"use strict";
const fs = require("fs");
const os = require("os");
const path = require("path");
const runtime_info_1 = require("../lib/private/runtime-info");
module.exports = {
    'version reporting includes @aws-solutions-konstruk libraries'(test) {
        const pkgdir = fs.mkdtempSync(path.join(os.tmpdir(), 'runtime-info-konstruk-fixture'));
        const mockVersion = '1.2.3';
        fs.writeFileSync(path.join(pkgdir, 'index.js'), 'module.exports = \'this is foo\';');
        fs.writeFileSync(path.join(pkgdir, 'package.json'), JSON.stringify({
            name: '@aws-solutions-konstruk/foo',
            version: mockVersion,
        }));
        // eslint-disable-next-line @typescript-eslint/no-require-imports, import/no-extraneous-dependencies
        require(pkgdir);
        const runtimeInfo = runtime_info_1.collectRuntimeInformation();
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        const version = require('../package.json').version;
        test.deepEqual(runtimeInfo.libraries, {
            '@aws-cdk/core': version,
            '@aws-cdk/cx-api': version,
            '@aws-cdk/cloud-assembly-schema': version,
            '@aws-solutions-konstruk/foo': mockVersion,
            'jsii-runtime': `node.js/${process.version}`,
        });
        test.done();
    },
    'version reporting finds no version with no associated package.json'(test) {
        const pkgdir = fs.mkdtempSync(path.join(os.tmpdir(), 'runtime-info-find-npm-package-fixture'));
        const mockVersion = '1.2.3';
        fs.writeFileSync(path.join(pkgdir, 'index.js'), 'module.exports = \'this is bar\';');
        fs.mkdirSync(path.join(pkgdir, 'bar'));
        fs.writeFileSync(path.join(pkgdir, 'bar', 'package.json'), JSON.stringify({
            name: '@aws-solutions-konstruk/bar',
            version: mockVersion,
        }));
        // eslint-disable-next-line @typescript-eslint/no-require-imports, import/no-extraneous-dependencies
        require(pkgdir);
        const cwd = process.cwd();
        // Switch to `bar` where the package.json is, then resolve version.  Fails when module.resolve
        // is passed an empty string in the paths array.
        process.chdir(path.join(pkgdir, 'bar'));
        const runtimeInfo = runtime_info_1.collectRuntimeInformation();
        process.chdir(cwd);
        test.equal(runtimeInfo.libraries['@aws-solutions-konstruk/bar'], undefined);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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