"""
Type annotations for cognito-idp service literal definitions.

[Open documentation](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cognito_idp/literals.html)

Usage::

    ```python
    from mypy_boto3_cognito_idp.literals import AccountTakeoverEventActionTypeType

    data: AccountTakeoverEventActionTypeType = "BLOCK"
    ```
"""
import sys

if sys.version_info >= (3, 9):
    from typing import Literal
else:
    from typing_extensions import Literal


__all__ = (
    "AccountTakeoverEventActionTypeType",
    "AdminListGroupsForUserPaginatorName",
    "AdminListUserAuthEventsPaginatorName",
    "AdvancedSecurityModeTypeType",
    "AliasAttributeTypeType",
    "AttributeDataTypeType",
    "AuthFlowTypeType",
    "ChallengeNameType",
    "ChallengeNameTypeType",
    "ChallengeResponseType",
    "CompromisedCredentialsEventActionTypeType",
    "CustomEmailSenderLambdaVersionTypeType",
    "CustomSMSSenderLambdaVersionTypeType",
    "DefaultEmailOptionTypeType",
    "DeliveryMediumTypeType",
    "DeviceRememberedStatusTypeType",
    "DomainStatusTypeType",
    "EmailSendingAccountTypeType",
    "EventFilterTypeType",
    "EventResponseTypeType",
    "EventTypeType",
    "ExplicitAuthFlowsTypeType",
    "FeedbackValueTypeType",
    "IdentityProviderTypeTypeType",
    "ListGroupsPaginatorName",
    "ListIdentityProvidersPaginatorName",
    "ListResourceServersPaginatorName",
    "ListUserPoolClientsPaginatorName",
    "ListUserPoolsPaginatorName",
    "ListUsersInGroupPaginatorName",
    "ListUsersPaginatorName",
    "MessageActionTypeType",
    "OAuthFlowTypeType",
    "PreventUserExistenceErrorTypesType",
    "RecoveryOptionNameTypeType",
    "RiskDecisionTypeType",
    "RiskLevelTypeType",
    "StatusTypeType",
    "TimeUnitsTypeType",
    "UserImportJobStatusTypeType",
    "UserPoolMfaTypeType",
    "UserStatusTypeType",
    "UsernameAttributeTypeType",
    "VerifiedAttributeTypeType",
    "VerifySoftwareTokenResponseTypeType",
    "ServiceName",
    "PaginatorName",
)


AccountTakeoverEventActionTypeType = Literal[
    "BLOCK", "MFA_IF_CONFIGURED", "MFA_REQUIRED", "NO_ACTION"
]
AdminListGroupsForUserPaginatorName = Literal["admin_list_groups_for_user"]
AdminListUserAuthEventsPaginatorName = Literal["admin_list_user_auth_events"]
AdvancedSecurityModeTypeType = Literal["AUDIT", "ENFORCED", "OFF"]
AliasAttributeTypeType = Literal["email", "phone_number", "preferred_username"]
AttributeDataTypeType = Literal["Boolean", "DateTime", "Number", "String"]
AuthFlowTypeType = Literal[
    "ADMIN_NO_SRP_AUTH",
    "ADMIN_USER_PASSWORD_AUTH",
    "CUSTOM_AUTH",
    "REFRESH_TOKEN",
    "REFRESH_TOKEN_AUTH",
    "USER_PASSWORD_AUTH",
    "USER_SRP_AUTH",
]
ChallengeNameType = Literal["Mfa", "Password"]
ChallengeNameTypeType = Literal[
    "ADMIN_NO_SRP_AUTH",
    "CUSTOM_CHALLENGE",
    "DEVICE_PASSWORD_VERIFIER",
    "DEVICE_SRP_AUTH",
    "MFA_SETUP",
    "NEW_PASSWORD_REQUIRED",
    "PASSWORD_VERIFIER",
    "SELECT_MFA_TYPE",
    "SMS_MFA",
    "SOFTWARE_TOKEN_MFA",
]
ChallengeResponseType = Literal["Failure", "Success"]
CompromisedCredentialsEventActionTypeType = Literal["BLOCK", "NO_ACTION"]
CustomEmailSenderLambdaVersionTypeType = Literal["V1_0"]
CustomSMSSenderLambdaVersionTypeType = Literal["V1_0"]
DefaultEmailOptionTypeType = Literal["CONFIRM_WITH_CODE", "CONFIRM_WITH_LINK"]
DeliveryMediumTypeType = Literal["EMAIL", "SMS"]
DeviceRememberedStatusTypeType = Literal["not_remembered", "remembered"]
DomainStatusTypeType = Literal["ACTIVE", "CREATING", "DELETING", "FAILED", "UPDATING"]
EmailSendingAccountTypeType = Literal["COGNITO_DEFAULT", "DEVELOPER"]
EventFilterTypeType = Literal["PASSWORD_CHANGE", "SIGN_IN", "SIGN_UP"]
EventResponseTypeType = Literal["Failure", "Success"]
EventTypeType = Literal["ForgotPassword", "SignIn", "SignUp"]
ExplicitAuthFlowsTypeType = Literal[
    "ADMIN_NO_SRP_AUTH",
    "ALLOW_ADMIN_USER_PASSWORD_AUTH",
    "ALLOW_CUSTOM_AUTH",
    "ALLOW_REFRESH_TOKEN_AUTH",
    "ALLOW_USER_PASSWORD_AUTH",
    "ALLOW_USER_SRP_AUTH",
    "CUSTOM_AUTH_FLOW_ONLY",
    "USER_PASSWORD_AUTH",
]
FeedbackValueTypeType = Literal["Invalid", "Valid"]
IdentityProviderTypeTypeType = Literal[
    "Facebook", "Google", "LoginWithAmazon", "OIDC", "SAML", "SignInWithApple"
]
ListGroupsPaginatorName = Literal["list_groups"]
ListIdentityProvidersPaginatorName = Literal["list_identity_providers"]
ListResourceServersPaginatorName = Literal["list_resource_servers"]
ListUserPoolClientsPaginatorName = Literal["list_user_pool_clients"]
ListUserPoolsPaginatorName = Literal["list_user_pools"]
ListUsersInGroupPaginatorName = Literal["list_users_in_group"]
ListUsersPaginatorName = Literal["list_users"]
MessageActionTypeType = Literal["RESEND", "SUPPRESS"]
OAuthFlowTypeType = Literal["client_credentials", "code", "implicit"]
PreventUserExistenceErrorTypesType = Literal["ENABLED", "LEGACY"]
RecoveryOptionNameTypeType = Literal["admin_only", "verified_email", "verified_phone_number"]
RiskDecisionTypeType = Literal["AccountTakeover", "Block", "NoRisk"]
RiskLevelTypeType = Literal["High", "Low", "Medium"]
StatusTypeType = Literal["Disabled", "Enabled"]
TimeUnitsTypeType = Literal["days", "hours", "minutes", "seconds"]
UserImportJobStatusTypeType = Literal[
    "Created", "Expired", "Failed", "InProgress", "Pending", "Stopped", "Stopping", "Succeeded"
]
UserPoolMfaTypeType = Literal["OFF", "ON", "OPTIONAL"]
UserStatusTypeType = Literal[
    "ARCHIVED",
    "COMPROMISED",
    "CONFIRMED",
    "FORCE_CHANGE_PASSWORD",
    "RESET_REQUIRED",
    "UNCONFIRMED",
    "UNKNOWN",
]
UsernameAttributeTypeType = Literal["email", "phone_number"]
VerifiedAttributeTypeType = Literal["email", "phone_number"]
VerifySoftwareTokenResponseTypeType = Literal["ERROR", "SUCCESS"]
ServiceName = Literal[
    "accessanalyzer",
    "account",
    "acm",
    "acm-pca",
    "alexaforbusiness",
    "amp",
    "amplify",
    "amplifybackend",
    "apigateway",
    "apigatewaymanagementapi",
    "apigatewayv2",
    "appconfig",
    "appflow",
    "appintegrations",
    "application-autoscaling",
    "application-insights",
    "applicationcostprofiler",
    "appmesh",
    "apprunner",
    "appstream",
    "appsync",
    "athena",
    "auditmanager",
    "autoscaling",
    "autoscaling-plans",
    "backup",
    "batch",
    "braket",
    "budgets",
    "ce",
    "chime",
    "chime-sdk-identity",
    "chime-sdk-meetings",
    "chime-sdk-messaging",
    "cloud9",
    "cloudcontrol",
    "clouddirectory",
    "cloudformation",
    "cloudfront",
    "cloudhsm",
    "cloudhsmv2",
    "cloudsearch",
    "cloudsearchdomain",
    "cloudtrail",
    "cloudwatch",
    "codeartifact",
    "codebuild",
    "codecommit",
    "codedeploy",
    "codeguru-reviewer",
    "codeguruprofiler",
    "codepipeline",
    "codestar",
    "codestar-connections",
    "codestar-notifications",
    "cognito-identity",
    "cognito-idp",
    "cognito-sync",
    "comprehend",
    "comprehendmedical",
    "compute-optimizer",
    "config",
    "connect",
    "connect-contact-lens",
    "connectparticipant",
    "cur",
    "customer-profiles",
    "databrew",
    "dataexchange",
    "datapipeline",
    "datasync",
    "dax",
    "detective",
    "devicefarm",
    "devops-guru",
    "directconnect",
    "discovery",
    "dlm",
    "dms",
    "docdb",
    "ds",
    "dynamodb",
    "dynamodbstreams",
    "ebs",
    "ec2",
    "ec2-instance-connect",
    "ecr",
    "ecr-public",
    "ecs",
    "efs",
    "eks",
    "elastic-inference",
    "elasticache",
    "elasticbeanstalk",
    "elastictranscoder",
    "elb",
    "elbv2",
    "emr",
    "emr-containers",
    "es",
    "events",
    "finspace",
    "finspace-data",
    "firehose",
    "fis",
    "fms",
    "forecast",
    "forecastquery",
    "frauddetector",
    "fsx",
    "gamelift",
    "glacier",
    "globalaccelerator",
    "glue",
    "grafana",
    "greengrass",
    "greengrassv2",
    "groundstation",
    "guardduty",
    "health",
    "healthlake",
    "honeycode",
    "iam",
    "identitystore",
    "imagebuilder",
    "importexport",
    "inspector",
    "iot",
    "iot-data",
    "iot-jobs-data",
    "iot1click-devices",
    "iot1click-projects",
    "iotanalytics",
    "iotdeviceadvisor",
    "iotevents",
    "iotevents-data",
    "iotfleethub",
    "iotsecuretunneling",
    "iotsitewise",
    "iotthingsgraph",
    "iotwireless",
    "ivs",
    "kafka",
    "kafkaconnect",
    "kendra",
    "kinesis",
    "kinesis-video-archived-media",
    "kinesis-video-media",
    "kinesis-video-signaling",
    "kinesisanalytics",
    "kinesisanalyticsv2",
    "kinesisvideo",
    "kms",
    "lakeformation",
    "lambda",
    "lex-models",
    "lex-runtime",
    "lexv2-models",
    "lexv2-runtime",
    "license-manager",
    "lightsail",
    "location",
    "logs",
    "lookoutequipment",
    "lookoutmetrics",
    "lookoutvision",
    "machinelearning",
    "macie",
    "macie2",
    "managedblockchain",
    "marketplace-catalog",
    "marketplace-entitlement",
    "marketplacecommerceanalytics",
    "mediaconnect",
    "mediaconvert",
    "medialive",
    "mediapackage",
    "mediapackage-vod",
    "mediastore",
    "mediastore-data",
    "mediatailor",
    "memorydb",
    "meteringmarketplace",
    "mgh",
    "mgn",
    "migrationhub-config",
    "mobile",
    "mq",
    "mturk",
    "mwaa",
    "neptune",
    "network-firewall",
    "networkmanager",
    "nimble",
    "opensearch",
    "opsworks",
    "opsworkscm",
    "organizations",
    "outposts",
    "panorama",
    "personalize",
    "personalize-events",
    "personalize-runtime",
    "pi",
    "pinpoint",
    "pinpoint-email",
    "pinpoint-sms-voice",
    "polly",
    "pricing",
    "proton",
    "qldb",
    "qldb-session",
    "quicksight",
    "ram",
    "rds",
    "rds-data",
    "redshift",
    "redshift-data",
    "rekognition",
    "resource-groups",
    "resourcegroupstaggingapi",
    "robomaker",
    "route53",
    "route53-recovery-cluster",
    "route53-recovery-control-config",
    "route53-recovery-readiness",
    "route53domains",
    "route53resolver",
    "s3",
    "s3control",
    "s3outposts",
    "sagemaker",
    "sagemaker-a2i-runtime",
    "sagemaker-edge",
    "sagemaker-featurestore-runtime",
    "sagemaker-runtime",
    "savingsplans",
    "schemas",
    "sdb",
    "secretsmanager",
    "securityhub",
    "serverlessrepo",
    "service-quotas",
    "servicecatalog",
    "servicecatalog-appregistry",
    "servicediscovery",
    "ses",
    "sesv2",
    "shield",
    "signer",
    "sms",
    "sms-voice",
    "snow-device-management",
    "snowball",
    "sns",
    "sqs",
    "ssm",
    "ssm-contacts",
    "ssm-incidents",
    "sso",
    "sso-admin",
    "sso-oidc",
    "stepfunctions",
    "storagegateway",
    "sts",
    "support",
    "swf",
    "synthetics",
    "textract",
    "timestream-query",
    "timestream-write",
    "transcribe",
    "transfer",
    "translate",
    "voice-id",
    "waf",
    "waf-regional",
    "wafv2",
    "wellarchitected",
    "wisdom",
    "workdocs",
    "worklink",
    "workmail",
    "workmailmessageflow",
    "workspaces",
    "xray",
]
PaginatorName = Literal[
    "admin_list_groups_for_user",
    "admin_list_user_auth_events",
    "list_groups",
    "list_identity_providers",
    "list_resource_servers",
    "list_user_pool_clients",
    "list_user_pools",
    "list_users",
    "list_users_in_group",
]
