/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.MultiMapKt;
import datastructures.SparseLabelledGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0005BW\u0012(\u0010\u0006\u001a$\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000`\t\u0012\u001e\u0010\n\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000fJ\"\u0010\u0010\u001a\u00028\u00012\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u000bH\u0086\u0002\u00a2\u0006\u0002\u0010\u0012J$\u0010\u0013\u001a \u0012\u001c\u0012\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00028\u00010\u000b0\u0014J\u001b\u0010\u0015\u001a\u00028\u00012\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J#\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u00012\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ*\u0010\u001d\u001a\u00020\u001a2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u0010\u001e\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\u001fR\u0010\u0010\u0004\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR&\u0010\n\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0006\u001a$\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldatastructures/MutableSparseLabelledGraph;", "V", "E", "", "defaultLabel", "(Ljava/lang/Object;)V", "relation", "", "", "Ldatastructures/MutableMultiMap;", "labelMapping", "Lkotlin/Pair;", "(Ljava/util/Map;Ljava/util/Map;Ljava/lang/Object;)V", "Ljava/lang/Object;", "freeze", "Ldatastructures/SparseLabelledGraph;", "get", "pair", "(Lkotlin/Pair;)Ljava/lang/Object;", "getAllNonDefaultEdges", "", "getLabel", "src", "tgt", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "put", "", "lab", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "set", "label", "(Lkotlin/Pair;Ljava/lang/Object;)V", "GeneralUtils"})
@SourceDebugExtension(value={"SMAP\nGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Graph.kt\ndatastructures/MutableSparseLabelledGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n766#2:152\n857#2,2:153\n1549#2:155\n1620#2,3:156\n*S KotlinDebug\n*F\n+ 1 Graph.kt\ndatastructures/MutableSparseLabelledGraph\n*L\n104#1:152\n104#1:153,2\n105#1:155\n105#1:156,3\n*E\n"})
public final class MutableSparseLabelledGraph<V, E> {
    @NotNull
    private final Map<V, Set<V>> relation;
    @NotNull
    private final Map<Pair<V, V>, E> labelMapping;
    private final E defaultLabel;

    public MutableSparseLabelledGraph(@NotNull Map<V, Set<V>> relation, @NotNull Map<Pair<V, V>, E> labelMapping, E defaultLabel) {
        Intrinsics.checkNotNullParameter(relation, "relation");
        Intrinsics.checkNotNullParameter(labelMapping, "labelMapping");
        this.relation = relation;
        this.labelMapping = labelMapping;
        this.defaultLabel = defaultLabel;
    }

    public MutableSparseLabelledGraph(E defaultLabel) {
        this(MultiMapKt.mutableMultiMapOf(), new LinkedHashMap(), defaultLabel);
    }

    public final void put(V src, E lab, V tgt) {
        MultiMapKt.add(this.relation, src, tgt);
        this.labelMapping.put(TuplesKt.to(src, tgt), lab);
    }

    public final void set(@NotNull Pair<? extends V, ? extends V> pair2, E label) {
        Intrinsics.checkNotNullParameter(pair2, "pair");
        this.put(pair2.getFirst(), label, pair2.getSecond());
    }

    public final E get(@NotNull Pair<? extends V, ? extends V> pair2) {
        Intrinsics.checkNotNullParameter(pair2, "pair");
        return this.getLabel(pair2.getFirst(), pair2.getSecond());
    }

    public final E getLabel(V src, V tgt) {
        E e = this.labelMapping.get(TuplesKt.to(src, tgt));
        if (e == null) {
            e = this.defaultLabel;
        }
        return e;
    }

    @NotNull
    public final SparseLabelledGraph<V, E> freeze() {
        return new SparseLabelledGraph<V, E>(this.relation, this.labelMapping, this.defaultLabel);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Pair<Pair<V, V>, E>> getAllNonDefaultEdges() {
        void $this$mapTo$iv$iv;
        Object v2;
        Object v1;
        Pair pair2;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = MultiMapKt.getPairs(this.relation);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            pair2 = (Pair)element$iv$iv;
            boolean bl = false;
            v1 = pair2.component1();
            if (!(!Intrinsics.areEqual(this.labelMapping.get(TuplesKt.to(v1, v2 = pair2.component2())), this.defaultLabel))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            pair2 = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            v1 = pair2.component1();
            v2 = pair2.component2();
            Pair pair3 = TuplesKt.to(v1, v2);
            E e = this.labelMapping.get(TuplesKt.to(v1, v2));
            Intrinsics.checkNotNull(e);
            collection.add(TuplesKt.to(pair3, e));
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }
}

