# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from apimatic_core.authentication.header_auth import HeaderAuth
from apimatic_core.utilities.auth_helper import AuthHelper
from verizon5gmecvnspapi.controllers.o_auth_authorization_controller import\
    OAuthAuthorizationController


class OAuth2(HeaderAuth):

    @property
    def error_message(self):
        """Display error message on occurrence of authentication failure
        in ClientCredentialsAuth

        """
        return "ClientCredentialsAuth: o_auth_token.access_token is undefined or expired."

    def __init__(self, o_auth_client_id, o_auth_client_secret, o_auth_token, config, o_auth_scopes=None):
        auth_params = {}
        self._o_auth_client_id = o_auth_client_id
        self._o_auth_client_secret = o_auth_client_secret
        self._o_auth_token = o_auth_token
        self._o_auth_scopes = o_auth_scopes
        self._o_auth_api = OAuthAuthorizationController(config)
        if self._o_auth_token:
            auth_params["Authorization"] = "Bearer {}".format(self._o_auth_token.access_token)
        super().__init__(auth_params=auth_params)

    def is_valid(self):
        return self._o_auth_token and not self.token_expired(self._o_auth_token)

    def build_basic_auth_header(self):
        """ Builds the basic auth header for endpoints in the
            OAuth Authorization Controller.

        Returns:
            str: The value of the Authentication header.

        """
        return "Basic {}".format(AuthHelper.get_base64_encoded_value(self._o_auth_client_id, self._o_auth_client_secret))

    def fetch_token(self, additional_params=None):
        """ Authorizes the client.

            
            additional_params (dict):  Any additional form parameters.

        Returns:
            OAuthToken: The OAuth token.

        """
        token = self._o_auth_api.request_token(
            self.build_basic_auth_header(),
            ' '.join(self._o_auth_scopes) if (isinstance(self._o_auth_scopes, list)) else self._o_auth_scopes,
            additional_params
        )
        if hasattr(token, 'expires_in'):
            current_utc_timestamp = AuthHelper.get_current_utc_timestamp()
            token.expiry = AuthHelper.get_token_expiry(current_utc_timestamp, token.expires_in)
        return token

    @staticmethod
    def token_expired(token):
        """ Checks if OAuth token has expired.

        Returns:
            bool: True if token has expired, False otherwise.

        """
        return hasattr(token, 'expiry') and AuthHelper.is_token_expired(token.expiry)
