# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon5gmecvnspapi.api_helper import APIHelper
from verizon5gmecvnspapi.models.aws_csp_profile import AwsCspProfile
from verizon5gmecvnspapi.models.azure_csp_profile import AzureCspProfile
from verizon5gmecvnspapi.models.default_location import DefaultLocation


class CSPProfile(object):

    """Implementation of the 'CSPProfile' model.

    The user can create cloud credentials used for deploying workloads to the
    CSP environment.

    Attributes:
        id (string): System generated unique identifier to identify the CSP
            Profile uniquely.
        usage (long|int): Usage tells how many services are using the CSP
            Profile. Only CSP Profile with 0 usage count be allowed to
            delete.
        csp_profile_name (string): Name of the cloud credential to uniquely
            identify the CSP.
        customer_id (string): Unique identification of the organization
            creating the CSP Profile.
        project_name (string): Project name where service artifacts needs to
            be stored.
        mtype (CSPProfileTypeEnum): Type of CSP profile.
        aws_csp_profile (AwsCspProfile): Information related to manage
            resources in AWS infrastructure.
        azure_csp_profile (AzureCspProfile): Information related to manage
            resources in Azure infrastructure.
        default_location (DefaultLocation): Default location where service
            needs to be deployed.
        verification_time_stamp (datetime): Auto-derived Time of creation.
            Part of response only.
        state (string): State of the CSP profile.
        is_validated (bool): True if CSP is validated using provided
            credential, false otherwise.
        created_date (datetime): Auto-derived Time of creation. Part of
            response only.
        last_modified_date (datetime): Last modified time. Part of response
            only.
        created_by (string): User who created the dropDown. Part of response
            only.
        last_modified_by (string): User who last modified the dropDown. Part
            of response only.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "csp_profile_name": 'cspProfileName',
        "id": 'id',
        "usage": 'usage',
        "customer_id": 'customerID',
        "project_name": 'projectName',
        "mtype": 'type',
        "aws_csp_profile": 'awsCspProfile',
        "azure_csp_profile": 'azureCspProfile',
        "default_location": 'defaultLocation',
        "verification_time_stamp": 'verificationTimeStamp',
        "state": 'state',
        "is_validated": 'isValidated',
        "created_date": 'createdDate',
        "last_modified_date": 'lastModifiedDate',
        "created_by": 'createdBy',
        "last_modified_by": 'lastModifiedBy'
    }

    _optionals = [
        'id',
        'usage',
        'customer_id',
        'project_name',
        'mtype',
        'aws_csp_profile',
        'azure_csp_profile',
        'default_location',
        'verification_time_stamp',
        'state',
        'is_validated',
        'created_date',
        'last_modified_date',
        'created_by',
        'last_modified_by',
    ]

    def __init__(self,
                 csp_profile_name=None,
                 id=APIHelper.SKIP,
                 usage=APIHelper.SKIP,
                 customer_id=APIHelper.SKIP,
                 project_name=APIHelper.SKIP,
                 mtype=APIHelper.SKIP,
                 aws_csp_profile=APIHelper.SKIP,
                 azure_csp_profile=APIHelper.SKIP,
                 default_location=APIHelper.SKIP,
                 verification_time_stamp=APIHelper.SKIP,
                 state=APIHelper.SKIP,
                 is_validated=False,
                 created_date=APIHelper.SKIP,
                 last_modified_date=APIHelper.SKIP,
                 created_by=APIHelper.SKIP,
                 last_modified_by=APIHelper.SKIP):
        """Constructor for the CSPProfile class"""

        # Initialize members of the class
        if id is not APIHelper.SKIP:
            self.id = id 
        if usage is not APIHelper.SKIP:
            self.usage = usage 
        self.csp_profile_name = csp_profile_name 
        if customer_id is not APIHelper.SKIP:
            self.customer_id = customer_id 
        if project_name is not APIHelper.SKIP:
            self.project_name = project_name 
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if aws_csp_profile is not APIHelper.SKIP:
            self.aws_csp_profile = aws_csp_profile 
        if azure_csp_profile is not APIHelper.SKIP:
            self.azure_csp_profile = azure_csp_profile 
        if default_location is not APIHelper.SKIP:
            self.default_location = default_location 
        if verification_time_stamp is not APIHelper.SKIP:
            self.verification_time_stamp = APIHelper.RFC3339DateTime(verification_time_stamp) if verification_time_stamp else None 
        if state is not APIHelper.SKIP:
            self.state = state 
        self.is_validated = is_validated 
        if created_date is not APIHelper.SKIP:
            self.created_date = APIHelper.RFC3339DateTime(created_date) if created_date else None 
        if last_modified_date is not APIHelper.SKIP:
            self.last_modified_date = APIHelper.RFC3339DateTime(last_modified_date) if last_modified_date else None 
        if created_by is not APIHelper.SKIP:
            self.created_by = created_by 
        if last_modified_by is not APIHelper.SKIP:
            self.last_modified_by = last_modified_by 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        csp_profile_name = dictionary.get("cspProfileName") if dictionary.get("cspProfileName") else None
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        usage = dictionary.get("usage") if dictionary.get("usage") else APIHelper.SKIP
        customer_id = dictionary.get("customerID") if dictionary.get("customerID") else APIHelper.SKIP
        project_name = dictionary.get("projectName") if dictionary.get("projectName") else APIHelper.SKIP
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        aws_csp_profile = AwsCspProfile.from_dictionary(dictionary.get('awsCspProfile')) if 'awsCspProfile' in dictionary.keys() else APIHelper.SKIP
        azure_csp_profile = AzureCspProfile.from_dictionary(dictionary.get('azureCspProfile')) if 'azureCspProfile' in dictionary.keys() else APIHelper.SKIP
        default_location = DefaultLocation.from_dictionary(dictionary.get('defaultLocation')) if 'defaultLocation' in dictionary.keys() else APIHelper.SKIP
        verification_time_stamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("verificationTimeStamp")).datetime if dictionary.get("verificationTimeStamp") else APIHelper.SKIP
        state = dictionary.get("state") if dictionary.get("state") else APIHelper.SKIP
        is_validated = dictionary.get("isValidated") if dictionary.get("isValidated") else False
        created_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("createdDate")).datetime if dictionary.get("createdDate") else APIHelper.SKIP
        last_modified_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("lastModifiedDate")).datetime if dictionary.get("lastModifiedDate") else APIHelper.SKIP
        created_by = dictionary.get("createdBy") if dictionary.get("createdBy") else APIHelper.SKIP
        last_modified_by = dictionary.get("lastModifiedBy") if dictionary.get("lastModifiedBy") else APIHelper.SKIP
        # Return an object of this model
        return cls(csp_profile_name,
                   id,
                   usage,
                   customer_id,
                   project_name,
                   mtype,
                   aws_csp_profile,
                   azure_csp_profile,
                   default_location,
                   verification_time_stamp,
                   state,
                   is_validated,
                   created_date,
                   last_modified_date,
                   created_by,
                   last_modified_by)
