# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon5gmecvnspapi.api_helper import APIHelper
from verizon5gmecvnspapi.models.boundary import Boundary
from verizon5gmecvnspapi.models.compatibility import Compatibility
from verizon5gmecvnspapi.models.edge_service_onboarding_result import EdgeServiceOnboardingResult
from verizon5gmecvnspapi.models.observability_template import ObservabilityTemplate
from verizon5gmecvnspapi.models.service_dependency import ServiceDependency
from verizon5gmecvnspapi.models.service_error import ServiceError
from verizon5gmecvnspapi.models.service_handler_id import ServiceHandlerId
from verizon5gmecvnspapi.models.service_onboarding_additional_params import ServiceOnboardingAdditionalParams
from verizon5gmecvnspapi.models.service_resource import ServiceResource
from verizon5gmecvnspapi.models.service_swagger_spec_id import ServiceSwaggerSpecId
from verizon5gmecvnspapi.models.service_tag import ServiceTag
from verizon5gmecvnspapi.models.workflow import Workflow
from verizon5gmecvnspapi.models.workload import Workload


class Service(object):

    """Implementation of the 'Service' model.

    A customer service on 5G MEC platform using 5G MEC portal.

    Attributes:
        id (string): System generated unique UUID.
        name (string): Name of the service needs to be deployed.
        description (string): Description of the service needs to be
            deployed.
        version (string): Version of the service needs to be deployed.
        metadata (list of ServiceOnboardingAdditionalParams): Properties are
            metadata attributes.
        tags (list of ServiceTag): List of service tags.
        categories (list of string): Can be any name just to define it under a
            category.
        is_favourite (bool): Boolean value to set/unset the service as
            favorite.
        is_deleted (bool): Boolean to support soft delete of a version of a
            service.
        compatibility (list of Compatibility): Compatibility would have the
            attribute CSP which is Cloud service provider e.g.
            AWS_PUBLIC_CLOUD, AWS_WL, AWS_OUTPOST, AZURE_EDGE,
            AZURE_PUBLIC_CLOUD.
        resource (ServiceResource): Resource of the service.
        created_date (datetime): Auto-derived time of creation. Part of
            response only.
        last_modified_date (datetime): Last modified time. Part of response
            only.
        created_by (string): User who created the service. Part of response
            only.
        last_modified_by (string): User who last modified the service. Part of
            response only.
        error (ServiceError): Errors related to service.
        error_response (EdgeServiceOnboardingResult): Error response attribute
            of a service.
        state (ServiceStateEnum): Can have any value as - DRAFT, DESIGN,
            TESTING, PUBLISH, CERTIFY, READY_TO_USE, DEPRECATE, DELETED.
        status (ServiceStatusEnum): Can have any value as - DRAFT_INPROGRESS,
            DRAFT_COMPLETE, DESIGN_INPROGRESS, DESIGN_FAILED,
            DESIGN_COMPLETED, VALIDATION_INPROGRESS,  VALIDATION_FAILED,
            VALIDATION_COMPLETED, TESTING_INPROGRESS, TESTING_FAILED,
            TESTING_COMPLETED, READY_TO_USE_INPROGRESS, READY_TO_USE_FAILED,
            READY_TO_USE_COMPLETED, READY_TO_PRIVATE_USE_INPROGRESS,
            READY_TO_PRIVATE_USE_FAILED, READY_TO_PRIVATE_USE_COMPLETED, 
            PUBLISH_INPROGRESS,  PUBLISH_FAILED,  PUBLISH_COMPLETED, 
            CERTIFY_INPROGRESS,  CERTIFY_FAILED, CERTIFY_COMPLETED,
            DEPRECATE_INPROGRESS,  DEPRECATE_FAILED, DEPRECATE_COMPLETED,
            MARKDELETE_INPROGRESS, MARKDELETE_FAILED, MARKDELETE_COMPLETED.
        mtype (ServiceTypeEnum): Service Type e.g. Installation, Operations,
            Custom.
        service_handler_id (ServiceHandlerId): Auto-generated Id of
            serviceHandlerId created.
        observability_template (ObservabilityTemplate): Attribute of service.
        service_swagger_spec_id (ServiceSwaggerSpecId): Auto-generated Id of
            service handler Swagger specification file uploaded.
        workflows (list of Workflow): TODO: type description here.
        workloads (list of Workload): TODO: type description here.
        dependencies (list of ServiceDependency): Dependencies of the
            service.
        boundaries (list of Boundary): Boundaries would have attributes csp,
            region and zoneId.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "version": 'version',
        "id": 'id',
        "description": 'description',
        "metadata": 'metadata',
        "tags": 'tags',
        "categories": 'categories',
        "is_favourite": 'isFavourite',
        "is_deleted": 'isDeleted',
        "compatibility": 'compatibility',
        "resource": 'resource',
        "created_date": 'createdDate',
        "last_modified_date": 'lastModifiedDate',
        "created_by": 'createdBy',
        "last_modified_by": 'lastModifiedBy',
        "error": 'error',
        "error_response": 'errorResponse',
        "state": 'state',
        "status": 'status',
        "mtype": 'type',
        "service_handler_id": 'serviceHandlerId',
        "observability_template": 'observabilityTemplate',
        "service_swagger_spec_id": 'serviceSwaggerSpecId',
        "workflows": 'workflows',
        "workloads": 'workloads',
        "dependencies": 'dependencies',
        "boundaries": 'boundaries'
    }

    _optionals = [
        'id',
        'description',
        'metadata',
        'tags',
        'categories',
        'is_favourite',
        'is_deleted',
        'compatibility',
        'resource',
        'created_date',
        'last_modified_date',
        'created_by',
        'last_modified_by',
        'error',
        'error_response',
        'state',
        'status',
        'mtype',
        'service_handler_id',
        'observability_template',
        'service_swagger_spec_id',
        'workflows',
        'workloads',
        'dependencies',
        'boundaries',
    ]

    _nullables = [
        'description',
        'categories',
        'boundaries',
    ]

    def __init__(self,
                 name=None,
                 version=None,
                 id=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 metadata=APIHelper.SKIP,
                 tags=APIHelper.SKIP,
                 categories=APIHelper.SKIP,
                 is_favourite=APIHelper.SKIP,
                 is_deleted=APIHelper.SKIP,
                 compatibility=APIHelper.SKIP,
                 resource=APIHelper.SKIP,
                 created_date=APIHelper.SKIP,
                 last_modified_date=APIHelper.SKIP,
                 created_by=APIHelper.SKIP,
                 last_modified_by=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 error_response=APIHelper.SKIP,
                 state=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 mtype=APIHelper.SKIP,
                 service_handler_id=APIHelper.SKIP,
                 observability_template=APIHelper.SKIP,
                 service_swagger_spec_id=APIHelper.SKIP,
                 workflows=APIHelper.SKIP,
                 workloads=APIHelper.SKIP,
                 dependencies=APIHelper.SKIP,
                 boundaries=APIHelper.SKIP):
        """Constructor for the Service class"""

        # Initialize members of the class
        if id is not APIHelper.SKIP:
            self.id = id 
        self.name = name 
        if description is not APIHelper.SKIP:
            self.description = description 
        self.version = version 
        if metadata is not APIHelper.SKIP:
            self.metadata = metadata 
        if tags is not APIHelper.SKIP:
            self.tags = tags 
        if categories is not APIHelper.SKIP:
            self.categories = categories 
        if is_favourite is not APIHelper.SKIP:
            self.is_favourite = is_favourite 
        if is_deleted is not APIHelper.SKIP:
            self.is_deleted = is_deleted 
        if compatibility is not APIHelper.SKIP:
            self.compatibility = compatibility 
        if resource is not APIHelper.SKIP:
            self.resource = resource 
        if created_date is not APIHelper.SKIP:
            self.created_date = APIHelper.RFC3339DateTime(created_date) if created_date else None 
        if last_modified_date is not APIHelper.SKIP:
            self.last_modified_date = APIHelper.RFC3339DateTime(last_modified_date) if last_modified_date else None 
        if created_by is not APIHelper.SKIP:
            self.created_by = created_by 
        if last_modified_by is not APIHelper.SKIP:
            self.last_modified_by = last_modified_by 
        if error is not APIHelper.SKIP:
            self.error = error 
        if error_response is not APIHelper.SKIP:
            self.error_response = error_response 
        if state is not APIHelper.SKIP:
            self.state = state 
        if status is not APIHelper.SKIP:
            self.status = status 
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if service_handler_id is not APIHelper.SKIP:
            self.service_handler_id = service_handler_id 
        if observability_template is not APIHelper.SKIP:
            self.observability_template = observability_template 
        if service_swagger_spec_id is not APIHelper.SKIP:
            self.service_swagger_spec_id = service_swagger_spec_id 
        if workflows is not APIHelper.SKIP:
            self.workflows = workflows 
        if workloads is not APIHelper.SKIP:
            self.workloads = workloads 
        if dependencies is not APIHelper.SKIP:
            self.dependencies = dependencies 
        if boundaries is not APIHelper.SKIP:
            self.boundaries = boundaries 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        name = dictionary.get("name") if dictionary.get("name") else None
        version = dictionary.get("version") if dictionary.get("version") else None
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        description = dictionary.get("description") if "description" in dictionary.keys() else APIHelper.SKIP
        metadata = None
        if dictionary.get('metadata') is not None:
            metadata = [ServiceOnboardingAdditionalParams.from_dictionary(x) for x in dictionary.get('metadata')]
        else:
            metadata = APIHelper.SKIP
        tags = None
        if dictionary.get('tags') is not None:
            tags = [ServiceTag.from_dictionary(x) for x in dictionary.get('tags')]
        else:
            tags = APIHelper.SKIP
        categories = dictionary.get("categories") if "categories" in dictionary.keys() else APIHelper.SKIP
        is_favourite = dictionary.get("isFavourite") if "isFavourite" in dictionary.keys() else APIHelper.SKIP
        is_deleted = dictionary.get("isDeleted") if "isDeleted" in dictionary.keys() else APIHelper.SKIP
        compatibility = None
        if dictionary.get('compatibility') is not None:
            compatibility = [Compatibility.from_dictionary(x) for x in dictionary.get('compatibility')]
        else:
            compatibility = APIHelper.SKIP
        resource = ServiceResource.from_dictionary(dictionary.get('resource')) if 'resource' in dictionary.keys() else APIHelper.SKIP
        created_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("createdDate")).datetime if dictionary.get("createdDate") else APIHelper.SKIP
        last_modified_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("lastModifiedDate")).datetime if dictionary.get("lastModifiedDate") else APIHelper.SKIP
        created_by = dictionary.get("createdBy") if dictionary.get("createdBy") else APIHelper.SKIP
        last_modified_by = dictionary.get("lastModifiedBy") if dictionary.get("lastModifiedBy") else APIHelper.SKIP
        error = ServiceError.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        error_response = EdgeServiceOnboardingResult.from_dictionary(dictionary.get('errorResponse')) if 'errorResponse' in dictionary.keys() else APIHelper.SKIP
        state = dictionary.get("state") if dictionary.get("state") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        service_handler_id = ServiceHandlerId.from_dictionary(dictionary.get('serviceHandlerId')) if 'serviceHandlerId' in dictionary.keys() else APIHelper.SKIP
        observability_template = ObservabilityTemplate.from_dictionary(dictionary.get('observabilityTemplate')) if 'observabilityTemplate' in dictionary.keys() else APIHelper.SKIP
        service_swagger_spec_id = ServiceSwaggerSpecId.from_dictionary(dictionary.get('serviceSwaggerSpecId')) if 'serviceSwaggerSpecId' in dictionary.keys() else APIHelper.SKIP
        workflows = None
        if dictionary.get('workflows') is not None:
            workflows = [Workflow.from_dictionary(x) for x in dictionary.get('workflows')]
        else:
            workflows = APIHelper.SKIP
        workloads = None
        if dictionary.get('workloads') is not None:
            workloads = [Workload.from_dictionary(x) for x in dictionary.get('workloads')]
        else:
            workloads = APIHelper.SKIP
        dependencies = None
        if dictionary.get('dependencies') is not None:
            dependencies = [ServiceDependency.from_dictionary(x) for x in dictionary.get('dependencies')]
        else:
            dependencies = APIHelper.SKIP
        if 'boundaries' in dictionary.keys():
            boundaries = [Boundary.from_dictionary(x) for x in dictionary.get('boundaries')] if dictionary.get('boundaries') else None
        else:
            boundaries = APIHelper.SKIP
        # Return an object of this model
        return cls(name,
                   version,
                   id,
                   description,
                   metadata,
                   tags,
                   categories,
                   is_favourite,
                   is_deleted,
                   compatibility,
                   resource,
                   created_date,
                   last_modified_date,
                   created_by,
                   last_modified_by,
                   error,
                   error_response,
                   state,
                   status,
                   mtype,
                   service_handler_id,
                   observability_template,
                   service_swagger_spec_id,
                   workflows,
                   workloads,
                   dependencies,
                   boundaries)
