# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon5gmecvnspapi.api_helper import APIHelper
from verizon5gmecvnspapi.models.dependent_service import DependentService
from verizon5gmecvnspapi.models.edge_service_onboarding_result import EdgeServiceOnboardingResult
from verizon5gmecvnspapi.models.running_instance import RunningInstance
from verizon5gmecvnspapi.models.selected_service import SelectedService


class ServiceDeleteResult(object):

    """Implementation of the 'ServiceDeleteResult' model.

    Response to delete a service.

    Attributes:
        selected_service (SelectedService): Service which is selected.
        dependent_service (list of DependentService): List of dependent
            services.
        running_instances (list of RunningInstance): List of running
            Instance.
        error_details (EdgeServiceOnboardingResult): Error response attribute
            of a service.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "selected_service": 'selectedService',
        "dependent_service": 'dependentService',
        "running_instances": 'runningInstances',
        "error_details": 'errorDetails'
    }

    _optionals = [
        'selected_service',
        'dependent_service',
        'running_instances',
        'error_details',
    ]

    def __init__(self,
                 selected_service=APIHelper.SKIP,
                 dependent_service=APIHelper.SKIP,
                 running_instances=APIHelper.SKIP,
                 error_details=APIHelper.SKIP):
        """Constructor for the ServiceDeleteResult class"""

        # Initialize members of the class
        if selected_service is not APIHelper.SKIP:
            self.selected_service = selected_service 
        if dependent_service is not APIHelper.SKIP:
            self.dependent_service = dependent_service 
        if running_instances is not APIHelper.SKIP:
            self.running_instances = running_instances 
        if error_details is not APIHelper.SKIP:
            self.error_details = error_details 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        selected_service = SelectedService.from_dictionary(dictionary.get('selectedService')) if 'selectedService' in dictionary.keys() else APIHelper.SKIP
        dependent_service = None
        if dictionary.get('dependentService') is not None:
            dependent_service = [DependentService.from_dictionary(x) for x in dictionary.get('dependentService')]
        else:
            dependent_service = APIHelper.SKIP
        running_instances = None
        if dictionary.get('runningInstances') is not None:
            running_instances = [RunningInstance.from_dictionary(x) for x in dictionary.get('runningInstances')]
        else:
            running_instances = APIHelper.SKIP
        error_details = EdgeServiceOnboardingResult.from_dictionary(dictionary.get('errorDetails')) if 'errorDetails' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(selected_service,
                   dependent_service,
                   running_instances,
                   error_details)
