from distutils.core import setup, Extension

pgpmsg_version = "1.1"

setup(name = "pgpmsg",
      version = pgpmsg_version,
      author = "Jens B. Jorgensen",
      author_email = "jbj1@ultraemail.net",
      maintainer = "Jens B. Jorgensen",
      maintainer_email = "jbj1@ultraemail.net",
      license = "GPL",
      platforms = ["OS Independent"],
      keywords = ["pgp", "gpg", "rfc2440", "crypto", "cryptography"],
      url = "http://www.pitroda.net:8000/~jbj1/#pgpmsg",
      download_url = "http://www.pitroda.net:8000/~jbj1/pgpmsg-%s.zip" % pgpmsg_version,
      description = "OpenPGP (RFC2440) message parser",
      long_description = """This is a fairly simply module which will decode OpenPGP messages (RFC 2440). Such messages are generated by Gnu Privacy Guard and PGP. I haven't made any effort to do much cryptographic operations because in my case my purpose for creating the module was to write an OpenLDAP backend that supported the kind of LDAP access present in PGP. The one crypto thing it does do is calculate the fingerprint/key_id for a public key. So, basically this module will let you read in a message (which could be encrypted text or a pgp key) and will let you iterate over the object and inspect its parts.""",
      classifiers = [
            'Development Status :: 4 - Beta',
            'Intended Audience :: Developers',
            'License :: OSI Approved :: GNU General Public License (GPL)',
            'Natural Language :: English',
            'Operating System :: OS Independent',
            'Programming Language :: Python',
            'Topic :: Security :: Cryptography',
            'Topic :: Software Development :: Libraries'
            ],
      py_modules = [ 'pgpmsg' ])
