# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import Optional
from typing_extensions import Literal

from ...._models import BaseModel
from .top_up_invoice_settings import TopUpInvoiceSettings

__all__ = ["TopUpCreateByExternalIDResponse"]


class TopUpCreateByExternalIDResponse(BaseModel):
    id: str

    amount: str
    """The amount to increment when the threshold is reached."""

    currency: str
    """The currency or custom pricing unit to use for this top-up.

    If this is a real-world currency, it must match the customer's invoicing
    currency.
    """

    invoice_settings: TopUpInvoiceSettings
    """Settings for invoices generated by triggered top-ups."""

    per_unit_cost_basis: str
    """How much, in the customer's currency, to charge for each unit."""

    threshold: str
    """The threshold at which to trigger the top-up.

    If the balance is at or below this threshold, the top-up will be triggered.
    """

    expires_after: Optional[int] = None
    """The number of days or months after which the top-up expires.

    If unspecified, it does not expire.
    """

    expires_after_unit: Optional[Literal["day", "month"]] = None
    """The unit of expires_after."""
