# coding: utf-8

"""
    GraphScope FLEX HTTP SERVICE API

    This is a specification for GraphScope FLEX HTTP service based on the OpenAPI 3.0 specification. You can find out more details about specification at [doc](https://swagger.io/specification/v3/).

    The version of the OpenAPI document: 1.0.0
    Contact: graphscope@alibaba-inc.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from graphscope.flex.rest.models.resource_usage import ResourceUsage
from typing import Optional, Set
from typing_extensions import Self

class GetResourceUsageResponse(BaseModel):
    """
    GetResourceUsageResponse
    """ # noqa: E501
    cpu_usage: List[ResourceUsage]
    memory_usage: List[ResourceUsage]
    __properties: ClassVar[List[str]] = ["cpu_usage", "memory_usage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetResourceUsageResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cpu_usage (list)
        _items = []
        if self.cpu_usage:
            for _item_cpu_usage in self.cpu_usage:
                if _item_cpu_usage:
                    _items.append(_item_cpu_usage.to_dict())
            _dict['cpu_usage'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in memory_usage (list)
        _items = []
        if self.memory_usage:
            for _item_memory_usage in self.memory_usage:
                if _item_memory_usage:
                    _items.append(_item_memory_usage.to_dict())
            _dict['memory_usage'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetResourceUsageResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cpu_usage": [ResourceUsage.from_dict(_item) for _item in obj["cpu_usage"]] if obj.get("cpu_usage") is not None else None,
            "memory_usage": [ResourceUsage.from_dict(_item) for _item in obj["memory_usage"]] if obj.get("memory_usage") is not None else None
        })
        return _obj


