# coding: utf-8

"""
    GraphScope FLEX HTTP SERVICE API

    This is a specification for GraphScope FLEX HTTP service based on the OpenAPI 3.0 specification. You can find out more details about specification at [doc](https://swagger.io/specification/v3/).

    The version of the OpenAPI document: 1.0.0
    Contact: graphscope@alibaba-inc.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from graphscope.flex.rest.models.primitive_type import PrimitiveType
from graphscope.flex.rest.models.string_type import StringType
from graphscope.flex.rest.models.temporal_type import TemporalType
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

GSDATATYPE_ONE_OF_SCHEMAS = ["PrimitiveType", "StringType", "TemporalType"]

class GSDataType(BaseModel):
    """
    GSDataType
    """
    # data type: PrimitiveType
    oneof_schema_1_validator: Optional[PrimitiveType] = None
    # data type: StringType
    oneof_schema_2_validator: Optional[StringType] = None
    # data type: TemporalType
    oneof_schema_3_validator: Optional[TemporalType] = None
    actual_instance: Optional[Union[PrimitiveType, StringType, TemporalType]] = None
    one_of_schemas: Set[str] = { "PrimitiveType", "StringType", "TemporalType" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = GSDataType.model_construct()
        error_messages = []
        match = 0
        # validate data type: PrimitiveType
        if not isinstance(v, PrimitiveType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PrimitiveType`")
        else:
            match += 1
        # validate data type: StringType
        if not isinstance(v, StringType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `StringType`")
        else:
            match += 1
        # validate data type: TemporalType
        if not isinstance(v, TemporalType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TemporalType`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in GSDataType with oneOf schemas: PrimitiveType, StringType, TemporalType. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in GSDataType with oneOf schemas: PrimitiveType, StringType, TemporalType. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into PrimitiveType
        try:
            instance.actual_instance = PrimitiveType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into StringType
        try:
            instance.actual_instance = StringType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TemporalType
        try:
            instance.actual_instance = TemporalType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into GSDataType with oneOf schemas: PrimitiveType, StringType, TemporalType. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into GSDataType with oneOf schemas: PrimitiveType, StringType, TemporalType. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], PrimitiveType, StringType, TemporalType]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


