
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import extend_opview_class as _ods_extend_opview_class, segmented_accessor as _ods_segmented_accessor, equally_sized_accessor as _ods_equally_sized_accessor, get_default_loc_context as _ods_get_default_loc_context, get_op_result_or_value as _get_op_result_or_value, get_op_results_or_values as _get_op_results_or_values
_ods_ir = _ods_cext.ir

try:
  from . import _stablehlo_ops_ext as _ods_ext_module
except ImportError:
  _ods_ext_module = None

import builtins


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "stablehlo"
  pass


@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class AbsOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.abs"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(AbsOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class AddOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.add"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(AddOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class AfterAllOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.after_all"

  _ODS_REGIONS = (0, True)

  def __init__(self, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(AfterAllOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class AllGatherOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.all_gather"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, all_gather_dim, replica_groups, *, channel_handle=None, use_global_device_ids=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["all_gather_dim"] = (all_gather_dim if (
    issubclass(type(all_gather_dim), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(all_gather_dim, context=_ods_context))
    attributes["replica_groups"] = (replica_groups if (
    issubclass(type(replica_groups), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(replica_groups, context=_ods_context))
    if channel_handle is not None: attributes["channel_handle"] = (channel_handle if (
        issubclass(type(channel_handle), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_ChannelHandle')) else
          _ods_ir.AttrBuilder.get('StableHLO_ChannelHandle')(channel_handle, context=_ods_context))
    if bool(use_global_device_ids): attributes["use_global_device_ids"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def all_gather_dim(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["all_gather_dim"])

  @all_gather_dim.setter
  def all_gather_dim(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["all_gather_dim"] = value

  @builtins.property
  def replica_groups(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["replica_groups"])

  @replica_groups.setter
  def replica_groups(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["replica_groups"] = value

  @builtins.property
  def use_global_device_ids(self):
    return "use_global_device_ids" in self.operation.attributes

  @use_global_device_ids.setter
  def use_global_device_ids(self, value):
    if bool(value):
      self.operation.attributes["use_global_device_ids"] = _ods_ir.UnitAttr.get()
    elif "use_global_device_ids" in self.operation.attributes:
      del self.operation.attributes["use_global_device_ids"]

  @use_global_device_ids.deleter
  def use_global_device_ids(self):
    del self.operation.attributes["use_global_device_ids"]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class AllReduceOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.all_reduce"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, operand, replica_groups, *, channel_handle=None, use_global_device_ids=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["replica_groups"] = (replica_groups if (
    issubclass(type(replica_groups), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(replica_groups, context=_ods_context))
    if channel_handle is not None: attributes["channel_handle"] = (channel_handle if (
        issubclass(type(channel_handle), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_ChannelHandle')) else
          _ods_ir.AttrBuilder.get('StableHLO_ChannelHandle')(channel_handle, context=_ods_context))
    if bool(use_global_device_ids): attributes["use_global_device_ids"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def replica_groups(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["replica_groups"])

  @replica_groups.setter
  def replica_groups(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["replica_groups"] = value

  @builtins.property
  def use_global_device_ids(self):
    return "use_global_device_ids" in self.operation.attributes

  @use_global_device_ids.setter
  def use_global_device_ids(self, value):
    if bool(value):
      self.operation.attributes["use_global_device_ids"] = _ods_ir.UnitAttr.get()
    elif "use_global_device_ids" in self.operation.attributes:
      del self.operation.attributes["use_global_device_ids"]

  @use_global_device_ids.deleter
  def use_global_device_ids(self):
    del self.operation.attributes["use_global_device_ids"]

  @builtins.property
  def computation(self):
    return self.regions[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class AllToAllOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.all_to_all"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, split_dimension, concat_dimension, split_count, replica_groups, *, channel_handle=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["split_dimension"] = (split_dimension if (
    issubclass(type(split_dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(split_dimension, context=_ods_context))
    attributes["concat_dimension"] = (concat_dimension if (
    issubclass(type(concat_dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(concat_dimension, context=_ods_context))
    attributes["split_count"] = (split_count if (
    issubclass(type(split_count), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(split_count, context=_ods_context))
    attributes["replica_groups"] = (replica_groups if (
    issubclass(type(replica_groups), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(replica_groups, context=_ods_context))
    if channel_handle is not None: attributes["channel_handle"] = (channel_handle if (
        issubclass(type(channel_handle), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_ChannelHandle')) else
          _ods_ir.AttrBuilder.get('StableHLO_ChannelHandle')(channel_handle, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(AllToAllOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def split_dimension(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["split_dimension"])

  @split_dimension.setter
  def split_dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["split_dimension"] = value

  @builtins.property
  def concat_dimension(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["concat_dimension"])

  @concat_dimension.setter
  def concat_dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["concat_dimension"] = value

  @builtins.property
  def split_count(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["split_count"])

  @split_count.setter
  def split_count(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["split_count"] = value

  @builtins.property
  def replica_groups(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["replica_groups"])

  @replica_groups.setter
  def replica_groups(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["replica_groups"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class AndOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.and"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(AndOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class Atan2Op(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.atan2"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(Atan2Op).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class BatchNormGradOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.batch_norm_grad"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, scale, mean, variance, grad_output, epsilon, feature_index, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(scale))
    operands.append(_get_op_result_or_value(mean))
    operands.append(_get_op_result_or_value(variance))
    operands.append(_get_op_result_or_value(grad_output))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["epsilon"] = (epsilon if (
    issubclass(type(epsilon), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('F32Attr')) else
      _ods_ir.AttrBuilder.get('F32Attr')(epsilon, context=_ods_context))
    attributes["feature_index"] = (feature_index if (
    issubclass(type(feature_index), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(feature_index, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(BatchNormGradOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def scale(self):
    return self.operation.operands[1]

  @builtins.property
  def mean(self):
    return self.operation.operands[2]

  @builtins.property
  def variance(self):
    return self.operation.operands[3]

  @builtins.property
  def grad_output(self):
    return self.operation.operands[4]

  @builtins.property
  def epsilon(self):
    return _ods_ir.FloatAttr(self.operation.attributes["epsilon"])

  @epsilon.setter
  def epsilon(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["epsilon"] = value

  @builtins.property
  def feature_index(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["feature_index"])

  @feature_index.setter
  def feature_index(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["feature_index"] = value

  @builtins.property
  def grad_operand(self):
    return self.operation.results[0]

  @builtins.property
  def grad_scale(self):
    return self.operation.results[1]

  @builtins.property
  def grad_offset(self):
    return self.operation.results[2]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class BatchNormInferenceOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.batch_norm_inference"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, scale, offset, mean, variance, epsilon, feature_index, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(scale))
    operands.append(_get_op_result_or_value(offset))
    operands.append(_get_op_result_or_value(mean))
    operands.append(_get_op_result_or_value(variance))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["epsilon"] = (epsilon if (
    issubclass(type(epsilon), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('F32Attr')) else
      _ods_ir.AttrBuilder.get('F32Attr')(epsilon, context=_ods_context))
    attributes["feature_index"] = (feature_index if (
    issubclass(type(feature_index), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(feature_index, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(BatchNormInferenceOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def scale(self):
    return self.operation.operands[1]

  @builtins.property
  def offset(self):
    return self.operation.operands[2]

  @builtins.property
  def mean(self):
    return self.operation.operands[3]

  @builtins.property
  def variance(self):
    return self.operation.operands[4]

  @builtins.property
  def epsilon(self):
    return _ods_ir.FloatAttr(self.operation.attributes["epsilon"])

  @epsilon.setter
  def epsilon(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["epsilon"] = value

  @builtins.property
  def feature_index(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["feature_index"])

  @feature_index.setter
  def feature_index(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["feature_index"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class BatchNormTrainingOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.batch_norm_training"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, scale, offset, epsilon, feature_index, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(scale))
    operands.append(_get_op_result_or_value(offset))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["epsilon"] = (epsilon if (
    issubclass(type(epsilon), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('F32Attr')) else
      _ods_ir.AttrBuilder.get('F32Attr')(epsilon, context=_ods_context))
    attributes["feature_index"] = (feature_index if (
    issubclass(type(feature_index), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(feature_index, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(BatchNormTrainingOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def scale(self):
    return self.operation.operands[1]

  @builtins.property
  def offset(self):
    return self.operation.operands[2]

  @builtins.property
  def epsilon(self):
    return _ods_ir.FloatAttr(self.operation.attributes["epsilon"])

  @epsilon.setter
  def epsilon(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["epsilon"] = value

  @builtins.property
  def feature_index(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["feature_index"])

  @feature_index.setter
  def feature_index(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["feature_index"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

  @builtins.property
  def batch_mean(self):
    return self.operation.results[1]

  @builtins.property
  def batch_var(self):
    return self.operation.results[2]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class BitcastConvertOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.bitcast_convert"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class BroadcastInDimOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.broadcast_in_dim"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, broadcast_dimensions, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["broadcast_dimensions"] = (broadcast_dimensions if (
    issubclass(type(broadcast_dimensions), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(broadcast_dimensions, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def broadcast_dimensions(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["broadcast_dimensions"])

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["broadcast_dimensions"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class BroadcastOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.broadcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, broadcast_sizes, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["broadcast_sizes"] = (broadcast_sizes if (
    issubclass(type(broadcast_sizes), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(broadcast_sizes, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(BroadcastOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def broadcast_sizes(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["broadcast_sizes"])

  @broadcast_sizes.setter
  def broadcast_sizes(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["broadcast_sizes"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CaseOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.case"

  _ODS_REGIONS = (0, False)

  def __init__(self, result, index, num_branches, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(index))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result)
    _ods_successors = None
    regions = 0 + num_branches
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def index(self):
    return self.operation.operands[0]

  @builtins.property
  def branches(self):
    return self.regions[0:]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CbrtOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.cbrt"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(CbrtOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CeilOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.ceil"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(CeilOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CholeskyOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.cholesky"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, *, lower=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    _ods_context = _ods_get_default_loc_context(loc)
    if lower is not None: attributes["lower"] = (lower if (
        issubclass(type(lower), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(lower, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(CholeskyOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def lower(self):
    if "lower" not in self.operation.attributes:
      return None
    return _ods_ir.BoolAttr(self.operation.attributes["lower"])

  @lower.setter
  def lower(self, value):
    if value is not None:
      self.operation.attributes["lower"] = value
    elif "lower" in self.operation.attributes:
      del self.operation.attributes["lower"]

  @lower.deleter
  def lower(self):
    del self.operation.attributes["lower"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ClampOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.clamp"

  _ODS_REGIONS = (0, True)

  def __init__(self, min, operand, max, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(min))
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(max))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(ClampOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def min(self):
    return self.operation.operands[0]

  @builtins.property
  def operand(self):
    return self.operation.operands[1]

  @builtins.property
  def max(self):
    return self.operation.operands[2]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ClzOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.count_leading_zeros"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(ClzOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CollectivePermuteOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.collective_permute"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, source_target_pairs, *, channel_handle=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["source_target_pairs"] = (source_target_pairs if (
    issubclass(type(source_target_pairs), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(source_target_pairs, context=_ods_context))
    if channel_handle is not None: attributes["channel_handle"] = (channel_handle if (
        issubclass(type(channel_handle), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_ChannelHandle')) else
          _ods_ir.AttrBuilder.get('StableHLO_ChannelHandle')(channel_handle, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(CollectivePermuteOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def source_target_pairs(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["source_target_pairs"])

  @source_target_pairs.setter
  def source_target_pairs(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["source_target_pairs"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CompareOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.compare"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, comparison_direction, *, compare_type=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["comparison_direction"] = (comparison_direction if (
    issubclass(type(comparison_direction), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StableHLO_ComparisonDirectionAttr')) else
      _ods_ir.AttrBuilder.get('StableHLO_ComparisonDirectionAttr')(comparison_direction, context=_ods_context))
    if compare_type is not None: attributes["compare_type"] = (compare_type if (
        issubclass(type(compare_type), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_ComparisonTypeAttr')) else
          _ods_ir.AttrBuilder.get('StableHLO_ComparisonTypeAttr')(compare_type, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(CompareOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ComplexOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.complex"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(ComplexOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ComputeReshapeShapeOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.compute_reshape_shape"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, num_elements, dynamic_shape, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(num_elements))
    operands.append(_get_op_result_or_value(dynamic_shape))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def num_elements(self):
    return self.operation.operands[0]

  @builtins.property
  def dynamic_shape(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ConcatenateOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.concatenate"

  _ODS_REGIONS = (0, True)

  def __init__(self, inputs, dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    issubclass(type(dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(dimension, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(ConcatenateOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def dimension(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["dimension"])

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ConstantOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.constant"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    issubclass(type(value), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ElementsAttr')) else
      _ods_ir.AttrBuilder.get('ElementsAttr')(value, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(ConstantOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def output(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ConvertOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.convert"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ConvolutionOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.convolution"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, dimension_numbers, feature_group_count, batch_group_count, *, window_strides=None, padding=None, lhs_dilation=None, rhs_dilation=None, window_reversal=None, precision_config=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if window_strides is not None: attributes["window_strides"] = (window_strides if (
        issubclass(type(window_strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(window_strides, context=_ods_context))
    if padding is not None: attributes["padding"] = (padding if (
        issubclass(type(padding), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(padding, context=_ods_context))
    if lhs_dilation is not None: attributes["lhs_dilation"] = (lhs_dilation if (
        issubclass(type(lhs_dilation), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(lhs_dilation, context=_ods_context))
    if rhs_dilation is not None: attributes["rhs_dilation"] = (rhs_dilation if (
        issubclass(type(rhs_dilation), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(rhs_dilation, context=_ods_context))
    if window_reversal is not None: attributes["window_reversal"] = (window_reversal if (
        issubclass(type(window_reversal), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_BoolElementsAttr')) else
          _ods_ir.AttrBuilder.get('StableHLO_BoolElementsAttr')(window_reversal, context=_ods_context))
    attributes["dimension_numbers"] = (dimension_numbers if (
    issubclass(type(dimension_numbers), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StableHLO_ConvDimensionNumbers')) else
      _ods_ir.AttrBuilder.get('StableHLO_ConvDimensionNumbers')(dimension_numbers, context=_ods_context))
    attributes["feature_group_count"] = (feature_group_count if (
    issubclass(type(feature_group_count), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(feature_group_count, context=_ods_context))
    attributes["batch_group_count"] = (batch_group_count if (
    issubclass(type(batch_group_count), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(batch_group_count, context=_ods_context))
    if precision_config is not None: attributes["precision_config"] = (precision_config if (
        issubclass(type(precision_config), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_PrecisionConfigAttr')) else
          _ods_ir.AttrBuilder.get('StableHLO_PrecisionConfigAttr')(precision_config, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def window_strides(self):
    if "window_strides" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["window_strides"])

  @window_strides.setter
  def window_strides(self, value):
    if value is not None:
      self.operation.attributes["window_strides"] = value
    elif "window_strides" in self.operation.attributes:
      del self.operation.attributes["window_strides"]

  @window_strides.deleter
  def window_strides(self):
    del self.operation.attributes["window_strides"]

  @builtins.property
  def padding(self):
    if "padding" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["padding"])

  @padding.setter
  def padding(self, value):
    if value is not None:
      self.operation.attributes["padding"] = value
    elif "padding" in self.operation.attributes:
      del self.operation.attributes["padding"]

  @padding.deleter
  def padding(self):
    del self.operation.attributes["padding"]

  @builtins.property
  def lhs_dilation(self):
    if "lhs_dilation" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["lhs_dilation"])

  @lhs_dilation.setter
  def lhs_dilation(self, value):
    if value is not None:
      self.operation.attributes["lhs_dilation"] = value
    elif "lhs_dilation" in self.operation.attributes:
      del self.operation.attributes["lhs_dilation"]

  @lhs_dilation.deleter
  def lhs_dilation(self):
    del self.operation.attributes["lhs_dilation"]

  @builtins.property
  def rhs_dilation(self):
    if "rhs_dilation" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["rhs_dilation"])

  @rhs_dilation.setter
  def rhs_dilation(self, value):
    if value is not None:
      self.operation.attributes["rhs_dilation"] = value
    elif "rhs_dilation" in self.operation.attributes:
      del self.operation.attributes["rhs_dilation"]

  @rhs_dilation.deleter
  def rhs_dilation(self):
    del self.operation.attributes["rhs_dilation"]

  @builtins.property
  def window_reversal(self):
    if "window_reversal" not in self.operation.attributes:
      return None
    return _ods_ir.DenseElementsAttr(self.operation.attributes["window_reversal"])

  @window_reversal.setter
  def window_reversal(self, value):
    if value is not None:
      self.operation.attributes["window_reversal"] = value
    elif "window_reversal" in self.operation.attributes:
      del self.operation.attributes["window_reversal"]

  @window_reversal.deleter
  def window_reversal(self):
    del self.operation.attributes["window_reversal"]

  @builtins.property
  def feature_group_count(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["feature_group_count"])

  @feature_group_count.setter
  def feature_group_count(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["feature_group_count"] = value

  @builtins.property
  def batch_group_count(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["batch_group_count"])

  @batch_group_count.setter
  def batch_group_count(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["batch_group_count"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CosineOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.cosine"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(CosineOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CreateTokenOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.create_token"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(CreateTokenOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def output(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CrossReplicaSumOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.cross-replica-sum"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, replica_groups, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["replica_groups"] = (replica_groups if (
    issubclass(type(replica_groups), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(replica_groups, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(CrossReplicaSumOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def replica_groups(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["replica_groups"])

  @replica_groups.setter
  def replica_groups(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["replica_groups"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CstrReshapableOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.cstr_reshapable"

  _ODS_REGIONS = (0, True)

  def __init__(self, num_elements, dynamic_shape, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(num_elements))
    operands.append(_get_op_result_or_value(dynamic_shape))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(CstrReshapableOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def num_elements(self):
    return self.operation.operands[0]

  @builtins.property
  def dynamic_shape(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CustomCallOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.custom_call"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, inputs, call_target_name, *, has_side_effect=None, backend_config=None, api_version=None, called_computations=None, operand_layouts=None, result_layouts=None, output_operand_aliases=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["call_target_name"] = (call_target_name if (
    issubclass(type(call_target_name), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(call_target_name, context=_ods_context))
    if has_side_effect is not None: attributes["has_side_effect"] = (has_side_effect if (
        issubclass(type(has_side_effect), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(has_side_effect, context=_ods_context))
    if backend_config is not None: attributes["backend_config"] = (backend_config if (
        issubclass(type(backend_config), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(backend_config, context=_ods_context))
    if api_version is not None: attributes["api_version"] = (api_version if (
        issubclass(type(api_version), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_CustomCallApiVersionAttr')) else
          _ods_ir.AttrBuilder.get('StableHLO_CustomCallApiVersionAttr')(api_version, context=_ods_context))
    if called_computations is not None: attributes["called_computations"] = (called_computations if (
        issubclass(type(called_computations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_FlatSymbolRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('StableHLO_FlatSymbolRefArrayAttr')(called_computations, context=_ods_context))
    if operand_layouts is not None: attributes["operand_layouts"] = (operand_layouts if (
        issubclass(type(operand_layouts), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_ArrayOfLayoutAttr')) else
          _ods_ir.AttrBuilder.get('StableHLO_ArrayOfLayoutAttr')(operand_layouts, context=_ods_context))
    if result_layouts is not None: attributes["result_layouts"] = (result_layouts if (
        issubclass(type(result_layouts), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_ArrayOfLayoutAttr')) else
          _ods_ir.AttrBuilder.get('StableHLO_ArrayOfLayoutAttr')(result_layouts, context=_ods_context))
    if output_operand_aliases is not None: attributes["output_operand_aliases"] = (output_operand_aliases if (
        issubclass(type(output_operand_aliases), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('anonymous_634')) else
          _ods_ir.AttrBuilder.get('anonymous_634')(output_operand_aliases, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def call_target_name(self):
    return _ods_ir.StringAttr(self.operation.attributes["call_target_name"])

  @call_target_name.setter
  def call_target_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["call_target_name"] = value

  @builtins.property
  def has_side_effect(self):
    if "has_side_effect" not in self.operation.attributes:
      return None
    return _ods_ir.BoolAttr(self.operation.attributes["has_side_effect"])

  @has_side_effect.setter
  def has_side_effect(self, value):
    if value is not None:
      self.operation.attributes["has_side_effect"] = value
    elif "has_side_effect" in self.operation.attributes:
      del self.operation.attributes["has_side_effect"]

  @has_side_effect.deleter
  def has_side_effect(self):
    del self.operation.attributes["has_side_effect"]

  @builtins.property
  def backend_config(self):
    return _ods_ir.StringAttr(self.operation.attributes["backend_config"])

  @backend_config.setter
  def backend_config(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["backend_config"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class DivOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.divide"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(DivOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class DotGeneralOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.dot_general"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, dot_dimension_numbers, *, precision_config=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dot_dimension_numbers"] = (dot_dimension_numbers if (
    issubclass(type(dot_dimension_numbers), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StableHLO_DotDimensionNumbers')) else
      _ods_ir.AttrBuilder.get('StableHLO_DotDimensionNumbers')(dot_dimension_numbers, context=_ods_context))
    if precision_config is not None: attributes["precision_config"] = (precision_config if (
        issubclass(type(precision_config), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_PrecisionConfigAttr')) else
          _ods_ir.AttrBuilder.get('StableHLO_PrecisionConfigAttr')(precision_config, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class DotOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.dot"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, *, precision_config=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    if precision_config is not None: attributes["precision_config"] = (precision_config if (
        issubclass(type(precision_config), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_PrecisionConfigAttr')) else
          _ods_ir.AttrBuilder.get('StableHLO_PrecisionConfigAttr')(precision_config, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class DynamicBroadcastInDimOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.dynamic_broadcast_in_dim"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, output_dimensions, broadcast_dimensions, *, known_expanding_dimensions=None, known_nonexpanding_dimensions=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(output_dimensions))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["broadcast_dimensions"] = (broadcast_dimensions if (
    issubclass(type(broadcast_dimensions), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(broadcast_dimensions, context=_ods_context))
    if known_expanding_dimensions is not None: attributes["known_expanding_dimensions"] = (known_expanding_dimensions if (
        issubclass(type(known_expanding_dimensions), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(known_expanding_dimensions, context=_ods_context))
    if known_nonexpanding_dimensions is not None: attributes["known_nonexpanding_dimensions"] = (known_nonexpanding_dimensions if (
        issubclass(type(known_nonexpanding_dimensions), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(known_nonexpanding_dimensions, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def output_dimensions(self):
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["broadcast_dimensions"])

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["broadcast_dimensions"] = value

  @builtins.property
  def known_expanding_dimensions(self):
    if "known_expanding_dimensions" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["known_expanding_dimensions"])

  @known_expanding_dimensions.setter
  def known_expanding_dimensions(self, value):
    if value is not None:
      self.operation.attributes["known_expanding_dimensions"] = value
    elif "known_expanding_dimensions" in self.operation.attributes:
      del self.operation.attributes["known_expanding_dimensions"]

  @known_expanding_dimensions.deleter
  def known_expanding_dimensions(self):
    del self.operation.attributes["known_expanding_dimensions"]

  @builtins.property
  def known_nonexpanding_dimensions(self):
    if "known_nonexpanding_dimensions" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["known_nonexpanding_dimensions"])

  @known_nonexpanding_dimensions.setter
  def known_nonexpanding_dimensions(self, value):
    if value is not None:
      self.operation.attributes["known_nonexpanding_dimensions"] = value
    elif "known_nonexpanding_dimensions" in self.operation.attributes:
      del self.operation.attributes["known_nonexpanding_dimensions"]

  @known_nonexpanding_dimensions.deleter
  def known_nonexpanding_dimensions(self):
    del self.operation.attributes["known_nonexpanding_dimensions"]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class DynamicConvOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.dynamic_conv"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, d_padding, dimension_numbers, feature_group_count, batch_group_count, *, window_strides=None, padding=None, lhs_dilation=None, rhs_dilation=None, window_reversal=None, precision_config=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    operands.append(_get_op_result_or_value(d_padding))
    _ods_context = _ods_get_default_loc_context(loc)
    if window_strides is not None: attributes["window_strides"] = (window_strides if (
        issubclass(type(window_strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(window_strides, context=_ods_context))
    if padding is not None: attributes["padding"] = (padding if (
        issubclass(type(padding), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(padding, context=_ods_context))
    if lhs_dilation is not None: attributes["lhs_dilation"] = (lhs_dilation if (
        issubclass(type(lhs_dilation), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(lhs_dilation, context=_ods_context))
    if rhs_dilation is not None: attributes["rhs_dilation"] = (rhs_dilation if (
        issubclass(type(rhs_dilation), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(rhs_dilation, context=_ods_context))
    if window_reversal is not None: attributes["window_reversal"] = (window_reversal if (
        issubclass(type(window_reversal), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_BoolElementsAttr')) else
          _ods_ir.AttrBuilder.get('StableHLO_BoolElementsAttr')(window_reversal, context=_ods_context))
    attributes["dimension_numbers"] = (dimension_numbers if (
    issubclass(type(dimension_numbers), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StableHLO_ConvDimensionNumbers')) else
      _ods_ir.AttrBuilder.get('StableHLO_ConvDimensionNumbers')(dimension_numbers, context=_ods_context))
    attributes["feature_group_count"] = (feature_group_count if (
    issubclass(type(feature_group_count), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(feature_group_count, context=_ods_context))
    attributes["batch_group_count"] = (batch_group_count if (
    issubclass(type(batch_group_count), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(batch_group_count, context=_ods_context))
    if precision_config is not None: attributes["precision_config"] = (precision_config if (
        issubclass(type(precision_config), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_PrecisionConfigAttr')) else
          _ods_ir.AttrBuilder.get('StableHLO_PrecisionConfigAttr')(precision_config, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def d_padding(self):
    return self.operation.operands[2]

  @builtins.property
  def window_strides(self):
    if "window_strides" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["window_strides"])

  @window_strides.setter
  def window_strides(self, value):
    if value is not None:
      self.operation.attributes["window_strides"] = value
    elif "window_strides" in self.operation.attributes:
      del self.operation.attributes["window_strides"]

  @window_strides.deleter
  def window_strides(self):
    del self.operation.attributes["window_strides"]

  @builtins.property
  def padding(self):
    if "padding" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["padding"])

  @padding.setter
  def padding(self, value):
    if value is not None:
      self.operation.attributes["padding"] = value
    elif "padding" in self.operation.attributes:
      del self.operation.attributes["padding"]

  @padding.deleter
  def padding(self):
    del self.operation.attributes["padding"]

  @builtins.property
  def lhs_dilation(self):
    if "lhs_dilation" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["lhs_dilation"])

  @lhs_dilation.setter
  def lhs_dilation(self, value):
    if value is not None:
      self.operation.attributes["lhs_dilation"] = value
    elif "lhs_dilation" in self.operation.attributes:
      del self.operation.attributes["lhs_dilation"]

  @lhs_dilation.deleter
  def lhs_dilation(self):
    del self.operation.attributes["lhs_dilation"]

  @builtins.property
  def rhs_dilation(self):
    if "rhs_dilation" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["rhs_dilation"])

  @rhs_dilation.setter
  def rhs_dilation(self, value):
    if value is not None:
      self.operation.attributes["rhs_dilation"] = value
    elif "rhs_dilation" in self.operation.attributes:
      del self.operation.attributes["rhs_dilation"]

  @rhs_dilation.deleter
  def rhs_dilation(self):
    del self.operation.attributes["rhs_dilation"]

  @builtins.property
  def window_reversal(self):
    if "window_reversal" not in self.operation.attributes:
      return None
    return _ods_ir.DenseElementsAttr(self.operation.attributes["window_reversal"])

  @window_reversal.setter
  def window_reversal(self, value):
    if value is not None:
      self.operation.attributes["window_reversal"] = value
    elif "window_reversal" in self.operation.attributes:
      del self.operation.attributes["window_reversal"]

  @window_reversal.deleter
  def window_reversal(self):
    del self.operation.attributes["window_reversal"]

  @builtins.property
  def feature_group_count(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["feature_group_count"])

  @feature_group_count.setter
  def feature_group_count(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["feature_group_count"] = value

  @builtins.property
  def batch_group_count(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["batch_group_count"])

  @batch_group_count.setter
  def batch_group_count(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["batch_group_count"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class DynamicGatherOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.dynamic_gather"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, start_indices, slice_sizes, dimension_numbers, *, indices_are_sorted=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(start_indices))
    operands.append(_get_op_result_or_value(slice_sizes))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension_numbers"] = (dimension_numbers if (
    issubclass(type(dimension_numbers), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StableHLO_GatherDimensionNumbers')) else
      _ods_ir.AttrBuilder.get('StableHLO_GatherDimensionNumbers')(dimension_numbers, context=_ods_context))
    if indices_are_sorted is not None: attributes["indices_are_sorted"] = (indices_are_sorted if (
        issubclass(type(indices_are_sorted), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(indices_are_sorted, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(DynamicGatherOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def start_indices(self):
    return self.operation.operands[1]

  @builtins.property
  def slice_sizes(self):
    return self.operation.operands[2]

  @builtins.property
  def indices_are_sorted(self):
    if "indices_are_sorted" not in self.operation.attributes:
      return None
    return _ods_ir.BoolAttr(self.operation.attributes["indices_are_sorted"])

  @indices_are_sorted.setter
  def indices_are_sorted(self, value):
    if value is not None:
      self.operation.attributes["indices_are_sorted"] = value
    elif "indices_are_sorted" in self.operation.attributes:
      del self.operation.attributes["indices_are_sorted"]

  @indices_are_sorted.deleter
  def indices_are_sorted(self):
    del self.operation.attributes["indices_are_sorted"]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class DynamicIotaOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.dynamic_iota"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, output_shape, iota_dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(output_shape))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["iota_dimension"] = (iota_dimension if (
    issubclass(type(iota_dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(iota_dimension, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def output_shape(self):
    return self.operation.operands[0]

  @builtins.property
  def iota_dimension(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["iota_dimension"])

  @iota_dimension.setter
  def iota_dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["iota_dimension"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class DynamicPadOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.dynamic_pad"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, padding_value, edge_padding_low, edge_padding_high, interior_padding, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(padding_value))
    operands.append(_get_op_result_or_value(edge_padding_low))
    operands.append(_get_op_result_or_value(edge_padding_high))
    operands.append(_get_op_result_or_value(interior_padding))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def padding_value(self):
    return self.operation.operands[1]

  @builtins.property
  def edge_padding_low(self):
    return self.operation.operands[2]

  @builtins.property
  def edge_padding_high(self):
    return self.operation.operands[3]

  @builtins.property
  def interior_padding(self):
    return self.operation.operands[4]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class DynamicReshapeOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.dynamic_reshape"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, output_shape, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(output_shape))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def output_shape(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class DynamicSliceOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.dynamic_slice"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, start_indices, slice_sizes, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.extend(_get_op_results_or_values(start_indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["slice_sizes"] = (slice_sizes if (
    issubclass(type(slice_sizes), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(slice_sizes, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(DynamicSliceOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def start_indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def slice_sizes(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["slice_sizes"])

  @slice_sizes.setter
  def slice_sizes(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["slice_sizes"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class DynamicUpdateSliceOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.dynamic_update_slice"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, update, start_indices, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(update))
    operands.extend(_get_op_results_or_values(start_indices))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(DynamicUpdateSliceOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def update(self):
    return self.operation.operands[1]

  @builtins.property
  def start_indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class EinsumOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.einsum"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, einsum_config, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["einsum_config"] = (einsum_config if (
    issubclass(type(einsum_config), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(einsum_config, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def einsum_config(self):
    return _ods_ir.StringAttr(self.operation.attributes["einsum_config"])

  @einsum_config.setter
  def einsum_config(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["einsum_config"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ExpOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.exponential"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(ExpOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class Expm1Op(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.exponential_minus_one"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(Expm1Op).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class FftOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.fft"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, fft_type, fft_length, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["fft_type"] = (fft_type if (
    issubclass(type(fft_type), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StableHLO_FftTypeAttr')) else
      _ods_ir.AttrBuilder.get('StableHLO_FftTypeAttr')(fft_type, context=_ods_context))
    attributes["fft_length"] = (fft_length if (
    issubclass(type(fft_length), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(fft_length, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(FftOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def fft_length(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["fft_length"])

  @fft_length.setter
  def fft_length(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fft_length"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class FloorOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.floor"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(FloorOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class GatherOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.gather"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, start_indices, dimension_numbers, slice_sizes, *, indices_are_sorted=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(start_indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension_numbers"] = (dimension_numbers if (
    issubclass(type(dimension_numbers), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StableHLO_GatherDimensionNumbers')) else
      _ods_ir.AttrBuilder.get('StableHLO_GatherDimensionNumbers')(dimension_numbers, context=_ods_context))
    attributes["slice_sizes"] = (slice_sizes if (
    issubclass(type(slice_sizes), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(slice_sizes, context=_ods_context))
    if indices_are_sorted is not None: attributes["indices_are_sorted"] = (indices_are_sorted if (
        issubclass(type(indices_are_sorted), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(indices_are_sorted, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(GatherOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def start_indices(self):
    return self.operation.operands[1]

  @builtins.property
  def slice_sizes(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["slice_sizes"])

  @slice_sizes.setter
  def slice_sizes(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["slice_sizes"] = value

  @builtins.property
  def indices_are_sorted(self):
    if "indices_are_sorted" not in self.operation.attributes:
      return None
    return _ods_ir.BoolAttr(self.operation.attributes["indices_are_sorted"])

  @indices_are_sorted.setter
  def indices_are_sorted(self, value):
    if value is not None:
      self.operation.attributes["indices_are_sorted"] = value
    elif "indices_are_sorted" in self.operation.attributes:
      del self.operation.attributes["indices_are_sorted"]

  @indices_are_sorted.deleter
  def indices_are_sorted(self):
    del self.operation.attributes["indices_are_sorted"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class GetDimensionSizeOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.get_dimension_size"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    issubclass(type(dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(dimension, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(GetDimensionSizeOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def dimension(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["dimension"])

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class GetTupleElementOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.get_tuple_element"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, index, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["index"] = (index if (
    issubclass(type(index), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(index, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(GetTupleElementOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def index(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["index"])

  @index.setter
  def index(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["index"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class IfOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.if"

  _ODS_REGIONS = (2, True)

  def __init__(self, result, pred, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(pred))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def pred(self):
    return self.operation.operands[0]

  @builtins.property
  def true_branch(self):
    return self.regions[0]

  @builtins.property
  def false_branch(self):
    return self.regions[1]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ImagOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.imag"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(ImagOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class InfeedOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.infeed"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, token, *, infeed_config=None, layout=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(token))
    _ods_context = _ods_get_default_loc_context(loc)
    if infeed_config is not None: attributes["infeed_config"] = (infeed_config if (
        issubclass(type(infeed_config), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(infeed_config, context=_ods_context))
    if layout is not None: attributes["layout"] = (layout if (
        issubclass(type(layout), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
          _ods_ir.AttrBuilder.get('ArrayAttr')(layout, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def token(self):
    return self.operation.operands[0]

  @builtins.property
  def infeed_config(self):
    return _ods_ir.StringAttr(self.operation.attributes["infeed_config"])

  @infeed_config.setter
  def infeed_config(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["infeed_config"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class IotaOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.iota"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, iota_dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["iota_dimension"] = (iota_dimension if (
    issubclass(type(iota_dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(iota_dimension, context=_ods_context))
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def iota_dimension(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["iota_dimension"])

  @iota_dimension.setter
  def iota_dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["iota_dimension"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class IsFiniteOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.is_finite"

  _ODS_REGIONS = (0, True)

  def __init__(self, x, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(x))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(IsFiniteOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def x(self):
    return self.operation.operands[0]

  @builtins.property
  def y(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class Log1pOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.log_plus_one"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(Log1pOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class LogOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.log"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(LogOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class LogisticOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.logistic"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(LogisticOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class MapOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.map"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, inputs, dimensions, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimensions"] = (dimensions if (
    issubclass(type(dimensions), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(dimensions, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def dimensions(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["dimensions"])

  @dimensions.setter
  def dimensions(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimensions"] = value

  @builtins.property
  def computation(self):
    return self.regions[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class MaxOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.maximum"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(MaxOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class MinOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.minimum"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(MinOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class MulOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.multiply"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(MulOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class NegOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.negate"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(NegOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class NotOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.not"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(NotOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class OptimizationBarrierOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.optimization_barrier"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(OptimizationBarrierOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class OrOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.or"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(OrOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class OutfeedOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.outfeed"

  _ODS_REGIONS = (0, True)

  def __init__(self, inputs, token, *, outfeed_config=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    operands.append(_get_op_result_or_value(token))
    _ods_context = _ods_get_default_loc_context(loc)
    if outfeed_config is not None: attributes["outfeed_config"] = (outfeed_config if (
        issubclass(type(outfeed_config), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(outfeed_config, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(OutfeedOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def token(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def outfeed_config(self):
    return _ods_ir.StringAttr(self.operation.attributes["outfeed_config"])

  @outfeed_config.setter
  def outfeed_config(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["outfeed_config"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class PadOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.pad"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, padding_value, edge_padding_low, edge_padding_high, interior_padding, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(padding_value))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["edge_padding_low"] = (edge_padding_low if (
    issubclass(type(edge_padding_low), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(edge_padding_low, context=_ods_context))
    attributes["edge_padding_high"] = (edge_padding_high if (
    issubclass(type(edge_padding_high), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(edge_padding_high, context=_ods_context))
    attributes["interior_padding"] = (interior_padding if (
    issubclass(type(interior_padding), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(interior_padding, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(PadOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def padding_value(self):
    return self.operation.operands[1]

  @builtins.property
  def edge_padding_low(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["edge_padding_low"])

  @edge_padding_low.setter
  def edge_padding_low(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["edge_padding_low"] = value

  @builtins.property
  def edge_padding_high(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["edge_padding_high"])

  @edge_padding_high.setter
  def edge_padding_high(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["edge_padding_high"] = value

  @builtins.property
  def interior_padding(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["interior_padding"])

  @interior_padding.setter
  def interior_padding(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["interior_padding"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class PartitionIdOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.partition_id"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(PartitionIdOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class PopulationCountOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.popcnt"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(PopulationCountOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class PowOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.power"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(PowOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class RealDynamicSliceOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.real_dynamic_slice"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, start_indices, limit_indices, strides, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(start_indices))
    operands.append(_get_op_result_or_value(limit_indices))
    operands.append(_get_op_result_or_value(strides))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def start_indices(self):
    return self.operation.operands[1]

  @builtins.property
  def limit_indices(self):
    return self.operation.operands[2]

  @builtins.property
  def strides(self):
    return self.operation.operands[3]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class RealOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.real"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(RealOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class RecvOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.recv"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, token, channel_handle, *, is_host_transfer=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(token))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["channel_handle"] = (channel_handle if (
    issubclass(type(channel_handle), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StableHLO_ChannelHandle')) else
      _ods_ir.AttrBuilder.get('StableHLO_ChannelHandle')(channel_handle, context=_ods_context))
    if is_host_transfer is not None: attributes["is_host_transfer"] = (is_host_transfer if (
        issubclass(type(is_host_transfer), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(is_host_transfer, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def token(self):
    return self.operation.operands[0]

  @builtins.property
  def is_host_transfer(self):
    if "is_host_transfer" not in self.operation.attributes:
      return None
    return _ods_ir.BoolAttr(self.operation.attributes["is_host_transfer"])

  @is_host_transfer.setter
  def is_host_transfer(self, value):
    if value is not None:
      self.operation.attributes["is_host_transfer"] = value
    elif "is_host_transfer" in self.operation.attributes:
      del self.operation.attributes["is_host_transfer"]

  @is_host_transfer.deleter
  def is_host_transfer(self):
    del self.operation.attributes["is_host_transfer"]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ReduceOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.reduce"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, inputs, init_values, dimensions, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    operands.extend(_get_op_results_or_values(init_values))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimensions"] = (dimensions if (
    issubclass(type(dimensions), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(dimensions, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    start, pg = _ods_equally_sized_accessor(operation.operands, 2, 0, 0)
    return self.operation.operands[start:start + pg]

  @builtins.property
  def init_values(self):
    start, pg = _ods_equally_sized_accessor(operation.operands, 2, 0, 1)
    return self.operation.operands[start:start + pg]

  @builtins.property
  def dimensions(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["dimensions"])

  @dimensions.setter
  def dimensions(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimensions"] = value

  @builtins.property
  def body(self):
    return self.regions[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ReducePrecisionOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.reduce_precision"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, exponent_bits, mantissa_bits, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["exponent_bits"] = (exponent_bits if (
    issubclass(type(exponent_bits), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(exponent_bits, context=_ods_context))
    attributes["mantissa_bits"] = (mantissa_bits if (
    issubclass(type(mantissa_bits), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(mantissa_bits, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(ReducePrecisionOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def exponent_bits(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["exponent_bits"])

  @exponent_bits.setter
  def exponent_bits(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["exponent_bits"] = value

  @builtins.property
  def mantissa_bits(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["mantissa_bits"])

  @mantissa_bits.setter
  def mantissa_bits(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["mantissa_bits"] = value

  @builtins.property
  def output(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ReduceScatterOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.reduce_scatter"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, operand, scatter_dimension, replica_groups, *, channel_handle=None, use_global_device_ids=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["scatter_dimension"] = (scatter_dimension if (
    issubclass(type(scatter_dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(scatter_dimension, context=_ods_context))
    attributes["replica_groups"] = (replica_groups if (
    issubclass(type(replica_groups), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(replica_groups, context=_ods_context))
    if channel_handle is not None: attributes["channel_handle"] = (channel_handle if (
        issubclass(type(channel_handle), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StableHLO_ChannelHandle')) else
          _ods_ir.AttrBuilder.get('StableHLO_ChannelHandle')(channel_handle, context=_ods_context))
    if bool(use_global_device_ids): attributes["use_global_device_ids"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def scatter_dimension(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["scatter_dimension"])

  @scatter_dimension.setter
  def scatter_dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["scatter_dimension"] = value

  @builtins.property
  def replica_groups(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["replica_groups"])

  @replica_groups.setter
  def replica_groups(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["replica_groups"] = value

  @builtins.property
  def use_global_device_ids(self):
    return "use_global_device_ids" in self.operation.attributes

  @use_global_device_ids.setter
  def use_global_device_ids(self, value):
    if bool(value):
      self.operation.attributes["use_global_device_ids"] = _ods_ir.UnitAttr.get()
    elif "use_global_device_ids" in self.operation.attributes:
      del self.operation.attributes["use_global_device_ids"]

  @use_global_device_ids.deleter
  def use_global_device_ids(self):
    del self.operation.attributes["use_global_device_ids"]

  @builtins.property
  def computation(self):
    return self.regions[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ReduceWindowOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.reduce_window"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, inputs, init_values, window_dimensions, *, window_strides=None, base_dilations=None, window_dilations=None, padding=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    operands.extend(_get_op_results_or_values(init_values))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["window_dimensions"] = (window_dimensions if (
    issubclass(type(window_dimensions), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(window_dimensions, context=_ods_context))
    if window_strides is not None: attributes["window_strides"] = (window_strides if (
        issubclass(type(window_strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(window_strides, context=_ods_context))
    if base_dilations is not None: attributes["base_dilations"] = (base_dilations if (
        issubclass(type(base_dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(base_dilations, context=_ods_context))
    if window_dilations is not None: attributes["window_dilations"] = (window_dilations if (
        issubclass(type(window_dilations), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(window_dilations, context=_ods_context))
    if padding is not None: attributes["padding"] = (padding if (
        issubclass(type(padding), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(padding, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    start, pg = _ods_equally_sized_accessor(operation.operands, 2, 0, 0)
    return self.operation.operands[start:start + pg]

  @builtins.property
  def init_values(self):
    start, pg = _ods_equally_sized_accessor(operation.operands, 2, 0, 1)
    return self.operation.operands[start:start + pg]

  @builtins.property
  def window_dimensions(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["window_dimensions"])

  @window_dimensions.setter
  def window_dimensions(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["window_dimensions"] = value

  @builtins.property
  def window_strides(self):
    if "window_strides" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["window_strides"])

  @window_strides.setter
  def window_strides(self, value):
    if value is not None:
      self.operation.attributes["window_strides"] = value
    elif "window_strides" in self.operation.attributes:
      del self.operation.attributes["window_strides"]

  @window_strides.deleter
  def window_strides(self):
    del self.operation.attributes["window_strides"]

  @builtins.property
  def base_dilations(self):
    if "base_dilations" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["base_dilations"])

  @base_dilations.setter
  def base_dilations(self, value):
    if value is not None:
      self.operation.attributes["base_dilations"] = value
    elif "base_dilations" in self.operation.attributes:
      del self.operation.attributes["base_dilations"]

  @base_dilations.deleter
  def base_dilations(self):
    del self.operation.attributes["base_dilations"]

  @builtins.property
  def window_dilations(self):
    if "window_dilations" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["window_dilations"])

  @window_dilations.setter
  def window_dilations(self, value):
    if value is not None:
      self.operation.attributes["window_dilations"] = value
    elif "window_dilations" in self.operation.attributes:
      del self.operation.attributes["window_dilations"]

  @window_dilations.deleter
  def window_dilations(self):
    del self.operation.attributes["window_dilations"]

  @builtins.property
  def padding(self):
    if "padding" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["padding"])

  @padding.setter
  def padding(self, value):
    if value is not None:
      self.operation.attributes["padding"] = value
    elif "padding" in self.operation.attributes:
      del self.operation.attributes["padding"]

  @padding.deleter
  def padding(self):
    del self.operation.attributes["padding"]

  @builtins.property
  def body(self):
    return self.regions[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class RemOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.remainder"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(RemOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ReplicaIdOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.replica_id"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(ReplicaIdOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ReshapeOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.reshape"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ReturnOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.return"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(results_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ReverseOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.reverse"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, dimensions, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimensions"] = (dimensions if (
    issubclass(type(dimensions), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(dimensions, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(ReverseOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def dimensions(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["dimensions"])

  @dimensions.setter
  def dimensions(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimensions"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class RngBitGeneratorOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.rng_bit_generator"

  _ODS_REGIONS = (0, True)

  def __init__(self, output_state, output, rng_algorithm, initial_state, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(initial_state))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["rng_algorithm"] = (rng_algorithm if (
    issubclass(type(rng_algorithm), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StableHLO_RngAlgorithmAttr')) else
      _ods_ir.AttrBuilder.get('StableHLO_RngAlgorithmAttr')(rng_algorithm, context=_ods_context))
    results.append(output_state)
    results.append(output)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def initial_state(self):
    return self.operation.operands[0]

  @builtins.property
  def output_state(self):
    return self.operation.results[0]

  @builtins.property
  def output(self):
    return self.operation.results[1]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class RngOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.rng"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, shape, rng_distribution, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    operands.append(_get_op_result_or_value(shape))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["rng_distribution"] = (rng_distribution if (
    issubclass(type(rng_distribution), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StableHLO_RngDistributionAttr')) else
      _ods_ir.AttrBuilder.get('StableHLO_RngDistributionAttr')(rng_distribution, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(RngOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def shape(self):
    return self.operation.operands[2]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class RoundNearestEvenOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.round_nearest_even"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(RoundNearestEvenOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class RoundOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.round_nearest_afz"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(RoundOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class RsqrtOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.rsqrt"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(RsqrtOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ScatterOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.scatter"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, inputs, scatter_indices, updates, scatter_dimension_numbers, *, indices_are_sorted=None, unique_indices=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    operands.append(_get_op_result_or_value(scatter_indices))
    operands.extend(_get_op_results_or_values(updates))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["scatter_dimension_numbers"] = (scatter_dimension_numbers if (
    issubclass(type(scatter_dimension_numbers), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StableHLO_ScatterDimensionNumbers')) else
      _ods_ir.AttrBuilder.get('StableHLO_ScatterDimensionNumbers')(scatter_dimension_numbers, context=_ods_context))
    if indices_are_sorted is not None: attributes["indices_are_sorted"] = (indices_are_sorted if (
        issubclass(type(indices_are_sorted), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(indices_are_sorted, context=_ods_context))
    if unique_indices is not None: attributes["unique_indices"] = (unique_indices if (
        issubclass(type(unique_indices), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(unique_indices, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    start, pg = _ods_equally_sized_accessor(operation.operands, 2, 0, 0)
    return self.operation.operands[start:start + pg]

  @builtins.property
  def scatter_indices(self):
    start, pg = _ods_equally_sized_accessor(operation.operands, 2, 0, 1)
    return self.operation.operands[start]

  @builtins.property
  def updates(self):
    start, pg = _ods_equally_sized_accessor(operation.operands, 2, 1, 1)
    return self.operation.operands[start:start + pg]

  @builtins.property
  def indices_are_sorted(self):
    if "indices_are_sorted" not in self.operation.attributes:
      return None
    return _ods_ir.BoolAttr(self.operation.attributes["indices_are_sorted"])

  @indices_are_sorted.setter
  def indices_are_sorted(self, value):
    if value is not None:
      self.operation.attributes["indices_are_sorted"] = value
    elif "indices_are_sorted" in self.operation.attributes:
      del self.operation.attributes["indices_are_sorted"]

  @indices_are_sorted.deleter
  def indices_are_sorted(self):
    del self.operation.attributes["indices_are_sorted"]

  @builtins.property
  def unique_indices(self):
    if "unique_indices" not in self.operation.attributes:
      return None
    return _ods_ir.BoolAttr(self.operation.attributes["unique_indices"])

  @unique_indices.setter
  def unique_indices(self, value):
    if value is not None:
      self.operation.attributes["unique_indices"] = value
    elif "unique_indices" in self.operation.attributes:
      del self.operation.attributes["unique_indices"]

  @unique_indices.deleter
  def unique_indices(self):
    del self.operation.attributes["unique_indices"]

  @builtins.property
  def update_computation(self):
    return self.regions[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class SelectAndScatterOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.select_and_scatter"

  _ODS_REGIONS = (2, True)

  def __init__(self, result, operand, source, init_value, *, window_dimensions=None, window_strides=None, padding=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(init_value))
    _ods_context = _ods_get_default_loc_context(loc)
    if window_dimensions is not None: attributes["window_dimensions"] = (window_dimensions if (
        issubclass(type(window_dimensions), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(window_dimensions, context=_ods_context))
    if window_strides is not None: attributes["window_strides"] = (window_strides if (
        issubclass(type(window_strides), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(window_strides, context=_ods_context))
    if padding is not None: attributes["padding"] = (padding if (
        issubclass(type(padding), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
          _ods_ir.AttrBuilder.get('I64ElementsAttr')(padding, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def source(self):
    return self.operation.operands[1]

  @builtins.property
  def init_value(self):
    return self.operation.operands[2]

  @builtins.property
  def window_dimensions(self):
    if "window_dimensions" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["window_dimensions"])

  @window_dimensions.setter
  def window_dimensions(self, value):
    if value is not None:
      self.operation.attributes["window_dimensions"] = value
    elif "window_dimensions" in self.operation.attributes:
      del self.operation.attributes["window_dimensions"]

  @window_dimensions.deleter
  def window_dimensions(self):
    del self.operation.attributes["window_dimensions"]

  @builtins.property
  def window_strides(self):
    if "window_strides" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["window_strides"])

  @window_strides.setter
  def window_strides(self, value):
    if value is not None:
      self.operation.attributes["window_strides"] = value
    elif "window_strides" in self.operation.attributes:
      del self.operation.attributes["window_strides"]

  @window_strides.deleter
  def window_strides(self):
    del self.operation.attributes["window_strides"]

  @builtins.property
  def padding(self):
    if "padding" not in self.operation.attributes:
      return None
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["padding"])

  @padding.setter
  def padding(self, value):
    if value is not None:
      self.operation.attributes["padding"] = value
    elif "padding" in self.operation.attributes:
      del self.operation.attributes["padding"]

  @padding.deleter
  def padding(self):
    del self.operation.attributes["padding"]

  @builtins.property
  def select(self):
    return self.regions[0]

  @builtins.property
  def scatter(self):
    return self.regions[1]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class SelectOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.select"

  _ODS_REGIONS = (0, True)

  def __init__(self, pred, on_true, on_false, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(pred))
    operands.append(_get_op_result_or_value(on_true))
    operands.append(_get_op_result_or_value(on_false))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(SelectOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def pred(self):
    return self.operation.operands[0]

  @builtins.property
  def on_true(self):
    return self.operation.operands[1]

  @builtins.property
  def on_false(self):
    return self.operation.operands[2]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class SendOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.send"

  _ODS_REGIONS = (0, True)

  def __init__(self, inputs, token, channel_handle, *, is_host_transfer=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    operands.append(_get_op_result_or_value(token))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["channel_handle"] = (channel_handle if (
    issubclass(type(channel_handle), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StableHLO_ChannelHandle')) else
      _ods_ir.AttrBuilder.get('StableHLO_ChannelHandle')(channel_handle, context=_ods_context))
    if is_host_transfer is not None: attributes["is_host_transfer"] = (is_host_transfer if (
        issubclass(type(is_host_transfer), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(is_host_transfer, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(SendOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def token(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1 + _ods_variadic_group_length - 1]

  @builtins.property
  def is_host_transfer(self):
    if "is_host_transfer" not in self.operation.attributes:
      return None
    return _ods_ir.BoolAttr(self.operation.attributes["is_host_transfer"])

  @is_host_transfer.setter
  def is_host_transfer(self, value):
    if value is not None:
      self.operation.attributes["is_host_transfer"] = value
    elif "is_host_transfer" in self.operation.attributes:
      del self.operation.attributes["is_host_transfer"]

  @is_host_transfer.deleter
  def is_host_transfer(self):
    del self.operation.attributes["is_host_transfer"]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class SetDimensionSizeOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.set_dimension_size"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, size, dimension, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(size))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    issubclass(type(dimension), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(dimension, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(SetDimensionSizeOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def size(self):
    return self.operation.operands[1]

  @builtins.property
  def dimension(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["dimension"])

  @dimension.setter
  def dimension(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ShiftLeftOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.shift_left"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(ShiftLeftOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ShiftRightArithmeticOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.shift_right_arithmetic"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(ShiftRightArithmeticOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ShiftRightLogicalOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.shift_right_logical"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(ShiftRightLogicalOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class SignOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.sign"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(SignOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class SineOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.sine"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(SineOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class SliceOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.slice"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, start_indices, limit_indices, strides, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["start_indices"] = (start_indices if (
    issubclass(type(start_indices), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(start_indices, context=_ods_context))
    attributes["limit_indices"] = (limit_indices if (
    issubclass(type(limit_indices), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(limit_indices, context=_ods_context))
    attributes["strides"] = (strides if (
    issubclass(type(strides), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(strides, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(SliceOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def start_indices(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["start_indices"])

  @start_indices.setter
  def start_indices(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["start_indices"] = value

  @builtins.property
  def limit_indices(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["limit_indices"])

  @limit_indices.setter
  def limit_indices(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["limit_indices"] = value

  @builtins.property
  def strides(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["strides"])

  @strides.setter
  def strides(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["strides"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class SortOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.sort"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, inputs, *, dimension=None, is_stable=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    if dimension is not None: attributes["dimension"] = (dimension if (
        issubclass(type(dimension), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(dimension, context=_ods_context))
    if is_stable is not None: attributes["is_stable"] = (is_stable if (
        issubclass(type(is_stable), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(is_stable, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def dimension(self):
    if "dimension" not in self.operation.attributes:
      return None
    return _ods_ir.IntegerAttr(self.operation.attributes["dimension"])

  @dimension.setter
  def dimension(self, value):
    if value is not None:
      self.operation.attributes["dimension"] = value
    elif "dimension" in self.operation.attributes:
      del self.operation.attributes["dimension"]

  @dimension.deleter
  def dimension(self):
    del self.operation.attributes["dimension"]

  @builtins.property
  def is_stable(self):
    if "is_stable" not in self.operation.attributes:
      return None
    return _ods_ir.BoolAttr(self.operation.attributes["is_stable"])

  @is_stable.setter
  def is_stable(self, value):
    if value is not None:
      self.operation.attributes["is_stable"] = value
    elif "is_stable" in self.operation.attributes:
      del self.operation.attributes["is_stable"]

  @is_stable.deleter
  def is_stable(self):
    del self.operation.attributes["is_stable"]

  @builtins.property
  def comparator(self):
    return self.regions[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class SqrtOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.sqrt"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(SqrtOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class SubtractOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.subtract"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(SubtractOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class TanhOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.tanh"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(TanhOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class TorchIndexSelectOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.torch_index_select"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, index, dim, batch_dims, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    operands.append(_get_op_result_or_value(index))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dim"] = (dim if (
    issubclass(type(dim), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(dim, context=_ods_context))
    attributes["batch_dims"] = (batch_dims if (
    issubclass(type(batch_dims), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(batch_dims, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def index(self):
    return self.operation.operands[1]

  @builtins.property
  def dim(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["dim"])

  @dim.setter
  def dim(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dim"] = value

  @builtins.property
  def batch_dims(self):
    return _ods_ir.IntegerAttr(self.operation.attributes["batch_dims"])

  @batch_dims.setter
  def batch_dims(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["batch_dims"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class TraceOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.trace"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, tag, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["tag"] = (tag if (
    issubclass(type(tag), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(tag, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def tag(self):
    return _ods_ir.StringAttr(self.operation.attributes["tag"])

  @tag.setter
  def tag(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["tag"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class TransposeOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.transpose"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, permutation, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["permutation"] = (permutation if (
    issubclass(type(permutation), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64ElementsAttr')) else
      _ods_ir.AttrBuilder.get('I64ElementsAttr')(permutation, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(TransposeOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def permutation(self):
    return _ods_ir.DenseIntElementsAttr(self.operation.attributes["permutation"])

  @permutation.setter
  def permutation(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["permutation"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class TriangularSolveOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.triangular_solve"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, left_side, lower, unit_diagonal, transpose_a, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(a))
    operands.append(_get_op_result_or_value(b))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["left_side"] = (left_side if (
    issubclass(type(left_side), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(left_side, context=_ods_context))
    attributes["lower"] = (lower if (
    issubclass(type(lower), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(lower, context=_ods_context))
    attributes["unit_diagonal"] = (unit_diagonal if (
    issubclass(type(unit_diagonal), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(unit_diagonal, context=_ods_context))
    attributes["transpose_a"] = (transpose_a if (
    issubclass(type(transpose_a), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StableHLO_TransposeAttr')) else
      _ods_ir.AttrBuilder.get('StableHLO_TransposeAttr')(transpose_a, context=_ods_context))
    results = _ods_ir.InferTypeOpInterface(TriangularSolveOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def a(self):
    return self.operation.operands[0]

  @builtins.property
  def b(self):
    return self.operation.operands[1]

  @builtins.property
  def left_side(self):
    return _ods_ir.BoolAttr(self.operation.attributes["left_side"])

  @left_side.setter
  def left_side(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["left_side"] = value

  @builtins.property
  def lower(self):
    return _ods_ir.BoolAttr(self.operation.attributes["lower"])

  @lower.setter
  def lower(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["lower"] = value

  @builtins.property
  def unit_diagonal(self):
    return _ods_ir.BoolAttr(self.operation.attributes["unit_diagonal"])

  @unit_diagonal.setter
  def unit_diagonal(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["unit_diagonal"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class TupleOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.tuple"

  _ODS_REGIONS = (0, True)

  def __init__(self, val, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(val))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(TupleOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def val(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class UnaryEinsumOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.unary_einsum"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, einsum_config, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["einsum_config"] = (einsum_config if (
    issubclass(type(einsum_config), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(einsum_config, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def einsum_config(self):
    return _ods_ir.StringAttr(self.operation.attributes["einsum_config"])

  @einsum_config.setter
  def einsum_config(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["einsum_config"] = value

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class UniformDequantizeOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.uniform_dequantize"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(UniformDequantizeOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class UniformQuantizeOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.uniform_quantize"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class WhileOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.while"

  _ODS_REGIONS = (2, True)

  def __init__(self, result, operand, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operand))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operand(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def cond(self):
    return self.regions[0]

  @builtins.property
  def body(self):
    return self.regions[1]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class XorOp(_ods_ir.OpView):
  OPERATION_NAME = "stablehlo.xor"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = _ods_ir.InferTypeOpInterface(XorOp).inferReturnTypes(
        operands=operands,
        attributes=_ods_ir.DictAttr.get(attributes, context=_ods_context),
        context=_ods_context,
        loc=loc)
    _ods_successors = None
    super().__init__(self.build_generic(
      attributes=attributes, results=results, operands=operands,
      successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]
