/**
* @file
* @brief Codata module - autogenerated.
*/

#if _MSC_VER & APIDLL
#define ADD_IMPORT __declspec(dllimport)
#define ADD_EXPORT __declspec(dllexport)
#else
#define ADD_IMPORT
#define ADD_EXPORT
#endif
ADD_IMPORT extern const int YEAR;

ADD_IMPORT extern const double ALPHA_PARTICLE_ELECTRON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_ALPHA_PARTICLE_ELECTRON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double ALPHA_PARTICLE_MASS;/**< kg */
ADD_IMPORT extern const double U_ALPHA_PARTICLE_MASS;/**< kg */

ADD_IMPORT extern const double ALPHA_PARTICLE_MASS_ENERGY_EQUIVALENT;/**< J */
ADD_IMPORT extern const double U_ALPHA_PARTICLE_MASS_ENERGY_EQUIVALENT;/**< J */

ADD_IMPORT extern const double ALPHA_PARTICLE_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */
ADD_IMPORT extern const double U_ALPHA_PARTICLE_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */

ADD_IMPORT extern const double ALPHA_PARTICLE_MASS_IN_U;/**< u */
ADD_IMPORT extern const double U_ALPHA_PARTICLE_MASS_IN_U;/**< u */

ADD_IMPORT extern const double ALPHA_PARTICLE_MOLAR_MASS;/**< kg mol^-1 */
ADD_IMPORT extern const double U_ALPHA_PARTICLE_MOLAR_MASS;/**< kg mol^-1 */

ADD_IMPORT extern const double ALPHA_PARTICLE_PROTON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_ALPHA_PARTICLE_PROTON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double ALPHA_PARTICLE_RELATIVE_ATOMIC_MASS;/**<   */
ADD_IMPORT extern const double U_ALPHA_PARTICLE_RELATIVE_ATOMIC_MASS;/**<   */

ADD_IMPORT extern const double ANGSTROM_STAR;/**< m */
ADD_IMPORT extern const double U_ANGSTROM_STAR;/**< m */

ADD_IMPORT extern const double ATOMIC_MASS_CONSTANT;/**< kg */
ADD_IMPORT extern const double U_ATOMIC_MASS_CONSTANT;/**< kg */

ADD_IMPORT extern const double ATOMIC_MASS_CONSTANT_ENERGY_EQUIVALENT;/**< J */
ADD_IMPORT extern const double U_ATOMIC_MASS_CONSTANT_ENERGY_EQUIVALENT;/**< J */

ADD_IMPORT extern const double ATOMIC_MASS_CONSTANT_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */
ADD_IMPORT extern const double U_ATOMIC_MASS_CONSTANT_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */

ADD_IMPORT extern const double ATOMIC_MASS_UNIT_ELECTRON_VOLT_RELATIONSHIP;/**< eV */
ADD_IMPORT extern const double U_ATOMIC_MASS_UNIT_ELECTRON_VOLT_RELATIONSHIP;/**< eV */

ADD_IMPORT extern const double ATOMIC_MASS_UNIT_HARTREE_RELATIONSHIP;/**< E_h */
ADD_IMPORT extern const double U_ATOMIC_MASS_UNIT_HARTREE_RELATIONSHIP;/**< E_h */

ADD_IMPORT extern const double ATOMIC_MASS_UNIT_HERTZ_RELATIONSHIP;/**< Hz */
ADD_IMPORT extern const double U_ATOMIC_MASS_UNIT_HERTZ_RELATIONSHIP;/**< Hz */

ADD_IMPORT extern const double ATOMIC_MASS_UNIT_INVERSE_METER_RELATIONSHIP;/**< m^-1 */
ADD_IMPORT extern const double U_ATOMIC_MASS_UNIT_INVERSE_METER_RELATIONSHIP;/**< m^-1 */

ADD_IMPORT extern const double ATOMIC_MASS_UNIT_JOULE_RELATIONSHIP;/**< J */
ADD_IMPORT extern const double U_ATOMIC_MASS_UNIT_JOULE_RELATIONSHIP;/**< J */

ADD_IMPORT extern const double ATOMIC_MASS_UNIT_KELVIN_RELATIONSHIP;/**< K */
ADD_IMPORT extern const double U_ATOMIC_MASS_UNIT_KELVIN_RELATIONSHIP;/**< K */

ADD_IMPORT extern const double ATOMIC_MASS_UNIT_KILOGRAM_RELATIONSHIP;/**< kg */
ADD_IMPORT extern const double U_ATOMIC_MASS_UNIT_KILOGRAM_RELATIONSHIP;/**< kg */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_1ST_HYPERPOLARIZABILITY;/**< C^3 m^3 J^-2 */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_1ST_HYPERPOLARIZABILITY;/**< C^3 m^3 J^-2 */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_2ND_HYPERPOLARIZABILITY;/**< C^4 m^4 J^-3 */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_2ND_HYPERPOLARIZABILITY;/**< C^4 m^4 J^-3 */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_ACTION;/**< J s */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_ACTION;/**< J s */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_CHARGE;/**< C */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_CHARGE;/**< C */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_CHARGE_DENSITY;/**< C m^-3 */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_CHARGE_DENSITY;/**< C m^-3 */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_CURRENT;/**< A */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_CURRENT;/**< A */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_ELECTRIC_DIPOLE_MOM;/**< C m */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_ELECTRIC_DIPOLE_MOM;/**< C m */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_ELECTRIC_FIELD;/**< V m^-1 */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_ELECTRIC_FIELD;/**< V m^-1 */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_ELECTRIC_FIELD_GRADIENT;/**< V m^-2 */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_ELECTRIC_FIELD_GRADIENT;/**< V m^-2 */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_ELECTRIC_POLARIZABILITY;/**< C^2 m^2 J^-1 */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_ELECTRIC_POLARIZABILITY;/**< C^2 m^2 J^-1 */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_ELECTRIC_POTENTIAL;/**< V */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_ELECTRIC_POTENTIAL;/**< V */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_ELECTRIC_QUADRUPOLE_MOM;/**< C m^2 */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_ELECTRIC_QUADRUPOLE_MOM;/**< C m^2 */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_ENERGY;/**< J */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_ENERGY;/**< J */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_FORCE;/**< N */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_FORCE;/**< N */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_LENGTH;/**< m */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_LENGTH;/**< m */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_MAG__DIPOLE_MOM;/**< J T^-1 */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_MAG__DIPOLE_MOM;/**< J T^-1 */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_MAG__FLUX_DENSITY;/**< T */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_MAG__FLUX_DENSITY;/**< T */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_MAGNETIZABILITY;/**< J T^-2 */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_MAGNETIZABILITY;/**< J T^-2 */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_MASS;/**< kg */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_MASS;/**< kg */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_MOMENTUM;/**< kg m s^-1 */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_MOMENTUM;/**< kg m s^-1 */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_PERMITTIVITY;/**< F m^-1 */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_PERMITTIVITY;/**< F m^-1 */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_TIME;/**< s */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_TIME;/**< s */

ADD_IMPORT extern const double ATOMIC_UNIT_OF_VELOCITY;/**< m s^-1 */
ADD_IMPORT extern const double U_ATOMIC_UNIT_OF_VELOCITY;/**< m s^-1 */

ADD_IMPORT extern const double AVOGADRO_CONSTANT;/**< mol^-1 */
ADD_IMPORT extern const double U_AVOGADRO_CONSTANT;/**< mol^-1 */

ADD_IMPORT extern const double BOHR_MAGNETON;/**< J T^-1 */
ADD_IMPORT extern const double U_BOHR_MAGNETON;/**< J T^-1 */

ADD_IMPORT extern const double BOHR_MAGNETON_IN_EV_T;/**< eV T^-1 */
ADD_IMPORT extern const double U_BOHR_MAGNETON_IN_EV_T;/**< eV T^-1 */

ADD_IMPORT extern const double BOHR_MAGNETON_IN_HZ_T;/**< Hz T^-1 */
ADD_IMPORT extern const double U_BOHR_MAGNETON_IN_HZ_T;/**< Hz T^-1 */

ADD_IMPORT extern const double BOHR_MAGNETON_IN_INVERSE_METER_PER_TESLA;/**< m^-1 T^-1 */
ADD_IMPORT extern const double U_BOHR_MAGNETON_IN_INVERSE_METER_PER_TESLA;/**< m^-1 T^-1 */

ADD_IMPORT extern const double BOHR_MAGNETON_IN_K_T;/**< K T^-1 */
ADD_IMPORT extern const double U_BOHR_MAGNETON_IN_K_T;/**< K T^-1 */

ADD_IMPORT extern const double BOHR_RADIUS;/**< m */
ADD_IMPORT extern const double U_BOHR_RADIUS;/**< m */

ADD_IMPORT extern const double BOLTZMANN_CONSTANT;/**< J K^-1 */
ADD_IMPORT extern const double U_BOLTZMANN_CONSTANT;/**< J K^-1 */

ADD_IMPORT extern const double BOLTZMANN_CONSTANT_IN_EV_K;/**< eV K^-1 */
ADD_IMPORT extern const double U_BOLTZMANN_CONSTANT_IN_EV_K;/**< eV K^-1 */

ADD_IMPORT extern const double BOLTZMANN_CONSTANT_IN_HZ_K;/**< Hz K^-1 */
ADD_IMPORT extern const double U_BOLTZMANN_CONSTANT_IN_HZ_K;/**< Hz K^-1 */

ADD_IMPORT extern const double BOLTZMANN_CONSTANT_IN_INVERSE_METER_PER_KELVIN;/**< m^-1 K^-1 */
ADD_IMPORT extern const double U_BOLTZMANN_CONSTANT_IN_INVERSE_METER_PER_KELVIN;/**< m^-1 K^-1 */

ADD_IMPORT extern const double CHARACTERISTIC_IMPEDANCE_OF_VACUUM;/**< ohm */
ADD_IMPORT extern const double U_CHARACTERISTIC_IMPEDANCE_OF_VACUUM;/**< ohm */

ADD_IMPORT extern const double CLASSICAL_ELECTRON_RADIUS;/**< m */
ADD_IMPORT extern const double U_CLASSICAL_ELECTRON_RADIUS;/**< m */

ADD_IMPORT extern const double COMPTON_WAVELENGTH;/**< m */
ADD_IMPORT extern const double U_COMPTON_WAVELENGTH;/**< m */

ADD_IMPORT extern const double CONDUCTANCE_QUANTUM;/**< S */
ADD_IMPORT extern const double U_CONDUCTANCE_QUANTUM;/**< S */

ADD_IMPORT extern const double CONVENTIONAL_VALUE_OF_AMPERE_90;/**< A */
ADD_IMPORT extern const double U_CONVENTIONAL_VALUE_OF_AMPERE_90;/**< A */

ADD_IMPORT extern const double CONVENTIONAL_VALUE_OF_COULOMB_90;/**< C */
ADD_IMPORT extern const double U_CONVENTIONAL_VALUE_OF_COULOMB_90;/**< C */

ADD_IMPORT extern const double CONVENTIONAL_VALUE_OF_FARAD_90;/**< F */
ADD_IMPORT extern const double U_CONVENTIONAL_VALUE_OF_FARAD_90;/**< F */

ADD_IMPORT extern const double CONVENTIONAL_VALUE_OF_HENRY_90;/**< H */
ADD_IMPORT extern const double U_CONVENTIONAL_VALUE_OF_HENRY_90;/**< H */

ADD_IMPORT extern const double CONVENTIONAL_VALUE_OF_JOSEPHSON_CONSTANT;/**< Hz V^-1 */
ADD_IMPORT extern const double U_CONVENTIONAL_VALUE_OF_JOSEPHSON_CONSTANT;/**< Hz V^-1 */

ADD_IMPORT extern const double CONVENTIONAL_VALUE_OF_OHM_90;/**< ohm */
ADD_IMPORT extern const double U_CONVENTIONAL_VALUE_OF_OHM_90;/**< ohm */

ADD_IMPORT extern const double CONVENTIONAL_VALUE_OF_VOLT_90;/**< V */
ADD_IMPORT extern const double U_CONVENTIONAL_VALUE_OF_VOLT_90;/**< V */

ADD_IMPORT extern const double CONVENTIONAL_VALUE_OF_VON_KLITZING_CONSTANT;/**< ohm */
ADD_IMPORT extern const double U_CONVENTIONAL_VALUE_OF_VON_KLITZING_CONSTANT;/**< ohm */

ADD_IMPORT extern const double CONVENTIONAL_VALUE_OF_WATT_90;/**< W */
ADD_IMPORT extern const double U_CONVENTIONAL_VALUE_OF_WATT_90;/**< W */

ADD_IMPORT extern const double COPPER_X_UNIT;/**< m */
ADD_IMPORT extern const double U_COPPER_X_UNIT;/**< m */

ADD_IMPORT extern const double DEUTERON_ELECTRON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_DEUTERON_ELECTRON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double DEUTERON_ELECTRON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_DEUTERON_ELECTRON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double DEUTERON_G_FACTOR;/**<   */
ADD_IMPORT extern const double U_DEUTERON_G_FACTOR;/**<   */

ADD_IMPORT extern const double DEUTERON_MAG__MOM;/**< J T^-1 */
ADD_IMPORT extern const double U_DEUTERON_MAG__MOM;/**< J T^-1 */

ADD_IMPORT extern const double DEUTERON_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_DEUTERON_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double DEUTERON_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_DEUTERON_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double DEUTERON_MASS;/**< kg */
ADD_IMPORT extern const double U_DEUTERON_MASS;/**< kg */

ADD_IMPORT extern const double DEUTERON_MASS_ENERGY_EQUIVALENT;/**< J */
ADD_IMPORT extern const double U_DEUTERON_MASS_ENERGY_EQUIVALENT;/**< J */

ADD_IMPORT extern const double DEUTERON_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */
ADD_IMPORT extern const double U_DEUTERON_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */

ADD_IMPORT extern const double DEUTERON_MASS_IN_U;/**< u */
ADD_IMPORT extern const double U_DEUTERON_MASS_IN_U;/**< u */

ADD_IMPORT extern const double DEUTERON_MOLAR_MASS;/**< kg mol^-1 */
ADD_IMPORT extern const double U_DEUTERON_MOLAR_MASS;/**< kg mol^-1 */

ADD_IMPORT extern const double DEUTERON_NEUTRON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_DEUTERON_NEUTRON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double DEUTERON_PROTON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_DEUTERON_PROTON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double DEUTERON_PROTON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_DEUTERON_PROTON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double DEUTERON_RELATIVE_ATOMIC_MASS;/**<   */
ADD_IMPORT extern const double U_DEUTERON_RELATIVE_ATOMIC_MASS;/**<   */

ADD_IMPORT extern const double DEUTERON_RMS_CHARGE_RADIUS;/**< m */
ADD_IMPORT extern const double U_DEUTERON_RMS_CHARGE_RADIUS;/**< m */

ADD_IMPORT extern const double ELECTRON_CHARGE_TO_MASS_QUOTIENT;/**< C kg^-1 */
ADD_IMPORT extern const double U_ELECTRON_CHARGE_TO_MASS_QUOTIENT;/**< C kg^-1 */

ADD_IMPORT extern const double ELECTRON_DEUTERON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_DEUTERON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_DEUTERON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_DEUTERON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_G_FACTOR;/**<   */
ADD_IMPORT extern const double U_ELECTRON_G_FACTOR;/**<   */

ADD_IMPORT extern const double ELECTRON_GYROMAG__RATIO;/**< s^-1 T^-1 */
ADD_IMPORT extern const double U_ELECTRON_GYROMAG__RATIO;/**< s^-1 T^-1 */

ADD_IMPORT extern const double ELECTRON_GYROMAG__RATIO_IN_MHZ_T;/**< MHz T^-1 */
ADD_IMPORT extern const double U_ELECTRON_GYROMAG__RATIO_IN_MHZ_T;/**< MHz T^-1 */

ADD_IMPORT extern const double ELECTRON_HELION_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_HELION_MASS_RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_MAG__MOM;/**< J T^-1 */
ADD_IMPORT extern const double U_ELECTRON_MAG__MOM;/**< J T^-1 */

ADD_IMPORT extern const double ELECTRON_MAG__MOM__ANOMALY;/**<   */
ADD_IMPORT extern const double U_ELECTRON_MAG__MOM__ANOMALY;/**<   */

ADD_IMPORT extern const double ELECTRON_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_MASS;/**< kg */
ADD_IMPORT extern const double U_ELECTRON_MASS;/**< kg */

ADD_IMPORT extern const double ELECTRON_MASS_ENERGY_EQUIVALENT;/**< J */
ADD_IMPORT extern const double U_ELECTRON_MASS_ENERGY_EQUIVALENT;/**< J */

ADD_IMPORT extern const double ELECTRON_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */
ADD_IMPORT extern const double U_ELECTRON_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */

ADD_IMPORT extern const double ELECTRON_MASS_IN_U;/**< u */
ADD_IMPORT extern const double U_ELECTRON_MASS_IN_U;/**< u */

ADD_IMPORT extern const double ELECTRON_MOLAR_MASS;/**< kg mol^-1 */
ADD_IMPORT extern const double U_ELECTRON_MOLAR_MASS;/**< kg mol^-1 */

ADD_IMPORT extern const double ELECTRON_MUON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_MUON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_MUON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_MUON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_NEUTRON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_NEUTRON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_NEUTRON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_NEUTRON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_PROTON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_PROTON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_PROTON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_PROTON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_RELATIVE_ATOMIC_MASS;/**<   */
ADD_IMPORT extern const double U_ELECTRON_RELATIVE_ATOMIC_MASS;/**<   */

ADD_IMPORT extern const double ELECTRON_TAU_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_TAU_MASS_RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_TO_ALPHA_PARTICLE_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_TO_ALPHA_PARTICLE_MASS_RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_TO_SHIELDED_HELION_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_TO_SHIELDED_HELION_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_TO_SHIELDED_PROTON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_TO_SHIELDED_PROTON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_TRITON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_ELECTRON_TRITON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double ELECTRON_VOLT;/**< J */
ADD_IMPORT extern const double U_ELECTRON_VOLT;/**< J */

ADD_IMPORT extern const double ELECTRON_VOLT_ATOMIC_MASS_UNIT_RELATIONSHIP;/**< u */
ADD_IMPORT extern const double U_ELECTRON_VOLT_ATOMIC_MASS_UNIT_RELATIONSHIP;/**< u */

ADD_IMPORT extern const double ELECTRON_VOLT_HARTREE_RELATIONSHIP;/**< E_h */
ADD_IMPORT extern const double U_ELECTRON_VOLT_HARTREE_RELATIONSHIP;/**< E_h */

ADD_IMPORT extern const double ELECTRON_VOLT_HERTZ_RELATIONSHIP;/**< Hz */
ADD_IMPORT extern const double U_ELECTRON_VOLT_HERTZ_RELATIONSHIP;/**< Hz */

ADD_IMPORT extern const double ELECTRON_VOLT_INVERSE_METER_RELATIONSHIP;/**< m^-1 */
ADD_IMPORT extern const double U_ELECTRON_VOLT_INVERSE_METER_RELATIONSHIP;/**< m^-1 */

ADD_IMPORT extern const double ELECTRON_VOLT_JOULE_RELATIONSHIP;/**< J */
ADD_IMPORT extern const double U_ELECTRON_VOLT_JOULE_RELATIONSHIP;/**< J */

ADD_IMPORT extern const double ELECTRON_VOLT_KELVIN_RELATIONSHIP;/**< K */
ADD_IMPORT extern const double U_ELECTRON_VOLT_KELVIN_RELATIONSHIP;/**< K */

ADD_IMPORT extern const double ELECTRON_VOLT_KILOGRAM_RELATIONSHIP;/**< kg */
ADD_IMPORT extern const double U_ELECTRON_VOLT_KILOGRAM_RELATIONSHIP;/**< kg */

ADD_IMPORT extern const double ELEMENTARY_CHARGE;/**< C */
ADD_IMPORT extern const double U_ELEMENTARY_CHARGE;/**< C */

ADD_IMPORT extern const double ELEMENTARY_CHARGE_OVER_H_BAR;/**< A J^-1 */
ADD_IMPORT extern const double U_ELEMENTARY_CHARGE_OVER_H_BAR;/**< A J^-1 */

ADD_IMPORT extern const double FARADAY_CONSTANT;/**< C mol^-1 */
ADD_IMPORT extern const double U_FARADAY_CONSTANT;/**< C mol^-1 */

ADD_IMPORT extern const double FERMI_COUPLING_CONSTANT;/**< GeV^-2 */
ADD_IMPORT extern const double U_FERMI_COUPLING_CONSTANT;/**< GeV^-2 */

ADD_IMPORT extern const double FINE_STRUCTURE_CONSTANT;/**<   */
ADD_IMPORT extern const double U_FINE_STRUCTURE_CONSTANT;/**<   */

ADD_IMPORT extern const double FIRST_RADIATION_CONSTANT;/**< W m^2 */
ADD_IMPORT extern const double U_FIRST_RADIATION_CONSTANT;/**< W m^2 */

ADD_IMPORT extern const double FIRST_RADIATION_CONSTANT_FOR_SPECTRAL_RADIANCE;/**< W m^2 sr^-1 */
ADD_IMPORT extern const double U_FIRST_RADIATION_CONSTANT_FOR_SPECTRAL_RADIANCE;/**< W m^2 sr^-1 */

ADD_IMPORT extern const double HARTREE_ATOMIC_MASS_UNIT_RELATIONSHIP;/**< u */
ADD_IMPORT extern const double U_HARTREE_ATOMIC_MASS_UNIT_RELATIONSHIP;/**< u */

ADD_IMPORT extern const double HARTREE_ELECTRON_VOLT_RELATIONSHIP;/**< eV */
ADD_IMPORT extern const double U_HARTREE_ELECTRON_VOLT_RELATIONSHIP;/**< eV */

ADD_IMPORT extern const double HARTREE_ENERGY;/**< J */
ADD_IMPORT extern const double U_HARTREE_ENERGY;/**< J */

ADD_IMPORT extern const double HARTREE_ENERGY_IN_EV;/**< eV */
ADD_IMPORT extern const double U_HARTREE_ENERGY_IN_EV;/**< eV */

ADD_IMPORT extern const double HARTREE_HERTZ_RELATIONSHIP;/**< Hz */
ADD_IMPORT extern const double U_HARTREE_HERTZ_RELATIONSHIP;/**< Hz */

ADD_IMPORT extern const double HARTREE_INVERSE_METER_RELATIONSHIP;/**< m^-1 */
ADD_IMPORT extern const double U_HARTREE_INVERSE_METER_RELATIONSHIP;/**< m^-1 */

ADD_IMPORT extern const double HARTREE_JOULE_RELATIONSHIP;/**< J */
ADD_IMPORT extern const double U_HARTREE_JOULE_RELATIONSHIP;/**< J */

ADD_IMPORT extern const double HARTREE_KELVIN_RELATIONSHIP;/**< K */
ADD_IMPORT extern const double U_HARTREE_KELVIN_RELATIONSHIP;/**< K */

ADD_IMPORT extern const double HARTREE_KILOGRAM_RELATIONSHIP;/**< kg */
ADD_IMPORT extern const double U_HARTREE_KILOGRAM_RELATIONSHIP;/**< kg */

ADD_IMPORT extern const double HELION_ELECTRON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_HELION_ELECTRON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double HELION_G_FACTOR;/**<   */
ADD_IMPORT extern const double U_HELION_G_FACTOR;/**<   */

ADD_IMPORT extern const double HELION_MAG__MOM;/**< J T^-1 */
ADD_IMPORT extern const double U_HELION_MAG__MOM;/**< J T^-1 */

ADD_IMPORT extern const double HELION_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_HELION_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double HELION_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_HELION_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double HELION_MASS;/**< kg */
ADD_IMPORT extern const double U_HELION_MASS;/**< kg */

ADD_IMPORT extern const double HELION_MASS_ENERGY_EQUIVALENT;/**< J */
ADD_IMPORT extern const double U_HELION_MASS_ENERGY_EQUIVALENT;/**< J */

ADD_IMPORT extern const double HELION_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */
ADD_IMPORT extern const double U_HELION_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */

ADD_IMPORT extern const double HELION_MASS_IN_U;/**< u */
ADD_IMPORT extern const double U_HELION_MASS_IN_U;/**< u */

ADD_IMPORT extern const double HELION_MOLAR_MASS;/**< kg mol^-1 */
ADD_IMPORT extern const double U_HELION_MOLAR_MASS;/**< kg mol^-1 */

ADD_IMPORT extern const double HELION_PROTON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_HELION_PROTON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double HELION_RELATIVE_ATOMIC_MASS;/**<   */
ADD_IMPORT extern const double U_HELION_RELATIVE_ATOMIC_MASS;/**<   */

ADD_IMPORT extern const double HELION_SHIELDING_SHIFT;/**<   */
ADD_IMPORT extern const double U_HELION_SHIELDING_SHIFT;/**<   */

ADD_IMPORT extern const double HERTZ_ATOMIC_MASS_UNIT_RELATIONSHIP;/**< u */
ADD_IMPORT extern const double U_HERTZ_ATOMIC_MASS_UNIT_RELATIONSHIP;/**< u */

ADD_IMPORT extern const double HERTZ_ELECTRON_VOLT_RELATIONSHIP;/**< eV */
ADD_IMPORT extern const double U_HERTZ_ELECTRON_VOLT_RELATIONSHIP;/**< eV */

ADD_IMPORT extern const double HERTZ_HARTREE_RELATIONSHIP;/**< E_h */
ADD_IMPORT extern const double U_HERTZ_HARTREE_RELATIONSHIP;/**< E_h */

ADD_IMPORT extern const double HERTZ_INVERSE_METER_RELATIONSHIP;/**< m^-1 */
ADD_IMPORT extern const double U_HERTZ_INVERSE_METER_RELATIONSHIP;/**< m^-1 */

ADD_IMPORT extern const double HERTZ_JOULE_RELATIONSHIP;/**< J */
ADD_IMPORT extern const double U_HERTZ_JOULE_RELATIONSHIP;/**< J */

ADD_IMPORT extern const double HERTZ_KELVIN_RELATIONSHIP;/**< K */
ADD_IMPORT extern const double U_HERTZ_KELVIN_RELATIONSHIP;/**< K */

ADD_IMPORT extern const double HERTZ_KILOGRAM_RELATIONSHIP;/**< kg */
ADD_IMPORT extern const double U_HERTZ_KILOGRAM_RELATIONSHIP;/**< kg */

ADD_IMPORT extern const double HYPERFINE_TRANSITION_FREQUENCY_OF_CS_133;/**< Hz */
ADD_IMPORT extern const double U_HYPERFINE_TRANSITION_FREQUENCY_OF_CS_133;/**< Hz */

ADD_IMPORT extern const double INVERSE_FINE_STRUCTURE_CONSTANT;/**<   */
ADD_IMPORT extern const double U_INVERSE_FINE_STRUCTURE_CONSTANT;/**<   */

ADD_IMPORT extern const double INVERSE_METER_ATOMIC_MASS_UNIT_RELATIONSHIP;/**< u */
ADD_IMPORT extern const double U_INVERSE_METER_ATOMIC_MASS_UNIT_RELATIONSHIP;/**< u */

ADD_IMPORT extern const double INVERSE_METER_ELECTRON_VOLT_RELATIONSHIP;/**< eV */
ADD_IMPORT extern const double U_INVERSE_METER_ELECTRON_VOLT_RELATIONSHIP;/**< eV */

ADD_IMPORT extern const double INVERSE_METER_HARTREE_RELATIONSHIP;/**< E_h */
ADD_IMPORT extern const double U_INVERSE_METER_HARTREE_RELATIONSHIP;/**< E_h */

ADD_IMPORT extern const double INVERSE_METER_HERTZ_RELATIONSHIP;/**< Hz */
ADD_IMPORT extern const double U_INVERSE_METER_HERTZ_RELATIONSHIP;/**< Hz */

ADD_IMPORT extern const double INVERSE_METER_JOULE_RELATIONSHIP;/**< J */
ADD_IMPORT extern const double U_INVERSE_METER_JOULE_RELATIONSHIP;/**< J */

ADD_IMPORT extern const double INVERSE_METER_KELVIN_RELATIONSHIP;/**< K */
ADD_IMPORT extern const double U_INVERSE_METER_KELVIN_RELATIONSHIP;/**< K */

ADD_IMPORT extern const double INVERSE_METER_KILOGRAM_RELATIONSHIP;/**< kg */
ADD_IMPORT extern const double U_INVERSE_METER_KILOGRAM_RELATIONSHIP;/**< kg */

ADD_IMPORT extern const double INVERSE_OF_CONDUCTANCE_QUANTUM;/**< ohm */
ADD_IMPORT extern const double U_INVERSE_OF_CONDUCTANCE_QUANTUM;/**< ohm */

ADD_IMPORT extern const double JOSEPHSON_CONSTANT;/**< Hz V^-1 */
ADD_IMPORT extern const double U_JOSEPHSON_CONSTANT;/**< Hz V^-1 */

ADD_IMPORT extern const double JOULE_ATOMIC_MASS_UNIT_RELATIONSHIP;/**< u */
ADD_IMPORT extern const double U_JOULE_ATOMIC_MASS_UNIT_RELATIONSHIP;/**< u */

ADD_IMPORT extern const double JOULE_ELECTRON_VOLT_RELATIONSHIP;/**< eV */
ADD_IMPORT extern const double U_JOULE_ELECTRON_VOLT_RELATIONSHIP;/**< eV */

ADD_IMPORT extern const double JOULE_HARTREE_RELATIONSHIP;/**< E_h */
ADD_IMPORT extern const double U_JOULE_HARTREE_RELATIONSHIP;/**< E_h */

ADD_IMPORT extern const double JOULE_HERTZ_RELATIONSHIP;/**< Hz */
ADD_IMPORT extern const double U_JOULE_HERTZ_RELATIONSHIP;/**< Hz */

ADD_IMPORT extern const double JOULE_INVERSE_METER_RELATIONSHIP;/**< m^-1 */
ADD_IMPORT extern const double U_JOULE_INVERSE_METER_RELATIONSHIP;/**< m^-1 */

ADD_IMPORT extern const double JOULE_KELVIN_RELATIONSHIP;/**< K */
ADD_IMPORT extern const double U_JOULE_KELVIN_RELATIONSHIP;/**< K */

ADD_IMPORT extern const double JOULE_KILOGRAM_RELATIONSHIP;/**< kg */
ADD_IMPORT extern const double U_JOULE_KILOGRAM_RELATIONSHIP;/**< kg */

ADD_IMPORT extern const double KELVIN_ATOMIC_MASS_UNIT_RELATIONSHIP;/**< u */
ADD_IMPORT extern const double U_KELVIN_ATOMIC_MASS_UNIT_RELATIONSHIP;/**< u */

ADD_IMPORT extern const double KELVIN_ELECTRON_VOLT_RELATIONSHIP;/**< eV */
ADD_IMPORT extern const double U_KELVIN_ELECTRON_VOLT_RELATIONSHIP;/**< eV */

ADD_IMPORT extern const double KELVIN_HARTREE_RELATIONSHIP;/**< E_h */
ADD_IMPORT extern const double U_KELVIN_HARTREE_RELATIONSHIP;/**< E_h */

ADD_IMPORT extern const double KELVIN_HERTZ_RELATIONSHIP;/**< Hz */
ADD_IMPORT extern const double U_KELVIN_HERTZ_RELATIONSHIP;/**< Hz */

ADD_IMPORT extern const double KELVIN_INVERSE_METER_RELATIONSHIP;/**< m^-1 */
ADD_IMPORT extern const double U_KELVIN_INVERSE_METER_RELATIONSHIP;/**< m^-1 */

ADD_IMPORT extern const double KELVIN_JOULE_RELATIONSHIP;/**< J */
ADD_IMPORT extern const double U_KELVIN_JOULE_RELATIONSHIP;/**< J */

ADD_IMPORT extern const double KELVIN_KILOGRAM_RELATIONSHIP;/**< kg */
ADD_IMPORT extern const double U_KELVIN_KILOGRAM_RELATIONSHIP;/**< kg */

ADD_IMPORT extern const double KILOGRAM_ATOMIC_MASS_UNIT_RELATIONSHIP;/**< u */
ADD_IMPORT extern const double U_KILOGRAM_ATOMIC_MASS_UNIT_RELATIONSHIP;/**< u */

ADD_IMPORT extern const double KILOGRAM_ELECTRON_VOLT_RELATIONSHIP;/**< eV */
ADD_IMPORT extern const double U_KILOGRAM_ELECTRON_VOLT_RELATIONSHIP;/**< eV */

ADD_IMPORT extern const double KILOGRAM_HARTREE_RELATIONSHIP;/**< E_h */
ADD_IMPORT extern const double U_KILOGRAM_HARTREE_RELATIONSHIP;/**< E_h */

ADD_IMPORT extern const double KILOGRAM_HERTZ_RELATIONSHIP;/**< Hz */
ADD_IMPORT extern const double U_KILOGRAM_HERTZ_RELATIONSHIP;/**< Hz */

ADD_IMPORT extern const double KILOGRAM_INVERSE_METER_RELATIONSHIP;/**< m^-1 */
ADD_IMPORT extern const double U_KILOGRAM_INVERSE_METER_RELATIONSHIP;/**< m^-1 */

ADD_IMPORT extern const double KILOGRAM_JOULE_RELATIONSHIP;/**< J */
ADD_IMPORT extern const double U_KILOGRAM_JOULE_RELATIONSHIP;/**< J */

ADD_IMPORT extern const double KILOGRAM_KELVIN_RELATIONSHIP;/**< K */
ADD_IMPORT extern const double U_KILOGRAM_KELVIN_RELATIONSHIP;/**< K */

ADD_IMPORT extern const double LATTICE_PARAMETER_OF_SILICON;/**< m */
ADD_IMPORT extern const double U_LATTICE_PARAMETER_OF_SILICON;/**< m */

ADD_IMPORT extern const double LATTICE_SPACING_OF_IDEAL_SI__220;/**< m */
ADD_IMPORT extern const double U_LATTICE_SPACING_OF_IDEAL_SI__220;/**< m */

ADD_IMPORT extern const double LOSCHMIDT_CONSTANT__273_15_K__100_KPA;/**< m^-3 */
ADD_IMPORT extern const double U_LOSCHMIDT_CONSTANT__273_15_K__100_KPA;/**< m^-3 */

ADD_IMPORT extern const double LOSCHMIDT_CONSTANT__273_15_K__101_325_KPA;/**< m^-3 */
ADD_IMPORT extern const double U_LOSCHMIDT_CONSTANT__273_15_K__101_325_KPA;/**< m^-3 */

ADD_IMPORT extern const double LUMINOUS_EFFICACY;/**< lm W^-1 */
ADD_IMPORT extern const double U_LUMINOUS_EFFICACY;/**< lm W^-1 */

ADD_IMPORT extern const double MAG__FLUX_QUANTUM;/**< Wb */
ADD_IMPORT extern const double U_MAG__FLUX_QUANTUM;/**< Wb */

ADD_IMPORT extern const double MOLAR_GAS_CONSTANT;/**< J mol^-1 K^-1 */
ADD_IMPORT extern const double U_MOLAR_GAS_CONSTANT;/**< J mol^-1 K^-1 */

ADD_IMPORT extern const double MOLAR_MASS_CONSTANT;/**< kg mol^-1 */
ADD_IMPORT extern const double U_MOLAR_MASS_CONSTANT;/**< kg mol^-1 */

ADD_IMPORT extern const double MOLAR_MASS_OF_CARBON_12;/**< kg mol^-1 */
ADD_IMPORT extern const double U_MOLAR_MASS_OF_CARBON_12;/**< kg mol^-1 */

ADD_IMPORT extern const double MOLAR_PLANCK_CONSTANT;/**< J Hz^-1 mol^-1 */
ADD_IMPORT extern const double U_MOLAR_PLANCK_CONSTANT;/**< J Hz^-1 mol^-1 */

ADD_IMPORT extern const double MOLAR_VOLUME_OF_IDEAL_GAS__273_15_K__100_KPA;/**< m^3 mol^-1 */
ADD_IMPORT extern const double U_MOLAR_VOLUME_OF_IDEAL_GAS__273_15_K__100_KPA;/**< m^3 mol^-1 */

ADD_IMPORT extern const double MOLAR_VOLUME_OF_IDEAL_GAS__273_15_K__101_325_KPA;/**< m^3 mol^-1 */
ADD_IMPORT extern const double U_MOLAR_VOLUME_OF_IDEAL_GAS__273_15_K__101_325_KPA;/**< m^3 mol^-1 */

ADD_IMPORT extern const double MOLAR_VOLUME_OF_SILICON;/**< m^3 mol^-1 */
ADD_IMPORT extern const double U_MOLAR_VOLUME_OF_SILICON;/**< m^3 mol^-1 */

ADD_IMPORT extern const double MOLYBDENUM_X_UNIT;/**< m */
ADD_IMPORT extern const double U_MOLYBDENUM_X_UNIT;/**< m */

ADD_IMPORT extern const double MUON_COMPTON_WAVELENGTH;/**< m */
ADD_IMPORT extern const double U_MUON_COMPTON_WAVELENGTH;/**< m */

ADD_IMPORT extern const double MUON_ELECTRON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_MUON_ELECTRON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double MUON_G_FACTOR;/**<   */
ADD_IMPORT extern const double U_MUON_G_FACTOR;/**<   */

ADD_IMPORT extern const double MUON_MAG__MOM;/**< J T^-1 */
ADD_IMPORT extern const double U_MUON_MAG__MOM;/**< J T^-1 */

ADD_IMPORT extern const double MUON_MAG__MOM__ANOMALY;/**<   */
ADD_IMPORT extern const double U_MUON_MAG__MOM__ANOMALY;/**<   */

ADD_IMPORT extern const double MUON_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_MUON_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double MUON_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_MUON_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double MUON_MASS;/**< kg */
ADD_IMPORT extern const double U_MUON_MASS;/**< kg */

ADD_IMPORT extern const double MUON_MASS_ENERGY_EQUIVALENT;/**< J */
ADD_IMPORT extern const double U_MUON_MASS_ENERGY_EQUIVALENT;/**< J */

ADD_IMPORT extern const double MUON_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */
ADD_IMPORT extern const double U_MUON_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */

ADD_IMPORT extern const double MUON_MASS_IN_U;/**< u */
ADD_IMPORT extern const double U_MUON_MASS_IN_U;/**< u */

ADD_IMPORT extern const double MUON_MOLAR_MASS;/**< kg mol^-1 */
ADD_IMPORT extern const double U_MUON_MOLAR_MASS;/**< kg mol^-1 */

ADD_IMPORT extern const double MUON_NEUTRON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_MUON_NEUTRON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double MUON_PROTON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_MUON_PROTON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double MUON_PROTON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_MUON_PROTON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double MUON_TAU_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_MUON_TAU_MASS_RATIO;/**<   */

ADD_IMPORT extern const double NATURAL_UNIT_OF_ACTION;/**< J s */
ADD_IMPORT extern const double U_NATURAL_UNIT_OF_ACTION;/**< J s */

ADD_IMPORT extern const double NATURAL_UNIT_OF_ACTION_IN_EV_S;/**< eV s */
ADD_IMPORT extern const double U_NATURAL_UNIT_OF_ACTION_IN_EV_S;/**< eV s */

ADD_IMPORT extern const double NATURAL_UNIT_OF_ENERGY;/**< J */
ADD_IMPORT extern const double U_NATURAL_UNIT_OF_ENERGY;/**< J */

ADD_IMPORT extern const double NATURAL_UNIT_OF_ENERGY_IN_MEV;/**< MeV */
ADD_IMPORT extern const double U_NATURAL_UNIT_OF_ENERGY_IN_MEV;/**< MeV */

ADD_IMPORT extern const double NATURAL_UNIT_OF_LENGTH;/**< m */
ADD_IMPORT extern const double U_NATURAL_UNIT_OF_LENGTH;/**< m */

ADD_IMPORT extern const double NATURAL_UNIT_OF_MASS;/**< kg */
ADD_IMPORT extern const double U_NATURAL_UNIT_OF_MASS;/**< kg */

ADD_IMPORT extern const double NATURAL_UNIT_OF_MOMENTUM;/**< kg m s^-1 */
ADD_IMPORT extern const double U_NATURAL_UNIT_OF_MOMENTUM;/**< kg m s^-1 */

ADD_IMPORT extern const double NATURAL_UNIT_OF_MOMENTUM_IN_MEV_C;/**< MeV/c */
ADD_IMPORT extern const double U_NATURAL_UNIT_OF_MOMENTUM_IN_MEV_C;/**< MeV/c */

ADD_IMPORT extern const double NATURAL_UNIT_OF_TIME;/**< s */
ADD_IMPORT extern const double U_NATURAL_UNIT_OF_TIME;/**< s */

ADD_IMPORT extern const double NATURAL_UNIT_OF_VELOCITY;/**< m s^-1 */
ADD_IMPORT extern const double U_NATURAL_UNIT_OF_VELOCITY;/**< m s^-1 */

ADD_IMPORT extern const double NEUTRON_COMPTON_WAVELENGTH;/**< m */
ADD_IMPORT extern const double U_NEUTRON_COMPTON_WAVELENGTH;/**< m */

ADD_IMPORT extern const double NEUTRON_ELECTRON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_NEUTRON_ELECTRON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double NEUTRON_ELECTRON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_NEUTRON_ELECTRON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double NEUTRON_G_FACTOR;/**<   */
ADD_IMPORT extern const double U_NEUTRON_G_FACTOR;/**<   */

ADD_IMPORT extern const double NEUTRON_GYROMAG__RATIO;/**< s^-1 T^-1 */
ADD_IMPORT extern const double U_NEUTRON_GYROMAG__RATIO;/**< s^-1 T^-1 */

ADD_IMPORT extern const double NEUTRON_GYROMAG__RATIO_IN_MHZ_T;/**< MHz T^-1 */
ADD_IMPORT extern const double U_NEUTRON_GYROMAG__RATIO_IN_MHZ_T;/**< MHz T^-1 */

ADD_IMPORT extern const double NEUTRON_MAG__MOM;/**< J T^-1 */
ADD_IMPORT extern const double U_NEUTRON_MAG__MOM;/**< J T^-1 */

ADD_IMPORT extern const double NEUTRON_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_NEUTRON_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double NEUTRON_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_NEUTRON_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double NEUTRON_MASS;/**< kg */
ADD_IMPORT extern const double U_NEUTRON_MASS;/**< kg */

ADD_IMPORT extern const double NEUTRON_MASS_ENERGY_EQUIVALENT;/**< J */
ADD_IMPORT extern const double U_NEUTRON_MASS_ENERGY_EQUIVALENT;/**< J */

ADD_IMPORT extern const double NEUTRON_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */
ADD_IMPORT extern const double U_NEUTRON_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */

ADD_IMPORT extern const double NEUTRON_MASS_IN_U;/**< u */
ADD_IMPORT extern const double U_NEUTRON_MASS_IN_U;/**< u */

ADD_IMPORT extern const double NEUTRON_MOLAR_MASS;/**< kg mol^-1 */
ADD_IMPORT extern const double U_NEUTRON_MOLAR_MASS;/**< kg mol^-1 */

ADD_IMPORT extern const double NEUTRON_MUON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_NEUTRON_MUON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double NEUTRON_PROTON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_NEUTRON_PROTON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double NEUTRON_PROTON_MASS_DIFFERENCE;/**< kg */
ADD_IMPORT extern const double U_NEUTRON_PROTON_MASS_DIFFERENCE;/**< kg */

ADD_IMPORT extern const double NEUTRON_PROTON_MASS_DIFFERENCE_ENERGY_EQUIVALENT;/**< J */
ADD_IMPORT extern const double U_NEUTRON_PROTON_MASS_DIFFERENCE_ENERGY_EQUIVALENT;/**< J */

ADD_IMPORT extern const double NEUTRON_PROTON_MASS_DIFFERENCE_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */
ADD_IMPORT extern const double U_NEUTRON_PROTON_MASS_DIFFERENCE_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */

ADD_IMPORT extern const double NEUTRON_PROTON_MASS_DIFFERENCE_IN_U;/**< u */
ADD_IMPORT extern const double U_NEUTRON_PROTON_MASS_DIFFERENCE_IN_U;/**< u */

ADD_IMPORT extern const double NEUTRON_PROTON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_NEUTRON_PROTON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double NEUTRON_RELATIVE_ATOMIC_MASS;/**<   */
ADD_IMPORT extern const double U_NEUTRON_RELATIVE_ATOMIC_MASS;/**<   */

ADD_IMPORT extern const double NEUTRON_TAU_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_NEUTRON_TAU_MASS_RATIO;/**<   */

ADD_IMPORT extern const double NEUTRON_TO_SHIELDED_PROTON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_NEUTRON_TO_SHIELDED_PROTON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double NEWTONIAN_CONSTANT_OF_GRAVITATION;/**< m^3 kg^-1 s^-2 */
ADD_IMPORT extern const double U_NEWTONIAN_CONSTANT_OF_GRAVITATION;/**< m^3 kg^-1 s^-2 */

ADD_IMPORT extern const double NEWTONIAN_CONSTANT_OF_GRAVITATION_OVER_H_BAR_C;/**< (GeV/c^2)^-2 */
ADD_IMPORT extern const double U_NEWTONIAN_CONSTANT_OF_GRAVITATION_OVER_H_BAR_C;/**< (GeV/c^2)^-2 */

ADD_IMPORT extern const double NUCLEAR_MAGNETON;/**< J T^-1 */
ADD_IMPORT extern const double U_NUCLEAR_MAGNETON;/**< J T^-1 */

ADD_IMPORT extern const double NUCLEAR_MAGNETON_IN_EV_T;/**< eV T^-1 */
ADD_IMPORT extern const double U_NUCLEAR_MAGNETON_IN_EV_T;/**< eV T^-1 */

ADD_IMPORT extern const double NUCLEAR_MAGNETON_IN_INVERSE_METER_PER_TESLA;/**< m^-1 T^-1 */
ADD_IMPORT extern const double U_NUCLEAR_MAGNETON_IN_INVERSE_METER_PER_TESLA;/**< m^-1 T^-1 */

ADD_IMPORT extern const double NUCLEAR_MAGNETON_IN_K_T;/**< K T^-1 */
ADD_IMPORT extern const double U_NUCLEAR_MAGNETON_IN_K_T;/**< K T^-1 */

ADD_IMPORT extern const double NUCLEAR_MAGNETON_IN_MHZ_T;/**< MHz T^-1 */
ADD_IMPORT extern const double U_NUCLEAR_MAGNETON_IN_MHZ_T;/**< MHz T^-1 */

ADD_IMPORT extern const double PLANCK_CONSTANT;/**< J Hz^-1 */
ADD_IMPORT extern const double U_PLANCK_CONSTANT;/**< J Hz^-1 */

ADD_IMPORT extern const double PLANCK_CONSTANT_IN_EV_HZ;/**< eV Hz^-1 */
ADD_IMPORT extern const double U_PLANCK_CONSTANT_IN_EV_HZ;/**< eV Hz^-1 */

ADD_IMPORT extern const double PLANCK_LENGTH;/**< m */
ADD_IMPORT extern const double U_PLANCK_LENGTH;/**< m */

ADD_IMPORT extern const double PLANCK_MASS;/**< kg */
ADD_IMPORT extern const double U_PLANCK_MASS;/**< kg */

ADD_IMPORT extern const double PLANCK_MASS_ENERGY_EQUIVALENT_IN_GEV;/**< GeV */
ADD_IMPORT extern const double U_PLANCK_MASS_ENERGY_EQUIVALENT_IN_GEV;/**< GeV */

ADD_IMPORT extern const double PLANCK_TEMPERATURE;/**< K */
ADD_IMPORT extern const double U_PLANCK_TEMPERATURE;/**< K */

ADD_IMPORT extern const double PLANCK_TIME;/**< s */
ADD_IMPORT extern const double U_PLANCK_TIME;/**< s */

ADD_IMPORT extern const double PROTON_CHARGE_TO_MASS_QUOTIENT;/**< C kg^-1 */
ADD_IMPORT extern const double U_PROTON_CHARGE_TO_MASS_QUOTIENT;/**< C kg^-1 */

ADD_IMPORT extern const double PROTON_COMPTON_WAVELENGTH;/**< m */
ADD_IMPORT extern const double U_PROTON_COMPTON_WAVELENGTH;/**< m */

ADD_IMPORT extern const double PROTON_ELECTRON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_PROTON_ELECTRON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double PROTON_G_FACTOR;/**<   */
ADD_IMPORT extern const double U_PROTON_G_FACTOR;/**<   */

ADD_IMPORT extern const double PROTON_GYROMAG__RATIO;/**< s^-1 T^-1 */
ADD_IMPORT extern const double U_PROTON_GYROMAG__RATIO;/**< s^-1 T^-1 */

ADD_IMPORT extern const double PROTON_GYROMAG__RATIO_IN_MHZ_T;/**< MHz T^-1 */
ADD_IMPORT extern const double U_PROTON_GYROMAG__RATIO_IN_MHZ_T;/**< MHz T^-1 */

ADD_IMPORT extern const double PROTON_MAG__MOM;/**< J T^-1 */
ADD_IMPORT extern const double U_PROTON_MAG__MOM;/**< J T^-1 */

ADD_IMPORT extern const double PROTON_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_PROTON_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double PROTON_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_PROTON_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double PROTON_MAG__SHIELDING_CORRECTION;/**<   */
ADD_IMPORT extern const double U_PROTON_MAG__SHIELDING_CORRECTION;/**<   */

ADD_IMPORT extern const double PROTON_MASS;/**< kg */
ADD_IMPORT extern const double U_PROTON_MASS;/**< kg */

ADD_IMPORT extern const double PROTON_MASS_ENERGY_EQUIVALENT;/**< J */
ADD_IMPORT extern const double U_PROTON_MASS_ENERGY_EQUIVALENT;/**< J */

ADD_IMPORT extern const double PROTON_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */
ADD_IMPORT extern const double U_PROTON_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */

ADD_IMPORT extern const double PROTON_MASS_IN_U;/**< u */
ADD_IMPORT extern const double U_PROTON_MASS_IN_U;/**< u */

ADD_IMPORT extern const double PROTON_MOLAR_MASS;/**< kg mol^-1 */
ADD_IMPORT extern const double U_PROTON_MOLAR_MASS;/**< kg mol^-1 */

ADD_IMPORT extern const double PROTON_MUON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_PROTON_MUON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double PROTON_NEUTRON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_PROTON_NEUTRON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double PROTON_NEUTRON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_PROTON_NEUTRON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double PROTON_RELATIVE_ATOMIC_MASS;/**<   */
ADD_IMPORT extern const double U_PROTON_RELATIVE_ATOMIC_MASS;/**<   */

ADD_IMPORT extern const double PROTON_RMS_CHARGE_RADIUS;/**< m */
ADD_IMPORT extern const double U_PROTON_RMS_CHARGE_RADIUS;/**< m */

ADD_IMPORT extern const double PROTON_TAU_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_PROTON_TAU_MASS_RATIO;/**<   */

ADD_IMPORT extern const double QUANTUM_OF_CIRCULATION;/**< m^2 s^-1 */
ADD_IMPORT extern const double U_QUANTUM_OF_CIRCULATION;/**< m^2 s^-1 */

ADD_IMPORT extern const double QUANTUM_OF_CIRCULATION_TIMES_2;/**< m^2 s^-1 */
ADD_IMPORT extern const double U_QUANTUM_OF_CIRCULATION_TIMES_2;/**< m^2 s^-1 */

ADD_IMPORT extern const double REDUCED_COMPTON_WAVELENGTH;/**< m */
ADD_IMPORT extern const double U_REDUCED_COMPTON_WAVELENGTH;/**< m */

ADD_IMPORT extern const double REDUCED_MUON_COMPTON_WAVELENGTH;/**< m */
ADD_IMPORT extern const double U_REDUCED_MUON_COMPTON_WAVELENGTH;/**< m */

ADD_IMPORT extern const double REDUCED_NEUTRON_COMPTON_WAVELENGTH;/**< m */
ADD_IMPORT extern const double U_REDUCED_NEUTRON_COMPTON_WAVELENGTH;/**< m */

ADD_IMPORT extern const double REDUCED_PLANCK_CONSTANT;/**< J s */
ADD_IMPORT extern const double U_REDUCED_PLANCK_CONSTANT;/**< J s */

ADD_IMPORT extern const double REDUCED_PLANCK_CONSTANT_IN_EV_S;/**< eV s */
ADD_IMPORT extern const double U_REDUCED_PLANCK_CONSTANT_IN_EV_S;/**< eV s */

ADD_IMPORT extern const double REDUCED_PLANCK_CONSTANT_TIMES_C_IN_MEV_FM;/**< MeV fm */
ADD_IMPORT extern const double U_REDUCED_PLANCK_CONSTANT_TIMES_C_IN_MEV_FM;/**< MeV fm */

ADD_IMPORT extern const double REDUCED_PROTON_COMPTON_WAVELENGTH;/**< m */
ADD_IMPORT extern const double U_REDUCED_PROTON_COMPTON_WAVELENGTH;/**< m */

ADD_IMPORT extern const double REDUCED_TAU_COMPTON_WAVELENGTH;/**< m */
ADD_IMPORT extern const double U_REDUCED_TAU_COMPTON_WAVELENGTH;/**< m */

ADD_IMPORT extern const double RYDBERG_CONSTANT;/**< m^-1 */
ADD_IMPORT extern const double U_RYDBERG_CONSTANT;/**< m^-1 */

ADD_IMPORT extern const double RYDBERG_CONSTANT_TIMES_C_IN_HZ;/**< Hz */
ADD_IMPORT extern const double U_RYDBERG_CONSTANT_TIMES_C_IN_HZ;/**< Hz */

ADD_IMPORT extern const double RYDBERG_CONSTANT_TIMES_HC_IN_EV;/**< eV */
ADD_IMPORT extern const double U_RYDBERG_CONSTANT_TIMES_HC_IN_EV;/**< eV */

ADD_IMPORT extern const double RYDBERG_CONSTANT_TIMES_HC_IN_J;/**< J */
ADD_IMPORT extern const double U_RYDBERG_CONSTANT_TIMES_HC_IN_J;/**< J */

ADD_IMPORT extern const double SACKUR_TETRODE_CONSTANT__1_K__100_KPA;/**<   */
ADD_IMPORT extern const double U_SACKUR_TETRODE_CONSTANT__1_K__100_KPA;/**<   */

ADD_IMPORT extern const double SACKUR_TETRODE_CONSTANT__1_K__101_325_KPA;/**<   */
ADD_IMPORT extern const double U_SACKUR_TETRODE_CONSTANT__1_K__101_325_KPA;/**<   */

ADD_IMPORT extern const double SECOND_RADIATION_CONSTANT;/**< m K */
ADD_IMPORT extern const double U_SECOND_RADIATION_CONSTANT;/**< m K */

ADD_IMPORT extern const double SHIELDED_HELION_GYROMAG__RATIO;/**< s^-1 T^-1 */
ADD_IMPORT extern const double U_SHIELDED_HELION_GYROMAG__RATIO;/**< s^-1 T^-1 */

ADD_IMPORT extern const double SHIELDED_HELION_GYROMAG__RATIO_IN_MHZ_T;/**< MHz T^-1 */
ADD_IMPORT extern const double U_SHIELDED_HELION_GYROMAG__RATIO_IN_MHZ_T;/**< MHz T^-1 */

ADD_IMPORT extern const double SHIELDED_HELION_MAG__MOM;/**< J T^-1 */
ADD_IMPORT extern const double U_SHIELDED_HELION_MAG__MOM;/**< J T^-1 */

ADD_IMPORT extern const double SHIELDED_HELION_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_SHIELDED_HELION_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double SHIELDED_HELION_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_SHIELDED_HELION_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double SHIELDED_HELION_TO_PROTON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_SHIELDED_HELION_TO_PROTON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double SHIELDED_HELION_TO_SHIELDED_PROTON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_SHIELDED_HELION_TO_SHIELDED_PROTON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double SHIELDED_PROTON_GYROMAG__RATIO;/**< s^-1 T^-1 */
ADD_IMPORT extern const double U_SHIELDED_PROTON_GYROMAG__RATIO;/**< s^-1 T^-1 */

ADD_IMPORT extern const double SHIELDED_PROTON_GYROMAG__RATIO_IN_MHZ_T;/**< MHz T^-1 */
ADD_IMPORT extern const double U_SHIELDED_PROTON_GYROMAG__RATIO_IN_MHZ_T;/**< MHz T^-1 */

ADD_IMPORT extern const double SHIELDED_PROTON_MAG__MOM;/**< J T^-1 */
ADD_IMPORT extern const double U_SHIELDED_PROTON_MAG__MOM;/**< J T^-1 */

ADD_IMPORT extern const double SHIELDED_PROTON_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_SHIELDED_PROTON_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double SHIELDED_PROTON_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_SHIELDED_PROTON_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double SHIELDING_DIFFERENCE_OF_D_AND_P_IN_HD;/**<   */
ADD_IMPORT extern const double U_SHIELDING_DIFFERENCE_OF_D_AND_P_IN_HD;/**<   */

ADD_IMPORT extern const double SHIELDING_DIFFERENCE_OF_T_AND_P_IN_HT;/**<   */
ADD_IMPORT extern const double U_SHIELDING_DIFFERENCE_OF_T_AND_P_IN_HT;/**<   */

ADD_IMPORT extern const double SPEED_OF_LIGHT_IN_VACUUM;/**< m s^-1 */
ADD_IMPORT extern const double U_SPEED_OF_LIGHT_IN_VACUUM;/**< m s^-1 */

ADD_IMPORT extern const double STANDARD_ACCELERATION_OF_GRAVITY;/**< m s^-2 */
ADD_IMPORT extern const double U_STANDARD_ACCELERATION_OF_GRAVITY;/**< m s^-2 */

ADD_IMPORT extern const double STANDARD_ATMOSPHERE;/**< Pa */
ADD_IMPORT extern const double U_STANDARD_ATMOSPHERE;/**< Pa */

ADD_IMPORT extern const double STANDARD_STATE_PRESSURE;/**< Pa */
ADD_IMPORT extern const double U_STANDARD_STATE_PRESSURE;/**< Pa */

ADD_IMPORT extern const double STEFAN_BOLTZMANN_CONSTANT;/**< W m^-2 K^-4 */
ADD_IMPORT extern const double U_STEFAN_BOLTZMANN_CONSTANT;/**< W m^-2 K^-4 */

ADD_IMPORT extern const double TAU_COMPTON_WAVELENGTH;/**< m */
ADD_IMPORT extern const double U_TAU_COMPTON_WAVELENGTH;/**< m */

ADD_IMPORT extern const double TAU_ELECTRON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_TAU_ELECTRON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double TAU_ENERGY_EQUIVALENT;/**< MeV */
ADD_IMPORT extern const double U_TAU_ENERGY_EQUIVALENT;/**< MeV */

ADD_IMPORT extern const double TAU_MASS;/**< kg */
ADD_IMPORT extern const double U_TAU_MASS;/**< kg */

ADD_IMPORT extern const double TAU_MASS_ENERGY_EQUIVALENT;/**< J */
ADD_IMPORT extern const double U_TAU_MASS_ENERGY_EQUIVALENT;/**< J */

ADD_IMPORT extern const double TAU_MASS_IN_U;/**< u */
ADD_IMPORT extern const double U_TAU_MASS_IN_U;/**< u */

ADD_IMPORT extern const double TAU_MOLAR_MASS;/**< kg mol^-1 */
ADD_IMPORT extern const double U_TAU_MOLAR_MASS;/**< kg mol^-1 */

ADD_IMPORT extern const double TAU_MUON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_TAU_MUON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double TAU_NEUTRON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_TAU_NEUTRON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double TAU_PROTON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_TAU_PROTON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double THOMSON_CROSS_SECTION;/**< m^2 */
ADD_IMPORT extern const double U_THOMSON_CROSS_SECTION;/**< m^2 */

ADD_IMPORT extern const double TRITON_ELECTRON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_TRITON_ELECTRON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double TRITON_G_FACTOR;/**<   */
ADD_IMPORT extern const double U_TRITON_G_FACTOR;/**<   */

ADD_IMPORT extern const double TRITON_MAG__MOM;/**< J T^-1 */
ADD_IMPORT extern const double U_TRITON_MAG__MOM;/**< J T^-1 */

ADD_IMPORT extern const double TRITON_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_TRITON_MAG__MOM__TO_BOHR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double TRITON_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */
ADD_IMPORT extern const double U_TRITON_MAG__MOM__TO_NUCLEAR_MAGNETON_RATIO;/**<   */

ADD_IMPORT extern const double TRITON_MASS;/**< kg */
ADD_IMPORT extern const double U_TRITON_MASS;/**< kg */

ADD_IMPORT extern const double TRITON_MASS_ENERGY_EQUIVALENT;/**< J */
ADD_IMPORT extern const double U_TRITON_MASS_ENERGY_EQUIVALENT;/**< J */

ADD_IMPORT extern const double TRITON_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */
ADD_IMPORT extern const double U_TRITON_MASS_ENERGY_EQUIVALENT_IN_MEV;/**< MeV */

ADD_IMPORT extern const double TRITON_MASS_IN_U;/**< u */
ADD_IMPORT extern const double U_TRITON_MASS_IN_U;/**< u */

ADD_IMPORT extern const double TRITON_MOLAR_MASS;/**< kg mol^-1 */
ADD_IMPORT extern const double U_TRITON_MOLAR_MASS;/**< kg mol^-1 */

ADD_IMPORT extern const double TRITON_PROTON_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_TRITON_PROTON_MASS_RATIO;/**<   */

ADD_IMPORT extern const double TRITON_RELATIVE_ATOMIC_MASS;/**<   */
ADD_IMPORT extern const double U_TRITON_RELATIVE_ATOMIC_MASS;/**<   */

ADD_IMPORT extern const double TRITON_TO_PROTON_MAG__MOM__RATIO;/**<   */
ADD_IMPORT extern const double U_TRITON_TO_PROTON_MAG__MOM__RATIO;/**<   */

ADD_IMPORT extern const double UNIFIED_ATOMIC_MASS_UNIT;/**< kg */
ADD_IMPORT extern const double U_UNIFIED_ATOMIC_MASS_UNIT;/**< kg */

ADD_IMPORT extern const double VACUUM_ELECTRIC_PERMITTIVITY;/**< F m^-1 */
ADD_IMPORT extern const double U_VACUUM_ELECTRIC_PERMITTIVITY;/**< F m^-1 */

ADD_IMPORT extern const double VACUUM_MAG__PERMEABILITY;/**< N A^-2 */
ADD_IMPORT extern const double U_VACUUM_MAG__PERMEABILITY;/**< N A^-2 */

ADD_IMPORT extern const double VON_KLITZING_CONSTANT;/**< ohm */
ADD_IMPORT extern const double U_VON_KLITZING_CONSTANT;/**< ohm */

ADD_IMPORT extern const double WEAK_MIXING_ANGLE;/**<   */
ADD_IMPORT extern const double U_WEAK_MIXING_ANGLE;/**<   */

ADD_IMPORT extern const double WIEN_FREQUENCY_DISPLACEMENT_LAW_CONSTANT;/**< Hz K^-1 */
ADD_IMPORT extern const double U_WIEN_FREQUENCY_DISPLACEMENT_LAW_CONSTANT;/**< Hz K^-1 */

ADD_IMPORT extern const double WIEN_WAVELENGTH_DISPLACEMENT_LAW_CONSTANT;/**< m K */
ADD_IMPORT extern const double U_WIEN_WAVELENGTH_DISPLACEMENT_LAW_CONSTANT;/**< m K */

ADD_IMPORT extern const double W_TO_Z_MASS_RATIO;/**<   */
ADD_IMPORT extern const double U_W_TO_Z_MASS_RATIO;/**<   */

