# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInternetGatewaysResult',
    'AwaitableGetInternetGatewaysResult',
    'get_internet_gateways',
    'get_internet_gateways_output',
]

@pulumi.output_type
class GetInternetGatewaysResult:
    """
    A collection of values returned by getInternetGateways.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, gateways=None, id=None, state=None, vcn_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if gateways and not isinstance(gateways, list):
            raise TypeError("Expected argument 'gateways' to be a list")
        pulumi.set(__self__, "gateways", gateways)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the internet gateway.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInternetGatewaysFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def gateways(self) -> Sequence['outputs.GetInternetGatewaysGatewayResult']:
        """
        The list of gateways.
        """
        return pulumi.get(self, "gateways")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The internet gateway's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN the Internet Gateway belongs to.
        """
        return pulumi.get(self, "vcn_id")


class AwaitableGetInternetGatewaysResult(GetInternetGatewaysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInternetGatewaysResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            gateways=self.gateways,
            id=self.id,
            state=self.state,
            vcn_id=self.vcn_id)


def get_internet_gateways(compartment_id: Optional[str] = None,
                          display_name: Optional[str] = None,
                          filters: Optional[Sequence[pulumi.InputType['GetInternetGatewaysFilterArgs']]] = None,
                          state: Optional[str] = None,
                          vcn_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInternetGatewaysResult:
    """
    This data source provides the list of Internet Gateways in Oracle Cloud Infrastructure Core service.

    Lists the internet gateways in the specified VCN and the specified compartment.
    If the VCN ID is not provided, then the list includes the internet gateways from all VCNs in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_internet_gateways = oci.Core.get_internet_gateways(compartment_id=var["compartment_id"],
        display_name=var["internet_gateway_display_name"],
        state=var["internet_gateway_state"],
        vcn_id=oci_core_vcn["test_vcn"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    :param str vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['vcnId'] = vcn_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getInternetGateways:getInternetGateways', __args__, opts=opts, typ=GetInternetGatewaysResult).value

    return AwaitableGetInternetGatewaysResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        gateways=pulumi.get(__ret__, 'gateways'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))


@_utilities.lift_output_func(get_internet_gateways)
def get_internet_gateways_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                 display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetInternetGatewaysFilterArgs']]]]] = None,
                                 state: Optional[pulumi.Input[Optional[str]]] = None,
                                 vcn_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInternetGatewaysResult]:
    """
    This data source provides the list of Internet Gateways in Oracle Cloud Infrastructure Core service.

    Lists the internet gateways in the specified VCN and the specified compartment.
    If the VCN ID is not provided, then the list includes the internet gateways from all VCNs in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_internet_gateways = oci.Core.get_internet_gateways(compartment_id=var["compartment_id"],
        display_name=var["internet_gateway_display_name"],
        state=var["internet_gateway_state"],
        vcn_id=oci_core_vcn["test_vcn"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    :param str vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
    """
    ...
