# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetSnapshotResult',
    'AwaitableGetSnapshotResult',
    'get_snapshot',
    'get_snapshot_output',
]

@pulumi.output_type
class GetSnapshotResult:
    """
    A collection of values returned by getSnapshot.
    """
    def __init__(__self__, defined_tags=None, expiration_time=None, file_system_id=None, filesystem_snapshot_policy_id=None, freeform_tags=None, id=None, is_clone_source=None, lifecycle_details=None, name=None, provenance_id=None, snapshot_id=None, snapshot_time=None, snapshot_type=None, state=None, time_created=None):
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if expiration_time and not isinstance(expiration_time, str):
            raise TypeError("Expected argument 'expiration_time' to be a str")
        pulumi.set(__self__, "expiration_time", expiration_time)
        if file_system_id and not isinstance(file_system_id, str):
            raise TypeError("Expected argument 'file_system_id' to be a str")
        pulumi.set(__self__, "file_system_id", file_system_id)
        if filesystem_snapshot_policy_id and not isinstance(filesystem_snapshot_policy_id, str):
            raise TypeError("Expected argument 'filesystem_snapshot_policy_id' to be a str")
        pulumi.set(__self__, "filesystem_snapshot_policy_id", filesystem_snapshot_policy_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_clone_source and not isinstance(is_clone_source, bool):
            raise TypeError("Expected argument 'is_clone_source' to be a bool")
        pulumi.set(__self__, "is_clone_source", is_clone_source)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provenance_id and not isinstance(provenance_id, str):
            raise TypeError("Expected argument 'provenance_id' to be a str")
        pulumi.set(__self__, "provenance_id", provenance_id)
        if snapshot_id and not isinstance(snapshot_id, str):
            raise TypeError("Expected argument 'snapshot_id' to be a str")
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        if snapshot_time and not isinstance(snapshot_time, str):
            raise TypeError("Expected argument 'snapshot_time' to be a str")
        pulumi.set(__self__, "snapshot_time", snapshot_time)
        if snapshot_type and not isinstance(snapshot_type, str):
            raise TypeError("Expected argument 'snapshot_type' to be a str")
        pulumi.set(__self__, "snapshot_type", snapshot_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        """
        The time when this snapshot will be deleted.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system from which the snapshot was created.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="filesystemSnapshotPolicyId")
    def filesystem_snapshot_policy_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system snapshot policy that created this snapshot.
        """
        return pulumi.get(self, "filesystem_snapshot_policy_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCloneSource")
    def is_clone_source(self) -> bool:
        """
        Specifies whether the snapshot has been cloned. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "is_clone_source")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current `lifecycleState`.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the snapshot. This value is immutable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provenanceId")
    def provenance_id(self) -> str:
        """
        An [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) identifying the parent from which this snapshot was cloned. If this snapshot was not cloned, then the `provenanceId` is the same as the snapshot `id` value. If this snapshot was cloned, then the `provenanceId` value is the parent's `provenanceId`. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "provenance_id")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> str:
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="snapshotTime")
    def snapshot_time(self) -> str:
        """
        The date and time the snapshot was taken, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. This value might be the same or different from `timeCreated` depending on the following factors:
        * If the snapshot is created in the original file system directory.
        * If the snapshot is cloned from a file system.
        * If the snapshot is replicated from a file system.
        """
        return pulumi.get(self, "snapshot_time")

    @property
    @pulumi.getter(name="snapshotType")
    def snapshot_type(self) -> str:
        """
        Specifies the generation type of the snapshot.
        """
        return pulumi.get(self, "snapshot_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the snapshot.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the snapshot was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetSnapshotResult(GetSnapshotResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSnapshotResult(
            defined_tags=self.defined_tags,
            expiration_time=self.expiration_time,
            file_system_id=self.file_system_id,
            filesystem_snapshot_policy_id=self.filesystem_snapshot_policy_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_clone_source=self.is_clone_source,
            lifecycle_details=self.lifecycle_details,
            name=self.name,
            provenance_id=self.provenance_id,
            snapshot_id=self.snapshot_id,
            snapshot_time=self.snapshot_time,
            snapshot_type=self.snapshot_type,
            state=self.state,
            time_created=self.time_created)


def get_snapshot(snapshot_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSnapshotResult:
    """
    This data source provides details about a specific Snapshot resource in Oracle Cloud Infrastructure File Storage service.

    Gets the specified snapshot's information.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_snapshot = oci.FileStorage.get_snapshot(snapshot_id=oci_file_storage_snapshot["test_snapshot"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot.
    """
    __args__ = dict()
    __args__['snapshotId'] = snapshot_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FileStorage/getSnapshot:getSnapshot', __args__, opts=opts, typ=GetSnapshotResult).value

    return AwaitableGetSnapshotResult(
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        expiration_time=pulumi.get(__ret__, 'expiration_time'),
        file_system_id=pulumi.get(__ret__, 'file_system_id'),
        filesystem_snapshot_policy_id=pulumi.get(__ret__, 'filesystem_snapshot_policy_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_clone_source=pulumi.get(__ret__, 'is_clone_source'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        name=pulumi.get(__ret__, 'name'),
        provenance_id=pulumi.get(__ret__, 'provenance_id'),
        snapshot_id=pulumi.get(__ret__, 'snapshot_id'),
        snapshot_time=pulumi.get(__ret__, 'snapshot_time'),
        snapshot_type=pulumi.get(__ret__, 'snapshot_type'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_snapshot)
def get_snapshot_output(snapshot_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSnapshotResult]:
    """
    This data source provides details about a specific Snapshot resource in Oracle Cloud Infrastructure File Storage service.

    Gets the specified snapshot's information.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_snapshot = oci.FileStorage.get_snapshot(snapshot_id=oci_file_storage_snapshot["test_snapshot"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot.
    """
    ...
