# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetLogAnalyticsLogGroupResult',
    'AwaitableGetLogAnalyticsLogGroupResult',
    'get_log_analytics_log_group',
    'get_log_analytics_log_group_output',
]

@pulumi.output_type
class GetLogAnalyticsLogGroupResult:
    """
    A collection of values returned by getLogAnalyticsLogGroup.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, log_analytics_log_group_id=None, namespace=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_analytics_log_group_id and not isinstance(log_analytics_log_group_id, str):
            raise TypeError("Expected argument 'log_analytics_log_group_id' to be a str")
        pulumi.set(__self__, "log_analytics_log_group_id", log_analytics_log_group_id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description for this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name that is changeable and that does not have to be unique. Format: a leading alphanumeric, followed by zero or more alphanumerics, underscores, spaces, backslashes, or hyphens in any order). No trailing spaces allowed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The log analytics entity OCID. This ID is a reference used by log analytics features and it represents a resource that is provisioned and managed by the customer on their premises or on the cloud.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logAnalyticsLogGroupId")
    def log_analytics_log_group_id(self) -> str:
        return pulumi.get(self, "log_analytics_log_group_id")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetLogAnalyticsLogGroupResult(GetLogAnalyticsLogGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsLogGroupResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            log_analytics_log_group_id=self.log_analytics_log_group_id,
            namespace=self.namespace,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_log_analytics_log_group(log_analytics_log_group_id: Optional[str] = None,
                                namespace: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsLogGroupResult:
    """
    This data source provides details about a specific Log Analytics Log Group resource in Oracle Cloud Infrastructure Log Analytics service.

    Gets detailed information about the specified log group such as display name, description, defined tags, and free-form tags.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_log_group = oci.LogAnalytics.get_log_analytics_log_group(log_analytics_log_group_id=oci_log_analytics_log_analytics_log_group["test_log_analytics_log_group"]["id"],
        namespace=var["log_analytics_log_group_namespace"])
    ```
    <!--End PulumiCodeChooser -->


    :param str log_analytics_log_group_id: unique logAnalytics log group identifier
    :param str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['logAnalyticsLogGroupId'] = log_analytics_log_group_id
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsLogGroup:getLogAnalyticsLogGroup', __args__, opts=opts, typ=GetLogAnalyticsLogGroupResult).value

    return AwaitableGetLogAnalyticsLogGroupResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        log_analytics_log_group_id=pulumi.get(__ret__, 'log_analytics_log_group_id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_log_analytics_log_group)
def get_log_analytics_log_group_output(log_analytics_log_group_id: Optional[pulumi.Input[str]] = None,
                                       namespace: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLogAnalyticsLogGroupResult]:
    """
    This data source provides details about a specific Log Analytics Log Group resource in Oracle Cloud Infrastructure Log Analytics service.

    Gets detailed information about the specified log group such as display name, description, defined tags, and free-form tags.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_log_group = oci.LogAnalytics.get_log_analytics_log_group(log_analytics_log_group_id=oci_log_analytics_log_analytics_log_group["test_log_analytics_log_group"]["id"],
        namespace=var["log_analytics_log_group_namespace"])
    ```
    <!--End PulumiCodeChooser -->


    :param str log_analytics_log_group_id: unique logAnalytics log group identifier
    :param str namespace: The Logging Analytics namespace used for the request.
    """
    ...
