# generated by datamodel-codegen:
#   filename:  analytics/reportData.json
#   timestamp: 2025-04-14T07:35:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import basic
from .reportDataType import (
    aggregatedCostAnalysisReportData,
    entityReportData,
    rawCostAnalysisReportData,
    webAnalyticEntityViewReportData,
    webAnalyticUserActivityReportData,
)


class ReportDataType(Enum):
    entityReportData = 'entityReportData'
    webAnalyticUserActivityReportData = 'webAnalyticUserActivityReportData'
    webAnalyticEntityViewReportData = 'webAnalyticEntityViewReportData'
    rawCostAnalysisReportData = 'rawCostAnalysisReportData'
    aggregatedCostAnalysisReportData = 'aggregatedCostAnalysisReportData'


class ReportData(BaseModel):
    id: Annotated[
        Optional[basic.Uuid], Field(None, description='Unique identifier for a result.')
    ]
    timestamp: Annotated[
        basic.Timestamp, Field(description='timestamp for of a result ingestion.')
    ]
    reportDataType: Annotated[
        Optional[ReportDataType], Field(None, description='Type of data')
    ]
    data: Annotated[
        Optional[
            Union[
                entityReportData.EntityReportData,
                webAnalyticUserActivityReportData.WebAnalyticUserActivityReportData,
                webAnalyticEntityViewReportData.WebAnalyticEntityViewReportData,
                rawCostAnalysisReportData.RawCostAnalysisReportData,
                aggregatedCostAnalysisReportData.AggregatedCostAnalysisReportData,
            ]
        ],
        Field(None, description='Data captured'),
    ]
