# generated by datamodel-codegen:
#   filename:  api/services/ingestionPipelines/createIngestionPipeline.json
#   timestamp: 2025-04-14T07:35:48+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ....entity.services.ingestionPipelines import ingestionPipeline
from ....metadataIngestion import workflow
from ....type import basic, entityReference, entityReferenceList


class CreateIngestionPipelineRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this pipeline instance uniquely.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None, description='Display Name that identifies this ingestion pipeline.'
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the pipeline.'),
    ]
    pipelineType: ingestionPipeline.PipelineType
    sourceConfig: workflow.SourceConfig
    airflowConfig: ingestionPipeline.AirflowConfig
    loggerLevel: Annotated[
        Optional[workflow.LogLevels],
        Field(
            workflow.LogLevels.INFO,
            description='Set the logging level for the workflow.',
        ),
    ]
    service: Annotated[
        entityReference.EntityReference,
        Field(
            description='Link to the service for which ingestion pipeline is ingesting the metadata.'
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owner of this Ingestion Pipeline.'),
    ]
    domain: Annotated[
        Optional[str],
        Field(
            None, description='Fully qualified name of the domain the Table belongs to.'
        ),
    ]
