# generated by datamodel-codegen:
#   filename:  configuration/authConfig.json
#   timestamp: 2025-04-14T07:35:48+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..security.client import (
    auth0SSOClientConfig,
    azureSSOClientConfig,
    customOidcSSOClientConfig,
    googleSSOClientConfig,
    oktaSSOClientConfig,
    openMetadataJWTClientConfig,
)


class AuthConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    google: Annotated[
        Optional[googleSSOClientConfig.GoogleSSOClientConfig],
        Field(None, description='Google SSO Configuration'),
    ]
    okta: Annotated[
        Optional[oktaSSOClientConfig.OktaSSOClientConfig],
        Field(None, description='Okta SSO Configuration'),
    ]
    auth0: Annotated[
        Optional[auth0SSOClientConfig.Auth0SSOClientConfig],
        Field(None, description='Auth0 SSO Configuration'),
    ]
    azure: Annotated[
        Optional[azureSSOClientConfig.AzureSSOClientConfig],
        Field(None, description='Azure SSO Configuration'),
    ]
    customOidc: Annotated[
        Optional[customOidcSSOClientConfig.CustomOIDCSSOClientConfig],
        Field(None, description='Custom OIDC SSO Configuration'),
    ]
    openmetadata: Annotated[
        Optional[openMetadataJWTClientConfig.OpenMetadataJWTClientConfig],
        Field(None, description='OpenMetadata SSO Configuration'),
    ]
