# generated by datamodel-codegen:
#   filename:  governance/workflows/elements/nodes/automatedTask/setEntityCertificationTask.json
#   timestamp: 2025-04-14T07:35:48+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ......type import basic


class InputNamespaceMap(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    relatedEntity: str
    updatedBy: Optional[str] = None


class CertificationEnum(Enum):
    field_ = ''
    Certification_Gold = 'Certification.Gold'
    Certification_Silver = 'Certification.Silver'
    Certification_Bronze = 'Certification.Bronze'


class CertificationConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    certification: Annotated[
        CertificationEnum,
        Field(
            description='Choose which Certification to apply to the Data Asset',
            title='Certification',
        ),
    ]


class SetEntityCertificationTaskDefinition(BaseModel):
    type: Optional[str] = 'automatedTask'
    subType: Optional[str] = 'setEntityCertificationTask'
    name: Annotated[
        Optional[basic.EntityName],
        Field(None, description='Name that identifies this Node.', title='Name'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this Node.',
            title='Display Name',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the Node.', title='Description'),
    ]
    config: Optional[CertificationConfiguration] = None
    input: Annotated[
        Optional[List[str]],
        Field(['relatedEntity', 'updatedBy'], max_length=2, min_length=2),
    ]
    inputNamespaceMap: Optional[InputNamespaceMap] = None
