# generated by datamodel-codegen:
#   filename:  entity/applications/appRunRecord.json
#   timestamp: 2025-04-14T07:35:48+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...system import eventPublisherJob, indexingError
from ...type import basic, entityReference
from . import app


class Status(Enum):
    started = 'started'
    running = 'running'
    completed = 'completed'
    failed = 'failed'
    active = 'active'
    activeError = 'activeError'
    stopped = 'stopped'
    success = 'success'
    pending = 'pending'


class SuccessContext(BaseModel):
    stats: Annotated[
        Optional[eventPublisherJob.Stats],
        Field(None, description='Stats for the application.'),
    ]


class FailureContext(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    failure: Optional[indexingError.IndexingAppError] = None


class AppRunRecord(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    appId: Annotated[
        Optional[basic.Uuid],
        Field(
            None,
            description='Unique identifier of this application for which the job is ran.',
        ),
    ]
    appName: Annotated[
        Optional[basic.EntityName], Field(None, description='Name of the application.')
    ]
    timestamp: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Update time of the job status.'),
    ]
    extension: Annotated[Optional[str], Field('status', description='Extension type.')]
    status: Annotated[Optional[Status], Field(None, description='Status for the Job.')]
    runType: Annotated[
        Optional[str],
        Field(None, description='This schema defines the type of application Run.'),
    ]
    startTime: Annotated[
        Optional[basic.Timestamp], Field(None, description='Start of the job status.')
    ]
    endTime: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='End time of the job status.'),
    ]
    executionTime: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Execution time of the job status.'),
    ]
    failureContext: Annotated[
        Optional[FailureContext],
        Field(
            None,
            description="Container for messages regarding the failure of the application. Use the 'failure' field to get the error message. Additional properties are there for backward compatibility.",
        ),
    ]
    successContext: Annotated[
        Optional[SuccessContext],
        Field(None, description='Success Context for the Application.'),
    ]
    scheduleInfo: Optional[app.AppSchedule] = None
    config: Annotated[
        Optional[basic.Map],
        Field(
            None,
            description="The configuration used for this application run. It's type will be based on the application type. Old runs might not be compatible with schema of app configuration.",
        ),
    ]
    services: Annotated[
        Optional[List[entityReference.EntityReference]],
        Field(
            None,
            description='Services configured in the application run. This information is generated based on the given configuration.',
        ),
    ]
    properties: Annotated[
        Optional[basic.Map],
        Field(
            None, description='Arbitrary metadata that will be attached to the report.'
        ),
    ]
