# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/internal/dataInsightsAppConfig.json
#   timestamp: 2025-04-14T07:35:48+00:00

from __future__ import annotations

from datetime import date
from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class DataInsightsAppType(Enum):
    DataInsights = 'DataInsights'


class BackfillConfiguration(BaseModel):
    enabled: Annotated[
        Optional[bool],
        Field(
            None,
            description='Enable Backfill for the configured dates',
            title='Enabled',
        ),
    ]
    startDate: Annotated[
        Optional[date],
        Field(
            None,
            description='Date from which to start the backfill',
            title='Start Date',
        ),
    ]
    endDate: Annotated[
        Optional[date],
        Field(
            None, description='Date for which the backfill will end', title='End Date'
        ),
    ]


class ServiceFilter(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    serviceType: Optional[str] = None
    serviceName: Optional[str] = None


class DataAssetsConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enabled: Annotated[
        bool,
        Field(
            description='If Enabled, Data Asset insights will be populated when the App runs.',
            title='Enabled',
        ),
    ]
    entities: Annotated[
        Optional[List[str]], Field(['all'], description='List of Entities to Reindex')
    ]
    retention: Annotated[
        Optional[int],
        Field(
            7,
            description='Defines the number of days the Data Assets Insights information will be kept. After it they will be deleted.',
            title='Data Retention (Days)',
        ),
    ]
    serviceFilter: Optional[ServiceFilter] = None


class AppAnalyticsConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enabled: Annotated[
        bool,
        Field(
            description='If Enabled, App Analytics insights will be populated when the App runs.',
            title='Enabled',
        ),
    ]


class DataQualityConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enabled: Annotated[
        bool,
        Field(
            description='If Enabled, Data Quality insights will be populated when the App runs.',
            title='Enabled',
        ),
    ]


class CostAnalysisConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enabled: Annotated[
        bool,
        Field(
            description='If Enabled, Cost Analysis insights will be populated when the App runs.',
            title='Enabled',
        ),
    ]


class ModuleConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dataAssets: Annotated[
        DataAssetsConfig,
        Field(
            description='Data Assets Insights Module configuration',
            title='Data Assets Module',
        ),
    ]
    appAnalytics: Annotated[
        AppAnalyticsConfig,
        Field(
            description='App Analytics Module configuration',
            title='App Analytics Module',
        ),
    ]
    dataQuality: Annotated[
        DataQualityConfig,
        Field(
            description='Data Quality Insights Module configuration',
            title='Data Quality Insights Module',
        ),
    ]
    costAnalysis: Annotated[
        CostAnalysisConfig,
        Field(
            description='Cost Analysis Insights Module configuration',
            title='Cost Analysis Insights Module',
        ),
    ]


class DataInsightsAppConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DataInsightsAppType],
        Field(
            DataInsightsAppType.DataInsights,
            description='Application Type',
            title='Application Type',
        ),
    ]
    batchSize: Annotated[
        Optional[int],
        Field(
            100,
            description='Maximum number of events processed at a time (Default 100).',
        ),
    ]
    recreateDataAssetsIndex: Annotated[
        Optional[bool],
        Field(
            False,
            description='Recreates the DataAssets index on DataInsights. Useful if you changed a Custom Property Type and are facing errors. Bear in mind that recreating the index will delete your DataAssets and a backfill will be needed.',
            title='Recreate DataInsights DataAssets Index',
        ),
    ]
    backfillConfiguration: Optional[BackfillConfiguration] = None
    moduleConfiguration: Optional[ModuleConfiguration] = None
