# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/lightdashConnection.json
#   timestamp: 2025-04-14T07:35:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class LightdashType(Enum):
    Lightdash = 'Lightdash'


class LightdashConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[LightdashType],
        Field(
            LightdashType.Lightdash, description='Service Type', title='Service Type'
        ),
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(
            description='Address for your running Lightdash instance', title='Host Port'
        ),
    ]
    apiKey: Annotated[
        CustomSecretStr,
        Field(
            description='The personal access token you can generate in the Lightdash app under the user settings',
            title='API Key',
        ),
    ]
    projectUUID: Annotated[
        str,
        Field(
            description='The Project UUID for your Lightdash instance',
            title='Project UUID',
        ),
    ]
    spaceUUID: Annotated[
        str,
        Field(
            description='The Space UUID for your Lightdash instance', title='Space UUID'
        ),
    ]
    proxyAuthentication: Annotated[
        Optional[CustomSecretStr],
        Field(
            None,
            description='Use if your Lightdash instance is behind a proxy like (Cloud IAP)',
            title='Proxy Authentication',
        ),
    ]
    dashboardFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include dashboards that matches the pattern.',
            title='Default Dashboard Filter Pattern',
        ),
    ]
    chartFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include charts that matches the pattern.',
            title='Default Chart Filter Pattern',
        ),
    ]
    dataModelFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include data models that matches the pattern.',
            title='Default Data Model Filter Pattern',
        ),
    ]
    projectFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include projects that matches the pattern.',
            title='Default Project Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
