# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/customPipelineConnection.json
#   timestamp: 2025-04-14T07:35:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....type import filterPattern
from .. import connectionBasicType


class CustomPipelineType(Enum):
    CustomPipeline = 'CustomPipeline'


class CustomPipelineConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        CustomPipelineType,
        Field(description='Custom pipeline service type', title='Service Type'),
    ]
    sourcePythonClass: Annotated[
        Optional[str],
        Field(
            None,
            description='Source Python Class Name to instantiated by the ingestion workflow',
            title='Source Python Class Name',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    pipelineFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude pipelines.',
            title='Default Pipeline Filter Pattern',
        ),
    ]
