# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/dbtCloudConnection.json
#   timestamp: 2025-04-14T07:35:48+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern


class DBTCloudType(Enum):
    DBTCloud = 'DBTCloud'


class DBTCloudConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DBTCloudType],
        Field(DBTCloudType.DBTCloud, description='Service Type', title='Service Type'),
    ]
    host: Annotated[AnyUrl, Field(description='DBT cloud Access URL.', title='Host')]
    discoveryAPI: Annotated[
        AnyUrl,
        Field(description='DBT cloud Metadata API URL.', title='Discovery API URL'),
    ]
    accountId: Annotated[
        str, Field(description='ID of your DBT cloud account', title='Account Id')
    ]
    jobIds: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='List of IDs of your DBT cloud jobs seperated by comma `,`',
            title='Job Ids',
        ),
    ]
    projectIds: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='List of IDs of your DBT cloud projects seperated by comma `,`',
            title='Project Ids',
        ),
    ]
    numberOfRuns: Annotated[
        Optional[int],
        Field(
            100,
            description='Number of runs to fetch from DBT cloud',
            title='Number of Runs',
        ),
    ]
    token: Annotated[
        CustomSecretStr,
        Field(description='Generated Token to connect to DBTCloud.', title='Token'),
    ]
    pipelineFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude pipelines.',
            title='Default Pipeline Filter Pattern',
        ),
    ]
