# generated by datamodel-codegen:
#   filename:  entity/services/metadataService.json
#   timestamp: 2025-04-14T07:35:48+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityHistory, entityReference, entityReferenceList, tagLabel
from .connections import testConnectionResult
from .connections.metadata import (
    alationConnection,
    alationSinkConnection,
    amundsenConnection,
    atlasConnection,
    metadataESConnection,
    openMetadataConnection,
)


class MetadataServiceType(Enum):
    Amundsen = 'Amundsen'
    MetadataES = 'MetadataES'
    OpenMetadata = 'OpenMetadata'
    Atlas = 'Atlas'
    Alation = 'Alation'
    AlationSink = 'AlationSink'


class MetadataConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    config: Optional[
        Union[
            amundsenConnection.AmundsenConnection,
            metadataESConnection.MetadataESConnection,
            openMetadataConnection.OpenMetadataConnection,
            atlasConnection.AtlasConnection,
            alationConnection.AlationConnection,
            alationSinkConnection.AlationSinkConnection,
        ]
    ] = None


class MetadataService(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier of this database service instance.'),
    ]
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this database service.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this database service.'),
    ]
    serviceType: Annotated[
        MetadataServiceType,
        Field(
            description='Type of database service such as MySQL, BigQuery, Snowflake, Redshift, Postgres...'
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of a database service instance.'),
    ]
    connection: Optional[MetadataConnection] = None
    pipelines: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='References to pipelines deployed for this database service to extract metadata, usage, lineage etc..',
        ),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    testConnectionResult: Annotated[
        Optional[testConnectionResult.TestConnectionResult],
        Field(None, description='Last test connection results for this service'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field([], description='Tags for this Metadata Service.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this database service.'),
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(
            None,
            description='Link to the resource corresponding to this database service.',
        ),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
    ingestionRunner: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='The ingestion agent responsible for executing the ingestion pipeline.',
        ),
    ]
