# generated by datamodel-codegen:
#   filename:  entity/services/pipelineService.json
#   timestamp: 2025-04-14T07:35:48+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityHistory, entityReference, entityReferenceList, tagLabel
from .connections import testConnectionResult
from .connections.pipeline import (
    airbyteConnection,
    airflowConnection,
    customPipelineConnection,
    dagsterConnection,
    databricksPipelineConnection,
    datafactoryConnection,
    dbtCloudConnection,
    domoPipelineConnection,
    fivetranConnection,
    flinkConnection,
    gluePipelineConnection,
    kafkaConnectConnection,
    matillionConnection,
    nifiConnection,
    openLineageConnection,
    sparkConnection,
    splineConnection,
    stitchConnection,
    wherescapeConnection,
)


class PipelineServiceType(Enum):
    Airflow = 'Airflow'
    GluePipeline = 'GluePipeline'
    Airbyte = 'Airbyte'
    Fivetran = 'Fivetran'
    Flink = 'Flink'
    Dagster = 'Dagster'
    Nifi = 'Nifi'
    DomoPipeline = 'DomoPipeline'
    CustomPipeline = 'CustomPipeline'
    DatabricksPipeline = 'DatabricksPipeline'
    Spline = 'Spline'
    Spark = 'Spark'
    OpenLineage = 'OpenLineage'
    KafkaConnect = 'KafkaConnect'
    DBTCloud = 'DBTCloud'
    Matillion = 'Matillion'
    Stitch = 'Stitch'
    DataFactory = 'DataFactory'
    Wherescape = 'Wherescape'


class PipelineConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    config: Optional[
        Union[
            airflowConnection.AirflowConnection,
            wherescapeConnection.WherescapeConnection,
            gluePipelineConnection.GluePipelineConnection,
            airbyteConnection.AirbyteConnection,
            fivetranConnection.FivetranConnection,
            flinkConnection.FlinkConnection,
            dagsterConnection.DagsterConnection,
            nifiConnection.NifiConnection,
            domoPipelineConnection.DomoPipelineConnection,
            customPipelineConnection.CustomPipelineConnection,
            databricksPipelineConnection.DatabricksPipelineConnection,
            splineConnection.SplineConnection,
            sparkConnection.SparkConnection,
            openLineageConnection.OpenLineageConnection,
            kafkaConnectConnection.KafkaConnectConnection,
            dbtCloudConnection.DBTCloudConnection,
            matillionConnection.MatillionConnection,
            datafactoryConnection.DataFactoryConnection,
            stitchConnection.StitchConnection,
        ]
    ] = None


class PipelineService(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier of this pipeline service instance.'),
    ]
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this pipeline service.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    serviceType: Annotated[
        PipelineServiceType,
        Field(description='Type of pipeline service such as Airflow or Prefect...'),
    ]
    description: Annotated[
        Optional[str],
        Field(None, description='Description of a pipeline service instance.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this pipeline service. It could be title or label from the source services.',
        ),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    testConnectionResult: Annotated[
        Optional[testConnectionResult.TestConnectionResult],
        Field(None, description='Last test connection results for this service'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field([], description='Tags for this Pipeline Service.'),
    ]
    pipelines: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='References to pipelines deployed for this pipeline service to extract metadata',
        ),
    ]
    connection: Optional[PipelineConnection] = None
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this pipeline service.'),
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(
            None,
            description='Link to the resource corresponding to this pipeline service.',
        ),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Domain the Pipeline service belongs to.'),
    ]
    ingestionRunner: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='The ingestion agent responsible for executing the ingestion pipeline.',
        ),
    ]
