# generated by datamodel-codegen:
#   filename:  entity/teams/team.json
#   timestamp: 2025-04-14T07:35:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityHistory, entityReferenceList, profile


class TeamType(Enum):
    Group = 'Group'
    Department = 'Department'
    Division = 'Division'
    BusinessUnit = 'BusinessUnit'
    Organization = 'Organization'


class Team(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: basic.Uuid
    teamType: Annotated[
        Optional[TeamType], Field(TeamType.Group, description='Team type')
    ]
    name: Annotated[
        basic.EntityName,
        Field(
            description='A unique name of the team typically the team ID from an identity provider. Example - group Id from LDAP.'
        ),
    ]
    email: Annotated[
        Optional[basic.Email], Field(None, description='Email address of the team.')
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description="Name used for display purposes. Example 'Data Science team'.",
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown], Field(None, description='Description of the team.')
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    profile: Annotated[
        Optional[profile.Profile], Field(None, description='Team profile information.')
    ]
    parents: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Parent teams. For an `Organization` the `parent` is always null. A `BusinessUnit` always has only one parent of type `BusinessUnit` or an `Organization`. A `Division` can have multiple parents of type `BusinessUnit` or `Division`. A `Department` can have multiple parents of type `Division` or `Department`.',
        ),
    ]
    children: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Children teams. An `Organization` can have `BusinessUnit`, `Division` or `Department` as children. A `BusinessUnit` can have `BusinessUnit`, `Division`, or `Department` as children. A `Division` can have `Division` or `Department` as children. A `Department` can have `Department` as children.',
        ),
    ]
    users: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Users that are part of the team.'),
    ]
    childrenCount: Annotated[
        Optional[int], Field(None, description='Total count of Children teams.')
    ]
    userCount: Annotated[
        Optional[int],
        Field(None, description='Total count of users that are part of the team.'),
    ]
    owns: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of entities owned by the team.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owner of this team. '),
    ]
    isJoinable: Annotated[
        Optional[bool],
        Field(
            True,
            description='Can any user join this team during sign up? Value of true indicates yes, and false no.',
        ),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    defaultRoles: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Default roles of a team. These roles will be inherited by all the users that are part of this team.',
        ),
    ]
    inheritedRoles: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Roles that a team is inheriting through membership in teams that have set team default roles.',
        ),
    ]
    policies: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Policies that is attached to this team.'),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Domain the Team belongs to.'),
    ]
