# generated by datamodel-codegen:
#   filename:  metadataIngestion/apiServiceMetadataPipeline.json
#   timestamp: 2025-04-14T07:35:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import filterPattern


class ApiMetadataConfigType(Enum):
    ApiMetadata = 'ApiMetadata'


class ApiServiceMetadataPipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[ApiMetadataConfigType],
        Field(ApiMetadataConfigType.ApiMetadata, description='Pipeline type'),
    ]
    apiCollectionFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch api collections with names matching the pattern.',
            title='API Collection Filter Pattern',
        ),
    ]
    markDeletedApiCollections: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to soft delete api collections in OpenMetadata if the source collections are deleted. Also, if the collection is deleted, all the associated entities like endpoints, etc., with that collection will be deleted',
            title='Mark Deleted Api Collection',
        ),
    ]
    overrideMetadata: Annotated[
        Optional[bool],
        Field(
            False,
            description="Set the 'Override Metadata' toggle to control whether to override the existing metadata in the OpenMetadata server with the metadata fetched from the source. If the toggle is set to true, the metadata fetched from the source will override the existing metadata in the OpenMetadata server. If the toggle is set to false, the metadata fetched from the source will not override the existing metadata in the OpenMetadata server. This is applicable for fields like description, tags, owner and displayName",
            title='Override Metadata',
        ),
    ]
