# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Settlement(BaseModel):
    """
    Settlement
    """ # noqa: E501
    ticker: StrictStr = Field(description="The ticker symbol of the market that was settled.")
    event_ticker: StrictStr = Field(description="The event ticker symbol of the market that was settled.")
    market_result: StrictStr = Field(description="The outcome of the market settlement. 'yes' = market resolved to YES, 'no' = market resolved to NO, 'scalar' = scalar market settled at a specific value, 'void' = market was voided/cancelled and all positions returned at original cost.")
    yes_count: StrictInt = Field(description="Number of YES contracts owned at the time of settlement.")
    yes_total_cost: StrictInt = Field(description="Total cost basis of all YES contracts in cents.")
    no_count: StrictInt = Field(description="Number of NO contracts owned at the time of settlement.")
    no_total_cost: StrictInt = Field(description="Total cost basis of all NO contracts in cents.")
    revenue: StrictInt = Field(description="Total revenue earned from this settlement in cents (winning contracts pay out 100 cents each).")
    settled_time: datetime = Field(description="Timestamp when the market was settled and payouts were processed.")
    fee_cost: StrictStr = Field(description="Total fees paid in fixed point dollars.")
    value: Optional[StrictInt] = Field(default=None, description="Payout of a single yes contract in cents.")
    __properties: ClassVar[List[str]] = ["ticker", "event_ticker", "market_result", "yes_count", "yes_total_cost", "no_count", "no_total_cost", "revenue", "settled_time", "fee_cost", "value"]

    @field_validator('market_result')
    def market_result_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['yes', 'no', 'scalar', 'void']):
            raise ValueError("must be one of enum values ('yes', 'no', 'scalar', 'void')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Settlement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if value (nullable) is None
        # and model_fields_set contains the field
        if self.value is None and "value" in self.model_fields_set:
            _dict['value'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Settlement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ticker": obj.get("ticker"),
            "event_ticker": obj.get("event_ticker"),
            "market_result": obj.get("market_result"),
            "yes_count": obj.get("yes_count"),
            "yes_total_cost": obj.get("yes_total_cost"),
            "no_count": obj.get("no_count"),
            "no_total_cost": obj.get("no_total_cost"),
            "revenue": obj.get("revenue"),
            "settled_time": obj.get("settled_time"),
            "fee_cost": obj.get("fee_cost"),
            "value": obj.get("value")
        })
        return _obj


