"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import httpx
import pydantic
from speakeasy_client_sdk_python.models.errors import error as errors_error
from speakeasy_client_sdk_python.types import BaseModel
from speakeasy_client_sdk_python.utils import FieldMetadata, PathParamMetadata
from typing import Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class DownloadSchemaRequestTypedDict(TypedDict):
    api_id: str
    r"""The ID of the Api to download the schema for."""
    version_id: str
    r"""The version ID of the Api to delete metadata for."""
    

class DownloadSchemaRequest(BaseModel):
    api_id: Annotated[str, pydantic.Field(alias="apiID"), FieldMetadata(path=PathParamMetadata(style="simple", explode=False))]
    r"""The ID of the Api to download the schema for."""
    version_id: Annotated[str, pydantic.Field(alias="versionID"), FieldMetadata(path=PathParamMetadata(style="simple", explode=False))]
    r"""The version ID of the Api to delete metadata for."""
    

class DownloadSchemaResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    two_hundred_application_json_schema: NotRequired[httpx.Response]
    r"""OK"""
    two_hundred_application_x_yaml_schema: NotRequired[httpx.Response]
    r"""OK"""
    error: NotRequired[errors_error.Error]
    r"""Default error response"""
    

class DownloadSchemaResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    two_hundred_application_json_schema: Optional[httpx.Response] = None
    r"""OK"""
    two_hundred_application_x_yaml_schema: Optional[httpx.Response] = None
    r"""OK"""
    error: Optional[errors_error.Error] = None
    r"""Default error response"""
    
