# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-10-18T14:17:46+00:00

from __future__ import annotations

from datetime import date, datetime
from enum import Enum
from typing import Annotated, Any, Mapping, Sequence

from pydantic import AnyUrl, BaseModel, EmailStr, Extra, Field


class Root(BaseModel):
    current_user_url: str | None = None
    current_user_authorizations_html_url: str | None = None
    authorizations_url: str | None = None
    code_search_url: str | None = None
    commit_search_url: str | None = None
    emails_url: str | None = None
    emojis_url: str | None = None
    events_url: str | None = None
    feeds_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    hub_url: str | None = None
    issue_search_url: str | None = None
    issues_url: str | None = None
    keys_url: str | None = None
    label_search_url: str | None = None
    notifications_url: str | None = None
    organization_url: str | None = None
    organization_repositories_url: str | None = None
    organization_teams_url: str | None = None
    public_gists_url: str | None = None
    rate_limit_url: str | None = None
    repository_url: str | None = None
    repository_search_url: str | None = None
    current_user_repositories_url: str | None = None
    starred_url: str | None = None
    starred_gists_url: str | None = None
    topic_search_url: str | None = None
    user_url: str | None = None
    user_organizations_url: str | None = None
    user_repositories_url: str | None = None
    user_search_url: str | None = None


class NullableSimpleUser(BaseModel):
    """
    Simple User
    """

    name: str | None = None
    email: str | None = None
    login: Annotated[str | None, Field(example="octocat")] = None
    id: Annotated[int | None, Field(example=1)] = None
    node_id: Annotated[str | None, Field(example="MDQ6VXNlcjE=")] = None
    avatar_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/images/error/octocat_happy.gif"),
    ] = None
    gravatar_id: Annotated[
        str | None, Field(example="41d064eb2195891e12d0413f63227ea7")
    ] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat")
    ] = None
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat")
    ] = None
    followers_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/followers")
    ] = None
    following_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/following{/other_user}"),
    ] = None
    gists_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/gists{/gist_id}"),
    ] = None
    starred_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/starred{/owner}{/repo}"),
    ] = None
    subscriptions_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/users/octocat/subscriptions"),
    ] = None
    organizations_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/orgs")
    ] = None
    repos_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/repos")
    ] = None
    events_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/events{/privacy}"),
    ] = None
    received_events_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/users/octocat/received_events"),
    ] = None
    type: Annotated[str | None, Field(example="User")] = None
    site_admin: bool | None = None
    starred_at: Annotated[str | None, Field(example='"2020-07-09T00:17:55Z"')] = None


class Permissions(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    issues: str | None = None
    checks: str | None = None
    metadata: str | None = None
    contents: str | None = None
    deployments: str | None = None


class Integration(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    id: Annotated[int | None, Field(example=37)] = None
    """
    Unique identifier of the GitHub app
    """
    slug: Annotated[str | None, Field(example="probot-owners")] = None
    """
    The slug name of the GitHub app
    """
    node_id: Annotated[str | None, Field(example="MDExOkludGVncmF0aW9uMQ==")] = None
    owner: NullableSimpleUser | None = None
    name: Annotated[str | None, Field(example="Probot Owners")] = None
    """
    The name of the GitHub app
    """
    description: Annotated[
        str | None, Field(example="The description of the app.")
    ] = None
    external_url: Annotated[AnyUrl | None, Field(example="https://example.com")] = None
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/apps/super-ci")
    ] = None
    created_at: Annotated[
        datetime | None, Field(example="2017-07-08T16:18:44-04:00")
    ] = None
    updated_at: Annotated[
        datetime | None, Field(example="2017-07-08T16:18:44-04:00")
    ] = None
    permissions: Annotated[
        Permissions | None, Field(example={"issues": "read", "deployments": "write"})
    ] = None
    """
    The set of permissions for the GitHub app
    """
    events: Annotated[
        Sequence[str] | None, Field(example=["label", "deployment"])
    ] = None
    """
    The list of events for the GitHub app
    """
    installations_count: Annotated[int | None, Field(example=5)] = None
    """
    The number of installations associated with the GitHub app
    """
    client_id: Annotated[str | None, Field(example='"Iv1.25b5d1e65ffc4022"')] = None
    client_secret: Annotated[
        str | None, Field(example='"1d4b2097ac622ba702d19de498f005747a8b21d3"')
    ] = None
    webhook_secret: Annotated[
        str | None, Field(example='"6fba8f2fc8a7e8f2cca5577eddd82ca7586b3b6b"')
    ] = None
    pem: Annotated[
        str | None,
        Field(
            example='"-----BEGIN RSA PRIVATE KEY-----\\nMIIEogIBAAKCAQEArYxrNYD/iT5CZVpRJu4rBKmmze3PVmT/gCo2ATUvDvZTPTey\\nxcGJ3vvrJXazKk06pN05TN29o98jrYz4cengG3YGsXPNEpKsIrEl8NhbnxapEnM9\\nJCMRe0P5JcPsfZlX6hmiT7136GRWiGOUba2X9+HKh8QJVLG5rM007TBER9/z9mWm\\nrJuNh+m5l320oBQY/Qq3A7wzdEfZw8qm/mIN0FCeoXH1L6B8xXWaAYBwhTEh6SSn\\nZHlO1Xu1JWDmAvBCi0RO5aRSKM8q9QEkvvHP4yweAtK3N8+aAbZ7ovaDhyGz8r6r\\nzhU1b8Uo0Z2ysf503WqzQgIajr7Fry7/kUwpgQIDAQABAoIBADwJp80Ko1xHPZDy\\nfcCKBDfIuPvkmSW6KumbsLMaQv1aGdHDwwTGv3t0ixSay8CGlxMRtRDyZPib6SvQ\\n6OH/lpfpbMdW2ErkksgtoIKBVrDilfrcAvrNZu7NxRNbhCSvN8q0s4ICecjbbVQh\\nnueSdlA6vGXbW58BHMq68uRbHkP+k+mM9U0mDJ1HMch67wlg5GbayVRt63H7R2+r\\nVxcna7B80J/lCEjIYZznawgiTvp3MSanTglqAYi+m1EcSsP14bJIB9vgaxS79kTu\\noiSo93leJbBvuGo8QEiUqTwMw4tDksmkLsoqNKQ1q9P7LZ9DGcujtPy4EZsamSJT\\ny8OJt0ECgYEA2lxOxJsQk2kI325JgKFjo92mQeUObIvPfSNWUIZQDTjniOI6Gv63\\nGLWVFrZcvQBWjMEQraJA9xjPbblV8PtfO87MiJGLWCHFxmPz2dzoedN+2Coxom8m\\nV95CLz8QUShuao6u/RYcvUaZEoYs5bHcTmy5sBK80JyEmafJPtCQVxMCgYEAy3ar\\nZr3yv4xRPEPMat4rseswmuMooSaK3SKub19WFI5IAtB/e7qR1Rj9JhOGcZz+OQrl\\nT78O2OFYlgOIkJPvRMrPpK5V9lslc7tz1FSh3BZMRGq5jSyD7ETSOQ0c8T2O/s7v\\nbeEPbVbDe4mwvM24XByH0GnWveVxaDl51ABD65sCgYB3ZAspUkOA5egVCh8kNpnd\\nSd6SnuQBE3ySRlT2WEnCwP9Ph6oPgn+oAfiPX4xbRqkL8q/k0BdHQ4h+zNwhk7+h\\nWtPYRAP1Xxnc/F+jGjb+DVaIaKGU18MWPg7f+FI6nampl3Q0KvfxwX0GdNhtio8T\\nTj1E+SnFwh56SRQuxSh2gwKBgHKjlIO5NtNSflsUYFM+hyQiPiqnHzddfhSG+/3o\\nm5nNaSmczJesUYreH5San7/YEy2UxAugvP7aSY2MxB+iGsiJ9WD2kZzTUlDZJ7RV\\nUzWsoqBR+eZfVJ2FUWWvy8TpSG6trh4dFxImNtKejCR1TREpSiTV3Zb1dmahK9GV\\nrK9NAoGAbBxRLoC01xfxCTgt5BDiBcFVh4fp5yYKwavJPLzHSpuDOrrI9jDn1oKN\\nonq5sDU1i391zfQvdrbX4Ova48BN+B7p63FocP/MK5tyyBoT8zQEk2+vWDOw7H/Z\\nu5dTCPxTIsoIwUw1I+7yIxqJzLPFgR2gVBwY1ra/8iAqCj+zeBw=\\n-----END RSA PRIVATE KEY-----\\n"'
        ),
    ] = None


class BasicError(BaseModel):
    """
    Basic Error
    """

    message: str | None = None
    documentation_url: str | None = None
    url: str | None = None
    status: str | None = None


class ValidationErrorSimple(BaseModel):
    """
    Validation Error Simple
    """

    message: str | None = None
    documentation_url: str | None = None
    errors: Sequence[str] | None = None


class WebhookConfig(BaseModel):
    """
    Configuration object of the webhook
    """

    url: Annotated[AnyUrl | None, Field(example="https://example.com/webhook")] = None
    """
    The URL to which the payloads will be delivered.
    """
    content_type: Annotated[str | None, Field(example='"json"')] = None
    """
    The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
    """
    secret: Annotated[str | None, Field(example='"********"')] = None
    """
    If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).
    """
    insecure_ssl: str | float | None = None


class HookDeliveryItem(BaseModel):
    """
    Delivery made by a webhook, without request and response information.
    """

    id: Annotated[int | None, Field(example=42)] = None
    """
    Unique identifier of the webhook delivery.
    """
    guid: Annotated[
        str | None, Field(example="58474f00-b361-11eb-836d-0e4f3503ccbe")
    ] = None
    """
    Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
    """
    delivered_at: Annotated[
        datetime | None, Field(example="2021-05-12T20:33:44Z")
    ] = None
    """
    Time when the webhook delivery occurred.
    """
    redelivery: Annotated[bool | None, Field(example=False)] = None
    """
    Whether the webhook delivery is a redelivery.
    """
    duration: Annotated[float | None, Field(example=0.03)] = None
    """
    Time spent delivering.
    """
    status: Annotated[str | None, Field(example="failed to connect")] = None
    """
    Describes the response returned after attempting the delivery.
    """
    status_code: Annotated[int | None, Field(example=502)] = None
    """
    Status code received when delivery was made.
    """
    event: Annotated[str | None, Field(example="issues")] = None
    """
    The event that triggered the delivery.
    """
    action: Annotated[str | None, Field(example="opened")] = None
    """
    The type of activity for the event that triggered the delivery.
    """
    installation_id: Annotated[int | None, Field(example=123)] = None
    """
    The id of the GitHub App installation associated with this event.
    """
    repository_id: Annotated[int | None, Field(example=123)] = None
    """
    The id of the repository associated with this event.
    """


class ScimError(BaseModel):
    """
    Scim Error
    """

    message: str | None = None
    documentation_url: str | None = None
    detail: str | None = None
    status: int | None = None
    scimType: str | None = None
    schemas: Sequence[str] | None = None


class Error(BaseModel):
    resource: str | None = None
    field: str | None = None
    message: str | None = None
    code: str | None = None
    index: int | None = None
    value: str | int | Sequence[str] | None = None


class ValidationError(BaseModel):
    """
    Validation Error
    """

    message: str | None = None
    documentation_url: str | None = None
    errors: Sequence[Error] | None = None


class Request(BaseModel):
    headers: Mapping[str, Any] | None = None
    """
    The request headers sent with the webhook delivery.
    """
    payload: Mapping[str, Any] | None = None
    """
    The webhook payload.
    """


class Response(BaseModel):
    headers: Mapping[str, Any] | None = None
    """
    The response headers received when the delivery was made.
    """
    payload: str | None = None
    """
    The response payload received.
    """


class HookDelivery(BaseModel):
    """
    Delivery made by a webhook.
    """

    id: Annotated[int | None, Field(example=42)] = None
    """
    Unique identifier of the delivery.
    """
    guid: Annotated[
        str | None, Field(example="58474f00-b361-11eb-836d-0e4f3503ccbe")
    ] = None
    """
    Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
    """
    delivered_at: Annotated[
        datetime | None, Field(example="2021-05-12T20:33:44Z")
    ] = None
    """
    Time when the delivery was delivered.
    """
    redelivery: Annotated[bool | None, Field(example=False)] = None
    """
    Whether the delivery is a redelivery.
    """
    duration: Annotated[float | None, Field(example=0.03)] = None
    """
    Time spent delivering.
    """
    status: Annotated[str | None, Field(example="failed to connect")] = None
    """
    Description of the status of the attempted delivery
    """
    status_code: Annotated[int | None, Field(example=502)] = None
    """
    Status code received when delivery was made.
    """
    event: Annotated[str | None, Field(example="issues")] = None
    """
    The event that triggered the delivery.
    """
    action: Annotated[str | None, Field(example="opened")] = None
    """
    The type of activity for the event that triggered the delivery.
    """
    installation_id: Annotated[int | None, Field(example=123)] = None
    """
    The id of the GitHub App installation associated with this event.
    """
    repository_id: Annotated[int | None, Field(example=123)] = None
    """
    The id of the repository associated with this event.
    """
    url: Annotated[str | None, Field(example="https://www.example.com")] = None
    """
    The URL target of the delivery.
    """
    request: Request | None = None
    response: Response | None = None


class SimpleUser(BaseModel):
    """
    Simple User
    """

    name: str | None = None
    email: str | None = None
    login: Annotated[str | None, Field(example="octocat")] = None
    id: Annotated[int | None, Field(example=1)] = None
    node_id: Annotated[str | None, Field(example="MDQ6VXNlcjE=")] = None
    avatar_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/images/error/octocat_happy.gif"),
    ] = None
    gravatar_id: Annotated[
        str | None, Field(example="41d064eb2195891e12d0413f63227ea7")
    ] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat")
    ] = None
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat")
    ] = None
    followers_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/followers")
    ] = None
    following_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/following{/other_user}"),
    ] = None
    gists_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/gists{/gist_id}"),
    ] = None
    starred_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/starred{/owner}{/repo}"),
    ] = None
    subscriptions_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/users/octocat/subscriptions"),
    ] = None
    organizations_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/orgs")
    ] = None
    repos_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/repos")
    ] = None
    events_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/events{/privacy}"),
    ] = None
    received_events_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/users/octocat/received_events"),
    ] = None
    type: Annotated[str | None, Field(example="User")] = None
    site_admin: bool | None = None
    starred_at: Annotated[str | None, Field(example='"2020-07-09T00:17:55Z"')] = None


class Enterprise(BaseModel):
    """
    An enterprise account
    """

    description: str | None = None
    """
    A short description of the enterprise.
    """
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/enterprises/octo-business")
    ] = None
    website_url: AnyUrl | None = None
    """
    The enterprise's website URL.
    """
    id: Annotated[int | None, Field(example=42)] = None
    """
    Unique identifier of the enterprise
    """
    node_id: Annotated[str | None, Field(example="MDEwOlJlcG9zaXRvcnkxMjk2MjY5")] = None
    name: Annotated[str | None, Field(example="Octo Business")] = None
    """
    The name of the enterprise.
    """
    slug: Annotated[str | None, Field(example="octo-business")] = None
    """
    The slug url identifier for the enterprise.
    """
    created_at: Annotated[datetime | None, Field(example="2019-01-26T19:01:12Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2019-01-26T19:14:43Z")] = None
    avatar_url: AnyUrl | None = None


class Actions(Enum):
    """
    The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.
    """

    read = "read"
    write = "write"


class Administration(Enum):
    """
    The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.
    """

    read = "read"
    write = "write"


class Checks(Enum):
    """
    The level of permission to grant the access token for checks on code.
    """

    read = "read"
    write = "write"


class Contents(Enum):
    """
    The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.
    """

    read = "read"
    write = "write"


class Deployments(Enum):
    """
    The level of permission to grant the access token for deployments and deployment statuses.
    """

    read = "read"
    write = "write"


class Environments(Enum):
    """
    The level of permission to grant the access token for managing repository environments.
    """

    read = "read"
    write = "write"


class Issues(Enum):
    """
    The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.
    """

    read = "read"
    write = "write"


class Metadata(Enum):
    """
    The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.
    """

    read = "read"
    write = "write"


class Packages(Enum):
    """
    The level of permission to grant the access token for packages published to GitHub Packages.
    """

    read = "read"
    write = "write"


class Pages(Enum):
    """
    The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.
    """

    read = "read"
    write = "write"


class PullRequests(Enum):
    """
    The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.
    """

    read = "read"
    write = "write"


class RepositoryAnnouncementBanners(Enum):
    """
    The level of permission to grant the access token to view and manage announcement banners for a repository.
    """

    read = "read"
    write = "write"


class RepositoryHooks(Enum):
    """
    The level of permission to grant the access token to manage the post-receive hooks for a repository.
    """

    read = "read"
    write = "write"


class RepositoryProjects(Enum):
    """
    The level of permission to grant the access token to manage repository projects, columns, and cards.
    """

    read = "read"
    write = "write"
    admin = "admin"


class SecretScanningAlerts(Enum):
    """
    The level of permission to grant the access token to view and manage secret scanning alerts.
    """

    read = "read"
    write = "write"


class Secrets(Enum):
    """
    The level of permission to grant the access token to manage repository secrets.
    """

    read = "read"
    write = "write"


class SecurityEvents(Enum):
    """
    The level of permission to grant the access token to view and manage security events like code scanning alerts.
    """

    read = "read"
    write = "write"


class SingleFile(Enum):
    """
    The level of permission to grant the access token to manage just a single file.
    """

    read = "read"
    write = "write"


class Statuses(Enum):
    """
    The level of permission to grant the access token for commit statuses.
    """

    read = "read"
    write = "write"


class VulnerabilityAlerts(Enum):
    """
    The level of permission to grant the access token to manage Dependabot alerts.
    """

    read = "read"
    write = "write"


class Workflows(Enum):
    """
    The level of permission to grant the access token to update GitHub Actions workflow files.
    """

    write = "write"


class Members(Enum):
    """
    The level of permission to grant the access token for organization teams and members.
    """

    read = "read"
    write = "write"


class OrganizationAdministration(Enum):
    """
    The level of permission to grant the access token to manage access to an organization.
    """

    read = "read"
    write = "write"


class OrganizationCustomRoles(Enum):
    """
    The level of permission to grant the access token for custom roles management. This property is in beta and is subject to change.
    """

    read = "read"
    write = "write"


class OrganizationAnnouncementBanners(Enum):
    """
    The level of permission to grant the access token to view and manage announcement banners for an organization.
    """

    read = "read"
    write = "write"


class OrganizationHooks(Enum):
    """
    The level of permission to grant the access token to manage the post-receive hooks for an organization.
    """

    read = "read"
    write = "write"


class OrganizationPlan(Enum):
    """
    The level of permission to grant the access token for viewing an organization's plan.
    """

    read = "read"


class OrganizationProjects(Enum):
    """
    The level of permission to grant the access token to manage organization projects and projects beta (where available).
    """

    read = "read"
    write = "write"
    admin = "admin"


class OrganizationPackages(Enum):
    """
    The level of permission to grant the access token for organization packages published to GitHub Packages.
    """

    read = "read"
    write = "write"


class OrganizationSecrets(Enum):
    """
    The level of permission to grant the access token to manage organization secrets.
    """

    read = "read"
    write = "write"


class OrganizationSelfHostedRunners(Enum):
    """
    The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.
    """

    read = "read"
    write = "write"


class OrganizationUserBlocking(Enum):
    """
    The level of permission to grant the access token to view and manage users blocked by the organization.
    """

    read = "read"
    write = "write"


class TeamDiscussions(Enum):
    """
    The level of permission to grant the access token to manage team discussions and related comments.
    """

    read = "read"
    write = "write"


class AppPermissions(BaseModel):
    """
    The permissions granted to the user-to-server access token.
    """

    actions: Actions | None = None
    """
    The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.
    """
    administration: Administration | None = None
    """
    The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.
    """
    checks: Checks | None = None
    """
    The level of permission to grant the access token for checks on code.
    """
    contents: Contents | None = None
    """
    The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.
    """
    deployments: Deployments | None = None
    """
    The level of permission to grant the access token for deployments and deployment statuses.
    """
    environments: Environments | None = None
    """
    The level of permission to grant the access token for managing repository environments.
    """
    issues: Issues | None = None
    """
    The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.
    """
    metadata: Metadata | None = None
    """
    The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.
    """
    packages: Packages | None = None
    """
    The level of permission to grant the access token for packages published to GitHub Packages.
    """
    pages: Pages | None = None
    """
    The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.
    """
    pull_requests: PullRequests | None = None
    """
    The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.
    """
    repository_announcement_banners: RepositoryAnnouncementBanners | None = None
    """
    The level of permission to grant the access token to view and manage announcement banners for a repository.
    """
    repository_hooks: RepositoryHooks | None = None
    """
    The level of permission to grant the access token to manage the post-receive hooks for a repository.
    """
    repository_projects: RepositoryProjects | None = None
    """
    The level of permission to grant the access token to manage repository projects, columns, and cards.
    """
    secret_scanning_alerts: SecretScanningAlerts | None = None
    """
    The level of permission to grant the access token to view and manage secret scanning alerts.
    """
    secrets: Secrets | None = None
    """
    The level of permission to grant the access token to manage repository secrets.
    """
    security_events: SecurityEvents | None = None
    """
    The level of permission to grant the access token to view and manage security events like code scanning alerts.
    """
    single_file: SingleFile | None = None
    """
    The level of permission to grant the access token to manage just a single file.
    """
    statuses: Statuses | None = None
    """
    The level of permission to grant the access token for commit statuses.
    """
    vulnerability_alerts: VulnerabilityAlerts | None = None
    """
    The level of permission to grant the access token to manage Dependabot alerts.
    """
    workflows: Workflows | None = None
    """
    The level of permission to grant the access token to update GitHub Actions workflow files.
    """
    members: Members | None = None
    """
    The level of permission to grant the access token for organization teams and members.
    """
    organization_administration: OrganizationAdministration | None = None
    """
    The level of permission to grant the access token to manage access to an organization.
    """
    organization_custom_roles: OrganizationCustomRoles | None = None
    """
    The level of permission to grant the access token for custom roles management. This property is in beta and is subject to change.
    """
    organization_announcement_banners: OrganizationAnnouncementBanners | None = None
    """
    The level of permission to grant the access token to view and manage announcement banners for an organization.
    """
    organization_hooks: OrganizationHooks | None = None
    """
    The level of permission to grant the access token to manage the post-receive hooks for an organization.
    """
    organization_plan: OrganizationPlan | None = None
    """
    The level of permission to grant the access token for viewing an organization's plan.
    """
    organization_projects: OrganizationProjects | None = None
    """
    The level of permission to grant the access token to manage organization projects and projects beta (where available).
    """
    organization_packages: OrganizationPackages | None = None
    """
    The level of permission to grant the access token for organization packages published to GitHub Packages.
    """
    organization_secrets: OrganizationSecrets | None = None
    """
    The level of permission to grant the access token to manage organization secrets.
    """
    organization_self_hosted_runners: OrganizationSelfHostedRunners | None = None
    """
    The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.
    """
    organization_user_blocking: OrganizationUserBlocking | None = None
    """
    The level of permission to grant the access token to view and manage users blocked by the organization.
    """
    team_discussions: TeamDiscussions | None = None
    """
    The level of permission to grant the access token to manage team discussions and related comments.
    """


class RepositorySelection(Enum):
    """
    Describe whether all repositories have been selected or there's a selection involved
    """

    all = "all"
    selected = "selected"


class Installation(BaseModel):
    """
    Installation
    """

    id: Annotated[int | None, Field(example=1)] = None
    """
    The ID of the installation.
    """
    account: SimpleUser | Enterprise | None = None
    repository_selection: RepositorySelection | None = None
    """
    Describe whether all repositories have been selected or there's a selection involved
    """
    access_tokens_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/installations/1/access_tokens"),
    ] = None
    repositories_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/installation/repositories")
    ] = None
    html_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://github.com/organizations/github/settings/installations/1"
        ),
    ] = None
    app_id: Annotated[int | None, Field(example=1)] = None
    target_id: int | None = None
    """
    The ID of the user or organization this token is being scoped to.
    """
    target_type: Annotated[str | None, Field(example="Organization")] = None
    permissions: AppPermissions | None = None
    events: Sequence[str] | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    single_file_name: Annotated[str | None, Field(example="config.yaml")] = None
    has_multiple_single_files: Annotated[bool | None, Field(example=True)] = None
    single_file_paths: Annotated[
        Sequence[str] | None, Field(example=["config.yml", ".github/issue_TEMPLATE.md"])
    ] = None
    app_slug: Annotated[str | None, Field(example="github-actions")] = None
    suspended_by: NullableSimpleUser | None = None
    suspended_at: datetime | None = None
    contact_email: Annotated[
        str | None, Field(example='"test_13f1e99741e3e004@d7e1eb0bc0a1ba12.com"')
    ] = None


class NullableLicenseSimple(BaseModel):
    """
    License Simple
    """

    key: Annotated[str | None, Field(example="mit")] = None
    name: Annotated[str | None, Field(example="MIT License")] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/licenses/mit")
    ] = None
    spdx_id: Annotated[str | None, Field(example="MIT")] = None
    node_id: Annotated[str | None, Field(example="MDc6TGljZW5zZW1pdA==")] = None
    html_url: AnyUrl | None = None


class Permissions1(BaseModel):
    admin: bool | None = None
    pull: bool | None = None
    triage: bool | None = None
    push: bool | None = None
    maintain: bool | None = None


class Owner(BaseModel):
    login: str | None = None
    id: int | None = None
    node_id: str | None = None
    avatar_url: str | None = None
    gravatar_id: str | None = None
    url: str | None = None
    html_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    organizations_url: str | None = None
    repos_url: str | None = None
    events_url: str | None = None
    received_events_url: str | None = None
    type: str | None = None
    site_admin: bool | None = None


class Permissions2(BaseModel):
    admin: bool | None = None
    maintain: bool | None = None
    push: bool | None = None
    triage: bool | None = None
    pull: bool | None = None


class SquashMergeCommitTitle(Enum):
    """
    The default value for a squash merge commit title:

    - `PR_TITLE` - default to the pull request's title.
    - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
    """

    PR_TITLE = "PR_TITLE"
    COMMIT_OR_PR_TITLE = "COMMIT_OR_PR_TITLE"


class SquashMergeCommitMessage(Enum):
    """
    The default value for a squash merge commit message:

    - `PR_BODY` - default to the pull request's body.
    - `COMMIT_MESSAGES` - default to the branch's commit messages.
    - `BLANK` - default to a blank commit message.
    """

    PR_BODY = "PR_BODY"
    COMMIT_MESSAGES = "COMMIT_MESSAGES"
    BLANK = "BLANK"


class MergeCommitTitle(Enum):
    """
    The default value for a merge commit title.

    - `PR_TITLE` - default to the pull request's title.
    - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
    """

    PR_TITLE = "PR_TITLE"
    MERGE_MESSAGE = "MERGE_MESSAGE"


class MergeCommitMessage(Enum):
    """
    The default value for a merge commit message.

    - `PR_TITLE` - default to the pull request's title.
    - `PR_BODY` - default to the pull request's body.
    - `BLANK` - default to a blank commit message.
    """

    PR_BODY = "PR_BODY"
    PR_TITLE = "PR_TITLE"
    BLANK = "BLANK"


class TemplateRepository(BaseModel):
    id: int | None = None
    node_id: str | None = None
    name: str | None = None
    full_name: str | None = None
    owner: Owner | None = None
    private: bool | None = None
    html_url: str | None = None
    description: str | None = None
    fork: bool | None = None
    url: str | None = None
    archive_url: str | None = None
    assignees_url: str | None = None
    blobs_url: str | None = None
    branches_url: str | None = None
    collaborators_url: str | None = None
    comments_url: str | None = None
    commits_url: str | None = None
    compare_url: str | None = None
    contents_url: str | None = None
    contributors_url: str | None = None
    deployments_url: str | None = None
    downloads_url: str | None = None
    events_url: str | None = None
    forks_url: str | None = None
    git_commits_url: str | None = None
    git_refs_url: str | None = None
    git_tags_url: str | None = None
    git_url: str | None = None
    issue_comment_url: str | None = None
    issue_events_url: str | None = None
    issues_url: str | None = None
    keys_url: str | None = None
    labels_url: str | None = None
    languages_url: str | None = None
    merges_url: str | None = None
    milestones_url: str | None = None
    notifications_url: str | None = None
    pulls_url: str | None = None
    releases_url: str | None = None
    ssh_url: str | None = None
    stargazers_url: str | None = None
    statuses_url: str | None = None
    subscribers_url: str | None = None
    subscription_url: str | None = None
    tags_url: str | None = None
    teams_url: str | None = None
    trees_url: str | None = None
    clone_url: str | None = None
    mirror_url: str | None = None
    hooks_url: str | None = None
    svn_url: str | None = None
    homepage: str | None = None
    language: str | None = None
    forks_count: int | None = None
    stargazers_count: int | None = None
    watchers_count: int | None = None
    size: int | None = None
    default_branch: str | None = None
    open_issues_count: int | None = None
    is_template: bool | None = None
    topics: Sequence[str] | None = None
    has_issues: bool | None = None
    has_projects: bool | None = None
    has_wiki: bool | None = None
    has_pages: bool | None = None
    has_downloads: bool | None = None
    archived: bool | None = None
    disabled: bool | None = None
    visibility: str | None = None
    pushed_at: str | None = None
    created_at: str | None = None
    updated_at: str | None = None
    permissions: Permissions2 | None = None
    allow_rebase_merge: bool | None = None
    temp_clone_token: str | None = None
    allow_squash_merge: bool | None = None
    allow_auto_merge: bool | None = None
    delete_branch_on_merge: bool | None = None
    allow_update_branch: bool | None = None
    use_squash_pr_title_as_default: bool | None = None
    squash_merge_commit_title: SquashMergeCommitTitle | None = None
    """
    The default value for a squash merge commit title:

    - `PR_TITLE` - default to the pull request's title.
    - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
    """
    squash_merge_commit_message: SquashMergeCommitMessage | None = None
    """
    The default value for a squash merge commit message:

    - `PR_BODY` - default to the pull request's body.
    - `COMMIT_MESSAGES` - default to the branch's commit messages.
    - `BLANK` - default to a blank commit message.
    """
    merge_commit_title: MergeCommitTitle | None = None
    """
    The default value for a merge commit title.

    - `PR_TITLE` - default to the pull request's title.
    - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
    """
    merge_commit_message: MergeCommitMessage | None = None
    """
    The default value for a merge commit message.

    - `PR_TITLE` - default to the pull request's title.
    - `PR_BODY` - default to the pull request's body.
    - `BLANK` - default to a blank commit message.
    """
    allow_merge_commit: bool | None = None
    subscribers_count: int | None = None
    network_count: int | None = None


class Repository(BaseModel):
    """
    A git repository
    """

    id: Annotated[int | None, Field(example=42)] = None
    """
    Unique identifier of the repository
    """
    node_id: Annotated[str | None, Field(example="MDEwOlJlcG9zaXRvcnkxMjk2MjY5")] = None
    name: Annotated[str | None, Field(example="Team Environment")] = None
    """
    The name of the repository.
    """
    full_name: Annotated[str | None, Field(example="octocat/Hello-World")] = None
    license: NullableLicenseSimple | None = None
    organization: NullableSimpleUser | None = None
    forks: int | None = None
    permissions: Permissions1 | None = None
    owner: SimpleUser | None = None
    private: bool | None = False
    """
    Whether the repository is private or public.
    """
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat/Hello-World")
    ] = None
    description: Annotated[str | None, Field(example="This your first repo!")] = None
    fork: bool | None = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/repos/octocat/Hello-World")
    ] = None
    archive_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}"
        ),
    ] = None
    assignees_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/assignees{/user}"
        ),
    ] = None
    blobs_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}"
        ),
    ] = None
    branches_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/branches{/branch}"
        ),
    ] = None
    collaborators_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}"
        ),
    ] = None
    comments_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/comments{/number}"
        ),
    ] = None
    commits_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/commits{/sha}"),
    ] = None
    compare_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}"
        ),
    ] = None
    contents_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/contents/{+path}"
        ),
    ] = None
    contributors_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/contributors"),
    ] = None
    deployments_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/deployments"),
    ] = None
    downloads_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/downloads"),
    ] = None
    events_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/events"),
    ] = None
    forks_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/forks"),
    ] = None
    git_commits_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/commits{/sha}"
        ),
    ] = None
    git_refs_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/git/refs{/sha}"),
    ] = None
    git_tags_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/git/tags{/sha}"),
    ] = None
    git_url: Annotated[
        str | None, Field(example="git:github.com/octocat/Hello-World.git")
    ] = None
    issue_comment_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues/comments{/number}"
        ),
    ] = None
    issue_events_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues/events{/number}"
        ),
    ] = None
    issues_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues{/number}"
        ),
    ] = None
    keys_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/keys{/key_id}"),
    ] = None
    labels_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/labels{/name}"),
    ] = None
    languages_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/languages"),
    ] = None
    merges_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/merges"),
    ] = None
    milestones_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/milestones{/number}"
        ),
    ] = None
    notifications_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}"
        ),
    ] = None
    pulls_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/pulls{/number}"),
    ] = None
    releases_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/releases{/id}"),
    ] = None
    ssh_url: Annotated[
        str | None, Field(example="git@github.com:octocat/Hello-World.git")
    ] = None
    stargazers_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/stargazers"),
    ] = None
    statuses_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/statuses/{sha}"),
    ] = None
    subscribers_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/subscribers"),
    ] = None
    subscription_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/subscription"),
    ] = None
    tags_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/tags"),
    ] = None
    teams_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/teams"),
    ] = None
    trees_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/trees{/sha}"
        ),
    ] = None
    clone_url: Annotated[
        str | None, Field(example="https://github.com/octocat/Hello-World.git")
    ] = None
    mirror_url: Annotated[
        AnyUrl | None, Field(example="git:git.example.com/octocat/Hello-World")
    ] = None
    hooks_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/hooks"),
    ] = None
    svn_url: Annotated[
        AnyUrl | None, Field(example="https://svn.github.com/octocat/Hello-World")
    ] = None
    homepage: Annotated[AnyUrl | None, Field(example="https://github.com")] = None
    language: str | None = None
    forks_count: Annotated[int | None, Field(example=9)] = None
    stargazers_count: Annotated[int | None, Field(example=80)] = None
    watchers_count: Annotated[int | None, Field(example=80)] = None
    size: Annotated[int | None, Field(example=108)] = None
    """
    The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.
    """
    default_branch: Annotated[str | None, Field(example="master")] = None
    """
    The default branch of the repository.
    """
    open_issues_count: Annotated[int | None, Field(example=0)] = None
    is_template: Annotated[bool | None, Field(example=True)] = False
    """
    Whether this repository acts as a template that can be used to generate new repositories.
    """
    topics: Sequence[str] | None = None
    has_issues: Annotated[bool | None, Field(example=True)] = True
    """
    Whether issues are enabled.
    """
    has_projects: Annotated[bool | None, Field(example=True)] = True
    """
    Whether projects are enabled.
    """
    has_wiki: Annotated[bool | None, Field(example=True)] = True
    """
    Whether the wiki is enabled.
    """
    has_pages: bool | None = None
    has_downloads: Annotated[bool | None, Field(example=True)] = True
    """
    Whether downloads are enabled.
    """
    archived: bool | None = False
    """
    Whether the repository is archived.
    """
    disabled: bool | None = None
    """
    Returns whether or not this repository disabled.
    """
    visibility: str | None = "public"
    """
    The repository visibility: public, private, or internal.
    """
    pushed_at: Annotated[datetime | None, Field(example="2011-01-26T19:06:43Z")] = None
    created_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2011-01-26T19:14:43Z")] = None
    allow_rebase_merge: Annotated[bool | None, Field(example=True)] = True
    """
    Whether to allow rebase merges for pull requests.
    """
    template_repository: TemplateRepository | None = None
    temp_clone_token: str | None = None
    allow_squash_merge: Annotated[bool | None, Field(example=True)] = True
    """
    Whether to allow squash merges for pull requests.
    """
    allow_auto_merge: Annotated[bool | None, Field(example=False)] = False
    """
    Whether to allow Auto-merge to be used on pull requests.
    """
    delete_branch_on_merge: Annotated[bool | None, Field(example=False)] = False
    """
    Whether to delete head branches when pull requests are merged
    """
    allow_update_branch: Annotated[bool | None, Field(example=False)] = False
    """
    Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
    """
    use_squash_pr_title_as_default: bool | None = False
    """
    Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
    """
    squash_merge_commit_title: SquashMergeCommitTitle | None = None
    """
    The default value for a squash merge commit title:

    - `PR_TITLE` - default to the pull request's title.
    - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
    """
    squash_merge_commit_message: SquashMergeCommitMessage | None = None
    """
    The default value for a squash merge commit message:

    - `PR_BODY` - default to the pull request's body.
    - `COMMIT_MESSAGES` - default to the branch's commit messages.
    - `BLANK` - default to a blank commit message.
    """
    merge_commit_title: MergeCommitTitle | None = None
    """
    The default value for a merge commit title.

    - `PR_TITLE` - default to the pull request's title.
    - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
    """
    merge_commit_message: MergeCommitMessage | None = None
    """
    The default value for a merge commit message.

    - `PR_TITLE` - default to the pull request's title.
    - `PR_BODY` - default to the pull request's body.
    - `BLANK` - default to a blank commit message.
    """
    allow_merge_commit: Annotated[bool | None, Field(example=True)] = True
    """
    Whether to allow merge commits for pull requests.
    """
    allow_forking: bool | None = None
    """
    Whether to allow forking this repo
    """
    web_commit_signoff_required: bool | None = False
    """
    Whether to require contributors to sign off on web-based commits
    """
    subscribers_count: int | None = None
    network_count: int | None = None
    open_issues: int | None = None
    watchers: int | None = None
    master_branch: str | None = None
    starred_at: Annotated[str | None, Field(example='"2020-07-09T00:17:42Z"')] = None
    anonymous_access_enabled: bool | None = None
    """
    Whether anonymous git access is enabled for this repository
    """


class RepositorySelection1(Enum):
    all = "all"
    selected = "selected"


class InstallationToken(BaseModel):
    """
    Authentication token for a GitHub App installed on a user or org.
    """

    token: str | None = None
    expires_at: str | None = None
    permissions: AppPermissions | None = None
    repository_selection: RepositorySelection1 | None = None
    repositories: Sequence[Repository] | None = None
    single_file: Annotated[str | None, Field(example="README.md")] = None
    has_multiple_single_files: Annotated[bool | None, Field(example=True)] = None
    single_file_paths: Annotated[
        Sequence[str] | None, Field(example=["config.yml", ".github/issue_TEMPLATE.md"])
    ] = None


class RepositorySelection2(Enum):
    """
    Describe whether all repositories have been selected or there's a selection involved
    """

    all = "all"
    selected = "selected"


class NullableScopedInstallation(BaseModel):
    permissions: AppPermissions | None = None
    repository_selection: RepositorySelection2 | None = None
    """
    Describe whether all repositories have been selected or there's a selection involved
    """
    single_file_name: Annotated[str | None, Field(example="config.yaml")] = None
    has_multiple_single_files: Annotated[bool | None, Field(example=True)] = None
    single_file_paths: Annotated[
        Sequence[str] | None, Field(example=["config.yml", ".github/issue_TEMPLATE.md"])
    ] = None
    repositories_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/repos")
    ] = None
    account: SimpleUser | None = None


class App(BaseModel):
    client_id: str | None = None
    name: str | None = None
    url: AnyUrl | None = None


class Authorization(BaseModel):
    """
    The authorization for an OAuth app, GitHub App, or a Personal Access Token.
    """

    id: int | None = None
    url: AnyUrl | None = None
    scopes: Sequence[str] | None = None
    """
    A list of scopes that this authorization is in.
    """
    token: str | None = None
    token_last_eight: str | None = None
    hashed_token: str | None = None
    app: App | None = None
    note: str | None = None
    note_url: AnyUrl | None = None
    updated_at: datetime | None = None
    created_at: datetime | None = None
    fingerprint: str | None = None
    user: NullableSimpleUser | None = None
    installation: NullableScopedInstallation | None = None
    expires_at: datetime | None = None


class CodeOfConduct(BaseModel):
    """
    Code Of Conduct
    """

    key: Annotated[str | None, Field(example="contributor_covenant")] = None
    name: Annotated[str | None, Field(example="Contributor Covenant")] = None
    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/codes_of_conduct/contributor_covenant"),
    ] = None
    body: Annotated[
        str | None,
        Field(
            example="# Contributor Covenant Code of Conduct\n\n## Our Pledge\n\nIn the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to making participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level of experience, nationality, personal appearance, race, religion, or sexual identity and orientation.\n\n## Our Standards\n\nExamples of behavior that contributes to creating a positive environment include:\n\n* Using welcoming and inclusive language\n* Being respectful of differing viewpoints and experiences\n* Gracefully accepting constructive criticism\n* Focusing on what is best for the community\n* Showing empathy towards other community members\n\nExamples of unacceptable behavior by participants include:\n\n* The use of sexualized language or imagery and unwelcome sexual attention or advances\n* Trolling, insulting/derogatory comments, and personal or political attacks\n* Public or private harassment\n* Publishing others' private information, such as a physical or electronic address, without explicit permission\n* Other conduct which could reasonably be considered inappropriate in a professional setting\n\n## Our Responsibilities\n\nProject maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response\n                  to any instances of unacceptable behavior.\n\nProject maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.\n\n## Scope\n\nThis Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project e-mail address,\n                  posting via an official social media account, or acting as an appointed representative at an online or offline event. Representation of a project may be further defined and clarified by project maintainers.\n\n## Enforcement\n\nInstances of abusive, harassing, or otherwise unacceptable behavior may be reported by contacting the project team at [EMAIL]. The project team will review and investigate all complaints, and will respond in a way that it deems appropriate to the circumstances. The project team is obligated to maintain confidentiality with regard to the reporter of an incident. Further details of specific enforcement policies may be posted separately.\n\nProject maintainers who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the project's leadership.\n\n## Attribution\n\nThis Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4, available at [http://contributor-covenant.org/version/1/4][version]\n\n[homepage]: http://contributor-covenant.org\n[version]: http://contributor-covenant.org/version/1/4/\n"
        ),
    ] = None
    html_url: AnyUrl | None = None


class GithubConnect(BaseModel):
    features_enabled: Sequence[str] | None = None


class Comments(BaseModel):
    total_commit_comments: int | None = None
    total_gist_comments: int | None = None
    total_issue_comments: int | None = None
    total_pull_request_comments: int | None = None


class Gists(BaseModel):
    total_gists: int | None = None
    private_gists: int | None = None
    public_gists: int | None = None


class Hooks(BaseModel):
    total_hooks: int | None = None
    active_hooks: int | None = None
    inactive_hooks: int | None = None


class Issues1(BaseModel):
    total_issues: int | None = None
    open_issues: int | None = None
    closed_issues: int | None = None


class Milestones(BaseModel):
    total_milestones: int | None = None
    open_milestones: int | None = None
    closed_milestones: int | None = None


class Orgs(BaseModel):
    total_orgs: int | None = None
    disabled_orgs: int | None = None
    total_teams: int | None = None
    total_team_members: int | None = None


class Pages1(BaseModel):
    total_pages: int | None = None


class Pulls(BaseModel):
    total_pulls: int | None = None
    merged_pulls: int | None = None
    mergeable_pulls: int | None = None
    unmergeable_pulls: int | None = None


class Repos(BaseModel):
    total_repos: int | None = None
    root_repos: int | None = None
    fork_repos: int | None = None
    org_repos: int | None = None
    total_pushes: int | None = None
    total_wikis: int | None = None


class Users(BaseModel):
    total_users: int | None = None
    admin_users: int | None = None
    suspended_users: int | None = None


class GheStats(BaseModel):
    comments: Comments | None = None
    gists: Gists | None = None
    hooks: Hooks | None = None
    issues: Issues1 | None = None
    milestones: Milestones | None = None
    orgs: Orgs | None = None
    pages: Pages1 | None = None
    pulls: Pulls | None = None
    repos: Repos | None = None
    users: Users | None = None


class DormantUsers(BaseModel):
    total_dormant_users: int | None = None
    dormancy_threshold: str | None = None


class ServerStatistic(BaseModel):
    server_id: str | None = None
    collection_date: str | None = None
    schema_version: str | None = None
    ghes_version: str | None = None
    host_name: str | None = None
    github_connect: GithubConnect | None = None
    ghe_stats: GheStats | None = None
    dormant_users: DormantUsers | None = None


class ServerStatistics(BaseModel):
    """
    Response of S4 Proxy endpoint that provides GHES statistics
    """

    __root__: Annotated[
        Sequence[ServerStatistic] | None,
        Field(title="Server Statistics Proxy Endpoint"),
    ] = None
    """
    Response of S4 Proxy endpoint that provides GHES statistics
    """


class ActionsCacheUsageOrgEnterprise(BaseModel):
    total_active_caches_count: int | None = None
    """
    The count of active caches across all repositories of an enterprise or an organization.
    """
    total_active_caches_size_in_bytes: int | None = None
    """
    The total size in bytes of all active cache items across all repositories of an enterprise or an organization.
    """


class EnabledOrganizations(Enum):
    """
    The policy that controls the organizations in the enterprise that are allowed to run GitHub Actions.
    """

    all = "all"
    none = "none"
    selected = "selected"


class AllowedActions(Enum):
    """
    The permissions policy that controls the actions and reusable workflows that are allowed to run.
    """

    all = "all"
    local_only = "local_only"
    selected = "selected"


class ActionsEnterprisePermissions(BaseModel):
    enabled_organizations: EnabledOrganizations | None = None
    selected_organizations_url: str | None = None
    """
    The API URL to use to get or set the selected organizations that are allowed to run GitHub Actions, when `enabled_organizations` is set to `selected`.
    """
    allowed_actions: AllowedActions | None = None
    selected_actions_url: str | None = None
    """
    The API URL to use to get or set the actions and reusable workflows that are allowed to run, when `allowed_actions` is set to `selected`.
    """


class OrganizationSimple(BaseModel):
    """
    Organization Simple
    """

    login: Annotated[str | None, Field(example="github")] = None
    id: Annotated[int | None, Field(example=1)] = None
    node_id: Annotated[str | None, Field(example="MDEyOk9yZ2FuaXphdGlvbjE=")] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/orgs/github")
    ] = None
    repos_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/orgs/github/repos")
    ] = None
    events_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/orgs/github/events")
    ] = None
    hooks_url: Annotated[
        str | None, Field(example="https://api.github.com/orgs/github/hooks")
    ] = None
    issues_url: Annotated[
        str | None, Field(example="https://api.github.com/orgs/github/issues")
    ] = None
    members_url: Annotated[
        str | None, Field(example="https://api.github.com/orgs/github/members{/member}")
    ] = None
    public_members_url: Annotated[
        str | None,
        Field(example="https://api.github.com/orgs/github/public_members{/member}"),
    ] = None
    avatar_url: Annotated[
        str | None, Field(example="https://github.com/images/error/octocat_happy.gif")
    ] = None
    description: Annotated[str | None, Field(example="A great organization")] = None


class SelectedActions(BaseModel):
    github_owned_allowed: bool | None = None
    """
    Whether GitHub-owned actions are allowed. For example, this includes the actions in the `actions` organization.
    """
    verified_allowed: bool | None = None
    """
    Whether actions from GitHub Marketplace verified creators are allowed. Set to `true` to allow all actions by GitHub Marketplace verified creators.
    """
    patterns_allowed: Sequence[str] | None = None
    """
    Specifies a list of string-matching patterns to allow specific action(s) and reusable workflow(s). Wildcards, tags, and SHAs are allowed. For example, `monalisa/octocat@*`, `monalisa/octocat@v2`, `monalisa/*`."
    """


class ActionsDefaultWorkflowPermissions(Enum):
    """
    The default workflow permissions granted to the GITHUB_TOKEN when running workflows.
    """

    read = "read"
    write = "write"


class ActionsGetDefaultWorkflowPermissions(BaseModel):
    default_workflow_permissions: ActionsDefaultWorkflowPermissions | None = None
    can_approve_pull_request_reviews: bool | None = None
    """
    Whether GitHub Actions can approve pull requests. Enabling this can be a security risk.
    """


class ActionsSetDefaultWorkflowPermissions(BaseModel):
    default_workflow_permissions: ActionsDefaultWorkflowPermissions | None = None
    can_approve_pull_request_reviews: bool | None = None
    """
    Whether GitHub Actions can approve pull requests. Enabling this can be a security risk.
    """


class RunnerGroupsEnterprise(BaseModel):
    id: float | None = None
    name: str | None = None
    visibility: str | None = None
    default: bool | None = None
    selected_organizations_url: str | None = None
    runners_url: str | None = None
    allows_public_repositories: bool | None = None
    workflow_restrictions_read_only: bool | None = False
    """
    If `true`, the `restricted_to_workflows` and `selected_workflows` fields cannot be modified.
    """
    restricted_to_workflows: bool | None = False
    """
    If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array.
    """
    selected_workflows: Sequence[str] | None = None
    """
    List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`.
    """


class Type(Enum):
    """
    The type of label. Read-only labels are applied automatically when the runner is configured.
    """

    read_only = "read-only"
    custom = "custom"


class RunnerLabel(BaseModel):
    """
    A label for a self hosted runner
    """

    id: int | None = None
    """
    Unique identifier of the label.
    """
    name: str | None = None
    """
    Name of the label.
    """
    type: Type | None = None
    """
    The type of label. Read-only labels are applied automatically when the runner is configured.
    """


class Runner(BaseModel):
    """
    A self hosted runner
    """

    id: Annotated[int | None, Field(example=5)] = None
    """
    The id of the runner.
    """
    name: Annotated[str | None, Field(example="iMac")] = None
    """
    The name of the runner.
    """
    os: Annotated[str | None, Field(example="macos")] = None
    """
    The Operating System of the runner.
    """
    status: Annotated[str | None, Field(example="online")] = None
    """
    The status of the runner.
    """
    busy: bool | None = None
    labels: Sequence[RunnerLabel] | None = None


class RunnerApplication(BaseModel):
    """
    Runner Application
    """

    os: str | None = None
    architecture: str | None = None
    download_url: str | None = None
    filename: str | None = None
    temp_download_token: str | None = None
    """
    A short lived bearer token used to download the runner, if needed.
    """
    sha256_checksum: str | None = None


class AuthenticationToken(BaseModel):
    """
    Authentication Token
    """

    token: Annotated[str | None, Field(example="v1.1f699f1069f60xxx")] = None
    """
    The token used for authentication
    """
    expires_at: Annotated[datetime | None, Field(example="2016-07-11T22:14:10Z")] = None
    """
    The time this token expires
    """
    permissions: Annotated[
        Mapping[str, Any] | None,
        Field(example={"issues": "read", "deployments": "write"}),
    ] = None
    repositories: Sequence[Repository] | None = None
    """
    The repositories this token has access to
    """
    single_file: Annotated[str | None, Field(example="config.yaml")] = None
    repository_selection: RepositorySelection2 | None = None
    """
    Describe whether all repositories have been selected or there's a selection involved
    """


class CodeScanningAlertState(Enum):
    """
    State of a code scanning alert.
    """

    open = "open"
    closed = "closed"
    dismissed = "dismissed"
    fixed = "fixed"


class CodeScanningAlertDismissedReasonEnum(Enum):
    """
    **Required when the state is dismissed.** The reason for dismissing or closing the alert.
    """

    false_positive = "false positive"
    won_t_fix = "won't fix"
    used_in_tests = "used in tests"


class Severity(Enum):
    """
    The severity of the alert.
    """

    none = "none"
    note = "note"
    warning = "warning"
    error = "error"


class SecuritySeverityLevel(Enum):
    """
    The security severity of the alert.
    """

    low = "low"
    medium = "medium"
    high = "high"
    critical = "critical"


class CodeScanningAlertRule(BaseModel):
    id: str | None = None
    """
    A unique identifier for the rule used to detect the alert.
    """
    name: str | None = None
    """
    The name of the rule used to detect the alert.
    """
    severity: Severity | None = None
    """
    The severity of the alert.
    """
    security_severity_level: SecuritySeverityLevel | None = None
    """
    The security severity of the alert.
    """
    description: str | None = None
    """
    A short description of the rule used to detect the alert.
    """
    full_description: str | None = None
    """
    description of the rule used to detect the alert.
    """
    tags: Sequence[str] | None = None
    """
    A set of tags applicable for the rule.
    """
    help: str | None = None
    """
    Detailed documentation for the rule as GitHub Flavored Markdown.
    """
    help_uri: str | None = None
    """
    A link to the documentation for the rule used to detect the alert.
    """


class CodeScanningAnalysisTool(BaseModel):
    name: str | None = None
    """
    The name of the tool used to generate the code scanning analysis.
    """
    version: str | None = None
    """
    The version of the tool used to generate the code scanning analysis.
    """
    guid: str | None = None
    """
    The GUID of the tool used to generate the code scanning analysis, if provided in the uploaded SARIF data.
    """


class CodeScanningAlertLocation(BaseModel):
    """
    Describe a region within a file for the alert.
    """

    path: str | None = None
    start_line: int | None = None
    end_line: int | None = None
    start_column: int | None = None
    end_column: int | None = None


class CodeScanningAlertClassification(Enum):
    """
    A classification of the file. For example to identify it as generated.
    """

    source = "source"
    generated = "generated"
    test = "test"
    library = "library"


class Message(BaseModel):
    text: str | None = None


class CodeScanningAlertInstance(BaseModel):
    ref: str | None = None
    """
    The full Git reference, formatted as `refs/heads/<branch name>`,
    `refs/pull/<number>/merge`, or `refs/pull/<number>/head`.
    """
    analysis_key: str | None = None
    """
    Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
    """
    environment: str | None = None
    """
    Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
    """
    category: str | None = None
    """
    Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code.
    """
    state: CodeScanningAlertState | None = None
    commit_sha: str | None = None
    message: Message | None = None
    location: CodeScanningAlertLocation | None = None
    html_url: str | None = None
    classifications: Sequence[CodeScanningAlertClassification] | None = None
    """
    Classifications that have been applied to the file that triggered the alert.
    For example identifying it as documentation, or a generated file.
    """


class SimpleRepository(BaseModel):
    """
    Simple Repository
    """

    id: Annotated[int | None, Field(example=1296269)] = None
    """
    A unique identifier of the repository.
    """
    node_id: Annotated[str | None, Field(example="MDEwOlJlcG9zaXRvcnkxMjk2MjY5")] = None
    """
    The GraphQL identifier of the repository.
    """
    name: Annotated[str | None, Field(example="Hello-World")] = None
    """
    The name of the repository.
    """
    full_name: Annotated[str | None, Field(example="octocat/Hello-World")] = None
    """
    The full, globally unique, name of the repository.
    """
    owner: SimpleUser | None = None
    private: bool | None = None
    """
    Whether the repository is private.
    """
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat/Hello-World")
    ] = None
    """
    The URL to view the repository on GitHub.com.
    """
    description: Annotated[str | None, Field(example="This your first repo!")] = None
    """
    The repository description.
    """
    fork: bool | None = None
    """
    Whether the repository is a fork.
    """
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/repos/octocat/Hello-World")
    ] = None
    """
    The URL to get more information about the repository from the GitHub API.
    """
    archive_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}"
        ),
    ] = None
    """
    A template for the API URL to download the repository as an archive.
    """
    assignees_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/assignees{/user}"
        ),
    ] = None
    """
    A template for the API URL to list the available assignees for issues in the repository.
    """
    blobs_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}"
        ),
    ] = None
    """
    A template for the API URL to create or retrieve a raw Git blob in the repository.
    """
    branches_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/branches{/branch}"
        ),
    ] = None
    """
    A template for the API URL to get information about branches in the repository.
    """
    collaborators_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}"
        ),
    ] = None
    """
    A template for the API URL to get information about collaborators of the repository.
    """
    comments_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/comments{/number}"
        ),
    ] = None
    """
    A template for the API URL to get information about comments on the repository.
    """
    commits_url: Annotated[
        str | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/commits{/sha}"),
    ] = None
    """
    A template for the API URL to get information about commits on the repository.
    """
    compare_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}"
        ),
    ] = None
    """
    A template for the API URL to compare two commits or refs.
    """
    contents_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/contents/{+path}"
        ),
    ] = None
    """
    A template for the API URL to get the contents of the repository.
    """
    contributors_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/contributors"),
    ] = None
    """
    A template for the API URL to list the contributors to the repository.
    """
    deployments_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/deployments"),
    ] = None
    """
    The API URL to list the deployments of the repository.
    """
    downloads_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/downloads"),
    ] = None
    """
    The API URL to list the downloads on the repository.
    """
    events_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/events"),
    ] = None
    """
    The API URL to list the events of the repository.
    """
    forks_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/forks"),
    ] = None
    """
    The API URL to list the forks of the repository.
    """
    git_commits_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/git/commits{/sha}"
        ),
    ] = None
    """
    A template for the API URL to get information about Git commits of the repository.
    """
    git_refs_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/git/refs{/sha}"
        ),
    ] = None
    """
    A template for the API URL to get information about Git refs of the repository.
    """
    git_tags_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/git/tags{/sha}"
        ),
    ] = None
    """
    A template for the API URL to get information about Git tags of the repository.
    """
    issue_comment_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/issues/comments{/number}"
        ),
    ] = None
    """
    A template for the API URL to get information about issue comments on the repository.
    """
    issue_events_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/issues/events{/number}"
        ),
    ] = None
    """
    A template for the API URL to get information about issue events on the repository.
    """
    issues_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/issues{/number}"
        ),
    ] = None
    """
    A template for the API URL to get information about issues on the repository.
    """
    keys_url: Annotated[
        str | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/keys{/key_id}"),
    ] = None
    """
    A template for the API URL to get information about deploy keys on the repository.
    """
    labels_url: Annotated[
        str | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/labels{/name}"),
    ] = None
    """
    A template for the API URL to get information about labels of the repository.
    """
    languages_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/languages"),
    ] = None
    """
    The API URL to get information about the languages of the repository.
    """
    merges_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/merges"),
    ] = None
    """
    The API URL to merge branches in the repository.
    """
    milestones_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/milestones{/number}"
        ),
    ] = None
    """
    A template for the API URL to get information about milestones of the repository.
    """
    notifications_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}"
        ),
    ] = None
    """
    A template for the API URL to get information about notifications on the repository.
    """
    pulls_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/pulls{/number}"
        ),
    ] = None
    """
    A template for the API URL to get information about pull requests on the repository.
    """
    releases_url: Annotated[
        str | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/releases{/id}"),
    ] = None
    """
    A template for the API URL to get information about releases on the repository.
    """
    stargazers_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/stargazers"),
    ] = None
    """
    The API URL to list the stargazers on the repository.
    """
    statuses_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/statuses/{sha}"
        ),
    ] = None
    """
    A template for the API URL to get information about statuses of a commit.
    """
    subscribers_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/subscribers"),
    ] = None
    """
    The API URL to list the subscribers on the repository.
    """
    subscription_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/subscription"),
    ] = None
    """
    The API URL to subscribe to notifications for this repository.
    """
    tags_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/tags"),
    ] = None
    """
    The API URL to get information about tags on the repository.
    """
    teams_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/teams"),
    ] = None
    """
    The API URL to list the teams on the repository.
    """
    trees_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/git/trees{/sha}"
        ),
    ] = None
    """
    A template for the API URL to create or retrieve a raw Git tree of the repository.
    """
    hooks_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/hooks"),
    ] = None
    """
    The API URL to list the hooks on the repository.
    """


class CodeScanningOrganizationAlertItems(BaseModel):
    number: int | None = None
    """
    The security alert number.
    """
    created_at: datetime | None = None
    """
    The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    updated_at: datetime | None = None
    """
    The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    url: AnyUrl | None = None
    """
    The REST API URL of the alert resource.
    """
    html_url: AnyUrl | None = None
    """
    The GitHub URL of the alert resource.
    """
    instances_url: AnyUrl | None = None
    """
    The REST API URL for fetching the list of instances for an alert.
    """
    state: CodeScanningAlertState | None = None
    fixed_at: datetime | None = None
    """
    The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_by: NullableSimpleUser | None = None
    dismissed_at: datetime | None = None
    """
    The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_reason: CodeScanningAlertDismissedReasonEnum | None = None
    """
    **Required when the state is dismissed.** The reason for dismissing or closing the alert.
    """
    dismissed_comment: Annotated[str | None, Field(max_length=280)] = None
    """
    The dismissal comment associated with the dismissal of the alert.
    """
    rule: CodeScanningAlertRule | None = None
    tool: CodeScanningAnalysisTool | None = None
    most_recent_instance: CodeScanningAlertInstance | None = None
    repository: SimpleRepository | None = None


class SecretScanningAlertState(Enum):
    """
    Sets the state of the secret scanning alert. You must provide `resolution` when you set the state to `resolved`.
    """

    open = "open"
    resolved = "resolved"


class SecretScanningAlertResolutionEnum(Enum):
    """
    **Required when the `state` is `resolved`.** The reason for resolving the alert.
    """

    false_positive = "false_positive"
    wont_fix = "wont_fix"
    revoked = "revoked"
    used_in_tests = "used_in_tests"


class OrganizationSecretScanningAlert(BaseModel):
    number: int | None = None
    """
    The security alert number.
    """
    created_at: datetime | None = None
    """
    The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    updated_at: datetime | None = None
    """
    The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    url: AnyUrl | None = None
    """
    The REST API URL of the alert resource.
    """
    html_url: AnyUrl | None = None
    """
    The GitHub URL of the alert resource.
    """
    locations_url: AnyUrl | None = None
    """
    The REST API URL of the code locations for this alert.
    """
    state: SecretScanningAlertState | None = None
    resolution: SecretScanningAlertResolutionEnum | None = None
    """
    **Required when the `state` is `resolved`.** The reason for resolving the alert.
    """
    resolved_at: datetime | None = None
    """
    The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    resolved_by: NullableSimpleUser | None = None
    secret_type: str | None = None
    """
    The type of secret that secret scanning detected.
    """
    secret_type_display_name: str | None = None
    """
    User-friendly name for the detected secret, matching the `secret_type`.
    For a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."
    """
    secret: str | None = None
    """
    The secret that was detected.
    """
    repository: SimpleRepository | None = None
    push_protection_bypassed: bool | None = None
    """
    Whether push protection was bypassed for the detected secret.
    """
    push_protection_bypassed_by: NullableSimpleUser | None = None
    push_protection_bypassed_at: datetime | None = None
    """
    The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    resolution_comment: str | None = None
    """
    The comment that was optionally added when this alert was closed
    """


class AdvancedSecurityActiveCommittersUser(BaseModel):
    user_login: str | None = None
    last_pushed_date: Annotated[str | None, Field(example="2021-11-03")] = None


class AdvancedSecurityActiveCommittersRepository(BaseModel):
    name: Annotated[str | None, Field(example="octocat/Hello-World")] = None
    advanced_security_committers: Annotated[int | None, Field(example=25)] = None
    advanced_security_committers_breakdown: Sequence[
        AdvancedSecurityActiveCommittersUser
    ] | None = None


class AdvancedSecurityActiveCommitters(BaseModel):
    total_advanced_security_committers: Annotated[int | None, Field(example=25)] = None
    total_count: Annotated[int | None, Field(example=2)] = None
    repositories: Sequence[AdvancedSecurityActiveCommittersRepository] | None = None


class Actor(BaseModel):
    """
    Actor
    """

    id: int | None = None
    login: str | None = None
    display_login: str | None = None
    gravatar_id: str | None = None
    url: AnyUrl | None = None
    avatar_url: AnyUrl | None = None


class State(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class NullableMilestone(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/milestones/1"),
    ] = None
    html_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/octocat/Hello-World/milestones/v1.0"),
    ] = None
    labels_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/milestones/1/labels"
        ),
    ] = None
    id: Annotated[int | None, Field(example=1002604)] = None
    node_id: Annotated[str | None, Field(example="MDk6TWlsZXN0b25lMTAwMjYwNA==")] = None
    number: Annotated[int | None, Field(example=42)] = None
    """
    The number of the milestone.
    """
    state: Annotated[State | None, Field(example="open")] = "open"
    """
    The state of the milestone.
    """
    title: Annotated[str | None, Field(example="v1.0")] = None
    """
    The title of the milestone.
    """
    description: Annotated[
        str | None, Field(example="Tracking milestone for version 1.0")
    ] = None
    creator: NullableSimpleUser | None = None
    open_issues: Annotated[int | None, Field(example=4)] = None
    closed_issues: Annotated[int | None, Field(example=8)] = None
    created_at: Annotated[datetime | None, Field(example="2011-04-10T20:09:31Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2014-03-03T18:58:10Z")] = None
    closed_at: Annotated[datetime | None, Field(example="2013-02-12T13:22:01Z")] = None
    due_on: Annotated[datetime | None, Field(example="2012-10-09T23:39:01Z")] = None


class Permissions3(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    issues: str | None = None
    checks: str | None = None
    metadata: str | None = None
    contents: str | None = None
    deployments: str | None = None


class NullableIntegration(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    id: Annotated[int | None, Field(example=37)] = None
    """
    Unique identifier of the GitHub app
    """
    slug: Annotated[str | None, Field(example="probot-owners")] = None
    """
    The slug name of the GitHub app
    """
    node_id: Annotated[str | None, Field(example="MDExOkludGVncmF0aW9uMQ==")] = None
    owner: NullableSimpleUser | None = None
    name: Annotated[str | None, Field(example="Probot Owners")] = None
    """
    The name of the GitHub app
    """
    description: Annotated[
        str | None, Field(example="The description of the app.")
    ] = None
    external_url: Annotated[AnyUrl | None, Field(example="https://example.com")] = None
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/apps/super-ci")
    ] = None
    created_at: Annotated[
        datetime | None, Field(example="2017-07-08T16:18:44-04:00")
    ] = None
    updated_at: Annotated[
        datetime | None, Field(example="2017-07-08T16:18:44-04:00")
    ] = None
    permissions: Annotated[
        Permissions3 | None, Field(example={"issues": "read", "deployments": "write"})
    ] = None
    """
    The set of permissions for the GitHub app
    """
    events: Annotated[
        Sequence[str] | None, Field(example=["label", "deployment"])
    ] = None
    """
    The list of events for the GitHub app
    """
    installations_count: Annotated[int | None, Field(example=5)] = None
    """
    The number of installations associated with the GitHub app
    """
    client_id: Annotated[str | None, Field(example='"Iv1.25b5d1e65ffc4022"')] = None
    client_secret: Annotated[
        str | None, Field(example='"1d4b2097ac622ba702d19de498f005747a8b21d3"')
    ] = None
    webhook_secret: Annotated[
        str | None, Field(example='"6fba8f2fc8a7e8f2cca5577eddd82ca7586b3b6b"')
    ] = None
    pem: Annotated[
        str | None,
        Field(
            example='"-----BEGIN RSA PRIVATE KEY-----\\nMIIEogIBAAKCAQEArYxrNYD/iT5CZVpRJu4rBKmmze3PVmT/gCo2ATUvDvZTPTey\\nxcGJ3vvrJXazKk06pN05TN29o98jrYz4cengG3YGsXPNEpKsIrEl8NhbnxapEnM9\\nJCMRe0P5JcPsfZlX6hmiT7136GRWiGOUba2X9+HKh8QJVLG5rM007TBER9/z9mWm\\nrJuNh+m5l320oBQY/Qq3A7wzdEfZw8qm/mIN0FCeoXH1L6B8xXWaAYBwhTEh6SSn\\nZHlO1Xu1JWDmAvBCi0RO5aRSKM8q9QEkvvHP4yweAtK3N8+aAbZ7ovaDhyGz8r6r\\nzhU1b8Uo0Z2ysf503WqzQgIajr7Fry7/kUwpgQIDAQABAoIBADwJp80Ko1xHPZDy\\nfcCKBDfIuPvkmSW6KumbsLMaQv1aGdHDwwTGv3t0ixSay8CGlxMRtRDyZPib6SvQ\\n6OH/lpfpbMdW2ErkksgtoIKBVrDilfrcAvrNZu7NxRNbhCSvN8q0s4ICecjbbVQh\\nnueSdlA6vGXbW58BHMq68uRbHkP+k+mM9U0mDJ1HMch67wlg5GbayVRt63H7R2+r\\nVxcna7B80J/lCEjIYZznawgiTvp3MSanTglqAYi+m1EcSsP14bJIB9vgaxS79kTu\\noiSo93leJbBvuGo8QEiUqTwMw4tDksmkLsoqNKQ1q9P7LZ9DGcujtPy4EZsamSJT\\ny8OJt0ECgYEA2lxOxJsQk2kI325JgKFjo92mQeUObIvPfSNWUIZQDTjniOI6Gv63\\nGLWVFrZcvQBWjMEQraJA9xjPbblV8PtfO87MiJGLWCHFxmPz2dzoedN+2Coxom8m\\nV95CLz8QUShuao6u/RYcvUaZEoYs5bHcTmy5sBK80JyEmafJPtCQVxMCgYEAy3ar\\nZr3yv4xRPEPMat4rseswmuMooSaK3SKub19WFI5IAtB/e7qR1Rj9JhOGcZz+OQrl\\nT78O2OFYlgOIkJPvRMrPpK5V9lslc7tz1FSh3BZMRGq5jSyD7ETSOQ0c8T2O/s7v\\nbeEPbVbDe4mwvM24XByH0GnWveVxaDl51ABD65sCgYB3ZAspUkOA5egVCh8kNpnd\\nSd6SnuQBE3ySRlT2WEnCwP9Ph6oPgn+oAfiPX4xbRqkL8q/k0BdHQ4h+zNwhk7+h\\nWtPYRAP1Xxnc/F+jGjb+DVaIaKGU18MWPg7f+FI6nampl3Q0KvfxwX0GdNhtio8T\\nTj1E+SnFwh56SRQuxSh2gwKBgHKjlIO5NtNSflsUYFM+hyQiPiqnHzddfhSG+/3o\\nm5nNaSmczJesUYreH5San7/YEy2UxAugvP7aSY2MxB+iGsiJ9WD2kZzTUlDZJ7RV\\nUzWsoqBR+eZfVJ2FUWWvy8TpSG6trh4dFxImNtKejCR1TREpSiTV3Zb1dmahK9GV\\nrK9NAoGAbBxRLoC01xfxCTgt5BDiBcFVh4fp5yYKwavJPLzHSpuDOrrI9jDn1oKN\\nonq5sDU1i391zfQvdrbX4Ova48BN+B7p63FocP/MK5tyyBoT8zQEk2+vWDOw7H/Z\\nu5dTCPxTIsoIwUw1I+7yIxqJzLPFgR2gVBwY1ra/8iAqCj+zeBw=\\n-----END RSA PRIVATE KEY-----\\n"'
        ),
    ] = None


class AuthorAssociation(Enum):
    """
    How the author is associated with the repository.
    """

    COLLABORATOR = "COLLABORATOR"
    CONTRIBUTOR = "CONTRIBUTOR"
    FIRST_TIMER = "FIRST_TIMER"
    FIRST_TIME_CONTRIBUTOR = "FIRST_TIME_CONTRIBUTOR"
    MANNEQUIN = "MANNEQUIN"
    MEMBER = "MEMBER"
    NONE = "NONE"
    OWNER = "OWNER"


class ReactionRollup(BaseModel):
    url: AnyUrl | None = None
    total_count: int | None = None
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    laugh: int | None = None
    confused: int | None = None
    heart: int | None = None
    hooray: int | None = None
    eyes: int | None = None
    rocket: int | None = None


class StateReason(Enum):
    """
    The reason for the current state
    """

    completed = "completed"
    reopened = "reopened"
    not_planned = "not_planned"


class Label(BaseModel):
    id: int | None = None
    node_id: str | None = None
    url: AnyUrl | None = None
    name: str | None = None
    description: str | None = None
    color: str | None = None
    default: bool | None = None


class PullRequest(BaseModel):
    merged_at: datetime | None = None
    diff_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    patch_url: AnyUrl | None = None
    url: AnyUrl | None = None


class Issue(BaseModel):
    """
    Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.
    """

    id: int | None = None
    node_id: str | None = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/repositories/42/issues/1")
    ] = None
    """
    URL for the issue
    """
    repository_url: AnyUrl | None = None
    labels_url: str | None = None
    comments_url: AnyUrl | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    number: Annotated[int | None, Field(example=42)] = None
    """
    Number uniquely identifying the issue within its repository
    """
    state: Annotated[str | None, Field(example="open")] = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: Annotated[StateReason | None, Field(example="not_planned")] = None
    """
    The reason for the current state
    """
    title: Annotated[
        str | None, Field(example="Widget creation fails in Safari on OS X 10.8")
    ] = None
    """
    Title of the issue
    """
    body: Annotated[
        str | None,
        Field(
            example="It looks like the new widget form is broken on Safari. When I try and create the widget, Safari crashes. This is reproducible on 10.8, but not 10.9. Maybe a browser bug?"
        ),
    ] = None
    """
    Contents of the issue
    """
    user: NullableSimpleUser | None = None
    labels: Annotated[
        Sequence[str | Label] | None, Field(example=["bug", "registration"])
    ] = None
    """
    Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
    """
    assignee: NullableSimpleUser | None = None
    assignees: Sequence[SimpleUser] | None = None
    milestone: NullableMilestone | None = None
    locked: bool | None = None
    active_lock_reason: str | None = None
    comments: int | None = None
    pull_request: PullRequest | None = None
    closed_at: datetime | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    draft: bool | None = None
    closed_by: NullableSimpleUser | None = None
    body_html: str | None = None
    body_text: str | None = None
    timeline_url: AnyUrl | None = None
    repository: Repository | None = None
    performed_via_github_app: NullableIntegration | None = None
    author_association: AuthorAssociation | None = None
    reactions: ReactionRollup | None = None


class IssueComment(BaseModel):
    """
    Comments provide a way for people to collaborate on an issue.
    """

    id: Annotated[int | None, Field(example=42)] = None
    """
    Unique identifier of the issue comment
    """
    node_id: str | None = None
    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repositories/42/issues/comments/1"),
    ] = None
    """
    URL for the issue comment
    """
    body: Annotated[
        str | None,
        Field(
            example="What version of Safari were you using when you observed this bug?"
        ),
    ] = None
    """
    Contents of the issue comment
    """
    body_text: str | None = None
    body_html: str | None = None
    html_url: AnyUrl | None = None
    user: NullableSimpleUser | None = None
    created_at: Annotated[datetime | None, Field(example="2011-04-14T16:00:49Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2011-04-14T16:00:49Z")] = None
    issue_url: AnyUrl | None = None
    author_association: AuthorAssociation | None = None
    performed_via_github_app: NullableIntegration | None = None
    reactions: ReactionRollup | None = None


class Repo(BaseModel):
    id: int | None = None
    name: str | None = None
    url: AnyUrl | None = None


class Page(BaseModel):
    page_name: str | None = None
    title: str | None = None
    summary: str | None = None
    action: str | None = None
    sha: str | None = None
    html_url: str | None = None


class Payload(BaseModel):
    action: str | None = None
    issue: Issue | None = None
    comment: IssueComment | None = None
    pages: Sequence[Page] | None = None


class Event(BaseModel):
    """
    Event
    """

    id: str | None = None
    type: str | None = None
    actor: Actor | None = None
    repo: Repo | None = None
    org: Actor | None = None
    payload: Payload | None = None
    public: bool | None = None
    created_at: datetime | None = None


class LinkWithType(BaseModel):
    """
    Hypermedia Link with Type
    """

    href: str | None = None
    type: str | None = None


class FieldLinks(BaseModel):
    timeline: LinkWithType | None = None
    user: LinkWithType | None = None
    security_advisories: LinkWithType | None = None
    current_user: LinkWithType | None = None
    current_user_public: LinkWithType | None = None
    current_user_actor: LinkWithType | None = None
    current_user_organization: LinkWithType | None = None
    current_user_organizations: Sequence[LinkWithType] | None = None


class Feed(BaseModel):
    """
    Feed
    """

    timeline_url: Annotated[
        str | None, Field(example="https://github.com/timeline")
    ] = None
    user_url: Annotated[str | None, Field(example="https://github.com/{user}")] = None
    current_user_public_url: Annotated[
        str | None, Field(example="https://github.com/octocat")
    ] = None
    current_user_url: Annotated[
        str | None, Field(example="https://github.com/octocat.private?token=abc123")
    ] = None
    current_user_actor_url: Annotated[
        str | None,
        Field(example="https://github.com/octocat.private.actor?token=abc123"),
    ] = None
    current_user_organization_url: Annotated[
        str | None, Field(example="https://github.com/octocat-org")
    ] = None
    current_user_organization_urls: Annotated[
        Sequence[AnyUrl] | None,
        Field(
            example=[
                "https://github.com/organizations/github/octocat.private.atom?token=abc123"
            ]
        ),
    ] = None
    security_advisories_url: Annotated[
        str | None, Field(example="https://github.com/security-advisories")
    ] = None
    field_links: Annotated[FieldLinks | None, Field(alias="_links")] = None


class Files(BaseModel):
    filename: str | None = None
    type: str | None = None
    language: str | None = None
    raw_url: str | None = None
    size: int | None = None


class BaseGist(BaseModel):
    """
    Base Gist
    """

    url: AnyUrl | None = None
    forks_url: AnyUrl | None = None
    commits_url: AnyUrl | None = None
    id: str | None = None
    node_id: str | None = None
    git_pull_url: AnyUrl | None = None
    git_push_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    files: Mapping[str, Files] | None = None
    public: bool | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    description: str | None = None
    comments: int | None = None
    user: NullableSimpleUser | None = None
    comments_url: AnyUrl | None = None
    owner: SimpleUser | None = None
    truncated: bool | None = None
    forks: Sequence | None = None
    history: Sequence | None = None


class Plan(BaseModel):
    collaborators: int | None = None
    name: str | None = None
    space: int | None = None
    private_repos: int | None = None


class PublicUser(BaseModel):
    """
    Public User
    """

    class Config:
        extra = Extra.forbid

    login: str | None = None
    id: int | None = None
    node_id: str | None = None
    avatar_url: AnyUrl | None = None
    gravatar_id: str | None = None
    url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    organizations_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    events_url: str | None = None
    received_events_url: AnyUrl | None = None
    type: str | None = None
    site_admin: bool | None = None
    name: str | None = None
    company: str | None = None
    blog: str | None = None
    location: str | None = None
    email: EmailStr | None = None
    hireable: bool | None = None
    bio: str | None = None
    twitter_username: str | None = None
    public_repos: int | None = None
    public_gists: int | None = None
    followers: int | None = None
    following: int | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    plan: Plan | None = None
    suspended_at: datetime | None = None
    private_gists: Annotated[int | None, Field(example=1)] = None
    total_private_repos: Annotated[int | None, Field(example=2)] = None
    owned_private_repos: Annotated[int | None, Field(example=2)] = None
    disk_usage: Annotated[int | None, Field(example=1)] = None
    collaborators: Annotated[int | None, Field(example=3)] = None


class ChangeStatus(BaseModel):
    total: int | None = None
    additions: int | None = None
    deletions: int | None = None


class GistHistory(BaseModel):
    """
    Gist History
    """

    user: NullableSimpleUser | None = None
    version: str | None = None
    committed_at: datetime | None = None
    change_status: ChangeStatus | None = None
    url: AnyUrl | None = None


class Fork(BaseModel):
    id: str | None = None
    url: AnyUrl | None = None
    user: PublicUser | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None


class ForkOf(BaseModel):
    """
    Gist
    """

    url: AnyUrl | None = None
    forks_url: AnyUrl | None = None
    commits_url: AnyUrl | None = None
    id: str | None = None
    node_id: str | None = None
    git_pull_url: AnyUrl | None = None
    git_push_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    files: Mapping[str, Files] | None = None
    public: bool | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    description: str | None = None
    comments: int | None = None
    user: NullableSimpleUser | None = None
    comments_url: AnyUrl | None = None
    owner: NullableSimpleUser | None = None
    truncated: bool | None = None
    forks: Sequence | None = None
    history: Sequence | None = None


class Files2(BaseModel):
    filename: str | None = None
    type: str | None = None
    language: str | None = None
    raw_url: str | None = None
    size: int | None = None
    truncated: bool | None = None
    content: str | None = None


class GistSimple(BaseModel):
    """
    Gist Simple
    """

    forks: Sequence[Fork] | None = None
    history: Sequence[GistHistory] | None = None
    fork_of: Annotated[ForkOf | None, Field(title="Gist")] = None
    """
    Gist
    """
    url: str | None = None
    forks_url: str | None = None
    commits_url: str | None = None
    id: str | None = None
    node_id: str | None = None
    git_pull_url: str | None = None
    git_push_url: str | None = None
    html_url: str | None = None
    files: Mapping[str, Files2] | None = None
    public: bool | None = None
    created_at: str | None = None
    updated_at: str | None = None
    description: str | None = None
    comments: int | None = None
    user: str | None = None
    comments_url: str | None = None
    owner: SimpleUser | None = None
    truncated: bool | None = None


class GistComment(BaseModel):
    """
    A comment made to a gist.
    """

    id: Annotated[int | None, Field(example=1)] = None
    node_id: Annotated[str | None, Field(example="MDExOkdpc3RDb21tZW50MQ==")] = None
    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/gists/a6db0bec360bb87e9418/comments/1"),
    ] = None
    body: Annotated[
        str | None, Field(example="Body of the attachment", max_length=65535)
    ] = None
    """
    The comment text.
    """
    user: NullableSimpleUser | None = None
    created_at: Annotated[datetime | None, Field(example="2011-04-18T23:23:56Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2011-04-18T23:23:56Z")] = None
    author_association: AuthorAssociation | None = None


class GistCommit(BaseModel):
    """
    Gist Commit
    """

    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/gists/aa5a315d61ae9438b18d/57a7f021a713b1c5a6a199b54cc514735d2d462f"
        ),
    ] = None
    version: Annotated[
        str | None, Field(example="57a7f021a713b1c5a6a199b54cc514735d2d462f")
    ] = None
    user: NullableSimpleUser | None = None
    change_status: ChangeStatus | None = None
    committed_at: Annotated[
        datetime | None, Field(example="2010-04-14T02:15:15Z")
    ] = None


class GitignoreTemplate(BaseModel):
    """
    Gitignore Template
    """

    name: Annotated[str | None, Field(example="C")] = None
    source: Annotated[
        str | None,
        Field(
            example="# Object files\n*.o\n\n# Libraries\n*.lib\n*.a\n\n# Shared objects (inc. Windows DLLs)\n*.dll\n*.so\n*.so.*\n*.dylib\n\n# Executables\n*.exe\n*.out\n*.app\n"
        ),
    ] = None


class LicenseSimple(BaseModel):
    """
    License Simple
    """

    key: Annotated[str | None, Field(example="mit")] = None
    name: Annotated[str | None, Field(example="MIT License")] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/licenses/mit")
    ] = None
    spdx_id: Annotated[str | None, Field(example="MIT")] = None
    node_id: Annotated[str | None, Field(example="MDc6TGljZW5zZW1pdA==")] = None
    html_url: AnyUrl | None = None


class License(BaseModel):
    """
    License
    """

    key: Annotated[str | None, Field(example="mit")] = None
    name: Annotated[str | None, Field(example="MIT License")] = None
    spdx_id: Annotated[str | None, Field(example="MIT")] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/licenses/mit")
    ] = None
    node_id: Annotated[str | None, Field(example="MDc6TGljZW5zZW1pdA==")] = None
    html_url: Annotated[
        AnyUrl | None, Field(example="http://choosealicense.com/licenses/mit/")
    ] = None
    description: Annotated[
        str | None,
        Field(
            example="A permissive license that is short and to the point. It lets people do anything with your code with proper attribution and without warranty."
        ),
    ] = None
    implementation: Annotated[
        str | None,
        Field(
            example="Create a text file (typically named LICENSE or LICENSE.txt) in the root of your source code and copy the text of the license into the file. Replace [year] with the current year and [fullname] with the name (or names) of the copyright holders."
        ),
    ] = None
    permissions: Annotated[
        Sequence[str] | None,
        Field(
            example=[
                "commercial-use",
                "modifications",
                "distribution",
                "sublicense",
                "private-use",
            ]
        ),
    ] = None
    conditions: Annotated[
        Sequence[str] | None, Field(example=["include-copyright"])
    ] = None
    limitations: Annotated[Sequence[str] | None, Field(example=["no-liability"])] = None
    body: Annotated[
        str | None,
        Field(
            example='\n\nThe MIT License (MIT)\n\nCopyright (c) [year] [fullname]\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the "Software"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n'
        ),
    ] = None
    featured: Annotated[bool | None, Field(example=True)] = None


class MarketplaceListingPlan(BaseModel):
    """
    Marketplace Listing Plan
    """

    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/marketplace_listing/plans/1313"),
    ] = None
    accounts_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/marketplace_listing/plans/1313/accounts"),
    ] = None
    id: Annotated[int | None, Field(example=1313)] = None
    number: Annotated[int | None, Field(example=3)] = None
    name: Annotated[str | None, Field(example="Pro")] = None
    description: Annotated[
        str | None, Field(example="A professional-grade CI solution")
    ] = None
    monthly_price_in_cents: Annotated[int | None, Field(example=1099)] = None
    yearly_price_in_cents: Annotated[int | None, Field(example=11870)] = None
    price_model: Annotated[str | None, Field(example="flat-rate")] = None
    has_free_trial: Annotated[bool | None, Field(example=True)] = None
    unit_name: str | None = None
    state: Annotated[str | None, Field(example="published")] = None
    bullets: Annotated[
        Sequence[str] | None,
        Field(example=["Up to 25 private repositories", "11 concurrent builds"]),
    ] = None


class MarketplacePendingChange(BaseModel):
    is_installed: bool | None = None
    effective_date: str | None = None
    unit_count: int | None = None
    id: int | None = None
    plan: MarketplaceListingPlan | None = None


class MarketplacePurchase1(BaseModel):
    billing_cycle: str | None = None
    next_billing_date: str | None = None
    is_installed: bool | None = None
    unit_count: int | None = None
    on_free_trial: bool | None = None
    free_trial_ends_on: str | None = None
    updated_at: str | None = None
    plan: MarketplaceListingPlan | None = None


class MarketplacePurchase(BaseModel):
    """
    Marketplace Purchase
    """

    url: str | None = None
    type: str | None = None
    id: int | None = None
    login: str | None = None
    organization_billing_email: str | None = None
    email: str | None = None
    marketplace_pending_change: MarketplacePendingChange | None = None
    marketplace_purchase: MarketplacePurchase1 | None = None


class SshKeyFingerprints(BaseModel):
    SHA256_RSA: str | None = None
    SHA256_DSA: str | None = None
    SHA256_ECDSA: str | None = None
    SHA256_ED25519: str | None = None


class ApiOverview(BaseModel):
    """
    Api Overview
    """

    verifiable_password_authentication: Annotated[
        bool | None, Field(example=True)
    ] = None
    ssh_key_fingerprints: SshKeyFingerprints | None = None
    ssh_keys: Annotated[
        Sequence[str] | None,
        Field(
            example=[
                "ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIOMqqnkVzrm0SdG6UOoqKLsabgH5C9okWi0dh2l9GKJl"
            ]
        ),
    ] = None
    hooks: Annotated[Sequence[str] | None, Field(example=["127.0.0.1/32"])] = None
    web: Annotated[Sequence[str] | None, Field(example=["127.0.0.1/32"])] = None
    api: Annotated[Sequence[str] | None, Field(example=["127.0.0.1/32"])] = None
    git: Annotated[Sequence[str] | None, Field(example=["127.0.0.1/32"])] = None
    packages: Annotated[
        Sequence[str] | None,
        Field(example=["13.65.0.0/16", "157.55.204.33/32", "2a01:111:f403:f90c::/62"]),
    ] = None
    pages: Annotated[
        Sequence[str] | None, Field(example=["192.30.252.153/32", "192.30.252.154/32"])
    ] = None
    importer: Annotated[
        Sequence[str] | None, Field(example=["54.158.161.132", "54.226.70.38"])
    ] = None
    actions: Annotated[
        Sequence[str] | None, Field(example=["13.64.0.0/16", "13.65.0.0/16"])
    ] = None
    dependabot: Annotated[
        Sequence[str] | None, Field(example=["192.168.7.15/32", "192.168.7.16/32"])
    ] = None


class Permissions4(BaseModel):
    admin: bool | None = None
    maintain: bool | None = None
    push: bool | None = None
    triage: bool | None = None
    pull: bool | None = None


class License1(BaseModel):
    key: str | None = None
    name: str | None = None
    spdx_id: str | None = None
    url: str | None = None
    node_id: str | None = None


class MinimalRepository(BaseModel):
    """
    Minimal Repository
    """

    id: Annotated[int | None, Field(example=1296269)] = None
    node_id: Annotated[str | None, Field(example="MDEwOlJlcG9zaXRvcnkxMjk2MjY5")] = None
    name: Annotated[str | None, Field(example="Hello-World")] = None
    full_name: Annotated[str | None, Field(example="octocat/Hello-World")] = None
    owner: SimpleUser | None = None
    private: bool | None = None
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat/Hello-World")
    ] = None
    description: Annotated[str | None, Field(example="This your first repo!")] = None
    fork: bool | None = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/repos/octocat/Hello-World")
    ] = None
    archive_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}"
        ),
    ] = None
    assignees_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/assignees{/user}"
        ),
    ] = None
    blobs_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}"
        ),
    ] = None
    branches_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/branches{/branch}"
        ),
    ] = None
    collaborators_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}"
        ),
    ] = None
    comments_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/comments{/number}"
        ),
    ] = None
    commits_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/commits{/sha}"),
    ] = None
    compare_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}"
        ),
    ] = None
    contents_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/contents/{+path}"
        ),
    ] = None
    contributors_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/contributors"),
    ] = None
    deployments_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/deployments"),
    ] = None
    downloads_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/downloads"),
    ] = None
    events_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/events"),
    ] = None
    forks_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/forks"),
    ] = None
    git_commits_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/commits{/sha}"
        ),
    ] = None
    git_refs_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/git/refs{/sha}"),
    ] = None
    git_tags_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/git/tags{/sha}"),
    ] = None
    git_url: str | None = None
    issue_comment_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues/comments{/number}"
        ),
    ] = None
    issue_events_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues/events{/number}"
        ),
    ] = None
    issues_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues{/number}"
        ),
    ] = None
    keys_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/keys{/key_id}"),
    ] = None
    labels_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/labels{/name}"),
    ] = None
    languages_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/languages"),
    ] = None
    merges_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/merges"),
    ] = None
    milestones_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/milestones{/number}"
        ),
    ] = None
    notifications_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}"
        ),
    ] = None
    pulls_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/pulls{/number}"),
    ] = None
    releases_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/releases{/id}"),
    ] = None
    ssh_url: str | None = None
    stargazers_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/stargazers"),
    ] = None
    statuses_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/statuses/{sha}"),
    ] = None
    subscribers_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/subscribers"),
    ] = None
    subscription_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/subscription"),
    ] = None
    tags_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/tags"),
    ] = None
    teams_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/teams"),
    ] = None
    trees_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/trees{/sha}"
        ),
    ] = None
    clone_url: str | None = None
    mirror_url: str | None = None
    hooks_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/hooks"),
    ] = None
    svn_url: str | None = None
    homepage: str | None = None
    language: str | None = None
    forks_count: int | None = None
    stargazers_count: int | None = None
    watchers_count: int | None = None
    size: int | None = None
    """
    The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.
    """
    default_branch: str | None = None
    open_issues_count: int | None = None
    is_template: bool | None = None
    topics: Sequence[str] | None = None
    has_issues: bool | None = None
    has_projects: bool | None = None
    has_wiki: bool | None = None
    has_pages: bool | None = None
    has_downloads: bool | None = None
    archived: bool | None = None
    disabled: bool | None = None
    visibility: str | None = None
    pushed_at: Annotated[datetime | None, Field(example="2011-01-26T19:06:43Z")] = None
    created_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2011-01-26T19:14:43Z")] = None
    permissions: Permissions4 | None = None
    role_name: Annotated[str | None, Field(example="admin")] = None
    temp_clone_token: str | None = None
    delete_branch_on_merge: bool | None = None
    subscribers_count: int | None = None
    network_count: int | None = None
    code_of_conduct: CodeOfConduct | None = None
    license: License1 | None = None
    forks: Annotated[int | None, Field(example=0)] = None
    open_issues: Annotated[int | None, Field(example=0)] = None
    watchers: Annotated[int | None, Field(example=0)] = None
    allow_forking: bool | None = None
    web_commit_signoff_required: Annotated[bool | None, Field(example=False)] = None


class Subject(BaseModel):
    title: str | None = None
    url: str | None = None
    latest_comment_url: str | None = None
    type: str | None = None


class Thread(BaseModel):
    """
    Thread
    """

    id: str | None = None
    repository: MinimalRepository | None = None
    subject: Subject | None = None
    reason: str | None = None
    unread: bool | None = None
    updated_at: str | None = None
    last_read_at: str | None = None
    url: str | None = None
    subscription_url: Annotated[
        str | None,
        Field(example="https://api.github.com/notifications/threads/2/subscription"),
    ] = None


class ThreadSubscription(BaseModel):
    """
    Thread Subscription
    """

    subscribed: Annotated[bool | None, Field(example=True)] = None
    ignored: bool | None = None
    reason: str | None = None
    created_at: Annotated[datetime | None, Field(example="2012-10-06T21:34:12Z")] = None
    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/notifications/threads/1/subscription"),
    ] = None
    thread_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/notifications/threads/1")
    ] = None
    repository_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/repos/1")
    ] = None


class BaseRole(Enum):
    """
    The system role from which this role inherits permissions.
    """

    read = "read"
    triage = "triage"
    write = "write"
    maintain = "maintain"


class OrganizationCustomRepositoryRole(BaseModel):
    """
    Custom repository roles created by organization administrators
    """

    id: int | None = None
    """
    The unique identifier of the custom role.
    """
    name: str | None = None
    """
    The name of the custom role.
    """
    description: str | None = None
    """
    A short description about who this role is for or what permissions it grants.
    """
    base_role: BaseRole | None = None
    """
    The system role from which this role inherits permissions.
    """
    permissions: Sequence[str] | None = None
    """
    A list of additional permissions included in this role.
    """
    organization: SimpleUser | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None


class Plan1(BaseModel):
    name: str | None = None
    space: int | None = None
    private_repos: int | None = None
    filled_seats: int | None = None
    seats: int | None = None


class OrganizationFull(BaseModel):
    """
    Organization Full
    """

    login: Annotated[str | None, Field(example="github")] = None
    id: Annotated[int | None, Field(example=1)] = None
    node_id: Annotated[str | None, Field(example="MDEyOk9yZ2FuaXphdGlvbjE=")] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/orgs/github")
    ] = None
    repos_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/orgs/github/repos")
    ] = None
    events_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/orgs/github/events")
    ] = None
    hooks_url: Annotated[
        str | None, Field(example="https://api.github.com/orgs/github/hooks")
    ] = None
    issues_url: Annotated[
        str | None, Field(example="https://api.github.com/orgs/github/issues")
    ] = None
    members_url: Annotated[
        str | None, Field(example="https://api.github.com/orgs/github/members{/member}")
    ] = None
    public_members_url: Annotated[
        str | None,
        Field(example="https://api.github.com/orgs/github/public_members{/member}"),
    ] = None
    avatar_url: Annotated[
        str | None, Field(example="https://github.com/images/error/octocat_happy.gif")
    ] = None
    description: Annotated[str | None, Field(example="A great organization")] = None
    name: Annotated[str | None, Field(example="github")] = None
    company: Annotated[str | None, Field(example="GitHub")] = None
    blog: Annotated[AnyUrl | None, Field(example="https://github.com/blog")] = None
    location: Annotated[str | None, Field(example="San Francisco")] = None
    email: Annotated[EmailStr | None, Field(example="octocat@github.com")] = None
    twitter_username: Annotated[str | None, Field(example="github")] = None
    is_verified: Annotated[bool | None, Field(example=True)] = None
    has_organization_projects: Annotated[bool | None, Field(example=True)] = None
    has_repository_projects: Annotated[bool | None, Field(example=True)] = None
    public_repos: Annotated[int | None, Field(example=2)] = None
    public_gists: Annotated[int | None, Field(example=1)] = None
    followers: Annotated[int | None, Field(example=20)] = None
    following: Annotated[int | None, Field(example=0)] = None
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat")
    ] = None
    created_at: Annotated[datetime | None, Field(example="2008-01-14T04:33:35Z")] = None
    type: Annotated[str | None, Field(example="Organization")] = None
    total_private_repos: Annotated[int | None, Field(example=100)] = None
    owned_private_repos: Annotated[int | None, Field(example=100)] = None
    private_gists: Annotated[int | None, Field(example=81)] = None
    disk_usage: Annotated[int | None, Field(example=10000)] = None
    collaborators: Annotated[int | None, Field(example=8)] = None
    billing_email: Annotated[EmailStr | None, Field(example="org@example.com")] = None
    plan: Plan1 | None = None
    default_repository_permission: str | None = None
    members_can_create_repositories: Annotated[bool | None, Field(example=True)] = None
    two_factor_requirement_enabled: Annotated[bool | None, Field(example=True)] = None
    members_allowed_repository_creation_type: Annotated[
        str | None, Field(example="all")
    ] = None
    members_can_create_public_repositories: Annotated[
        bool | None, Field(example=True)
    ] = None
    members_can_create_private_repositories: Annotated[
        bool | None, Field(example=True)
    ] = None
    members_can_create_internal_repositories: Annotated[
        bool | None, Field(example=True)
    ] = None
    members_can_create_pages: Annotated[bool | None, Field(example=True)] = None
    members_can_create_public_pages: Annotated[bool | None, Field(example=True)] = None
    members_can_create_private_pages: Annotated[bool | None, Field(example=True)] = None
    members_can_fork_private_repositories: Annotated[
        bool | None, Field(example=False)
    ] = None
    web_commit_signoff_required: Annotated[bool | None, Field(example=False)] = None
    updated_at: datetime | None = None
    advanced_security_enabled_for_new_repositories: Annotated[
        bool | None, Field(example=False)
    ] = None
    """
    Whether GitHub Advanced Security is enabled for new repositories and repositories transferred to this organization.

    This field is only visible to organization owners or members of a team with the security manager role.
    """
    dependabot_alerts_enabled_for_new_repositories: Annotated[
        bool | None, Field(example=False)
    ] = None
    """
    Whether GitHub Advanced Security is automatically enabled for new repositories and repositories transferred to
    this organization.

    This field is only visible to organization owners or members of a team with the security manager role.
    """
    dependabot_security_updates_enabled_for_new_repositories: Annotated[
        bool | None, Field(example=False)
    ] = None
    """
    Whether dependabot security updates are automatically enabled for new repositories and repositories transferred
    to this organization.

    This field is only visible to organization owners or members of a team with the security manager role.
    """
    dependency_graph_enabled_for_new_repositories: Annotated[
        bool | None, Field(example=False)
    ] = None
    """
    Whether dependency graph is automatically enabled for new repositories and repositories transferred to this
    organization.

    This field is only visible to organization owners or members of a team with the security manager role.
    """
    secret_scanning_enabled_for_new_repositories: Annotated[
        bool | None, Field(example=False)
    ] = None
    """
    Whether secret scanning is automatically enabled for new repositories and repositories transferred to this
    organization.

    This field is only visible to organization owners or members of a team with the security manager role.
    """
    secret_scanning_push_protection_enabled_for_new_repositories: Annotated[
        bool | None, Field(example=False)
    ] = None
    """
    Whether secret scanning push protection is automatically enabled for new repositories and repositories
    transferred to this organization.

    This field is only visible to organization owners or members of a team with the security manager role.
    """


class ActionsCacheUsageByRepository(BaseModel):
    """
    GitHub Actions Cache Usage by repository.
    """

    full_name: Annotated[str | None, Field(example="octo-org/Hello-World")] = None
    """
    The repository owner and name for the cache usage being shown.
    """
    active_caches_size_in_bytes: Annotated[int | None, Field(example=2322142)] = None
    """
    The sum of the size in bytes of all the active cache items in the repository.
    """
    active_caches_count: Annotated[int | None, Field(example=3)] = None
    """
    The number of active caches in the repository.
    """


class EnabledRepositories(Enum):
    """
    The policy that controls the repositories in the organization that are allowed to run GitHub Actions.
    """

    all = "all"
    none = "none"
    selected = "selected"


class ActionsOrganizationPermissions(BaseModel):
    enabled_repositories: EnabledRepositories | None = None
    selected_repositories_url: str | None = None
    """
    The API URL to use to get or set the selected repositories that are allowed to run GitHub Actions, when `enabled_repositories` is set to `selected`.
    """
    allowed_actions: AllowedActions | None = None
    selected_actions_url: str | None = None
    """
    The API URL to use to get or set the actions and reusable workflows that are allowed to run, when `allowed_actions` is set to `selected`.
    """


class RunnerGroupsOrg(BaseModel):
    id: float | None = None
    name: str | None = None
    visibility: str | None = None
    default: bool | None = None
    selected_repositories_url: str | None = None
    """
    Link to the selected repositories resource for this runner group. Not present unless visibility was set to `selected`
    """
    runners_url: str | None = None
    inherited: bool | None = None
    inherited_allows_public_repositories: bool | None = None
    allows_public_repositories: bool | None = None
    workflow_restrictions_read_only: bool | None = False
    """
    If `true`, the `restricted_to_workflows` and `selected_workflows` fields cannot be modified.
    """
    restricted_to_workflows: bool | None = False
    """
    If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array.
    """
    selected_workflows: Sequence[str] | None = None
    """
    List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`.
    """


class Visibility(Enum):
    """
    Visibility of a secret
    """

    all = "all"
    private = "private"
    selected = "selected"


class OrganizationActionsSecret(BaseModel):
    """
    Secrets for GitHub Actions for an organization.
    """

    name: Annotated[str | None, Field(example="SECRET_TOKEN")] = None
    """
    The name of the secret.
    """
    created_at: datetime | None = None
    updated_at: datetime | None = None
    visibility: Visibility | None = None
    """
    Visibility of a secret
    """
    selected_repositories_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/organizations/org/secrets/my_secret/repositories"
        ),
    ] = None


class ActionsPublicKey(BaseModel):
    """
    The public key used for setting Actions Secrets.
    """

    key_id: Annotated[str | None, Field(example="1234567")] = None
    """
    The identifier for the key.
    """
    key: Annotated[
        str | None, Field(example="hBT5WZEj8ZoOv6TYJsfWq7MxTEQopZO5/IT3ZCVQPzs=")
    ] = None
    """
    The Base64 encoded public key.
    """
    id: Annotated[int | None, Field(example=2)] = None
    url: Annotated[
        str | None, Field(example="https://api.github.com/user/keys/2")
    ] = None
    title: Annotated[str | None, Field(example="ssh-rsa AAAAB3NzaC1yc2EAAA")] = None
    created_at: Annotated[str | None, Field(example="2011-01-26T19:01:12Z")] = None


class EmptyObject(BaseModel):
    """
    An object without any properties.
    """

    class Config:
        extra = Extra.forbid


class PrebuildAvailability(Enum):
    """
    Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.
    """

    none = "none"
    ready = "ready"
    in_progress = "in_progress"


class NullableCodespaceMachine(BaseModel):
    """
    A description of the machine powering a codespace.
    """

    name: Annotated[str | None, Field(example="standardLinux")] = None
    """
    The name of the machine.
    """
    display_name: Annotated[
        str | None, Field(example="4 cores, 8 GB RAM, 64 GB storage")
    ] = None
    """
    The display name of the machine includes cores, memory, and storage.
    """
    operating_system: Annotated[str | None, Field(example="linux")] = None
    """
    The operating system of the machine.
    """
    storage_in_bytes: Annotated[int | None, Field(example=68719476736)] = None
    """
    How much storage is available to the codespace.
    """
    memory_in_bytes: Annotated[int | None, Field(example=8589934592)] = None
    """
    How much memory is available to the codespace.
    """
    cpus: Annotated[int | None, Field(example=4)] = None
    """
    How many cores are available to the codespace.
    """
    prebuild_availability: Annotated[
        PrebuildAvailability | None, Field(example="ready")
    ] = None
    """
    Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.
    """


class State1(Enum):
    """
    State of this codespace.
    """

    Unknown = "Unknown"
    Created = "Created"
    Queued = "Queued"
    Provisioning = "Provisioning"
    Available = "Available"
    Awaiting = "Awaiting"
    Unavailable = "Unavailable"
    Deleted = "Deleted"
    Moved = "Moved"
    Shutdown = "Shutdown"
    Archived = "Archived"
    Starting = "Starting"
    ShuttingDown = "ShuttingDown"
    Failed = "Failed"
    Exporting = "Exporting"
    Updating = "Updating"
    Rebuilding = "Rebuilding"


class GitStatus(BaseModel):
    """
    Details about the codespace's git repository.
    """

    ahead: Annotated[int | None, Field(example=0)] = None
    """
    The number of commits the local repository is ahead of the remote.
    """
    behind: Annotated[int | None, Field(example=0)] = None
    """
    The number of commits the local repository is behind the remote.
    """
    has_unpushed_changes: bool | None = None
    """
    Whether the local repository has unpushed changes.
    """
    has_uncommitted_changes: bool | None = None
    """
    Whether the local repository has uncommitted changes.
    """
    ref: Annotated[str | None, Field(example="main")] = None
    """
    The current branch (or SHA if in detached HEAD state) of the local repository.
    """


class Location(Enum):
    """
    The Azure region where this codespace is located.
    """

    EastUs = "EastUs"
    SouthEastAsia = "SouthEastAsia"
    WestEurope = "WestEurope"
    WestUs2 = "WestUs2"


class RuntimeConstraints(BaseModel):
    allowed_port_privacy_settings: Sequence[str] | None = None
    """
    The privacy settings a user can select from when forwarding a port.
    """


class Codespace(BaseModel):
    """
    A codespace.
    """

    id: Annotated[int | None, Field(example=1)] = None
    name: Annotated[
        str | None, Field(example="monalisa-octocat-hello-world-g4wpq6h95q")
    ] = None
    """
    Automatically generated name of this codespace.
    """
    display_name: Annotated[str | None, Field(example="bookish space pancake")] = None
    """
    Display name for this codespace.
    """
    environment_id: Annotated[
        str | None, Field(example="26a7c758-7299-4a73-b978-5a92a7ae98a0")
    ] = None
    """
    UUID identifying this codespace's environment.
    """
    owner: SimpleUser | None = None
    billable_owner: SimpleUser | None = None
    repository: MinimalRepository | None = None
    machine: NullableCodespaceMachine | None = None
    devcontainer_path: Annotated[
        str | None, Field(example=".devcontainer/example/devcontainer.json")
    ] = None
    """
    Path to devcontainer.json from repo root used to create Codespace.
    """
    prebuild: Annotated[bool | None, Field(example=False)] = None
    """
    Whether the codespace was created from a prebuild.
    """
    created_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    last_used_at: Annotated[
        datetime | None, Field(example="2011-01-26T19:01:12Z")
    ] = None
    """
    Last known time this codespace was started.
    """
    state: Annotated[State1 | None, Field(example="Available")] = None
    """
    State of this codespace.
    """
    url: AnyUrl | None = None
    """
    API URL for this codespace.
    """
    git_status: GitStatus | None = None
    """
    Details about the codespace's git repository.
    """
    location: Annotated[Location | None, Field(example="WestUs2")] = None
    """
    The Azure region where this codespace is located.
    """
    idle_timeout_minutes: Annotated[int | None, Field(example=60)] = None
    """
    The number of minutes of inactivity after which this codespace will be automatically stopped.
    """
    web_url: AnyUrl | None = None
    """
    URL to access this codespace on the web.
    """
    machines_url: AnyUrl | None = None
    """
    API URL to access available alternate machine types for this codespace.
    """
    start_url: AnyUrl | None = None
    """
    API URL to start this codespace.
    """
    stop_url: AnyUrl | None = None
    """
    API URL to stop this codespace.
    """
    pulls_url: AnyUrl | None = None
    """
    API URL for the Pull Request associated with this codespace, if any.
    """
    recent_folders: Sequence[str] | None = None
    runtime_constraints: RuntimeConstraints | None = None
    pending_operation: bool | None = None
    """
    Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it.
    """
    pending_operation_disabled_reason: str | None = None
    """
    Text to show user when codespace is disabled by a pending operation
    """
    idle_timeout_notice: str | None = None
    """
    Text to show user when codespace idle timeout minutes has been overriden by an organization policy
    """
    retention_period_minutes: Annotated[int | None, Field(example=60)] = None
    """
    Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).
    """
    retention_expires_at: Annotated[
        datetime | None, Field(example="2011-01-26T20:01:12Z")
    ] = None
    """
    When a codespace will be auto-deleted based on the "retention_period_minutes" and "last_used_at"
    """
    last_known_stop_notice: Annotated[
        str | None,
        Field(example="you've used 100% of your spending limit for Codespaces"),
    ] = None
    """
    The text to display to a user when a codespace has been stopped for a potentially actionable reason.
    """


class Visibility1(Enum):
    """
    The type of repositories in the organization that the secret is visible to
    """

    all = "all"
    private = "private"
    selected = "selected"


class CodespacesOrgSecret(BaseModel):
    """
    Secrets for a GitHub Codespace.
    """

    name: Annotated[str | None, Field(example="SECRET_NAME")] = None
    """
    The name of the secret
    """
    created_at: datetime | None = None
    """
    The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
    """
    updated_at: datetime | None = None
    """
    The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
    """
    visibility: Visibility1 | None = None
    """
    The type of repositories in the organization that the secret is visible to
    """
    selected_repositories_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/orgs/ORGANIZATION/codespaces/secrets/SECRET_NAME/repositories"
        ),
    ] = None
    """
    The API URL at which the list of repositories this secret is visible to can be retrieved
    """


class CodespacesPublicKey(BaseModel):
    """
    The public key used for setting Codespaces secrets.
    """

    key_id: Annotated[str | None, Field(example="1234567")] = None
    """
    The identifier for the key.
    """
    key: Annotated[
        str | None, Field(example="hBT5WZEj8ZoOv6TYJsfWq7MxTEQopZO5/IT3ZCVQPzs=")
    ] = None
    """
    The Base64 encoded public key.
    """
    id: Annotated[int | None, Field(example=2)] = None
    url: Annotated[
        str | None, Field(example="https://api.github.com/user/keys/2")
    ] = None
    title: Annotated[str | None, Field(example="ssh-rsa AAAAB3NzaC1yc2EAAA")] = None
    created_at: Annotated[str | None, Field(example="2011-01-26T19:01:12Z")] = None


class DependabotAlertPackage(BaseModel):
    """
    Details for the vulnerable package.
    """

    class Config:
        extra = Extra.forbid

    ecosystem: str | None = None
    """
    The package's language or package management ecosystem.
    """
    name: str | None = None
    """
    The unique package name within its ecosystem.
    """


class Severity1(Enum):
    """
    The severity of the vulnerability.
    """

    low = "low"
    medium = "medium"
    high = "high"
    critical = "critical"


class FirstPatchedVersion(BaseModel):
    """
    Details pertaining to the package version that patches this vulnerability.
    """

    class Config:
        extra = Extra.forbid

    identifier: str | None = None
    """
    The package version that patches this vulnerability.
    """


class DependabotAlertSecurityVulnerability(BaseModel):
    """
    Details pertaining to one vulnerable version range for the advisory.
    """

    class Config:
        extra = Extra.forbid

    package: DependabotAlertPackage | None = None
    severity: Severity1 | None = None
    """
    The severity of the vulnerability.
    """
    vulnerable_version_range: str | None = None
    """
    Conditions that identify vulnerable versions of this vulnerability's package.
    """
    first_patched_version: FirstPatchedVersion | None = None
    """
    Details pertaining to the package version that patches this vulnerability.
    """


class Severity2(Enum):
    """
    The severity of the advisory.
    """

    low = "low"
    medium = "medium"
    high = "high"
    critical = "critical"


class Cvss(BaseModel):
    """
    Details for the advisory pertaining to the Common Vulnerability Scoring System.
    """

    class Config:
        extra = Extra.forbid

    score: Annotated[float | None, Field(ge=0.0, le=10.0)] = None
    """
    The overall CVSS score of the advisory.
    """
    vector_string: str | None = None
    """
    The full CVSS vector string for the advisory.
    """


class Cwe(BaseModel):
    """
    A CWE weakness assigned to the advisory.
    """

    class Config:
        extra = Extra.forbid

    cwe_id: str | None = None
    """
    The unique CWE ID.
    """
    name: str | None = None
    """
    The short, plain text name of the CWE.
    """


class Type1(Enum):
    """
    The type of advisory identifier.
    """

    CVE = "CVE"
    GHSA = "GHSA"


class Identifier(BaseModel):
    """
    An advisory identifier.
    """

    class Config:
        extra = Extra.forbid

    type: Type1 | None = None
    """
    The type of advisory identifier.
    """
    value: str | None = None
    """
    The value of the advisory identifer.
    """


class Reference(BaseModel):
    """
    A link to additional advisory information.
    """

    class Config:
        extra = Extra.forbid

    url: AnyUrl | None = None
    """
    The URL of the reference.
    """


class DependabotAlertSecurityAdvisory(BaseModel):
    """
    Details for the GitHub Security Advisory.
    """

    class Config:
        extra = Extra.forbid

    ghsa_id: str | None = None
    """
    The unique GitHub Security Advisory ID assigned to the advisory.
    """
    cve_id: str | None = None
    """
    The unique CVE ID assigned to the advisory.
    """
    summary: Annotated[str | None, Field(max_length=1024)] = None
    """
    A short, plain text summary of the advisory.
    """
    description: str | None = None
    """
    A long-form Markdown-supported description of the advisory.
    """
    vulnerabilities: Sequence[DependabotAlertSecurityVulnerability] | None = None
    """
    Vulnerable version range information for the advisory.
    """
    severity: Severity2 | None = None
    """
    The severity of the advisory.
    """
    cvss: Cvss | None = None
    """
    Details for the advisory pertaining to the Common Vulnerability Scoring System.
    """
    cwes: Sequence[Cwe] | None = None
    """
    Details for the advisory pertaining to Common Weakness Enumeration.
    """
    identifiers: Sequence[Identifier] | None = None
    """
    Values that identify this advisory among security information sources.
    """
    references: Sequence[Reference] | None = None
    """
    Links to additional advisory information.
    """
    published_at: datetime | None = None
    """
    The time that the advisory was published in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    updated_at: datetime | None = None
    """
    The time that the advisory was last modified in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    withdrawn_at: datetime | None = None
    """
    The time that the advisory was withdrawn in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """


class State2(Enum):
    """
    The state of the Dependabot alert.
    """

    dismissed = "dismissed"
    fixed = "fixed"
    open = "open"


class Scope(Enum):
    """
    The execution scope of the vulnerable dependency.
    """

    development = "development"
    runtime = "runtime"


class Dependency(BaseModel):
    """
    Details for the vulnerable dependency.
    """

    package: DependabotAlertPackage | None = None
    manifest_path: str | None = None
    """
    The full path to the dependency manifest file, relative to the root of the repository.
    """
    scope: Scope | None = None
    """
    The execution scope of the vulnerable dependency.
    """


class DismissedReason(Enum):
    """
    The reason that the alert was dismissed.
    """

    fix_started = "fix_started"
    inaccurate = "inaccurate"
    no_bandwidth = "no_bandwidth"
    not_used = "not_used"
    tolerable_risk = "tolerable_risk"


class DependabotAlertWithRepository(BaseModel):
    """
    A Dependabot alert.
    """

    class Config:
        extra = Extra.forbid

    number: int | None = None
    """
    The security alert number.
    """
    state: State2 | None = None
    """
    The state of the Dependabot alert.
    """
    dependency: Dependency | None = None
    """
    Details for the vulnerable dependency.
    """
    security_advisory: DependabotAlertSecurityAdvisory | None = None
    security_vulnerability: DependabotAlertSecurityVulnerability | None = None
    url: AnyUrl | None = None
    """
    The REST API URL of the alert resource.
    """
    html_url: AnyUrl | None = None
    """
    The GitHub URL of the alert resource.
    """
    created_at: datetime | None = None
    """
    The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    updated_at: datetime | None = None
    """
    The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_at: datetime | None = None
    """
    The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_by: NullableSimpleUser | None = None
    dismissed_reason: DismissedReason | None = None
    """
    The reason that the alert was dismissed.
    """
    dismissed_comment: Annotated[str | None, Field(max_length=280)] = None
    """
    An optional comment associated with the alert's dismissal.
    """
    fixed_at: datetime | None = None
    """
    The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    repository: SimpleRepository | None = None


class Visibility2(Enum):
    """
    Visibility of a secret
    """

    all = "all"
    private = "private"
    selected = "selected"


class OrganizationDependabotSecret(BaseModel):
    """
    Secrets for GitHub Dependabot for an organization.
    """

    name: Annotated[str | None, Field(example="SECRET_TOKEN")] = None
    """
    The name of the secret.
    """
    created_at: datetime | None = None
    updated_at: datetime | None = None
    visibility: Visibility2 | None = None
    """
    Visibility of a secret
    """
    selected_repositories_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/organizations/org/dependabot/secrets/my_secret/repositories"
        ),
    ] = None


class DependabotPublicKey(BaseModel):
    """
    The public key used for setting Dependabot Secrets.
    """

    key_id: Annotated[str | None, Field(example="1234567")] = None
    """
    The identifier for the key.
    """
    key: Annotated[
        str | None, Field(example="hBT5WZEj8ZoOv6TYJsfWq7MxTEQopZO5/IT3ZCVQPzs=")
    ] = None
    """
    The Base64 encoded public key.
    """


class OrganizationInvitation(BaseModel):
    """
    Organization Invitation
    """

    id: int | None = None
    login: str | None = None
    email: str | None = None
    role: str | None = None
    created_at: str | None = None
    failed_at: str | None = None
    failed_reason: str | None = None
    inviter: SimpleUser | None = None
    team_count: int | None = None
    node_id: Annotated[
        str | None, Field(example='"MDIyOk9yZ2FuaXphdGlvbkludml0YXRpb24x"')
    ] = None
    invitation_teams_url: Annotated[
        str | None,
        Field(example='"https://api.github.com/organizations/16/invitations/1/teams"'),
    ] = None


class OrganizationFineGrainedPermission(BaseModel):
    """
    Fine-grained permissions available for the organization
    """

    name: str | None = None
    description: str | None = None


class Config(BaseModel):
    url: Annotated[str | None, Field(example='"http://example.com/2"')] = None
    insecure_ssl: Annotated[str | None, Field(example='"0"')] = None
    content_type: Annotated[str | None, Field(example='"form"')] = None
    secret: Annotated[str | None, Field(example='"********"')] = None


class OrgHook(BaseModel):
    """
    Org Hook
    """

    id: Annotated[int | None, Field(example=1)] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/orgs/octocat/hooks/1")
    ] = None
    ping_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/orgs/octocat/hooks/1/pings"),
    ] = None
    deliveries_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/orgs/octocat/hooks/1/deliveries"),
    ] = None
    name: Annotated[str | None, Field(example="web")] = None
    events: Annotated[
        Sequence[str] | None, Field(example=["push", "pull_request"])
    ] = None
    active: Annotated[bool | None, Field(example=True)] = None
    config: Config | None = None
    updated_at: Annotated[datetime | None, Field(example="2011-09-06T20:39:23Z")] = None
    created_at: Annotated[datetime | None, Field(example="2011-09-06T17:26:27Z")] = None
    type: str | None = None


class InteractionGroup(Enum):
    """
    The type of GitHub user that can comment, open issues, or create pull requests while the interaction limit is in effect.
    """

    existing_users = "existing_users"
    contributors_only = "contributors_only"
    collaborators_only = "collaborators_only"


class InteractionLimitResponse(BaseModel):
    """
    Interaction limit settings.
    """

    limit: InteractionGroup | None = None
    origin: Annotated[str | None, Field(example="repository")] = None
    expires_at: Annotated[datetime | None, Field(example="2018-08-17T04:18:39Z")] = None


class InteractionExpiry(Enum):
    """
    The duration of the interaction restriction. Default: `one_day`.
    """

    one_day = "one_day"
    three_days = "three_days"
    one_week = "one_week"
    one_month = "one_month"
    six_months = "six_months"


class InteractionLimit(BaseModel):
    """
    Limit interactions to a specific type of user for a specified duration
    """

    limit: InteractionGroup | None = None
    expiry: InteractionExpiry | None = None


class NullableTeamSimple(BaseModel):
    """
    Groups of organization members that gives permissions on specified repositories.
    """

    id: Annotated[int | None, Field(example=1)] = None
    """
    Unique identifier of the team
    """
    node_id: Annotated[str | None, Field(example="MDQ6VGVhbTE=")] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/organizations/1/team/1")
    ] = None
    """
    URL for the team
    """
    members_url: Annotated[
        str | None,
        Field(example="https://api.github.com/organizations/1/team/1/members{/member}"),
    ] = None
    name: Annotated[str | None, Field(example="Justice League")] = None
    """
    Name of the team
    """
    description: Annotated[str | None, Field(example="A great team.")] = None
    """
    Description of the team
    """
    permission: Annotated[str | None, Field(example="admin")] = None
    """
    Permission that the team will have for its repositories
    """
    privacy: Annotated[str | None, Field(example="closed")] = None
    """
    The level of privacy this team should have
    """
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/orgs/rails/teams/core")
    ] = None
    repositories_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/organizations/1/team/1/repos"),
    ] = None
    slug: Annotated[str | None, Field(example="justice-league")] = None
    ldap_dn: Annotated[
        str | None, Field(example="uid=example,ou=users,dc=github,dc=com")
    ] = None
    """
    Distinguished Name (DN) that team maps to within LDAP environment
    """


class Permissions5(BaseModel):
    pull: bool | None = None
    triage: bool | None = None
    push: bool | None = None
    maintain: bool | None = None
    admin: bool | None = None


class Team(BaseModel):
    """
    Groups of organization members that gives permissions on specified repositories.
    """

    id: int | None = None
    node_id: str | None = None
    name: str | None = None
    slug: str | None = None
    description: str | None = None
    privacy: str | None = None
    permission: str | None = None
    permissions: Permissions5 | None = None
    url: AnyUrl | None = None
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/orgs/rails/teams/core")
    ] = None
    members_url: str | None = None
    repositories_url: AnyUrl | None = None
    parent: NullableTeamSimple | None = None


class State3(Enum):
    """
    The state of the member in the organization. The `pending` state indicates the user has not yet accepted an invitation.
    """

    active = "active"
    pending = "pending"


class Role(Enum):
    """
    The user's membership type in the organization.
    """

    admin = "admin"
    member = "member"
    billing_manager = "billing_manager"


class Permissions6(BaseModel):
    can_create_repository: bool | None = None


class OrgMembership(BaseModel):
    """
    Org Membership
    """

    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/orgs/octocat/memberships/defunkt"),
    ] = None
    state: Annotated[State3 | None, Field(example="active")] = None
    """
    The state of the member in the organization. The `pending` state indicates the user has not yet accepted an invitation.
    """
    role: Annotated[Role | None, Field(example="admin")] = None
    """
    The user's membership type in the organization.
    """
    organization_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/orgs/octocat")
    ] = None
    organization: OrganizationSimple | None = None
    user: NullableSimpleUser | None = None
    permissions: Permissions6 | None = None


class Migration(BaseModel):
    """
    A migration.
    """

    id: Annotated[int | None, Field(example=79)] = None
    owner: NullableSimpleUser | None = None
    guid: Annotated[
        str | None, Field(example="0b989ba4-242f-11e5-81e1-c7b6966d2516")
    ] = None
    state: Annotated[str | None, Field(example="pending")] = None
    lock_repositories: Annotated[bool | None, Field(example=True)] = None
    exclude_metadata: bool | None = None
    exclude_git_data: bool | None = None
    exclude_attachments: bool | None = None
    exclude_releases: bool | None = None
    exclude_owner_projects: bool | None = None
    org_metadata_only: bool | None = None
    repositories: Sequence[Repository] | None = None
    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/orgs/octo-org/migrations/79"),
    ] = None
    created_at: Annotated[
        datetime | None, Field(example="2015-07-06T15:33:38-07:00")
    ] = None
    updated_at: Annotated[
        datetime | None, Field(example="2015-07-06T15:33:38-07:00")
    ] = None
    node_id: str | None = None
    archive_url: AnyUrl | None = None
    exclude: Sequence | None = None


class Permissions7(BaseModel):
    admin: bool | None = None
    maintain: bool | None = None
    push: bool | None = None
    triage: bool | None = None
    pull: bool | None = None


class NullableMinimalRepository(BaseModel):
    """
    Minimal Repository
    """

    id: Annotated[int | None, Field(example=1296269)] = None
    node_id: Annotated[str | None, Field(example="MDEwOlJlcG9zaXRvcnkxMjk2MjY5")] = None
    name: Annotated[str | None, Field(example="Hello-World")] = None
    full_name: Annotated[str | None, Field(example="octocat/Hello-World")] = None
    owner: SimpleUser | None = None
    private: bool | None = None
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat/Hello-World")
    ] = None
    description: Annotated[str | None, Field(example="This your first repo!")] = None
    fork: bool | None = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/repos/octocat/Hello-World")
    ] = None
    archive_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}"
        ),
    ] = None
    assignees_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/assignees{/user}"
        ),
    ] = None
    blobs_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}"
        ),
    ] = None
    branches_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/branches{/branch}"
        ),
    ] = None
    collaborators_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}"
        ),
    ] = None
    comments_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/comments{/number}"
        ),
    ] = None
    commits_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/commits{/sha}"),
    ] = None
    compare_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}"
        ),
    ] = None
    contents_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/contents/{+path}"
        ),
    ] = None
    contributors_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/contributors"),
    ] = None
    deployments_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/deployments"),
    ] = None
    downloads_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/downloads"),
    ] = None
    events_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/events"),
    ] = None
    forks_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/forks"),
    ] = None
    git_commits_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/commits{/sha}"
        ),
    ] = None
    git_refs_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/git/refs{/sha}"),
    ] = None
    git_tags_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/git/tags{/sha}"),
    ] = None
    git_url: str | None = None
    issue_comment_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues/comments{/number}"
        ),
    ] = None
    issue_events_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues/events{/number}"
        ),
    ] = None
    issues_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues{/number}"
        ),
    ] = None
    keys_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/keys{/key_id}"),
    ] = None
    labels_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/labels{/name}"),
    ] = None
    languages_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/languages"),
    ] = None
    merges_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/merges"),
    ] = None
    milestones_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/milestones{/number}"
        ),
    ] = None
    notifications_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}"
        ),
    ] = None
    pulls_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/pulls{/number}"),
    ] = None
    releases_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/releases{/id}"),
    ] = None
    ssh_url: str | None = None
    stargazers_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/stargazers"),
    ] = None
    statuses_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/statuses/{sha}"),
    ] = None
    subscribers_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/subscribers"),
    ] = None
    subscription_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/subscription"),
    ] = None
    tags_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/tags"),
    ] = None
    teams_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/teams"),
    ] = None
    trees_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/trees{/sha}"
        ),
    ] = None
    clone_url: str | None = None
    mirror_url: str | None = None
    hooks_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/hooks"),
    ] = None
    svn_url: str | None = None
    homepage: str | None = None
    language: str | None = None
    forks_count: int | None = None
    stargazers_count: int | None = None
    watchers_count: int | None = None
    size: int | None = None
    """
    The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.
    """
    default_branch: str | None = None
    open_issues_count: int | None = None
    is_template: bool | None = None
    topics: Sequence[str] | None = None
    has_issues: bool | None = None
    has_projects: bool | None = None
    has_wiki: bool | None = None
    has_pages: bool | None = None
    has_downloads: bool | None = None
    archived: bool | None = None
    disabled: bool | None = None
    visibility: str | None = None
    pushed_at: Annotated[datetime | None, Field(example="2011-01-26T19:06:43Z")] = None
    created_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2011-01-26T19:14:43Z")] = None
    permissions: Permissions7 | None = None
    role_name: Annotated[str | None, Field(example="admin")] = None
    temp_clone_token: str | None = None
    delete_branch_on_merge: bool | None = None
    subscribers_count: int | None = None
    network_count: int | None = None
    code_of_conduct: CodeOfConduct | None = None
    license: License1 | None = None
    forks: Annotated[int | None, Field(example=0)] = None
    open_issues: Annotated[int | None, Field(example=0)] = None
    watchers: Annotated[int | None, Field(example=0)] = None
    allow_forking: bool | None = None
    web_commit_signoff_required: Annotated[bool | None, Field(example=False)] = None


class PackageType(Enum):
    npm = "npm"
    maven = "maven"
    rubygems = "rubygems"
    docker = "docker"
    nuget = "nuget"
    container = "container"


class Visibility3(Enum):
    private = "private"
    public = "public"


class Package(BaseModel):
    """
    A software package
    """

    id: Annotated[int | None, Field(example=1)] = None
    """
    Unique identifier of the package.
    """
    name: Annotated[str | None, Field(example="super-linter")] = None
    """
    The name of the package.
    """
    package_type: Annotated[PackageType | None, Field(example="docker")] = None
    url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/orgs/github/packages/container/super-linter"
        ),
    ] = None
    html_url: Annotated[
        str | None,
        Field(
            example="https://github.com/orgs/github/packages/container/package/super-linter"
        ),
    ] = None
    version_count: Annotated[int | None, Field(example=1)] = None
    """
    The number of versions of the package.
    """
    visibility: Annotated[Visibility3 | None, Field(example="private")] = None
    owner: NullableSimpleUser | None = None
    repository: NullableMinimalRepository | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None


class Container(BaseModel):
    tags: Sequence[str] | None = None


class Docker(BaseModel):
    tag: Sequence[str] | None = None


class Metadata1(BaseModel):
    package_type: Annotated[PackageType | None, Field(example="docker")] = None
    container: Annotated[Container | None, Field(title="Container Metadata")] = None
    docker: Annotated[Docker | None, Field(title="Docker Metadata")] = None


class PackageVersion(BaseModel):
    """
    A version of a software package
    """

    id: Annotated[int | None, Field(example=1)] = None
    """
    Unique identifier of the package version.
    """
    name: Annotated[str | None, Field(example="latest")] = None
    """
    The name of the package version.
    """
    url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/orgs/github/packages/container/super-linter/versions/786068"
        ),
    ] = None
    package_html_url: Annotated[
        str | None,
        Field(
            example="https://github.com/orgs/github/packages/container/package/super-linter"
        ),
    ] = None
    html_url: Annotated[
        str | None,
        Field(
            example="https://github.com/orgs/github/packages/container/super-linter/786068"
        ),
    ] = None
    license: Annotated[str | None, Field(example="MIT")] = None
    description: str | None = None
    created_at: Annotated[datetime | None, Field(example="2011-04-10T20:09:31Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2014-03-03T18:58:10Z")] = None
    deleted_at: Annotated[datetime | None, Field(example="2014-03-03T18:58:10Z")] = None
    metadata: Annotated[
        Metadata1 | None, Field(title="Package Version Metadata")
    ] = None


class OrganizationPermission(Enum):
    """
    The baseline permission that all organization members have on this project. Only present if owner is an organization.
    """

    read = "read"
    write = "write"
    admin = "admin"
    none = "none"


class Project(BaseModel):
    """
    Projects are a way to organize columns and cards of work.
    """

    owner_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/api-playground/projects-test"),
    ] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/projects/1002604")
    ] = None
    html_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/api-playground/projects-test/projects/12"),
    ] = None
    columns_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/projects/1002604/columns")
    ] = None
    id: Annotated[int | None, Field(example=1002604)] = None
    node_id: Annotated[str | None, Field(example="MDc6UHJvamVjdDEwMDI2MDQ=")] = None
    name: Annotated[str | None, Field(example="Week One Sprint")] = None
    """
    Name of the project
    """
    body: Annotated[
        str | None,
        Field(
            example="This project represents the sprint of the first week in January"
        ),
    ] = None
    """
    Body of the project
    """
    number: Annotated[int | None, Field(example=1)] = None
    state: Annotated[str | None, Field(example="open")] = None
    """
    State of the project; either 'open' or 'closed'
    """
    creator: NullableSimpleUser | None = None
    created_at: Annotated[datetime | None, Field(example="2011-04-10T20:09:31Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2014-03-03T18:58:10Z")] = None
    organization_permission: OrganizationPermission | None = None
    """
    The baseline permission that all organization members have on this project. Only present if owner is an organization.
    """
    private: bool | None = None
    """
    Whether or not this project can be seen by everyone. Only present if owner is an organization.
    """


class TeamSimple(BaseModel):
    """
    Groups of organization members that gives permissions on specified repositories.
    """

    id: Annotated[int | None, Field(example=1)] = None
    """
    Unique identifier of the team
    """
    node_id: Annotated[str | None, Field(example="MDQ6VGVhbTE=")] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/organizations/1/team/1")
    ] = None
    """
    URL for the team
    """
    members_url: Annotated[
        str | None,
        Field(example="https://api.github.com/organizations/1/team/1/members{/member}"),
    ] = None
    name: Annotated[str | None, Field(example="Justice League")] = None
    """
    Name of the team
    """
    description: Annotated[str | None, Field(example="A great team.")] = None
    """
    Description of the team
    """
    permission: Annotated[str | None, Field(example="admin")] = None
    """
    Permission that the team will have for its repositories
    """
    privacy: Annotated[str | None, Field(example="closed")] = None
    """
    The level of privacy this team should have
    """
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/orgs/rails/teams/core")
    ] = None
    repositories_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/organizations/1/team/1/repos"),
    ] = None
    slug: Annotated[str | None, Field(example="justice-league")] = None
    ldap_dn: Annotated[
        str | None, Field(example="uid=example,ou=users,dc=github,dc=com")
    ] = None
    """
    Distinguished Name (DN) that team maps to within LDAP environment
    """


class MinutesUsedBreakdown(BaseModel):
    UBUNTU: int | None = None
    """
    Total minutes used on Ubuntu runner machines.
    """
    MACOS: int | None = None
    """
    Total minutes used on macOS runner machines.
    """
    WINDOWS: int | None = None
    """
    Total minutes used on Windows runner machines.
    """
    ubuntu_4_core: int | None = None
    """
    Total minutes used on Ubuntu 4 core runner machines.
    """
    ubuntu_8_core: int | None = None
    """
    Total minutes used on Ubuntu 8 core runner machines.
    """
    ubuntu_16_core: int | None = None
    """
    Total minutes used on Ubuntu 16 core runner machines.
    """
    ubuntu_32_core: int | None = None
    """
    Total minutes used on Ubuntu 32 core runner machines.
    """
    ubuntu_64_core: int | None = None
    """
    Total minutes used on Ubuntu 64 core runner machines.
    """
    windows_4_core: int | None = None
    """
    Total minutes used on Windows 4 core runner machines.
    """
    windows_8_core: int | None = None
    """
    Total minutes used on Windows 8 core runner machines.
    """
    windows_16_core: int | None = None
    """
    Total minutes used on Windows 16 core runner machines.
    """
    windows_32_core: int | None = None
    """
    Total minutes used on Windows 32 core runner machines.
    """
    windows_64_core: int | None = None
    """
    Total minutes used on Windows 64 core runner machines.
    """
    total: int | None = None
    """
    Total minutes used on all runner machines.
    """


class ActionsBillingUsage(BaseModel):
    total_minutes_used: int | None = None
    """
    The sum of the free and paid GitHub Actions minutes used.
    """
    total_paid_minutes_used: int | None = None
    """
    The total paid GitHub Actions minutes used.
    """
    included_minutes: int | None = None
    """
    The amount of free GitHub Actions minutes available.
    """
    minutes_used_breakdown: MinutesUsedBreakdown | None = None


class PackagesBillingUsage(BaseModel):
    total_gigabytes_bandwidth_used: int | None = None
    """
    Sum of the free and paid storage space (GB) for GitHuub Packages.
    """
    total_paid_gigabytes_bandwidth_used: int | None = None
    """
    Total paid storage space (GB) for GitHuub Packages.
    """
    included_gigabytes_bandwidth: int | None = None
    """
    Free storage space (GB) for GitHub Packages.
    """


class CombinedBillingUsage(BaseModel):
    days_left_in_billing_cycle: int | None = None
    """
    Numbers of days left in billing cycle.
    """
    estimated_paid_storage_for_month: int | None = None
    """
    Estimated storage space (GB) used in billing cycle.
    """
    estimated_storage_for_month: int | None = None
    """
    Estimated sum of free and paid storage space (GB) used in billing cycle.
    """


class TeamOrganization(BaseModel):
    """
    Team Organization
    """

    login: Annotated[str | None, Field(example="github")] = None
    id: Annotated[int | None, Field(example=1)] = None
    node_id: Annotated[str | None, Field(example="MDEyOk9yZ2FuaXphdGlvbjE=")] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/orgs/github")
    ] = None
    repos_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/orgs/github/repos")
    ] = None
    events_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/orgs/github/events")
    ] = None
    hooks_url: Annotated[
        str | None, Field(example="https://api.github.com/orgs/github/hooks")
    ] = None
    issues_url: Annotated[
        str | None, Field(example="https://api.github.com/orgs/github/issues")
    ] = None
    members_url: Annotated[
        str | None, Field(example="https://api.github.com/orgs/github/members{/member}")
    ] = None
    public_members_url: Annotated[
        str | None,
        Field(example="https://api.github.com/orgs/github/public_members{/member}"),
    ] = None
    avatar_url: Annotated[
        str | None, Field(example="https://github.com/images/error/octocat_happy.gif")
    ] = None
    description: Annotated[str | None, Field(example="A great organization")] = None
    name: Annotated[str | None, Field(example="github")] = None
    company: Annotated[str | None, Field(example="GitHub")] = None
    blog: Annotated[AnyUrl | None, Field(example="https://github.com/blog")] = None
    location: Annotated[str | None, Field(example="San Francisco")] = None
    email: Annotated[EmailStr | None, Field(example="octocat@github.com")] = None
    twitter_username: Annotated[str | None, Field(example="github")] = None
    is_verified: Annotated[bool | None, Field(example=True)] = None
    has_organization_projects: Annotated[bool | None, Field(example=True)] = None
    has_repository_projects: Annotated[bool | None, Field(example=True)] = None
    public_repos: Annotated[int | None, Field(example=2)] = None
    public_gists: Annotated[int | None, Field(example=1)] = None
    followers: Annotated[int | None, Field(example=20)] = None
    following: Annotated[int | None, Field(example=0)] = None
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat")
    ] = None
    created_at: Annotated[datetime | None, Field(example="2008-01-14T04:33:35Z")] = None
    type: Annotated[str | None, Field(example="Organization")] = None
    total_private_repos: Annotated[int | None, Field(example=100)] = None
    owned_private_repos: Annotated[int | None, Field(example=100)] = None
    private_gists: Annotated[int | None, Field(example=81)] = None
    disk_usage: Annotated[int | None, Field(example=10000)] = None
    collaborators: Annotated[int | None, Field(example=8)] = None
    billing_email: Annotated[EmailStr | None, Field(example="org@example.com")] = None
    plan: Plan1 | None = None
    default_repository_permission: str | None = None
    members_can_create_repositories: Annotated[bool | None, Field(example=True)] = None
    two_factor_requirement_enabled: Annotated[bool | None, Field(example=True)] = None
    members_allowed_repository_creation_type: Annotated[
        str | None, Field(example="all")
    ] = None
    members_can_create_public_repositories: Annotated[
        bool | None, Field(example=True)
    ] = None
    members_can_create_private_repositories: Annotated[
        bool | None, Field(example=True)
    ] = None
    members_can_create_internal_repositories: Annotated[
        bool | None, Field(example=True)
    ] = None
    members_can_create_pages: Annotated[bool | None, Field(example=True)] = None
    members_can_create_public_pages: Annotated[bool | None, Field(example=True)] = None
    members_can_create_private_pages: Annotated[bool | None, Field(example=True)] = None
    members_can_fork_private_repositories: Annotated[
        bool | None, Field(example=False)
    ] = None
    web_commit_signoff_required: Annotated[bool | None, Field(example=False)] = None
    updated_at: datetime | None = None


class Privacy(Enum):
    """
    The level of privacy this team should have
    """

    closed = "closed"
    secret = "secret"


class TeamFull(BaseModel):
    """
    Groups of organization members that gives permissions on specified repositories.
    """

    id: Annotated[int | None, Field(example=42)] = None
    """
    Unique identifier of the team
    """
    node_id: Annotated[str | None, Field(example="MDQ6VGVhbTE=")] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/organizations/1/team/1")
    ] = None
    """
    URL for the team
    """
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/orgs/rails/teams/core")
    ] = None
    name: Annotated[str | None, Field(example="Developers")] = None
    """
    Name of the team
    """
    slug: Annotated[str | None, Field(example="justice-league")] = None
    description: Annotated[str | None, Field(example="A great team.")] = None
    privacy: Annotated[Privacy | None, Field(example="closed")] = None
    """
    The level of privacy this team should have
    """
    permission: Annotated[str | None, Field(example="push")] = None
    """
    Permission that the team will have for its repositories
    """
    members_url: Annotated[
        str | None,
        Field(example="https://api.github.com/organizations/1/team/1/members{/member}"),
    ] = None
    repositories_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/organizations/1/team/1/repos"),
    ] = None
    parent: NullableTeamSimple | None = None
    members_count: Annotated[int | None, Field(example=3)] = None
    repos_count: Annotated[int | None, Field(example=10)] = None
    created_at: Annotated[datetime | None, Field(example="2017-07-14T16:53:42Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2017-08-17T12:37:15Z")] = None
    organization: TeamOrganization | None = None
    ldap_dn: Annotated[
        str | None, Field(example="uid=example,ou=users,dc=github,dc=com")
    ] = None
    """
    Distinguished Name (DN) that team maps to within LDAP environment
    """


class TeamDiscussion(BaseModel):
    """
    A team discussion is a persistent record of a free-form conversation within a team.
    """

    author: NullableSimpleUser | None = None
    body: Annotated[
        str | None,
        Field(example="Please suggest improvements to our workflow in comments."),
    ] = None
    """
    The main text of the discussion.
    """
    body_html: Annotated[
        str | None,
        Field(example="<p>Hi! This is an area for us to collaborate as a team</p>"),
    ] = None
    body_version: Annotated[
        str | None, Field(example="0307116bbf7ced493b8d8a346c650b71")
    ] = None
    """
    The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
    """
    comments_count: Annotated[int | None, Field(example=0)] = None
    comments_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/organizations/1/team/2343027/discussions/1/comments"
        ),
    ] = None
    created_at: Annotated[datetime | None, Field(example="2018-01-25T18:56:31Z")] = None
    last_edited_at: datetime | None = None
    html_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://github.com/orgs/github/teams/justice-league/discussions/1"
        ),
    ] = None
    node_id: Annotated[str | None, Field(example="MDE0OlRlYW1EaXNjdXNzaW9uMQ==")] = None
    number: Annotated[int | None, Field(example=42)] = None
    """
    The unique sequence number of a team discussion.
    """
    pinned: Annotated[bool | None, Field(example=True)] = None
    """
    Whether or not this discussion should be pinned for easy retrieval.
    """
    private: Annotated[bool | None, Field(example=True)] = None
    """
    Whether or not this discussion should be restricted to team members and organization administrators.
    """
    team_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/organizations/1/team/2343027"),
    ] = None
    title: Annotated[
        str | None, Field(example="How can we improve our workflow?")
    ] = None
    """
    The title of the discussion.
    """
    updated_at: Annotated[datetime | None, Field(example="2018-01-25T18:56:31Z")] = None
    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/organizations/1/team/2343027/discussions/1"
        ),
    ] = None
    reactions: ReactionRollup | None = None


class TeamDiscussionComment(BaseModel):
    """
    A reply to a discussion within a team.
    """

    author: NullableSimpleUser | None = None
    body: Annotated[str | None, Field(example="I agree with this suggestion.")] = None
    """
    The main text of the comment.
    """
    body_html: Annotated[str | None, Field(example="<p>Do you like apples?</p>")] = None
    body_version: Annotated[
        str | None, Field(example="0307116bbf7ced493b8d8a346c650b71")
    ] = None
    """
    The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
    """
    created_at: Annotated[datetime | None, Field(example="2018-01-15T23:53:58Z")] = None
    last_edited_at: datetime | None = None
    discussion_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/organizations/1/team/2403582/discussions/1"
        ),
    ] = None
    html_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://github.com/orgs/github/teams/justice-league/discussions/1/comments/1"
        ),
    ] = None
    node_id: Annotated[
        str | None, Field(example="MDIxOlRlYW1EaXNjdXNzaW9uQ29tbWVudDE=")
    ] = None
    number: Annotated[int | None, Field(example=42)] = None
    """
    The unique sequence number of a team discussion comment.
    """
    updated_at: Annotated[datetime | None, Field(example="2018-01-15T23:53:58Z")] = None
    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/organizations/1/team/2403582/discussions/1/comments/1"
        ),
    ] = None
    reactions: ReactionRollup | None = None


class Content(Enum):
    """
    The reaction to use
    """

    field_1 = "+1"
    field_1_1 = "-1"
    laugh = "laugh"
    confused = "confused"
    heart = "heart"
    hooray = "hooray"
    rocket = "rocket"
    eyes = "eyes"


class Reaction(BaseModel):
    """
    Reactions to conversations provide a way to help people express their feelings more simply and effectively.
    """

    id: Annotated[int | None, Field(example=1)] = None
    node_id: Annotated[str | None, Field(example="MDg6UmVhY3Rpb24x")] = None
    user: NullableSimpleUser | None = None
    content: Annotated[Content | None, Field(example="heart")] = None
    """
    The reaction to use
    """
    created_at: Annotated[datetime | None, Field(example="2016-05-20T20:09:31Z")] = None


class Role1(Enum):
    """
    The role of the user in the team.
    """

    member = "member"
    maintainer = "maintainer"


class State4(Enum):
    """
    The state of the user's membership in the team.
    """

    active = "active"
    pending = "pending"


class TeamMembership(BaseModel):
    """
    Team Membership
    """

    url: AnyUrl | None = None
    role: Annotated[Role1 | None, Field(example="member")] = "member"
    """
    The role of the user in the team.
    """
    state: State4 | None = None
    """
    The state of the user's membership in the team.
    """


class Permissions8(BaseModel):
    read: bool | None = None
    write: bool | None = None
    admin: bool | None = None


class TeamProject(BaseModel):
    """
    A team's access to a project.
    """

    owner_url: str | None = None
    url: str | None = None
    html_url: str | None = None
    columns_url: str | None = None
    id: int | None = None
    node_id: str | None = None
    name: str | None = None
    body: str | None = None
    number: int | None = None
    state: str | None = None
    creator: SimpleUser | None = None
    created_at: str | None = None
    updated_at: str | None = None
    organization_permission: str | None = None
    """
    The organization permission for this project. Only present when owner is an organization.
    """
    private: bool | None = None
    """
    Whether the project is private or not. Only present when owner is an organization.
    """
    permissions: Permissions8 | None = None


class Permissions9(BaseModel):
    admin: bool | None = None
    pull: bool | None = None
    triage: bool | None = None
    push: bool | None = None
    maintain: bool | None = None


class Permissions10(BaseModel):
    admin: bool | None = None
    maintain: bool | None = None
    push: bool | None = None
    triage: bool | None = None
    pull: bool | None = None


class TemplateRepository1(BaseModel):
    id: int | None = None
    node_id: str | None = None
    name: str | None = None
    full_name: str | None = None
    owner: Owner | None = None
    private: bool | None = None
    html_url: str | None = None
    description: str | None = None
    fork: bool | None = None
    url: str | None = None
    archive_url: str | None = None
    assignees_url: str | None = None
    blobs_url: str | None = None
    branches_url: str | None = None
    collaborators_url: str | None = None
    comments_url: str | None = None
    commits_url: str | None = None
    compare_url: str | None = None
    contents_url: str | None = None
    contributors_url: str | None = None
    deployments_url: str | None = None
    downloads_url: str | None = None
    events_url: str | None = None
    forks_url: str | None = None
    git_commits_url: str | None = None
    git_refs_url: str | None = None
    git_tags_url: str | None = None
    git_url: str | None = None
    issue_comment_url: str | None = None
    issue_events_url: str | None = None
    issues_url: str | None = None
    keys_url: str | None = None
    labels_url: str | None = None
    languages_url: str | None = None
    merges_url: str | None = None
    milestones_url: str | None = None
    notifications_url: str | None = None
    pulls_url: str | None = None
    releases_url: str | None = None
    ssh_url: str | None = None
    stargazers_url: str | None = None
    statuses_url: str | None = None
    subscribers_url: str | None = None
    subscription_url: str | None = None
    tags_url: str | None = None
    teams_url: str | None = None
    trees_url: str | None = None
    clone_url: str | None = None
    mirror_url: str | None = None
    hooks_url: str | None = None
    svn_url: str | None = None
    homepage: str | None = None
    language: str | None = None
    forks_count: int | None = None
    stargazers_count: int | None = None
    watchers_count: int | None = None
    size: int | None = None
    default_branch: str | None = None
    open_issues_count: int | None = None
    is_template: bool | None = None
    topics: Sequence[str] | None = None
    has_issues: bool | None = None
    has_projects: bool | None = None
    has_wiki: bool | None = None
    has_pages: bool | None = None
    has_downloads: bool | None = None
    archived: bool | None = None
    disabled: bool | None = None
    visibility: str | None = None
    pushed_at: str | None = None
    created_at: str | None = None
    updated_at: str | None = None
    permissions: Permissions10 | None = None
    allow_rebase_merge: bool | None = None
    temp_clone_token: str | None = None
    allow_squash_merge: bool | None = None
    allow_auto_merge: bool | None = None
    delete_branch_on_merge: bool | None = None
    allow_update_branch: bool | None = None
    use_squash_pr_title_as_default: bool | None = None
    squash_merge_commit_title: SquashMergeCommitTitle | None = None
    """
    The default value for a squash merge commit title:

    - `PR_TITLE` - default to the pull request's title.
    - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
    """
    squash_merge_commit_message: SquashMergeCommitMessage | None = None
    """
    The default value for a squash merge commit message:

    - `PR_BODY` - default to the pull request's body.
    - `COMMIT_MESSAGES` - default to the branch's commit messages.
    - `BLANK` - default to a blank commit message.
    """
    merge_commit_title: MergeCommitTitle | None = None
    """
    The default value for a merge commit title.

    - `PR_TITLE` - default to the pull request's title.
    - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
    """
    merge_commit_message: MergeCommitMessage | None = None
    """
    The default value for a merge commit message.

    - `PR_TITLE` - default to the pull request's title.
    - `PR_BODY` - default to the pull request's body.
    - `BLANK` - default to a blank commit message.
    """
    allow_merge_commit: bool | None = None
    subscribers_count: int | None = None
    network_count: int | None = None


class NullableRepository(BaseModel):
    """
    A git repository
    """

    id: Annotated[int | None, Field(example=42)] = None
    """
    Unique identifier of the repository
    """
    node_id: Annotated[str | None, Field(example="MDEwOlJlcG9zaXRvcnkxMjk2MjY5")] = None
    name: Annotated[str | None, Field(example="Team Environment")] = None
    """
    The name of the repository.
    """
    full_name: Annotated[str | None, Field(example="octocat/Hello-World")] = None
    license: NullableLicenseSimple | None = None
    organization: NullableSimpleUser | None = None
    forks: int | None = None
    permissions: Permissions9 | None = None
    owner: SimpleUser | None = None
    private: bool | None = False
    """
    Whether the repository is private or public.
    """
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat/Hello-World")
    ] = None
    description: Annotated[str | None, Field(example="This your first repo!")] = None
    fork: bool | None = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/repos/octocat/Hello-World")
    ] = None
    archive_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}"
        ),
    ] = None
    assignees_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/assignees{/user}"
        ),
    ] = None
    blobs_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}"
        ),
    ] = None
    branches_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/branches{/branch}"
        ),
    ] = None
    collaborators_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}"
        ),
    ] = None
    comments_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/comments{/number}"
        ),
    ] = None
    commits_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/commits{/sha}"),
    ] = None
    compare_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}"
        ),
    ] = None
    contents_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/contents/{+path}"
        ),
    ] = None
    contributors_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/contributors"),
    ] = None
    deployments_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/deployments"),
    ] = None
    downloads_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/downloads"),
    ] = None
    events_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/events"),
    ] = None
    forks_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/forks"),
    ] = None
    git_commits_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/commits{/sha}"
        ),
    ] = None
    git_refs_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/git/refs{/sha}"),
    ] = None
    git_tags_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/git/tags{/sha}"),
    ] = None
    git_url: Annotated[
        str | None, Field(example="git:github.com/octocat/Hello-World.git")
    ] = None
    issue_comment_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues/comments{/number}"
        ),
    ] = None
    issue_events_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues/events{/number}"
        ),
    ] = None
    issues_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues{/number}"
        ),
    ] = None
    keys_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/keys{/key_id}"),
    ] = None
    labels_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/labels{/name}"),
    ] = None
    languages_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/languages"),
    ] = None
    merges_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/merges"),
    ] = None
    milestones_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/milestones{/number}"
        ),
    ] = None
    notifications_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}"
        ),
    ] = None
    pulls_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/pulls{/number}"),
    ] = None
    releases_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/releases{/id}"),
    ] = None
    ssh_url: Annotated[
        str | None, Field(example="git@github.com:octocat/Hello-World.git")
    ] = None
    stargazers_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/stargazers"),
    ] = None
    statuses_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/statuses/{sha}"),
    ] = None
    subscribers_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/subscribers"),
    ] = None
    subscription_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/subscription"),
    ] = None
    tags_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/tags"),
    ] = None
    teams_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/teams"),
    ] = None
    trees_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/trees{/sha}"
        ),
    ] = None
    clone_url: Annotated[
        str | None, Field(example="https://github.com/octocat/Hello-World.git")
    ] = None
    mirror_url: Annotated[
        AnyUrl | None, Field(example="git:git.example.com/octocat/Hello-World")
    ] = None
    hooks_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/hooks"),
    ] = None
    svn_url: Annotated[
        AnyUrl | None, Field(example="https://svn.github.com/octocat/Hello-World")
    ] = None
    homepage: Annotated[AnyUrl | None, Field(example="https://github.com")] = None
    language: str | None = None
    forks_count: Annotated[int | None, Field(example=9)] = None
    stargazers_count: Annotated[int | None, Field(example=80)] = None
    watchers_count: Annotated[int | None, Field(example=80)] = None
    size: Annotated[int | None, Field(example=108)] = None
    """
    The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.
    """
    default_branch: Annotated[str | None, Field(example="master")] = None
    """
    The default branch of the repository.
    """
    open_issues_count: Annotated[int | None, Field(example=0)] = None
    is_template: Annotated[bool | None, Field(example=True)] = False
    """
    Whether this repository acts as a template that can be used to generate new repositories.
    """
    topics: Sequence[str] | None = None
    has_issues: Annotated[bool | None, Field(example=True)] = True
    """
    Whether issues are enabled.
    """
    has_projects: Annotated[bool | None, Field(example=True)] = True
    """
    Whether projects are enabled.
    """
    has_wiki: Annotated[bool | None, Field(example=True)] = True
    """
    Whether the wiki is enabled.
    """
    has_pages: bool | None = None
    has_downloads: Annotated[bool | None, Field(example=True)] = True
    """
    Whether downloads are enabled.
    """
    archived: bool | None = False
    """
    Whether the repository is archived.
    """
    disabled: bool | None = None
    """
    Returns whether or not this repository disabled.
    """
    visibility: str | None = "public"
    """
    The repository visibility: public, private, or internal.
    """
    pushed_at: Annotated[datetime | None, Field(example="2011-01-26T19:06:43Z")] = None
    created_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2011-01-26T19:14:43Z")] = None
    allow_rebase_merge: Annotated[bool | None, Field(example=True)] = True
    """
    Whether to allow rebase merges for pull requests.
    """
    template_repository: TemplateRepository1 | None = None
    temp_clone_token: str | None = None
    allow_squash_merge: Annotated[bool | None, Field(example=True)] = True
    """
    Whether to allow squash merges for pull requests.
    """
    allow_auto_merge: Annotated[bool | None, Field(example=False)] = False
    """
    Whether to allow Auto-merge to be used on pull requests.
    """
    delete_branch_on_merge: Annotated[bool | None, Field(example=False)] = False
    """
    Whether to delete head branches when pull requests are merged
    """
    allow_update_branch: Annotated[bool | None, Field(example=False)] = False
    """
    Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
    """
    use_squash_pr_title_as_default: bool | None = False
    """
    Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
    """
    squash_merge_commit_title: SquashMergeCommitTitle | None = None
    """
    The default value for a squash merge commit title:

    - `PR_TITLE` - default to the pull request's title.
    - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
    """
    squash_merge_commit_message: SquashMergeCommitMessage | None = None
    """
    The default value for a squash merge commit message:

    - `PR_BODY` - default to the pull request's body.
    - `COMMIT_MESSAGES` - default to the branch's commit messages.
    - `BLANK` - default to a blank commit message.
    """
    merge_commit_title: MergeCommitTitle | None = None
    """
    The default value for a merge commit title.

    - `PR_TITLE` - default to the pull request's title.
    - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
    """
    merge_commit_message: MergeCommitMessage | None = None
    """
    The default value for a merge commit message.

    - `PR_TITLE` - default to the pull request's title.
    - `PR_BODY` - default to the pull request's body.
    - `BLANK` - default to a blank commit message.
    """
    allow_merge_commit: Annotated[bool | None, Field(example=True)] = True
    """
    Whether to allow merge commits for pull requests.
    """
    allow_forking: bool | None = None
    """
    Whether to allow forking this repo
    """
    web_commit_signoff_required: bool | None = False
    """
    Whether to require contributors to sign off on web-based commits
    """
    subscribers_count: int | None = None
    network_count: int | None = None
    open_issues: int | None = None
    watchers: int | None = None
    master_branch: str | None = None
    starred_at: Annotated[str | None, Field(example='"2020-07-09T00:17:42Z"')] = None
    anonymous_access_enabled: bool | None = None
    """
    Whether anonymous git access is enabled for this repository
    """


class Permissions11(BaseModel):
    admin: bool | None = None
    pull: bool | None = None
    triage: bool | None = None
    push: bool | None = None
    maintain: bool | None = None


class TeamRepository(BaseModel):
    """
    A team's access to a repository.
    """

    id: Annotated[int | None, Field(example=42)] = None
    """
    Unique identifier of the repository
    """
    node_id: Annotated[str | None, Field(example="MDEwOlJlcG9zaXRvcnkxMjk2MjY5")] = None
    name: Annotated[str | None, Field(example="Team Environment")] = None
    """
    The name of the repository.
    """
    full_name: Annotated[str | None, Field(example="octocat/Hello-World")] = None
    license: NullableLicenseSimple | None = None
    forks: int | None = None
    permissions: Permissions11 | None = None
    role_name: Annotated[str | None, Field(example="admin")] = None
    owner: NullableSimpleUser | None = None
    private: bool | None = False
    """
    Whether the repository is private or public.
    """
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat/Hello-World")
    ] = None
    description: Annotated[str | None, Field(example="This your first repo!")] = None
    fork: bool | None = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/repos/octocat/Hello-World")
    ] = None
    archive_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}"
        ),
    ] = None
    assignees_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/assignees{/user}"
        ),
    ] = None
    blobs_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}"
        ),
    ] = None
    branches_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/branches{/branch}"
        ),
    ] = None
    collaborators_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}"
        ),
    ] = None
    comments_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/comments{/number}"
        ),
    ] = None
    commits_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/commits{/sha}"),
    ] = None
    compare_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}"
        ),
    ] = None
    contents_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/contents/{+path}"
        ),
    ] = None
    contributors_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/contributors"),
    ] = None
    deployments_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/deployments"),
    ] = None
    downloads_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/downloads"),
    ] = None
    events_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/events"),
    ] = None
    forks_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/forks"),
    ] = None
    git_commits_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/commits{/sha}"
        ),
    ] = None
    git_refs_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/git/refs{/sha}"),
    ] = None
    git_tags_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/git/tags{/sha}"),
    ] = None
    git_url: Annotated[
        str | None, Field(example="git:github.com/octocat/Hello-World.git")
    ] = None
    issue_comment_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues/comments{/number}"
        ),
    ] = None
    issue_events_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues/events{/number}"
        ),
    ] = None
    issues_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues{/number}"
        ),
    ] = None
    keys_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/keys{/key_id}"),
    ] = None
    labels_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/labels{/name}"),
    ] = None
    languages_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/languages"),
    ] = None
    merges_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/merges"),
    ] = None
    milestones_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/milestones{/number}"
        ),
    ] = None
    notifications_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}"
        ),
    ] = None
    pulls_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/pulls{/number}"),
    ] = None
    releases_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/releases{/id}"),
    ] = None
    ssh_url: Annotated[
        str | None, Field(example="git@github.com:octocat/Hello-World.git")
    ] = None
    stargazers_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/stargazers"),
    ] = None
    statuses_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/statuses/{sha}"),
    ] = None
    subscribers_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/subscribers"),
    ] = None
    subscription_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/subscription"),
    ] = None
    tags_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/tags"),
    ] = None
    teams_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/teams"),
    ] = None
    trees_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/trees{/sha}"
        ),
    ] = None
    clone_url: Annotated[
        str | None, Field(example="https://github.com/octocat/Hello-World.git")
    ] = None
    mirror_url: Annotated[
        AnyUrl | None, Field(example="git:git.example.com/octocat/Hello-World")
    ] = None
    hooks_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/hooks"),
    ] = None
    svn_url: Annotated[
        AnyUrl | None, Field(example="https://svn.github.com/octocat/Hello-World")
    ] = None
    homepage: Annotated[AnyUrl | None, Field(example="https://github.com")] = None
    language: str | None = None
    forks_count: Annotated[int | None, Field(example=9)] = None
    stargazers_count: Annotated[int | None, Field(example=80)] = None
    watchers_count: Annotated[int | None, Field(example=80)] = None
    size: Annotated[int | None, Field(example=108)] = None
    default_branch: Annotated[str | None, Field(example="master")] = None
    """
    The default branch of the repository.
    """
    open_issues_count: Annotated[int | None, Field(example=0)] = None
    is_template: Annotated[bool | None, Field(example=True)] = False
    """
    Whether this repository acts as a template that can be used to generate new repositories.
    """
    topics: Sequence[str] | None = None
    has_issues: Annotated[bool | None, Field(example=True)] = True
    """
    Whether issues are enabled.
    """
    has_projects: Annotated[bool | None, Field(example=True)] = True
    """
    Whether projects are enabled.
    """
    has_wiki: Annotated[bool | None, Field(example=True)] = True
    """
    Whether the wiki is enabled.
    """
    has_pages: bool | None = None
    has_downloads: Annotated[bool | None, Field(example=True)] = True
    """
    Whether downloads are enabled.
    """
    archived: bool | None = False
    """
    Whether the repository is archived.
    """
    disabled: bool | None = None
    """
    Returns whether or not this repository disabled.
    """
    visibility: str | None = "public"
    """
    The repository visibility: public, private, or internal.
    """
    pushed_at: Annotated[datetime | None, Field(example="2011-01-26T19:06:43Z")] = None
    created_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2011-01-26T19:14:43Z")] = None
    allow_rebase_merge: Annotated[bool | None, Field(example=True)] = True
    """
    Whether to allow rebase merges for pull requests.
    """
    template_repository: NullableRepository | None = None
    temp_clone_token: str | None = None
    allow_squash_merge: Annotated[bool | None, Field(example=True)] = True
    """
    Whether to allow squash merges for pull requests.
    """
    allow_auto_merge: Annotated[bool | None, Field(example=False)] = False
    """
    Whether to allow Auto-merge to be used on pull requests.
    """
    delete_branch_on_merge: Annotated[bool | None, Field(example=False)] = False
    """
    Whether to delete head branches when pull requests are merged
    """
    allow_merge_commit: Annotated[bool | None, Field(example=True)] = True
    """
    Whether to allow merge commits for pull requests.
    """
    allow_forking: Annotated[bool | None, Field(example=False)] = False
    """
    Whether to allow forking this repo
    """
    web_commit_signoff_required: Annotated[bool | None, Field(example=False)] = False
    """
    Whether to require contributors to sign off on web-based commits
    """
    subscribers_count: int | None = None
    network_count: int | None = None
    open_issues: int | None = None
    watchers: int | None = None
    master_branch: str | None = None


class ProjectCard(BaseModel):
    """
    Project cards represent a scope of work.
    """

    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/projects/columns/cards/1478"),
    ] = None
    id: Annotated[int | None, Field(example=42)] = None
    """
    The project card's ID
    """
    node_id: Annotated[str | None, Field(example="MDExOlByb2plY3RDYXJkMTQ3OA==")] = None
    note: Annotated[
        str | None, Field(example="Add payload for delete Project column")
    ] = None
    creator: NullableSimpleUser | None = None
    created_at: Annotated[datetime | None, Field(example="2016-09-05T14:21:06Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2016-09-05T14:20:22Z")] = None
    archived: Annotated[bool | None, Field(example=False)] = None
    """
    Whether or not the card is archived
    """
    column_name: str | None = None
    project_id: str | None = None
    column_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/projects/columns/367")
    ] = None
    content_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/api-playground/projects-test/issues/3"
        ),
    ] = None
    project_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/projects/120")
    ] = None


class ProjectColumn(BaseModel):
    """
    Project columns contain cards of work.
    """

    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/projects/columns/367")
    ] = None
    project_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/projects/120")
    ] = None
    cards_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/projects/columns/367/cards"),
    ] = None
    id: Annotated[int | None, Field(example=42)] = None
    """
    The unique identifier of the project column
    """
    node_id: Annotated[str | None, Field(example="MDEzOlByb2plY3RDb2x1bW4zNjc=")] = None
    name: Annotated[str | None, Field(example="Remaining tasks")] = None
    """
    Name of the project column
    """
    created_at: Annotated[datetime | None, Field(example="2016-09-05T14:18:44Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2016-09-05T14:22:28Z")] = None


class ProjectCollaboratorPermission(BaseModel):
    """
    Project Collaborator Permission
    """

    permission: str | None = None
    user: NullableSimpleUser | None = None


class RateLimit(BaseModel):
    limit: int | None = None
    remaining: int | None = None
    reset: int | None = None
    used: int | None = None


class Resources(BaseModel):
    core: RateLimit | None = None
    graphql: RateLimit | None = None
    search: RateLimit | None = None
    source_import: RateLimit | None = None
    integration_manifest: RateLimit | None = None
    code_scanning_upload: RateLimit | None = None
    actions_runner_registration: RateLimit | None = None
    scim: RateLimit | None = None
    dependency_snapshots: RateLimit | None = None


class RateLimitOverview(BaseModel):
    """
    Rate Limit Overview
    """

    resources: Resources | None = None
    rate: RateLimit | None = None


class CodeOfConductSimple(BaseModel):
    """
    Code of Conduct Simple
    """

    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/github/docs/community/code_of_conduct"
        ),
    ] = None
    key: Annotated[str | None, Field(example="citizen_code_of_conduct")] = None
    name: Annotated[str | None, Field(example="Citizen Code of Conduct")] = None
    html_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/github/docs/blob/main/CODE_OF_CONDUCT.md"),
    ] = None


class Status(Enum):
    enabled = "enabled"
    disabled = "disabled"


class AdvancedSecurity(BaseModel):
    status: Status | None = None


class SecretScanning(BaseModel):
    status: Status | None = None


class SecretScanningPushProtection(BaseModel):
    status: Status | None = None


class SecurityAndAnalysis(BaseModel):
    advanced_security: AdvancedSecurity | None = None
    secret_scanning: SecretScanning | None = None
    secret_scanning_push_protection: SecretScanningPushProtection | None = None


class Permissions12(BaseModel):
    admin: bool | None = None
    maintain: bool | None = None
    push: bool | None = None
    triage: bool | None = None
    pull: bool | None = None


class MergeCommitTitle4(Enum):
    """
    The default value for a merge commit title.

      - `PR_TITLE` - default to the pull request's title.
      - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
    """

    PR_TITLE = "PR_TITLE"
    MERGE_MESSAGE = "MERGE_MESSAGE"


class FullRepository(BaseModel):
    """
    Full Repository
    """

    id: Annotated[int | None, Field(example=1296269)] = None
    node_id: Annotated[str | None, Field(example="MDEwOlJlcG9zaXRvcnkxMjk2MjY5")] = None
    name: Annotated[str | None, Field(example="Hello-World")] = None
    full_name: Annotated[str | None, Field(example="octocat/Hello-World")] = None
    owner: SimpleUser | None = None
    private: bool | None = None
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat/Hello-World")
    ] = None
    description: Annotated[str | None, Field(example="This your first repo!")] = None
    fork: bool | None = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/repos/octocat/Hello-World")
    ] = None
    archive_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}"
        ),
    ] = None
    assignees_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/assignees{/user}"
        ),
    ] = None
    blobs_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}"
        ),
    ] = None
    branches_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/branches{/branch}"
        ),
    ] = None
    collaborators_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}"
        ),
    ] = None
    comments_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/comments{/number}"
        ),
    ] = None
    commits_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/commits{/sha}"),
    ] = None
    compare_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}"
        ),
    ] = None
    contents_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/contents/{+path}"
        ),
    ] = None
    contributors_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/contributors"),
    ] = None
    deployments_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/deployments"),
    ] = None
    downloads_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/downloads"),
    ] = None
    events_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/events"),
    ] = None
    forks_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/forks"),
    ] = None
    git_commits_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/commits{/sha}"
        ),
    ] = None
    git_refs_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/git/refs{/sha}"),
    ] = None
    git_tags_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/git/tags{/sha}"),
    ] = None
    git_url: Annotated[
        str | None, Field(example="git:github.com/octocat/Hello-World.git")
    ] = None
    issue_comment_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues/comments{/number}"
        ),
    ] = None
    issue_events_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues/events{/number}"
        ),
    ] = None
    issues_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/issues{/number}"
        ),
    ] = None
    keys_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/keys{/key_id}"),
    ] = None
    labels_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/labels{/name}"),
    ] = None
    languages_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/languages"),
    ] = None
    merges_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/merges"),
    ] = None
    milestones_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/milestones{/number}"
        ),
    ] = None
    notifications_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}"
        ),
    ] = None
    pulls_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/pulls{/number}"),
    ] = None
    releases_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/releases{/id}"),
    ] = None
    ssh_url: Annotated[
        str | None, Field(example="git@github.com:octocat/Hello-World.git")
    ] = None
    stargazers_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/stargazers"),
    ] = None
    statuses_url: Annotated[
        str | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/statuses/{sha}"),
    ] = None
    subscribers_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/subscribers"),
    ] = None
    subscription_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/subscription"),
    ] = None
    tags_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/tags"),
    ] = None
    teams_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/teams"),
    ] = None
    trees_url: Annotated[
        str | None,
        Field(
            example="http://api.github.com/repos/octocat/Hello-World/git/trees{/sha}"
        ),
    ] = None
    clone_url: Annotated[
        str | None, Field(example="https://github.com/octocat/Hello-World.git")
    ] = None
    mirror_url: Annotated[
        AnyUrl | None, Field(example="git:git.example.com/octocat/Hello-World")
    ] = None
    hooks_url: Annotated[
        AnyUrl | None,
        Field(example="http://api.github.com/repos/octocat/Hello-World/hooks"),
    ] = None
    svn_url: Annotated[
        AnyUrl | None, Field(example="https://svn.github.com/octocat/Hello-World")
    ] = None
    homepage: Annotated[AnyUrl | None, Field(example="https://github.com")] = None
    language: str | None = None
    forks_count: Annotated[int | None, Field(example=9)] = None
    stargazers_count: Annotated[int | None, Field(example=80)] = None
    watchers_count: Annotated[int | None, Field(example=80)] = None
    size: Annotated[int | None, Field(example=108)] = None
    """
    The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.
    """
    default_branch: Annotated[str | None, Field(example="master")] = None
    open_issues_count: Annotated[int | None, Field(example=0)] = None
    is_template: Annotated[bool | None, Field(example=True)] = None
    topics: Annotated[
        Sequence[str] | None, Field(example=["octocat", "atom", "electron", "API"])
    ] = None
    has_issues: Annotated[bool | None, Field(example=True)] = None
    has_projects: Annotated[bool | None, Field(example=True)] = None
    has_wiki: Annotated[bool | None, Field(example=True)] = None
    has_pages: bool | None = None
    has_downloads: Annotated[bool | None, Field(example=True)] = None
    archived: bool | None = None
    disabled: bool | None = None
    """
    Returns whether or not this repository disabled.
    """
    visibility: Annotated[str | None, Field(example="public")] = None
    """
    The repository visibility: public, private, or internal.
    """
    pushed_at: Annotated[datetime | None, Field(example="2011-01-26T19:06:43Z")] = None
    created_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2011-01-26T19:14:43Z")] = None
    permissions: Permissions12 | None = None
    allow_rebase_merge: Annotated[bool | None, Field(example=True)] = None
    template_repository: NullableRepository | None = None
    temp_clone_token: str | None = None
    allow_squash_merge: Annotated[bool | None, Field(example=True)] = None
    allow_auto_merge: Annotated[bool | None, Field(example=False)] = None
    delete_branch_on_merge: Annotated[bool | None, Field(example=False)] = None
    allow_merge_commit: Annotated[bool | None, Field(example=True)] = None
    allow_update_branch: Annotated[bool | None, Field(example=True)] = None
    use_squash_pr_title_as_default: Annotated[bool | None, Field(example=False)] = None
    squash_merge_commit_title: Annotated[
        SquashMergeCommitTitle | None, Field(example="PR_TITLE")
    ] = None
    """
    The default value for a squash merge commit title:

    - `PR_TITLE` - default to the pull request's title.
    - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
    """
    squash_merge_commit_message: Annotated[
        SquashMergeCommitMessage | None, Field(example="PR_BODY")
    ] = None
    """
    The default value for a squash merge commit message:

    - `PR_BODY` - default to the pull request's body.
    - `COMMIT_MESSAGES` - default to the branch's commit messages.
    - `BLANK` - default to a blank commit message.
    """
    merge_commit_title: Annotated[
        MergeCommitTitle4 | None, Field(example="PR_TITLE")
    ] = None
    """
    The default value for a merge commit title.

      - `PR_TITLE` - default to the pull request's title.
      - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
    """
    merge_commit_message: Annotated[
        MergeCommitMessage | None, Field(example="PR_BODY")
    ] = None
    """
    The default value for a merge commit message.

    - `PR_TITLE` - default to the pull request's title.
    - `PR_BODY` - default to the pull request's body.
    - `BLANK` - default to a blank commit message.
    """
    allow_forking: Annotated[bool | None, Field(example=True)] = None
    web_commit_signoff_required: Annotated[bool | None, Field(example=False)] = None
    subscribers_count: Annotated[int | None, Field(example=42)] = None
    network_count: Annotated[int | None, Field(example=0)] = None
    license: NullableLicenseSimple | None = None
    organization: NullableSimpleUser | None = None
    parent: Repository | None = None
    source: Repository | None = None
    forks: int | None = None
    master_branch: str | None = None
    open_issues: int | None = None
    watchers: int | None = None
    anonymous_access_enabled: bool | None = True
    """
    Whether anonymous git access is allowed.
    """
    code_of_conduct: CodeOfConductSimple | None = None
    security_and_analysis: SecurityAndAnalysis | None = None


class WorkflowRun(BaseModel):
    id: Annotated[int | None, Field(example=10)] = None
    repository_id: Annotated[int | None, Field(example=42)] = None
    head_repository_id: Annotated[int | None, Field(example=42)] = None
    head_branch: Annotated[str | None, Field(example="main")] = None
    head_sha: Annotated[
        str | None, Field(example="009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d")
    ] = None


class Artifact(BaseModel):
    """
    An artifact
    """

    id: Annotated[int | None, Field(example=5)] = None
    node_id: Annotated[str | None, Field(example="MDEwOkNoZWNrU3VpdGU1")] = None
    name: Annotated[str | None, Field(example="AdventureWorks.Framework")] = None
    """
    The name of the artifact.
    """
    size_in_bytes: Annotated[int | None, Field(example=12345)] = None
    """
    The size in bytes of the artifact.
    """
    url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/actions/artifacts/5"
        ),
    ] = None
    archive_download_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/actions/artifacts/5/zip"
        ),
    ] = None
    expired: bool | None = None
    """
    Whether or not the artifact has expired.
    """
    created_at: datetime | None = None
    expires_at: datetime | None = None
    updated_at: datetime | None = None
    workflow_run: WorkflowRun | None = None


class ActionsCach(BaseModel):
    id: Annotated[int | None, Field(example=2)] = None
    ref: Annotated[str | None, Field(example="refs/heads/main")] = None
    key: Annotated[
        str | None, Field(example="Linux-node-958aff96db2d75d67787d1e634ae70b659de937b")
    ] = None
    version: Annotated[
        str | None,
        Field(
            example="73885106f58cc52a7df9ec4d4a5622a5614813162cb516c759a30af6bf56e6f0"
        ),
    ] = None
    last_accessed_at: Annotated[
        datetime | None, Field(example="2019-01-24T22:45:36.000Z")
    ] = None
    created_at: Annotated[
        datetime | None, Field(example="2019-01-24T22:45:36.000Z")
    ] = None
    size_in_bytes: Annotated[int | None, Field(example=1024)] = None


class ActionsCacheList(BaseModel):
    """
    Repository actions caches
    """

    total_count: Annotated[int | None, Field(example=2)] = None
    """
    Total number of caches
    """
    actions_caches: Sequence[ActionsCach] | None = None
    """
    Array of caches
    """


class Status3(Enum):
    """
    The phase of the lifecycle that the job is currently in.
    """

    queued = "queued"
    in_progress = "in_progress"
    completed = "completed"


class Conclusion(Enum):
    """
    The outcome of the job.
    """

    success = "success"
    failure = "failure"
    neutral = "neutral"
    cancelled = "cancelled"
    skipped = "skipped"
    timed_out = "timed_out"
    action_required = "action_required"


class Step(BaseModel):
    status: Annotated[Status3 | None, Field(example="queued")] = None
    """
    The phase of the lifecycle that the job is currently in.
    """
    conclusion: Annotated[str | None, Field(example="success")] = None
    """
    The outcome of the job.
    """
    name: Annotated[str | None, Field(example="test-coverage")] = None
    """
    The name of the job.
    """
    number: Annotated[int | None, Field(example=1)] = None
    started_at: Annotated[
        datetime | None, Field(example="2019-08-08T08:00:00-07:00")
    ] = None
    """
    The time that the step started, in ISO 8601 format.
    """
    completed_at: Annotated[
        datetime | None, Field(example="2019-08-08T08:00:00-07:00")
    ] = None
    """
    The time that the job finished, in ISO 8601 format.
    """


class Job(BaseModel):
    """
    Information of a job execution in a workflow run
    """

    id: Annotated[int | None, Field(example=21)] = None
    """
    The id of the job.
    """
    run_id: Annotated[int | None, Field(example=5)] = None
    """
    The id of the associated workflow run.
    """
    run_url: Annotated[
        str | None,
        Field(example="https://api.github.com/repos/github/hello-world/actions/runs/5"),
    ] = None
    run_attempt: Annotated[int | None, Field(example=1)] = None
    """
    Attempt number of the associated workflow run, 1 for first attempt and higher if the workflow was re-run.
    """
    node_id: Annotated[str | None, Field(example="MDg6Q2hlY2tSdW40")] = None
    head_sha: Annotated[
        str | None, Field(example="009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d")
    ] = None
    """
    The SHA of the commit that is being run.
    """
    url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/actions/jobs/21"
        ),
    ] = None
    html_url: Annotated[
        str | None, Field(example="https://github.com/github/hello-world/runs/4")
    ] = None
    status: Annotated[Status3 | None, Field(example="queued")] = None
    """
    The phase of the lifecycle that the job is currently in.
    """
    conclusion: Annotated[Conclusion | None, Field(example="success")] = None
    """
    The outcome of the job.
    """
    started_at: Annotated[
        datetime | None, Field(example="2019-08-08T08:00:00-07:00")
    ] = None
    """
    The time that the job started, in ISO 8601 format.
    """
    completed_at: Annotated[
        datetime | None, Field(example="2019-08-08T08:00:00-07:00")
    ] = None
    """
    The time that the job finished, in ISO 8601 format.
    """
    name: Annotated[str | None, Field(example="test-coverage")] = None
    """
    The name of the job.
    """
    steps: Sequence[Step] | None = None
    """
    Steps in this job.
    """
    check_run_url: Annotated[
        str | None,
        Field(example="https://api.github.com/repos/github/hello-world/check-runs/4"),
    ] = None
    labels: Annotated[
        Sequence[str] | None, Field(example=["self-hosted", "foo", "bar"])
    ] = None
    """
    Labels for the workflow job. Specified by the "runs_on" attribute in the action's workflow file.
    """
    runner_id: Annotated[int | None, Field(example=1)] = None
    """
    The ID of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
    """
    runner_name: Annotated[str | None, Field(example="my runner")] = None
    """
    The name of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
    """
    runner_group_id: Annotated[int | None, Field(example=2)] = None
    """
    The ID of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
    """
    runner_group_name: Annotated[str | None, Field(example="my runner group")] = None
    """
    The name of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
    """


class ActionsRepositoryPermissions(BaseModel):
    enabled: bool | None = None
    """
    Whether GitHub Actions is enabled on the repository.
    """
    allowed_actions: AllowedActions | None = None
    selected_actions_url: str | None = None
    """
    The API URL to use to get or set the actions and reusable workflows that are allowed to run, when `allowed_actions` is set to `selected`.
    """


class AccessLevel(Enum):
    """
    Defines the level of access that workflows outside of the repository have to actions and reusable workflows within the
    repository. `none` means access is only possible from workflows in this repository.
    """

    none = "none"
    organization = "organization"
    enterprise = "enterprise"


class ActionsWorkflowAccessToRepository(BaseModel):
    access_level: AccessLevel | None = None
    """
    Defines the level of access that workflows outside of the repository have to actions and reusable workflows within the
    repository. `none` means access is only possible from workflows in this repository.
    """


class ReferencedWorkflow(BaseModel):
    """
    A workflow referenced/reused by the initial caller workflow
    """

    path: str | None = None
    sha: str | None = None
    ref: str | None = None


class Repo1(BaseModel):
    id: int | None = None
    url: str | None = None
    name: str | None = None


class Head(BaseModel):
    ref: str | None = None
    sha: str | None = None
    repo: Repo1 | None = None


class Base(BaseModel):
    ref: str | None = None
    sha: str | None = None
    repo: Repo1 | None = None


class PullRequestMinimal(BaseModel):
    id: int | None = None
    number: int | None = None
    url: str | None = None
    head: Head | None = None
    base: Base | None = None


class Author(BaseModel):
    name: str | None = None
    email: str | None = None


class Committer(BaseModel):
    name: str | None = None
    email: str | None = None


class NullableSimpleCommit(BaseModel):
    """
    Simple Commit
    """

    id: str | None = None
    tree_id: str | None = None
    message: str | None = None
    timestamp: datetime | None = None
    author: Author | None = None
    committer: Committer | None = None


class WorkflowRun1(BaseModel):
    """
    An invocation of a workflow
    """

    id: Annotated[int | None, Field(example=5)] = None
    """
    The ID of the workflow run.
    """
    name: Annotated[str | None, Field(example="Build")] = None
    """
    The name of the workflow run.
    """
    node_id: Annotated[str | None, Field(example="MDEwOkNoZWNrU3VpdGU1")] = None
    check_suite_id: Annotated[int | None, Field(example=42)] = None
    """
    The ID of the associated check suite.
    """
    check_suite_node_id: Annotated[
        str | None, Field(example="MDEwOkNoZWNrU3VpdGU0Mg==")
    ] = None
    """
    The node ID of the associated check suite.
    """
    head_branch: Annotated[str | None, Field(example="master")] = None
    head_sha: Annotated[
        str | None, Field(example="009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d")
    ] = None
    """
    The SHA of the head commit that points to the version of the workflow being run.
    """
    path: Annotated[
        str | None, Field(example="octocat/octo-repo/.github/workflows/ci.yml@main")
    ] = None
    """
    The full path of the workflow
    """
    run_number: Annotated[int | None, Field(example=106)] = None
    """
    The auto incrementing run number for the workflow run.
    """
    run_attempt: Annotated[int | None, Field(example=1)] = None
    """
    Attempt number of the run, 1 for first attempt and higher if the workflow was re-run.
    """
    referenced_workflows: Sequence[ReferencedWorkflow] | None = None
    event: Annotated[str | None, Field(example="push")] = None
    status: Annotated[str | None, Field(example="completed")] = None
    conclusion: Annotated[str | None, Field(example="neutral")] = None
    workflow_id: Annotated[int | None, Field(example=5)] = None
    """
    The ID of the parent workflow.
    """
    url: Annotated[
        str | None,
        Field(example="https://api.github.com/repos/github/hello-world/actions/runs/5"),
    ] = None
    """
    The URL to the workflow run.
    """
    html_url: Annotated[
        str | None, Field(example="https://github.com/github/hello-world/suites/4")
    ] = None
    pull_requests: Sequence[PullRequestMinimal] | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    actor: SimpleUser | None = None
    triggering_actor: SimpleUser | None = None
    run_started_at: datetime | None = None
    """
    The start time of the latest run. Resets on re-run.
    """
    jobs_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/actions/runs/5/jobs"
        ),
    ] = None
    """
    The URL to the jobs for the workflow run.
    """
    logs_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/actions/runs/5/logs"
        ),
    ] = None
    """
    The URL to download the logs for the workflow run.
    """
    check_suite_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/check-suites/12"
        ),
    ] = None
    """
    The URL to the associated check suite.
    """
    artifacts_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/actions/runs/5/rerun/artifacts"
        ),
    ] = None
    """
    The URL to the artifacts for the workflow run.
    """
    cancel_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/actions/runs/5/cancel"
        ),
    ] = None
    """
    The URL to cancel the workflow run.
    """
    rerun_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/actions/runs/5/rerun"
        ),
    ] = None
    """
    The URL to rerun the workflow run.
    """
    previous_attempt_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/actions/runs/5/attempts/3"
        ),
    ] = None
    """
    The URL to the previous attempted run of this workflow, if one exists.
    """
    workflow_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/actions/workflows/main.yaml"
        ),
    ] = None
    """
    The URL to the workflow.
    """
    head_commit: NullableSimpleCommit | None = None
    repository: MinimalRepository | None = None
    head_repository: MinimalRepository | None = None
    head_repository_id: Annotated[int | None, Field(example=5)] = None
    display_title: Annotated[str | None, Field(example="Simple Workflow")] = None
    """
    The event-specific title associated with the run or the run-name if set, or the value of `run-name` if it is set in the workflow.
    """


class Environment(BaseModel):
    id: Annotated[int | None, Field(example=56780428)] = None
    """
    The id of the environment.
    """
    node_id: Annotated[
        str | None, Field(example="MDExOkVudmlyb25tZW50NTY3ODA0Mjg=")
    ] = None
    name: Annotated[str | None, Field(example="staging")] = None
    """
    The name of the environment.
    """
    url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/environments/staging"
        ),
    ] = None
    html_url: Annotated[
        str | None,
        Field(
            example="https://github.com/github/hello-world/deployments/activity_log?environments_filter=staging"
        ),
    ] = None
    created_at: Annotated[datetime | None, Field(example="2020-11-23T22:00:40Z")] = None
    """
    The time that the environment was created, in ISO 8601 format.
    """
    updated_at: Annotated[datetime | None, Field(example="2020-11-23T22:00:40Z")] = None
    """
    The time that the environment was last updated, in ISO 8601 format.
    """


class State5(Enum):
    """
    Whether deployment to the environment(s) was approved or rejected
    """

    approved = "approved"
    rejected = "rejected"


class EnvironmentApprovals(BaseModel):
    """
    An entry in the reviews log for environment deployments
    """

    environments: Sequence[Environment] | None = None
    """
    The list of environments that were approved or rejected
    """
    state: Annotated[State5 | None, Field(example="approved")] = None
    """
    Whether deployment to the environment(s) was approved or rejected
    """
    user: SimpleUser | None = None
    comment: Annotated[str | None, Field(example="Ship it!")] = None
    """
    The comment submitted with the deployment review
    """


class DeploymentReviewerType(Enum):
    """
    The type of reviewer.
    """

    User = "User"
    Team = "Team"


class Environment1(BaseModel):
    id: Annotated[int | None, Field(example=56780428)] = None
    """
    The id of the environment.
    """
    node_id: Annotated[
        str | None, Field(example="MDExOkVudmlyb25tZW50NTY3ODA0Mjg=")
    ] = None
    name: Annotated[str | None, Field(example="staging")] = None
    """
    The name of the environment.
    """
    url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/environments/staging"
        ),
    ] = None
    html_url: Annotated[
        str | None,
        Field(
            example="https://github.com/github/hello-world/deployments/activity_log?environments_filter=staging"
        ),
    ] = None


class Reviewer(BaseModel):
    type: DeploymentReviewerType | None = None
    reviewer: SimpleUser | Team | None = None


class PendingDeployment(BaseModel):
    """
    Details of a deployment that is waiting for protection rules to pass
    """

    environment: Environment1 | None = None
    wait_timer: Annotated[int | None, Field(example=30)] = None
    """
    The set duration of the wait timer
    """
    wait_timer_started_at: Annotated[
        datetime | None, Field(example="2020-11-23T22:00:40Z")
    ] = None
    """
    The time that the wait timer began.
    """
    current_user_can_approve: Annotated[bool | None, Field(example=True)] = None
    """
    Whether the currently authenticated user can approve the deployment
    """
    reviewers: Sequence[Reviewer] | None = None
    """
    The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.
    """


class Deployment(BaseModel):
    """
    A request for a specific ref(branch,sha,tag) to be deployed
    """

    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/example/deployments/1"),
    ] = None
    id: Annotated[int | None, Field(example=42)] = None
    """
    Unique identifier of the deployment
    """
    node_id: Annotated[str | None, Field(example="MDEwOkRlcGxveW1lbnQx")] = None
    sha: Annotated[
        str | None, Field(example="a84d88e7554fc1fa21bcbc4efae3c782a70d2b9d")
    ] = None
    ref: Annotated[str | None, Field(example="topic-branch")] = None
    """
    The ref to deploy. This can be a branch, tag, or sha.
    """
    task: Annotated[str | None, Field(example="deploy")] = None
    """
    Parameter to specify a task to execute
    """
    payload: Mapping[str, Any] | str | None = None
    original_environment: Annotated[str | None, Field(example="staging")] = None
    environment: Annotated[str | None, Field(example="production")] = None
    """
    Name for the target deployment environment.
    """
    description: Annotated[
        str | None, Field(example="Deploy request from hubot")
    ] = None
    creator: NullableSimpleUser | None = None
    created_at: Annotated[datetime | None, Field(example="2012-07-20T01:19:13Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2012-07-20T01:19:13Z")] = None
    statuses_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/example/deployments/1/statuses"
        ),
    ] = None
    repository_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/repos/octocat/example")
    ] = None
    transient_environment: Annotated[bool | None, Field(example=True)] = None
    """
    Specifies if the given environment is will no longer exist at some point in the future. Default: false.
    """
    production_environment: Annotated[bool | None, Field(example=True)] = None
    """
    Specifies if the given environment is one that end-users directly interact with. Default: false.
    """
    performed_via_github_app: NullableIntegration | None = None


class JobRun(BaseModel):
    job_id: int | None = None
    duration_ms: int | None = None


class UBUNTU(BaseModel):
    total_ms: int | None = None
    jobs: int | None = None
    job_runs: Sequence[JobRun] | None = None


class MACOS(BaseModel):
    total_ms: int | None = None
    jobs: int | None = None
    job_runs: Sequence[JobRun] | None = None


class WINDOWS(BaseModel):
    total_ms: int | None = None
    jobs: int | None = None
    job_runs: Sequence[JobRun] | None = None


class Billable(BaseModel):
    UBUNTU: UBUNTU | None = None
    MACOS: MACOS | None = None
    WINDOWS: WINDOWS | None = None


class WorkflowRunUsage(BaseModel):
    """
    Workflow Run Usage
    """

    billable: Billable | None = None
    run_duration_ms: int | None = None


class ActionsSecret(BaseModel):
    """
    Set secrets for GitHub Actions.
    """

    name: Annotated[str | None, Field(example="SECRET_TOKEN")] = None
    """
    The name of the secret.
    """
    created_at: datetime | None = None
    updated_at: datetime | None = None


class State6(Enum):
    active = "active"
    deleted = "deleted"
    disabled_fork = "disabled_fork"
    disabled_inactivity = "disabled_inactivity"
    disabled_manually = "disabled_manually"


class Workflow(BaseModel):
    """
    A GitHub Actions workflow
    """

    id: Annotated[int | None, Field(example=5)] = None
    node_id: Annotated[str | None, Field(example="MDg6V29ya2Zsb3cxMg==")] = None
    name: Annotated[str | None, Field(example="CI")] = None
    path: Annotated[str | None, Field(example="ruby.yaml")] = None
    state: Annotated[State6 | None, Field(example="active")] = None
    created_at: Annotated[
        datetime | None, Field(example="2019-12-06T14:20:20.000Z")
    ] = None
    updated_at: Annotated[
        datetime | None, Field(example="2019-12-06T14:20:20.000Z")
    ] = None
    url: Annotated[
        str | None,
        Field(example="https://api.github.com/repos/actions/setup-ruby/workflows/5"),
    ] = None
    html_url: Annotated[
        str | None,
        Field(
            example="https://github.com/actions/setup-ruby/blob/master/.github/workflows/ruby.yaml"
        ),
    ] = None
    badge_url: Annotated[
        str | None,
        Field(example="https://github.com/actions/setup-ruby/workflows/CI/badge.svg"),
    ] = None
    deleted_at: Annotated[
        datetime | None, Field(example="2019-12-06T14:20:20.000Z")
    ] = None


class UBUNTU1(BaseModel):
    total_ms: int | None = None


class MACOS1(BaseModel):
    total_ms: int | None = None


class WINDOWS1(BaseModel):
    total_ms: int | None = None


class Billable1(BaseModel):
    UBUNTU: UBUNTU1 | None = None
    MACOS: MACOS1 | None = None
    WINDOWS: WINDOWS1 | None = None


class WorkflowUsage(BaseModel):
    """
    Workflow Usage
    """

    billable: Billable1 | None = None


class Autolink(BaseModel):
    """
    An autolink reference.
    """

    id: Annotated[int | None, Field(example=3)] = None
    key_prefix: Annotated[str | None, Field(example="TICKET-")] = None
    """
    The prefix of a key that is linkified.
    """
    url_template: Annotated[
        str | None, Field(example="https://example.com/TICKET?query=<num>")
    ] = None
    """
    A template for the target URL that is generated if a key was found.
    """
    is_alphanumeric: Annotated[bool | None, Field(example=True)] = None
    """
    Whether this autolink reference matches alphanumeric characters. If false, this autolink reference only matches numeric characters.
    """


class Check(BaseModel):
    context: str | None = None
    app_id: int | None = None


class ProtectedBranchRequiredStatusCheck(BaseModel):
    """
    Protected Branch Required Status Check
    """

    url: str | None = None
    enforcement_level: str | None = None
    contexts: Sequence[str] | None = None
    checks: Sequence[Check] | None = None
    contexts_url: str | None = None
    strict: bool | None = None


class ProtectedBranchAdminEnforced(BaseModel):
    """
    Protected Branch Admin Enforced
    """

    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/branches/master/protection/enforce_admins"
        ),
    ] = None
    enabled: Annotated[bool | None, Field(example=True)] = None


class DismissalRestrictions(BaseModel):
    users: Sequence[SimpleUser] | None = None
    """
    The list of users with review dismissal access.
    """
    teams: Sequence[Team] | None = None
    """
    The list of teams with review dismissal access.
    """
    apps: Sequence[Integration] | None = None
    """
    The list of apps with review dismissal access.
    """
    url: Annotated[
        str | None,
        Field(
            example='"https://api.github.com/repos/the-org/an-org-repo/branches/master/protection/dismissal_restrictions"'
        ),
    ] = None
    users_url: Annotated[
        str | None,
        Field(
            example='"https://api.github.com/repos/the-org/an-org-repo/branches/master/protection/dismissal_restrictions/users"'
        ),
    ] = None
    teams_url: Annotated[
        str | None,
        Field(
            example='"https://api.github.com/repos/the-org/an-org-repo/branches/master/protection/dismissal_restrictions/teams"'
        ),
    ] = None


class BypassPullRequestAllowances(BaseModel):
    """
    Allow specific users, teams, or apps to bypass pull request requirements.
    """

    users: Sequence[SimpleUser] | None = None
    """
    The list of users allowed to bypass pull request requirements.
    """
    teams: Sequence[Team] | None = None
    """
    The list of teams allowed to bypass pull request requirements.
    """
    apps: Sequence[Integration] | None = None
    """
    The list of apps allowed to bypass pull request requirements.
    """


class ProtectedBranchPullRequestReview(BaseModel):
    """
    Protected Branch Pull Request Review
    """

    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/branches/master/protection/dismissal_restrictions"
        ),
    ] = None
    dismissal_restrictions: DismissalRestrictions | None = None
    bypass_pull_request_allowances: BypassPullRequestAllowances | None = None
    """
    Allow specific users, teams, or apps to bypass pull request requirements.
    """
    dismiss_stale_reviews: Annotated[bool | None, Field(example=True)] = None
    require_code_owner_reviews: Annotated[bool | None, Field(example=True)] = None
    required_approving_review_count: Annotated[
        int | None, Field(example=2, ge=0, le=6)
    ] = None
    require_last_push_approval: Annotated[bool | None, Field(example=True)] = False
    """
    Whether someone other than the person who last pushed to the branch must approve this pull request.
    """


class User(BaseModel):
    login: str | None = None
    id: int | None = None
    node_id: str | None = None
    avatar_url: str | None = None
    gravatar_id: str | None = None
    url: str | None = None
    html_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    organizations_url: str | None = None
    repos_url: str | None = None
    events_url: str | None = None
    received_events_url: str | None = None
    type: str | None = None
    site_admin: bool | None = None


class Team1(BaseModel):
    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    html_url: str | None = None
    name: str | None = None
    slug: str | None = None
    description: str | None = None
    privacy: str | None = None
    permission: str | None = None
    members_url: str | None = None
    repositories_url: str | None = None
    parent: str | None = None


class Owner2(BaseModel):
    login: str | None = None
    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    repos_url: str | None = None
    events_url: str | None = None
    hooks_url: str | None = None
    issues_url: str | None = None
    members_url: str | None = None
    public_members_url: str | None = None
    avatar_url: str | None = None
    description: str | None = None
    gravatar_id: Annotated[str | None, Field(example='""')] = None
    html_url: Annotated[
        str | None, Field(example='"https://github.com/testorg-ea8ec76d71c3af4b"')
    ] = None
    followers_url: Annotated[
        str | None,
        Field(
            example='"https://api.github.com/users/testorg-ea8ec76d71c3af4b/followers"'
        ),
    ] = None
    following_url: Annotated[
        str | None,
        Field(
            example='"https://api.github.com/users/testorg-ea8ec76d71c3af4b/following{/other_user}"'
        ),
    ] = None
    gists_url: Annotated[
        str | None,
        Field(
            example='"https://api.github.com/users/testorg-ea8ec76d71c3af4b/gists{/gist_id}"'
        ),
    ] = None
    starred_url: Annotated[
        str | None,
        Field(
            example='"https://api.github.com/users/testorg-ea8ec76d71c3af4b/starred{/owner}{/repo}"'
        ),
    ] = None
    subscriptions_url: Annotated[
        str | None,
        Field(
            example='"https://api.github.com/users/testorg-ea8ec76d71c3af4b/subscriptions"'
        ),
    ] = None
    organizations_url: Annotated[
        str | None,
        Field(example='"https://api.github.com/users/testorg-ea8ec76d71c3af4b/orgs"'),
    ] = None
    received_events_url: Annotated[
        str | None,
        Field(
            example='"https://api.github.com/users/testorg-ea8ec76d71c3af4b/received_events"'
        ),
    ] = None
    type: Annotated[str | None, Field(example='"Organization"')] = None
    site_admin: Annotated[bool | None, Field(example=False)] = None


class Permissions13(BaseModel):
    metadata: str | None = None
    contents: str | None = None
    issues: str | None = None
    single_file: str | None = None


class App1(BaseModel):
    id: int | None = None
    slug: str | None = None
    node_id: str | None = None
    owner: Owner2 | None = None
    name: str | None = None
    description: str | None = None
    external_url: str | None = None
    html_url: str | None = None
    created_at: str | None = None
    updated_at: str | None = None
    permissions: Permissions13 | None = None
    events: Sequence[str] | None = None


class BranchRestrictionPolicy(BaseModel):
    """
    Branch Restriction Policy
    """

    url: AnyUrl | None = None
    users_url: AnyUrl | None = None
    teams_url: AnyUrl | None = None
    apps_url: AnyUrl | None = None
    users: Sequence[User] | None = None
    teams: Sequence[Team1] | None = None
    apps: Sequence[App1] | None = None


class RequiredLinearHistory(BaseModel):
    enabled: bool | None = None


class AllowForcePushes(BaseModel):
    enabled: bool | None = None


class AllowDeletions(BaseModel):
    enabled: bool | None = None


class BlockCreations(BaseModel):
    enabled: bool | None = None


class RequiredConversationResolution(BaseModel):
    enabled: bool | None = None


class RequiredSignatures(BaseModel):
    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/branches/master/protection/required_signatures"
        ),
    ] = None
    enabled: Annotated[bool | None, Field(example=True)] = None


class LockBranch(BaseModel):
    """
    Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.
    """

    enabled: bool | None = False


class AllowForkSyncing(BaseModel):
    """
    Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.
    """

    enabled: bool | None = False


class BranchProtection(BaseModel):
    """
    Branch Protection
    """

    url: str | None = None
    enabled: bool | None = None
    required_status_checks: ProtectedBranchRequiredStatusCheck | None = None
    enforce_admins: ProtectedBranchAdminEnforced | None = None
    required_pull_request_reviews: ProtectedBranchPullRequestReview | None = None
    restrictions: BranchRestrictionPolicy | None = None
    required_linear_history: RequiredLinearHistory | None = None
    allow_force_pushes: AllowForcePushes | None = None
    allow_deletions: AllowDeletions | None = None
    block_creations: BlockCreations | None = None
    required_conversation_resolution: RequiredConversationResolution | None = None
    name: Annotated[str | None, Field(example='"branch/with/protection"')] = None
    protection_url: Annotated[
        str | None,
        Field(
            example='"https://api.github.com/repos/owner-79e94e2d36b3fd06a32bb213/AAA_Public_Repo/branches/branch/with/protection/protection"'
        ),
    ] = None
    required_signatures: RequiredSignatures | None = None
    lock_branch: LockBranch | None = None
    """
    Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.
    """
    allow_fork_syncing: AllowForkSyncing | None = None
    """
    Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.
    """


class Commit(BaseModel):
    sha: str | None = None
    url: AnyUrl | None = None


class ShortBranch(BaseModel):
    """
    Short Branch
    """

    name: str | None = None
    commit: Commit | None = None
    protected: bool | None = None
    protection: BranchProtection | None = None
    protection_url: AnyUrl | None = None


class NullableGitUser(BaseModel):
    """
    Metaproperties for Git author/committer information.
    """

    name: Annotated[str | None, Field(example='"Chris Wanstrath"')] = None
    email: Annotated[str | None, Field(example='"chris@ozmm.org"')] = None
    date: Annotated[str | None, Field(example='"2007-10-29T02:42:39.000-07:00"')] = None


class Verification(BaseModel):
    verified: bool | None = None
    reason: str | None = None
    payload: str | None = None
    signature: str | None = None


class Status5(Enum):
    added = "added"
    removed = "removed"
    modified = "modified"
    renamed = "renamed"
    copied = "copied"
    changed = "changed"
    unchanged = "unchanged"


class DiffEntry(BaseModel):
    """
    Diff Entry
    """

    sha: Annotated[
        str | None, Field(example="bbcd538c8e72b8c175046e27cc8f907076331401")
    ] = None
    filename: Annotated[str | None, Field(example="file1.txt")] = None
    status: Annotated[Status5 | None, Field(example="added")] = None
    additions: Annotated[int | None, Field(example=103)] = None
    deletions: Annotated[int | None, Field(example=21)] = None
    changes: Annotated[int | None, Field(example=124)] = None
    blob_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://github.com/octocat/Hello-World/blob/6dcb09b5b57875f334f61aebed695e2e4193db5e/file1.txt"
        ),
    ] = None
    raw_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://github.com/octocat/Hello-World/raw/6dcb09b5b57875f334f61aebed695e2e4193db5e/file1.txt"
        ),
    ] = None
    contents_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/contents/file1.txt?ref=6dcb09b5b57875f334f61aebed695e2e4193db5e"
        ),
    ] = None
    patch: Annotated[
        str | None,
        Field(
            example="@@ -132,7 +132,7 @@ module Test @@ -1000,7 +1000,7 @@ module Test"
        ),
    ] = None
    previous_filename: Annotated[str | None, Field(example="file.txt")] = None


class Tree(BaseModel):
    sha: Annotated[
        str | None, Field(example="827efc6d56897b048c772eb4087f854f46256132")
    ] = None
    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/tree/827efc6d56897b048c772eb4087f854f46256132"
        ),
    ] = None


class Commit2(BaseModel):
    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e"
        ),
    ] = None
    author: NullableGitUser | None = None
    committer: NullableGitUser | None = None
    message: Annotated[str | None, Field(example="Fix all the bugs")] = None
    comment_count: Annotated[int | None, Field(example=0)] = None
    tree: Tree | None = None
    verification: Verification | None = None


class Parent(BaseModel):
    sha: Annotated[
        str | None, Field(example="7638417db6d59f3c431d3e1f261cc637155684cd")
    ] = None
    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/commits/7638417db6d59f3c431d3e1f261cc637155684cd"
        ),
    ] = None
    html_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://github.com/octocat/Hello-World/commit/7638417db6d59f3c431d3e1f261cc637155684cd"
        ),
    ] = None


class Stats(BaseModel):
    additions: int | None = None
    deletions: int | None = None
    total: int | None = None


class Commit1(BaseModel):
    """
    Commit
    """

    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e"
        ),
    ] = None
    sha: Annotated[
        str | None, Field(example="6dcb09b5b57875f334f61aebed695e2e4193db5e")
    ] = None
    node_id: Annotated[
        str | None,
        Field(
            example="MDY6Q29tbWl0NmRjYjA5YjViNTc4NzVmMzM0ZjYxYWViZWQ2OTVlMmU0MTkzZGI1ZQ=="
        ),
    ] = None
    html_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://github.com/octocat/Hello-World/commit/6dcb09b5b57875f334f61aebed695e2e4193db5e"
        ),
    ] = None
    comments_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e/comments"
        ),
    ] = None
    commit: Commit2 | None = None
    author: NullableSimpleUser | None = None
    committer: NullableSimpleUser | None = None
    parents: Sequence[Parent] | None = None
    stats: Stats | None = None
    files: Sequence[DiffEntry] | None = None


class FieldLinks1(BaseModel):
    html: str | None = None
    self: AnyUrl | None = None


class BranchWithProtection(BaseModel):
    """
    Branch With Protection
    """

    name: str | None = None
    commit: Commit1 | None = None
    field_links: Annotated[FieldLinks1 | None, Field(alias="_links")] = None
    protected: bool | None = None
    protection: BranchProtection | None = None
    protection_url: AnyUrl | None = None
    pattern: Annotated[str | None, Field(example='"mas*"')] = None
    required_approving_review_count: Annotated[int | None, Field(example=1)] = None


class Check1(BaseModel):
    context: Annotated[
        str | None, Field(example="continuous-integration/travis-ci")
    ] = None
    app_id: int | None = None


class StatusCheckPolicy(BaseModel):
    """
    Status Check Policy
    """

    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/branches/master/protection/required_status_checks"
        ),
    ] = None
    strict: Annotated[bool | None, Field(example=True)] = None
    contexts: Annotated[
        Sequence[str] | None, Field(example=["continuous-integration/travis-ci"])
    ] = None
    checks: Sequence[Check1] | None = None
    contexts_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/branches/master/protection/required_status_checks/contexts"
        ),
    ] = None


class DismissalRestrictions1(BaseModel):
    url: AnyUrl | None = None
    users_url: AnyUrl | None = None
    teams_url: AnyUrl | None = None
    users: Sequence[SimpleUser] | None = None
    teams: Sequence[Team] | None = None
    apps: Sequence[Integration] | None = None


class BypassPullRequestAllowances1(BaseModel):
    users: Sequence[SimpleUser] | None = None
    teams: Sequence[Team] | None = None
    apps: Sequence[Integration] | None = None


class RequiredPullRequestReviews(BaseModel):
    url: AnyUrl | None = None
    dismiss_stale_reviews: bool | None = None
    require_code_owner_reviews: bool | None = None
    required_approving_review_count: int | None = None
    require_last_push_approval: bool | None = False
    """
    Whether someone other than the person who last pushed to the branch must approve this pull request.
    """
    dismissal_restrictions: DismissalRestrictions1 | None = None
    bypass_pull_request_allowances: BypassPullRequestAllowances1 | None = None


class EnforceAdmins(BaseModel):
    class Config:
        extra = Extra.forbid

    url: AnyUrl | None = None
    enabled: bool | None = None


class RequiredLinearHistory1(BaseModel):
    class Config:
        extra = Extra.forbid

    enabled: bool | None = None


class AllowForcePushes1(BaseModel):
    class Config:
        extra = Extra.forbid

    enabled: bool | None = None


class AllowDeletions1(BaseModel):
    class Config:
        extra = Extra.forbid

    enabled: bool | None = None


class RequiredConversationResolution1(BaseModel):
    class Config:
        extra = Extra.forbid

    enabled: bool | None = None


class BlockCreations1(BaseModel):
    class Config:
        extra = Extra.forbid

    enabled: bool | None = None


class LockBranch1(BaseModel):
    """
    Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.
    """

    class Config:
        extra = Extra.forbid

    enabled: bool | None = False


class AllowForkSyncing1(BaseModel):
    """
    Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.
    """

    class Config:
        extra = Extra.forbid

    enabled: bool | None = False


class ProtectedBranch(BaseModel):
    """
    Branch protections protect branches
    """

    url: AnyUrl | None = None
    required_status_checks: StatusCheckPolicy | None = None
    required_pull_request_reviews: RequiredPullRequestReviews | None = None
    required_signatures: RequiredSignatures | None = None
    enforce_admins: EnforceAdmins | None = None
    required_linear_history: RequiredLinearHistory1 | None = None
    allow_force_pushes: AllowForcePushes1 | None = None
    allow_deletions: AllowDeletions1 | None = None
    restrictions: BranchRestrictionPolicy | None = None
    required_conversation_resolution: RequiredConversationResolution1 | None = None
    block_creations: BlockCreations1 | None = None
    lock_branch: LockBranch1 | None = None
    """
    Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.
    """
    allow_fork_syncing: AllowForkSyncing1 | None = None
    """
    Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.
    """


class DeploymentSimple(BaseModel):
    """
    A deployment created as the result of an Actions check run from a workflow that references an environment
    """

    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/example/deployments/1"),
    ] = None
    id: Annotated[int | None, Field(example=42)] = None
    """
    Unique identifier of the deployment
    """
    node_id: Annotated[str | None, Field(example="MDEwOkRlcGxveW1lbnQx")] = None
    task: Annotated[str | None, Field(example="deploy")] = None
    """
    Parameter to specify a task to execute
    """
    original_environment: Annotated[str | None, Field(example="staging")] = None
    environment: Annotated[str | None, Field(example="production")] = None
    """
    Name for the target deployment environment.
    """
    description: Annotated[
        str | None, Field(example="Deploy request from hubot")
    ] = None
    created_at: Annotated[datetime | None, Field(example="2012-07-20T01:19:13Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2012-07-20T01:19:13Z")] = None
    statuses_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/example/deployments/1/statuses"
        ),
    ] = None
    repository_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/repos/octocat/example")
    ] = None
    transient_environment: Annotated[bool | None, Field(example=True)] = None
    """
    Specifies if the given environment is will no longer exist at some point in the future. Default: false.
    """
    production_environment: Annotated[bool | None, Field(example=True)] = None
    """
    Specifies if the given environment is one that end-users directly interact with. Default: false.
    """
    performed_via_github_app: NullableIntegration | None = None


class Status6(Enum):
    """
    The phase of the lifecycle that the check is currently in.
    """

    queued = "queued"
    in_progress = "in_progress"
    completed = "completed"


class Conclusion1(Enum):
    success = "success"
    failure = "failure"
    neutral = "neutral"
    cancelled = "cancelled"
    skipped = "skipped"
    timed_out = "timed_out"
    action_required = "action_required"


class Output(BaseModel):
    title: str | None = None
    summary: str | None = None
    text: str | None = None
    annotations_count: int | None = None
    annotations_url: AnyUrl | None = None


class CheckSuite(BaseModel):
    id: int | None = None


class CheckRun(BaseModel):
    """
    A check performed on the code of a given code change
    """

    id: Annotated[int | None, Field(example=21)] = None
    """
    The id of the check.
    """
    head_sha: Annotated[
        str | None, Field(example="009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d")
    ] = None
    """
    The SHA of the commit that is being checked.
    """
    node_id: Annotated[str | None, Field(example="MDg6Q2hlY2tSdW40")] = None
    external_id: Annotated[str | None, Field(example="42")] = None
    url: Annotated[
        str | None,
        Field(example="https://api.github.com/repos/github/hello-world/check-runs/4"),
    ] = None
    html_url: Annotated[
        str | None, Field(example="https://github.com/github/hello-world/runs/4")
    ] = None
    details_url: Annotated[str | None, Field(example="https://example.com")] = None
    status: Annotated[Status6 | None, Field(example="queued")] = None
    """
    The phase of the lifecycle that the check is currently in.
    """
    conclusion: Annotated[Conclusion1 | None, Field(example="neutral")] = None
    started_at: Annotated[datetime | None, Field(example="2018-05-04T01:14:52Z")] = None
    completed_at: Annotated[
        datetime | None, Field(example="2018-05-04T01:14:52Z")
    ] = None
    output: Output | None = None
    name: Annotated[str | None, Field(example="test-coverage")] = None
    """
    The name of the check.
    """
    check_suite: CheckSuite | None = None
    app: NullableIntegration | None = None
    pull_requests: Sequence[PullRequestMinimal] | None = None
    deployment: DeploymentSimple | None = None


class CheckAnnotation(BaseModel):
    """
    Check Annotation
    """

    path: Annotated[str | None, Field(example="README.md")] = None
    start_line: Annotated[int | None, Field(example=2)] = None
    end_line: Annotated[int | None, Field(example=2)] = None
    start_column: Annotated[int | None, Field(example=5)] = None
    end_column: Annotated[int | None, Field(example=10)] = None
    annotation_level: Annotated[str | None, Field(example="warning")] = None
    title: Annotated[str | None, Field(example="Spell Checker")] = None
    message: Annotated[
        str | None, Field(example="Check your spelling for 'banaas'.")
    ] = None
    raw_details: Annotated[
        str | None, Field(example="Do you mean 'bananas' or 'banana'?")
    ] = None
    blob_href: str | None = None


class SimpleCommit(BaseModel):
    """
    Simple Commit
    """

    id: str | None = None
    tree_id: str | None = None
    message: str | None = None
    timestamp: datetime | None = None
    author: Author | None = None
    committer: Committer | None = None


class Status7(Enum):
    queued = "queued"
    in_progress = "in_progress"
    completed = "completed"


class CheckSuite1(BaseModel):
    """
    A suite of checks performed on the code of a given code change
    """

    id: Annotated[int | None, Field(example=5)] = None
    node_id: Annotated[str | None, Field(example="MDEwOkNoZWNrU3VpdGU1")] = None
    head_branch: Annotated[str | None, Field(example="master")] = None
    head_sha: Annotated[
        str | None, Field(example="009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d")
    ] = None
    """
    The SHA of the head commit that is being checked.
    """
    status: Annotated[Status7 | None, Field(example="completed")] = None
    conclusion: Annotated[Conclusion1 | None, Field(example="neutral")] = None
    url: Annotated[
        str | None,
        Field(example="https://api.github.com/repos/github/hello-world/check-suites/5"),
    ] = None
    before: Annotated[
        str | None, Field(example="146e867f55c26428e5f9fade55a9bbf5e95a7912")
    ] = None
    after: Annotated[
        str | None, Field(example="d6fde92930d4715a2b49857d24b940956b26d2d3")
    ] = None
    pull_requests: Sequence[PullRequestMinimal] | None = None
    app: NullableIntegration | None = None
    repository: MinimalRepository | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    head_commit: SimpleCommit | None = None
    latest_check_runs_count: int | None = None
    check_runs_url: str | None = None
    rerequestable: bool | None = None
    runs_rerequestable: bool | None = None


class AutoTriggerCheck(BaseModel):
    app_id: int | None = None
    setting: bool | None = None


class Preferences(BaseModel):
    auto_trigger_checks: Sequence[AutoTriggerCheck] | None = None


class CheckSuitePreference(BaseModel):
    """
    Check suite configuration preferences for a repository.
    """

    preferences: Preferences | None = None
    repository: MinimalRepository | None = None


class Severity3(Enum):
    """
    The severity of the alert.
    """

    none = "none"
    note = "note"
    warning = "warning"
    error = "error"


class CodeScanningAlertRuleSummary(BaseModel):
    id: str | None = None
    """
    A unique identifier for the rule used to detect the alert.
    """
    name: str | None = None
    """
    The name of the rule used to detect the alert.
    """
    tags: Sequence[str] | None = None
    """
    A set of tags applicable for the rule.
    """
    severity: Severity3 | None = None
    """
    The severity of the alert.
    """
    description: str | None = None
    """
    A short description of the rule used to detect the alert.
    """


class CodeScanningAlertItems(BaseModel):
    number: int | None = None
    """
    The security alert number.
    """
    created_at: datetime | None = None
    """
    The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    updated_at: datetime | None = None
    """
    The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    url: AnyUrl | None = None
    """
    The REST API URL of the alert resource.
    """
    html_url: AnyUrl | None = None
    """
    The GitHub URL of the alert resource.
    """
    instances_url: AnyUrl | None = None
    """
    The REST API URL for fetching the list of instances for an alert.
    """
    state: CodeScanningAlertState | None = None
    fixed_at: datetime | None = None
    """
    The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_by: NullableSimpleUser | None = None
    dismissed_at: datetime | None = None
    """
    The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_reason: CodeScanningAlertDismissedReasonEnum | None = None
    """
    **Required when the state is dismissed.** The reason for dismissing or closing the alert.
    """
    dismissed_comment: Annotated[str | None, Field(max_length=280)] = None
    """
    The dismissal comment associated with the dismissal of the alert.
    """
    rule: CodeScanningAlertRuleSummary | None = None
    tool: CodeScanningAnalysisTool | None = None
    most_recent_instance: CodeScanningAlertInstance | None = None


class CodeScanningAlert(BaseModel):
    number: int | None = None
    """
    The security alert number.
    """
    created_at: datetime | None = None
    """
    The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    updated_at: datetime | None = None
    """
    The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    url: AnyUrl | None = None
    """
    The REST API URL of the alert resource.
    """
    html_url: AnyUrl | None = None
    """
    The GitHub URL of the alert resource.
    """
    instances_url: AnyUrl | None = None
    """
    The REST API URL for fetching the list of instances for an alert.
    """
    state: CodeScanningAlertState | None = None
    fixed_at: datetime | None = None
    """
    The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_by: NullableSimpleUser | None = None
    dismissed_at: datetime | None = None
    """
    The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_reason: CodeScanningAlertDismissedReasonEnum | None = None
    """
    **Required when the state is dismissed.** The reason for dismissing or closing the alert.
    """
    dismissed_comment: Annotated[str | None, Field(max_length=280)] = None
    """
    The dismissal comment associated with the dismissal of the alert.
    """
    rule: CodeScanningAlertRule | None = None
    tool: CodeScanningAnalysisTool | None = None
    most_recent_instance: CodeScanningAlertInstance | None = None


class CodeScanningAlertSetState(Enum):
    """
    Sets the state of the code scanning alert. You must provide `dismissed_reason` when you set the state to `dismissed`.
    """

    open = "open"
    dismissed = "dismissed"


class CodeScanningAnalysis(BaseModel):
    ref: str | None = None
    """
    The full Git reference, formatted as `refs/heads/<branch name>`,
    `refs/pull/<number>/merge`, or `refs/pull/<number>/head`.
    """
    commit_sha: Annotated[
        str | None, Field(max_length=40, min_length=40, regex="^[0-9a-fA-F]+$")
    ] = None
    """
    The SHA of the commit to which the analysis you are uploading relates.
    """
    analysis_key: str | None = None
    """
    Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
    """
    environment: str | None = None
    """
    Identifies the variable values associated with the environment in which this analysis was performed.
    """
    category: str | None = None
    """
    Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code.
    """
    error: Annotated[str | None, Field(example="error reading field xyz")] = None
    created_at: datetime | None = None
    """
    The time that the analysis was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    results_count: int | None = None
    """
    The total number of results in the analysis.
    """
    rules_count: int | None = None
    """
    The total number of rules used in the analysis.
    """
    id: int | None = None
    """
    Unique identifier for this analysis.
    """
    url: AnyUrl | None = None
    """
    The REST API URL of the analysis resource.
    """
    sarif_id: Annotated[
        str | None, Field(example="6c81cd8e-b078-4ac3-a3be-1dad7dbd0b53")
    ] = None
    """
    An identifier for the upload.
    """
    tool: CodeScanningAnalysisTool | None = None
    deletable: bool | None = None
    warning: Annotated[str | None, Field(example="123 results were ignored")] = None
    """
    Warning generated when processing the analysis
    """


class CodeScanningAnalysisDeletion(BaseModel):
    """
    Successful deletion of a code scanning analysis
    """

    next_analysis_url: AnyUrl | None = None
    """
    Next deletable analysis in chain, without last analysis deletion confirmation
    """
    confirm_delete_url: AnyUrl | None = None
    """
    Next deletable analysis in chain, with last analysis deletion confirmation
    """


class CodeScanningCodeqlDatabase(BaseModel):
    """
    A CodeQL database.
    """

    id: int | None = None
    """
    The ID of the CodeQL database.
    """
    name: str | None = None
    """
    The name of the CodeQL database.
    """
    language: str | None = None
    """
    The language of the CodeQL database.
    """
    uploader: SimpleUser | None = None
    content_type: str | None = None
    """
    The MIME type of the CodeQL database file.
    """
    size: int | None = None
    """
    The size of the CodeQL database file in bytes.
    """
    created_at: datetime | None = None
    """
    The date and time at which the CodeQL database was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
    """
    updated_at: datetime | None = None
    """
    The date and time at which the CodeQL database was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
    """
    url: AnyUrl | None = None
    """
    The URL at which to download the CodeQL database. The `Accept` header must be set to the value of the `content_type` property.
    """


class CodeScanningAnalysisSarifFile(BaseModel):
    __root__: str | None = None
    """
    A Base64 string representing the SARIF file to upload. You must first compress your SARIF file using [`gzip`](http://www.gnu.org/software/gzip/manual/gzip.html) and then translate the contents of the file into a Base64 encoding string. For more information, see "[SARIF support for code scanning](https://docs.github.com/code-security/secure-coding/sarif-support-for-code-scanning)."
    """


class CodeScanningSarifsReceipt(BaseModel):
    id: Annotated[
        str | None, Field(example="6c81cd8e-b078-4ac3-a3be-1dad7dbd0b53")
    ] = None
    """
    An identifier for the upload.
    """
    url: AnyUrl | None = None
    """
    The REST API URL for checking the status of the upload.
    """


class ProcessingStatus(Enum):
    """
    `pending` files have not yet been processed, while `complete` means results from the SARIF have been stored. `failed` files have either not been processed at all, or could only be partially processed.
    """

    pending = "pending"
    complete = "complete"
    failed = "failed"


class CodeScanningSarifsStatus(BaseModel):
    processing_status: ProcessingStatus | None = None
    """
    `pending` files have not yet been processed, while `complete` means results from the SARIF have been stored. `failed` files have either not been processed at all, or could only be partially processed.
    """
    analyses_url: AnyUrl | None = None
    """
    The REST API URL for getting the analyses associated with the upload.
    """
    errors: Sequence[str] | None = None
    """
    Any errors that ocurred during processing of the delivery.
    """


class Error1(BaseModel):
    line: Annotated[int | None, Field(example=7)] = None
    """
    The line number where this errors occurs.
    """
    column: Annotated[int | None, Field(example=3)] = None
    """
    The column number where this errors occurs.
    """
    source: Annotated[str | None, Field(example="* user")] = None
    """
    The contents of the line where the error occurs.
    """
    kind: Annotated[str | None, Field(example="Invalid owner")] = None
    """
    The type of error.
    """
    suggestion: Annotated[
        str | None,
        Field(
            example="The pattern `/` will never match anything, did you mean `*` instead?"
        ),
    ] = None
    """
    Suggested action to fix the error. This will usually be `null`, but is provided for some common errors.
    """
    message: Annotated[
        str | None, Field(example="Invalid owner on line 7:\n\n  * user\n    ^")
    ] = None
    """
    A human-readable description of the error, combining information from multiple fields, laid out for display in a monospaced typeface (for example, a command-line setting).
    """
    path: Annotated[str | None, Field(example=".github/CODEOWNERS")] = None
    """
    The path of the file where the error occured.
    """


class CodeownersErrors(BaseModel):
    """
    A list of errors found in a repo's CODEOWNERS file
    """

    errors: Sequence[Error1] | None = None


class CodespaceMachine(BaseModel):
    """
    A description of the machine powering a codespace.
    """

    name: Annotated[str | None, Field(example="standardLinux")] = None
    """
    The name of the machine.
    """
    display_name: Annotated[
        str | None, Field(example="4 cores, 8 GB RAM, 64 GB storage")
    ] = None
    """
    The display name of the machine includes cores, memory, and storage.
    """
    operating_system: Annotated[str | None, Field(example="linux")] = None
    """
    The operating system of the machine.
    """
    storage_in_bytes: Annotated[int | None, Field(example=68719476736)] = None
    """
    How much storage is available to the codespace.
    """
    memory_in_bytes: Annotated[int | None, Field(example=8589934592)] = None
    """
    How much memory is available to the codespace.
    """
    cpus: Annotated[int | None, Field(example=4)] = None
    """
    How many cores are available to the codespace.
    """
    prebuild_availability: Annotated[
        PrebuildAvailability | None, Field(example="ready")
    ] = None
    """
    Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.
    """


class RepoCodespacesSecret(BaseModel):
    """
    Set repository secrets for GitHub Codespaces.
    """

    name: Annotated[str | None, Field(example="SECRET_TOKEN")] = None
    """
    The name of the secret.
    """
    created_at: datetime | None = None
    updated_at: datetime | None = None


class Permissions14(BaseModel):
    pull: bool | None = None
    triage: bool | None = None
    push: bool | None = None
    maintain: bool | None = None
    admin: bool | None = None


class Collaborator(BaseModel):
    """
    Collaborator
    """

    login: Annotated[str | None, Field(example="octocat")] = None
    id: Annotated[int | None, Field(example=1)] = None
    email: str | None = None
    name: str | None = None
    node_id: Annotated[str | None, Field(example="MDQ6VXNlcjE=")] = None
    avatar_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/images/error/octocat_happy.gif"),
    ] = None
    gravatar_id: Annotated[
        str | None, Field(example="41d064eb2195891e12d0413f63227ea7")
    ] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat")
    ] = None
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat")
    ] = None
    followers_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/followers")
    ] = None
    following_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/following{/other_user}"),
    ] = None
    gists_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/gists{/gist_id}"),
    ] = None
    starred_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/starred{/owner}{/repo}"),
    ] = None
    subscriptions_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/users/octocat/subscriptions"),
    ] = None
    organizations_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/orgs")
    ] = None
    repos_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/repos")
    ] = None
    events_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/events{/privacy}"),
    ] = None
    received_events_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/users/octocat/received_events"),
    ] = None
    type: Annotated[str | None, Field(example="User")] = None
    site_admin: bool | None = None
    permissions: Permissions14 | None = None
    role_name: Annotated[str | None, Field(example="admin")] = None


class Permissions15(Enum):
    """
    The permission associated with the invitation.
    """

    read = "read"
    write = "write"
    admin = "admin"
    triage = "triage"
    maintain = "maintain"


class RepositoryInvitation(BaseModel):
    """
    Repository invitations let you manage who you collaborate with.
    """

    id: Annotated[int | None, Field(example=42)] = None
    """
    Unique identifier of the repository invitation.
    """
    repository: MinimalRepository | None = None
    invitee: NullableSimpleUser | None = None
    inviter: NullableSimpleUser | None = None
    permissions: Annotated[Permissions15 | None, Field(example="read")] = None
    """
    The permission associated with the invitation.
    """
    created_at: Annotated[
        datetime | None, Field(example="2016-06-13T14:52:50-05:00")
    ] = None
    expired: bool | None = None
    """
    Whether or not the invitation has expired
    """
    url: Annotated[
        str | None,
        Field(example="https://api.github.com/user/repository-invitations/1"),
    ] = None
    """
    URL for the repository invitation
    """
    html_url: Annotated[
        str | None, Field(example="https://github.com/octocat/Hello-World/invitations")
    ] = None
    node_id: str | None = None


class Permissions16(BaseModel):
    pull: bool | None = None
    triage: bool | None = None
    push: bool | None = None
    maintain: bool | None = None
    admin: bool | None = None


class NullableCollaborator(BaseModel):
    """
    Collaborator
    """

    login: Annotated[str | None, Field(example="octocat")] = None
    id: Annotated[int | None, Field(example=1)] = None
    email: str | None = None
    name: str | None = None
    node_id: Annotated[str | None, Field(example="MDQ6VXNlcjE=")] = None
    avatar_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/images/error/octocat_happy.gif"),
    ] = None
    gravatar_id: Annotated[
        str | None, Field(example="41d064eb2195891e12d0413f63227ea7")
    ] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat")
    ] = None
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat")
    ] = None
    followers_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/followers")
    ] = None
    following_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/following{/other_user}"),
    ] = None
    gists_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/gists{/gist_id}"),
    ] = None
    starred_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/starred{/owner}{/repo}"),
    ] = None
    subscriptions_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/users/octocat/subscriptions"),
    ] = None
    organizations_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/orgs")
    ] = None
    repos_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/repos")
    ] = None
    events_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/events{/privacy}"),
    ] = None
    received_events_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/users/octocat/received_events"),
    ] = None
    type: Annotated[str | None, Field(example="User")] = None
    site_admin: bool | None = None
    permissions: Permissions16 | None = None
    role_name: Annotated[str | None, Field(example="admin")] = None


class RepositoryCollaboratorPermission(BaseModel):
    """
    Repository Collaborator Permission
    """

    permission: str | None = None
    role_name: Annotated[str | None, Field(example="admin")] = None
    user: NullableCollaborator | None = None


class CommitComment(BaseModel):
    """
    Commit Comment
    """

    html_url: AnyUrl | None = None
    url: AnyUrl | None = None
    id: int | None = None
    node_id: str | None = None
    body: str | None = None
    path: str | None = None
    position: int | None = None
    line: int | None = None
    commit_id: str | None = None
    user: NullableSimpleUser | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    author_association: AuthorAssociation | None = None
    reactions: ReactionRollup | None = None


class Commit3(BaseModel):
    sha: str | None = None
    url: str | None = None


class BranchShort(BaseModel):
    """
    Branch Short
    """

    name: str | None = None
    commit: Commit3 | None = None
    protected: bool | None = None


class Link(BaseModel):
    """
    Hypermedia Link
    """

    href: str | None = None


class MergeMethod(Enum):
    """
    The merge method to use.
    """

    merge = "merge"
    squash = "squash"
    rebase = "rebase"


class AutoMerge(BaseModel):
    """
    The status of auto merging a pull request.
    """

    enabled_by: SimpleUser | None = None
    merge_method: MergeMethod | None = None
    """
    The merge method to use.
    """
    commit_title: str | None = None
    """
    Title for the merge commit message.
    """
    commit_message: str | None = None
    """
    Commit message for the merge commit.
    """


class Label1(BaseModel):
    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    name: str | None = None
    description: str | None = None
    color: str | None = None
    default: bool | None = None


class Head1(BaseModel):
    label: str | None = None
    ref: str | None = None
    repo: Repository | None = None
    sha: str | None = None
    user: NullableSimpleUser | None = None


class Base1(BaseModel):
    label: str | None = None
    ref: str | None = None
    repo: Repository | None = None
    sha: str | None = None
    user: NullableSimpleUser | None = None


class FieldLinks2(BaseModel):
    comments: Link | None = None
    commits: Link | None = None
    statuses: Link | None = None
    html: Link | None = None
    issue: Link | None = None
    review_comments: Link | None = None
    review_comment: Link | None = None
    self: Link | None = None


class PullRequestSimple(BaseModel):
    """
    Pull Request Simple
    """

    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/pulls/1347"),
    ] = None
    id: Annotated[int | None, Field(example=1)] = None
    node_id: Annotated[str | None, Field(example="MDExOlB1bGxSZXF1ZXN0MQ==")] = None
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat/Hello-World/pull/1347")
    ] = None
    diff_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/octocat/Hello-World/pull/1347.diff"),
    ] = None
    patch_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/octocat/Hello-World/pull/1347.patch"),
    ] = None
    issue_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/issues/1347"),
    ] = None
    commits_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/pulls/1347/commits"
        ),
    ] = None
    review_comments_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/pulls/1347/comments"
        ),
    ] = None
    review_comment_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/pulls/comments{/number}"
        ),
    ] = None
    comments_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/issues/1347/comments"
        ),
    ] = None
    statuses_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/statuses/6dcb09b5b57875f334f61aebed695e2e4193db5e"
        ),
    ] = None
    number: Annotated[int | None, Field(example=1347)] = None
    state: Annotated[str | None, Field(example="open")] = None
    locked: Annotated[bool | None, Field(example=True)] = None
    title: Annotated[str | None, Field(example="new-feature")] = None
    user: NullableSimpleUser | None = None
    body: Annotated[
        str | None, Field(example="Please pull these awesome changes")
    ] = None
    labels: Sequence[Label1] | None = None
    milestone: NullableMilestone | None = None
    active_lock_reason: Annotated[str | None, Field(example="too heated")] = None
    created_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    closed_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    merged_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    merge_commit_sha: Annotated[
        str | None, Field(example="e5bd3914e2e596debea16f433f57875b5b90bcd6")
    ] = None
    assignee: NullableSimpleUser | None = None
    assignees: Sequence[SimpleUser] | None = None
    requested_reviewers: Sequence[SimpleUser] | None = None
    requested_teams: Sequence[Team] | None = None
    head: Head1 | None = None
    base: Base1 | None = None
    field_links: Annotated[FieldLinks2 | None, Field(alias="_links")] = None
    author_association: AuthorAssociation | None = None
    auto_merge: AutoMerge | None = None
    draft: Annotated[bool | None, Field(example=False)] = None
    """
    Indicates whether or not the pull request is a draft.
    """


class SimpleCommitStatus(BaseModel):
    description: str | None = None
    id: int | None = None
    node_id: str | None = None
    state: str | None = None
    context: str | None = None
    target_url: AnyUrl | None = None
    required: bool | None = None
    avatar_url: AnyUrl | None = None
    url: AnyUrl | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None


class CombinedCommitStatus(BaseModel):
    """
    Combined Commit Status
    """

    state: str | None = None
    statuses: Sequence[SimpleCommitStatus] | None = None
    sha: str | None = None
    total_count: int | None = None
    repository: MinimalRepository | None = None
    commit_url: AnyUrl | None = None
    url: AnyUrl | None = None


class Status8(BaseModel):
    """
    The status of a commit.
    """

    url: str | None = None
    avatar_url: str | None = None
    id: int | None = None
    node_id: str | None = None
    state: str | None = None
    description: str | None = None
    target_url: str | None = None
    context: str | None = None
    created_at: str | None = None
    updated_at: str | None = None
    creator: NullableSimpleUser | None = None


class NullableCodeOfConductSimple(BaseModel):
    """
    Code of Conduct Simple
    """

    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/github/docs/community/code_of_conduct"
        ),
    ] = None
    key: Annotated[str | None, Field(example="citizen_code_of_conduct")] = None
    name: Annotated[str | None, Field(example="Citizen Code of Conduct")] = None
    html_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/github/docs/blob/main/CODE_OF_CONDUCT.md"),
    ] = None


class NullableCommunityHealthFile(BaseModel):
    url: AnyUrl | None = None
    html_url: AnyUrl | None = None


class Files3(BaseModel):
    code_of_conduct: NullableCodeOfConductSimple | None = None
    code_of_conduct_file: NullableCommunityHealthFile | None = None
    license: NullableLicenseSimple | None = None
    contributing: NullableCommunityHealthFile | None = None
    readme: NullableCommunityHealthFile | None = None
    issue_template: NullableCommunityHealthFile | None = None
    pull_request_template: NullableCommunityHealthFile | None = None


class CommunityProfile(BaseModel):
    """
    Community Profile
    """

    health_percentage: Annotated[int | None, Field(example=100)] = None
    description: Annotated[
        str | None, Field(example="My first repository on GitHub!")
    ] = None
    documentation: Annotated[str | None, Field(example="example.com")] = None
    files: Files3 | None = None
    updated_at: Annotated[datetime | None, Field(example="2017-02-28T19:09:29Z")] = None
    content_reports_enabled: Annotated[bool | None, Field(example=True)] = None


class Status9(Enum):
    diverged = "diverged"
    ahead = "ahead"
    behind = "behind"
    identical = "identical"


class CommitComparison(BaseModel):
    """
    Commit Comparison
    """

    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/compare/master...topic"
        ),
    ] = None
    html_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/octocat/Hello-World/compare/master...topic"),
    ] = None
    permalink_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://github.com/octocat/Hello-World/compare/octocat:bbcd538c8e72b8c175046e27cc8f907076331401...octocat:0328041d1152db8ae77652d1618a02e57f745f17"
        ),
    ] = None
    diff_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://github.com/octocat/Hello-World/compare/master...topic.diff"
        ),
    ] = None
    patch_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://github.com/octocat/Hello-World/compare/master...topic.patch"
        ),
    ] = None
    base_commit: Commit1 | None = None
    merge_base_commit: Commit1 | None = None
    status: Annotated[Status9 | None, Field(example="ahead")] = None
    ahead_by: Annotated[int | None, Field(example=4)] = None
    behind_by: Annotated[int | None, Field(example=5)] = None
    total_commits: Annotated[int | None, Field(example=6)] = None
    commits: Sequence[Commit1] | None = None
    files: Sequence[DiffEntry] | None = None


class FieldLinks3(BaseModel):
    git: AnyUrl | None = None
    html: AnyUrl | None = None
    self: AnyUrl | None = None


class Entry(BaseModel):
    type: str | None = None
    size: int | None = None
    name: str | None = None
    path: str | None = None
    content: str | None = None
    sha: str | None = None
    url: AnyUrl | None = None
    git_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    download_url: AnyUrl | None = None
    field_links: Annotated[FieldLinks3 | None, Field(alias="_links")] = None


class ContentTree(BaseModel):
    """
    Content Tree
    """

    type: str | None = None
    size: int | None = None
    name: str | None = None
    path: str | None = None
    sha: str | None = None
    url: AnyUrl | None = None
    git_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    download_url: AnyUrl | None = None
    entries: Sequence[Entry] | None = None
    field_links: Annotated[FieldLinks3 | None, Field(alias="_links")] = None


class Type2(Enum):
    dir = "dir"
    file = "file"
    submodule = "submodule"
    symlink = "symlink"


class ContentDirectoryItem(BaseModel):
    type: Type2 | None = None
    size: int | None = None
    name: str | None = None
    path: str | None = None
    content: str | None = None
    sha: str | None = None
    url: AnyUrl | None = None
    git_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    download_url: AnyUrl | None = None
    field_links: Annotated[FieldLinks3 | None, Field(alias="_links")] = None


class ContentDirectory(BaseModel):
    """
    A list of directory items
    """

    __root__: Annotated[
        Sequence[ContentDirectoryItem] | None, Field(title="Content Directory")
    ] = None
    """
    A list of directory items
    """


class Type3(Enum):
    file = "file"


class ContentFile(BaseModel):
    """
    Content File
    """

    type: Type3 | None = None
    encoding: str | None = None
    size: int | None = None
    name: str | None = None
    path: str | None = None
    content: str | None = None
    sha: str | None = None
    url: AnyUrl | None = None
    git_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    download_url: AnyUrl | None = None
    field_links: Annotated[FieldLinks3 | None, Field(alias="_links")] = None
    target: Annotated[str | None, Field(example='"actual/actual.md"')] = None
    submodule_git_url: Annotated[
        str | None, Field(example='"git://example.com/defunkt/dotjs.git"')
    ] = None


class Type4(Enum):
    symlink = "symlink"


class ContentSymlink(BaseModel):
    """
    An object describing a symlink
    """

    type: Type4 | None = None
    target: str | None = None
    size: int | None = None
    name: str | None = None
    path: str | None = None
    sha: str | None = None
    url: AnyUrl | None = None
    git_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    download_url: AnyUrl | None = None
    field_links: Annotated[FieldLinks3 | None, Field(alias="_links")] = None


class Type5(Enum):
    submodule = "submodule"


class ContentSubmodule(BaseModel):
    """
    An object describing a submodule
    """

    type: Type5 | None = None
    submodule_git_url: AnyUrl | None = None
    size: int | None = None
    name: str | None = None
    path: str | None = None
    sha: str | None = None
    url: AnyUrl | None = None
    git_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    download_url: AnyUrl | None = None
    field_links: Annotated[FieldLinks3 | None, Field(alias="_links")] = None


class FieldLinks9(BaseModel):
    self: str | None = None
    git: str | None = None
    html: str | None = None


class Content1(BaseModel):
    name: str | None = None
    path: str | None = None
    sha: str | None = None
    size: int | None = None
    url: str | None = None
    html_url: str | None = None
    git_url: str | None = None
    download_url: str | None = None
    type: str | None = None
    field_links: Annotated[FieldLinks9 | None, Field(alias="_links")] = None


class Author2(BaseModel):
    date: str | None = None
    name: str | None = None
    email: str | None = None


class Committer2(BaseModel):
    date: str | None = None
    name: str | None = None
    email: str | None = None


class Tree1(BaseModel):
    url: str | None = None
    sha: str | None = None


class Parent1(BaseModel):
    url: str | None = None
    html_url: str | None = None
    sha: str | None = None


class Verification1(BaseModel):
    verified: bool | None = None
    reason: str | None = None
    signature: str | None = None
    payload: str | None = None


class Commit4(BaseModel):
    sha: str | None = None
    node_id: str | None = None
    url: str | None = None
    html_url: str | None = None
    author: Author2 | None = None
    committer: Committer2 | None = None
    message: str | None = None
    tree: Tree1 | None = None
    parents: Sequence[Parent1] | None = None
    verification: Verification1 | None = None


class FileCommit(BaseModel):
    """
    File Commit
    """

    content: Content1 | None = None
    commit: Commit4 | None = None


class Contributor(BaseModel):
    """
    Contributor
    """

    login: str | None = None
    id: int | None = None
    node_id: str | None = None
    avatar_url: AnyUrl | None = None
    gravatar_id: str | None = None
    url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    organizations_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    events_url: str | None = None
    received_events_url: AnyUrl | None = None
    type: str | None = None
    site_admin: bool | None = None
    contributions: int | None = None
    email: str | None = None
    name: str | None = None


class State7(Enum):
    """
    The state of the Dependabot alert.
    """

    dismissed = "dismissed"
    fixed = "fixed"
    open = "open"


class Dependency1(BaseModel):
    """
    Details for the vulnerable dependency.
    """

    package: DependabotAlertPackage | None = None
    manifest_path: str | None = None
    """
    The full path to the dependency manifest file, relative to the root of the repository.
    """
    scope: Scope | None = None
    """
    The execution scope of the vulnerable dependency.
    """


class DependabotAlert(BaseModel):
    """
    A Dependabot alert.
    """

    class Config:
        extra = Extra.forbid

    number: int | None = None
    """
    The security alert number.
    """
    state: State7 | None = None
    """
    The state of the Dependabot alert.
    """
    dependency: Dependency1 | None = None
    """
    Details for the vulnerable dependency.
    """
    security_advisory: DependabotAlertSecurityAdvisory | None = None
    security_vulnerability: DependabotAlertSecurityVulnerability | None = None
    url: AnyUrl | None = None
    """
    The REST API URL of the alert resource.
    """
    html_url: AnyUrl | None = None
    """
    The GitHub URL of the alert resource.
    """
    created_at: datetime | None = None
    """
    The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    updated_at: datetime | None = None
    """
    The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_at: datetime | None = None
    """
    The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_by: NullableSimpleUser | None = None
    dismissed_reason: DismissedReason | None = None
    """
    The reason that the alert was dismissed.
    """
    dismissed_comment: Annotated[str | None, Field(max_length=280)] = None
    """
    An optional comment associated with the alert's dismissal.
    """
    fixed_at: datetime | None = None
    """
    The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """


class DependabotSecret(BaseModel):
    """
    Set secrets for Dependabot.
    """

    name: Annotated[str | None, Field(example="MY_ARTIFACTORY_PASSWORD")] = None
    """
    The name of the secret.
    """
    created_at: datetime | None = None
    updated_at: datetime | None = None


class ChangeType(Enum):
    added = "added"
    removed = "removed"


class Vulnerability(BaseModel):
    severity: Annotated[str | None, Field(example="critical")] = None
    advisory_ghsa_id: Annotated[str | None, Field(example="GHSA-rf4j-j272-fj86")] = None
    advisory_summary: Annotated[
        str | None, Field(example="A summary of the advisory.")
    ] = None
    advisory_url: Annotated[
        str | None, Field(example="https://github.com/advisories/GHSA-rf4j-j272-fj86")
    ] = None


class Scope2(Enum):
    """
    Where the dependency is utilized. `development` means that the dependency is only utilized in the development environment. `runtime` means that the dependency is utilized at runtime and in the development environment.
    """

    unknown = "unknown"
    runtime = "runtime"
    development = "development"


class DependencyGraphDiffItem(BaseModel):
    change_type: ChangeType | None = None
    manifest: Annotated[str | None, Field(example="path/to/package-lock.json")] = None
    ecosystem: Annotated[str | None, Field(example="npm")] = None
    name: Annotated[str | None, Field(example="@actions/core")] = None
    version: Annotated[str | None, Field(example="1.0.0")] = None
    package_url: Annotated[
        str | None, Field(example="pkg:/npm/%40actions/core@1.1.0")
    ] = None
    license: Annotated[str | None, Field(example="MIT")] = None
    source_repository_url: Annotated[
        str | None, Field(example="https://github.com/github/actions")
    ] = None
    vulnerabilities: Sequence[Vulnerability] | None = None
    scope: Scope2 | None = None
    """
    Where the dependency is utilized. `development` means that the dependency is only utilized in the development environment. `runtime` means that the dependency is utilized at runtime and in the development environment.
    """


class DependencyGraphDiff(BaseModel):
    """
    A diff of the dependencies between two commits.
    """

    __root__: Annotated[
        Sequence[DependencyGraphDiffItem] | None, Field(title="Dependency Graph Diff")
    ] = None
    """
    A diff of the dependencies between two commits.
    """


class Relationship(Enum):
    """
    A notation of whether a dependency is requested directly by this manifest or is a dependency of another dependency.
    """

    direct = "direct"
    indirect = "indirect"


class Scope3(Enum):
    """
    A notation of whether the dependency is required for the primary build artifact (runtime) or is only used for development. Future versions of this specification may allow for more granular scopes.
    """

    runtime = "runtime"
    development = "development"


class Dependency2(BaseModel):
    class Config:
        extra = Extra.forbid

    package_url: Annotated[
        str | None,
        Field(example="pkg:/npm/%40actions/http-client@1.0.11", regex="^pkg"),
    ] = None
    """
    Package-url (PURL) of dependency. See https://github.com/package-url/purl-spec for more details.
    """
    metadata: Mapping[str, str | float | bool] | None = None
    relationship: Annotated[Relationship | None, Field(example="direct")] = None
    """
    A notation of whether a dependency is requested directly by this manifest or is a dependency of another dependency.
    """
    scope: Annotated[Scope3 | None, Field(example="runtime")] = None
    """
    A notation of whether the dependency is required for the primary build artifact (runtime) or is only used for development. Future versions of this specification may allow for more granular scopes.
    """
    dependencies: Annotated[
        Sequence[str] | None, Field(example="@actions/http-client")
    ] = None
    """
    Array of package-url (PURLs) of direct child dependencies.
    """


class File(BaseModel):
    class Config:
        extra = Extra.forbid

    source_location: Annotated[
        str | None, Field(example="/src/build/package-lock.json")
    ] = None
    """
    The path of the manifest file relative to the root of the Git repository.
    """


class Manifest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Annotated[str | None, Field(example="package-lock.json")] = None
    """
    The name of the manifest.
    """
    file: File | None = None
    metadata: Mapping[str, str | float | bool] | None = None
    resolved: Mapping[str, Dependency2] | None = None
    """
    A collection of resolved package dependencies.
    """


class Job1(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Annotated[
        str | None, Field(example="5622a2b0-63f6-4732-8c34-a1ab27e102a11")
    ] = None
    """
    The external ID of the job.
    """
    correlator: Annotated[
        str | None, Field(example="yourworkflowname_yourjobname")
    ] = None
    """
    Correlator provides a key that is used to group snapshots submitted over time. Only the "latest" submitted snapshot for a given combination of `job.correlator` and `detector.name` will be considered when calculating a repository's current dependencies. Correlator should be as unique as it takes to distinguish all detection runs for a given "wave" of CI workflow you run. If you're using GitHub Actions, a good default value for this could be the environment variables GITHUB_WORKFLOW and GITHUB_JOB concatenated together. If you're using a build matrix, then you'll also need to add additional key(s) to distinguish between each submission inside a matrix variation.
    """
    html_url: Annotated[str | None, Field(example="http://example.com/build")] = None
    """
    The url for the job.
    """


class Detector(BaseModel):
    """
    A description of the detector used.
    """

    class Config:
        extra = Extra.forbid

    name: Annotated[str | None, Field(example="docker buildtime detector")] = None
    """
    The name of the detector used.
    """
    version: Annotated[str | None, Field(example="1.0.0")] = None
    """
    The version of the detector used.
    """
    url: Annotated[
        str | None, Field(example="http://example.com/docker-buildtimer-detector")
    ] = None
    """
    The url of the detector used.
    """


class Snapshot(BaseModel):
    """
    Create a new snapshot of a repository's dependencies.
    """

    class Config:
        extra = Extra.forbid

    version: int | None = None
    """
    The version of the repository snapshot submission.
    """
    job: Job1 | None = None
    sha: Annotated[
        str | None,
        Field(example="ddc951f4b1293222421f2c8df679786153acf689", min_length=40),
    ] = None
    """
    The commit SHA associated with this dependency snapshot.
    """
    ref: Annotated[str | None, Field(example="refs/heads/main", regex="^refs/")] = None
    """
    The repository branch that triggered this snapshot.
    """
    detector: Detector | None = None
    """
    A description of the detector used.
    """
    metadata: Mapping[str, str | float | bool] | None = None
    manifests: Mapping[str, Manifest] | None = None
    """
    A collection of package manifests, which are a collection of related dependencies declared in a file or representing a logical group of dependencies.
    """
    scanned: Annotated[
        datetime | None, Field(example="2020-06-13T14:52:50-05:00")
    ] = None
    """
    The time at which the snapshot was scanned.
    """


class State8(Enum):
    """
    The state of the status.
    """

    error = "error"
    failure = "failure"
    inactive = "inactive"
    pending = "pending"
    success = "success"
    queued = "queued"
    in_progress = "in_progress"


class DeploymentStatus(BaseModel):
    """
    The status of a deployment.
    """

    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/example/deployments/42/statuses/1"
        ),
    ] = None
    id: Annotated[int | None, Field(example=1)] = None
    node_id: Annotated[str | None, Field(example="MDE2OkRlcGxveW1lbnRTdGF0dXMx")] = None
    state: Annotated[State8 | None, Field(example="success")] = None
    """
    The state of the status.
    """
    creator: NullableSimpleUser | None = None
    description: Annotated[
        str | None, Field(example="Deployment finished successfully.", max_length=140)
    ] = ""
    """
    A short description of the status.
    """
    environment: Annotated[str | None, Field(example="production")] = ""
    """
    The environment of the deployment that the status is for.
    """
    target_url: Annotated[
        AnyUrl | None, Field(example="https://example.com/deployment/42/output")
    ] = ""
    """
    Deprecated: the URL to associate with this status.
    """
    created_at: Annotated[datetime | None, Field(example="2012-07-20T01:19:13Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2012-07-20T01:19:13Z")] = None
    deployment_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/example/deployments/42"),
    ] = None
    repository_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/repos/octocat/example")
    ] = None
    environment_url: Annotated[
        AnyUrl | None, Field(example="https://staging.example.com/")
    ] = ""
    """
    The URL for accessing your environment.
    """
    log_url: Annotated[
        AnyUrl | None, Field(example="https://example.com/deployment/42/output")
    ] = ""
    """
    The URL to associate with this status.
    """
    performed_via_github_app: NullableIntegration | None = None


class DeploymentBranchPolicySettings(BaseModel):
    """
    The type of deployment branch policy for this environment. To allow all branches to deploy, set to `null`.
    """

    protected_branches: bool | None = None
    """
    Whether only branches with branch protection rules can deploy to this environment. If `protected_branches` is `true`, `custom_branch_policies` must be `false`; if `protected_branches` is `false`, `custom_branch_policies` must be `true`.
    """
    custom_branch_policies: bool | None = None
    """
    Whether only branches that match the specified name patterns can deploy to this environment.  If `custom_branch_policies` is `true`, `protected_branches` must be `false`; if `custom_branch_policies` is `false`, `protected_branches` must be `true`.
    """


class ProtectionRule(BaseModel):
    id: Annotated[int | None, Field(example=3515)] = None
    node_id: Annotated[str | None, Field(example="MDQ6R2F0ZTM1MTU=")] = None
    type: Annotated[str | None, Field(example="wait_timer")] = None
    wait_timer: Annotated[int | None, Field(example=30)] = None
    """
    The amount of time to delay a job after the job is initially triggered. The time (in minutes) must be an integer between 0 and 43,200 (30 days).
    """


class ProtectionRule1(BaseModel):
    id: Annotated[int | None, Field(example=3755)] = None
    node_id: Annotated[str | None, Field(example="MDQ6R2F0ZTM3NTU=")] = None
    type: Annotated[str | None, Field(example="required_reviewers")] = None
    reviewers: Sequence[Reviewer] | None = None
    """
    The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.
    """


class ProtectionRule2(BaseModel):
    id: Annotated[int | None, Field(example=3515)] = None
    node_id: Annotated[str | None, Field(example="MDQ6R2F0ZTM1MTU=")] = None
    type: Annotated[str | None, Field(example="branch_policy")] = None


class Environment2(BaseModel):
    """
    Details of a deployment environment
    """

    id: Annotated[int | None, Field(example=56780428)] = None
    """
    The id of the environment.
    """
    node_id: Annotated[
        str | None, Field(example="MDExOkVudmlyb25tZW50NTY3ODA0Mjg=")
    ] = None
    name: Annotated[str | None, Field(example="staging")] = None
    """
    The name of the environment.
    """
    url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/environments/staging"
        ),
    ] = None
    html_url: Annotated[
        str | None,
        Field(
            example="https://github.com/github/hello-world/deployments/activity_log?environments_filter=staging"
        ),
    ] = None
    created_at: Annotated[datetime | None, Field(example="2020-11-23T22:00:40Z")] = None
    """
    The time that the environment was created, in ISO 8601 format.
    """
    updated_at: Annotated[datetime | None, Field(example="2020-11-23T22:00:40Z")] = None
    """
    The time that the environment was last updated, in ISO 8601 format.
    """
    protection_rules: Sequence[
        ProtectionRule | ProtectionRule1 | ProtectionRule2
    ] | None = None
    deployment_branch_policy: DeploymentBranchPolicySettings | None = None


class DeploymentBranchPolicy(BaseModel):
    """
    Details of a deployment branch policy.
    """

    id: Annotated[int | None, Field(example=361471)] = None
    """
    The unique identifier of the branch policy.
    """
    node_id: Annotated[
        str | None, Field(example="MDE2OkdhdGVCcmFuY2hQb2xpY3kzNjE0NzE=")
    ] = None
    name: Annotated[str | None, Field(example="release/*")] = None
    """
    The name pattern that branches must match in order to deploy to the environment.
    """


class DeploymentBranchPolicyNamePattern(BaseModel):
    name: Annotated[str | None, Field(example="release/*")] = None
    """
    The name pattern that branches must match in order to deploy to the environment.

    Wildcard characters will not match `/`. For example, to match branches that begin with `release/` and contain an additional single slash, use `release/*/*`.
    For more information about pattern matching syntax, see the [Ruby File.fnmatch documentation](https://ruby-doc.org/core-2.5.1/File.html#method-c-fnmatch).
    """


class ShortBlob(BaseModel):
    """
    Short Blob
    """

    url: str | None = None
    sha: str | None = None


class Blob(BaseModel):
    """
    Blob
    """

    content: str | None = None
    encoding: str | None = None
    url: AnyUrl | None = None
    sha: str | None = None
    size: int | None = None
    node_id: str | None = None
    highlighted_content: str | None = None


class Author3(BaseModel):
    """
    Identifying information for the git-user
    """

    date: Annotated[datetime | None, Field(example="2014-08-09T08:02:04+12:00")] = None
    """
    Timestamp of the commit
    """
    email: Annotated[str | None, Field(example="monalisa.octocat@example.com")] = None
    """
    Git email address of the user
    """
    name: Annotated[str | None, Field(example="Monalisa Octocat")] = None
    """
    Name of the git user
    """


class Committer3(BaseModel):
    """
    Identifying information for the git-user
    """

    date: Annotated[datetime | None, Field(example="2014-08-09T08:02:04+12:00")] = None
    """
    Timestamp of the commit
    """
    email: Annotated[str | None, Field(example="monalisa.octocat@example.com")] = None
    """
    Git email address of the user
    """
    name: Annotated[str | None, Field(example="Monalisa Octocat")] = None
    """
    Name of the git user
    """


class Tree2(BaseModel):
    sha: Annotated[
        str | None, Field(example="7638417db6d59f3c431d3e1f261cc637155684cd")
    ] = None
    """
    SHA for the commit
    """
    url: AnyUrl | None = None


class Parent2(BaseModel):
    sha: Annotated[
        str | None, Field(example="7638417db6d59f3c431d3e1f261cc637155684cd")
    ] = None
    """
    SHA for the commit
    """
    url: AnyUrl | None = None
    html_url: AnyUrl | None = None


class GitCommit(BaseModel):
    """
    Low-level Git commit operations within a repository
    """

    sha: Annotated[
        str | None, Field(example="7638417db6d59f3c431d3e1f261cc637155684cd")
    ] = None
    """
    SHA for the commit
    """
    node_id: str | None = None
    url: AnyUrl | None = None
    author: Author3 | None = None
    """
    Identifying information for the git-user
    """
    committer: Committer3 | None = None
    """
    Identifying information for the git-user
    """
    message: Annotated[str | None, Field(example="Fix #42")] = None
    """
    Message describing the purpose of the commit
    """
    tree: Tree2 | None = None
    parents: Sequence[Parent2] | None = None
    verification: Verification1 | None = None
    html_url: AnyUrl | None = None


class Object(BaseModel):
    type: str | None = None
    sha: Annotated[
        str | None,
        Field(
            example="7638417db6d59f3c431d3e1f261cc637155684cd",
            max_length=40,
            min_length=40,
        ),
    ] = None
    """
    SHA for the reference
    """
    url: AnyUrl | None = None


class GitRef(BaseModel):
    """
    Git references within a repository
    """

    ref: str | None = None
    node_id: str | None = None
    url: AnyUrl | None = None
    object: Object | None = None


class Tagger(BaseModel):
    date: str | None = None
    email: str | None = None
    name: str | None = None


class Object1(BaseModel):
    sha: str | None = None
    type: str | None = None
    url: AnyUrl | None = None


class GitTag(BaseModel):
    """
    Metadata for a Git tag
    """

    node_id: Annotated[
        str | None,
        Field(
            example="MDM6VGFnOTQwYmQzMzYyNDhlZmFlMGY5ZWU1YmM3YjJkNWM5ODU4ODdiMTZhYw=="
        ),
    ] = None
    tag: Annotated[str | None, Field(example="v0.0.1")] = None
    """
    Name of the tag
    """
    sha: Annotated[
        str | None, Field(example="940bd336248efae0f9ee5bc7b2d5c985887b16ac")
    ] = None
    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repositories/42/git/tags/940bd336248efae0f9ee5bc7b2d5c985887b16ac"
        ),
    ] = None
    """
    URL for the tag
    """
    message: Annotated[str | None, Field(example="Initial public release")] = None
    """
    Message describing the purpose of the tag
    """
    tagger: Tagger | None = None
    object: Object1 | None = None
    verification: Verification | None = None


class TreeItem(BaseModel):
    path: Annotated[str | None, Field(example="test/file.rb")] = None
    mode: Annotated[str | None, Field(example="040000")] = None
    type: Annotated[str | None, Field(example="tree")] = None
    sha: Annotated[
        str | None, Field(example="23f6827669e43831def8a7ad935069c8bd418261")
    ] = None
    size: Annotated[int | None, Field(example=12)] = None
    url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/owner-482f3203ecf01f67e9deb18e/BBB_Private_Repo/git/blobs/23f6827669e43831def8a7ad935069c8bd418261"
        ),
    ] = None


class GitTree(BaseModel):
    """
    The hierarchy between files in a Git repository.
    """

    sha: str | None = None
    url: AnyUrl | None = None
    truncated: bool | None = None
    tree: Annotated[
        Sequence[TreeItem] | None,
        Field(
            example=[
                {
                    "path": "file.rb",
                    "mode": "100644",
                    "type": "blob",
                    "size": 30,
                    "sha": "44b4fc6d56897b048c772eb4087f854f46256132",
                    "url": "https://api.github.com/repos/octocat/Hello-World/git/blobs/44b4fc6d56897b048c772eb4087f854f46256132",
                    "properties": {
                        "path": {"type": "string"},
                        "mode": {"type": "string"},
                        "type": {"type": "string"},
                        "size": {"type": "integer"},
                        "sha": {"type": "string"},
                        "url": {"type": "string"},
                    },
                    "required": ["path", "mode", "type", "sha", "url", "size"],
                }
            ]
        ),
    ] = None
    """
    Objects specifying a tree structure
    """


class HookResponse(BaseModel):
    code: int | None = None
    status: str | None = None
    message: str | None = None


class Config1(BaseModel):
    email: Annotated[str | None, Field(example='"foo@bar.com"')] = None
    password: Annotated[str | None, Field(example='"foo"')] = None
    room: Annotated[str | None, Field(example='"roomer"')] = None
    subdomain: Annotated[str | None, Field(example='"foo"')] = None
    url: Annotated[AnyUrl | None, Field(example="https://example.com/webhook")] = None
    """
    The URL to which the payloads will be delivered.
    """
    insecure_ssl: str | float | None = None
    content_type: Annotated[str | None, Field(example='"json"')] = None
    """
    The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
    """
    digest: Annotated[str | None, Field(example='"sha256"')] = None
    secret: Annotated[str | None, Field(example='"********"')] = None
    """
    If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).
    """
    token: Annotated[str | None, Field(example='"abc"')] = None


class Hook(BaseModel):
    """
    Webhooks for repositories.
    """

    type: str | None = None
    id: Annotated[int | None, Field(example=42)] = None
    """
    Unique identifier of the webhook.
    """
    name: Annotated[str | None, Field(example="web")] = None
    """
    The name of a valid service, use 'web' for a webhook.
    """
    active: Annotated[bool | None, Field(example=True)] = None
    """
    Determines whether the hook is actually triggered on pushes.
    """
    events: Annotated[
        Sequence[str] | None, Field(example=["push", "pull_request"])
    ] = None
    """
    Determines what events the hook is triggered for. Default: ['push'].
    """
    config: Config1 | None = None
    updated_at: Annotated[datetime | None, Field(example="2011-09-06T20:39:23Z")] = None
    created_at: Annotated[datetime | None, Field(example="2011-09-06T17:26:27Z")] = None
    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/hooks/1"),
    ] = None
    test_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/hooks/1/test"),
    ] = None
    ping_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/hooks/1/pings"),
    ] = None
    deliveries_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/hooks/1/deliveries"
        ),
    ] = None
    last_response: HookResponse | None = None


class Status10(Enum):
    auth = "auth"
    error = "error"
    none = "none"
    detecting = "detecting"
    choose = "choose"
    auth_failed = "auth_failed"
    importing = "importing"
    mapping = "mapping"
    waiting_to_push = "waiting_to_push"
    pushing = "pushing"
    complete = "complete"
    setup = "setup"
    unknown = "unknown"
    detection_found_multiple = "detection_found_multiple"
    detection_found_nothing = "detection_found_nothing"
    detection_needs_auth = "detection_needs_auth"


class ProjectChoice(BaseModel):
    vcs: str | None = None
    tfvc_project: str | None = None
    human_name: str | None = None


class Import(BaseModel):
    """
    A repository import from an external source.
    """

    vcs: str | None = None
    use_lfs: bool | None = None
    vcs_url: str | None = None
    """
    The URL of the originating repository.
    """
    svc_root: str | None = None
    tfvc_project: str | None = None
    status: Status10 | None = None
    status_text: str | None = None
    failed_step: str | None = None
    error_message: str | None = None
    import_percent: int | None = None
    commit_count: int | None = None
    push_percent: int | None = None
    has_large_files: bool | None = None
    large_files_size: int | None = None
    large_files_count: int | None = None
    project_choices: Sequence[ProjectChoice] | None = None
    message: str | None = None
    authors_count: int | None = None
    url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    authors_url: AnyUrl | None = None
    repository_url: AnyUrl | None = None
    svn_root: str | None = None


class PorterAuthor(BaseModel):
    """
    Porter Author
    """

    id: int | None = None
    remote_id: str | None = None
    remote_name: str | None = None
    email: str | None = None
    name: str | None = None
    url: AnyUrl | None = None
    import_url: AnyUrl | None = None


class PorterLargeFile(BaseModel):
    """
    Porter Large File
    """

    ref_name: str | None = None
    path: str | None = None
    oid: str | None = None
    size: int | None = None


class Label2(BaseModel):
    id: int | None = None
    node_id: str | None = None
    url: AnyUrl | None = None
    name: str | None = None
    description: str | None = None
    color: str | None = None
    default: bool | None = None


class NullableIssue(BaseModel):
    """
    Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.
    """

    id: int | None = None
    node_id: str | None = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/repositories/42/issues/1")
    ] = None
    """
    URL for the issue
    """
    repository_url: AnyUrl | None = None
    labels_url: str | None = None
    comments_url: AnyUrl | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    number: Annotated[int | None, Field(example=42)] = None
    """
    Number uniquely identifying the issue within its repository
    """
    state: Annotated[str | None, Field(example="open")] = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: Annotated[StateReason | None, Field(example="not_planned")] = None
    """
    The reason for the current state
    """
    title: Annotated[
        str | None, Field(example="Widget creation fails in Safari on OS X 10.8")
    ] = None
    """
    Title of the issue
    """
    body: Annotated[
        str | None,
        Field(
            example="It looks like the new widget form is broken on Safari. When I try and create the widget, Safari crashes. This is reproducible on 10.8, but not 10.9. Maybe a browser bug?"
        ),
    ] = None
    """
    Contents of the issue
    """
    user: NullableSimpleUser | None = None
    labels: Annotated[
        Sequence[str | Label2] | None, Field(example=["bug", "registration"])
    ] = None
    """
    Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
    """
    assignee: NullableSimpleUser | None = None
    assignees: Sequence[SimpleUser] | None = None
    milestone: NullableMilestone | None = None
    locked: bool | None = None
    active_lock_reason: str | None = None
    comments: int | None = None
    pull_request: PullRequest | None = None
    closed_at: datetime | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    draft: bool | None = None
    closed_by: NullableSimpleUser | None = None
    body_html: str | None = None
    body_text: str | None = None
    timeline_url: AnyUrl | None = None
    repository: Repository | None = None
    performed_via_github_app: NullableIntegration | None = None
    author_association: AuthorAssociation | None = None
    reactions: ReactionRollup | None = None


class IssueEventLabel(BaseModel):
    """
    Issue Event Label
    """

    name: str | None = None
    color: str | None = None


class IssueEventDismissedReview(BaseModel):
    state: str | None = None
    review_id: int | None = None
    dismissal_message: str | None = None
    dismissal_commit_id: str | None = None


class IssueEventMilestone(BaseModel):
    """
    Issue Event Milestone
    """

    title: str | None = None


class IssueEventProjectCard(BaseModel):
    """
    Issue Event Project Card
    """

    url: AnyUrl | None = None
    id: int | None = None
    project_url: AnyUrl | None = None
    project_id: int | None = None
    column_name: str | None = None
    previous_column_name: str | None = None


class IssueEventRename(BaseModel):
    """
    Issue Event Rename
    """

    from_: Annotated[str | None, Field(alias="from")] = None
    to: str | None = None


class IssueEvent(BaseModel):
    """
    Issue Event
    """

    id: Annotated[int | None, Field(example=1)] = None
    node_id: Annotated[str | None, Field(example="MDEwOklzc3VlRXZlbnQx")] = None
    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/issues/events/1"
        ),
    ] = None
    actor: NullableSimpleUser | None = None
    event: Annotated[str | None, Field(example="closed")] = None
    commit_id: Annotated[
        str | None, Field(example="6dcb09b5b57875f334f61aebed695e2e4193db5e")
    ] = None
    commit_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e"
        ),
    ] = None
    created_at: Annotated[datetime | None, Field(example="2011-04-14T16:00:49Z")] = None
    issue: NullableIssue | None = None
    label: IssueEventLabel | None = None
    assignee: NullableSimpleUser | None = None
    assigner: NullableSimpleUser | None = None
    review_requester: NullableSimpleUser | None = None
    requested_reviewer: NullableSimpleUser | None = None
    requested_team: Team | None = None
    dismissed_review: IssueEventDismissedReview | None = None
    milestone: IssueEventMilestone | None = None
    project_card: IssueEventProjectCard | None = None
    rename: IssueEventRename | None = None
    author_association: AuthorAssociation | None = None
    lock_reason: str | None = None
    performed_via_github_app: NullableIntegration | None = None


class Label3(BaseModel):
    name: str | None = None
    color: str | None = None


class LabeledIssueEvent(BaseModel):
    """
    Labeled Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    label: Label3 | None = None


class UnlabeledIssueEvent(BaseModel):
    """
    Unlabeled Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    label: Label3 | None = None


class AssignedIssueEvent(BaseModel):
    """
    Assigned Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: Integration | None = None
    assignee: SimpleUser | None = None
    assigner: SimpleUser | None = None


class UnassignedIssueEvent(BaseModel):
    """
    Unassigned Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    assignee: SimpleUser | None = None
    assigner: SimpleUser | None = None


class Milestone(BaseModel):
    title: str | None = None


class MilestonedIssueEvent(BaseModel):
    """
    Milestoned Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    milestone: Milestone | None = None


class DemilestonedIssueEvent(BaseModel):
    """
    Demilestoned Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    milestone: Milestone | None = None


class Rename(BaseModel):
    from_: Annotated[str | None, Field(alias="from")] = None
    to: str | None = None


class RenamedIssueEvent(BaseModel):
    """
    Renamed Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    rename: Rename | None = None


class ReviewRequestedIssueEvent(BaseModel):
    """
    Review Requested Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    review_requester: SimpleUser | None = None
    requested_team: Team | None = None
    requested_reviewer: SimpleUser | None = None


class ReviewRequestRemovedIssueEvent(BaseModel):
    """
    Review Request Removed Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    review_requester: SimpleUser | None = None
    requested_team: Team | None = None
    requested_reviewer: SimpleUser | None = None


class DismissedReview(BaseModel):
    state: str | None = None
    review_id: int | None = None
    dismissal_message: str | None = None
    dismissal_commit_id: str | None = None


class ReviewDismissedIssueEvent(BaseModel):
    """
    Review Dismissed Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    dismissed_review: DismissedReview | None = None


class LockedIssueEvent(BaseModel):
    """
    Locked Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    lock_reason: Annotated[str | None, Field(example='"off-topic"')] = None


class ProjectCard1(BaseModel):
    id: int | None = None
    url: AnyUrl | None = None
    project_id: int | None = None
    project_url: AnyUrl | None = None
    column_name: str | None = None
    previous_column_name: str | None = None


class AddedToProjectIssueEvent(BaseModel):
    """
    Added to Project Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    project_card: ProjectCard1 | None = None


class MovedColumnInProjectIssueEvent(BaseModel):
    """
    Moved Column in Project Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    project_card: ProjectCard1 | None = None


class RemovedFromProjectIssueEvent(BaseModel):
    """
    Removed from Project Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    project_card: ProjectCard1 | None = None


class ConvertedNoteToIssueIssueEvent(BaseModel):
    """
    Converted Note to Issue Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: Integration | None = None
    project_card: ProjectCard1 | None = None


class IssueEventForIssue(BaseModel):
    __root__: Annotated[
        LabeledIssueEvent
        | UnlabeledIssueEvent
        | AssignedIssueEvent
        | UnassignedIssueEvent
        | MilestonedIssueEvent
        | DemilestonedIssueEvent
        | RenamedIssueEvent
        | ReviewRequestedIssueEvent
        | ReviewRequestRemovedIssueEvent
        | ReviewDismissedIssueEvent
        | LockedIssueEvent
        | AddedToProjectIssueEvent
        | MovedColumnInProjectIssueEvent
        | RemovedFromProjectIssueEvent
        | ConvertedNoteToIssueIssueEvent
        | None,
        Field(title="Issue Event for Issue"),
    ] = None
    """
    Issue Event for Issue
    """


class Label5(BaseModel):
    """
    Color-coded labels help you categorize and filter your issues (just like labels in Gmail).
    """

    id: Annotated[int | None, Field(example=208045946)] = None
    node_id: Annotated[str | None, Field(example="MDU6TGFiZWwyMDgwNDU5NDY=")] = None
    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repositories/42/labels/bug"),
    ] = None
    """
    URL for the label
    """
    name: Annotated[str | None, Field(example="bug")] = None
    """
    The name of the label.
    """
    description: Annotated[str | None, Field(example="Something isn't working")] = None
    color: Annotated[str | None, Field(example="FFFFFF")] = None
    """
    6-character hex code, without the leading #, identifying the color
    """
    default: Annotated[bool | None, Field(example=True)] = None


class TimelineCommentEvent(BaseModel):
    """
    Timeline Comment Event
    """

    event: str | None = None
    actor: SimpleUser | None = None
    id: Annotated[int | None, Field(example=42)] = None
    """
    Unique identifier of the issue comment
    """
    node_id: str | None = None
    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repositories/42/issues/comments/1"),
    ] = None
    """
    URL for the issue comment
    """
    body: Annotated[
        str | None,
        Field(
            example="What version of Safari were you using when you observed this bug?"
        ),
    ] = None
    """
    Contents of the issue comment
    """
    body_text: str | None = None
    body_html: str | None = None
    html_url: AnyUrl | None = None
    user: SimpleUser | None = None
    created_at: Annotated[datetime | None, Field(example="2011-04-14T16:00:49Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2011-04-14T16:00:49Z")] = None
    issue_url: AnyUrl | None = None
    author_association: AuthorAssociation | None = None
    performed_via_github_app: NullableIntegration | None = None
    reactions: ReactionRollup | None = None


class Source(BaseModel):
    type: str | None = None
    issue: Issue | None = None


class TimelineCrossReferencedEvent(BaseModel):
    """
    Timeline Cross Referenced Event
    """

    event: str | None = None
    actor: SimpleUser | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    source: Source | None = None


class TimelineCommittedEvent(BaseModel):
    """
    Timeline Committed Event
    """

    event: str | None = None
    sha: Annotated[
        str | None, Field(example="7638417db6d59f3c431d3e1f261cc637155684cd")
    ] = None
    """
    SHA for the commit
    """
    node_id: str | None = None
    url: AnyUrl | None = None
    author: Author3 | None = None
    """
    Identifying information for the git-user
    """
    committer: Committer3 | None = None
    """
    Identifying information for the git-user
    """
    message: Annotated[str | None, Field(example="Fix #42")] = None
    """
    Message describing the purpose of the commit
    """
    tree: Tree2 | None = None
    parents: Sequence[Parent2] | None = None
    verification: Verification1 | None = None
    html_url: AnyUrl | None = None


class Html(BaseModel):
    href: str | None = None


class PullRequest2(BaseModel):
    href: str | None = None


class FieldLinks10(BaseModel):
    html: Html | None = None
    pull_request: PullRequest2 | None = None


class TimelineReviewedEvent(BaseModel):
    """
    Timeline Reviewed Event
    """

    event: str | None = None
    id: Annotated[int | None, Field(example=42)] = None
    """
    Unique identifier of the review
    """
    node_id: Annotated[
        str | None, Field(example="MDE3OlB1bGxSZXF1ZXN0UmV2aWV3ODA=")
    ] = None
    user: SimpleUser | None = None
    body: Annotated[str | None, Field(example="This looks great.")] = None
    """
    The text of the review.
    """
    state: Annotated[str | None, Field(example="CHANGES_REQUESTED")] = None
    html_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://github.com/octocat/Hello-World/pull/12#pullrequestreview-80"
        ),
    ] = None
    pull_request_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/pulls/12"),
    ] = None
    field_links: Annotated[FieldLinks10 | None, Field(alias="_links")] = None
    submitted_at: datetime | None = None
    commit_id: Annotated[
        str | None, Field(example="54bb654c9e6025347f57900a4a5c2313a96b8035")
    ] = None
    """
    A commit SHA for the review.
    """
    body_html: str | None = None
    body_text: str | None = None
    author_association: AuthorAssociation | None = None


class Self(BaseModel):
    href: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/pulls/comments/1"
        ),
    ] = None


class Html1(BaseModel):
    href: Annotated[
        AnyUrl | None,
        Field(
            example="https://github.com/octocat/Hello-World/pull/1#discussion-diff-1"
        ),
    ] = None


class PullRequest3(BaseModel):
    href: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/pulls/1"),
    ] = None


class FieldLinks11(BaseModel):
    self: Self | None = None
    html: Html1 | None = None
    pull_request: PullRequest3 | None = None


class StartSide(Enum):
    """
    The side of the first line of the range for a multi-line comment.
    """

    LEFT = "LEFT"
    RIGHT = "RIGHT"


class Side(Enum):
    """
    The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment
    """

    LEFT = "LEFT"
    RIGHT = "RIGHT"


class PullRequestReviewComment(BaseModel):
    """
    Pull Request Review Comments are comments on a portion of the Pull Request's diff.
    """

    url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/pulls/comments/1"
        ),
    ] = None
    """
    URL for the pull request review comment
    """
    pull_request_review_id: Annotated[int | None, Field(example=42)] = None
    """
    The ID of the pull request review to which the comment belongs.
    """
    id: Annotated[int | None, Field(example=1)] = None
    """
    The ID of the pull request review comment.
    """
    node_id: Annotated[
        str | None, Field(example="MDI0OlB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudDEw")
    ] = None
    """
    The node ID of the pull request review comment.
    """
    diff_hunk: Annotated[
        str | None,
        Field(example="@@ -16,33 +16,40 @@ public class Connection : IConnection..."),
    ] = None
    """
    The diff of the line that the comment refers to.
    """
    path: Annotated[str | None, Field(example="config/database.yaml")] = None
    """
    The relative path of the file to which the comment applies.
    """
    position: Annotated[int | None, Field(example=1)] = None
    """
    The line index in the diff to which the comment applies. This field is deprecated; use `line` instead.
    """
    original_position: Annotated[int | None, Field(example=4)] = None
    """
    The index of the original line in the diff to which the comment applies. This field is deprecated; use `original_line` instead.
    """
    commit_id: Annotated[
        str | None, Field(example="6dcb09b5b57875f334f61aebed695e2e4193db5e")
    ] = None
    """
    The SHA of the commit to which the comment applies.
    """
    original_commit_id: Annotated[
        str | None, Field(example="9c48853fa3dc5c1c3d6f1f1cd1f2743e72652840")
    ] = None
    """
    The SHA of the original commit to which the comment applies.
    """
    in_reply_to_id: Annotated[int | None, Field(example=8)] = None
    """
    The comment ID to reply to.
    """
    user: SimpleUser | None = None
    body: Annotated[
        str | None,
        Field(example="We should probably include a check for null values here."),
    ] = None
    """
    The text of the comment.
    """
    created_at: Annotated[datetime | None, Field(example="2011-04-14T16:00:49Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2011-04-14T16:00:49Z")] = None
    html_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://github.com/octocat/Hello-World/pull/1#discussion-diff-1"
        ),
    ] = None
    """
    HTML URL for the pull request review comment.
    """
    pull_request_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/pulls/1"),
    ] = None
    """
    URL for the pull request that the review comment belongs to.
    """
    author_association: AuthorAssociation | None = None
    field_links: Annotated[FieldLinks11 | None, Field(alias="_links")] = None
    start_line: Annotated[int | None, Field(example=2)] = None
    """
    The first line of the range for a multi-line comment.
    """
    original_start_line: Annotated[int | None, Field(example=2)] = None
    """
    The first line of the range for a multi-line comment.
    """
    start_side: StartSide | None = "RIGHT"
    """
    The side of the first line of the range for a multi-line comment.
    """
    line: Annotated[int | None, Field(example=2)] = None
    """
    The line of the blob to which the comment applies. The last line of the range for a multi-line comment
    """
    original_line: Annotated[int | None, Field(example=2)] = None
    """
    The line of the blob to which the comment applies. The last line of the range for a multi-line comment
    """
    side: Side | None = "RIGHT"
    """
    The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment
    """
    reactions: ReactionRollup | None = None
    body_html: Annotated[str | None, Field(example='"<p>comment body</p>"')] = None
    body_text: Annotated[str | None, Field(example='"comment body"')] = None


class TimelineLineCommentedEvent(BaseModel):
    """
    Timeline Line Commented Event
    """

    event: str | None = None
    node_id: str | None = None
    comments: Sequence[PullRequestReviewComment] | None = None


class TimelineCommitCommentedEvent(BaseModel):
    """
    Timeline Commit Commented Event
    """

    event: str | None = None
    node_id: str | None = None
    commit_id: str | None = None
    comments: Sequence[CommitComment] | None = None


class TimelineAssignedIssueEvent(BaseModel):
    """
    Timeline Assigned Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    assignee: SimpleUser | None = None


class TimelineUnassignedIssueEvent(BaseModel):
    """
    Timeline Unassigned Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    assignee: SimpleUser | None = None


class StateChangeIssueEvent(BaseModel):
    """
    State Change Issue Event
    """

    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    actor: SimpleUser | None = None
    event: str | None = None
    commit_id: str | None = None
    commit_url: str | None = None
    created_at: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    state_reason: str | None = None


class TimelineIssueEvents(BaseModel):
    __root__: Annotated[
        LabeledIssueEvent
        | UnlabeledIssueEvent
        | MilestonedIssueEvent
        | DemilestonedIssueEvent
        | RenamedIssueEvent
        | ReviewRequestedIssueEvent
        | ReviewRequestRemovedIssueEvent
        | ReviewDismissedIssueEvent
        | LockedIssueEvent
        | AddedToProjectIssueEvent
        | MovedColumnInProjectIssueEvent
        | RemovedFromProjectIssueEvent
        | ConvertedNoteToIssueIssueEvent
        | TimelineCommentEvent
        | TimelineCrossReferencedEvent
        | TimelineCommittedEvent
        | TimelineReviewedEvent
        | TimelineLineCommentedEvent
        | TimelineCommitCommentedEvent
        | TimelineAssignedIssueEvent
        | TimelineUnassignedIssueEvent
        | StateChangeIssueEvent
        | None,
        Field(title="Timeline Event"),
    ] = None
    """
    Timeline Event
    """


class DeployKey(BaseModel):
    """
    An SSH key granting access to a single repository.
    """

    id: int | None = None
    key: str | None = None
    url: str | None = None
    title: str | None = None
    verified: bool | None = None
    created_at: str | None = None
    read_only: bool | None = None
    added_by: str | None = None
    last_used: str | None = None


class Language(BaseModel):
    """
    Language
    """

    __root__: Mapping[str, int] | None = None


class FieldLinks12(BaseModel):
    git: AnyUrl | None = None
    html: AnyUrl | None = None
    self: AnyUrl | None = None


class LicenseContent(BaseModel):
    """
    License Content
    """

    name: str | None = None
    path: str | None = None
    sha: str | None = None
    size: int | None = None
    url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    git_url: AnyUrl | None = None
    download_url: AnyUrl | None = None
    type: str | None = None
    content: str | None = None
    encoding: str | None = None
    field_links: Annotated[FieldLinks12 | None, Field(alias="_links")] = None
    license: NullableLicenseSimple | None = None


class MergeType(Enum):
    merge = "merge"
    fast_forward = "fast-forward"
    none = "none"


class MergedUpstream(BaseModel):
    """
    Results of a successful merge upstream request
    """

    message: str | None = None
    merge_type: MergeType | None = None
    base_branch: str | None = None


class State9(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone2(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/milestones/1"),
    ] = None
    html_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/octocat/Hello-World/milestones/v1.0"),
    ] = None
    labels_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/milestones/1/labels"
        ),
    ] = None
    id: Annotated[int | None, Field(example=1002604)] = None
    node_id: Annotated[str | None, Field(example="MDk6TWlsZXN0b25lMTAwMjYwNA==")] = None
    number: Annotated[int | None, Field(example=42)] = None
    """
    The number of the milestone.
    """
    state: Annotated[State9 | None, Field(example="open")] = "open"
    """
    The state of the milestone.
    """
    title: Annotated[str | None, Field(example="v1.0")] = None
    """
    The title of the milestone.
    """
    description: Annotated[
        str | None, Field(example="Tracking milestone for version 1.0")
    ] = None
    creator: NullableSimpleUser | None = None
    open_issues: Annotated[int | None, Field(example=4)] = None
    closed_issues: Annotated[int | None, Field(example=8)] = None
    created_at: Annotated[datetime | None, Field(example="2011-04-10T20:09:31Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2014-03-03T18:58:10Z")] = None
    closed_at: Annotated[datetime | None, Field(example="2013-02-12T13:22:01Z")] = None
    due_on: Annotated[datetime | None, Field(example="2012-10-09T23:39:01Z")] = None


class PagesSourceHash(BaseModel):
    branch: str | None = None
    path: str | None = None


class State10(Enum):
    new = "new"
    authorization_created = "authorization_created"
    authorization_pending = "authorization_pending"
    authorized = "authorized"
    authorization_revoked = "authorization_revoked"
    issued = "issued"
    uploaded = "uploaded"
    approved = "approved"
    errored = "errored"
    bad_authz = "bad_authz"
    destroy_pending = "destroy_pending"
    dns_changed = "dns_changed"


class PagesHttpsCertificate(BaseModel):
    state: Annotated[State10 | None, Field(example="approved")] = None
    description: Annotated[str | None, Field(example="Certificate is approved")] = None
    domains: Annotated[
        Sequence[str] | None, Field(example=["example.com", "www.example.com"])
    ] = None
    """
    Array of the domain set and its alternate name (if it is configured)
    """
    expires_at: date | None = None


class Status11(Enum):
    """
    The status of the most recent build of the Page.
    """

    built = "built"
    building = "building"
    errored = "errored"


class ProtectedDomainState(Enum):
    """
    The state if the domain is verified
    """

    pending = "pending"
    verified = "verified"
    unverified = "unverified"


class BuildType(Enum):
    """
    The process in which the Page will be built.
    """

    legacy = "legacy"
    workflow = "workflow"


class Page1(BaseModel):
    """
    The configuration for GitHub Pages for a repository.
    """

    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/github/hello-world/pages"),
    ] = None
    """
    The API address for accessing this Page resource.
    """
    status: Annotated[Status11 | None, Field(example="built")] = None
    """
    The status of the most recent build of the Page.
    """
    cname: Annotated[str | None, Field(example="example.com")] = None
    """
    The Pages site's custom domain
    """
    protected_domain_state: Annotated[
        ProtectedDomainState | None, Field(example="pending")
    ] = None
    """
    The state if the domain is verified
    """
    pending_domain_unverified_at: datetime | None = None
    """
    The timestamp when a pending domain becomes unverified.
    """
    custom_404: Annotated[bool | None, Field(example=False)] = False
    """
    Whether the Page has a custom 404 page.
    """
    html_url: Annotated[AnyUrl | None, Field(example="https://example.com")] = None
    """
    The web address the Page can be accessed from.
    """
    build_type: Annotated[BuildType | None, Field(example="legacy")] = None
    """
    The process in which the Page will be built.
    """
    source: PagesSourceHash | None = None
    public: Annotated[bool | None, Field(example=True)] = None
    """
    Whether the GitHub Pages site is publicly visible. If set to `true`, the site is accessible to anyone on the internet. If set to `false`, the site will only be accessible to users who have at least `read` access to the repository that published the site.
    """
    https_certificate: PagesHttpsCertificate | None = None
    https_enforced: Annotated[bool | None, Field(example=True)] = None
    """
    Whether https is enabled on the domain
    """


class Error2(BaseModel):
    message: str | None = None


class PageBuild(BaseModel):
    """
    Page Build
    """

    url: AnyUrl | None = None
    status: str | None = None
    error: Error2 | None = None
    pusher: NullableSimpleUser | None = None
    commit: str | None = None
    duration: int | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None


class PageBuildStatus(BaseModel):
    """
    Page Build Status
    """

    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/pages/builds/latest"
        ),
    ] = None
    status: Annotated[str | None, Field(example="queued")] = None


class PageDeployment(BaseModel):
    """
    The GitHub Pages deployment status.
    """

    status_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/github/hello-world/pages/deployments/4fd754f7e594640989b406850d0bc8f06a121251/status"
        ),
    ] = None
    """
    The URI to monitor GitHub Pages deployment status.
    """
    page_url: Annotated[AnyUrl | None, Field(example="hello-world.github.io")] = None
    """
    The URI to the deployed GitHub Pages.
    """
    preview_url: Annotated[
        AnyUrl | None, Field(example="monalisa-1231a2312sa32-23sda74.drafts.github.io")
    ] = None
    """
    The URI to the deployed GitHub Pages preview.
    """


class Domain(BaseModel):
    host: str | None = None
    uri: str | None = None
    nameservers: str | None = None
    dns_resolves: bool | None = None
    is_proxied: bool | None = None
    is_cloudflare_ip: bool | None = None
    is_fastly_ip: bool | None = None
    is_old_ip_address: bool | None = None
    is_a_record: bool | None = None
    has_cname_record: bool | None = None
    has_mx_records_present: bool | None = None
    is_valid_domain: bool | None = None
    is_apex_domain: bool | None = None
    should_be_a_record: bool | None = None
    is_cname_to_github_user_domain: bool | None = None
    is_cname_to_pages_dot_github_dot_com: bool | None = None
    is_cname_to_fastly: bool | None = None
    is_pointed_to_github_pages_ip: bool | None = None
    is_non_github_pages_ip_present: bool | None = None
    is_pages_domain: bool | None = None
    is_served_by_pages: bool | None = None
    is_valid: bool | None = None
    reason: str | None = None
    responds_to_https: bool | None = None
    enforces_https: bool | None = None
    https_error: str | None = None
    is_https_eligible: bool | None = None
    caa_error: str | None = None


class AltDomain(BaseModel):
    host: str | None = None
    uri: str | None = None
    nameservers: str | None = None
    dns_resolves: bool | None = None
    is_proxied: bool | None = None
    is_cloudflare_ip: bool | None = None
    is_fastly_ip: bool | None = None
    is_old_ip_address: bool | None = None
    is_a_record: bool | None = None
    has_cname_record: bool | None = None
    has_mx_records_present: bool | None = None
    is_valid_domain: bool | None = None
    is_apex_domain: bool | None = None
    should_be_a_record: bool | None = None
    is_cname_to_github_user_domain: bool | None = None
    is_cname_to_pages_dot_github_dot_com: bool | None = None
    is_cname_to_fastly: bool | None = None
    is_pointed_to_github_pages_ip: bool | None = None
    is_non_github_pages_ip_present: bool | None = None
    is_pages_domain: bool | None = None
    is_served_by_pages: bool | None = None
    is_valid: bool | None = None
    reason: str | None = None
    responds_to_https: bool | None = None
    enforces_https: bool | None = None
    https_error: str | None = None
    is_https_eligible: bool | None = None
    caa_error: str | None = None


class PagesHealthCheck(BaseModel):
    """
    Pages Health Check Status
    """

    domain: Domain | None = None
    alt_domain: AltDomain | None = None


class State11(Enum):
    """
    State of this Pull Request. Either `open` or `closed`.
    """

    open = "open"
    closed = "closed"


class Label6(BaseModel):
    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    name: str | None = None
    description: str | None = None
    color: str | None = None
    default: bool | None = None


class Owner3(BaseModel):
    avatar_url: AnyUrl | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    node_id: str | None = None
    login: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: str | None = None
    url: AnyUrl | None = None


class Permissions17(BaseModel):
    admin: bool | None = None
    maintain: bool | None = None
    push: bool | None = None
    triage: bool | None = None
    pull: bool | None = None


class License3(BaseModel):
    key: str | None = None
    name: str | None = None
    url: AnyUrl | None = None
    spdx_id: str | None = None
    node_id: str | None = None


class Repo3(BaseModel):
    archive_url: str | None = None
    assignees_url: str | None = None
    blobs_url: str | None = None
    branches_url: str | None = None
    collaborators_url: str | None = None
    comments_url: str | None = None
    commits_url: str | None = None
    compare_url: str | None = None
    contents_url: str | None = None
    contributors_url: AnyUrl | None = None
    deployments_url: AnyUrl | None = None
    description: str | None = None
    downloads_url: AnyUrl | None = None
    events_url: AnyUrl | None = None
    fork: bool | None = None
    forks_url: AnyUrl | None = None
    full_name: str | None = None
    git_commits_url: str | None = None
    git_refs_url: str | None = None
    git_tags_url: str | None = None
    hooks_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    node_id: str | None = None
    issue_comment_url: str | None = None
    issue_events_url: str | None = None
    issues_url: str | None = None
    keys_url: str | None = None
    labels_url: str | None = None
    languages_url: AnyUrl | None = None
    merges_url: AnyUrl | None = None
    milestones_url: str | None = None
    name: str | None = None
    notifications_url: str | None = None
    owner: Owner3 | None = None
    private: bool | None = None
    pulls_url: str | None = None
    releases_url: str | None = None
    stargazers_url: AnyUrl | None = None
    statuses_url: str | None = None
    subscribers_url: AnyUrl | None = None
    subscription_url: AnyUrl | None = None
    tags_url: AnyUrl | None = None
    teams_url: AnyUrl | None = None
    trees_url: str | None = None
    url: AnyUrl | None = None
    clone_url: str | None = None
    default_branch: str | None = None
    forks: int | None = None
    forks_count: int | None = None
    git_url: str | None = None
    has_downloads: bool | None = None
    has_issues: bool | None = None
    has_projects: bool | None = None
    has_wiki: bool | None = None
    has_pages: bool | None = None
    homepage: AnyUrl | None = None
    language: str | None = None
    master_branch: str | None = None
    archived: bool | None = None
    disabled: bool | None = None
    visibility: str | None = None
    """
    The repository visibility: public, private, or internal.
    """
    mirror_url: AnyUrl | None = None
    open_issues: int | None = None
    open_issues_count: int | None = None
    permissions: Permissions17 | None = None
    temp_clone_token: str | None = None
    allow_merge_commit: bool | None = None
    allow_squash_merge: bool | None = None
    allow_rebase_merge: bool | None = None
    license: License3 | None = None
    pushed_at: datetime | None = None
    size: int | None = None
    ssh_url: str | None = None
    stargazers_count: int | None = None
    svn_url: AnyUrl | None = None
    topics: Sequence[str] | None = None
    watchers: int | None = None
    watchers_count: int | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    allow_forking: bool | None = None
    is_template: bool | None = None
    web_commit_signoff_required: bool | None = None


class User1(BaseModel):
    avatar_url: AnyUrl | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    node_id: str | None = None
    login: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: str | None = None
    url: AnyUrl | None = None


class Head2(BaseModel):
    label: str | None = None
    ref: str | None = None
    repo: Repo3 | None = None
    sha: str | None = None
    user: User1 | None = None


class Repo4(BaseModel):
    archive_url: str | None = None
    assignees_url: str | None = None
    blobs_url: str | None = None
    branches_url: str | None = None
    collaborators_url: str | None = None
    comments_url: str | None = None
    commits_url: str | None = None
    compare_url: str | None = None
    contents_url: str | None = None
    contributors_url: AnyUrl | None = None
    deployments_url: AnyUrl | None = None
    description: str | None = None
    downloads_url: AnyUrl | None = None
    events_url: AnyUrl | None = None
    fork: bool | None = None
    forks_url: AnyUrl | None = None
    full_name: str | None = None
    git_commits_url: str | None = None
    git_refs_url: str | None = None
    git_tags_url: str | None = None
    hooks_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    is_template: bool | None = None
    node_id: str | None = None
    issue_comment_url: str | None = None
    issue_events_url: str | None = None
    issues_url: str | None = None
    keys_url: str | None = None
    labels_url: str | None = None
    languages_url: AnyUrl | None = None
    merges_url: AnyUrl | None = None
    milestones_url: str | None = None
    name: str | None = None
    notifications_url: str | None = None
    owner: Owner3 | None = None
    private: bool | None = None
    pulls_url: str | None = None
    releases_url: str | None = None
    stargazers_url: AnyUrl | None = None
    statuses_url: str | None = None
    subscribers_url: AnyUrl | None = None
    subscription_url: AnyUrl | None = None
    tags_url: AnyUrl | None = None
    teams_url: AnyUrl | None = None
    trees_url: str | None = None
    url: AnyUrl | None = None
    clone_url: str | None = None
    default_branch: str | None = None
    forks: int | None = None
    forks_count: int | None = None
    git_url: str | None = None
    has_downloads: bool | None = None
    has_issues: bool | None = None
    has_projects: bool | None = None
    has_wiki: bool | None = None
    has_pages: bool | None = None
    homepage: AnyUrl | None = None
    language: str | None = None
    master_branch: str | None = None
    archived: bool | None = None
    disabled: bool | None = None
    visibility: str | None = None
    """
    The repository visibility: public, private, or internal.
    """
    mirror_url: AnyUrl | None = None
    open_issues: int | None = None
    open_issues_count: int | None = None
    permissions: Permissions17 | None = None
    temp_clone_token: str | None = None
    allow_merge_commit: bool | None = None
    allow_squash_merge: bool | None = None
    allow_rebase_merge: bool | None = None
    license: NullableLicenseSimple | None = None
    pushed_at: datetime | None = None
    size: int | None = None
    ssh_url: str | None = None
    stargazers_count: int | None = None
    svn_url: AnyUrl | None = None
    topics: Sequence[str] | None = None
    watchers: int | None = None
    watchers_count: int | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    allow_forking: bool | None = None
    web_commit_signoff_required: bool | None = None


class Base2(BaseModel):
    label: str | None = None
    ref: str | None = None
    repo: Repo4 | None = None
    sha: str | None = None
    user: User1 | None = None


class FieldLinks13(BaseModel):
    comments: Link | None = None
    commits: Link | None = None
    statuses: Link | None = None
    html: Link | None = None
    issue: Link | None = None
    review_comments: Link | None = None
    review_comment: Link | None = None
    self: Link | None = None


class PullRequest4(BaseModel):
    """
    Pull requests let you tell others about changes you've pushed to a repository on GitHub. Once a pull request is sent, interested parties can review the set of changes, discuss potential modifications, and even push follow-up commits if necessary.
    """

    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/pulls/1347"),
    ] = None
    id: Annotated[int | None, Field(example=1)] = None
    node_id: Annotated[str | None, Field(example="MDExOlB1bGxSZXF1ZXN0MQ==")] = None
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat/Hello-World/pull/1347")
    ] = None
    diff_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/octocat/Hello-World/pull/1347.diff"),
    ] = None
    patch_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/octocat/Hello-World/pull/1347.patch"),
    ] = None
    issue_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/issues/1347"),
    ] = None
    commits_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/pulls/1347/commits"
        ),
    ] = None
    review_comments_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/pulls/1347/comments"
        ),
    ] = None
    review_comment_url: Annotated[
        str | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/pulls/comments{/number}"
        ),
    ] = None
    comments_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/issues/1347/comments"
        ),
    ] = None
    statuses_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/statuses/6dcb09b5b57875f334f61aebed695e2e4193db5e"
        ),
    ] = None
    number: Annotated[int | None, Field(example=42)] = None
    """
    Number uniquely identifying the pull request within its repository.
    """
    state: Annotated[State11 | None, Field(example="open")] = None
    """
    State of this Pull Request. Either `open` or `closed`.
    """
    locked: Annotated[bool | None, Field(example=True)] = None
    title: Annotated[str | None, Field(example="Amazing new feature")] = None
    """
    The title of the pull request.
    """
    user: NullableSimpleUser | None = None
    body: Annotated[
        str | None, Field(example="Please pull these awesome changes")
    ] = None
    labels: Sequence[Label6] | None = None
    milestone: NullableMilestone | None = None
    active_lock_reason: Annotated[str | None, Field(example="too heated")] = None
    created_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    closed_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    merged_at: Annotated[datetime | None, Field(example="2011-01-26T19:01:12Z")] = None
    merge_commit_sha: Annotated[
        str | None, Field(example="e5bd3914e2e596debea16f433f57875b5b90bcd6")
    ] = None
    assignee: NullableSimpleUser | None = None
    assignees: Sequence[SimpleUser] | None = None
    requested_reviewers: Sequence[SimpleUser] | None = None
    requested_teams: Sequence[TeamSimple] | None = None
    head: Head2 | None = None
    base: Base2 | None = None
    field_links: Annotated[FieldLinks13 | None, Field(alias="_links")] = None
    author_association: AuthorAssociation | None = None
    auto_merge: AutoMerge | None = None
    draft: Annotated[bool | None, Field(example=False)] = None
    """
    Indicates whether or not the pull request is a draft.
    """
    merged: bool | None = None
    mergeable: Annotated[bool | None, Field(example=True)] = None
    rebaseable: Annotated[bool | None, Field(example=True)] = None
    mergeable_state: Annotated[str | None, Field(example="clean")] = None
    merged_by: NullableSimpleUser | None = None
    comments: Annotated[int | None, Field(example=10)] = None
    review_comments: Annotated[int | None, Field(example=0)] = None
    maintainer_can_modify: Annotated[bool | None, Field(example=True)] = None
    """
    Indicates whether maintainers can modify the pull request.
    """
    commits: Annotated[int | None, Field(example=3)] = None
    additions: Annotated[int | None, Field(example=100)] = None
    deletions: Annotated[int | None, Field(example=3)] = None
    changed_files: Annotated[int | None, Field(example=5)] = None


class PullRequestMergeResult(BaseModel):
    """
    Pull Request Merge Result
    """

    sha: str | None = None
    merged: bool | None = None
    message: str | None = None


class PullRequestReviewRequest(BaseModel):
    """
    Pull Request Review Request
    """

    users: Sequence[SimpleUser] | None = None
    teams: Sequence[Team] | None = None


class Html2(BaseModel):
    href: str | None = None


class PullRequest5(BaseModel):
    href: str | None = None


class FieldLinks14(BaseModel):
    html: Html2 | None = None
    pull_request: PullRequest5 | None = None


class PullRequestReview(BaseModel):
    """
    Pull Request Reviews are reviews on pull requests.
    """

    id: Annotated[int | None, Field(example=42)] = None
    """
    Unique identifier of the review
    """
    node_id: Annotated[
        str | None, Field(example="MDE3OlB1bGxSZXF1ZXN0UmV2aWV3ODA=")
    ] = None
    user: NullableSimpleUser | None = None
    body: Annotated[str | None, Field(example="This looks great.")] = None
    """
    The text of the review.
    """
    state: Annotated[str | None, Field(example="CHANGES_REQUESTED")] = None
    html_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://github.com/octocat/Hello-World/pull/12#pullrequestreview-80"
        ),
    ] = None
    pull_request_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/pulls/12"),
    ] = None
    field_links: Annotated[FieldLinks14 | None, Field(alias="_links")] = None
    submitted_at: datetime | None = None
    commit_id: Annotated[
        str | None, Field(example="54bb654c9e6025347f57900a4a5c2313a96b8035")
    ] = None
    """
    A commit SHA for the review.
    """
    body_html: str | None = None
    body_text: str | None = None
    author_association: AuthorAssociation | None = None


class FieldLinks15(BaseModel):
    self: Link | None = None
    html: Link | None = None
    pull_request: Link | None = None


class Side1(Enum):
    """
    The side of the first line of the range for a multi-line comment.
    """

    LEFT = "LEFT"
    RIGHT = "RIGHT"


class ReviewComment(BaseModel):
    """
    Legacy Review Comment
    """

    url: Annotated[
        AnyUrl | None,
        Field(
            example="https://api.github.com/repos/octocat/Hello-World/pulls/comments/1"
        ),
    ] = None
    pull_request_review_id: Annotated[int | None, Field(example=42)] = None
    id: Annotated[int | None, Field(example=10)] = None
    node_id: Annotated[
        str | None, Field(example="MDI0OlB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudDEw")
    ] = None
    diff_hunk: Annotated[
        str | None,
        Field(example="@@ -16,33 +16,40 @@ public class Connection : IConnection..."),
    ] = None
    path: Annotated[str | None, Field(example="file1.txt")] = None
    position: Annotated[int | None, Field(example=1)] = None
    original_position: Annotated[int | None, Field(example=4)] = None
    commit_id: Annotated[
        str | None, Field(example="6dcb09b5b57875f334f61aebed695e2e4193db5e")
    ] = None
    original_commit_id: Annotated[
        str | None, Field(example="9c48853fa3dc5c1c3d6f1f1cd1f2743e72652840")
    ] = None
    in_reply_to_id: Annotated[int | None, Field(example=8)] = None
    user: NullableSimpleUser | None = None
    body: Annotated[str | None, Field(example="Great stuff")] = None
    created_at: Annotated[datetime | None, Field(example="2011-04-14T16:00:49Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2011-04-14T16:00:49Z")] = None
    html_url: Annotated[
        AnyUrl | None,
        Field(
            example="https://github.com/octocat/Hello-World/pull/1#discussion-diff-1"
        ),
    ] = None
    pull_request_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/Hello-World/pulls/1"),
    ] = None
    author_association: AuthorAssociation | None = None
    field_links: Annotated[FieldLinks15 | None, Field(alias="_links")] = None
    body_text: str | None = None
    body_html: str | None = None
    reactions: ReactionRollup | None = None
    side: Side1 | None = "RIGHT"
    """
    The side of the first line of the range for a multi-line comment.
    """
    start_side: StartSide | None = "RIGHT"
    """
    The side of the first line of the range for a multi-line comment.
    """
    line: Annotated[int | None, Field(example=2)] = None
    """
    The line of the blob to which the comment applies. The last line of the range for a multi-line comment
    """
    original_line: Annotated[int | None, Field(example=2)] = None
    """
    The original line of the blob to which the comment applies. The last line of the range for a multi-line comment
    """
    start_line: Annotated[int | None, Field(example=2)] = None
    """
    The first line of the range for a multi-line comment.
    """
    original_start_line: Annotated[int | None, Field(example=2)] = None
    """
    The original first line of the range for a multi-line comment.
    """


class State12(Enum):
    """
    State of the release asset.
    """

    uploaded = "uploaded"
    open = "open"


class ReleaseAsset(BaseModel):
    """
    Data related to a release.
    """

    url: AnyUrl | None = None
    browser_download_url: AnyUrl | None = None
    id: int | None = None
    node_id: str | None = None
    name: Annotated[str | None, Field(example="Team Environment")] = None
    """
    The file name of the asset.
    """
    label: str | None = None
    state: State12 | None = None
    """
    State of the release asset.
    """
    content_type: str | None = None
    size: int | None = None
    download_count: int | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    uploader: NullableSimpleUser | None = None


class Release(BaseModel):
    """
    A release.
    """

    url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    assets_url: AnyUrl | None = None
    upload_url: str | None = None
    tarball_url: AnyUrl | None = None
    zipball_url: AnyUrl | None = None
    id: int | None = None
    node_id: str | None = None
    tag_name: Annotated[str | None, Field(example="v1.0.0")] = None
    """
    The name of the tag.
    """
    target_commitish: Annotated[str | None, Field(example="master")] = None
    """
    Specifies the commitish value that determines where the Git tag is created from.
    """
    name: str | None = None
    body: str | None = None
    draft: Annotated[bool | None, Field(example=False)] = None
    """
    true to create a draft (unpublished) release, false to create a published one.
    """
    prerelease: Annotated[bool | None, Field(example=False)] = None
    """
    Whether to identify the release as a prerelease or a full release.
    """
    created_at: datetime | None = None
    published_at: datetime | None = None
    author: SimpleUser | None = None
    assets: Sequence[ReleaseAsset] | None = None
    body_html: str | None = None
    body_text: str | None = None
    mentions_count: int | None = None
    discussion_url: AnyUrl | None = None
    """
    The URL of the release discussion.
    """
    reactions: ReactionRollup | None = None


class ReleaseNotesContent(BaseModel):
    """
    Generated name and body describing a release
    """

    name: Annotated[
        str | None, Field(example="Release v1.0.0 is now available!")
    ] = None
    """
    The generated name of the release
    """
    body: str | None = None
    """
    The generated body describing the contents of the release supporting markdown formatting
    """


class SecretScanningAlert(BaseModel):
    number: int | None = None
    """
    The security alert number.
    """
    created_at: datetime | None = None
    """
    The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    updated_at: datetime | None = None
    """
    The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    url: AnyUrl | None = None
    """
    The REST API URL of the alert resource.
    """
    html_url: AnyUrl | None = None
    """
    The GitHub URL of the alert resource.
    """
    locations_url: AnyUrl | None = None
    """
    The REST API URL of the code locations for this alert.
    """
    state: SecretScanningAlertState | None = None
    resolution: SecretScanningAlertResolutionEnum | None = None
    """
    **Required when the `state` is `resolved`.** The reason for resolving the alert.
    """
    resolved_at: datetime | None = None
    """
    The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    resolved_by: NullableSimpleUser | None = None
    resolution_comment: str | None = None
    """
    An optional comment to resolve an alert.
    """
    secret_type: str | None = None
    """
    The type of secret that secret scanning detected.
    """
    secret_type_display_name: str | None = None
    """
    User-friendly name for the detected secret, matching the `secret_type`.
    For a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."
    """
    secret: str | None = None
    """
    The secret that was detected.
    """
    push_protection_bypassed: bool | None = None
    """
    Whether push protection was bypassed for the detected secret.
    """
    push_protection_bypassed_by: NullableSimpleUser | None = None
    push_protection_bypassed_at: datetime | None = None
    """
    The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """


class SecretScanningAlertResolutionComment(BaseModel):
    __root__: str | None = None
    """
    An optional comment when closing an alert. Cannot be updated or deleted. Must be `null` when changing `state` to `open`.
    """


class SecretScanningLocationCommit(BaseModel):
    """
    Represents a 'commit' secret scanning location type. This location type shows that a secret was detected inside a commit to a repository.
    """

    path: Annotated[str | None, Field(example="/example/secrets.txt")] = None
    """
    The file path in the repository
    """
    start_line: float | None = None
    """
    Line number at which the secret starts in the file
    """
    end_line: float | None = None
    """
    Line number at which the secret ends in the file
    """
    start_column: float | None = None
    """
    The column at which the secret starts within the start line when the file is interpreted as 8BIT ASCII
    """
    end_column: float | None = None
    """
    The column at which the secret ends within the end line when the file is interpreted as 8BIT ASCII
    """
    blob_sha: Annotated[
        str | None, Field(example="af5626b4a114abcb82d63db7c8082c3c4756e51b")
    ] = None
    """
    SHA-1 hash ID of the associated blob
    """
    blob_url: str | None = None
    """
    The API URL to get the associated blob resource
    """
    commit_sha: Annotated[
        str | None, Field(example="af5626b4a114abcb82d63db7c8082c3c4756e51b")
    ] = None
    """
    SHA-1 hash ID of the associated commit
    """
    commit_url: str | None = None
    """
    The API URL to get the associated commit resource
    """


class Type6(Enum):
    """
    The location type. Because secrets may be found in different types of resources (ie. code, comments, issues), this field identifies the type of resource where the secret was found.
    """

    commit = "commit"


class SecretScanningLocation(BaseModel):
    type: Annotated[Type6 | None, Field(example="commit")] = None
    """
    The location type. Because secrets may be found in different types of resources (ie. code, comments, issues), this field identifies the type of resource where the secret was found.
    """
    details: SecretScanningLocationCommit | None = None


class Stargazer(BaseModel):
    """
    Stargazer
    """

    starred_at: datetime | None = None
    user: NullableSimpleUser | None = None


class CodeFrequencyStat(BaseModel):
    """
    Code Frequency Stat
    """

    __root__: Annotated[Sequence[int] | None, Field(title="Code Frequency Stat")] = None
    """
    Code Frequency Stat
    """


class CommitActivity(BaseModel):
    """
    Commit Activity
    """

    days: Annotated[
        Sequence[int] | None, Field(example=[0, 3, 26, 20, 39, 1, 0])
    ] = None
    total: Annotated[int | None, Field(example=89)] = None
    week: Annotated[int | None, Field(example=1336280400)] = None


class Week(BaseModel):
    w: int | None = None
    a: int | None = None
    d: int | None = None
    c: int | None = None


class ContributorActivity(BaseModel):
    """
    Contributor Activity
    """

    author: NullableSimpleUser | None = None
    total: Annotated[int | None, Field(example=135)] = None
    weeks: Annotated[
        Sequence[Week] | None,
        Field(example=[{"w": "1367712000", "a": 6898, "d": 77, "c": 10}]),
    ] = None


class ParticipationStats(BaseModel):
    all: Sequence[int] | None = None
    owner: Sequence[int] | None = None


class RepositorySubscription(BaseModel):
    """
    Repository invitations let you manage who you collaborate with.
    """

    subscribed: Annotated[bool | None, Field(example=True)] = None
    """
    Determines if notifications should be received from this repository.
    """
    ignored: bool | None = None
    """
    Determines if all notifications should be blocked from this repository.
    """
    reason: str | None = None
    created_at: Annotated[datetime | None, Field(example="2012-10-06T21:34:12Z")] = None
    url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/repos/octocat/example/subscription"),
    ] = None
    repository_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/repos/octocat/example")
    ] = None


class Commit5(BaseModel):
    sha: str | None = None
    url: AnyUrl | None = None


class Tag(BaseModel):
    """
    Tag
    """

    name: Annotated[str | None, Field(example="v0.1")] = None
    commit: Commit5 | None = None
    zipball_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/octocat/Hello-World/zipball/v0.1"),
    ] = None
    tarball_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/octocat/Hello-World/tarball/v0.1"),
    ] = None
    node_id: str | None = None


class TagProtection(BaseModel):
    """
    Tag protection
    """

    id: Annotated[int | None, Field(example=2)] = None
    created_at: Annotated[str | None, Field(example="2011-01-26T19:01:12Z")] = None
    updated_at: Annotated[str | None, Field(example="2011-01-26T19:01:12Z")] = None
    enabled: Annotated[bool | None, Field(example=True)] = None
    pattern: Annotated[str | None, Field(example="v1.*")] = None


class Topic(BaseModel):
    """
    A topic aggregates entities that are related to a subject.
    """

    names: Sequence[str] | None = None


class Traffic(BaseModel):
    timestamp: datetime | None = None
    uniques: int | None = None
    count: int | None = None


class CloneTraffic(BaseModel):
    """
    Clone Traffic
    """

    count: Annotated[int | None, Field(example=173)] = None
    uniques: Annotated[int | None, Field(example=128)] = None
    clones: Sequence[Traffic] | None = None


class ContentTraffic(BaseModel):
    """
    Content Traffic
    """

    path: Annotated[str | None, Field(example="/github/hubot")] = None
    title: Annotated[
        str | None,
        Field(example="github/hubot: A customizable life embetterment robot."),
    ] = None
    count: Annotated[int | None, Field(example=3542)] = None
    uniques: Annotated[int | None, Field(example=2225)] = None


class ReferrerTraffic(BaseModel):
    """
    Referrer Traffic
    """

    referrer: Annotated[str | None, Field(example="Google")] = None
    count: Annotated[int | None, Field(example=4)] = None
    uniques: Annotated[int | None, Field(example=3)] = None


class ViewTraffic(BaseModel):
    """
    View Traffic
    """

    count: Annotated[int | None, Field(example=14850)] = None
    uniques: Annotated[int | None, Field(example=3782)] = None
    views: Sequence[Traffic] | None = None


class Match(BaseModel):
    text: str | None = None
    indices: Sequence[int] | None = None


class SearchResultTextMatch(BaseModel):
    object_url: str | None = None
    object_type: str | None = None
    property: str | None = None
    fragment: str | None = None
    matches: Sequence[Match] | None = None


class CodeSearchResultItem(BaseModel):
    """
    Code Search Result Item
    """

    name: str | None = None
    path: str | None = None
    sha: str | None = None
    url: AnyUrl | None = None
    git_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    repository: MinimalRepository | None = None
    score: float | None = None
    file_size: int | None = None
    language: str | None = None
    last_modified_at: datetime | None = None
    line_numbers: Annotated[
        Sequence[str] | None, Field(example=["73..77", "77..78"])
    ] = None
    text_matches: Annotated[
        Sequence[SearchResultTextMatch] | None,
        Field(title="Search Result Text Matches"),
    ] = None


class Author5(BaseModel):
    name: str | None = None
    email: str | None = None
    date: datetime | None = None


class Tree4(BaseModel):
    sha: str | None = None
    url: AnyUrl | None = None


class Commit6(BaseModel):
    author: Author5 | None = None
    committer: NullableGitUser | None = None
    comment_count: int | None = None
    message: str | None = None
    tree: Tree4 | None = None
    url: AnyUrl | None = None
    verification: Verification | None = None


class Parent4(BaseModel):
    url: str | None = None
    html_url: str | None = None
    sha: str | None = None


class CommitSearchResultItem(BaseModel):
    """
    Commit Search Result Item
    """

    url: AnyUrl | None = None
    sha: str | None = None
    html_url: AnyUrl | None = None
    comments_url: AnyUrl | None = None
    commit: Commit6 | None = None
    author: NullableSimpleUser | None = None
    committer: NullableGitUser | None = None
    parents: Sequence[Parent4] | None = None
    repository: MinimalRepository | None = None
    score: float | None = None
    node_id: str | None = None
    text_matches: Annotated[
        Sequence[SearchResultTextMatch] | None,
        Field(title="Search Result Text Matches"),
    ] = None


class Label7(BaseModel):
    id: int | None = None
    node_id: str | None = None
    url: str | None = None
    name: str | None = None
    color: str | None = None
    default: bool | None = None
    description: str | None = None


class PullRequest6(BaseModel):
    merged_at: datetime | None = None
    diff_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    patch_url: AnyUrl | None = None
    url: AnyUrl | None = None


class IssueSearchResultItem(BaseModel):
    """
    Issue Search Result Item
    """

    url: AnyUrl | None = None
    repository_url: AnyUrl | None = None
    labels_url: str | None = None
    comments_url: AnyUrl | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    node_id: str | None = None
    number: int | None = None
    title: str | None = None
    locked: bool | None = None
    active_lock_reason: str | None = None
    assignees: Sequence[SimpleUser] | None = None
    user: NullableSimpleUser | None = None
    labels: Sequence[Label7] | None = None
    state: str | None = None
    state_reason: str | None = None
    assignee: NullableSimpleUser | None = None
    milestone: NullableMilestone | None = None
    comments: int | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    closed_at: datetime | None = None
    text_matches: Annotated[
        Sequence[SearchResultTextMatch] | None,
        Field(title="Search Result Text Matches"),
    ] = None
    pull_request: PullRequest6 | None = None
    body: str | None = None
    score: float | None = None
    author_association: AuthorAssociation | None = None
    draft: bool | None = None
    repository: Repository | None = None
    body_html: str | None = None
    body_text: str | None = None
    timeline_url: AnyUrl | None = None
    performed_via_github_app: NullableIntegration | None = None
    reactions: ReactionRollup | None = None


class LabelSearchResultItem(BaseModel):
    """
    Label Search Result Item
    """

    id: int | None = None
    node_id: str | None = None
    url: AnyUrl | None = None
    name: str | None = None
    color: str | None = None
    default: bool | None = None
    description: str | None = None
    score: float | None = None
    text_matches: Annotated[
        Sequence[SearchResultTextMatch] | None,
        Field(title="Search Result Text Matches"),
    ] = None


class RepoSearchResultItem(BaseModel):
    """
    Repo Search Result Item
    """

    id: int | None = None
    node_id: str | None = None
    name: str | None = None
    full_name: str | None = None
    owner: NullableSimpleUser | None = None
    private: bool | None = None
    html_url: AnyUrl | None = None
    description: str | None = None
    fork: bool | None = None
    url: AnyUrl | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    pushed_at: datetime | None = None
    homepage: AnyUrl | None = None
    size: int | None = None
    stargazers_count: int | None = None
    watchers_count: int | None = None
    language: str | None = None
    forks_count: int | None = None
    open_issues_count: int | None = None
    master_branch: str | None = None
    default_branch: str | None = None
    score: float | None = None
    forks_url: AnyUrl | None = None
    keys_url: str | None = None
    collaborators_url: str | None = None
    teams_url: AnyUrl | None = None
    hooks_url: AnyUrl | None = None
    issue_events_url: str | None = None
    events_url: AnyUrl | None = None
    assignees_url: str | None = None
    branches_url: str | None = None
    tags_url: AnyUrl | None = None
    blobs_url: str | None = None
    git_tags_url: str | None = None
    git_refs_url: str | None = None
    trees_url: str | None = None
    statuses_url: str | None = None
    languages_url: AnyUrl | None = None
    stargazers_url: AnyUrl | None = None
    contributors_url: AnyUrl | None = None
    subscribers_url: AnyUrl | None = None
    subscription_url: AnyUrl | None = None
    commits_url: str | None = None
    git_commits_url: str | None = None
    comments_url: str | None = None
    issue_comment_url: str | None = None
    contents_url: str | None = None
    compare_url: str | None = None
    merges_url: AnyUrl | None = None
    archive_url: str | None = None
    downloads_url: AnyUrl | None = None
    issues_url: str | None = None
    pulls_url: str | None = None
    milestones_url: str | None = None
    notifications_url: str | None = None
    labels_url: str | None = None
    releases_url: str | None = None
    deployments_url: AnyUrl | None = None
    git_url: str | None = None
    ssh_url: str | None = None
    clone_url: str | None = None
    svn_url: AnyUrl | None = None
    forks: int | None = None
    open_issues: int | None = None
    watchers: int | None = None
    topics: Sequence[str] | None = None
    mirror_url: AnyUrl | None = None
    has_issues: bool | None = None
    has_projects: bool | None = None
    has_pages: bool | None = None
    has_wiki: bool | None = None
    has_downloads: bool | None = None
    archived: bool | None = None
    disabled: bool | None = None
    """
    Returns whether or not this repository disabled.
    """
    visibility: str | None = None
    """
    The repository visibility: public, private, or internal.
    """
    license: NullableLicenseSimple | None = None
    permissions: Permissions17 | None = None
    text_matches: Annotated[
        Sequence[SearchResultTextMatch] | None,
        Field(title="Search Result Text Matches"),
    ] = None
    temp_clone_token: str | None = None
    allow_merge_commit: bool | None = None
    allow_squash_merge: bool | None = None
    allow_rebase_merge: bool | None = None
    allow_auto_merge: bool | None = None
    delete_branch_on_merge: bool | None = None
    allow_forking: bool | None = None
    is_template: bool | None = None
    web_commit_signoff_required: Annotated[bool | None, Field(example=False)] = None


class TopicRelation(BaseModel):
    id: int | None = None
    name: str | None = None
    topic_id: int | None = None
    relation_type: str | None = None


class RelatedItem(BaseModel):
    topic_relation: TopicRelation | None = None


class Alias(BaseModel):
    topic_relation: TopicRelation | None = None


class TopicSearchResultItem(BaseModel):
    """
    Topic Search Result Item
    """

    name: str | None = None
    display_name: str | None = None
    short_description: str | None = None
    description: str | None = None
    created_by: str | None = None
    released: str | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    featured: bool | None = None
    curated: bool | None = None
    score: float | None = None
    repository_count: int | None = None
    logo_url: AnyUrl | None = None
    text_matches: Annotated[
        Sequence[SearchResultTextMatch] | None,
        Field(title="Search Result Text Matches"),
    ] = None
    related: Sequence[RelatedItem] | None = None
    aliases: Sequence[Alias] | None = None


class UserSearchResultItem(BaseModel):
    """
    User Search Result Item
    """

    login: str | None = None
    id: int | None = None
    node_id: str | None = None
    avatar_url: AnyUrl | None = None
    gravatar_id: str | None = None
    url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    followers_url: AnyUrl | None = None
    subscriptions_url: AnyUrl | None = None
    organizations_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    type: str | None = None
    score: float | None = None
    following_url: str | None = None
    gists_url: str | None = None
    starred_url: str | None = None
    events_url: str | None = None
    public_repos: int | None = None
    public_gists: int | None = None
    followers: int | None = None
    following: int | None = None
    created_at: datetime | None = None
    updated_at: datetime | None = None
    name: str | None = None
    bio: str | None = None
    email: EmailStr | None = None
    location: str | None = None
    site_admin: bool | None = None
    hireable: bool | None = None
    text_matches: Annotated[
        Sequence[SearchResultTextMatch] | None,
        Field(title="Search Result Text Matches"),
    ] = None
    blog: str | None = None
    company: str | None = None
    suspended_at: datetime | None = None


class Plan3(BaseModel):
    collaborators: int | None = None
    name: str | None = None
    space: int | None = None
    private_repos: int | None = None


class PrivateUser(BaseModel):
    """
    Private User
    """

    login: Annotated[str | None, Field(example="octocat")] = None
    id: Annotated[int | None, Field(example=1)] = None
    node_id: Annotated[str | None, Field(example="MDQ6VXNlcjE=")] = None
    avatar_url: Annotated[
        AnyUrl | None,
        Field(example="https://github.com/images/error/octocat_happy.gif"),
    ] = None
    gravatar_id: Annotated[
        str | None, Field(example="41d064eb2195891e12d0413f63227ea7")
    ] = None
    url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat")
    ] = None
    html_url: Annotated[
        AnyUrl | None, Field(example="https://github.com/octocat")
    ] = None
    followers_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/followers")
    ] = None
    following_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/following{/other_user}"),
    ] = None
    gists_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/gists{/gist_id}"),
    ] = None
    starred_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/starred{/owner}{/repo}"),
    ] = None
    subscriptions_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/users/octocat/subscriptions"),
    ] = None
    organizations_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/orgs")
    ] = None
    repos_url: Annotated[
        AnyUrl | None, Field(example="https://api.github.com/users/octocat/repos")
    ] = None
    events_url: Annotated[
        str | None,
        Field(example="https://api.github.com/users/octocat/events{/privacy}"),
    ] = None
    received_events_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/users/octocat/received_events"),
    ] = None
    type: Annotated[str | None, Field(example="User")] = None
    site_admin: bool | None = None
    name: Annotated[str | None, Field(example="monalisa octocat")] = None
    company: Annotated[str | None, Field(example="GitHub")] = None
    blog: Annotated[str | None, Field(example="https://github.com/blog")] = None
    location: Annotated[str | None, Field(example="San Francisco")] = None
    email: Annotated[EmailStr | None, Field(example="octocat@github.com")] = None
    hireable: bool | None = None
    bio: Annotated[str | None, Field(example="There once was...")] = None
    twitter_username: Annotated[str | None, Field(example="monalisa")] = None
    public_repos: Annotated[int | None, Field(example=2)] = None
    public_gists: Annotated[int | None, Field(example=1)] = None
    followers: Annotated[int | None, Field(example=20)] = None
    following: Annotated[int | None, Field(example=0)] = None
    created_at: Annotated[datetime | None, Field(example="2008-01-14T04:33:35Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2008-01-14T04:33:35Z")] = None
    private_gists: Annotated[int | None, Field(example=81)] = None
    total_private_repos: Annotated[int | None, Field(example=100)] = None
    owned_private_repos: Annotated[int | None, Field(example=100)] = None
    disk_usage: Annotated[int | None, Field(example=10000)] = None
    collaborators: Annotated[int | None, Field(example=8)] = None
    two_factor_authentication: Annotated[bool | None, Field(example=True)] = None
    plan: Plan3 | None = None
    suspended_at: datetime | None = None
    business_plus: bool | None = None
    ldap_dn: str | None = None


class Visibility4(Enum):
    """
    The type of repositories in the organization that the secret is visible to
    """

    all = "all"
    private = "private"
    selected = "selected"


class CodespacesSecret(BaseModel):
    """
    Secrets for a GitHub Codespace.
    """

    name: Annotated[str | None, Field(example="SECRET_NAME")] = None
    """
    The name of the secret
    """
    created_at: datetime | None = None
    """
    The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
    """
    updated_at: datetime | None = None
    """
    The date and time at which the secret was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
    """
    visibility: Visibility4 | None = None
    """
    The type of repositories in the organization that the secret is visible to
    """
    selected_repositories_url: Annotated[
        AnyUrl | None,
        Field(example="https://api.github.com/user/secrets/SECRET_NAME/repositories"),
    ] = None
    """
    The API URL at which the list of repositories this secret is visible to can be retrieved
    """


class CodespacesUserPublicKey(BaseModel):
    """
    The public key used for setting user Codespaces' Secrets.
    """

    key_id: Annotated[str | None, Field(example="1234567")] = None
    """
    The identifier for the key.
    """
    key: Annotated[
        str | None, Field(example="hBT5WZEj8ZoOv6TYJsfWq7MxTEQopZO5/IT3ZCVQPzs=")
    ] = None
    """
    The Base64 encoded public key.
    """


class CodespaceExportDetails(BaseModel):
    """
    An export of a codespace. Also, latest export details for a codespace can be fetched with id = latest
    """

    state: Annotated[
        str | None, Field(example="succeeded | failed | in_progress")
    ] = None
    """
    State of the latest export
    """
    completed_at: Annotated[
        datetime | None, Field(example="2021-01-01T19:01:12Z")
    ] = None
    """
    Completion time of the last export operation
    """
    branch: Annotated[
        str | None, Field(example="codespace-monalisa-octocat-hello-world-g4wpq6h95q")
    ] = None
    """
    Name of the exported branch
    """
    sha: Annotated[
        str | None, Field(example="fd95a81ca01e48ede9f39c799ecbcef817b8a3b2")
    ] = None
    """
    Git commit SHA of the exported branch
    """
    id: Annotated[str | None, Field(example="latest")] = None
    """
    Id for the export details
    """
    export_url: Annotated[
        str | None,
        Field(example="https://api.github.com/user/codespaces/:name/exports/latest"),
    ] = None
    """
    Url for fetching export details
    """
    html_url: Annotated[
        str | None, Field(example="https://github.com/octocat/hello-world/tree/:branch")
    ] = None
    """
    Web url for the exported branch
    """


class Email(BaseModel):
    """
    Email
    """

    email: Annotated[EmailStr | None, Field(example="octocat@github.com")] = None
    primary: Annotated[bool | None, Field(example=True)] = None
    verified: Annotated[bool | None, Field(example=True)] = None
    visibility: Annotated[str | None, Field(example="public")] = None


class Email1(BaseModel):
    email: str | None = None
    verified: bool | None = None


class Subkey(BaseModel):
    id: int | None = None
    primary_key_id: int | None = None
    key_id: str | None = None
    public_key: str | None = None
    emails: Sequence | None = None
    subkeys: Sequence | None = None
    can_sign: bool | None = None
    can_encrypt_comms: bool | None = None
    can_encrypt_storage: bool | None = None
    can_certify: bool | None = None
    created_at: str | None = None
    expires_at: str | None = None
    raw_key: str | None = None
    revoked: bool | None = None


class GpgKey(BaseModel):
    """
    A unique encryption key
    """

    id: Annotated[int | None, Field(example=3)] = None
    name: Annotated[str | None, Field(example="Octocat's GPG Key")] = None
    primary_key_id: int | None = None
    key_id: Annotated[str | None, Field(example="3262EFF25BA0D270")] = None
    public_key: Annotated[str | None, Field(example="xsBNBFayYZ...")] = None
    emails: Annotated[
        Sequence[Email1] | None,
        Field(
            example=[{"email": "octocat@users.noreply.github.com", "verified": True}]
        ),
    ] = None
    subkeys: Annotated[
        Sequence[Subkey] | None,
        Field(
            example=[
                {
                    "id": 4,
                    "primary_key_id": 3,
                    "key_id": "4A595D4C72EE49C7",
                    "public_key": "zsBNBFayYZ...",
                    "emails": [],
                    "subkeys": [],
                    "can_sign": False,
                    "can_encrypt_comms": True,
                    "can_encrypt_storage": True,
                    "can_certify": False,
                    "created_at": "2016-03-24T11:31:04-06:00",
                    "expires_at": None,
                    "revoked": False,
                }
            ]
        ),
    ] = None
    can_sign: Annotated[bool | None, Field(example=True)] = None
    can_encrypt_comms: bool | None = None
    can_encrypt_storage: bool | None = None
    can_certify: Annotated[bool | None, Field(example=True)] = None
    created_at: Annotated[
        datetime | None, Field(example="2016-03-24T11:31:04-06:00")
    ] = None
    expires_at: datetime | None = None
    revoked: Annotated[bool | None, Field(example=True)] = None
    raw_key: str | None = None


class Key(BaseModel):
    """
    Key
    """

    key: str | None = None
    id: int | None = None
    url: str | None = None
    title: str | None = None
    created_at: datetime | None = None
    verified: bool | None = None
    read_only: bool | None = None


class MarketplaceAccount(BaseModel):
    url: AnyUrl | None = None
    id: int | None = None
    type: str | None = None
    node_id: str | None = None
    login: str | None = None
    email: EmailStr | None = None
    organization_billing_email: EmailStr | None = None


class UserMarketplacePurchase(BaseModel):
    """
    User Marketplace Purchase
    """

    billing_cycle: Annotated[str | None, Field(example="monthly")] = None
    next_billing_date: Annotated[
        datetime | None, Field(example="2017-11-11T00:00:00Z")
    ] = None
    unit_count: int | None = None
    on_free_trial: Annotated[bool | None, Field(example=True)] = None
    free_trial_ends_on: Annotated[
        datetime | None, Field(example="2017-11-11T00:00:00Z")
    ] = None
    updated_at: Annotated[datetime | None, Field(example="2017-11-02T01:12:12Z")] = None
    account: MarketplaceAccount | None = None
    plan: MarketplaceListingPlan | None = None


class SshSigningKey(BaseModel):
    """
    A public SSH key used to sign Git commits
    """

    key: str | None = None
    id: int | None = None
    title: str | None = None
    created_at: datetime | None = None


class StarredRepository(BaseModel):
    """
    Starred Repository
    """

    starred_at: datetime | None = None
    repo: Repository | None = None


class Context(BaseModel):
    message: str | None = None
    octicon: str | None = None


class Hovercard(BaseModel):
    """
    Hovercard
    """

    contexts: Sequence[Context] | None = None


class KeySimple(BaseModel):
    """
    Key Simple
    """

    id: int | None = None
    key: str | None = None


class SimpleInstallation(BaseModel):
    """
    Simple Installation
    """

    id: Annotated[int | None, Field(example=1)] = None
    """
    The ID of the installation.
    """
    node_id: Annotated[str | None, Field(example="MDQ6VXNlcjU4MzIzMQ==")] = None
    """
    The global node ID of the installation.
    """


class Conclusion3(Enum):
    success = "success"
    failure = "failure"
    neutral = "neutral"
    cancelled = "cancelled"
    skipped = "skipped"
    timed_out = "timed_out"
    action_required = "action_required"
    stale = "stale"
    startup_failure = "startup_failure"


class Status12(Enum):
    queued = "queued"
    in_progress = "in_progress"
    completed = "completed"
    pending = "pending"
    waiting = "waiting"


class SimpleCheckSuite(BaseModel):
    """
    A suite of checks performed on the code of a given code change
    """

    after: Annotated[
        str | None, Field(example="d6fde92930d4715a2b49857d24b940956b26d2d3")
    ] = None
    app: Integration | None = None
    before: Annotated[
        str | None, Field(example="146e867f55c26428e5f9fade55a9bbf5e95a7912")
    ] = None
    conclusion: Annotated[Conclusion3 | None, Field(example="neutral")] = None
    created_at: datetime | None = None
    head_branch: Annotated[str | None, Field(example="master")] = None
    head_sha: Annotated[
        str | None, Field(example="009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d")
    ] = None
    """
    The SHA of the head commit that is being checked.
    """
    id: Annotated[int | None, Field(example=5)] = None
    node_id: Annotated[str | None, Field(example="MDEwOkNoZWNrU3VpdGU1")] = None
    pull_requests: Sequence[PullRequestMinimal] | None = None
    repository: MinimalRepository | None = None
    status: Annotated[Status12 | None, Field(example="completed")] = None
    updated_at: datetime | None = None
    url: Annotated[
        str | None,
        Field(example="https://api.github.com/repos/github/hello-world/check-suites/5"),
    ] = None


class Conclusion4(Enum):
    waiting = "waiting"
    pending = "pending"
    startup_failure = "startup_failure"
    stale = "stale"
    success = "success"
    failure = "failure"
    neutral = "neutral"
    cancelled = "cancelled"
    skipped = "skipped"
    timed_out = "timed_out"
    action_required = "action_required"


class Output1(BaseModel):
    annotations_count: int | None = None
    annotations_url: AnyUrl | None = None
    summary: str | None = None
    text: str | None = None
    title: str | None = None


class Status13(Enum):
    """
    The phase of the lifecycle that the check is currently in.
    """

    queued = "queued"
    in_progress = "in_progress"
    completed = "completed"
    pending = "pending"


class CheckRunWithSimpleCheckSuite(BaseModel):
    """
    A check performed on the code of a given code change
    """

    app: NullableIntegration | None = None
    check_suite: SimpleCheckSuite | None = None
    completed_at: Annotated[
        datetime | None, Field(example="2018-05-04T01:14:52Z")
    ] = None
    conclusion: Annotated[Conclusion4 | None, Field(example="neutral")] = None
    deployment: DeploymentSimple | None = None
    details_url: Annotated[str | None, Field(example="https://example.com")] = None
    external_id: Annotated[str | None, Field(example="42")] = None
    head_sha: Annotated[
        str | None, Field(example="009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d")
    ] = None
    """
    The SHA of the commit that is being checked.
    """
    html_url: Annotated[
        str | None, Field(example="https://github.com/github/hello-world/runs/4")
    ] = None
    id: Annotated[int | None, Field(example=21)] = None
    """
    The id of the check.
    """
    name: Annotated[str | None, Field(example="test-coverage")] = None
    """
    The name of the check.
    """
    node_id: Annotated[str | None, Field(example="MDg6Q2hlY2tSdW40")] = None
    output: Output1 | None = None
    pull_requests: Sequence[PullRequestMinimal] | None = None
    started_at: Annotated[datetime | None, Field(example="2018-05-04T01:14:52Z")] = None
    status: Annotated[Status13 | None, Field(example="queued")] = None
    """
    The phase of the lifecycle that the check is currently in.
    """
    url: Annotated[
        str | None,
        Field(example="https://api.github.com/repos/github/hello-world/check-runs/4"),
    ] = None


class ProjectsV2ItemContentType(Enum):
    """
    The type of content tracked in a project item
    """

    Issue = "Issue"
    PullRequest = "PullRequest"
    DraftIssue = "DraftIssue"


class ProjectsV2Item(BaseModel):
    """
    An item belonging to a project
    """

    id: float | None = None
    node_id: str | None = None
    project_node_id: str | None = None
    content_node_id: str | None = None
    content_type: ProjectsV2ItemContentType | None = None
    creator: SimpleUser | None = None
    created_at: Annotated[datetime | None, Field(example="2022-04-28T12:00:00Z")] = None
    updated_at: Annotated[datetime | None, Field(example="2022-04-28T12:00:00Z")] = None
    archived_at: Annotated[
        datetime | None, Field(example="2022-04-28T12:00:00Z")
    ] = None


class Action(Enum):
    created = "created"


class AllowDeletionsEnforcementLevel(Enum):
    off = "off"
    non_admins = "non_admins"
    everyone = "everyone"


class AllowForcePushesEnforcementLevel(Enum):
    off = "off"
    non_admins = "non_admins"
    everyone = "everyone"


class LinearHistoryRequirementEnforcementLevel(Enum):
    off = "off"
    non_admins = "non_admins"
    everyone = "everyone"


class MergeQueueEnforcementLevel(Enum):
    off = "off"
    non_admins = "non_admins"
    everyone = "everyone"


class PullRequestReviewsEnforcementLevel(Enum):
    off = "off"
    non_admins = "non_admins"
    everyone = "everyone"


class RequiredConversationResolutionLevel(Enum):
    off = "off"
    non_admins = "non_admins"
    everyone = "everyone"


class RequiredDeploymentsEnforcementLevel(Enum):
    off = "off"
    non_admins = "non_admins"
    everyone = "everyone"


class RequiredStatusChecksEnforcementLevel(Enum):
    off = "off"
    non_admins = "non_admins"
    everyone = "everyone"


class SignatureRequirementEnforcementLevel(Enum):
    off = "off"
    non_admins = "non_admins"
    everyone = "everyone"


class Rule(BaseModel):
    """
    The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.
    """

    admin_enforced: bool | None = None
    allow_deletions_enforcement_level: AllowDeletionsEnforcementLevel | None = None
    allow_force_pushes_enforcement_level: AllowForcePushesEnforcementLevel | None = None
    authorized_actor_names: Sequence[str] | None = None
    authorized_actors_only: bool | None = None
    authorized_dismissal_actors_only: bool | None = None
    create_protected: bool | None = None
    created_at: datetime | None = None
    dismiss_stale_reviews_on_push: bool | None = None
    id: int | None = None
    ignore_approvals_from_contributors: bool | None = None
    linear_history_requirement_enforcement_level: LinearHistoryRequirementEnforcementLevel | None = (
        None
    )
    merge_queue_enforcement_level: MergeQueueEnforcementLevel | None = None
    name: str | None = None
    pull_request_reviews_enforcement_level: PullRequestReviewsEnforcementLevel | None = (
        None
    )
    repository_id: int | None = None
    require_code_owner_review: bool | None = None
    required_approving_review_count: int | None = None
    required_conversation_resolution_level: RequiredConversationResolutionLevel | None = (
        None
    )
    required_deployments_enforcement_level: RequiredDeploymentsEnforcementLevel | None = (
        None
    )
    required_status_checks: Sequence[str] | None = None
    required_status_checks_enforcement_level: RequiredStatusChecksEnforcementLevel | None = (
        None
    )
    signature_requirement_enforcement_level: SignatureRequirementEnforcementLevel | None = (
        None
    )
    strict_required_status_checks_policy: bool | None = None
    updated_at: datetime | None = None


class WebhookBranchProtectionRuleCreated(BaseModel):
    action: Action | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    rule: Annotated[Rule | None, Field(title="branch protection rule")] = None
    """
    The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.
    """
    sender: SimpleUser | None = None


class Action1(Enum):
    deleted = "deleted"


class Rule1(BaseModel):
    """
    The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.
    """

    admin_enforced: bool | None = None
    allow_deletions_enforcement_level: AllowDeletionsEnforcementLevel | None = None
    allow_force_pushes_enforcement_level: AllowForcePushesEnforcementLevel | None = None
    authorized_actor_names: Sequence[str] | None = None
    authorized_actors_only: bool | None = None
    authorized_dismissal_actors_only: bool | None = None
    create_protected: bool | None = None
    created_at: datetime | None = None
    dismiss_stale_reviews_on_push: bool | None = None
    id: int | None = None
    ignore_approvals_from_contributors: bool | None = None
    linear_history_requirement_enforcement_level: LinearHistoryRequirementEnforcementLevel | None = (
        None
    )
    merge_queue_enforcement_level: MergeQueueEnforcementLevel | None = None
    name: str | None = None
    pull_request_reviews_enforcement_level: PullRequestReviewsEnforcementLevel | None = (
        None
    )
    repository_id: int | None = None
    require_code_owner_review: bool | None = None
    required_approving_review_count: int | None = None
    required_conversation_resolution_level: RequiredConversationResolutionLevel | None = (
        None
    )
    required_deployments_enforcement_level: RequiredDeploymentsEnforcementLevel | None = (
        None
    )
    required_status_checks: Sequence[str] | None = None
    required_status_checks_enforcement_level: RequiredStatusChecksEnforcementLevel | None = (
        None
    )
    signature_requirement_enforcement_level: SignatureRequirementEnforcementLevel | None = (
        None
    )
    strict_required_status_checks_policy: bool | None = None
    updated_at: datetime | None = None


class WebhookBranchProtectionRuleDeleted(BaseModel):
    action: Action1 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    rule: Annotated[Rule1 | None, Field(title="branch protection rule")] = None
    """
    The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.
    """
    sender: SimpleUser | None = None


class Action2(Enum):
    edited = "edited"


class AdminEnforced(BaseModel):
    from_: Annotated[bool | None, Field(alias="from")] = None


class AuthorizedActorNames(BaseModel):
    from_: Annotated[Sequence[str] | None, Field(alias="from")] = None


class AuthorizedActorsOnly(BaseModel):
    from_: Annotated[bool | None, Field(alias="from")] = None


class AuthorizedDismissalActorsOnly(BaseModel):
    from_: Annotated[bool | None, Field(alias="from")] = None


class From(Enum):
    off = "off"
    non_admins = "non_admins"
    everyone = "everyone"


class LinearHistoryRequirementEnforcementLevel2(BaseModel):
    from_: Annotated[From | None, Field(alias="from")] = None


class RequiredStatusChecks(BaseModel):
    from_: Annotated[Sequence[str] | None, Field(alias="from")] = None


class RequiredStatusChecksEnforcementLevel2(BaseModel):
    from_: Annotated[From | None, Field(alias="from")] = None


class Changes(BaseModel):
    """
    If the action was `edited`, the changes to the rule.
    """

    admin_enforced: AdminEnforced | None = None
    authorized_actor_names: AuthorizedActorNames | None = None
    authorized_actors_only: AuthorizedActorsOnly | None = None
    authorized_dismissal_actors_only: AuthorizedDismissalActorsOnly | None = None
    linear_history_requirement_enforcement_level: LinearHistoryRequirementEnforcementLevel2 | None = (
        None
    )
    required_status_checks: RequiredStatusChecks | None = None
    required_status_checks_enforcement_level: RequiredStatusChecksEnforcementLevel2 | None = (
        None
    )


class LinearHistoryRequirementEnforcementLevel3(Enum):
    off = "off"
    non_admins = "non_admins"
    everyone = "everyone"


class RequiredStatusChecksEnforcementLevel3(Enum):
    off = "off"
    non_admins = "non_admins"
    everyone = "everyone"


class Rule2(BaseModel):
    """
    The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.
    """

    admin_enforced: bool | None = None
    allow_deletions_enforcement_level: AllowDeletionsEnforcementLevel | None = None
    allow_force_pushes_enforcement_level: AllowForcePushesEnforcementLevel | None = None
    authorized_actor_names: Sequence[str] | None = None
    authorized_actors_only: bool | None = None
    authorized_dismissal_actors_only: bool | None = None
    create_protected: bool | None = None
    created_at: datetime | None = None
    dismiss_stale_reviews_on_push: bool | None = None
    id: int | None = None
    ignore_approvals_from_contributors: bool | None = None
    linear_history_requirement_enforcement_level: LinearHistoryRequirementEnforcementLevel3 | None = (
        None
    )
    merge_queue_enforcement_level: MergeQueueEnforcementLevel | None = None
    name: str | None = None
    pull_request_reviews_enforcement_level: PullRequestReviewsEnforcementLevel | None = (
        None
    )
    repository_id: int | None = None
    require_code_owner_review: bool | None = None
    required_approving_review_count: int | None = None
    required_conversation_resolution_level: RequiredConversationResolutionLevel | None = (
        None
    )
    required_deployments_enforcement_level: RequiredDeploymentsEnforcementLevel | None = (
        None
    )
    required_status_checks: Sequence[str] | None = None
    required_status_checks_enforcement_level: RequiredStatusChecksEnforcementLevel3 | None = (
        None
    )
    signature_requirement_enforcement_level: SignatureRequirementEnforcementLevel | None = (
        None
    )
    strict_required_status_checks_policy: bool | None = None
    updated_at: datetime | None = None


class WebhookBranchProtectionRuleEdited(BaseModel):
    action: Action2 | None = None
    changes: Changes | None = None
    """
    If the action was `edited`, the changes to the rule.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    rule: Annotated[Rule2 | None, Field(title="branch protection rule")] = None
    """
    The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.
    """
    sender: SimpleUser | None = None


class Action3(Enum):
    completed = "completed"


class WebhookCheckRunCompleted(BaseModel):
    """
    The status of the check run is now `completed`.
    """

    action: Action3 | None = None
    check_run: CheckRunWithSimpleCheckSuite | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class WebhookCheckRunCompletedFormEncoded(BaseModel):
    """
    The check_run.completed webhook encoded with URL encoding
    """

    payload: str | None = None
    """
    A URL-encoded string of the check_run.completed JSON payload. The decoded payload is a JSON object.
    """


class Action4(Enum):
    created = "created"


class WebhookCheckRunCreated(BaseModel):
    """
    A new check run was created.
    """

    action: Action4 | None = None
    check_run: CheckRunWithSimpleCheckSuite | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class WebhookCheckRunCreatedFormEncoded(BaseModel):
    """
    The check_run.created webhook encoded with URL encoding
    """

    payload: str | None = None
    """
    A URL-encoded string of the check_run.created JSON payload. The decoded payload is a JSON object.
    """


class Action5(Enum):
    completed = "completed"


class Event1(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"
    merge_group = "merge_group"
    pull_request_review_thread = "pull_request_review_thread"
    workflow_job = "workflow_job"
    merge_queue_entry = "merge_queue_entry"
    security_and_analysis = "security_and_analysis"
    projects_v2_item = "projects_v2_item"
    secret_scanning_alert_location = "secret_scanning_alert_location"


class Type7(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Owner5(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Actions1(Enum):
    read = "read"
    write = "write"


class Administration1(Enum):
    read = "read"
    write = "write"


class Checks1(Enum):
    read = "read"
    write = "write"


class ContentReferences(Enum):
    read = "read"
    write = "write"


class Contents1(Enum):
    read = "read"
    write = "write"


class Deployments1(Enum):
    read = "read"
    write = "write"


class Discussions(Enum):
    read = "read"
    write = "write"


class Emails(Enum):
    read = "read"
    write = "write"


class Environments1(Enum):
    read = "read"
    write = "write"


class Issues2(Enum):
    read = "read"
    write = "write"


class Keys(Enum):
    read = "read"
    write = "write"


class Members1(Enum):
    read = "read"
    write = "write"


class Metadata3(Enum):
    read = "read"
    write = "write"


class OrganizationAdministration1(Enum):
    read = "read"
    write = "write"


class OrganizationHooks1(Enum):
    read = "read"
    write = "write"


class OrganizationPackages1(Enum):
    read = "read"
    write = "write"


class OrganizationPlan1(Enum):
    read = "read"
    write = "write"


class OrganizationProjects1(Enum):
    read = "read"
    write = "write"
    admin = "admin"


class OrganizationSecrets1(Enum):
    read = "read"
    write = "write"


class OrganizationSelfHostedRunners1(Enum):
    read = "read"
    write = "write"


class OrganizationUserBlocking1(Enum):
    read = "read"
    write = "write"


class Packages1(Enum):
    read = "read"
    write = "write"


class Pages2(Enum):
    read = "read"
    write = "write"


class PullRequests1(Enum):
    read = "read"
    write = "write"


class RepositoryHooks1(Enum):
    read = "read"
    write = "write"


class RepositoryProjects1(Enum):
    read = "read"
    write = "write"
    admin = "admin"


class SecretScanningAlerts1(Enum):
    read = "read"
    write = "write"


class Secrets1(Enum):
    read = "read"
    write = "write"


class SecurityEvents1(Enum):
    read = "read"
    write = "write"


class SecurityScanningAlert(Enum):
    read = "read"
    write = "write"


class SingleFile1(Enum):
    read = "read"
    write = "write"


class Statuses1(Enum):
    read = "read"
    write = "write"


class TeamDiscussions1(Enum):
    read = "read"
    write = "write"


class VulnerabilityAlerts1(Enum):
    read = "read"
    write = "write"


class Workflows1(Enum):
    read = "read"
    write = "write"


class Permissions20(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects1 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects1 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class App2(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event1] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner5 | None, Field(title="User")] = None
    permissions: Permissions20 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Conclusion5Enum(Enum):
    """
    The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has `completed`.
    """

    success = "success"
    failure = "failure"
    neutral = "neutral"
    cancelled = "cancelled"
    timed_out = "timed_out"
    action_required = "action_required"
    stale = "stale"
    skipped = "skipped"
    startup_failure = "startup_failure"


class Author6(BaseModel):
    """
    Metaproperties for Git author/committer information.
    """

    date: datetime | None = None
    email: EmailStr | None = None
    name: str | None = None
    """
    The git author's name.
    """
    username: str | None = None


class Committer5(BaseModel):
    """
    Metaproperties for Git author/committer information.
    """

    date: datetime | None = None
    email: EmailStr | None = None
    name: str | None = None
    """
    The git author's name.
    """
    username: str | None = None


class HeadCommit(BaseModel):
    author: Annotated[Author6 | None, Field(title="Committer")] = None
    """
    Metaproperties for Git author/committer information.
    """
    committer: Annotated[Committer5 | None, Field(title="Committer")] = None
    """
    Metaproperties for Git author/committer information.
    """
    id: str | None = None
    message: str | None = None
    timestamp: str | None = None
    tree_id: str | None = None


class Repo5(BaseModel):
    id: int | None = None
    name: str | None = None
    url: AnyUrl | None = None


class Base3(BaseModel):
    ref: str | None = None
    repo: Annotated[Repo5 | None, Field(title="Repo Ref")] = None
    sha: str | None = None


class Head3(BaseModel):
    ref: str | None = None
    repo: Annotated[Repo5 | None, Field(title="Repo Ref")] = None
    sha: str | None = None


class PullRequest7(BaseModel):
    base: Base3 | None = None
    head: Head3 | None = None
    id: int | None = None
    number: int | None = None
    url: AnyUrl | None = None


class Status14Enum(Enum):
    """
    The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.
    """

    requested = "requested"
    in_progress = "in_progress"
    completed = "completed"
    queued = "queued"
    pending = "pending"


class CheckSuite2(BaseModel):
    """
    The [check_suite](https://docs.github.com/en/rest/reference/checks#suites).
    """

    after: str | None = None
    app: Annotated[App2 | None, Field(title="App")] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    before: str | None = None
    check_runs_url: AnyUrl | None = None
    conclusion: Conclusion5Enum | None = None
    """
    The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has `completed`.
    """
    created_at: datetime | None = None
    head_branch: str | None = None
    """
    The head branch name the changes are on.
    """
    head_commit: Annotated[HeadCommit | None, Field(title="SimpleCommit")] = None
    head_sha: str | None = None
    """
    The SHA of the head commit that is being checked.
    """
    id: int | None = None
    latest_check_runs_count: int | None = None
    node_id: str | None = None
    pull_requests: Sequence[PullRequest7] | None = None
    """
    An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.
    """
    rerequestable: bool | None = None
    runs_rerequestable: bool | None = None
    status: Status14Enum | None = None
    """
    The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL that points to the check suite API resource.
    """


class WebhookCheckSuiteCompleted(BaseModel):
    action: Action5 | None = None
    actions_meta: Mapping[str, Any] | None = None
    check_suite: CheckSuite2 | None = None
    """
    The [check_suite](https://docs.github.com/en/rest/reference/checks#suites).
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action6(Enum):
    appeared_in_branch = "appeared_in_branch"


class DismissedBy(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class DismissedReason2Enum(Enum):
    """
    The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
    """

    false_positive = "false positive"
    won_t_fix = "won't fix"
    used_in_tests = "used in tests"


class Location1(BaseModel):
    end_column: int | None = None
    end_line: int | None = None
    path: str | None = None
    start_column: int | None = None
    start_line: int | None = None


class State13(Enum):
    """
    State of a code scanning alert.
    """

    open = "open"
    dismissed = "dismissed"
    fixed = "fixed"


class Instance(BaseModel):
    analysis_key: str | None = None
    """
    Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
    """
    classifications: Sequence[str] | None = None
    commit_sha: str | None = None
    environment: str | None = None
    """
    Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
    """
    location: Location1 | None = None
    message: Message | None = None
    ref: str | None = None
    """
    The full Git reference, formatted as `refs/heads/<branch name>`.
    """
    state: State13 | None = None
    """
    State of a code scanning alert.
    """


class MostRecentInstance(BaseModel):
    analysis_key: str | None = None
    """
    Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
    """
    classifications: Sequence[str] | None = None
    commit_sha: str | None = None
    environment: str | None = None
    """
    Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
    """
    location: Location1 | None = None
    message: Message | None = None
    ref: str | None = None
    """
    The full Git reference, formatted as `refs/heads/<branch name>`.
    """
    state: State13 | None = None
    """
    State of a code scanning alert.
    """


class Severity4Enum(Enum):
    """
    The severity of the alert.
    """

    none = "none"
    note = "note"
    warning = "warning"
    error = "error"


class Rule3(BaseModel):
    description: str | None = None
    """
    A short description of the rule used to detect the alert.
    """
    id: str | None = None
    """
    A unique identifier for the rule used to detect the alert.
    """
    severity: Severity4Enum | None = None
    """
    The severity of the alert.
    """


class Tool(BaseModel):
    name: str | None = None
    """
    The name of the tool used to generate the code scanning analysis alert.
    """
    version: str | None = None
    """
    The version of the tool used to detect the alert.
    """


class Alert(BaseModel):
    """
    The code scanning alert involved in the event.
    """

    created_at: datetime | None = None
    """
    The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
    """
    dismissed_at: datetime | None = None
    """
    The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_by: Annotated[DismissedBy | None, Field(title="User")] = None
    dismissed_reason: DismissedReason2Enum | None = None
    """
    The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
    """
    html_url: AnyUrl | None = None
    """
    The GitHub URL of the alert resource.
    """
    instances: Sequence[Instance] | None = None
    most_recent_instance: Annotated[
        MostRecentInstance | None, Field(title="Alert Instance")
    ] = None
    number: int | None = None
    """
    The code scanning alert number.
    """
    rule: Rule3 | None = None
    state: State13 | None = None
    """
    State of a code scanning alert.
    """
    tool: Tool | None = None
    url: AnyUrl | None = None


class WebhookCodeScanningAlertAppearedInBranch(BaseModel):
    action: Action6 | None = None
    alert: Alert | None = None
    """
    The code scanning alert involved in the event.
    """
    commit_oid: str | None = None
    """
    The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    ref: str | None = None
    """
    The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
    """
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action7(Enum):
    closed_by_user = "closed_by_user"


class DismissedBy1(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class DismissedReason3Enum(Enum):
    """
    The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
    """

    false_positive = "false positive"
    won_t_fix = "won't fix"
    used_in_tests = "used in tests"


class State16(Enum):
    dismissed = "dismissed"


class Instance1(BaseModel):
    analysis_key: str | None = None
    """
    Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
    """
    classifications: Sequence[str] | None = None
    commit_sha: str | None = None
    environment: str | None = None
    """
    Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
    """
    location: Location1 | None = None
    message: Message | None = None
    ref: str | None = None
    """
    The full Git reference, formatted as `refs/heads/<branch name>`.
    """
    state: State16 | None = None
    """
    State of a code scanning alert.
    """


class State17(Enum):
    """
    State of a code scanning alert.
    """

    open = "open"
    dismissed = "dismissed"
    fixed = "fixed"


class MostRecentInstance1(BaseModel):
    analysis_key: str | None = None
    """
    Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
    """
    classifications: Sequence[str] | None = None
    commit_sha: str | None = None
    environment: str | None = None
    """
    Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
    """
    location: Location1 | None = None
    message: Message | None = None
    ref: str | None = None
    """
    The full Git reference, formatted as `refs/heads/<branch name>`.
    """
    state: State17 | None = None
    """
    State of a code scanning alert.
    """


class Severity5Enum(Enum):
    """
    The severity of the alert.
    """

    none = "none"
    note = "note"
    warning = "warning"
    error = "error"


class Rule4(BaseModel):
    description: str | None = None
    """
    A short description of the rule used to detect the alert.
    """
    full_description: str | None = None
    help: str | None = None
    help_uri: str | None = None
    """
    A link to the documentation for the rule used to detect the alert.
    """
    id: str | None = None
    """
    A unique identifier for the rule used to detect the alert.
    """
    name: str | None = None
    severity: Severity5Enum | None = None
    """
    The severity of the alert.
    """
    tags: Sequence[str] | None = None


class State18(Enum):
    """
    State of a code scanning alert.
    """

    dismissed = "dismissed"
    fixed = "fixed"


class Tool1(BaseModel):
    guid: str | None = None
    name: str | None = None
    """
    The name of the tool used to generate the code scanning analysis alert.
    """
    version: str | None = None
    """
    The version of the tool used to detect the alert.
    """


class Alert1(BaseModel):
    """
    The code scanning alert involved in the event.
    """

    created_at: datetime | None = None
    """
    The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
    """
    dismissed_at: datetime | None = None
    """
    The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_by: Annotated[DismissedBy1 | None, Field(title="User")] = None
    dismissed_reason: DismissedReason3Enum | None = None
    """
    The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
    """
    html_url: AnyUrl | None = None
    """
    The GitHub URL of the alert resource.
    """
    instances: Sequence[Instance1] | None = None
    most_recent_instance: Annotated[
        MostRecentInstance1 | None, Field(title="Alert Instance")
    ] = None
    number: int | None = None
    """
    The code scanning alert number.
    """
    rule: Rule4 | None = None
    state: State18 | None = None
    """
    State of a code scanning alert.
    """
    tool: Tool1 | None = None
    url: AnyUrl | None = None


class WebhookCodeScanningAlertClosedByUser(BaseModel):
    action: Action7 | None = None
    alert: Alert1 | None = None
    """
    The code scanning alert involved in the event.
    """
    commit_oid: str | None = None
    """
    The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    ref: str | None = None
    """
    The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
    """
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action8(Enum):
    created = "created"


class State19(Enum):
    open = "open"
    dismissed = "dismissed"


class Instance2(BaseModel):
    analysis_key: str | None = None
    """
    Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
    """
    classifications: Sequence[str] | None = None
    commit_sha: str | None = None
    environment: str | None = None
    """
    Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
    """
    location: Location1 | None = None
    message: Message | None = None
    ref: str | None = None
    """
    The full Git reference, formatted as `refs/heads/<branch name>`.
    """
    state: State19 | None = None
    """
    State of a code scanning alert.
    """


class State20(Enum):
    """
    State of a code scanning alert.
    """

    open = "open"
    dismissed = "dismissed"
    fixed = "fixed"


class MostRecentInstance2(BaseModel):
    analysis_key: str | None = None
    """
    Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
    """
    classifications: Sequence[str] | None = None
    commit_sha: str | None = None
    environment: str | None = None
    """
    Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
    """
    location: Location1 | None = None
    message: Message | None = None
    ref: str | None = None
    """
    The full Git reference, formatted as `refs/heads/<branch name>`.
    """
    state: State20 | None = None
    """
    State of a code scanning alert.
    """


class Severity6Enum(Enum):
    """
    The severity of the alert.
    """

    none = "none"
    note = "note"
    warning = "warning"
    error = "error"


class Rule5(BaseModel):
    description: str | None = None
    """
    A short description of the rule used to detect the alert.
    """
    full_description: str | None = None
    help: str | None = None
    help_uri: str | None = None
    """
    A link to the documentation for the rule used to detect the alert.
    """
    id: str | None = None
    """
    A unique identifier for the rule used to detect the alert.
    """
    name: str | None = None
    severity: Severity6Enum | None = None
    """
    The severity of the alert.
    """
    tags: Sequence[str] | None = None


class State21(Enum):
    """
    State of a code scanning alert.
    """

    open = "open"
    dismissed = "dismissed"


class Alert2(BaseModel):
    """
    The code scanning alert involved in the event.
    """

    created_at: datetime | None = None
    """
    The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
    """
    dismissed_at: Any | None = None
    """
    The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_by: Any | None = None
    dismissed_comment: Annotated[str | None, Field(max_length=280)] = None
    """
    The dismissal comment associated with the dismissal of the alert.
    """
    dismissed_reason: Any | None = None
    """
    The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
    """
    fixed_at: Any | None = None
    html_url: AnyUrl | None = None
    """
    The GitHub URL of the alert resource.
    """
    instances: Sequence[Instance2] | None = None
    instances_url: str | None = None
    most_recent_instance: Annotated[
        MostRecentInstance2 | None, Field(title="Alert Instance")
    ] = None
    number: int | None = None
    """
    The code scanning alert number.
    """
    rule: Rule5 | None = None
    state: State21 | None = None
    """
    State of a code scanning alert.
    """
    tool: Tool1 | None = None
    updated_at: str | None = None
    url: AnyUrl | None = None


class WebhookCodeScanningAlertCreated(BaseModel):
    action: Action8 | None = None
    alert: Alert2 | None = None
    """
    The code scanning alert involved in the event.
    """
    commit_oid: str | None = None
    """
    The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    ref: str | None = None
    """
    The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
    """
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action9(Enum):
    fixed = "fixed"


class DismissedBy2(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class DismissedReason4Enum(Enum):
    """
    The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
    """

    false_positive = "false positive"
    won_t_fix = "won't fix"
    used_in_tests = "used in tests"


class State22(Enum):
    fixed = "fixed"


class Instance3(BaseModel):
    analysis_key: str | None = None
    """
    Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
    """
    classifications: Sequence[str] | None = None
    commit_sha: str | None = None
    environment: str | None = None
    """
    Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
    """
    location: Location1 | None = None
    message: Message | None = None
    ref: str | None = None
    """
    The full Git reference, formatted as `refs/heads/<branch name>`.
    """
    state: State22 | None = None
    """
    State of a code scanning alert.
    """


class State23(Enum):
    """
    State of a code scanning alert.
    """

    open = "open"
    dismissed = "dismissed"
    fixed = "fixed"


class MostRecentInstance3(BaseModel):
    analysis_key: str | None = None
    """
    Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
    """
    classifications: Sequence[str] | None = None
    commit_sha: str | None = None
    environment: str | None = None
    """
    Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
    """
    location: Location1 | None = None
    message: Message | None = None
    ref: str | None = None
    """
    The full Git reference, formatted as `refs/heads/<branch name>`.
    """
    state: State23 | None = None
    """
    State of a code scanning alert.
    """


class Severity7Enum(Enum):
    """
    The severity of the alert.
    """

    none = "none"
    note = "note"
    warning = "warning"
    error = "error"


class Rule6(BaseModel):
    description: str | None = None
    """
    A short description of the rule used to detect the alert.
    """
    full_description: str | None = None
    help: str | None = None
    help_uri: str | None = None
    """
    A link to the documentation for the rule used to detect the alert.
    """
    id: str | None = None
    """
    A unique identifier for the rule used to detect the alert.
    """
    name: str | None = None
    severity: Severity7Enum | None = None
    """
    The severity of the alert.
    """
    tags: Sequence[str] | None = None


class State24(Enum):
    """
    State of a code scanning alert.
    """

    fixed = "fixed"


class Alert3(BaseModel):
    """
    The code scanning alert involved in the event.
    """

    created_at: datetime | None = None
    """
    The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
    """
    dismissed_at: datetime | None = None
    """
    The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_by: Annotated[DismissedBy2 | None, Field(title="User")] = None
    dismissed_reason: DismissedReason4Enum | None = None
    """
    The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
    """
    html_url: AnyUrl | None = None
    """
    The GitHub URL of the alert resource.
    """
    instances: Sequence[Instance3] | None = None
    instances_url: AnyUrl | None = None
    most_recent_instance: Annotated[
        MostRecentInstance3 | None, Field(title="Alert Instance")
    ] = None
    number: int | None = None
    """
    The code scanning alert number.
    """
    rule: Rule6 | None = None
    state: State24 | None = None
    """
    State of a code scanning alert.
    """
    tool: Tool1 | None = None
    url: AnyUrl | None = None


class WebhookCodeScanningAlertFixed(BaseModel):
    action: Action9 | None = None
    alert: Alert3 | None = None
    """
    The code scanning alert involved in the event.
    """
    commit_oid: str | None = None
    """
    The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    ref: str | None = None
    """
    The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
    """
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action10(Enum):
    reopened = "reopened"


class State25(Enum):
    open = "open"


class Instance4(BaseModel):
    analysis_key: str | None = None
    """
    Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
    """
    classifications: Sequence[str] | None = None
    commit_sha: str | None = None
    environment: str | None = None
    """
    Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
    """
    location: Location1 | None = None
    message: Message | None = None
    ref: str | None = None
    """
    The full Git reference, formatted as `refs/heads/<branch name>`.
    """
    state: State25 | None = None
    """
    State of a code scanning alert.
    """


class State26(Enum):
    """
    State of a code scanning alert.
    """

    open = "open"
    dismissed = "dismissed"
    fixed = "fixed"


class MostRecentInstance4(BaseModel):
    analysis_key: str | None = None
    """
    Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
    """
    classifications: Sequence[str] | None = None
    commit_sha: str | None = None
    environment: str | None = None
    """
    Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
    """
    location: Location1 | None = None
    message: Message | None = None
    ref: str | None = None
    """
    The full Git reference, formatted as `refs/heads/<branch name>`.
    """
    state: State26 | None = None
    """
    State of a code scanning alert.
    """


class Severity8Enum(Enum):
    """
    The severity of the alert.
    """

    none = "none"
    note = "note"
    warning = "warning"
    error = "error"


class Rule7(BaseModel):
    description: str | None = None
    """
    A short description of the rule used to detect the alert.
    """
    full_description: str | None = None
    help: str | None = None
    help_uri: str | None = None
    """
    A link to the documentation for the rule used to detect the alert.
    """
    id: str | None = None
    """
    A unique identifier for the rule used to detect the alert.
    """
    name: str | None = None
    severity: Severity8Enum | None = None
    """
    The severity of the alert.
    """
    tags: Sequence[str] | None = None


class Alert4(BaseModel):
    """
    The code scanning alert involved in the event.
    """

    created_at: datetime | None = None
    """
    The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
    """
    dismissed_at: str | None = None
    """
    The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_by: Mapping[str, Any] | None = None
    dismissed_reason: str | None = None
    """
    The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
    """
    html_url: AnyUrl | None = None
    """
    The GitHub URL of the alert resource.
    """
    instances: Sequence[Instance4] | None = None
    most_recent_instance: Annotated[
        MostRecentInstance4 | None, Field(title="Alert Instance")
    ] = None
    number: int | None = None
    """
    The code scanning alert number.
    """
    rule: Rule7 | None = None
    state: State26 | None = None
    """
    State of a code scanning alert.
    """
    tool: Tool1 | None = None
    url: AnyUrl | None = None


class WebhookCodeScanningAlertReopened(BaseModel):
    action: Action10 | None = None
    alert: Alert4 | None = None
    """
    The code scanning alert involved in the event.
    """
    commit_oid: str | None = None
    """
    The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    ref: str | None = None
    """
    The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
    """
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action11(Enum):
    reopened_by_user = "reopened_by_user"


class State28(Enum):
    open = "open"


class Instance5(BaseModel):
    analysis_key: str | None = None
    """
    Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
    """
    classifications: Sequence[str] | None = None
    commit_sha: str | None = None
    environment: str | None = None
    """
    Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
    """
    location: Location1 | None = None
    message: Message | None = None
    ref: str | None = None
    """
    The full Git reference, formatted as `refs/heads/<branch name>`.
    """
    state: State28 | None = None
    """
    State of a code scanning alert.
    """


class State29(Enum):
    """
    State of a code scanning alert.
    """

    open = "open"
    dismissed = "dismissed"
    fixed = "fixed"


class MostRecentInstance5(BaseModel):
    analysis_key: str | None = None
    """
    Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
    """
    classifications: Sequence[str] | None = None
    commit_sha: str | None = None
    environment: str | None = None
    """
    Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
    """
    location: Location1 | None = None
    message: Message | None = None
    ref: str | None = None
    """
    The full Git reference, formatted as `refs/heads/<branch name>`.
    """
    state: State29 | None = None
    """
    State of a code scanning alert.
    """


class Severity9Enum(Enum):
    """
    The severity of the alert.
    """

    none = "none"
    note = "note"
    warning = "warning"
    error = "error"


class Rule8(BaseModel):
    description: str | None = None
    """
    A short description of the rule used to detect the alert.
    """
    id: str | None = None
    """
    A unique identifier for the rule used to detect the alert.
    """
    severity: Severity9Enum | None = None
    """
    The severity of the alert.
    """


class State30(Enum):
    """
    State of a code scanning alert.
    """

    open = "open"
    fixed = "fixed"


class Tool5(BaseModel):
    name: str | None = None
    """
    The name of the tool used to generate the code scanning analysis alert.
    """
    version: str | None = None
    """
    The version of the tool used to detect the alert.
    """


class Alert5(BaseModel):
    """
    The code scanning alert involved in the event.
    """

    created_at: datetime | None = None
    """
    The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
    """
    dismissed_at: Any | None = None
    """
    The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    """
    dismissed_by: Any | None = None
    dismissed_reason: Any | None = None
    """
    The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
    """
    html_url: AnyUrl | None = None
    """
    The GitHub URL of the alert resource.
    """
    instances: Sequence[Instance5] | None = None
    most_recent_instance: Annotated[
        MostRecentInstance5 | None, Field(title="Alert Instance")
    ] = None
    number: int | None = None
    """
    The code scanning alert number.
    """
    rule: Rule8 | None = None
    state: State30 | None = None
    """
    State of a code scanning alert.
    """
    tool: Tool5 | None = None
    url: AnyUrl | None = None


class WebhookCodeScanningAlertReopenedByUser(BaseModel):
    action: Action11 | None = None
    alert: Alert5 | None = None
    """
    The code scanning alert involved in the event.
    """
    commit_oid: str | None = None
    """
    The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    ref: str | None = None
    """
    The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
    """
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action12(Enum):
    """
    The action performed. Can be `created`.
    """

    created = "created"


class Reactions(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: AnyUrl | None = None


class User3(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Comment(BaseModel):
    """
    The [commit comment](https://docs.github.com/en/rest/reference/repos#get-a-commit-comment) resource.
    """

    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    The text of the comment.
    """
    commit_id: str | None = None
    """
    The SHA of the commit to which the comment applies.
    """
    created_at: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    The ID of the commit comment.
    """
    line: int | None = None
    """
    The line of the blob to which the comment applies. The last line of the range for a multi-line comment
    """
    node_id: str | None = None
    """
    The node ID of the commit comment.
    """
    path: str | None = None
    """
    The relative path of the file to which the comment applies.
    """
    position: int | None = None
    """
    The line index in the diff to which the comment applies.
    """
    reactions: Annotated[Reactions | None, Field(title="Reactions")] = None
    updated_at: str | None = None
    url: AnyUrl | None = None
    user: Annotated[User3 | None, Field(title="User")] = None


class WebhookCommitCommentCreated(BaseModel):
    """
    A commit comment is created. The type of activity is specified in the `action` property.
    """

    action: Action12 | None = None
    """
    The action performed. Can be `created`.
    """
    comment: Comment | None = None
    """
    The [commit comment](https://docs.github.com/en/rest/reference/repos#get-a-commit-comment) resource.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class RefType(Enum):
    """
    The type of Git ref object created in the repository.
    """

    tag = "tag"
    branch = "branch"


class WebhookCreate(BaseModel):
    """
    A Git branch or tag is created.
    """

    description: str | None = None
    """
    The repository's current description.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    master_branch: str | None = None
    """
    The name of the repository's default branch (usually `main`).
    """
    organization: OrganizationSimple | None = None
    pusher_type: str | None = None
    """
    The pusher type for the event. Can be either `user` or a deploy key.
    """
    ref: str | None = None
    """
    The [`git ref`](https://docs.github.com/en/rest/reference/git#get-a-reference) resource.
    """
    ref_type: RefType | None = None
    """
    The type of Git ref object created in the repository.
    """
    repository: Repository | None = None
    sender: SimpleUser | None = None


class RefType1(Enum):
    """
    The type of Git ref object deleted in the repository.
    """

    tag = "tag"
    branch = "branch"


class WebhookDelete(BaseModel):
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    pusher_type: str | None = None
    """
    The pusher type for the event. Can be either `user` or a deploy key.
    """
    ref: str | None = None
    """
    The [`git ref`](https://docs.github.com/en/rest/reference/git#get-a-reference) resource.
    """
    ref_type: RefType1 | None = None
    """
    The type of Git ref object deleted in the repository.
    """
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action13(Enum):
    created = "created"


class WebhookDependabotAlertCreated(BaseModel):
    action: Action13 | None = None
    alert: DependabotAlert | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    enterprise: Enterprise | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action14(Enum):
    dismissed = "dismissed"


class WebhookDependabotAlertDismissed(BaseModel):
    action: Action14 | None = None
    alert: DependabotAlert | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    enterprise: Enterprise | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action15(Enum):
    fixed = "fixed"


class WebhookDependabotAlertFixed(BaseModel):
    action: Action15 | None = None
    alert: DependabotAlert | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    enterprise: Enterprise | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action16(Enum):
    reintroduced = "reintroduced"


class WebhookDependabotAlertReintroduced(BaseModel):
    action: Action16 | None = None
    alert: DependabotAlert | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    enterprise: Enterprise | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action17(Enum):
    reopened = "reopened"


class WebhookDependabotAlertReopened(BaseModel):
    action: Action17 | None = None
    alert: DependabotAlert | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    enterprise: Enterprise | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action18(Enum):
    created = "created"


class Key1(BaseModel):
    """
    The [`deploy key`](https://docs.github.com/en/rest/reference/deployments#get-a-deploy-key) resource.
    """

    added_by: str | None = None
    created_at: str | None = None
    id: int | None = None
    key: str | None = None
    last_used: str | None = None
    read_only: bool | None = None
    title: str | None = None
    url: AnyUrl | None = None
    verified: bool | None = None


class WebhookDeployKeyCreated(BaseModel):
    action: Action18 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    key: Key1 | None = None
    """
    The [`deploy key`](https://docs.github.com/en/rest/reference/deployments#get-a-deploy-key) resource.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action19(Enum):
    deleted = "deleted"


class WebhookDeployKeyDeleted(BaseModel):
    action: Action19 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    key: Key1 | None = None
    """
    The [`deploy key`](https://docs.github.com/en/rest/reference/deployments#get-a-deploy-key) resource.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action20(Enum):
    created = "created"


class Creator(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Event2(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"
    workflow_job = "workflow_job"
    pull_request_review_thread = "pull_request_review_thread"
    merge_queue_entry = "merge_queue_entry"
    secret_scanning_alert_location = "secret_scanning_alert_location"
    merge_group = "merge_group"


class Owner6(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class OrganizationProjects2(Enum):
    read = "read"
    write = "write"


class RepositoryProjects2(Enum):
    read = "read"
    write = "write"


class Permissions21(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects2 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects2 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event2] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner6 | None, Field(title="User")] = None
    permissions: Permissions21 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Deployment1(BaseModel):
    """
    The [deployment](https://docs.github.com/en/rest/reference/deployments#list-deployments).
    """

    created_at: str | None = None
    creator: Annotated[Creator | None, Field(title="User")] = None
    description: str | None = None
    environment: str | None = None
    id: int | None = None
    node_id: str | None = None
    original_environment: str | None = None
    payload: Mapping[str, Any] | str | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    production_environment: bool | None = None
    ref: str | None = None
    repository_url: AnyUrl | None = None
    sha: str | None = None
    statuses_url: AnyUrl | None = None
    task: str | None = None
    transient_environment: bool | None = None
    updated_at: str | None = None
    url: AnyUrl | None = None


class Workflow1(BaseModel):
    badge_url: AnyUrl | None = None
    created_at: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    name: str | None = None
    node_id: str | None = None
    path: str | None = None
    state: str | None = None
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Actor1(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Conclusion6Enum(Enum):
    success = "success"
    failure = "failure"
    neutral = "neutral"
    cancelled = "cancelled"
    timed_out = "timed_out"
    action_required = "action_required"
    stale = "stale"


class Owner7(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class HeadRepository(BaseModel):
    archive_url: str | None = None
    assignees_url: str | None = None
    blobs_url: str | None = None
    branches_url: str | None = None
    collaborators_url: str | None = None
    comments_url: str | None = None
    commits_url: str | None = None
    compare_url: str | None = None
    contents_url: str | None = None
    contributors_url: str | None = None
    deployments_url: str | None = None
    description: Any | None = None
    downloads_url: str | None = None
    events_url: str | None = None
    fork: bool | None = None
    forks_url: str | None = None
    full_name: str | None = None
    git_commits_url: str | None = None
    git_refs_url: str | None = None
    git_tags_url: str | None = None
    hooks_url: str | None = None
    html_url: str | None = None
    id: int | None = None
    issue_comment_url: str | None = None
    issue_events_url: str | None = None
    issues_url: str | None = None
    keys_url: str | None = None
    labels_url: str | None = None
    languages_url: str | None = None
    merges_url: str | None = None
    milestones_url: str | None = None
    name: str | None = None
    node_id: str | None = None
    notifications_url: str | None = None
    owner: Owner7 | None = None
    private: bool | None = None
    pulls_url: str | None = None
    releases_url: str | None = None
    stargazers_url: str | None = None
    statuses_url: str | None = None
    subscribers_url: str | None = None
    subscription_url: str | None = None
    tags_url: str | None = None
    teams_url: str | None = None
    trees_url: str | None = None
    url: str | None = None


class Base4(BaseModel):
    ref: str | None = None
    repo: Annotated[Repo5 | None, Field(title="Repo Ref")] = None
    sha: str | None = None


class Head4(BaseModel):
    ref: str | None = None
    repo: Annotated[Repo5 | None, Field(title="Repo Ref")] = None
    sha: str | None = None


class PullRequest8(BaseModel):
    base: Base4 | None = None
    head: Head4 | None = None
    id: int | None = None
    number: int | None = None
    url: AnyUrl | None = None


class ReferencedWorkflow1(BaseModel):
    path: str | None = None
    ref: str | None = None
    sha: str | None = None


class Repository1(BaseModel):
    archive_url: str | None = None
    assignees_url: str | None = None
    blobs_url: str | None = None
    branches_url: str | None = None
    collaborators_url: str | None = None
    comments_url: str | None = None
    commits_url: str | None = None
    compare_url: str | None = None
    contents_url: str | None = None
    contributors_url: str | None = None
    deployments_url: str | None = None
    description: Any | None = None
    downloads_url: str | None = None
    events_url: str | None = None
    fork: bool | None = None
    forks_url: str | None = None
    full_name: str | None = None
    git_commits_url: str | None = None
    git_refs_url: str | None = None
    git_tags_url: str | None = None
    hooks_url: str | None = None
    html_url: str | None = None
    id: int | None = None
    issue_comment_url: str | None = None
    issue_events_url: str | None = None
    issues_url: str | None = None
    keys_url: str | None = None
    labels_url: str | None = None
    languages_url: str | None = None
    merges_url: str | None = None
    milestones_url: str | None = None
    name: str | None = None
    node_id: str | None = None
    notifications_url: str | None = None
    owner: Owner7 | None = None
    private: bool | None = None
    pulls_url: str | None = None
    releases_url: str | None = None
    stargazers_url: str | None = None
    statuses_url: str | None = None
    subscribers_url: str | None = None
    subscription_url: str | None = None
    tags_url: str | None = None
    teams_url: str | None = None
    trees_url: str | None = None
    url: str | None = None


class Status15(Enum):
    requested = "requested"
    in_progress = "in_progress"
    completed = "completed"
    queued = "queued"
    waiting = "waiting"
    pending = "pending"


class TriggeringActor(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class WorkflowRun2(BaseModel):
    actor: Annotated[Actor1 | None, Field(title="User")] = None
    artifacts_url: str | None = None
    cancel_url: str | None = None
    check_suite_id: int | None = None
    check_suite_node_id: str | None = None
    check_suite_url: str | None = None
    conclusion: Conclusion6Enum | None = None
    created_at: datetime | None = None
    display_title: str | None = None
    event: str | None = None
    head_branch: str | None = None
    head_commit: Any | None = None
    head_repository: HeadRepository | None = None
    head_sha: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    jobs_url: str | None = None
    logs_url: str | None = None
    name: str | None = None
    node_id: str | None = None
    path: str | None = None
    previous_attempt_url: Any | None = None
    pull_requests: Sequence[PullRequest8] | None = None
    referenced_workflows: Sequence[ReferencedWorkflow1] | None = None
    repository: Repository1 | None = None
    rerun_url: str | None = None
    run_attempt: int | None = None
    run_number: int | None = None
    run_started_at: datetime | None = None
    status: Status15 | None = None
    triggering_actor: Annotated[TriggeringActor | None, Field(title="User")] = None
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    workflow_id: int | None = None
    workflow_url: str | None = None


class WebhookDeploymentCreated(BaseModel):
    action: Action20 | None = None
    deployment: Annotated[Deployment1 | None, Field(title="Deployment")] = None
    """
    The [deployment](https://docs.github.com/en/rest/reference/deployments#list-deployments).
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None
    workflow: Annotated[Workflow1 | None, Field(title="Workflow")] = None
    workflow_run: Annotated[
        WorkflowRun2 | None, Field(title="Deployment Workflow Run")
    ] = None


class Conclusion7Enum(Enum):
    """
    The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.
    """

    success = "success"
    failure = "failure"
    neutral = "neutral"
    cancelled = "cancelled"
    timed_out = "timed_out"
    action_required = "action_required"
    stale = "stale"
    skipped = "skipped"


class Status16(Enum):
    """
    The current status of the check run. Can be `queued`, `in_progress`, or `completed`.
    """

    queued = "queued"
    in_progress = "in_progress"
    completed = "completed"
    waiting = "waiting"
    pending = "pending"


class CheckRun1(BaseModel):
    completed_at: datetime | None = None
    conclusion: Conclusion7Enum | None = None
    """
    The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.
    """
    details_url: AnyUrl | None = None
    external_id: str | None = None
    head_sha: str | None = None
    """
    The SHA of the commit that is being checked.
    """
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    The id of the check.
    """
    name: str | None = None
    """
    The name of the check run.
    """
    node_id: str | None = None
    started_at: datetime | None = None
    status: Status16 | None = None
    """
    The current status of the check run. Can be `queued`, `in_progress`, or `completed`.
    """
    url: AnyUrl | None = None


class Creator1(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Event3(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"
    merge_queue_entry = "merge_queue_entry"
    workflow_job = "workflow_job"
    pull_request_review_thread = "pull_request_review_thread"
    secret_scanning_alert_location = "secret_scanning_alert_location"
    merge_group = "merge_group"


class Owner9(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Permissions22(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects2 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects2 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp1(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event3] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner9 | None, Field(title="User")] = None
    permissions: Permissions22 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Deployment2(BaseModel):
    """
    The [deployment](https://docs.github.com/en/rest/reference/deployments#list-deployments).
    """

    created_at: str | None = None
    creator: Annotated[Creator1 | None, Field(title="User")] = None
    description: str | None = None
    environment: str | None = None
    id: int | None = None
    node_id: str | None = None
    original_environment: str | None = None
    payload: str | Mapping[str, Any] | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp1 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    production_environment: bool | None = None
    ref: str | None = None
    repository_url: AnyUrl | None = None
    sha: str | None = None
    statuses_url: AnyUrl | None = None
    task: str | None = None
    transient_environment: bool | None = None
    updated_at: str | None = None
    url: AnyUrl | None = None


class Creator2(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Event4(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"
    pull_request_review_thread = "pull_request_review_thread"
    merge_queue_entry = "merge_queue_entry"
    workflow_job = "workflow_job"
    merge_group = "merge_group"
    secret_scanning_alert_location = "secret_scanning_alert_location"


class Owner10(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Permissions23(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects2 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects2 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp2(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event4] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner10 | None, Field(title="User")] = None
    permissions: Permissions23 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class DeploymentStatus1(BaseModel):
    """
    The [deployment status](https://docs.github.com/en/rest/reference/deployments#list-deployment-statuses).
    """

    created_at: str | None = None
    creator: Annotated[Creator2 | None, Field(title="User")] = None
    deployment_url: AnyUrl | None = None
    description: str | None = None
    """
    The optional human-readable description added to the status.
    """
    environment: str | None = None
    environment_url: AnyUrl | None = None
    id: int | None = None
    log_url: AnyUrl | None = None
    node_id: str | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp2 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    repository_url: AnyUrl | None = None
    state: str | None = None
    """
    The new state. Can be `pending`, `success`, `failure`, or `error`.
    """
    target_url: str | None = None
    """
    The optional link added to the status.
    """
    updated_at: str | None = None
    url: AnyUrl | None = None


class Actor2(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Conclusion8Enum(Enum):
    success = "success"
    failure = "failure"
    neutral = "neutral"
    cancelled = "cancelled"
    timed_out = "timed_out"
    action_required = "action_required"
    stale = "stale"
    startup_failure = "startup_failure"


class Owner11(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class HeadRepository1(BaseModel):
    archive_url: str | None = None
    assignees_url: str | None = None
    blobs_url: str | None = None
    branches_url: str | None = None
    collaborators_url: str | None = None
    comments_url: str | None = None
    commits_url: str | None = None
    compare_url: str | None = None
    contents_url: str | None = None
    contributors_url: str | None = None
    deployments_url: str | None = None
    description: Any | None = None
    downloads_url: str | None = None
    events_url: str | None = None
    fork: bool | None = None
    forks_url: str | None = None
    full_name: str | None = None
    git_commits_url: str | None = None
    git_refs_url: str | None = None
    git_tags_url: str | None = None
    hooks_url: str | None = None
    html_url: str | None = None
    id: int | None = None
    issue_comment_url: str | None = None
    issue_events_url: str | None = None
    issues_url: str | None = None
    keys_url: str | None = None
    labels_url: str | None = None
    languages_url: str | None = None
    merges_url: str | None = None
    milestones_url: str | None = None
    name: str | None = None
    node_id: str | None = None
    notifications_url: str | None = None
    owner: Owner11 | None = None
    private: bool | None = None
    pulls_url: str | None = None
    releases_url: str | None = None
    stargazers_url: str | None = None
    statuses_url: str | None = None
    subscribers_url: str | None = None
    subscription_url: str | None = None
    tags_url: str | None = None
    teams_url: str | None = None
    trees_url: str | None = None
    url: str | None = None


class Base5(BaseModel):
    ref: str | None = None
    repo: Annotated[Repo5 | None, Field(title="Repo Ref")] = None
    sha: str | None = None


class Head5(BaseModel):
    ref: str | None = None
    repo: Annotated[Repo5 | None, Field(title="Repo Ref")] = None
    sha: str | None = None


class PullRequest9(BaseModel):
    base: Base5 | None = None
    head: Head5 | None = None
    id: int | None = None
    number: int | None = None
    url: AnyUrl | None = None


class Repository2(BaseModel):
    archive_url: str | None = None
    assignees_url: str | None = None
    blobs_url: str | None = None
    branches_url: str | None = None
    collaborators_url: str | None = None
    comments_url: str | None = None
    commits_url: str | None = None
    compare_url: str | None = None
    contents_url: str | None = None
    contributors_url: str | None = None
    deployments_url: str | None = None
    description: Any | None = None
    downloads_url: str | None = None
    events_url: str | None = None
    fork: bool | None = None
    forks_url: str | None = None
    full_name: str | None = None
    git_commits_url: str | None = None
    git_refs_url: str | None = None
    git_tags_url: str | None = None
    hooks_url: str | None = None
    html_url: str | None = None
    id: int | None = None
    issue_comment_url: str | None = None
    issue_events_url: str | None = None
    issues_url: str | None = None
    keys_url: str | None = None
    labels_url: str | None = None
    languages_url: str | None = None
    merges_url: str | None = None
    milestones_url: str | None = None
    name: str | None = None
    node_id: str | None = None
    notifications_url: str | None = None
    owner: Owner11 | None = None
    private: bool | None = None
    pulls_url: str | None = None
    releases_url: str | None = None
    stargazers_url: str | None = None
    statuses_url: str | None = None
    subscribers_url: str | None = None
    subscription_url: str | None = None
    tags_url: str | None = None
    teams_url: str | None = None
    trees_url: str | None = None
    url: str | None = None


class Status17(Enum):
    requested = "requested"
    in_progress = "in_progress"
    completed = "completed"
    queued = "queued"
    waiting = "waiting"
    pending = "pending"


class TriggeringActor1(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class WorkflowRun3(BaseModel):
    actor: Annotated[Actor2 | None, Field(title="User")] = None
    artifacts_url: str | None = None
    cancel_url: str | None = None
    check_suite_id: int | None = None
    check_suite_node_id: str | None = None
    check_suite_url: str | None = None
    conclusion: Conclusion8Enum | None = None
    created_at: datetime | None = None
    display_title: str | None = None
    event: str | None = None
    head_branch: str | None = None
    head_commit: Any | None = None
    head_repository: HeadRepository1 | None = None
    head_sha: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    jobs_url: str | None = None
    logs_url: str | None = None
    name: str | None = None
    node_id: str | None = None
    path: str | None = None
    previous_attempt_url: Any | None = None
    pull_requests: Sequence[PullRequest9] | None = None
    referenced_workflows: Sequence[ReferencedWorkflow1] | None = None
    repository: Repository2 | None = None
    rerun_url: str | None = None
    run_attempt: int | None = None
    run_number: int | None = None
    run_started_at: datetime | None = None
    status: Status17 | None = None
    triggering_actor: Annotated[TriggeringActor1 | None, Field(title="User")] = None
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    workflow_id: int | None = None
    workflow_url: str | None = None


class WebhookDeploymentStatusCreated(BaseModel):
    action: Action20 | None = None
    check_run: CheckRun1 | None = None
    deployment: Annotated[Deployment2 | None, Field(title="Deployment")] = None
    """
    The [deployment](https://docs.github.com/en/rest/reference/deployments#list-deployments).
    """
    deployment_status: DeploymentStatus1 | None = None
    """
    The [deployment status](https://docs.github.com/en/rest/reference/deployments#list-deployment-statuses).
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None
    workflow: Annotated[Workflow1 | None, Field(title="Workflow")] = None
    workflow_run: Annotated[
        WorkflowRun3 | None, Field(title="Deployment Workflow Run")
    ] = None


class Action22(Enum):
    answered = "answered"


class User4(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Answer(BaseModel):
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    child_comment_count: int | None = None
    created_at: datetime | None = None
    discussion_id: int | None = None
    html_url: str | None = None
    id: int | None = None
    node_id: str | None = None
    parent_id: Any | None = None
    reactions: Annotated[Reactions | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User4 | None, Field(title="User")] = None


class AnswerChosenBy(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Category(BaseModel):
    created_at: str | None = None
    description: str | None = None
    emoji: str | None = None
    id: int | None = None
    is_answerable: IsAnswerable | None = None
    name: str | None = None
    node_id: str | None = None
    repository_id: int | None = None
    slug: str | None = None
    updated_at: str | None = None


class Reactions2(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: str | None = None


class State31(Enum):
    open = "open"
    locked = "locked"
    converting = "converting"
    transferring = "transferring"


class User5(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class IsAnswerable(Enum):
    boolean_True = True


class Discussion(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions2 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State31 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User5 | None, Field(title="User")] = None


class WebhookDiscussionAnswered(BaseModel):
    action: Action22 | None = None
    answer: Answer | None = None
    discussion: Discussion | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action23(Enum):
    category_changed = "category_changed"


class From2(BaseModel):
    created_at: datetime | None = None
    description: str | None = None
    emoji: str | None = None
    id: int | None = None
    is_answerable: bool | None = None
    name: str | None = None
    node_id: str | None = None
    repository_id: int | None = None
    slug: str | None = None
    updated_at: str | None = None


class Category1(BaseModel):
    from_: Annotated[From2 | None, Field(alias="from")] = None


class Changes1(BaseModel):
    category: Category1 | None = None


class AnswerChosenBy1(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Category2(BaseModel):
    created_at: datetime | None = None
    description: str | None = None
    emoji: str | None = None
    id: int | None = None
    is_answerable: bool | None = None
    name: str | None = None
    node_id: str | None = None
    repository_id: int | None = None
    slug: str | None = None
    updated_at: str | None = None


class Reactions3(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: AnyUrl | None = None


class User6(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Discussion1(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy1 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category2 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions3 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State31 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User6 | None, Field(title="User")] = None


class WebhookDiscussionCategoryChanged(BaseModel):
    action: Action23 | None = None
    changes: Changes1 | None = None
    discussion: Annotated[Discussion1 | None, Field(title="Discussion")] = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action24(Enum):
    created = "created"


class User7(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Comment1(BaseModel):
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    child_comment_count: int | None = None
    created_at: str | None = None
    discussion_id: int | None = None
    html_url: str | None = None
    id: int | None = None
    node_id: str | None = None
    parent_id: int | None = None
    reactions: Annotated[Reactions3 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    updated_at: str | None = None
    user: Annotated[User7 | None, Field(title="User")] = None


class AnswerChosenBy2(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class User8(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Discussion2(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy2 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category2 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions3 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State31 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User8 | None, Field(title="User")] = None


class WebhookDiscussionCommentCreated(BaseModel):
    action: Action24 | None = None
    comment: Comment1 | None = None
    discussion: Annotated[Discussion2 | None, Field(title="Discussion")] = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action25(Enum):
    deleted = "deleted"


class User9(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Comment2(BaseModel):
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    child_comment_count: int | None = None
    created_at: str | None = None
    discussion_id: int | None = None
    html_url: str | None = None
    id: int | None = None
    node_id: str | None = None
    parent_id: int | None = None
    reactions: Annotated[Reactions3 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    updated_at: str | None = None
    user: Annotated[User9 | None, Field(title="User")] = None


class AnswerChosenBy3(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class User10(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Discussion3(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy3 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category2 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions3 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State31 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User10 | None, Field(title="User")] = None


class WebhookDiscussionCommentDeleted(BaseModel):
    action: Action25 | None = None
    comment: Comment2 | None = None
    discussion: Annotated[Discussion3 | None, Field(title="Discussion")] = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action26(Enum):
    edited = "edited"


class Body(BaseModel):
    from_: Annotated[str | None, Field(alias="from")] = None


class Changes2(BaseModel):
    body: Body | None = None


class User11(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Comment3(BaseModel):
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    child_comment_count: int | None = None
    created_at: str | None = None
    discussion_id: int | None = None
    html_url: str | None = None
    id: int | None = None
    node_id: str | None = None
    parent_id: int | None = None
    reactions: Annotated[Reactions3 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    updated_at: str | None = None
    user: Annotated[User11 | None, Field(title="User")] = None


class AnswerChosenBy4(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class User12(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Discussion4(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy4 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category2 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions3 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State31 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User12 | None, Field(title="User")] = None


class WebhookDiscussionCommentEdited(BaseModel):
    action: Action26 | None = None
    changes: Changes2 | None = None
    comment: Comment3 | None = None
    discussion: Annotated[Discussion4 | None, Field(title="Discussion")] = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action27(Enum):
    created = "created"


class AnswerChosenBy5(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Category6(BaseModel):
    created_at: str | None = None
    description: str | None = None
    emoji: str | None = None
    id: int | None = None
    is_answerable: bool | None = None
    name: str | None = None
    node_id: str | None = None
    repository_id: int | None = None
    slug: str | None = None
    updated_at: str | None = None


class Reactions10(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: str | None = None


class State36(Enum):
    open = "open"
    converting = "converting"
    transferring = "transferring"


class User13(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class Locked(Enum):
    boolean_False = False


class Discussion5(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy5 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category6 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions10 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State36 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User13 | None, Field(title="User")] = None


class WebhookDiscussionCreated(BaseModel):
    action: Action27 | None = None
    discussion: Discussion5 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action28(Enum):
    deleted = "deleted"


class AnswerChosenBy6(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Category7(BaseModel):
    created_at: datetime | None = None
    description: str | None = None
    emoji: str | None = None
    id: int | None = None
    is_answerable: bool | None = None
    name: str | None = None
    node_id: str | None = None
    repository_id: int | None = None
    slug: str | None = None
    updated_at: str | None = None


class Reactions11(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: AnyUrl | None = None


class State37(Enum):
    open = "open"
    locked = "locked"
    converting = "converting"
    transferring = "transferring"


class User14(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Discussion6(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy6 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category7 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions11 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State37 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User14 | None, Field(title="User")] = None


class WebhookDiscussionDeleted(BaseModel):
    action: Action28 | None = None
    discussion: Annotated[Discussion6 | None, Field(title="Discussion")] = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action29(Enum):
    edited = "edited"


class Title(BaseModel):
    from_: Annotated[str | None, Field(alias="from")] = None


class Changes3(BaseModel):
    body: Body | None = None
    title: Title | None = None


class AnswerChosenBy7(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class User15(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Discussion7(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy7 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category7 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions11 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State37 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User15 | None, Field(title="User")] = None


class WebhookDiscussionEdited(BaseModel):
    action: Action29 | None = None
    changes: Changes3 | None = None
    discussion: Annotated[Discussion7 | None, Field(title="Discussion")] = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action30(Enum):
    labeled = "labeled"


class AnswerChosenBy8(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class User16(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Discussion8(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy8 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category7 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions11 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State37 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User16 | None, Field(title="User")] = None


class Label8(BaseModel):
    color: str | None = None
    """
    6-character hex code, without the leading #, identifying the color
    """
    default: bool | None = None
    description: str | None = None
    id: int | None = None
    name: str | None = None
    """
    The name of the label.
    """
    node_id: str | None = None
    url: AnyUrl | None = None
    """
    URL for the label
    """


class WebhookDiscussionLabeled(BaseModel):
    action: Action30 | None = None
    discussion: Annotated[Discussion8 | None, Field(title="Discussion")] = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    label: Annotated[Label8 | None, Field(title="Label")] = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action31(Enum):
    locked = "locked"


class AnswerChosenBy9(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Category10(BaseModel):
    created_at: str | None = None
    description: str | None = None
    emoji: str | None = None
    id: int | None = None
    is_answerable: bool | None = None
    name: str | None = None
    node_id: str | None = None
    repository_id: int | None = None
    slug: str | None = None
    updated_at: str | None = None


class Reactions14(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: str | None = None


class State40(Enum):
    locked = "locked"


class User17(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class Locked1(Enum):
    boolean_True = True


class Discussion9(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy9 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category10 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions14 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State40 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User17 | None, Field(title="User")] = None


class WebhookDiscussionLocked(BaseModel):
    action: Action31 | None = None
    discussion: Discussion9 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action32(Enum):
    pinned = "pinned"


class AnswerChosenBy10(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Category11(BaseModel):
    created_at: datetime | None = None
    description: str | None = None
    emoji: str | None = None
    id: int | None = None
    is_answerable: bool | None = None
    name: str | None = None
    node_id: str | None = None
    repository_id: int | None = None
    slug: str | None = None
    updated_at: str | None = None


class Reactions15(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: AnyUrl | None = None


class State41(Enum):
    open = "open"
    locked = "locked"
    converting = "converting"
    transferring = "transferring"


class User18(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Discussion10(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy10 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category11 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions15 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State41 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User18 | None, Field(title="User")] = None


class WebhookDiscussionPinned(BaseModel):
    action: Action32 | None = None
    discussion: Annotated[Discussion10 | None, Field(title="Discussion")] = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action33(Enum):
    transferred = "transferred"


class AnswerChosenBy11(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class User19(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class NewDiscussion(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy11 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category11 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions15 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State41 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User19 | None, Field(title="User")] = None


class License4(BaseModel):
    key: str | None = None
    name: str | None = None
    node_id: str | None = None
    spdx_id: str | None = None
    url: AnyUrl | None = None


class Owner13(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Permissions24(BaseModel):
    admin: bool | None = None
    maintain: bool | None = None
    pull: bool | None = None
    push: bool | None = None
    triage: bool | None = None


class Visibility5(Enum):
    public = "public"
    private = "private"
    internal = "internal"


class NewRepository(BaseModel):
    """
    A git repository
    """

    allow_auto_merge: bool | None = False
    """
    Whether to allow auto-merge for pull requests.
    """
    allow_forking: bool | None = None
    """
    Whether to allow private forks
    """
    allow_merge_commit: bool | None = True
    """
    Whether to allow merge commits for pull requests.
    """
    allow_rebase_merge: bool | None = True
    """
    Whether to allow rebase merges for pull requests.
    """
    allow_squash_merge: bool | None = True
    """
    Whether to allow squash merges for pull requests.
    """
    allow_update_branch: bool | None = None
    archive_url: str | None = None
    archived: bool | None = False
    """
    Whether the repository is archived.
    """
    assignees_url: str | None = None
    blobs_url: str | None = None
    branches_url: str | None = None
    clone_url: AnyUrl | None = None
    collaborators_url: str | None = None
    comments_url: str | None = None
    commits_url: str | None = None
    compare_url: str | None = None
    contents_url: str | None = None
    contributors_url: AnyUrl | None = None
    created_at: int | datetime | None = None
    default_branch: str | None = None
    """
    The default branch of the repository.
    """
    delete_branch_on_merge: bool | None = False
    """
    Whether to delete head branches when pull requests are merged
    """
    deployments_url: AnyUrl | None = None
    description: str | None = None
    disabled: bool | None = None
    """
    Returns whether or not this repository is disabled.
    """
    downloads_url: AnyUrl | None = None
    events_url: AnyUrl | None = None
    fork: bool | None = None
    forks: int | None = None
    forks_count: int | None = None
    forks_url: AnyUrl | None = None
    full_name: str | None = None
    git_commits_url: str | None = None
    git_refs_url: str | None = None
    git_tags_url: str | None = None
    git_url: AnyUrl | None = None
    has_downloads: bool | None = True
    """
    Whether downloads are enabled.
    """
    has_issues: bool | None = True
    """
    Whether issues are enabled.
    """
    has_pages: bool | None = None
    has_projects: bool | None = True
    """
    Whether projects are enabled.
    """
    has_wiki: bool | None = True
    """
    Whether the wiki is enabled.
    """
    homepage: str | None = None
    hooks_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the repository
    """
    is_template: bool | None = None
    issue_comment_url: str | None = None
    issue_events_url: str | None = None
    issues_url: str | None = None
    keys_url: str | None = None
    labels_url: str | None = None
    language: str | None = None
    languages_url: AnyUrl | None = None
    license: Annotated[License4 | None, Field(title="License")] = None
    master_branch: str | None = None
    merges_url: AnyUrl | None = None
    milestones_url: str | None = None
    mirror_url: AnyUrl | None = None
    name: str | None = None
    """
    The name of the repository.
    """
    node_id: str | None = None
    notifications_url: str | None = None
    open_issues: int | None = None
    open_issues_count: int | None = None
    organization: str | None = None
    owner: Annotated[Owner13 | None, Field(title="User")] = None
    permissions: Permissions24 | None = None
    private: bool | None = None
    """
    Whether the repository is private or public.
    """
    public: bool | None = None
    pulls_url: str | None = None
    pushed_at: int | datetime | None = None
    releases_url: str | None = None
    role_name: str | None = None
    size: int | None = None
    ssh_url: str | None = None
    stargazers: int | None = None
    stargazers_count: int | None = None
    stargazers_url: AnyUrl | None = None
    statuses_url: str | None = None
    subscribers_url: AnyUrl | None = None
    subscription_url: AnyUrl | None = None
    svn_url: AnyUrl | None = None
    tags_url: AnyUrl | None = None
    teams_url: AnyUrl | None = None
    topics: Sequence[str] | None = None
    trees_url: str | None = None
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    visibility: Visibility5 | None = None
    watchers: int | None = None
    watchers_count: int | None = None
    web_commit_signoff_required: bool | None = None
    """
    Whether to require contributors to sign off on web-based commits
    """


class Changes4(BaseModel):
    new_discussion: Annotated[NewDiscussion | None, Field(title="Discussion")] = None
    new_repository: Annotated[NewRepository | None, Field(title="Repository")] = None
    """
    A git repository
    """


class AnswerChosenBy12(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class User20(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Discussion11(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy12 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category11 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions15 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State41 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User20 | None, Field(title="User")] = None


class WebhookDiscussionTransferred(BaseModel):
    action: Action33 | None = None
    changes: Changes4 | None = None
    discussion: Annotated[Discussion11 | None, Field(title="Discussion")] = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action34(Enum):
    unanswered = "unanswered"


class AnswerChosenBy13(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Category14(BaseModel):
    created_at: str | None = None
    description: str | None = None
    emoji: str | None = None
    id: int | None = None
    is_answerable: IsAnswerable | None = None
    name: str | None = None
    node_id: str | None = None
    repository_id: int | None = None
    slug: str | None = None
    updated_at: str | None = None


class Reactions18(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: str | None = None


class User21(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class Discussion12(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy13 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category14 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions18 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State41 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User21 | None, Field(title="User")] = None


class Reactions19(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: AnyUrl | None = None


class User22(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class OldAnswer(BaseModel):
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    child_comment_count: int | None = None
    created_at: datetime | None = None
    discussion_id: int | None = None
    html_url: str | None = None
    id: int | None = None
    node_id: str | None = None
    parent_id: Any | None = None
    reactions: Annotated[Reactions19 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User22 | None, Field(title="User")] = None


class WebhookDiscussionUnanswered(BaseModel):
    action: Action34 | None = None
    discussion: Discussion12 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    old_answer: OldAnswer | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action35(Enum):
    unlabeled = "unlabeled"


class AnswerChosenBy14(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Category15(BaseModel):
    created_at: datetime | None = None
    description: str | None = None
    emoji: str | None = None
    id: int | None = None
    is_answerable: bool | None = None
    name: str | None = None
    node_id: str | None = None
    repository_id: int | None = None
    slug: str | None = None
    updated_at: str | None = None


class User23(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Discussion13(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy14 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category15 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions19 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State41 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User23 | None, Field(title="User")] = None


class WebhookDiscussionUnlabeled(BaseModel):
    action: Action35 | None = None
    discussion: Annotated[Discussion13 | None, Field(title="Discussion")] = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    label: Annotated[Label8 | None, Field(title="Label")] = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action36(Enum):
    unlocked = "unlocked"


class AnswerChosenBy15(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Category16(BaseModel):
    created_at: str | None = None
    description: str | None = None
    emoji: str | None = None
    id: int | None = None
    is_answerable: bool | None = None
    name: str | None = None
    node_id: str | None = None
    repository_id: int | None = None
    slug: str | None = None
    updated_at: str | None = None


class Reactions21(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: str | None = None


class State46(Enum):
    open = "open"


class User24(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class Locked2(Enum):
    boolean_False = False


class Discussion14(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy15 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category16 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions21 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State46 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User24 | None, Field(title="User")] = None


class WebhookDiscussionUnlocked(BaseModel):
    action: Action36 | None = None
    discussion: Discussion14 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action37(Enum):
    unpinned = "unpinned"


class AnswerChosenBy16(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Category17(BaseModel):
    created_at: datetime | None = None
    description: str | None = None
    emoji: str | None = None
    id: int | None = None
    is_answerable: bool | None = None
    name: str | None = None
    node_id: str | None = None
    repository_id: int | None = None
    slug: str | None = None
    updated_at: str | None = None


class Reactions22(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: AnyUrl | None = None


class State47(Enum):
    open = "open"
    locked = "locked"
    converting = "converting"
    transferring = "transferring"


class User25(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Discussion15(BaseModel):
    active_lock_reason: str | None = None
    answer_chosen_at: str | None = None
    answer_chosen_by: Annotated[AnswerChosenBy16 | None, Field(title="User")] = None
    answer_html_url: str | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    category: Category17 | None = None
    comments: int | None = None
    created_at: datetime | None = None
    html_url: str | None = None
    id: int | None = None
    locked: bool | None = None
    node_id: str | None = None
    number: int | None = None
    reactions: Annotated[Reactions22 | None, Field(title="Reactions")] = None
    repository_url: str | None = None
    state: State47 | None = None
    timeline_url: str | None = None
    title: str | None = None
    updated_at: datetime | None = None
    user: Annotated[User25 | None, Field(title="User")] = None


class WebhookDiscussionUnpinned(BaseModel):
    action: Action37 | None = None
    discussion: Annotated[Discussion15 | None, Field(title="Discussion")] = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Owner14(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class Fork1(Enum):
    boolean_True = True


class Forkee(BaseModel):
    """
    The created [`repository`](https://docs.github.com/en/rest/reference/repos#get-a-repository) resource.
    """

    allow_auto_merge: bool | None = False
    """
    Whether to allow auto-merge for pull requests.
    """
    allow_forking: bool | None = None
    """
    Whether to allow private forks
    """
    allow_merge_commit: bool | None = True
    """
    Whether to allow merge commits for pull requests.
    """
    allow_rebase_merge: bool | None = True
    """
    Whether to allow rebase merges for pull requests.
    """
    allow_squash_merge: bool | None = True
    """
    Whether to allow squash merges for pull requests.
    """
    allow_update_branch: bool | None = None
    archive_url: str | None = None
    archived: bool | None = False
    """
    Whether the repository is archived.
    """
    assignees_url: str | None = None
    blobs_url: str | None = None
    branches_url: str | None = None
    clone_url: AnyUrl | None = None
    collaborators_url: str | None = None
    comments_url: str | None = None
    commits_url: str | None = None
    compare_url: str | None = None
    contents_url: str | None = None
    contributors_url: AnyUrl | None = None
    created_at: int | datetime | None = None
    default_branch: str | None = None
    """
    The default branch of the repository.
    """
    delete_branch_on_merge: bool | None = False
    """
    Whether to delete head branches when pull requests are merged
    """
    deployments_url: AnyUrl | None = None
    description: str | None = None
    disabled: bool | None = None
    """
    Returns whether or not this repository is disabled.
    """
    downloads_url: AnyUrl | None = None
    events_url: AnyUrl | None = None
    fork: bool | None = None
    forks: int | None = None
    forks_count: int | None = None
    forks_url: AnyUrl | None = None
    full_name: str | None = None
    git_commits_url: str | None = None
    git_refs_url: str | None = None
    git_tags_url: str | None = None
    git_url: AnyUrl | None = None
    has_downloads: bool | None = True
    """
    Whether downloads are enabled.
    """
    has_issues: bool | None = True
    """
    Whether issues are enabled.
    """
    has_pages: bool | None = None
    has_projects: bool | None = True
    """
    Whether projects are enabled.
    """
    has_wiki: bool | None = True
    """
    Whether the wiki is enabled.
    """
    homepage: str | None = None
    hooks_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the repository
    """
    is_template: bool | None = None
    issue_comment_url: str | None = None
    issue_events_url: str | None = None
    issues_url: str | None = None
    keys_url: str | None = None
    labels_url: str | None = None
    language: str | None = None
    languages_url: AnyUrl | None = None
    license: Annotated[License4 | None, Field(title="License")] = None
    master_branch: str | None = None
    merges_url: AnyUrl | None = None
    milestones_url: str | None = None
    mirror_url: AnyUrl | None = None
    name: str | None = None
    """
    The name of the repository.
    """
    node_id: str | None = None
    notifications_url: str | None = None
    open_issues: int | None = None
    open_issues_count: int | None = None
    organization: str | None = None
    owner: Annotated[Owner14 | None, Field(title="User")] = None
    permissions: Permissions24 | None = None
    private: bool | None = None
    """
    Whether the repository is private or public.
    """
    public: bool | None = None
    pulls_url: str | None = None
    pushed_at: int | datetime | None = None
    releases_url: str | None = None
    role_name: str | None = None
    size: int | None = None
    ssh_url: str | None = None
    stargazers: int | None = None
    stargazers_count: int | None = None
    stargazers_url: AnyUrl | None = None
    statuses_url: str | None = None
    subscribers_url: AnyUrl | None = None
    subscription_url: AnyUrl | None = None
    svn_url: AnyUrl | None = None
    tags_url: AnyUrl | None = None
    teams_url: AnyUrl | None = None
    topics: Sequence[str] | None = None
    trees_url: str | None = None
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    visibility: Visibility5 | None = None
    watchers: int | None = None
    watchers_count: int | None = None
    web_commit_signoff_required: bool | None = None
    """
    Whether to require contributors to sign off on web-based commits
    """


class WebhookFork(BaseModel):
    """
    A user forks a repository.
    """

    enterprise: Enterprise | None = None
    forkee: Forkee | None = None
    """
    The created [`repository`](https://docs.github.com/en/rest/reference/repos#get-a-repository) resource.
    """
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action38(Enum):
    revoked = "revoked"


class WebhookGithubAppAuthorizationRevoked(BaseModel):
    action: Action38 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action39(Enum):
    """
    The action that was performed on the page. Can be `created` or `edited`.
    """

    created = "created"
    edited = "edited"


class Page2(BaseModel):
    action: Action39 | None = None
    """
    The action that was performed on the page. Can be `created` or `edited`.
    """
    html_url: AnyUrl | None = None
    """
    Points to the HTML wiki page.
    """
    page_name: str | None = None
    """
    The name of the page.
    """
    sha: str | None = None
    """
    The latest commit SHA of the page.
    """
    summary: str | None = None
    title: str | None = None
    """
    The current page title.
    """


class WebhookGollum(BaseModel):
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    pages: Sequence[Page2] | None = None
    """
    The pages that were updated.
    """
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action40(Enum):
    created = "created"


class Repository3(BaseModel):
    full_name: str | None = None
    id: int | None = None
    """
    Unique identifier of the repository
    """
    name: str | None = None
    """
    The name of the repository.
    """
    node_id: str | None = None
    private: bool | None = None
    """
    Whether the repository is private or public.
    """


class Requester(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class WebhookInstallationCreated(BaseModel):
    action: Action40 | None = None
    enterprise: Enterprise | None = None
    installation: Installation | None = None
    organization: OrganizationSimple | None = None
    repositories: Sequence[Repository3] | None = None
    """
    An array of repository objects that the installation can access.
    """
    repository: Repository | None = None
    requester: Annotated[Requester | None, Field(title="User")] = None
    sender: SimpleUser | None = None


class Action41(Enum):
    deleted = "deleted"


class WebhookInstallationDeleted(BaseModel):
    action: Action41 | None = None
    enterprise: Enterprise | None = None
    installation: Installation | None = None
    organization: OrganizationSimple | None = None
    repositories: Sequence[Repository3] | None = None
    """
    An array of repository objects that the installation can access.
    """
    repository: Repository | None = None
    requester: Any | None = None
    sender: SimpleUser | None = None


class Action42(Enum):
    new_permissions_accepted = "new_permissions_accepted"


class WebhookInstallationNewPermissionsAccepted(BaseModel):
    action: Action42 | None = None
    enterprise: Enterprise | None = None
    installation: Installation | None = None
    organization: OrganizationSimple | None = None
    repositories: Sequence[Repository3] | None = None
    """
    An array of repository objects that the installation can access.
    """
    repository: Repository | None = None
    requester: Any | None = None
    sender: SimpleUser | None = None


class Action43(Enum):
    added = "added"


class RepositoriesAddedItem(BaseModel):
    full_name: str | None = None
    id: int | None = None
    """
    Unique identifier of the repository
    """
    name: str | None = None
    """
    The name of the repository.
    """
    node_id: str | None = None
    private: bool | None = None
    """
    Whether the repository is private or public.
    """


class RepositoriesRemovedItem(BaseModel):
    full_name: str | None = None
    id: int | None = None
    """
    Unique identifier of the repository
    """
    name: str | None = None
    """
    The name of the repository.
    """
    node_id: str | None = None
    private: bool | None = None
    """
    Whether the repository is private or public.
    """


class Requester1(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class WebhookInstallationRepositoriesAdded(BaseModel):
    action: Action43 | None = None
    enterprise: Enterprise | None = None
    installation: Installation | None = None
    organization: OrganizationSimple | None = None
    repositories_added: Sequence[RepositoriesAddedItem] | None = None
    """
    An array of repository objects, which were added to the installation.
    """
    repositories_removed: Sequence[RepositoriesRemovedItem] | None = None
    """
    An array of repository objects, which were removed from the installation.
    """
    repository: Repository | None = None
    repository_selection: RepositorySelection2 | None = None
    """
    Describe whether all repositories have been selected or there's a selection involved
    """
    requester: Annotated[Requester1 | None, Field(title="User")] = None
    sender: SimpleUser | None = None


class Action44(Enum):
    removed = "removed"


class Requester2(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class WebhookInstallationRepositoriesRemoved(BaseModel):
    action: Action44 | None = None
    enterprise: Enterprise | None = None
    installation: Installation | None = None
    organization: OrganizationSimple | None = None
    repositories_added: Sequence[RepositoriesAddedItem] | None = None
    """
    An array of repository objects, which were added to the installation.
    """
    repositories_removed: Sequence[RepositoriesRemovedItem] | None = None
    """
    An array of repository objects, which were removed from the installation.
    """
    repository: Repository | None = None
    repository_selection: RepositorySelection2 | None = None
    """
    Describe whether all repositories have been selected or there's a selection involved
    """
    requester: Annotated[Requester2 | None, Field(title="User")] = None
    sender: SimpleUser | None = None


class Action45(Enum):
    suspend = "suspend"


class WebhookInstallationSuspend(BaseModel):
    action: Action45 | None = None
    enterprise: Enterprise | None = None
    installation: Installation | None = None
    organization: OrganizationSimple | None = None
    repositories: Sequence[Repository3] | None = None
    """
    An array of repository objects that the installation can access.
    """
    repository: Repository | None = None
    requester: Any | None = None
    sender: SimpleUser | None = None


class Account(BaseModel):
    avatar_url: str | None = None
    created_at: str | None = None
    description: Any | None = None
    events_url: str | None = None
    followers: int | None = None
    followers_url: str | None = None
    following: int | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    has_organization_projects: bool | None = None
    has_repository_projects: bool | None = None
    hooks_url: str | None = None
    html_url: str | None = None
    id: int | None = None
    is_verified: bool | None = None
    issues_url: str | None = None
    login: str | None = None
    members_url: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    public_gists: int | None = None
    public_members_url: str | None = None
    public_repos: int | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    slug: str | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    updated_at: str | None = None
    url: str | None = None
    website_url: Any | None = None


class Login(BaseModel):
    from_: Annotated[str | None, Field(alias="from")] = None


class Slug(BaseModel):
    from_: Annotated[str | None, Field(alias="from")] = None


class Changes5(BaseModel):
    login: Login | None = None
    slug: Slug | None = None


class WebhookInstallationTargetRenamed(BaseModel):
    account: Account | None = None
    action: str | None = None
    changes: Changes5 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None
    target_type: str | None = None


class Action46(Enum):
    unsuspend = "unsuspend"


class WebhookInstallationUnsuspend(BaseModel):
    action: Action46 | None = None
    enterprise: Enterprise | None = None
    installation: Installation | None = None
    organization: OrganizationSimple | None = None
    repositories: Sequence[Repository3] | None = None
    """
    An array of repository objects that the installation can access.
    """
    repository: Repository | None = None
    requester: Any | None = None
    sender: SimpleUser | None = None


class Action47(Enum):
    created = "created"


class User26(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type7 | None = None
    url: AnyUrl | None = None


class Comment4(BaseModel):
    """
    The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.
    """

    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue comment
    """
    created_at: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the issue comment
    """
    issue_url: AnyUrl | None = None
    node_id: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    reactions: Annotated[Reactions22 | None, Field(title="Reactions")] = None
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue comment
    """
    user: Annotated[User26 | None, Field(title="User")] = None


class ActiveLockReasonEnum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Type67(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class Assignee(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type67 | None = None
    url: AnyUrl | None = None


class Assignee1(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type67 | None = None
    url: AnyUrl | None = None


class Creator3(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type67 | None = None
    url: AnyUrl | None = None


class State48(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone3(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator3 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State48 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event5(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"
    reminder = "reminder"
    pull_request_review_thread = "pull_request_review_thread"


class Type70(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Owner15(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type70 | None = None
    url: AnyUrl | None = None


class OrganizationProjects5(Enum):
    read = "read"
    write = "write"
    admin = "admin"


class RepositoryProjects5(Enum):
    read = "read"
    write = "write"
    admin = "admin"


class Permissions26(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects5 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects5 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp3(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event5] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner15 | None, Field(title="User")] = None
    permissions: Permissions26 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class PullRequest10(BaseModel):
    diff_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    merged_at: datetime | None = None
    patch_url: AnyUrl | None = None
    url: AnyUrl | None = None


class Reactions24(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: str | None = None


class State49(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class Type71(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class User27(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class Issue1(BaseModel):
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.
    """

    active_lock_reason: ActiveLockReasonEnum | None = None
    assignee: Annotated[Assignee | None, Field(title="User")] = None
    assignees: Sequence[Assignee1] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone3 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp3 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions24 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State49 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User27 | None, Field(title="User")] = None


class WebhookIssueCommentCreated(BaseModel):
    action: Action47 | None = None
    comment: Annotated[Comment4 | None, Field(title="issue comment")] = None
    """
    The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Issue1 | None = None
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action48(Enum):
    deleted = "deleted"


class Reactions25(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: AnyUrl | None = None


class User28(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type71 | None = None
    url: AnyUrl | None = None


class Comment5(BaseModel):
    """
    The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.
    """

    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue comment
    """
    created_at: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the issue comment
    """
    issue_url: AnyUrl | None = None
    node_id: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    reactions: Annotated[Reactions25 | None, Field(title="Reactions")] = None
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue comment
    """
    user: Annotated[User28 | None, Field(title="User")] = None


class ActiveLockReason1Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Assignee2(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type71 | None = None
    url: AnyUrl | None = None


class Assignee3(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type71 | None = None
    url: AnyUrl | None = None


class Creator4(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type71 | None = None
    url: AnyUrl | None = None


class State50(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone4(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator4 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State50 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event6(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"


class Type76(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Owner16(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type76 | None = None
    url: AnyUrl | None = None


class OrganizationProjects6(Enum):
    read = "read"
    write = "write"


class RepositoryProjects6(Enum):
    read = "read"
    write = "write"


class Permissions27(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects6 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects6 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp4(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event6] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner16 | None, Field(title="User")] = None
    permissions: Permissions27 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Reactions26(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: str | None = None


class State51(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class Type77(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class User29(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class Issue2(BaseModel):
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.
    """

    active_lock_reason: ActiveLockReason1Enum | None = None
    assignee: Annotated[Assignee2 | None, Field(title="User")] = None
    assignees: Sequence[Assignee3] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone4 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp4 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions26 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State51 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User29 | None, Field(title="User")] = None


class WebhookIssueCommentDeleted(BaseModel):
    action: Action48 | None = None
    comment: Annotated[Comment5 | None, Field(title="issue comment")] = None
    """
    The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Issue2 | None = None
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action49(Enum):
    edited = "edited"


class Body2(BaseModel):
    from_: Annotated[str | None, Field(alias="from")] = None
    """
    The previous version of the body.
    """


class Changes6(BaseModel):
    """
    The changes to the comment.
    """

    body: Body2 | None = None


class Reactions27(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: AnyUrl | None = None


class User30(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type77 | None = None
    url: AnyUrl | None = None


class Comment6(BaseModel):
    """
    The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.
    """

    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue comment
    """
    created_at: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the issue comment
    """
    issue_url: AnyUrl | None = None
    node_id: str | None = None
    performed_via_github_app: NullableIntegration | None = None
    reactions: Annotated[Reactions27 | None, Field(title="Reactions")] = None
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue comment
    """
    user: Annotated[User30 | None, Field(title="User")] = None


class ActiveLockReason2Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Assignee4(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type77 | None = None
    url: AnyUrl | None = None


class Assignee5(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type77 | None = None
    url: AnyUrl | None = None


class Creator5(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type77 | None = None
    url: AnyUrl | None = None


class State52(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone5(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator5 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State52 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event7(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"
    reminder = "reminder"
    pull_request_review_thread = "pull_request_review_thread"


class Type82(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Owner17(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type82 | None = None
    url: AnyUrl | None = None


class OrganizationProjects7(Enum):
    read = "read"
    write = "write"
    admin = "admin"


class Permissions28(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects7 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects6 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp5(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event7] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner17 | None, Field(title="User")] = None
    permissions: Permissions28 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Reactions28(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: str | None = None


class State53(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class Type83(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class User31(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class Issue3(BaseModel):
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.
    """

    active_lock_reason: ActiveLockReason2Enum | None = None
    assignee: Annotated[Assignee4 | None, Field(title="User")] = None
    assignees: Sequence[Assignee5] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone5 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp5 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions28 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State53 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User31 | None, Field(title="User")] = None


class WebhookIssueCommentEdited(BaseModel):
    action: Action49 | None = None
    changes: Changes6 | None = None
    """
    The changes to the comment.
    """
    comment: Annotated[Comment6 | None, Field(title="issue comment")] = None
    """
    The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Issue3 | None = None
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action50(Enum):
    """
    The action that was performed.
    """

    assigned = "assigned"


class Type84(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Assignee6(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type84 | None = None
    url: AnyUrl | None = None


class ActiveLockReason3Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Type85(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class Assignee7(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type85 | None = None
    url: AnyUrl | None = None


class Assignee8(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type85 | None = None
    url: AnyUrl | None = None


class Creator6(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type85 | None = None
    url: AnyUrl | None = None


class State54(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone6(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator6 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State54 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Type88(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Owner18(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type88 | None = None
    url: AnyUrl | None = None


class Permissions29(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects7 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects6 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp6(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event7] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner18 | None, Field(title="User")] = None
    permissions: Permissions29 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Reactions29(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: AnyUrl | None = None


class State55(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class Type89(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class User32(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type89 | None = None
    url: AnyUrl | None = None


class Issue4(BaseModel):
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: ActiveLockReason3Enum | None = None
    assignee: Annotated[Assignee7 | None, Field(title="User")] = None
    assignees: Sequence[Assignee8] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone6 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp6 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions29 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State55 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User32 | None, Field(title="User")] = None


class WebhookIssuesAssigned(BaseModel):
    action: Action50 | None = None
    """
    The action that was performed.
    """
    assignee: Annotated[Assignee6 | None, Field(title="User")] = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Annotated[Issue4 | None, Field(title="Issue")] = None
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action51(Enum):
    """
    The action that was performed.
    """

    closed = "closed"


class ActiveLockReason4Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Assignee9(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type89 | None = None
    url: AnyUrl | None = None


class Assignee10(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type89 | None = None
    url: AnyUrl | None = None


class Creator7(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type89 | None = None
    url: AnyUrl | None = None


class State56(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone7(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator7 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State56 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event9(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"
    security_and_analysis = "security_and_analysis"
    reminder = "reminder"
    pull_request_review_thread = "pull_request_review_thread"


class Type93(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Owner19(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type93 | None = None
    url: AnyUrl | None = None


class Permissions30(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects7 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects6 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp7(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event9] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner19 | None, Field(title="User")] = None
    permissions: Permissions30 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Reactions30(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: str | None = None


class State57(Enum):
    closed = "closed"
    open = "open"


class Type94(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class User33(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class Issue5(BaseModel):
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: ActiveLockReason4Enum | None = None
    assignee: Annotated[Assignee9 | None, Field(title="User")] = None
    assignees: Sequence[Assignee10] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone7 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp7 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions30 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State57 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User33 | None, Field(title="User")] = None


class WebhookIssuesClosed(BaseModel):
    action: Action51 | None = None
    """
    The action that was performed.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Issue5 | None = None
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action52(Enum):
    deleted = "deleted"


class ActiveLockReason5Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Type95(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Assignee11(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type95 | None = None
    url: AnyUrl | None = None


class Assignee12(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type95 | None = None
    url: AnyUrl | None = None


class Creator8(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type95 | None = None
    url: AnyUrl | None = None


class State58(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone8(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator8 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State58 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event10(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"
    reminder = "reminder"


class Owner20(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type95 | None = None
    url: AnyUrl | None = None


class OrganizationProjects10(Enum):
    read = "read"
    write = "write"


class Permissions31(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects10 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects6 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp8(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event10] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner20 | None, Field(title="User")] = None
    permissions: Permissions31 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Reactions31(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: AnyUrl | None = None


class State59(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class User34(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type95 | None = None
    url: AnyUrl | None = None


class Issue6(BaseModel):
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: ActiveLockReason5Enum | None = None
    assignee: Annotated[Assignee11 | None, Field(title="User")] = None
    assignees: Sequence[Assignee12] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone8 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp8 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions31 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State59 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User34 | None, Field(title="User")] = None


class WebhookIssuesDeleted(BaseModel):
    action: Action52 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Annotated[Issue6 | None, Field(title="Issue")] = None
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action53(Enum):
    demilestoned = "demilestoned"


class ActiveLockReason6Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Type100(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class Assignee13(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type100 | None = None
    url: AnyUrl | None = None


class Assignee14(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type100 | None = None
    url: AnyUrl | None = None


class Creator9(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type100 | None = None
    url: AnyUrl | None = None


class State60(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone9(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator9 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State60 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event11(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"


class Type103(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Owner21(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type103 | None = None
    url: AnyUrl | None = None


class OrganizationProjects11(Enum):
    read = "read"
    write = "write"
    admin = "admin"


class Permissions32(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects11 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects6 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp9(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event11] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner21 | None, Field(title="User")] = None
    permissions: Permissions32 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Reactions32(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: str | None = None


class State61(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class Type104(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class User35(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class Issue7(BaseModel):
    active_lock_reason: ActiveLockReason6Enum | None = None
    assignee: Annotated[Assignee13 | None, Field(title="User")] = None
    assignees: Sequence[Assignee14] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone9 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp9 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions32 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State61 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User35 | None, Field(title="User")] = None


class Creator10(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type104 | None = None
    url: AnyUrl | None = None


class State62(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone10(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator10 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State62 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class WebhookIssuesDemilestoned(BaseModel):
    action: Action53 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Issue7 | None = None
    milestone: Annotated[Milestone10 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action54(Enum):
    edited = "edited"


class Title1(BaseModel):
    from_: Annotated[str | None, Field(alias="from")] = None
    """
    The previous version of the title.
    """


class Changes7(BaseModel):
    """
    The changes to the issue.
    """

    body: Body2 | None = None
    title: Title1 | None = None


class ActiveLockReason7Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Assignee15(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type104 | None = None
    url: AnyUrl | None = None


class Assignee16(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type104 | None = None
    url: AnyUrl | None = None


class Creator11(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type104 | None = None
    url: AnyUrl | None = None


class Milestone11(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator11 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State62 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event12(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"
    security_and_analysis = "security_and_analysis"
    pull_request_review_thread = "pull_request_review_thread"
    reminder = "reminder"


class Type109(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Owner22(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type109 | None = None
    url: AnyUrl | None = None


class Permissions33(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects11 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects6 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp10(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event12] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner22 | None, Field(title="User")] = None
    permissions: Permissions33 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Reactions33(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: AnyUrl | None = None


class State64(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class Type110(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class User36(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type110 | None = None
    url: AnyUrl | None = None


class Issue8(BaseModel):
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: ActiveLockReason7Enum | None = None
    assignee: Annotated[Assignee15 | None, Field(title="User")] = None
    assignees: Sequence[Assignee16] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone11 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp10 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions33 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State64 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User36 | None, Field(title="User")] = None


class WebhookIssuesEdited(BaseModel):
    action: Action54 | None = None
    changes: Changes7 | None = None
    """
    The changes to the issue.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Annotated[Issue8 | None, Field(title="Issue")] = None
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """
    label: Annotated[Label8 | None, Field(title="Label")] = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action55(Enum):
    labeled = "labeled"


class ActiveLockReason8Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Assignee17(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type110 | None = None
    url: AnyUrl | None = None


class Assignee18(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type110 | None = None
    url: AnyUrl | None = None


class Creator12(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type110 | None = None
    url: AnyUrl | None = None


class State65(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone12(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator12 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State65 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event13(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"
    pull_request_review_thread = "pull_request_review_thread"
    reminder = "reminder"


class Type114(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Owner23(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type114 | None = None
    url: AnyUrl | None = None


class Permissions34(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects11 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects6 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp11(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event13] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner23 | None, Field(title="User")] = None
    permissions: Permissions34 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class State66(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class Type115(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class User37(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type115 | None = None
    url: AnyUrl | None = None


class Issue9(BaseModel):
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: ActiveLockReason8Enum | None = None
    assignee: Annotated[Assignee17 | None, Field(title="User")] = None
    assignees: Sequence[Assignee18] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone12 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp11 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions33 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State66 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User37 | None, Field(title="User")] = None


class WebhookIssuesLabeled(BaseModel):
    action: Action55 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Annotated[Issue9 | None, Field(title="Issue")] = None
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """
    label: Annotated[Label8 | None, Field(title="Label")] = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action56(Enum):
    locked = "locked"


class ActiveLockReason9Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class ActiveLockReason9(BaseModel):
    __root__: ActiveLockReason9Enum | None = None


class Type116(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Assignee19(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type116 | None = None
    url: AnyUrl | None = None


class Assignee20(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type116 | None = None
    url: AnyUrl | None = None


class Creator13(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type116 | None = None
    url: AnyUrl | None = None


class State67(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone13(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator13 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State67 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event14(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"
    reminder = "reminder"
    security_and_analysis = "security_and_analysis"


class Owner24(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type116 | None = None
    url: AnyUrl | None = None


class OrganizationProjects14(Enum):
    read = "read"
    write = "write"


class Permissions35(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects14 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects6 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp12(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event14] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner24 | None, Field(title="User")] = None
    permissions: Permissions35 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Reactions35(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: str | None = None


class State68(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class User38(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class Locked3(Enum):
    boolean_True = True


class Issue10(BaseModel):
    active_lock_reason: ActiveLockReason9Enum | None = None
    assignee: Annotated[Assignee19 | None, Field(title="User")] = None
    assignees: Sequence[Assignee20] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone13 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp12 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions35 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State68 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User38 | None, Field(title="User")] = None


class WebhookIssuesLocked(BaseModel):
    action: Action56 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Issue10 | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action57(Enum):
    milestoned = "milestoned"


class ActiveLockReason10Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Assignee21(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type116 | None = None
    url: AnyUrl | None = None


class Assignee22(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type116 | None = None
    url: AnyUrl | None = None


class Type123(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class Creator14(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type123 | None = None
    url: AnyUrl | None = None


class State69(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone14(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator14 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State69 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event15(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"
    reminder = "reminder"


class Type124(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Owner25(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type124 | None = None
    url: AnyUrl | None = None


class OrganizationProjects15(Enum):
    read = "read"
    write = "write"
    admin = "admin"


class Permissions36(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects15 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects6 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp13(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event15] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner25 | None, Field(title="User")] = None
    permissions: Permissions36 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class State70(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class Issue11(BaseModel):
    active_lock_reason: ActiveLockReason10Enum | None = None
    assignee: Annotated[Assignee21 | None, Field(title="User")] = None
    assignees: Sequence[Assignee22] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone14 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp13 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions35 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State70 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User38 | None, Field(title="User")] = None


class Type126(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class Creator15(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type126 | None = None
    url: AnyUrl | None = None


class State71(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone15(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator15 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State71 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class WebhookIssuesMilestoned(BaseModel):
    action: Action57 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Issue11 | None = None
    milestone: Annotated[Milestone15 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action58(Enum):
    opened = "opened"


class ActiveLockReason11Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Type127(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Assignee23(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type127 | None = None
    url: AnyUrl | None = None


class Assignee24(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type127 | None = None
    url: AnyUrl | None = None


class Creator16(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type127 | None = None
    url: AnyUrl | None = None


class Milestone16(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator16 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State71 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event16(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"


class Owner26(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type127 | None = None
    url: AnyUrl | None = None


class OrganizationProjects16(Enum):
    read = "read"
    write = "write"


class Permissions37(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects16 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects6 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp14(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event16] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner26 | None, Field(title="User")] = None
    permissions: Permissions37 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Reactions37(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: AnyUrl | None = None


class State73(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class User40(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type127 | None = None
    url: AnyUrl | None = None


class OldIssue(BaseModel):
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: ActiveLockReason11Enum | None = None
    assignee: Annotated[Assignee23 | None, Field(title="User")] = None
    assignees: Sequence[Assignee24] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone16 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp14 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions37 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State73 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User40 | None, Field(title="User")] = None


class Owner27(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type127 | None = None
    url: AnyUrl | None = None


class Permissions38(BaseModel):
    admin: bool | None = None
    maintain: bool | None = None
    pull: bool | None = None
    push: bool | None = None
    triage: bool | None = None


class OldRepository(BaseModel):
    """
    A git repository
    """

    allow_auto_merge: bool | None = False
    """
    Whether to allow auto-merge for pull requests.
    """
    allow_forking: bool | None = None
    """
    Whether to allow private forks
    """
    allow_merge_commit: bool | None = True
    """
    Whether to allow merge commits for pull requests.
    """
    allow_rebase_merge: bool | None = True
    """
    Whether to allow rebase merges for pull requests.
    """
    allow_squash_merge: bool | None = True
    """
    Whether to allow squash merges for pull requests.
    """
    allow_update_branch: bool | None = None
    archive_url: str | None = None
    archived: bool | None = False
    """
    Whether the repository is archived.
    """
    assignees_url: str | None = None
    blobs_url: str | None = None
    branches_url: str | None = None
    clone_url: AnyUrl | None = None
    collaborators_url: str | None = None
    comments_url: str | None = None
    commits_url: str | None = None
    compare_url: str | None = None
    contents_url: str | None = None
    contributors_url: AnyUrl | None = None
    created_at: int | datetime | None = None
    default_branch: str | None = None
    """
    The default branch of the repository.
    """
    delete_branch_on_merge: bool | None = False
    """
    Whether to delete head branches when pull requests are merged
    """
    deployments_url: AnyUrl | None = None
    description: str | None = None
    disabled: bool | None = None
    """
    Returns whether or not this repository is disabled.
    """
    downloads_url: AnyUrl | None = None
    events_url: AnyUrl | None = None
    fork: bool | None = None
    forks: int | None = None
    forks_count: int | None = None
    forks_url: AnyUrl | None = None
    full_name: str | None = None
    git_commits_url: str | None = None
    git_refs_url: str | None = None
    git_tags_url: str | None = None
    git_url: AnyUrl | None = None
    has_downloads: bool | None = True
    """
    Whether downloads are enabled.
    """
    has_issues: bool | None = True
    """
    Whether issues are enabled.
    """
    has_pages: bool | None = None
    has_projects: bool | None = True
    """
    Whether projects are enabled.
    """
    has_wiki: bool | None = True
    """
    Whether the wiki is enabled.
    """
    homepage: str | None = None
    hooks_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the repository
    """
    is_template: bool | None = None
    issue_comment_url: str | None = None
    issue_events_url: str | None = None
    issues_url: str | None = None
    keys_url: str | None = None
    labels_url: str | None = None
    language: str | None = None
    languages_url: AnyUrl | None = None
    license: Annotated[License4 | None, Field(title="License")] = None
    master_branch: str | None = None
    merges_url: AnyUrl | None = None
    milestones_url: str | None = None
    mirror_url: AnyUrl | None = None
    name: str | None = None
    """
    The name of the repository.
    """
    node_id: str | None = None
    notifications_url: str | None = None
    open_issues: int | None = None
    open_issues_count: int | None = None
    organization: str | None = None
    owner: Annotated[Owner27 | None, Field(title="User")] = None
    permissions: Permissions38 | None = None
    private: bool | None = None
    """
    Whether the repository is private or public.
    """
    public: bool | None = None
    pulls_url: str | None = None
    pushed_at: int | datetime | None = None
    releases_url: str | None = None
    role_name: str | None = None
    size: int | None = None
    ssh_url: str | None = None
    stargazers: int | None = None
    stargazers_count: int | None = None
    stargazers_url: AnyUrl | None = None
    statuses_url: str | None = None
    subscribers_url: AnyUrl | None = None
    subscription_url: AnyUrl | None = None
    svn_url: AnyUrl | None = None
    tags_url: AnyUrl | None = None
    teams_url: AnyUrl | None = None
    topics: Sequence[str] | None = None
    trees_url: str | None = None
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    visibility: Visibility5 | None = None
    watchers: int | None = None
    watchers_count: int | None = None


class Changes8(BaseModel):
    old_issue: Annotated[OldIssue | None, Field(title="Issue")] = None
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """
    old_repository: Annotated[OldRepository | None, Field(title="Repository")] = None
    """
    A git repository
    """


class ActiveLockReason12Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Assignee25(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type127 | None = None
    url: AnyUrl | None = None


class Assignee26(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type127 | None = None
    url: AnyUrl | None = None


class Type135(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class Creator17(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type135 | None = None
    url: AnyUrl | None = None


class State74(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone17(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator17 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State74 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event17(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"
    security_and_analysis = "security_and_analysis"
    pull_request_review_thread = "pull_request_review_thread"
    reminder = "reminder"


class Type136(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Owner28(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type136 | None = None
    url: AnyUrl | None = None


class OrganizationProjects17(Enum):
    read = "read"
    write = "write"
    admin = "admin"


class Permissions39(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects17 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects6 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp15(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event17] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner28 | None, Field(title="User")] = None
    permissions: Permissions39 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Reactions38(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: str | None = None


class State75(Enum):
    open = "open"
    closed = "closed"


class User41(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class Issue12(BaseModel):
    active_lock_reason: ActiveLockReason12Enum | None = None
    assignee: Annotated[Assignee25 | None, Field(title="User")] = None
    assignees: Sequence[Assignee26] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone17 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp15 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions38 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State75 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User41 | None, Field(title="User")] = None


class WebhookIssuesOpened(BaseModel):
    action: Action58 | None = None
    changes: Changes8 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Issue12 | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action59(Enum):
    pinned = "pinned"


class ActiveLockReason13Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Assignee27(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type136 | None = None
    url: AnyUrl | None = None


class Assignee28(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type136 | None = None
    url: AnyUrl | None = None


class Creator18(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type136 | None = None
    url: AnyUrl | None = None


class State76(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone18(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator18 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State76 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event18(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"


class Owner29(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type136 | None = None
    url: AnyUrl | None = None


class OrganizationProjects18(Enum):
    read = "read"
    write = "write"


class Permissions40(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects18 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects6 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp16(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event18] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner29 | None, Field(title="User")] = None
    permissions: Permissions40 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Reactions39(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: AnyUrl | None = None


class State77(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class User42(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type136 | None = None
    url: AnyUrl | None = None


class Issue13(BaseModel):
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: ActiveLockReason13Enum | None = None
    assignee: Annotated[Assignee27 | None, Field(title="User")] = None
    assignees: Sequence[Assignee28] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone18 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp16 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions39 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State77 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User42 | None, Field(title="User")] = None


class WebhookIssuesPinned(BaseModel):
    action: Action59 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Annotated[Issue13 | None, Field(title="Issue")] = None
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action60(Enum):
    reopened = "reopened"


class ActiveLockReason14Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Assignee29(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type136 | None = None
    url: AnyUrl | None = None


class Type144(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class Assignee30(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type144 | None = None
    url: AnyUrl | None = None


class Creator19(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type144 | None = None
    url: AnyUrl | None = None


class State78(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone19(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator19 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State78 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event19(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"
    pull_request_review_thread = "pull_request_review_thread"
    reminder = "reminder"


class Type146(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Owner30(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type146 | None = None
    url: AnyUrl | None = None


class OrganizationProjects19(Enum):
    read = "read"
    write = "write"
    admin = "admin"


class RepositoryProjects19(Enum):
    read = "read"
    write = "write"
    admin = "admin"


class Permissions41(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects19 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects19 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp17(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event19] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner30 | None, Field(title="User")] = None
    permissions: Permissions41 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Reactions40(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: str | None = None


class State79(Enum):
    open = "open"
    closed = "closed"


class Type147(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class User43(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class Issue14(BaseModel):
    active_lock_reason: ActiveLockReason14Enum | None = None
    assignee: Annotated[Assignee29 | None, Field(title="User")] = None
    assignees: Sequence[Assignee30] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone19 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp17 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions40 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State79 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User43 | None, Field(title="User")] = None


class WebhookIssuesReopened(BaseModel):
    action: Action60 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Issue14 | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action61(Enum):
    transferred = "transferred"


class ActiveLockReason15Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Type148(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Assignee31(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type148 | None = None
    url: AnyUrl | None = None


class Assignee32(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type148 | None = None
    url: AnyUrl | None = None


class Creator20(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type148 | None = None
    url: AnyUrl | None = None


class State80(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone20(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator20 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State80 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event20(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"


class Owner31(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type148 | None = None
    url: AnyUrl | None = None


class OrganizationProjects20(Enum):
    read = "read"
    write = "write"


class RepositoryProjects20(Enum):
    read = "read"
    write = "write"


class Permissions42(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects20 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects20 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp18(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event20] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner31 | None, Field(title="User")] = None
    permissions: Permissions42 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Reactions41(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: AnyUrl | None = None


class State81(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class User44(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type148 | None = None
    url: AnyUrl | None = None


class NewIssue(BaseModel):
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: ActiveLockReason15Enum | None = None
    assignee: Annotated[Assignee31 | None, Field(title="User")] = None
    assignees: Sequence[Assignee32] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone20 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp18 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions41 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State81 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User44 | None, Field(title="User")] = None


class Owner32(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type148 | None = None
    url: AnyUrl | None = None


class Permissions43(BaseModel):
    admin: bool | None = None
    maintain: bool | None = None
    pull: bool | None = None
    push: bool | None = None
    triage: bool | None = None


class NewRepository1(BaseModel):
    """
    A git repository
    """

    allow_auto_merge: bool | None = False
    """
    Whether to allow auto-merge for pull requests.
    """
    allow_forking: bool | None = None
    """
    Whether to allow private forks
    """
    allow_merge_commit: bool | None = True
    """
    Whether to allow merge commits for pull requests.
    """
    allow_rebase_merge: bool | None = True
    """
    Whether to allow rebase merges for pull requests.
    """
    allow_squash_merge: bool | None = True
    """
    Whether to allow squash merges for pull requests.
    """
    allow_update_branch: bool | None = None
    archive_url: str | None = None
    archived: bool | None = False
    """
    Whether the repository is archived.
    """
    assignees_url: str | None = None
    blobs_url: str | None = None
    branches_url: str | None = None
    clone_url: AnyUrl | None = None
    collaborators_url: str | None = None
    comments_url: str | None = None
    commits_url: str | None = None
    compare_url: str | None = None
    contents_url: str | None = None
    contributors_url: AnyUrl | None = None
    created_at: int | datetime | None = None
    default_branch: str | None = None
    """
    The default branch of the repository.
    """
    delete_branch_on_merge: bool | None = False
    """
    Whether to delete head branches when pull requests are merged
    """
    deployments_url: AnyUrl | None = None
    description: str | None = None
    disabled: bool | None = None
    """
    Returns whether or not this repository is disabled.
    """
    downloads_url: AnyUrl | None = None
    events_url: AnyUrl | None = None
    fork: bool | None = None
    forks: int | None = None
    forks_count: int | None = None
    forks_url: AnyUrl | None = None
    full_name: str | None = None
    git_commits_url: str | None = None
    git_refs_url: str | None = None
    git_tags_url: str | None = None
    git_url: AnyUrl | None = None
    has_downloads: bool | None = True
    """
    Whether downloads are enabled.
    """
    has_issues: bool | None = True
    """
    Whether issues are enabled.
    """
    has_pages: bool | None = None
    has_projects: bool | None = True
    """
    Whether projects are enabled.
    """
    has_wiki: bool | None = True
    """
    Whether the wiki is enabled.
    """
    homepage: str | None = None
    hooks_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the repository
    """
    is_template: bool | None = None
    issue_comment_url: str | None = None
    issue_events_url: str | None = None
    issues_url: str | None = None
    keys_url: str | None = None
    labels_url: str | None = None
    language: str | None = None
    languages_url: AnyUrl | None = None
    license: Annotated[License4 | None, Field(title="License")] = None
    master_branch: str | None = None
    merges_url: AnyUrl | None = None
    milestones_url: str | None = None
    mirror_url: AnyUrl | None = None
    name: str | None = None
    """
    The name of the repository.
    """
    node_id: str | None = None
    notifications_url: str | None = None
    open_issues: int | None = None
    open_issues_count: int | None = None
    organization: str | None = None
    owner: Annotated[Owner32 | None, Field(title="User")] = None
    permissions: Permissions43 | None = None
    private: bool | None = None
    """
    Whether the repository is private or public.
    """
    public: bool | None = None
    pulls_url: str | None = None
    pushed_at: int | datetime | None = None
    releases_url: str | None = None
    role_name: str | None = None
    size: int | None = None
    ssh_url: str | None = None
    stargazers: int | None = None
    stargazers_count: int | None = None
    stargazers_url: AnyUrl | None = None
    statuses_url: str | None = None
    subscribers_url: AnyUrl | None = None
    subscription_url: AnyUrl | None = None
    svn_url: AnyUrl | None = None
    tags_url: AnyUrl | None = None
    teams_url: AnyUrl | None = None
    topics: Sequence[str] | None = None
    trees_url: str | None = None
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    visibility: Visibility5 | None = None
    watchers: int | None = None
    watchers_count: int | None = None
    web_commit_signoff_required: bool | None = None
    """
    Whether to require contributors to sign off on web-based commits
    """


class Changes9(BaseModel):
    new_issue: Annotated[NewIssue | None, Field(title="Issue")] = None
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """
    new_repository: Annotated[NewRepository1 | None, Field(title="Repository")] = None
    """
    A git repository
    """


class ActiveLockReason16Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Assignee33(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type148 | None = None
    url: AnyUrl | None = None


class Assignee34(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type148 | None = None
    url: AnyUrl | None = None


class Creator21(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type148 | None = None
    url: AnyUrl | None = None


class State82(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone21(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator21 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State82 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Owner33(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type148 | None = None
    url: AnyUrl | None = None


class Permissions44(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects20 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects20 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp19(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event20] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner33 | None, Field(title="User")] = None
    permissions: Permissions44 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class State83(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class User45(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type148 | None = None
    url: AnyUrl | None = None


class Issue15(BaseModel):
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: ActiveLockReason16Enum | None = None
    assignee: Annotated[Assignee33 | None, Field(title="User")] = None
    assignees: Sequence[Assignee34] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone21 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp19 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions41 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State83 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User45 | None, Field(title="User")] = None


class WebhookIssuesTransferred(BaseModel):
    action: Action61 | None = None
    changes: Changes9 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Annotated[Issue15 | None, Field(title="Issue")] = None
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action62(Enum):
    """
    The action that was performed.
    """

    unassigned = "unassigned"


class Type159(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class Assignee35(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type159 | None = None
    url: AnyUrl | None = None


class ActiveLockReason17Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Assignee36(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type159 | None = None
    url: AnyUrl | None = None


class Assignee37(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type159 | None = None
    url: AnyUrl | None = None


class Creator22(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type159 | None = None
    url: AnyUrl | None = None


class State84(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone22(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator22 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State84 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event22(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"
    reminder = "reminder"
    pull_request_review_thread = "pull_request_review_thread"


class Type163(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Owner34(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type163 | None = None
    url: AnyUrl | None = None


class OrganizationProjects22(Enum):
    read = "read"
    write = "write"
    admin = "admin"


class Permissions45(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects22 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects20 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp20(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event22] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner34 | None, Field(title="User")] = None
    permissions: Permissions45 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class State85(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class Type164(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class User46(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type164 | None = None
    url: AnyUrl | None = None


class Issue16(BaseModel):
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: ActiveLockReason17Enum | None = None
    assignee: Annotated[Assignee36 | None, Field(title="User")] = None
    assignees: Sequence[Assignee37] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone22 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp20 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions41 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State85 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User46 | None, Field(title="User")] = None


class WebhookIssuesUnassigned(BaseModel):
    action: Action62 | None = None
    """
    The action that was performed.
    """
    assignee: Annotated[Assignee35 | None, Field(title="User")] = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Annotated[Issue16 | None, Field(title="Issue")] = None
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action63(Enum):
    unlabeled = "unlabeled"


class ActiveLockReason18Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Assignee38(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type164 | None = None
    url: AnyUrl | None = None


class Assignee39(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type164 | None = None
    url: AnyUrl | None = None


class Creator23(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type164 | None = None
    url: AnyUrl | None = None


class State86(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone23(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator23 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State86 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Type168(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Owner35(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type168 | None = None
    url: AnyUrl | None = None


class Permissions46(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects22 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects20 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp21(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event22] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner35 | None, Field(title="User")] = None
    permissions: Permissions46 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class State87(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class Type169(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class User47(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type169 | None = None
    url: AnyUrl | None = None


class Issue17(BaseModel):
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: ActiveLockReason18Enum | None = None
    assignee: Annotated[Assignee38 | None, Field(title="User")] = None
    assignees: Sequence[Assignee39] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone23 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp21 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions41 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State87 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User47 | None, Field(title="User")] = None


class WebhookIssuesUnlabeled(BaseModel):
    action: Action63 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Annotated[Issue17 | None, Field(title="Issue")] = None
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """
    label: Annotated[Label8 | None, Field(title="Label")] = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action64(Enum):
    unlocked = "unlocked"


class ActiveLockReason19Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Type170(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Assignee40(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class Assignee41(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class Creator24(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class State88(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone24(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator24 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State88 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Event24(Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"


class Owner36(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class OrganizationProjects24(Enum):
    read = "read"
    write = "write"


class Permissions47(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects24 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects20 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp22(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event24] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner36 | None, Field(title="User")] = None
    permissions: Permissions47 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Reactions45(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: str | None = None


class State89(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class User48(BaseModel):
    avatar_url: str | None = None
    events_url: str | None = None
    followers_url: str | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: str | None = None
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organizations_url: str | None = None
    received_events_url: str | None = None
    repos_url: str | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: str | None = None
    type: str | None = None
    url: str | None = None


class Locked4(Enum):
    boolean_False = False


class Issue18(BaseModel):
    active_lock_reason: ActiveLockReason19Enum | None = None
    assignee: Annotated[Assignee40 | None, Field(title="User")] = None
    assignees: Sequence[Assignee41] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone24 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp22 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions45 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State89 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User48 | None, Field(title="User")] = None


class WebhookIssuesUnlocked(BaseModel):
    action: Action64 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Issue18 | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action65(Enum):
    unpinned = "unpinned"


class ActiveLockReason20Enum(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"


class Assignee42(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class Assignee43(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class Creator25(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class State90(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone25(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator25 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State90 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class Owner37(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class Permissions48(BaseModel):
    """
    The set of permissions for the GitHub app
    """

    actions: Actions1 | None = None
    administration: Administration1 | None = None
    checks: Checks1 | None = None
    content_references: ContentReferences | None = None
    contents: Contents1 | None = None
    deployments: Deployments1 | None = None
    discussions: Discussions | None = None
    emails: Emails | None = None
    environments: Environments1 | None = None
    issues: Issues2 | None = None
    keys: Keys | None = None
    members: Members1 | None = None
    metadata: Metadata3 | None = None
    organization_administration: OrganizationAdministration1 | None = None
    organization_hooks: OrganizationHooks1 | None = None
    organization_packages: OrganizationPackages1 | None = None
    organization_plan: OrganizationPlan1 | None = None
    organization_projects: OrganizationProjects24 | None = None
    organization_secrets: OrganizationSecrets1 | None = None
    organization_self_hosted_runners: OrganizationSelfHostedRunners1 | None = None
    organization_user_blocking: OrganizationUserBlocking1 | None = None
    packages: Packages1 | None = None
    pages: Pages2 | None = None
    pull_requests: PullRequests1 | None = None
    repository_hooks: RepositoryHooks1 | None = None
    repository_projects: RepositoryProjects20 | None = None
    secret_scanning_alerts: SecretScanningAlerts1 | None = None
    secrets: Secrets1 | None = None
    security_events: SecurityEvents1 | None = None
    security_scanning_alert: SecurityScanningAlert | None = None
    single_file: SingleFile1 | None = None
    statuses: Statuses1 | None = None
    team_discussions: TeamDiscussions1 | None = None
    vulnerability_alerts: VulnerabilityAlerts1 | None = None
    workflows: Workflows1 | None = None


class PerformedViaGithubApp23(BaseModel):
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """

    created_at: datetime | None = None
    description: str | None = None
    events: Sequence[Event24] | None = None
    """
    The list of events for the GitHub app
    """
    external_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the GitHub app
    """
    name: str | None = None
    """
    The name of the GitHub app
    """
    node_id: str | None = None
    owner: Annotated[Owner37 | None, Field(title="User")] = None
    permissions: Permissions48 | None = None
    """
    The set of permissions for the GitHub app
    """
    slug: str | None = None
    """
    The slug name of the GitHub app
    """
    updated_at: datetime | None = None


class Reactions46(BaseModel):
    field_1: Annotated[int | None, Field(alias="+1")] = None
    field_1_1: Annotated[int | None, Field(alias="-1")] = None
    confused: int | None = None
    eyes: int | None = None
    heart: int | None = None
    hooray: int | None = None
    laugh: int | None = None
    rocket: int | None = None
    total_count: int | None = None
    url: AnyUrl | None = None


class State91(Enum):
    """
    State of the issue; either 'open' or 'closed'
    """

    open = "open"
    closed = "closed"


class User49(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class Issue19(BaseModel):
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: ActiveLockReason20Enum | None = None
    assignee: Annotated[Assignee42 | None, Field(title="User")] = None
    assignees: Sequence[Assignee43] | None = None
    author_association: Annotated[
        AuthorAssociation | None, Field(title="AuthorAssociation")
    ] = None
    """
    How the author is associated with the repository.
    """
    body: str | None = None
    """
    Contents of the issue
    """
    closed_at: datetime | None = None
    comments: int | None = None
    comments_url: AnyUrl | None = None
    created_at: datetime | None = None
    draft: bool | None = None
    events_url: AnyUrl | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels: Sequence[Label8] | None = None
    labels_url: str | None = None
    locked: bool | None = None
    milestone: Annotated[Milestone25 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    node_id: str | None = None
    number: int | None = None
    performed_via_github_app: Annotated[
        PerformedViaGithubApp23 | None, Field(title="App")
    ] = None
    """
    GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
    """
    pull_request: PullRequest10 | None = None
    reactions: Annotated[Reactions46 | None, Field(title="Reactions")] = None
    repository_url: AnyUrl | None = None
    state: State91 | None = None
    """
    State of the issue; either 'open' or 'closed'
    """
    state_reason: str | None = None
    timeline_url: AnyUrl | None = None
    title: str | None = None
    """
    Title of the issue
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None
    """
    URL for the issue
    """
    user: Annotated[User49 | None, Field(title="User")] = None


class WebhookIssuesUnpinned(BaseModel):
    action: Action65 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    issue: Annotated[Issue19 | None, Field(title="Issue")] = None
    """
    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action66(Enum):
    created = "created"


class WebhookLabelCreated(BaseModel):
    action: Action66 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    label: Annotated[Label8 | None, Field(title="Label")] = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action67(Enum):
    deleted = "deleted"


class WebhookLabelDeleted(BaseModel):
    action: Action67 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    label: Annotated[Label8 | None, Field(title="Label")] = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action68(Enum):
    edited = "edited"


class Color(BaseModel):
    from_: Annotated[str | None, Field(alias="from")] = None
    """
    The previous version of the color if the action was `edited`.
    """


class Description(BaseModel):
    from_: Annotated[str | None, Field(alias="from")] = None
    """
    The previous version of the description if the action was `edited`.
    """


class Name(BaseModel):
    from_: Annotated[str | None, Field(alias="from")] = None
    """
    The previous version of the name if the action was `edited`.
    """


class Changes10(BaseModel):
    """
    The changes to the label if the action was `edited`.
    """

    color: Color | None = None
    description: Description | None = None
    name: Name | None = None


class WebhookLabelEdited(BaseModel):
    action: Action68 | None = None
    changes: Changes10 | None = None
    """
    The changes to the label if the action was `edited`.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    label: Annotated[Label8 | None, Field(title="Label")] = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action69(Enum):
    cancelled = "cancelled"


class Account1(BaseModel):
    id: int | None = None
    login: str | None = None
    node_id: str | None = None
    organization_billing_email: str | None = None
    type: str | None = None


class Plan4(BaseModel):
    bullets: Sequence[str] | None = None
    description: str | None = None
    has_free_trial: bool | None = None
    id: int | None = None
    monthly_price_in_cents: int | None = None
    name: str | None = None
    price_model: str | None = None
    unit_name: str | None = None
    yearly_price_in_cents: int | None = None


class MarketplacePurchase2(BaseModel):
    account: Account1 | None = None
    billing_cycle: str | None = None
    free_trial_ends_on: str | None = None
    next_billing_date: str | None = None
    on_free_trial: bool | None = None
    plan: Plan4 | None = None
    unit_count: int | None = None


class PreviousMarketplacePurchase(BaseModel):
    account: Account1 | None = None
    billing_cycle: str | None = None
    free_trial_ends_on: Any | None = None
    next_billing_date: str | None = None
    on_free_trial: bool | None = None
    plan: Plan4 | None = None
    unit_count: int | None = None


class WebhookMarketplacePurchaseCancelled(BaseModel):
    action: Action69 | None = None
    effective_date: str | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    marketplace_purchase: MarketplacePurchase2 | None = None
    organization: OrganizationSimple | None = None
    previous_marketplace_purchase: Annotated[
        PreviousMarketplacePurchase | None, Field(title="Marketplace Purchase")
    ] = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action70(Enum):
    changed = "changed"


class MarketplacePurchase3(BaseModel):
    account: Account1 | None = None
    billing_cycle: str | None = None
    free_trial_ends_on: str | None = None
    next_billing_date: str | None = None
    on_free_trial: bool | None = None
    plan: Plan4 | None = None
    unit_count: int | None = None


class PreviousMarketplacePurchase1(BaseModel):
    account: Account1 | None = None
    billing_cycle: str | None = None
    free_trial_ends_on: str | None = None
    next_billing_date: str | None = None
    on_free_trial: bool | None = None
    plan: Plan4 | None = None
    unit_count: int | None = None


class WebhookMarketplacePurchaseChanged(BaseModel):
    action: Action70 | None = None
    effective_date: str | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    marketplace_purchase: MarketplacePurchase3 | None = None
    organization: OrganizationSimple | None = None
    previous_marketplace_purchase: Annotated[
        PreviousMarketplacePurchase1 | None, Field(title="Marketplace Purchase")
    ] = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action71(Enum):
    pending_change = "pending_change"


class MarketplacePurchase4(BaseModel):
    account: Account1 | None = None
    billing_cycle: str | None = None
    free_trial_ends_on: str | None = None
    next_billing_date: str | None = None
    on_free_trial: bool | None = None
    plan: Plan4 | None = None
    unit_count: int | None = None


class PreviousMarketplacePurchase2(BaseModel):
    account: Account1 | None = None
    billing_cycle: str | None = None
    free_trial_ends_on: str | None = None
    next_billing_date: str | None = None
    on_free_trial: bool | None = None
    plan: Plan4 | None = None
    unit_count: int | None = None


class WebhookMarketplacePurchasePendingChange(BaseModel):
    action: Action71 | None = None
    effective_date: str | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    marketplace_purchase: MarketplacePurchase4 | None = None
    organization: OrganizationSimple | None = None
    previous_marketplace_purchase: Annotated[
        PreviousMarketplacePurchase2 | None, Field(title="Marketplace Purchase")
    ] = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action72(Enum):
    pending_change_cancelled = "pending_change_cancelled"


class MarketplacePurchase5(BaseModel):
    account: Account1 | None = None
    billing_cycle: str | None = None
    free_trial_ends_on: Any | None = None
    next_billing_date: str | None = None
    on_free_trial: bool | None = None
    plan: Plan4 | None = None
    unit_count: int | None = None


class PreviousMarketplacePurchase3(BaseModel):
    account: Account1 | None = None
    billing_cycle: str | None = None
    free_trial_ends_on: Any | None = None
    next_billing_date: str | None = None
    on_free_trial: bool | None = None
    plan: Plan4 | None = None
    unit_count: int | None = None


class WebhookMarketplacePurchasePendingChangeCancelled(BaseModel):
    action: Action72 | None = None
    effective_date: str | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    marketplace_purchase: MarketplacePurchase5 | None = None
    organization: OrganizationSimple | None = None
    previous_marketplace_purchase: Annotated[
        PreviousMarketplacePurchase3 | None, Field(title="Marketplace Purchase")
    ] = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action73(Enum):
    purchased = "purchased"


class MarketplacePurchase6(BaseModel):
    account: Account1 | None = None
    billing_cycle: str | None = None
    free_trial_ends_on: str | None = None
    next_billing_date: str | None = None
    on_free_trial: bool | None = None
    plan: Plan4 | None = None
    unit_count: int | None = None


class PreviousMarketplacePurchase4(BaseModel):
    account: Account1 | None = None
    billing_cycle: str | None = None
    free_trial_ends_on: Any | None = None
    next_billing_date: str | None = None
    on_free_trial: bool | None = None
    plan: Plan4 | None = None
    unit_count: int | None = None


class WebhookMarketplacePurchasePurchased(BaseModel):
    action: Action73 | None = None
    effective_date: str | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    marketplace_purchase: MarketplacePurchase6 | None = None
    organization: OrganizationSimple | None = None
    previous_marketplace_purchase: Annotated[
        PreviousMarketplacePurchase4 | None, Field(title="Marketplace Purchase")
    ] = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action74(Enum):
    added = "added"


class To(Enum):
    write = "write"
    admin = "admin"
    read = "read"


class Permission(BaseModel):
    to: To | None = None


class Changes11(BaseModel):
    permission: Permission | None = None


class Member(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class WebhookMemberAdded(BaseModel):
    """
    Activity related to repository collaborators. The type of activity is specified in the action property.
    """

    action: Action74 | None = None
    changes: Changes11 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    member: Annotated[Member | None, Field(title="User")] = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action75(Enum):
    edited = "edited"


class OldPermission(BaseModel):
    from_: Annotated[str | None, Field(alias="from")] = None
    """
    The previous permissions of the collaborator if the action was edited.
    """


class Permission1(BaseModel):
    from_: Annotated[str | None, Field(alias="from")] = None
    to: str | None = None


class Changes12(BaseModel):
    """
    The changes to the collaborator permissions
    """

    old_permission: OldPermission | None = None
    permission: Permission1 | None = None


class Member1(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class WebhookMemberEdited(BaseModel):
    action: Action75 | None = None
    changes: Changes12 | None = None
    """
    The changes to the collaborator permissions
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    member: Annotated[Member1 | None, Field(title="User")] = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action76(Enum):
    removed = "removed"


class Member2(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class WebhookMemberRemoved(BaseModel):
    action: Action76 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    member: Annotated[Member2 | None, Field(title="User")] = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action77(Enum):
    added = "added"


class Member3(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class Scope4(Enum):
    """
    The scope of the membership. Currently, can only be `team`.
    """

    team = "team"


class Sender(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class Privacy1(Enum):
    open = "open"
    closed = "closed"
    secret = "secret"


class Parent5(BaseModel):
    description: str | None = None
    """
    Description of the team
    """
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the team
    """
    members_url: str | None = None
    name: str | None = None
    """
    Name of the team
    """
    node_id: str | None = None
    permission: str | None = None
    """
    Permission that the team will have for its repositories
    """
    privacy: Privacy1 | None = None
    repositories_url: AnyUrl | None = None
    slug: str | None = None
    url: AnyUrl | None = None
    """
    URL for the team
    """


class Team2(BaseModel):
    """
    Groups of organization members that gives permissions on specified repositories.
    """

    deleted: bool | None = None
    description: str | None = None
    """
    Description of the team
    """
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the team
    """
    members_url: str | None = None
    name: str | None = None
    """
    Name of the team
    """
    node_id: str | None = None
    parent: Parent5 | None = None
    permission: str | None = None
    """
    Permission that the team will have for its repositories
    """
    privacy: Privacy1 | None = None
    repositories_url: AnyUrl | None = None
    slug: str | None = None
    url: AnyUrl | None = None
    """
    URL for the team
    """


class WebhookMembershipAdded(BaseModel):
    action: Action77 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    member: Annotated[Member3 | None, Field(title="User")] = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    scope: Scope4 | None = None
    """
    The scope of the membership. Currently, can only be `team`.
    """
    sender: Annotated[Sender | None, Field(title="User")] = None
    team: Annotated[Team2 | None, Field(title="Team")] = None
    """
    Groups of organization members that gives permissions on specified repositories.
    """


class Action78(Enum):
    removed = "removed"


class Member4(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class Scope5(Enum):
    """
    The scope of the membership. Currently, can only be `team`.
    """

    team = "team"
    organization = "organization"


class Sender1(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type170 | None = None
    url: AnyUrl | None = None


class Parent6(BaseModel):
    description: str | None = None
    """
    Description of the team
    """
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the team
    """
    members_url: str | None = None
    name: str | None = None
    """
    Name of the team
    """
    node_id: str | None = None
    permission: str | None = None
    """
    Permission that the team will have for its repositories
    """
    privacy: Privacy1 | None = None
    repositories_url: AnyUrl | None = None
    slug: str | None = None
    url: AnyUrl | None = None
    """
    URL for the team
    """


class Team3(BaseModel):
    """
    Groups of organization members that gives permissions on specified repositories.
    """

    deleted: bool | None = None
    description: str | None = None
    """
    Description of the team
    """
    html_url: AnyUrl | None = None
    id: int | None = None
    """
    Unique identifier of the team
    """
    members_url: str | None = None
    name: str | None = None
    """
    Name of the team
    """
    node_id: str | None = None
    parent: Parent6 | None = None
    permission: str | None = None
    """
    Permission that the team will have for its repositories
    """
    privacy: Privacy1 | None = None
    repositories_url: AnyUrl | None = None
    slug: str | None = None
    url: AnyUrl | None = None
    """
    URL for the team
    """


class WebhookMembershipRemoved(BaseModel):
    action: Action78 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    member: Annotated[Member4 | None, Field(title="User")] = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    scope: Scope5 | None = None
    """
    The scope of the membership. Currently, can only be `team`.
    """
    sender: Annotated[Sender1 | None, Field(title="User")] = None
    team: Annotated[Team3 | None, Field(title="Team")] = None
    """
    Groups of organization members that gives permissions on specified repositories.
    """


class HeadCommit1(BaseModel):
    author: Annotated[Author6 | None, Field(title="Committer")] = None
    """
    Metaproperties for Git author/committer information.
    """
    committer: Annotated[Committer5 | None, Field(title="Committer")] = None
    """
    Metaproperties for Git author/committer information.
    """
    id: str | None = None
    message: str | None = None
    timestamp: str | None = None
    tree_id: str | None = None


class MergeGroup(BaseModel):
    head_sha: str | None = None
    """
    The SHA of the merge group.
    """
    head_ref: str | None = None
    """
    The full ref of the merge group.
    """
    base_sha: str | None = None
    """
    The SHA of the merge group's parent commit.
    """
    base_ref: str | None = None
    """
    The full ref of the branch the merge group will be merged into.
    """
    head_commit: Annotated[HeadCommit1 | None, Field(title="SimpleCommit")] = None


class WebhookMergeGroupChecksRequested(BaseModel):
    action: str | None = None
    installation: SimpleInstallation | None = None
    merge_group: Annotated[MergeGroup | None, Field(title="MergeGroup")] = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action79(Enum):
    deleted = "deleted"


class ContentType(Enum):
    json = "json"
    form = "form"


class Config2(BaseModel):
    content_type: ContentType | None = None
    insecure_ssl: str | None = None
    secret: str | None = None
    url: AnyUrl | None = None


class Event26(Enum):
    field_ = "*"
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    meta = "meta"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    package = "package"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    pull_request_review_thread = "pull_request_review_thread"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_import = "repository_import"
    repository_vulnerability_alert = "repository_vulnerability_alert"
    secret_scanning_alert = "secret_scanning_alert"
    secret_scanning_alert_location = "secret_scanning_alert_location"
    security_and_analysis = "security_and_analysis"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_job = "workflow_job"
    workflow_run = "workflow_run"
    repository_dispatch = "repository_dispatch"
    projects_v2_item = "projects_v2_item"


class Hook1(BaseModel):
    """
    The modified webhook. This will contain different keys based on the type of webhook it is: repository, organization, business, app, or GitHub Marketplace.
    """

    active: bool | None = None
    config: Config2 | None = None
    created_at: str | None = None
    events: Sequence[Event26] | None = None
    id: int | None = None
    name: str | None = None
    type: str | None = None
    updated_at: str | None = None


class WebhookMetaDeleted(BaseModel):
    action: Action79 | None = None
    enterprise: Enterprise | None = None
    hook: Hook1 | None = None
    """
    The modified webhook. This will contain different keys based on the type of webhook it is: repository, organization, business, app, or GitHub Marketplace.
    """
    hook_id: int | None = None
    """
    The id of the modified webhook.
    """
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: NullableRepository | None = None
    sender: SimpleUser | None = None


class Action80(Enum):
    closed = "closed"


class Type187(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class Creator26(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type187 | None = None
    url: AnyUrl | None = None


class State92(Enum):
    """
    The state of the milestone.
    """

    open = "open"
    closed = "closed"


class Milestone26(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator26 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State92 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class WebhookMilestoneClosed(BaseModel):
    action: Action80 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    milestone: Annotated[Milestone26 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action81(Enum):
    created = "created"


class Type188(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Creator27(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type188 | None = None
    url: AnyUrl | None = None


class Milestone27(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator27 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State92 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class WebhookMilestoneCreated(BaseModel):
    action: Action81 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    milestone: Annotated[Milestone27 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action82(Enum):
    deleted = "deleted"


class Type189(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class Creator28(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type189 | None = None
    url: AnyUrl | None = None


class Milestone28(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator28 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State92 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class WebhookMilestoneDeleted(BaseModel):
    action: Action82 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    milestone: Annotated[Milestone28 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action83(Enum):
    edited = "edited"


class DueOn(BaseModel):
    from_: Annotated[str | None, Field(alias="from")] = None
    """
    The previous version of the due date if the action was `edited`.
    """


class Title2(BaseModel):
    from_: Annotated[str | None, Field(alias="from")] = None
    """
    The previous version of the title if the action was `edited`.
    """


class Changes13(BaseModel):
    """
    The changes to the milestone if the action was `edited`.
    """

    description: Description | None = None
    due_on: DueOn | None = None
    title: Title2 | None = None


class Creator29(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type189 | None = None
    url: AnyUrl | None = None


class Milestone29(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator29 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State92 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class WebhookMilestoneEdited(BaseModel):
    action: Action83 | None = None
    changes: Changes13 | None = None
    """
    The changes to the milestone if the action was `edited`.
    """
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    milestone: Annotated[Milestone29 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action84(Enum):
    opened = "opened"


class Type191(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Creator30(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class Milestone30(BaseModel):
    """
    A collection of related issues and pull requests.
    """

    closed_at: datetime | None = None
    closed_issues: int | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator30 | None, Field(title="User")] = None
    description: str | None = None
    due_on: datetime | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    labels_url: AnyUrl | None = None
    node_id: str | None = None
    number: int | None = None
    """
    The number of the milestone.
    """
    open_issues: int | None = None
    state: State92 | None = None
    """
    The state of the milestone.
    """
    title: str | None = None
    """
    The title of the milestone.
    """
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class WebhookMilestoneOpened(BaseModel):
    action: Action84 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    milestone: Annotated[Milestone30 | None, Field(title="Milestone")] = None
    """
    A collection of related issues and pull requests.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action85(Enum):
    blocked = "blocked"


class BlockedUser(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class WebhookOrgBlockBlocked(BaseModel):
    action: Action85 | None = None
    blocked_user: Annotated[BlockedUser | None, Field(title="User")] = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action86(Enum):
    unblocked = "unblocked"


class BlockedUser1(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class WebhookOrgBlockUnblocked(BaseModel):
    action: Action86 | None = None
    blocked_user: Annotated[BlockedUser1 | None, Field(title="User")] = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action87(Enum):
    deleted = "deleted"


class User50(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class Membership(BaseModel):
    """
    The membership between the user and the organization. Not present when the action is `member_invited`.
    """

    organization_url: AnyUrl | None = None
    role: str | None = None
    state: str | None = None
    url: AnyUrl | None = None
    user: Annotated[User50 | None, Field(title="User")] = None


class WebhookOrganizationDeleted(BaseModel):
    action: Action87 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    membership: Annotated[Membership | None, Field(title="Membership")] = None
    """
    The membership between the user and the organization. Not present when the action is `member_invited`.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action88(Enum):
    member_added = "member_added"


class User51(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class Membership1(BaseModel):
    """
    The membership between the user and the organization. Not present when the action is `member_invited`.
    """

    organization_url: AnyUrl | None = None
    role: str | None = None
    state: str | None = None
    url: AnyUrl | None = None
    user: Annotated[User51 | None, Field(title="User")] = None


class WebhookOrganizationMemberAdded(BaseModel):
    action: Action88 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    membership: Annotated[Membership1 | None, Field(title="Membership")] = None
    """
    The membership between the user and the organization. Not present when the action is `member_invited`.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action89(Enum):
    member_invited = "member_invited"


class Inviter(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class Invitation(BaseModel):
    """
    The invitation for the user or email if the action is `member_invited`.
    """

    created_at: datetime | None = None
    email: str | None = None
    failed_at: datetime | None = None
    failed_reason: str | None = None
    id: float | None = None
    invitation_teams_url: AnyUrl | None = None
    inviter: Annotated[Inviter | None, Field(title="User")] = None
    login: str | None = None
    node_id: str | None = None
    role: str | None = None
    team_count: float | None = None


class User52(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class WebhookOrganizationMemberInvited(BaseModel):
    action: Action89 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    invitation: Invitation | None = None
    """
    The invitation for the user or email if the action is `member_invited`.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None
    user: Annotated[User52 | None, Field(title="User")] = None


class Action90(Enum):
    member_removed = "member_removed"


class User53(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class Membership2(BaseModel):
    """
    The membership between the user and the organization. Not present when the action is `member_invited`.
    """

    organization_url: AnyUrl | None = None
    role: str | None = None
    state: str | None = None
    url: AnyUrl | None = None
    user: Annotated[User53 | None, Field(title="User")] = None


class WebhookOrganizationMemberRemoved(BaseModel):
    action: Action90 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    membership: Annotated[Membership2 | None, Field(title="Membership")] = None
    """
    The membership between the user and the organization. Not present when the action is `member_invited`.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action91(Enum):
    renamed = "renamed"


class Changes14(BaseModel):
    login: Login | None = None


class User54(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class Membership3(BaseModel):
    """
    The membership between the user and the organization. Not present when the action is `member_invited`.
    """

    organization_url: AnyUrl | None = None
    role: str | None = None
    state: str | None = None
    url: AnyUrl | None = None
    user: Annotated[User54 | None, Field(title="User")] = None


class WebhookOrganizationRenamed(BaseModel):
    action: Action91 | None = None
    changes: Changes14 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    membership: Annotated[Membership3 | None, Field(title="Membership")] = None
    """
    The membership between the user and the organization. Not present when the action is `member_invited`.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action92(Enum):
    published = "published"


class Owner38(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class Author8(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class Tag1(BaseModel):
    digest: str | None = None
    name: str | None = None


class ContainerMetadata(BaseModel):
    labels: Mapping[str, Any] | None = None
    manifest: Mapping[str, Any] | None = None
    tag: Tag1 | None = None


class NpmMetadata(BaseModel):
    name: str | None = None
    version: str | None = None
    npm_user: str | None = None
    author: Mapping[str, Any] | None = None
    bugs: Mapping[str, Any] | None = None
    dependencies: Mapping[str, Any] | None = None
    dev_dependencies: Mapping[str, Any] | None = None
    peer_dependencies: Mapping[str, Any] | None = None
    optional_dependencies: Mapping[str, Any] | None = None
    description: str | None = None
    dist: Mapping[str, Any] | None = None
    git_head: str | None = None
    homepage: str | None = None
    license: str | None = None
    main: str | None = None
    repository: Mapping[str, Any] | None = None
    scripts: Mapping[str, Any] | None = None
    id: str | None = None
    node_version: str | None = None
    npm_version: str | None = None
    has_shrinkwrap: bool | None = None
    maintainers: Sequence[Mapping[str, Any]] | None = None
    contributors: Sequence[Mapping[str, Any]] | None = None
    engines: Mapping[str, Any] | None = None
    keywords: Sequence[str] | None = None
    files: Sequence[str] | None = None
    bin: Mapping[str, Any] | None = None
    man: Mapping[str, Any] | None = None
    directories: Mapping[str, Any] | None = None
    os: Sequence[str] | None = None
    cpu: Sequence[str] | None = None
    readme: str | None = None
    installation_command: str | None = None
    release_id: int | None = None
    commit_oid: str | None = None
    published_via_actions: bool | None = None
    deleted_by_id: int | None = None


class ValueItem(BaseModel):
    url: str | None = None
    branch: str | None = None
    commit: str | None = None
    type: str | None = None


class NugetMetadatum(BaseModel):
    id: int | str | None = None
    name: str | None = None
    value: bool | str | int | ValueItem | None = None


class PackageFile(BaseModel):
    content_type: str | None = None
    created_at: str | None = None
    download_url: AnyUrl | None = None
    id: int | None = None
    md5: str | None = None
    name: str | None = None
    sha1: str | None = None
    sha256: str | None = None
    size: int | None = None
    state: str | None = None
    updated_at: str | None = None


class Author9(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class Release1(BaseModel):
    author: Annotated[Author9 | None, Field(title="User")] = None
    created_at: str | None = None
    draft: bool | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    name: str | None = None
    prerelease: bool | None = None
    published_at: str | None = None
    tag_name: str | None = None
    target_commitish: str | None = None
    url: AnyUrl | None = None


class PackageVersion1(BaseModel):
    author: Annotated[Author8 | None, Field(title="User")] = None
    body: str | Mapping[str, Any] | None = None
    body_html: str | None = None
    container_metadata: ContainerMetadata | None = None
    created_at: str | None = None
    description: str | None = None
    docker_metadata: Sequence | None = None
    draft: bool | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    installation_command: str | None = None
    manifest: str | None = None
    metadata: Sequence[Mapping[str, Any]] | None = None
    name: str | None = None
    npm_metadata: NpmMetadata | None = None
    nuget_metadata: Sequence[NugetMetadatum] | None = None
    package_files: Sequence[PackageFile] | None = None
    package_url: str | None = None
    prerelease: bool | None = None
    release: Release1 | None = None
    rubygems_metadata: Sequence | None = None
    source_url: str | None = None
    summary: str | None = None
    tag_name: str | None = None
    target_commitish: str | None = None
    target_oid: str | None = None
    updated_at: str | None = None
    version: str | None = None


class Registry(BaseModel):
    about_url: AnyUrl | None = None
    name: str | None = None
    type: str | None = None
    url: AnyUrl | None = None
    vendor: str | None = None


class Package1(BaseModel):
    """
    Information about the package.
    """

    created_at: str | None = None
    description: str | None = None
    ecosystem: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    name: str | None = None
    namespace: str | None = None
    owner: Annotated[Owner38 | None, Field(title="User")] = None
    package_type: str | None = None
    package_version: PackageVersion1 | None = None
    registry: Registry | None = None
    updated_at: str | None = None


class WebhookPackagePublished(BaseModel):
    action: Action92 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    package: Package1 | None = None
    """
    Information about the package.
    """
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action93(Enum):
    updated = "updated"


class Owner39(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class Author10(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class Author11(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class Release2(BaseModel):
    author: Annotated[Author11 | None, Field(title="User")] = None
    created_at: str | None = None
    draft: bool | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    name: str | None = None
    prerelease: bool | None = None
    published_at: str | None = None
    tag_name: str | None = None
    target_commitish: str | None = None
    url: AnyUrl | None = None


class PackageVersion2(BaseModel):
    author: Annotated[Author10 | None, Field(title="User")] = None
    body: str | None = None
    body_html: str | None = None
    created_at: str | None = None
    description: str | None = None
    docker_metadata: Sequence | None = None
    draft: bool | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    installation_command: str | None = None
    manifest: str | None = None
    metadata: Sequence | None = None
    name: str | None = None
    package_files: Sequence[PackageFile] | None = None
    package_url: str | None = None
    prerelease: bool | None = None
    release: Release2 | None = None
    rubygems_metadata: Sequence | None = None
    source_url: AnyUrl | None = None
    summary: str | None = None
    tag_name: str | None = None
    target_commitish: str | None = None
    target_oid: str | None = None
    updated_at: str | None = None
    version: str | None = None


class Package2(BaseModel):
    """
    Information about the package.
    """

    created_at: str | None = None
    description: str | None = None
    ecosystem: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    name: str | None = None
    namespace: str | None = None
    owner: Annotated[Owner39 | None, Field(title="User")] = None
    package_type: str | None = None
    package_version: PackageVersion2 | None = None
    registry: Registry | None = None
    updated_at: str | None = None


class WebhookPackageUpdated(BaseModel):
    action: Action93 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    package: Package2 | None = None
    """
    Information about the package.
    """
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action94(Enum):
    create = "create"


class AllLabels(BaseModel):
    com_github_base_image_id: Annotated[
        str | None, Field(alias="com.github.base_image.id")
    ] = None
    com_github_base_image_repo_digest: Annotated[
        str | None, Field(alias="com.github.base_image.repo_digest")
    ] = None
    com_github_repo_branch: Annotated[
        str | None, Field(alias="com.github.repo.branch")
    ] = None
    ghes_licenses_path: Annotated[str | None, Field(alias="ghes.licenses.path")] = None
    org_opencontainers_image_created: Annotated[
        str | None, Field(alias="org.opencontainers.image.created")
    ] = None
    org_opencontainers_image_description: Annotated[
        str | None, Field(alias="org.opencontainers.image.description")
    ] = None
    org_opencontainers_image_documentation: Annotated[
        str | None, Field(alias="org.opencontainers.image.documentation")
    ] = None
    org_opencontainers_image_revision: Annotated[
        str | None, Field(alias="org.opencontainers.image.revision")
    ] = None
    org_opencontainers_image_source: Annotated[
        str | None, Field(alias="org.opencontainers.image.source")
    ] = None


class Labels(BaseModel):
    all_labels: AllLabels | None = None
    description: str | None = None
    image_url: str | None = None
    licenses: str | None = None
    revision: str | None = None
    source: str | None = None


class Config3(BaseModel):
    digest: str | None = None
    media_type: str | None = None
    size: int | None = None


class Layer(BaseModel):
    digest: str | None = None
    media_type: str | None = None
    size: int | None = None


class Manifest1(BaseModel):
    config: Config3 | None = None
    digest: str | None = None
    layers: Sequence[Layer] | None = None
    media_type: str | None = None
    size: int | None = None
    uri: str | None = None


class ContainerMetadata1(BaseModel):
    labels: Labels | None = None
    manifest: Manifest1 | None = None
    tag: Tag1 | None = None


class PackageVersion3(BaseModel):
    blob_store: str | None = None
    container_metadata: ContainerMetadata1 | None = None
    created_at: str | None = None
    description: str | None = None
    html_url: str | None = None
    id: int | None = None
    name: str | None = None
    updated_at: str | None = None


class Package3(BaseModel):
    created_at: str | None = None
    description: str | None = None
    ecosystem: str | None = None
    html_url: str | None = None
    id: int | None = None
    name: str | None = None
    namespace: str | None = None
    package_version: PackageVersion3 | None = None
    updated_at: str | None = None


class WebhookPackageV2Create(BaseModel):
    action: Action94 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    package: Package3 | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Pusher(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class Build(BaseModel):
    """
    The [List GitHub Pages builds](https://docs.github.com/en/rest/reference/repos#list-github-pages-builds) itself.
    """

    commit: str | None = None
    created_at: str | None = None
    duration: int | None = None
    error: Error2 | None = None
    pusher: Annotated[Pusher | None, Field(title="User")] = None
    status: str | None = None
    updated_at: str | None = None
    url: AnyUrl | None = None


class WebhookPageBuild(BaseModel):
    """
    Page Build
    """

    build: Build | None = None
    """
    The [List GitHub Pages builds](https://docs.github.com/en/rest/reference/repos#list-github-pages-builds) itself.
    """
    enterprise: Enterprise | None = None
    id: int | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Config4(BaseModel):
    content_type: Annotated[str | None, Field(example='"json"')] = None
    """
    The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
    """
    insecure_ssl: str | float | None = None
    secret: Annotated[str | None, Field(example='"********"')] = None
    """
    If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).
    """
    url: Annotated[AnyUrl | None, Field(example="https://example.com/webhook")] = None
    """
    The URL to which the payloads will be delivered.
    """


class Name1(Enum):
    """
    The type of webhook. The only valid value is 'web'.
    """

    web = "web"


class Hook2(BaseModel):
    """
    The webhook that is being pinged
    """

    active: bool | None = None
    """
    Determines whether the hook is actually triggered for the events it subscribes to.
    """
    app_id: int | None = None
    """
    Only included for GitHub Apps. When you register a new GitHub App, GitHub sends a ping event to the webhook URL you specified during registration. The GitHub App ID sent in this field is required for authenticating an app.
    """
    config: Config4 | None = None
    created_at: datetime | None = None
    deliveries_url: AnyUrl | None = None
    events: Sequence[str] | None = None
    """
    Determines what events the hook is triggered for. Default: ['push'].
    """
    id: int | None = None
    """
    Unique identifier of the webhook.
    """
    last_response: HookResponse | None = None
    name: Name1 | None = None
    """
    The type of webhook. The only valid value is 'web'.
    """
    ping_url: AnyUrl | None = None
    test_url: AnyUrl | None = None
    type: str | None = None
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class WebhookPing(BaseModel):
    """
    The webhooks ping payload
    """

    hook: Annotated[Hook2 | None, Field(title="Webhook")] = None
    """
    The webhook that is being pinged
    """
    hook_id: int | None = None
    """
    The ID of the webhook that triggered the ping.
    """
    organization: OrganizationSimple | None = None
    repository: Repository | None = None
    sender: SimpleUser | None = None
    zen: str | None = None
    """
    Random string of GitHub zen.
    """


class WebhookPingFormEncoded(BaseModel):
    """
    The webhooks ping payload encoded with URL encoding.
    """

    payload: str | None = None
    """
    A URL-encoded string of the ping JSON payload. The decoded payload is a JSON object.
    """


class Action95(Enum):
    converted = "converted"


class Note(BaseModel):
    from_: Annotated[str | None, Field(alias="from")] = None


class Changes15(BaseModel):
    note: Note | None = None


class Creator31(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class ProjectCard5(BaseModel):
    after_id: int | None = None
    archived: bool | None = None
    """
    Whether or not the card is archived
    """
    column_id: int | None = None
    column_url: AnyUrl | None = None
    content_url: AnyUrl | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator31 | None, Field(title="User")] = None
    id: int | None = None
    """
    The project card's ID
    """
    node_id: str | None = None
    note: str | None = None
    project_url: AnyUrl | None = None
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class WebhookProjectCardConverted(BaseModel):
    action: Action95 | None = None
    changes: Changes15 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    project_card: Annotated[ProjectCard5 | None, Field(title="Project Card")] = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action96(Enum):
    created = "created"


class Creator32(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type191 | None = None
    url: AnyUrl | None = None


class ProjectCard6(BaseModel):
    after_id: int | None = None
    archived: bool | None = None
    """
    Whether or not the card is archived
    """
    column_id: int | None = None
    column_url: AnyUrl | None = None
    content_url: AnyUrl | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator32 | None, Field(title="User")] = None
    id: int | None = None
    """
    The project card's ID
    """
    node_id: str | None = None
    note: str | None = None
    project_url: AnyUrl | None = None
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class WebhookProjectCardCreated(BaseModel):
    action: Action96 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    project_card: Annotated[ProjectCard6 | None, Field(title="Project Card")] = None
    repository: Repository | None = None
    sender: SimpleUser | None = None


class Action97(Enum):
    deleted = "deleted"


class Type209(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"
    Mannequin = "Mannequin"


class Creator33(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type209 | None = None
    url: AnyUrl | None = None


class ProjectCard7(BaseModel):
    after_id: int | None = None
    archived: bool | None = None
    """
    Whether or not the card is archived
    """
    column_id: int | None = None
    column_url: AnyUrl | None = None
    content_url: AnyUrl | None = None
    created_at: datetime | None = None
    creator: Annotated[Creator33 | None, Field(title="User")] = None
    id: int | None = None
    """
    The project card's ID
    """
    node_id: str | None = None
    note: str | None = None
    project_url: AnyUrl | None = None
    updated_at: datetime | None = None
    url: AnyUrl | None = None


class WebhookProjectCardDeleted(BaseModel):
    action: Action97 | None = None
    enterprise: Enterprise | None = None
    installation: SimpleInstallation | None = None
    organization: OrganizationSimple | None = None
    project_card: Annotated[ProjectCard7 | None, Field(title="Project Card")] = None
    repository: NullableRepository | None = None
    sender: SimpleUser | None = None


class Action98(Enum):
    edited = "edited"


class Changes16(BaseModel):
    note: Note | None = None


class Type210(Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class Creator34(BaseModel):
    avatar_url: AnyUrl | None = None
    deleted: bool | None = None
    email: str | None = None
    events_url: str | None = None
    followers_url: AnyUrl | None = None
    following_url: str | None = None
    gists_url: str | None = None
    gravatar_id: str | None = None
    html_url: AnyUrl | None = None
    id: int | None = None
    login: str | None = None
    name: str | None = None
    node_id: str | None = None
    organizations_url: AnyUrl | None = None
    received_events_url: AnyUrl | None = None
    repos_url: AnyUrl | None = None
    site_admin: bool | None = None
    starred_url: str | None = None
    subscriptions_url: AnyUrl | None = None
    type: Type210 | None = None
    url: AnyUrl | None = None


class ProjectCard8(BaseModel):
    after_id: int | None = None
    archived: bool | None = None
    """
    Whether or not the card is arc