def ShiftRow(row, nr, inverse=False):
    if inverse:
        nr = -nr
    off = nr % 4
    return row[off:] + row[:off]


def MixColumn(col, inverse=False):
    res = [[0] * 8 for _ in range(4)]
    table = MCi_TABLE if inverse else MC_TABLE
    for yi in range(4):
        for yj in range(8):
            y = yi * 8 + yj
            for x in table[y]:
                xi, xj = divmod(x, 8)
                res[yi][yj] ^= col[xi][xj]
    return res

# y -> set of x indices to xor
MC_TABLE = [
    {1, 8, 9, 16, 24},
    {2, 9, 10, 17, 25},
    {3, 10, 11, 18, 26},
    {0, 4, 8, 11, 12, 19, 27},
    {0, 5, 8, 12, 13, 20, 28},
    {6, 13, 14, 21, 29},
    {0, 7, 8, 14, 15, 22, 30},
    {0, 8, 15, 23, 31},
    {0, 9, 16, 17, 24},
    {1, 10, 17, 18, 25},
    {2, 11, 18, 19, 26},
    {3, 8, 12, 16, 19, 20, 27},
    {4, 8, 13, 16, 20, 21, 28},
    {5, 14, 21, 22, 29},
    {6, 8, 15, 16, 22, 23, 30},
    {7, 8, 16, 23, 31},
    {0, 8, 17, 24, 25},
    {1, 9, 18, 25, 26},
    {2, 10, 19, 26, 27},
    {3, 11, 16, 20, 24, 27, 28},
    {4, 12, 16, 21, 24, 28, 29},
    {5, 13, 22, 29, 30},
    {6, 14, 16, 23, 24, 30, 31},
    {7, 15, 16, 24, 31},
    {0, 1, 8, 16, 25},
    {1, 2, 9, 17, 26},
    {2, 3, 10, 18, 27},
    {0, 3, 4, 11, 19, 24, 28},
    {0, 4, 5, 12, 20, 24, 29},
    {5, 6, 13, 21, 30},
    {0, 6, 7, 14, 22, 24, 31},
    {0, 7, 15, 23, 24},
]

MCi_TABLE = [
    {1, 2, 3, 8, 9, 11, 16, 18, 19, 24, 27},
    {0, 2, 3, 4, 8, 9, 10, 12, 16, 17, 19, 20, 24, 25, 28},
    {1, 3, 4, 5, 8, 9, 10, 11, 13, 17, 18, 20, 21, 24, 25, 26, 29},
    {2, 4, 5, 6, 8, 9, 10, 11, 12, 14, 16, 18, 19, 21, 22, 25, 26, 27, 30},
    {1, 2, 5, 6, 7, 10, 12, 13, 15, 16, 17, 18, 20, 22, 23, 24, 26, 28, 31},
    {1, 6, 7, 8, 9, 13, 14, 17, 21, 23, 24, 25, 29},
    {2, 7, 8, 9, 10, 14, 15, 16, 18, 22, 25, 26, 30},
    {0, 1, 2, 8, 10, 15, 17, 18, 23, 26, 31},
    {0, 3, 9, 10, 11, 16, 17, 19, 24, 26, 27},
    {0, 1, 4, 8, 10, 11, 12, 16, 17, 18, 20, 24, 25, 27, 28},
    {0, 1, 2, 5, 9, 11, 12, 13, 16, 17, 18, 19, 21, 25, 26, 28, 29},
    {1, 2, 3, 6, 10, 12, 13, 14, 16, 17, 18, 19, 20, 22, 24, 26, 27, 29, 30},
    {0, 2, 4, 7, 9, 10, 13, 14, 15, 18, 20, 21, 23, 24, 25, 26, 28, 30, 31},
    {0, 1, 5, 9, 14, 15, 16, 17, 21, 22, 25, 29, 31},
    {1, 2, 6, 10, 15, 16, 17, 18, 22, 23, 24, 26, 30},
    {2, 7, 8, 9, 10, 16, 18, 23, 25, 26, 31},
    {0, 2, 3, 8, 11, 17, 18, 19, 24, 25, 27},
    {0, 1, 3, 4, 8, 9, 12, 16, 18, 19, 20, 24, 25, 26, 28},
    {1, 2, 4, 5, 8, 9, 10, 13, 17, 19, 20, 21, 24, 25, 26, 27, 29},
    {0, 2, 3, 5, 6, 9, 10, 11, 14, 18, 20, 21, 22, 24, 25, 26, 27, 28, 30},
    {0, 1, 2, 4, 6, 7, 8, 10, 12, 15, 17, 18, 21, 22, 23, 26, 28, 29, 31},
    {1, 5, 7, 8, 9, 13, 17, 22, 23, 24, 25, 29, 30},
    {0, 2, 6, 9, 10, 14, 18, 23, 24, 25, 26, 30, 31},
    {1, 2, 7, 10, 15, 16, 17, 18, 24, 26, 31},
    {0, 1, 3, 8, 10, 11, 16, 19, 25, 26, 27},
    {0, 1, 2, 4, 8, 9, 11, 12, 16, 17, 20, 24, 26, 27, 28},
    {0, 1, 2, 3, 5, 9, 10, 12, 13, 16, 17, 18, 21, 25, 27, 28, 29},
    {0, 1, 2, 3, 4, 6, 8, 10, 11, 13, 14, 17, 18, 19, 22, 26, 28, 29, 30},
    {2, 4, 5, 7, 8, 9, 10, 12, 14, 15, 16, 18, 20, 23, 25, 26, 29, 30, 31},
    {0, 1, 5, 6, 9, 13, 15, 16, 17, 21, 25, 30, 31},
    {0, 1, 2, 6, 7, 8, 10, 14, 17, 18, 22, 26, 31},
    {0, 2, 7, 9, 10, 15, 18, 23, 24, 25, 26},
]
