import pandas as pd
import re
import numpy as np
from unidecode import unidecode
import dask.dataframe as dd
import multiprocessing
import os
import time
import dask.system
def apply_adaptation_KW(database, column_search):
    keyword_patterns = {
        "AdaptacaoClimatica" : re.compile(r'\badapta(?:ção|cao|ções|coes)\b\s+.*?\bclim(?:á|a)tic(?:a|as)\b(?:\s+|$)', re.IGNORECASE),
        "PagamentoServicoEcossistema" : re.compile(r'\bpagament(?:o|os)\b\s+.*?\bservi(?:ço|ços|co|cos)\b\s+.*?\becossistemi(?:cos|co)\b', re.IGNORECASE),
        "PagamentoCreditoCarbono" : re.compile(r'\bpagament(?:o|os)\b\s+.*?\bc(?:ré|re)dito\b\s+.*?\bcarbono\b', re.IGNORECASE),
        "PagamentoAgua" : re.compile(r'\bpagament(?:o|os)\b\s+.*?\b(?:á|a)gua\b', re.IGNORECASE),
        "AgriculturaControlada" : re.compile(r'\bagricultura\b\s+.*?\bcontrolada\b', re.IGNORECASE),
        "AgriculturaVertical" : re.compile(r'\bagricultura\b\s+.*?\bvertical\b', re.IGNORECASE),
        "FiscalizacaoAmbiental" : re.compile(r'\bfiscaliza(?:ção|çao|cão|cao)\b\s+\bambiental\b', re.IGNORECASE),
        "GestaoUsoAgua": re.compile(r'\bgest(?:ão|ao)\b\s+(?:\b(?:do|da|de|para o|para a)\b\s+)?\buso\b\s+(?:\b(?:do|da|de)\b\s+)?\b(?:á|a)gua\b', re.IGNORECASE),
        "EdificioVerde" : re.compile(r"\bedif(?:í|i)ci(?:o|os)\b\s+\bverd(?:e|es)\b", re.IGNORECASE),
        "InfraestruturaVerde" : re.compile(r"\binfraestrutur(?:a|as)\b\s+\bverd(?:e|es)\b", re.IGNORECASE),
        "TetoVerde" : re.compile(r"\btet(?:o|os)\b\s+\bverd(?:e|es)\b", re.IGNORECASE),
        "TelhadoVerde" : re.compile(r"\btelhad(?:o|os)\b\s+\bverd(?:e|es)", re.IGNORECASE),
        "ElevacaoNivelRodoviaEnchente" : re.compile(r"\beleva(?:ção|çao|cão|cao)\b\s+.*?\bn(?:í|i)vel\b\s+.*?\brodovi(?:a|as)\b\s+.*?\benchent(?:e|es)\b", re.IGNORECASE),
        "ElevacaoNivelRodoviaInundacao" : re.compile(r"\beleva(?:ção|çao|cão|cao)\b\s+.*?\bn(?:í|i)vel\b\s+.*?\brodovi(?:a|as)\b\s+.*?\binunda(?:ção|ções|cão|cões|cao|coes)\b", re.IGNORECASE),
        "ElevacaoNivelPistaEnchente" : re.compile(r"\beleva(?:ção|çao|cão|cao)\b\s+.*?\bn(?:í|i)vel\b\s+.*?\bpist(?:as|a)\b\s+.*?\benchent(?:e|es)\b", re.IGNORECASE),
        "ElevacaoNivelPistaInundacao" : re.compile(r"\beleva(?:ção|çao|cão|cao)\b\s+.*?\bn(?:í|i)vel\b\s+.*?\bpist(?:a|as)\b\s+.*?\binunda(?:ção|ções|cão|cões|cao|coes)\b", re.IGNORECASE),
        "Inundacao" : re.compile(r"\binunda(?:ção|ções|cão|cões|cao|coes)\b", re.IGNORECASE),
        "Enchente" : re.compile(r"\benchen(?:te|tes)\b", re.IGNORECASE),
        "SegurancaAlimentarAgriculturaAlimentar" : re.compile(r"\bseguran(?:ça|ca)\b\s+\balimentar\b\s+.*?\bagricultura\b\s+\bfamiliar\b", re.IGNORECASE),
        "SegurancaAlimentarPopulacaoTradicional" : re.compile(r"\bseguran(?:ça|ca)\b\s+\balimentar\b\s+.*?\bpopula(?:ção|çao|cão|cao)\b\s+\btradicional\b", re.IGNORECASE),
        "SegurancaAlimentarIndigena" : re.compile(r"\bseguran(?:ça|ca)\b\s+\balimentar\b\s+.*?\bind(?:í|i)gen(?:as|as)\b", re.IGNORECASE),
        "RecuperacaoAmbiental" : re.compile(r"\brecuper(?:a(?:r|ção|cao|ções|çoes|cões|coes|ando|do|da|dos|das)?|a|ou|ei|em|es|am|ava|avam|aria|ariam)\b\s+\bambiental\b", re.IGNORECASE),
        "RecuperacaoEcossistema" : re.compile(r"\brecuper(?:a(?:r|ção|cao|ções|çoes|cões|coes|ando|do|da|dos|das)?|a|ou|ei|em|es|am|ava|avam|aria|ariam)\b\s+.*?\becossiste(?:ma|mas)\b", re.IGNORECASE),
        "AguaResidual" : re.compile(r"\b(?:á|a)gu(?:a|as)\b\s+\bresidua(?:l|is)\b", re.IGNORECASE),
        "TratamentoAguaResidual" : re.compile(r"\btrata(?:r|mento|mentos)\b\s+.*?\b(?:á|a)gu(?:as|a)\b\s+\bresidua(?:l|is)\b", re.IGNORECASE),
        "TratamentoAgua" : re.compile(r"\btrata(?:r|mento|mentos)\b\s+.*?\b(?:á|a)gu(?:as|a)\b",re.IGNORECASE),
        "AquiculturaArtesanal" : re.compile(r"\baquicul(?:tor|tura|turas)\b\s+.*?\bartesa(?:nal|nais)\b",re.IGNORECASE),
        "AquiculturaInovacao" : re.compile(r"\baquicul(?:tor|tura|turas)\b\s+.*?\binova(?:ção|çao|ções|çoes|cão|cao|cões|coes)\b",re.IGNORECASE),
        "AquiculturaProtecaoEstoque" : re.compile(r"\baquicul(?:tor|tura|turas)\b\s+.*?\bprote(?:ção|çao|ções|çoes|cão|cao|cões|coes)\b\s+.*?\bestoqu(?:e|es)\b",re.IGNORECASE),
        "AssistenciaPublicaDesastres" : re.compile(r"\bassist(?:ê|e)nci(?:a|as)\b\s+.*?\bp(?:ú|u)blic(?:a|as)\b\s+.*?\bdesastr(?:e|es)\b",re.IGNORECASE),
        "TransposicaoRio" : re.compile(r"\btransposi(?:ção|çao|cão|cao)\b\s+.*?\bri(?:o|os)\b",re.IGNORECASE),
        "ConstrucaoSistemaAdutor" : re.compile(r"\bconstru(?:ção|çao|cão|cao|ções|çoes|cões|coes)\b\s+.*?\bsistem(?:a|as)\b\s+.*?\badut(?:or|ores)\b",re.IGNORECASE),
        "ConstrucaoCanalAdutor" : re.compile(r"\bconstru(?:ção|çao|cão|cao|ções|çoes|cões|coes)\b\s+.*?\bcan(?:al|ais)\b\s+.*?\badut(?:or|ores)\b",re.IGNORECASE),
        "IntegracaoBaciaHidrografica" : re.compile(r"\bintegra(?:ção|çao|cão|cao|ções|çoes|cões|coes)\b\s+.*?\bbaci(?:a|as)\b\s+\bhidrogr(?:á|a)fic(?:a|as)\b",re.IGNORECASE),
        "GerenciamentoBaciaHidrografica" : re.compile(r"\bgerenci(?:amento|ar|a)\b\s+.*?\bbaci(?:a|as)\b\s+\bhidrogr(?:á|a)fic(?:a|as)\b",re.IGNORECASE),
        "PesquisaRecursoHidrico" : re.compile(r"\bpesqui(?:sa|sar|sas)\b\s+.*?\brecur(?:so|sos)\b\s+\bh(?:í|i)dric(?:os|o)\b",re.IGNORECASE),
        "IntegracaoRioSaoFrancisco" : re.compile(r"\bintegra(?:ção|r|çao|cão|cao)\b\s+.*?\brio\b\s+\bs(?:ão|ao)\b\s+\bfrancisco\b",re.IGNORECASE),
        "CinturaoAguasCeara" : re.compile(r"\bcintur(?:ão|ao)\b\s+.*?\b(?:á|a)gu(?:a|as)\b\s+.*?\bcea(?:rá|ra)\b",re.IGNORECASE),
        "LevantamentoHidrogeologico" : re.compile(r"\blevanta(?:mento|r|ndo)\b\s+\bhidrogeol(?:ó|o)gico\b",re.IGNORECASE),
        "EstudoHidrologico" : re.compile(r"\bestu(?:dos|do|dar|dando)\b\s+\bhidrol(?:ó|o)gi(?:cos|co)\b",re.IGNORECASE),
        "MelhoramentoRacao" : re.compile(r"\bmelhor(?:ar|amento|a)\b\s+.*?\bra(?:ção|çao|cão|cao)\b",re.IGNORECASE),
        "ManejoRacao" : re.compile(r"\bmanej(?:o|os|ar|ando)\b\s+.*?\bra(?:ção|çao|cão|cao)\b",re.IGNORECASE),
        "NutricaoAnimal" : re.compile(r"\bnutri(?:r|ção|çao|cão|cao)\b\s+.*?\banim(?:al|ais)\b",re.IGNORECASE),
        "CatastrofeInundacao" : re.compile(r"\bcat(?:á|a)strofe\b\s+.*?\binun(?:dação|daçao|dacão|dacao|dar|da)\b",re.IGNORECASE),
        "CatastrofeEnchente" : re.compile(r"\bcat(?:á|a)strofe\b\s+.*?\benchen(?:te|tes)\b",re.IGNORECASE),
        "CatastrofeIncendio" : re.compile(r"\bcat(?:á|a)strofe\b\s+.*?\binc(?:ê|e)ndi(?:o|os)\b",re.IGNORECASE),
        "CatastrofeSeca" : re.compile(r"\bcat(?:á|a)strofe\b\s+.*?\bse(?:ca|cas)\b",re.IGNORECASE),
        "CatastrofeMetano" : re.compile(r"\bcat(?:á|a)strofe\b\s+.*?\bmetano\b",re.IGNORECASE),
        "CatastrofeDeslizamento" : re.compile(r"\bcat(?:á|a)strofe\b\s+.*?\bdesli(?:zar|zamento|za)\b",re.IGNORECASE),
        "CatastrofeAumentoNivelMar" : re.compile(r"\bcat(?:á|a)strofe\b\s+.*?\baumento\b\s+.*?\bn(?:í|i)vel\b\s+.*?\bmar\b",re.IGNORECASE),
        "CatastrofeAvancoNivelMar" : re.compile(r"\bcat(?:á|a)strofe\b\s+.*?\bavan(?:ço|co|çar|car)\b\s+.*?\bn(?:í|i)vel\b\s+.*?\bmar\b",re.IGNORECASE),
        "CatastrofeClimatica" : re.compile(r"\bcat(?:á|a)strofe\b\s+\bclim(?:a|ática|ático)\b",re.IGNORECASE),
        "CatastrofeAmbiental" : re.compile(r"\bcat(?:á|a)strofe\b\s+\bambiental\b",re.IGNORECASE),
        "MonitoramentoAlga" : re.compile(r"\bmonito(?:rar|ra|ramento)\b\s+.*?\balga\b",re.IGNORECASE),
        "MonitoramentoSalinidade" : re.compile(r"\bmonito(?:rar|ra|ramento)\b\s+.*?\bsalinidade\b",re.IGNORECASE),
        "MonitoramentoNivelRio" : re.compile(r"\bmonito(?:rar|ra|ramento)\b\s+.*?\bn(?:í|i)v(?:el|veis)\b\s+.*?\bri(?:o|os)\b",re.IGNORECASE),
        "MonitoramentoMeteorologico" : re.compile(r"\bmonito(?:rar|ra|ramento)\b\s+\bmeteoro(?:ló|lo)gico\b",re.IGNORECASE),
        "MonitoramentoDeslizamento" : re.compile(r"\bmonito(?:rar|ra|ramento)\b\s+.*?\bdeslizamento\b",re.IGNORECASE),
        "MonitoramentoEncosta" : re.compile(r"\bmonito(?:rar|ra|ramento)\b\s+.*?\bencost(?:a|as)\b",re.IGNORECASE),
        "FortalecimentoInundacao" : re.compile(r"\bfortale(?:cer|cimento|ce)\b\s+.*?\binunda(?:ção|çao|cão|cao)\b",re.IGNORECASE),
        "FortalecimentoEnchente" : re.compile(r"\bfortale(?:cer|cimento|ce)\b\s+.*?\benchent(?:e|es)\b",re.IGNORECASE),
        "FortalecimentoIncendio" : re.compile(r"\bfortale(?:cer|cimento|ce)\b\s+.*?\binc(?:ê|e)ndi(?:os|o)\b",re.IGNORECASE),
        "FortalecimentoSeca" : re.compile(r"\bfortale(?:cer|cimento|ce)\b\s+.*?\bsec(?:a|as)\b",re.IGNORECASE),
        "FortalecimentoMetano" : re.compile(r"\bfortale(?:cer|cimento|ce)\b\s+.*?\bmetano\b",re.IGNORECASE),
        "FortalecimentoCatastrofe" : re.compile(r"\bfortale(?:cer|cimento|ce)\b\s+.*?\bcat(?:á|a)stro(?:fe|fes)\b",re.IGNORECASE),
        "FortalecimentoDeslizamento" : re.compile(r"\bfortale(?:cer|cimento|ce)\b\s+.*?\bdeslizament(?:o|os)\b",re.IGNORECASE),
        "VulnerabilidadeClimatica": re.compile(r"\bvulner(?:avel|ável|abilidade|aveis|áveis|abilidades)\b\s+\bcli(?:ma|mática|matica|mático|matico|máticas|maticas)\b",re.IGNORECASE),
        "Saneamento" : re.compile(r"\bsaneamento\b",re.IGNORECASE),
        "CaixaDaguaSemiarido" : re.compile(r"\bcaixa(?:d'água|dagua|dágua)\b\s+.*?\bsemi(?:árido|arido)\b",re.IGNORECASE),
        "CaixaDaguaCerrado" : re.compile(r"\bcaixa(?:d'água|dagua|dágua)\b\s+.*?\bcerrado\b",re.IGNORECASE),
        "CaixaDaguaDesertificacao" : re.compile(r"\bcaixa(?:d'água|dagua|dágua)\b\s+.*?\bdeser(?:to|tificacao|tificaçao|tificação)\b",re.IGNORECASE),
        "CaminhaoPipa" : re.compile(r"\bcami(?:nhao|nhão|nhões|nhoes)-pi(?:pa|pas)\b",re.IGNORECASE),
        "CaminhaoTanque": re.compile(r"\bcami(?:nhao|nhão|nhões|nhoes)-tanqu(?:e|es)\b",re.IGNORECASE),
        "Cisterna": re.compile(r'\bcisterna\b',re.IGNORECASE),
        "Acude" : re.compile(r"\ba(?:c|ç)ude\b",re.IGNORECASE),
        "PrecificacaoAgua" : re.compile(r"\bprecific(?:ar|a|ação|açao|acão|acao)\b\s+.*?\b(?:á|a)gua\b",re.IGNORECASE),
        "PreparacaoDesastre" : re.compile(r"\bprepara(?:r|ção|çao|cão|cao)\b\s+.*?\bdesastr(?:es|e)\b",re.IGNORECASE),
        "PrevencaoDesastre" : re.compile(r"\bprev(?:enção|ençao|encão|encao|inir)\b\s+.*?\bdesastr(?:es|e)\b",re.IGNORECASE),
        "PreparacaoInundacao" : re.compile(r"\bprepara(?:r|ção|çao|cão|cao)\b\s+.*?\binunda(?:ção|çao|cão|cao|ções|çoes|cões|coes)\b",re.IGNORECASE),
        "PrevencaoInundacao" : re.compile(r"\bprev(?:enção|ençao|encão|encao|inir)\b\s+.*?\binunda(?:ção|çao|cão|cao|ções|çoes|cões|coes)\b",re.IGNORECASE),
        "PreparacaoEnchente" : re.compile(r"\bprepara(?:r|ção|çao|cão|cao)\b\s+.*?\benchent(?:e|es)\b",re.IGNORECASE),
        "PrevencaoEnchente" : re.compile(r"\bprev(?:enção|ençao|encão|encao|inir)\b\s+.*?\benchent(?:e|es)\b",re.IGNORECASE),
        "PreparacaoIncendio" : re.compile(r"\bprepara(?:r|ção|çao|cão|cao)\b\s+.*?\binc(?:ê|e)ndi(?:os|o)\b",re.IGNORECASE),
        "PrevencaoIncendio" : re.compile(r"\bprev(?:enção|ençao|encão|encao|inir)\b\s+.*?\binc(?:ê|e)ndi(?:os|o)\b",re.IGNORECASE),
        "PreparacaoSeca" : re.compile(r"\bprepara(?:r|ção|çao|cão|cao)\b\s+.*?\bseca\b",re.IGNORECASE),
        "PrevencaoSeca" : re.compile(r"\bprev(?:enção|ençao|encão|encao|inir)\b\s+.*?\bseca\b",re.IGNORECASE),
        "PreparacaoMetano" : re.compile(r"\bprepara(?:r|ção|çao|cão|cao)\b\s+.*?\bmetano\b",re.IGNORECASE),
        "PrevencaoMetano" : re.compile(r"\bprev(?:enção|ençao|encão|encao|inir)\b\s+.*?\bmetano\b",re.IGNORECASE),
        "PreparacaoCatastrofe" : re.compile(r"\bprepara(?:r|ção|çao|cão|cao)\b\s+.*?\bcat(?:á|a)strof(?:e|es)\b",re.IGNORECASE),
        "PrevencaoCatastrofe" : re.compile(r"\bprev(?:enção|ençao|encão|encao|inir)\b\s+.*?\bcat(?:á|a)strof(?:e|es)\b",re.IGNORECASE),
        "PreparacaoDeslizamento" : re.compile(r"\bprepara(?:r|ção|çao|cão|cao)\b\s+.*?\bdeslizament(?:o|os)\b",re.IGNORECASE),
        "PrevencaoDeslizamento" : re.compile(r"\bprev(?:enção|ençao|encão|encao|inir)\b\s+.*?\bdeslizament(?:o|os)\b",re.IGNORECASE),
        "ProtecaoAgricultura" : re.compile(r"\bprote(?:ger|ção|çao|cão|cao|ge)\b\s+.*?\bagricultura\b",re.IGNORECASE),
        "ProtecaoProducaoAgricultura" : re.compile(r"\bprote(?:ger|ção|çao|cão|cao|ge)\b\s+.*?\bprodu(?:ção|çao|cão|cao)\b\s+\bagr(?:í|i)col(?:a|as)\b",re.IGNORECASE),
        "ReforcoInundacao" : re.compile(r"\brefor(?:ço|co|ços|cos|çar|car)\b\s+.*?\binunda(?:ção|cão|çao|cao)\b",re.IGNORECASE),
        "ReforcoEnchente" : re.compile(r"\brefor(?:ço|co|ços|cos|çar|car)\b\s+.*?\benchent(?:e|es)\b",re.IGNORECASE),
        "ReforcoIncendio" : re.compile(r"\brefor(?:ço|co|ços|cos|çar|car)\b\s+.*?\binc(ê|e)ndio\b",re.IGNORECASE),
        "ReforcoSeca" : re.compile(r"\brefor(?:ço|co|ços|cos|çar|car)\b\s+.*?\bsec(?:a|as)\b",re.IGNORECASE),
        "ReforcoMetano" : re.compile(r"\brefor(?:ço|co|ços|cos|çar|car)\b\s+.*?\bmetano\b",re.IGNORECASE),
        "ReforcoCatastrofe" : re.compile(r"\brefor(?:ço|co|ços|cos|çar|car)\b\s+.*?\bcat(?:á|a)strof(?:e|es)\b",re.IGNORECASE),
        "ReforcoDeslizamento" : re.compile(r"\brefor(?:ço|co|ços|cos|çar|car)\bs+.*?\bdesliza(?:mento|mentos)\b",re.IGNORECASE),
        "QuebraMar" : re.compile(r"\bquebra(?:-|)ma(?:r|res)\b",re.IGNORECASE),
        "ExtensaoRural" : re.compile(r"\bextens(?:ão|ao)\b\s+\brural\b",re.IGNORECASE),
        "AgriculturaFamiliar" : re.compile(r"\bagric(?:ultura|ulturas|ultor|ultores|ultora|ultoras)\b\s+\bfamili(?:ar|ares)\b",re.IGNORECASE),
        "MonitoramentoAmbiental" : re.compile(r"\bmonitoramento\b\s+\bambiental\b",re.IGNORECASE),
        "InfraestruturaIrrigacao" : re.compile(r"\binfraestrutu(?:ra|ras)\b\s+.*?\birriga(?:ção|çao|cão|cao|ções|çoes|cões|coes)\b",re.IGNORECASE),
        "PagamentoServicoEcossistemico" : re.compile(r"\bpagament(?:o|os)\b\s+.*?\bservi(?:ços|ço|cos|co)\b\s+\becossist(?:é|e)mic(?:o|os)",re.IGNORECASE),
        "EstudoClimatico" : re.compile(r"\bestud(?:o|os)\b\s+.*?\bclim(?:á|a)tic(?:o|os)",re.IGNORECASE),
        "ConstrucaoCanalAdutor" : re.compile(r"\bconstru(?:ção|çao|cão|cao)\b\s+.*?\bca(?:nal|nais)\b\s+adu(?:tor|tores)\b",re.IGNORECASE),
        "MelhoriaAbastecimentoAgua" : re.compile(r"\bmelhori(?:a|as)\b\s+.*?\babaste(?:ce|cer|cimento|cimentos)\b\s+.*?\b(?:á|a)gu(?:a|as)\b",re.IGNORECASE),
        "IntegracaoBaciaRio" : re.compile(r"\bintegr(?:ar|ação|açao|acão|acao)\b\s+.*?\bbac(?:a|as)\b\s+.*?\br(?:io|ios)\b",re.IGNORECASE),
        "ImplantacaoAdutora" : re.compile(r"\bimplan(?:tar|tação|taçao|tacão|tacao)\b\s+.*?\badutor(?:a|as)\b",re.IGNORECASE),
        "OfertaAgua" : re.compile(r"\bofer(?:ecer|ta|tas)\b\s+.*?\b(?:á|a)gu(?:as|a)\b",re.IGNORECASE),
        "PesquisaRecursoHidrico" : re.compile(r"\bpesqui(?:sar|sa|sas)\b\s+.*?\brecur(?:so|sos)\b\s+\bh(í|i)dric(?:o|os)\b",re.IGNORECASE),
        "Cooperativismo Rural" : re.compile(r"\bcoope(?:rativismo|ração|raçao|racão|racao|rar)\b\s+.*?\bru(?:ral|rais|ralismo|ralismos)\b",re.IGNORECASE),
        "UnidadesProdutivasComunitarias" : re.compile(r"\bunidad(?:es|e)\b\s+.*?\bprodutiv(?:a|as)\b\s+.*?\bcomuni(?:tárias|tária)\b",re.IGNORECASE),
        "CompensacaoAmbiental" : re.compile(r"\bcompen(?:sar|sação|saçao|sacão|sacao)\b\s+\bambient(?:al|ais)\b",re.IGNORECASE),
        "AreasDegradadas" : re.compile(r"\b(?:á|a)re(?:a|as)\b\s+\bdegrada(?:da|das)\b",re.IGNORECASE),
        "PerigoGeologico" : re.compile(r"\bperig(?:o|os)\b\s+.*?\bgeol(?:ó|o)gic(?:o|os)\b",re.IGNORECASE),
        "RiscoGeologico" : re.compile(r"\bris(?:co|cos)\b\s+.*?\bgeol(?:ó|o)gic(?:o|os)\b",re.IGNORECASE),
        "SuscetibilidadeMovimentoMassa" : re.compile(r"\bsuscetibilidade\b\s+.*?\bmovimen(?:tar|to|tos)\b\s+.*?\bmass(?:a|as)\b",re.IGNORECASE),
        "AptidaoUrbanizacao": re.compile(r"\bapti(?:dão|dao)\b\s+.*?\bur(?:banizar|banização|banizaçao|banizacão|banizacao)\b",re.IGNORECASE),
        "MonitoramentoSistemaEletrico" : re.compile(r"\bmonito(?:rar|ra|ramento)\b\s+.*\bsiste(?:ma|mas)\b\s+.*?\bel(?:é|e)tric(?:o|os)\b",re.IGNORECASE),
        "UnidadeSaudeIndigena" : re.compile(r"\bunida(?:de|des)\b\s+.*?\bsa(?:ú|u)d(?:e|es)\b\s+\bind(?:í|i)ge(?:na|nas)\b",re.IGNORECASE),
        "PromocaoSaudeIndigena" : re.compile(r"\bpromo(?:ção|çao|cão|cao)\b\s+.*?\bsa(?:ú|u)d(?:e|es)\b\s+\bind(?:í|i)ge(?:na|nas)\b",re.IGNORECASE),
        "MedicamentoPopulacaoIndigena" : re.compile(r"\bmedica(?:mento|mentos)\b\s+.*?\bpopula(?:ção|çao|cão|cao|ções|çoes|cões|coes)\b\s+\bind(?:í|i)ge(?:na|nas)\b",re.IGNORECASE),
        "ControleEnchentes" : re.compile(r"\bcontro(?:le|les|lar)\b\s+.*?\benchen(?:te|tes)\b",re.IGNORECASE),
        "ControleInundacao" : re.compile(r"\bcontro(?:le|les|lar)\b\s+.*?\binun(?:dação|daçao|dacão|dacao|dar|da)\b",re.IGNORECASE),
        "ControleIncendio" : re.compile(r"\bcontro(?:le|les|lar)\b\s+.*?\binc(?:ê|e)nd(?:io|ios)\b",re.IGNORECASE),
        "ControleSeca" : re.compile(r"\bcontro(?:le|les|lar)\b\s+.*?\bsec(?:a|as)\b",re.IGNORECASE),
        "ControleMetano" : re.compile(r"\bcontro(?:le|les|lar)\b\s+.*?\bmetano\b",re.IGNORECASE),
        "ControleCatastrofe" : re.compile(r"\bcontro(?:le|les|lar)\b\s+.*?\bcat(?:á|a)stro(?:fe|fes)\b",re.IGNORECASE),
        "ConstrucaoBarragem" : re.compile(r"\bconstru(?:ção|çao|cão|cao|ir)\b\s+.*?\bbarra(?:gem|gens)\b",re.IGNORECASE),
        "ServicoMeteorologico" : re.compile(r"\bservi(?:ço|ços|co|cos)\b\s+\bmeteoro(?:ló|lo)gi(?:co|cos)\b",re.IGNORECASE),
        "MelhoriaAbastecimentoAgua" : re.compile(r"\bmelhori(?:a|as)\b\s+.*?\babas(?:tece|tecer|tecimento|tecimentos)\b\s+.*?\b(?:á|a)gu(?:a|as)\b",re.IGNORECASE),
        "AdequacaoAbastecimentoAgua" : re.compile(r"\badequ(?:ar|ação|açao|acão|acao)\b\s+.*?\babaste(?:cer|ce|cimento|cimentos)\b\s+.*?\b(?:á|a)gu(?:a|as)\b",re.IGNORECASE),
        "FiscalizacaoSeguroRural" : re.compile(r"\bfiscali(?:zar|za|zação|zaçao|zacão|zacao)\b\s+.*?\bsegur(?:o|os)\b\s+.*?\brur(?:al|ais)\b",re.IGNORECASE),
        "SeguroDefeso" : re.compile(r"\bsegur(?:o|os)\b\s+\bdefeso\b",re.IGNORECASE),
        "RecuperacaoAmbiental" : re.compile(r"\brecupe(?:rar|ra|ração|raçao|racão|racao)\b\s+\bambien(?:tal|tais)\b",re.IGNORECASE),
        "CreditoFamiliaAssentada" : re.compile(r"\bcr(?:é|e)di(?:to|tos)\b\s+.*?\bfam(?:í|i)li(?:a|as)\b\s+.*?\bassenta(?:mento|mentos|da|das)\b",re.IGNORECASE),
        "DesenvolvimentoSetorAguas" : re.compile(r"\bdesenvol(?:ver|vimento|vimentos)\b\s+.*?\bset(?:or|ores)\b\s+.*?\b(a|á)gu(?:a|as)\b",re.IGNORECASE),
        "CombateCheia" : re.compile(r"\bcomba(?:ter|te)\b\s+.*?\bchei(?:a|as)\b",re.IGNORECASE),
        "CombateInundacao" : re.compile(r"\bcomba(?:ter|te)\b\s+.*?\binunda(?:ção|çao|cão|cao)\b",re.IGNORECASE),
        "CombateIncendio" : re.compile(r"\bcomba(?:ter|te)\b\s+.*?\binc(?:ê|e)nd(?:ios|io)\b",re.IGNORECASE),
        "CombateSeca" : re.compile(r"\bcomba(?:ter|te)\b\s+.*?\bsec(?:a|as)\b",re.IGNORECASE),
        "CombateMetano" : re.compile(r"\bcomba(?:ter|te)\b\s+.*?\bmetano\b",re.IGNORECASE),
        "CombateCatastrofe" : re.compile(r"\bcomba(?:ter|te)\b\s+.*?\bcat(?:á|a)strof(?:e|es)\b",re.IGNORECASE),
        "PrevisaoCheia" : re.compile(r"\bprevis(?:ão|ao|ões|oes)\b\s+.*?\bchei(?:a|as)\b",re.IGNORECASE),
        "PrevisaoInundacao" : re.compile(r"\bprevis(?:ão|ao|ões|oes)\b\s+.*?\binunda(?:ção|çao|cão|cao|ções|çoes|cões|coes)\b",re.IGNORECASE),
        "PrevisaoIncendio" : re.compile(r"\bprevis(?:ão|ao|ões|oes)\b\s+.*?\binc(?:ê|e)ndi(?:o|os)\b",re.IGNORECASE),
        "PrevisaoSeca" : re.compile(r"\bprevis(?:ão|ao|ões|oes)\b\s+.*?\bsec(?:a|as)\b",re.IGNORECASE),
        "PrevisaoMetano" : re.compile(r"\bprevis(?:ão|ao|ões|oes)\b\s+.*?\bmetano\b",re.IGNORECASE),
        "PrevisaoCatastrofe" : re.compile(r"\bprevis(?:ão|ao|ões|oes)\b\s+.*?\bcat(?:á|a)strof(?:e|es)\b",re.IGNORECASE),
        "EstudoHidrologico" : re.compile(r"\bestud(?:os|o)\b\s+.*?\bhidro(?:ló|lo)gic(?:o|os)\b",re.IGNORECASE),
        "SaudeRibeirinha" : re.compile(r"\bsa(?:ú|u)d(?:e|es)\b\s+.*?\bribeirinh(?:a|o)",re.IGNORECASE),
        "SateliteAgricultura" : re.compile(r"\bsat(?:é|e)lit(?:e|es)\b\s+.*?\bagricultur(?:a|as)\b",re.IGNORECASE),
        "DadosMeteorologico" : re.compile(r"\bdad(?:o|os)\b\s+.*?\bmeteoro(?:ló|lo)gic(?:o|os)\b",re.IGNORECASE),
        "AumentoNivelMar" : re.compile(r"\baumen(?:tar|ta|to)\b\s+.*?\bn(?:í|i)ve(?:l|is)\b\s+.*?\bm(?:ar|ares)\b",re.IGNORECASE),
        "AvancoNivelMar" : re.compile(r"\bavan(?:çar|ço|ços)\b\s+.*?\bn(?:í|i)ve(?:l|is)\b\s+.*?\bm(?:ar|ares)\b",re.IGNORECASE),
        "DisponibilidadeAgua": re.compile(r'\bdisponibili\w*(?:\s+\w+){0,3}?\s+(?:aguas?|hidric\w)\b', re.IGNORECASE),
        "EmergenciaClimatica" : re.compile(r"\bemerg(?:ê|e)nci(?:a|as)\b\s+.*?\bclim(?:á|a)tic(?:a|as)\b",re.IGNORECASE),
        "ClimaExtremo" : re.compile(r"\bclima\b\s+.*?\bextre(?:mo|mos)\b",re.IGNORECASE),
        "BaixaQualidadeAr" : re.compile(r"\bbaixa\b\s+.*?\bqualidade (?:do|de)\b\s+\bar\b",re.IGNORECASE),
        "OutorgaAgua" : re.compile(r"\boutor(?:gar|ga|gas)\b\s+.*?\b(?:á|a)gu(?:a|as)\b",re.IGNORECASE),
        "MovimentoGravitacionalMassa" : re.compile(r"\bmovimen(?:tar|to)\b\s+.*\bgravitacio(?:nal|nais)\b\s+.*?\bmass(?:a|as)\b",re.IGNORECASE),
        "ProtecaoIndio" : re.compile(r"\bprote(?:ger|ção|çao|cão|cao)\b\s+.*?\b(?:í|i)ndi(?:o|os)\b",re.IGNORECASE),
        "ExploracaoSustentavel" : re.compile(r"\bexplo(?:rar|ração|raçao|racão|racao|ra)\b\s+.*?\bsustent(?:á|a)v(?:el|veis)\b",re.IGNORECASE),
        "InfraestruturaHidrica" : re.compile(r"\binfraestrutu(?:a|as)\b\s*?\bh(?:í|i)dric(?:a|as)\b",re.IGNORECASE),
        "ProducaoSustentavel" : re.compile(r"\bprodu(?:ção|çao|cão|cao|ções|çoes|cões|coes)\b\s+.*?\bsustent(?:á|a)v(?:el|veis)\b",re.IGNORECASE),
        "Desertificacao" : re.compile(r"\bdesertifica(?:ção|çao|cão|cao)\b",re.IGNORECASE),
        "SegurancaBarragem": re.compile(r"\bseguran(?:ça|ca|ças|cas)\b\s+.*?\bbarra(?:gem|gens)\b",re.IGNORECASE),
        "RegularizacaoRecursoHidrico" : re.compile(r"\bregulari(?:zar|zação|zaçao|zacão|zacao)\b\s+.*?\brecurs(?:sos|so)\b\s+.*?\bh(í|i)dric(?:o|os)\b",re.IGNORECASE),
        "ArmazenamentoGraoBiocombustivel" : re.compile(r"\barmaze(?:nar|nagem|m|namento)\b\s+.*?\bgr(?:ão|ao|ãos|aos)\b\s+.*?\bbiocombus(?:tí|ti)ve(?:l|eis)\b",re.IGNORECASE),
        "ArmazenamentoGraoEtanol" : re.compile(r"\barmaze(?:nar|nagem|m|namento)\b\s+.*?\bgr(?:ão|ao|ãos|aos)\b\s+.*?\betanol\b",re.IGNORECASE),
        "Babacu" : re.compile(r"\bbaba(?:çu|cu)\b",re.IGNORECASE),
        "TecnologiaSocial" : re.compile(r"\btecnologi(?:a|as)\b\s+.*?\bsoci(?:al|ais)\b",re.IGNORECASE),
        "EducacaoClimatica" : re.compile(r"\beduc(?:ar|ação|açao|acão|acao)\b\s+\bclim(?:á|a)ti(?:ca|co)\b",re.IGNORECASE),
        "PlantioArvores" : re.compile(r"\bplant(?:ar|io)\b\s+.*?\b(á|a)rvo(?:res|re|redo|redos)\b",re.IGNORECASE),
        "ProcessoErosivo" : re.compile(r"\bproce(?:sso|ssos)\b\s*.?\berosi(?:vo|vos)\b",re.IGNORECASE),
        "EstabilizacaoEnconsta" : re.compile(r"\bestabili(?:zar|zação|zaçao|zacao|zacão)\b\s+.*?\beconst(?:a|as)\b",re.IGNORECASE),
        "EngenhariaNatural" : re.compile(r"\bengenha(?:ria|rias)\b\s+.*?\bnatur(al|ais)\b",re.IGNORECASE),
        "AguaPluvial" : re.compile(r"\b(?:á|a)gu(?:a|as)\b\s+.*?\bpluvi(?:al|ais)\b",re.IGNORECASE),
        "PavimentoPermeavel" : re.compile(r"\bpavimen(?:to|tos)\b\s+.*?\bperme(?:á|a)v(?:el|eis)\b",re.IGNORECASE),
        "PocoInfiltracao" : re.compile(r"\bpo(?:ço|co)\b\s+.*?\binfiltra(?:ção|çao|cão|cao)\b | \binfiltra(?:ção|çao|cão|cao)\b\s+.*?\bpo(?:ço|co)\b",re.IGNORECASE),
        "Trincheira" : re.compile(r"\btrinchei(?:ra|ras)\b",re.IGNORECASE),
        "Biovaleta" : re.compile(r"\bbiovale(?:ta|tas)\b",re.IGNORECASE),
        "Biorretencao" : re.compile(r"\bbiorreten(?:ção|çao|cão|cao)\b",re.IGNORECASE),
        "SolucaoBaseadaNatureza" : re.compile(r"\bsolu(?:ção|ções|çao|çoes|cão|cões)\b\s+\bbasead(?:a|as)\b\s+.*?\bnature(?:za|zas)\b",re.IGNORECASE),
        "MataCiliar" : re.compile(r"\bmat(?:a|as)\b\s+\bcili(?:ar|ares)\b",re.IGNORECASE),
        "Reflorestamento" : re.compile(r"\breflores(?:tar|ta|tamento)\b",re.IGNORECASE),
        "Agrofloresta" : re.compile(r"\bagroflores(?:tal|tais|ta|tamento|tamentos)\b",re.IGNORECASE),
        "QuintalProdutivo" : re.compile(r"\bquin(?:tal|tais)\b\s+\bproduti(?:vo|vos)\b",re.IGNORECASE),
        "AguaBruta" : re.compile(r"\b(?:á|a)gu(?:a|as)\b\s+brut(?:a|as)\b",re.IGNORECASE),
        "AguaPotavel" : re.compile(r"\b(?:á|a)gu(?:a|as)\b\s+\bpot(?:á|a)v(?:el|eis)"),
        "AreasAlagadas": re.compile(r"\b(?:á|a)re(?:a|as)\b\s+\balaga(?:da|das)\b",re.IGNORECASE),
        "AvisoDesastre" : re.compile(r"\bavis(?:o|os)\b\s+.*?\bdesastr(?:e|es)\b",re.IGNORECASE),
        "Biodiversidade" : re.compile(r"\bbiodiversidade\b",re.IGNORECASE),
        "CoberturaVegetal" : re.compile(r"\bcobertura\b\s+\bvegetal\b",re.IGNORECASE),
        "CoberturaVerde" : re.compile(r"\bcobertura\b\s+\bverde\b",re.IGNORECASE),
        "IncendioFlorestal" : re.compile(r"\binc(?:ê|e)ndi(?:o|os)\b\s+\bflorest(?:a|al|ais)\b",re.IGNORECASE),
        "Praga" : re.compile(r"\bprag(?:a|as)\b",re.IGNORECASE),
        "DanoClimatico" : re.compile(r"\bdan(?:o|os)\b\s+.*?\bclim(?:á|a)tic(?:o|os)\b",re.IGNORECASE),
        "Erosao" : re.compile(r"\bero(?:são|sao)\b",re.IGNORECASE),
        "Florestamento" : re.compile(r"\bflorestamento\b",re.IGNORECASE),
        "MonitoramentoClimatico" : re.compile(r"\bmonitora(?:r|mento)\b\s+.*?\bclim(?:á|a)ti(?:co|cos)\b",re.IGNORECASE),
        "SeguroAgricola": re.compile(r"\bsegur(?:o|os)\b\s+\bagr(?:í|i)co(?:la|las)\b",re.IGNORECASE),
        "SeguroClima" : re.compile(r"\bsegur(?:o|os)\b\s+.*?\bclim(a|ático)\b",re.IGNORECASE),
        "Reservatorio" : re.compile(r"\breserva(?:tó|to)ri(?:o|os)\b",re.IGNORECASE),
        "Drenagem" : re.compile(r"\bdrenagem\b",re.IGNORECASE),
        "Compostagem" : re.compile(r"\bcompostagem\b",re.IGNORECASE),
        "ZoneamentoZonaCosteiro" : re.compile(r"\bzon(?:a|eamento)\b\s+\bcosteiro\b",re.IGNORECASE),
        "SementeSemear" : re.compile(r"\bsem(?:ear|ente)\b",re.IGNORECASE),
        "Resiliencia" : re.compile(r"\bresili(?:ê|e)ncia\b",re.IGNORECASE),
        "Resiliente" : re.compile(r"\bresiliente\b",re.IGNORECASE),
        "CapacidadeAdaptativa" : re.compile(r"\bcapacidade\b\s+\badaptativa\b",re.IGNORECASE),
        "SeguroDesastre" : re.compile(r"\bsegu(?:ro|ros)\b\s+.*?\bdesas(?:tre|tres)\b",re.IGNORECASE),
        "DescontinuacaoMineracao" : re.compile(r"\bdesconti(?:nuar|nuação|nuaçao|nuacão|nuacao)\b\s+.*?\bminera(?:ção|çao|cão|cao)\b",re.IGNORECASE),
        "DescontinuacaoRejeito" : re.compile(r"\bdesconti(?:nuar|nuação|nuaçao|nuacão|nuacao)\b\s+.*?\brejeito\b",re.IGNORECASE),
        "DescontinuacaoBarragem" : re.compile(r"\bdesconti(?:nuar|nuação|nuaçao|nuacão|nuacao)\b\s+.*?\bbarra(?:gem|gens)\b",re.IGNORECASE),
        "DesativacaoMineracao" : re.compile(r"\bdesa(?:tivar|tivação|tivaçao|tivacão|tivacao)\b\s+.*?\bminera(?:ção|çao|cão|cao)\b",re.IGNORECASE),
        "DesativacaoRejeito" : re.compile(r"\bdesa(?:tivar|tivação|tivaçao|tivacão|tivacao)\b\s+.*?\brejeito\b",re.IGNORECASE),
        "DesativacaoBarragem" : re.compile(r"\bdesa(?:tivar|tivação|tivaçao|tivacão|tivacao)\b\s+.*?\bbarra(?:gem|gens)\b",re.IGNORECASE),
        "DescomissionamentoMineracao" : re.compile(r"\bdescomi(?:ssionar|ssionamento)\b\s+.*?\bminera(?:ção|çao|cão|cao)\b",re.IGNORECASE),
        "DescomissionamentoRejeito" : re.compile(r"\bdescomi(?:ssionar|ssionamento)\b\s+.*?\brejeito\b",re.IGNORECASE),
        "DescomissionamentoBarragem" : re.compile(r"\bdescomi(?:ssionar|ssionamento)\b\s+.*?\bbarra(?:gem|gens)\b",re.IGNORECASE),
        "SegurancaHidrica" : re.compile(r"\bseguran(?:ça|ças|ca|cas)\b\s+.*?\bh(?:í|i)dri(?:ca|cas)\b",re.IGNORECASE),
        "EspecieInvasora" : re.compile(r"\besp(?:é|e)ci(?:e|es)\b\s+\binva(?:sora|soras)\b",re.IGNORECASE),
        "AgriculturaUrbana" : re.compile(r"\bagricul(?:tor|tura|turas)\b\s+\burban(?:a|as|o|os)\b", re.IGNORECASE),
        "CalamidadePublica" : re.compile(r"\bcalamida(?:de|des)\b\s+\bp(?:ú|u)blic(?:a|as)\b", re.IGNORECASE),
        "PoliticaNacionalMudancadoClima" : re.compile(r"\bpo(?:lí|li)tic(?:a|as)\b\s+\bnacio(?:nal|nais)\b\s+.*?\bmudan(?:ça|ca|ças|cas)\b\s+.*?\bclima\w*", re.IGNORECASE),
        "GestaoRiscosAmbientais" : re.compile(r"\bges(?:tão|tao)\b\s+.*?\bris(?:cos|co)\b\s+.*?\bambien(?:tal|tais)\b", re.IGNORECASE),
        "InovacaoBioinsumos" : re.compile(r"\binov(?:ar|ação|açao|acão|acao)\b\s+.*?\bbioinsu(?:mo|mos)\b", re.IGNORECASE),
        "RespostaEmergenciaAgropecuaria" : re.compile(r"\brespos(?:ta|tas)\b\s+.*?\bemer(?:gê|ge)nci(?:a|as)\b\s+.*?\bagr(?:ária|aria|opecúaria|opecuaria|opecúario|opecuario)", re.IGNORECASE),
        "DistribuicaoInseticidas" : re.compile(r"\bdistribui(?:ção|çao|cão|cao)\b\s+.*?\binsetici(?:da|das)\b", re.IGNORECASE),
        "DistribuicaoBiolarvicidas" : re.compile(r"\bdistribui(?:ção|çao|cão|cao)\b\s+.*?\bbiolarvici(?:da|das)\b", re.IGNORECASE),
        "ConstrucaoAdutora" : re.compile(r"\bconstru(?:ir|ção|çao|cão|cao)\b\s+.*?\baduto(?:ra|ras)\b", re.IGNORECASE),
        "ControleResiduosProdutosAnimais" : re.compile(r"\bcontrole\b\s+.*?\bres(?:í|i)du(?:o|os)\b\s+.*?\bprodu(?:to|tos)\b\s+\banim(?:al|ais)\b", re.IGNORECASE),
        "MatrizRiscoAgropecuario" : re.compile(r"\bmatr(?:iz|izes)\b\s+.*?\bris(?:co|cos)\b\s+\bagrope(?:cúario|cuario|cúarios|cuarios)\b",re.IGNORECASE),
        "PesquisaClima" : re.compile(r"\bpesqui(?:sar|sa|sas)\b\s+.*?\bcli(?:mática|mático|matica|matico|ma|mas)\b",re.IGNORECASE),
        "PesquisaCicloBiogeoquimico" : re.compile(r"\bpesqui(?:sar|sa|sas)\b\s+.*?\bcic(lo|los)\b\s+.*?\bbiogeo(?:químico|químicos|quimicos|quimicos)\b",re.IGNORECASE),
        "PesquisaEcossistemaAmazonico" : re.compile(r"\bpesqui(?:sar|sa|sas)\b\s+.*?\becossiste(?:ma|mas)\b\s+\bama(?:zô|zo)ni(?:co|cos)\b",re.IGNORECASE),
        "RastreabilidadeAgroalimentar" : re.compile(r"\brastre(?:bilidade|bilidades)\b\s+.*?\bagroalimen(?:tar|tares)\b", re.IGNORECASE),
        "ManutencaoBarragem" : re.compile(r"\bmanuten(?:ção|çao|cão|cao)\b\s+.*?\bbarra(?:gem|gens)\b", re.IGNORECASE),
        "PlanoNacionalGestaoRiscosRespostasDesastresNaturais" : re.compile(r"\bplano\b\s+\bnacional\b\s+.*?\bgest(?:ão|ao)\b\s+.*?\bris(?:co|cos)\b\s+.*?\brespos(?:tas|ta)\b\s+.*?\bdesas(?:tre|tres)\b\s+\bnatur(?:ais|al)\b",re.IGNORECASE),
        "ReabilitacaoBarragem" : re.compile(r"\breabilita(?:ção|çao|cão|cao|ções|çoes|cões|coes)\b\s+.*?\bbarrag(?:em|ens)\b",re.IGNORECASE),
        "DesenvolvimentoInformacaoGeorreferenciada" : re.compile(r"\bdesen(?:volver|volvimento|volvimentos)\b\s+.*?\binforma(?:ção|ções|çao|çoes|cão|cões|cao|coes)\b\s+.*?\bgeorreferenciada\b",re.IGNORECASE),
        "EstudoHidrogeologicoHidrologico" : re.compile(r"\bestu(?:do|dos)\b\s+.*?\bhidro(?:lógico|logico|lógicos|logicos|geológico|geológicos|geologico|geologicos)\b",re.IGNORECASE),
        "GestaoInformacaoGeologica" : re.compile(r"\bges(?:tão|tao)\b\s+.*?\binforma(?:ção|çao|cão|cao|ções|cões|çoes|coes)\b\s+.*?\bgeo(?:ló|lo)gi(?:ca|co|cas|cos)\b",re.IGNORECASE),
        "DesenvolvimentoSemiarido" : re.compile(r"\bdesenvol(?:ver|vimento|vimentos)\b\s+.*?\bsemi(?:á|a)ri(?:do|dos)\b",re.IGNORECASE),
        "ProjetoPublicoIrrigacao" : re.compile(r"\bproje(?:to|tos)\b\s+.*?\bp(?:ú|u)blic(?:os|o)\b\s+.*?\birrig(?:ar|ação|açao|acão|acao)\b",re.IGNORECASE),
        "ProdutosSociobiodiversidade" : re.compile(r"\bprodu(?:to|tos)\b\s+.*?\bsociobiodiversidad(?:e|es)\b",re.IGNORECASE),
        "CooperativismoAgropecuario" : re.compile(r"\bcooperativismo\b\s+.*?\bagropecu(?:á|a)ri(?:a|as|o|os)\b",re.IGNORECASE),
        "DesenvolvimentoPrevisaoClima" : re.compile(r"\bdesenvol(?:ver|vimento|vimentos)\b\s+.*?\bpre(?:ver|visão|visao)\b\s+.*?\bclim(?:a|as)\b",re.IGNORECASE),
        "FormacaoRecursosHumanosMeioAmbiente" : re.compile(r"\bform(?:ar|ação|açao|acão|acao)\b\s+.*?\brecur(?:so|sos)\b\s+.*?\bhuma(?:no|nos)\b\s+.*?\bmeio ambiente\b",re.IGNORECASE),
        "MonitoramentoAmazoniaAzul" : re.compile(r"\bmonitor(?:ar|amento)\b\s+.*?\bamaz(?:ô|o)nia\b\s+\bazul\b",re.IGNORECASE),
        "GerenciamentoAmazoniaAzul" : re.compile(r"\bgerenciamento\b\s+.*?\bamaz(?:ô|o)nia\b\s+\bazul\b",re.IGNORECASE),
        "TransferenciaTecnologiaAgropecuaria" : re.compile(r"\btransfe(?:rir|rência|rencia)\b\s+.*?\btecnolo(?:gia|gias)\b\s+.*?\bagrope(?:cuária|cuaria|cuárias|cuarias)\b",re.IGNORECASE),
        "DifusaoInformacaoAgroalimentar" : re.compile(r"\bdi(?:fundir|fusão|fusao)\b\s+.*?\binforma(?:ção|ções|çao|çoes|cão|cões|cao|coes)\b\s+.*?\bagro(?:alimentar|alimentares|pecúaria|pecúarias|pecuaria|pecuarias)\b",re.IGNORECASE),
        "DifusaoInformacaoAgropecuaria" : re.compile(r"\bdi(?:fundir|fusão|fusao)\b\s+.*?\binforma(?:ção|ções|çao|çoes|cão|cões|cao|coes)\b\s+.*?\bagro(?:pecuaria|pecuária)",re.IGNORECASE),
        "ImplementacaoProjetosAreasProtegidas" : re.compile(r"\bimplemen(?:tar|tação|taçao|tacão|tacao)\b\s+.*?\bproje(?:tos|to)\b\s+.*?\b(?:á|a)re(?:a|as)\b\s+\bprotegi(?:das|da)\b",re.IGNORECASE),
        "FomentoProjetosAreasProtegidas" : re.compile(r"\bfomen(?:tar|to)\b\s+.*?\bproje(?:to|tos)\b\s+.*?\b(?:á|a)reas\b\s+\bprotegi(?:das|da)\b",re.IGNORECASE),
        "IrrigacaoSocial" : re.compile(r"\birrig(?:ação|açao|acão|acao)\b\s+\bsoci(?:al|ais)\b", re.IGNORECASE),
        "PesquisaAvaliacaoSafra" : re.compile(r"\bpesqui(?:sas|sa|sar)\b\s+.*?\bavalia(?:ção|çao|cão|cao)\b\s+.*?\bsa(?:fra|fras)\b",re.IGNORECASE),
        "AprimoramentoModeloSistemaTerrestre" : re.compile(r"\baprimo(?:rar|ramento|ramentos)\b\s+.*?\bmode(?:los|lo)\b\s+.*?\bsistem(?:a|as)\b\s+.*?\bterres(?:tres|tre)\b",re.IGNORECASE),
        "DesenvolvimentoModeloSistemaTerrestre" : re.compile(r"\bdesenvol(?:ver|vimento|vimentos)\b\s+.*?\bmode(?:los|lo)\b\s+.*?\bsistem(?:a|as)\b\s+.*?\bterres(?:tres|tre)\b",re.IGNORECASE),
        "ApoioPesquisaMar" : re.compile(r"\bapoi(?:ar|o|os)\b\s+.*?\bpesqui(?:sar|sa|sas)\b\s+.*?\bma(?:r|rítima|ritima)\b",re.IGNORECASE),
        "ApoioPesquisaOceano" : re.compile(r"\bapoi(?:ar|o|os)\b\s+.*?\bpesqui(?:sar|sa|sas)\b\s+.*?\boce(?:ânica|anica|ânico|anico|ano|anos)\b",re.IGNORECASE),
        "FiscalizacaoRecursosHidricos" : re.compile(r"\bfiscali(?:zar|zacao|zação|zaçao)\b\s+.*?\brecur(?:sos|so)\b\s+\bh(?:í|i)dric(?:os|o)",re.IGNORECASE),
        "SateliteSerieAmazonia" : re.compile(r"\bsat(?:é|e)li(?:te|tes)\b\s+.*?\bama(?:zô|zo)nia\b",re.IGNORECASE),
        "ApoioAgriculturaIrrigada" : re.compile(r"\bapoi(?:ar|o)\b\s+.*?\bagricul(?:tura|turas)\b\s+.*?\birriga(?:ção|çao|cao|cão|da|das)\b",re.IGNORECASE),
        "PesquisaAquicultura" : re.compile(r"\bpesqui(?:sa|sas|sar)\b\s+.*?\baquicul(?:tura|turas)\b",re.IGNORECASE),
        "PesquisaCientificaAntartica" : re.compile(r"\bpesqui(?:sa|sas|sar)\b\s+.*?\bcien(?:tí|ti)fi(?:ca|cas)\b\s+.*?\bant(?:á|a)rti(?:a|o)\b",re.IGNORECASE),
        "VigilanciaFebreAftosa" : re.compile(r"\bvigi(?:lâ|la)ncia\b\s+.*?\bfebre\b\s+\baftosa\b",re.IGNORECASE),
        "ControleServicoPecuario" : re.compile(r"\bcontro(?:lar|le|les)\b\s+.*?\bservi(?:ço|co|ços|cos)\b\s+\bpecu(?:á|a)ri(?:o|os)\b",re.IGNORECASE),
        "VigilanciaServicoPecuario" : re.compile(r"\bvigi(?:lân|lan)cia\b\s+.*?\bservi(?:ço|co|ços|cos)\b\s+\bpecu(?:á|a)ri(?:o|os)\b",re.IGNORECASE),
        "TransferenciaConcessaoFlorestal" : re.compile(r"\btransf(?:erir|ência|encia)\b\s+.*?\bconce(?:ssão|ssao)\b\s+\bflores(?:tal|tais)\b",re.IGNORECASE),
        "ProducaoInformacaoClimatologica" : re.compile(r"\bprodu(?:zir|ção|çao|cão|cao)\b\s+.*?\binforma(?:ção|çao|cão|cao)\b\s+.*?\bclimato(?:ló|lo)gi(?:ca|cas)\b",re.IGNORECASE),
        "ProducaoInformacaoMeteorologica" : re.compile(r"\bprodu(?:zir|ção|çao|cão|cao)\b\s+.*?\binforma(?:ção|çao|cão|cao)\b\s+.*?\bmeteoro(?:ló|lo)gi(?:ca|cas)\b",re.IGNORECASE),
        "GestaoZonaCosteira" : re.compile(r"\bge(?:rir|stão|stao)\b\s+.*?\bzon(?:na|nas)\b\s+\bcostei(?:ra|ras)\b",re.IGNORECASE),
        "FiscalizacaoAtividadePesqueira" : re.compile(r"\bfiscali(?:zar|zação|zaçao|zacão|zacao)\b\s+.*?\bativida(?:de|des)\b\s+.*?\bpesquei(?:ra|ras)\b",re.IGNORECASE),
        "ControleAtividadePesqueira" : re.compile(r"\bcontrol(?:le|les)\b\s+.*?\bativida(?:de|des)\b\s+.*?\bpesquei(?:ra|ras)\b",re.IGNORECASE),
        "MonitoramentoAtividadePesqueira" : re.compile(r"\bmonito(?:rar|ramento|ramentos)\b\s+.*?\bativida(?:de|des)\b\s+.*?\bpesquei(?:ra|ras)\b",re.IGNORECASE),
        "AdutoraAgreste" : re.compile(r"\baduto(?:ra|ras)\b\s+.*?\bagres(?:te|tes)\b",re.IGNORECASE),
        "AlertaDesastreNatural" : re.compile(r"\baler(?:ta|tas)\b\s+.*?\bdesas(?:tre|tres)\b\s+\bnatu(?:ral|rais)\b",re.IGNORECASE),
        "MonitoramentoDesastreNatural" : re.compile(r"\bmonito(?:rar|ramento|ramentos)\b\s+.*?\bdesas(?:tre|tres)\b\s+\bnatu(?:ral|rais)\b",re.IGNORECASE),
        "AlertaEventoHidrologicoCritico" : re.compile(r"\baler(?:ta|tas)\b\s+.*?\beven(?:to|tos)\b\s+\bhidro(?:ló|lo)gi(?:co|cos)\b\s+\bcr(?:í|i)ti(?:co|cos)\b",re.IGNORECASE),
        "PrevisaoEventoHidrologicoCritico" : re.compile(r"\bprevi(?:sao|soes|são|sões)\b\s+.*?\beven(?:to|tos)\b\s+\bhidro(?:ló|lo)gi(?:co|cos)\b\s+\bcr(?:í|i)ti(?:co|cos)\b",re.IGNORECASE),
        "EstudoEventoHidrologicoCritico" : re.compile(r"\bestu(?:do|dos)\b\s+.*?\beven(?:to|tos)\b\s+\bhidro(?:ló|lo)gi(?:co|cos)\b\s+\bcr(?:í|i)ti(?:co|cos)\b",re.IGNORECASE),
        "FiscalizacaoProdutosOrigemAnimal" : re.compile(r"\bfiscali(?:zar|zaçao|zacao|zação|zacão)\b\s+.*?\bprodu(?:to|tos)\b\s+.*?\borig(?:em|ens)\b\s+\banim(?:al|ais)\b",re.IGNORECASE),
        "InovacaoCampo" : re.compile(r"\bino(?:var|vação|vaçao|vacão|vacao)\b\s+.*?\bcam(?:po|pos)\b",re.IGNORECASE),
        "DefesaSanitariaAnimal" : re.compile(r"\bdefe(?:sa|sas)\b\s+.*?\bsani(?:tá|ta)ri(?:as|a)\b\s+.*?\bani(?:mal|mais)\b",re.IGNORECASE),
        "AbastecimentoAguaSertao" : re.compile(r"\babaste(?:cer|cimento|cimentos)\b\s+.*?\b(?:á|a)gua\b\s+.*?\bser(?:tão|tao|tões|toes)\b",re.IGNORECASE),
        "ProtecaoCultivar" : re.compile(r"\bprote(?:ger|ção|çao|cão|cao)\b\s+.*?\bculti(?:var|vares)\b",re.IGNORECASE),
        "GerenciamentoInsumoAgricola" : re.compile(r"\bgeren(ciar|ciamento|ciamentos)\b\s+.*?\binsu(?:mo|mos)\b\s+.*?\bagr(?:í|i)co(?:la|las)\b",re.IGNORECASE),
        "GerenciamentoDefesaVegetal" : re.compile(r"\bgeren(ciar|ciamento|ciamentos)\b\s+.*?\bdefe(?:sa|nder|sas)\b\s+.*?\bvege(?:tal|tais)\b",re.IGNORECASE),
        "FomentoRecursosGeneticos" : re.compile(r"\bfomen(?:tar|to|tos)\b\s+.*?\brecur(?:so|sos)\b\s+\bgen(?:é|e)ti(?:co|cos)\b",re.IGNORECASE),
        "FomentoTecnologiaAgropecuaria" : re.compile(r"\bfomen(?:tar|to)\b\s+.*?\btecnologi(?:a|as)\b\s+.*?\bagrope(?:cú|cu)ari(?:a|as)",re.IGNORECASE),
        "ZoneamentoAgricolaRiscoClimatico" : re.compile(r"\bzoneamento\b\s+\bagr(?:í|i)col(?:a|as)\b\s+.*?\brisc(?:o|os)\b\s+\bclim(?:á|a)ti(?:co|cos)\b",re.IGNORECASE)
    }
    database["Pega_Palavra"] = [[] for _ in range(len(database))]
    database["Keyword_Catch"] = [[] for _ in range(len(database))]
    for palavra_chave, padrao in keyword_patterns.items():
        def processa_linha(row):
            descricao = row[column_search]
            match = padrao.findall(descricao)
            if match:
                row["Pega_Palavra"] += [palavra_chave]
                row["Keyword_Catch"] += match
            return row

        database = database.apply(processa_linha, axis=1)
    database["Pega_Palavra_str"] = database["Pega_Palavra"].apply(lambda x: " AND ".join(x) if x else "")
    database["Keyword_Catch_str"] = database["Keyword_Catch"].apply(lambda x: " AND ".join(x) if x else "")


    return database

def adaptation_flask_encapsulation(df, coluna, num_partitions=None):
    
    """ 
    Função para aplicar a funcao de pegar palavras de adaptação mas em paralelo usando Dask
    @param df: Dataframe que sera aplicada a funcao de procura por palavras chave de adaptação
    @param coluna: Coluna onde aplicaremos as regras de regex
    @param num_partitions: Numero que indicará quantas partições teremos
    """
    print("\n--- ATENÇÃO ---")
    print(f"numero de nucleos em seu computador é de {dask.system.cpu_count()}")
    print(f'Caso voce não utilize nenhum numero especifico de partições (chunks), utilizaremos {dask.system.cpu_count()*4} partições')
    print("\n--- --- ---")
    if num_partitions is None:
        num_partitions = multiprocessing.cpu_count() * 4
    
    start_time = time.perf_counter()
    print("\n--- Configuração de Processamento Dask ---")
    print(f"Número de partições: {num_partitions}")
    print(f"Número total de linhas: {len(df)}")
    print(f"Número de CPUs disponíveis: {multiprocessing.cpu_count()}")
    df["Pega_Palavra"] = [[] for _ in range(len(df))]
    df["Keyword_Catch"] = [[] for _ in range(len(df))]
    df["Pega_Palavra_str"] = [[] for _ in range(len(df))]
    df["Keyword_Catch_str"] = [[] for _ in range(len(df))]
    dask_df = dd.from_pandas(df, npartitions=num_partitions)
    processed_dask_df = dask_df.map_partitions(
        lambda partition: apply_adaptation_KW(partition, coluna), 
        meta=df
    )
    resultado_final = processed_dask_df.compute()
    stop_time = time.perf_counter()
    print("\n--- --- ---")
    print(f"Tempo de execução: {stop_time - start_time}")
    print("\n--- --- ---")
    return (resultado_final,stop_time - start_time)