# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RemediationRecipeArgs', 'RemediationRecipe']

@pulumi.input_type
class RemediationRecipeArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 detect_configuration: pulumi.Input['RemediationRecipeDetectConfigurationArgs'],
                 is_run_triggered_on_kb_change: pulumi.Input[_builtins.bool],
                 knowledge_base_id: pulumi.Input[_builtins.str],
                 network_configuration: pulumi.Input['RemediationRecipeNetworkConfigurationArgs'],
                 scm_configuration: pulumi.Input['RemediationRecipeScmConfigurationArgs'],
                 verify_configuration: pulumi.Input['RemediationRecipeVerifyConfigurationArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RemediationRecipe resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The compartment Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the remediation recipe.
        :param pulumi.Input['RemediationRecipeDetectConfigurationArgs'] detect_configuration: (Updatable) A configuration to define the constraints when detecting vulnerable dependencies and recommending remediations.
        :param pulumi.Input[_builtins.bool] is_run_triggered_on_kb_change: (Updatable) Boolean indicating if a run should be automatically triggered once the knowledge base is updated.
        :param pulumi.Input[_builtins.str] knowledge_base_id: (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        :param pulumi.Input['RemediationRecipeNetworkConfigurationArgs'] network_configuration: (Updatable) A network configuration defines the required network characteristics for the remediation run of the recipe to access the source repository and/or verify build services.
        :param pulumi.Input['RemediationRecipeScmConfigurationArgs'] scm_configuration: (Updatable) A configuration for the Source Code Management tool/platform used by a remediation recipe.
        :param pulumi.Input['RemediationRecipeVerifyConfigurationArgs'] verify_configuration: (Updatable) The Verify stage configuration specifies a build service to run a pipeline for the recommended code changes. The build pipeline will be initiated to ensure that there is no breaking change after the dependency versions have been updated in source to avoid vulnerabilities.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the remediation recipe.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Remediation Recipe. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "detect_configuration", detect_configuration)
        pulumi.set(__self__, "is_run_triggered_on_kb_change", is_run_triggered_on_kb_change)
        pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        pulumi.set(__self__, "network_configuration", network_configuration)
        pulumi.set(__self__, "scm_configuration", scm_configuration)
        pulumi.set(__self__, "verify_configuration", verify_configuration)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The compartment Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the remediation recipe.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="detectConfiguration")
    def detect_configuration(self) -> pulumi.Input['RemediationRecipeDetectConfigurationArgs']:
        """
        (Updatable) A configuration to define the constraints when detecting vulnerable dependencies and recommending remediations.
        """
        return pulumi.get(self, "detect_configuration")

    @detect_configuration.setter
    def detect_configuration(self, value: pulumi.Input['RemediationRecipeDetectConfigurationArgs']):
        pulumi.set(self, "detect_configuration", value)

    @_builtins.property
    @pulumi.getter(name="isRunTriggeredOnKbChange")
    def is_run_triggered_on_kb_change(self) -> pulumi.Input[_builtins.bool]:
        """
        (Updatable) Boolean indicating if a run should be automatically triggered once the knowledge base is updated.
        """
        return pulumi.get(self, "is_run_triggered_on_kb_change")

    @is_run_triggered_on_kb_change.setter
    def is_run_triggered_on_kb_change(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_run_triggered_on_kb_change", value)

    @_builtins.property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        """
        return pulumi.get(self, "knowledge_base_id")

    @knowledge_base_id.setter
    def knowledge_base_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "knowledge_base_id", value)

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Input['RemediationRecipeNetworkConfigurationArgs']:
        """
        (Updatable) A network configuration defines the required network characteristics for the remediation run of the recipe to access the source repository and/or verify build services.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: pulumi.Input['RemediationRecipeNetworkConfigurationArgs']):
        pulumi.set(self, "network_configuration", value)

    @_builtins.property
    @pulumi.getter(name="scmConfiguration")
    def scm_configuration(self) -> pulumi.Input['RemediationRecipeScmConfigurationArgs']:
        """
        (Updatable) A configuration for the Source Code Management tool/platform used by a remediation recipe.
        """
        return pulumi.get(self, "scm_configuration")

    @scm_configuration.setter
    def scm_configuration(self, value: pulumi.Input['RemediationRecipeScmConfigurationArgs']):
        pulumi.set(self, "scm_configuration", value)

    @_builtins.property
    @pulumi.getter(name="verifyConfiguration")
    def verify_configuration(self) -> pulumi.Input['RemediationRecipeVerifyConfigurationArgs']:
        """
        (Updatable) The Verify stage configuration specifies a build service to run a pipeline for the recommended code changes. The build pipeline will be initiated to ensure that there is no breaking change after the dependency versions have been updated in source to avoid vulnerabilities.
        """
        return pulumi.get(self, "verify_configuration")

    @verify_configuration.setter
    def verify_configuration(self, value: pulumi.Input['RemediationRecipeVerifyConfigurationArgs']):
        pulumi.set(self, "verify_configuration", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the remediation recipe.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The target state for the Remediation Recipe. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _RemediationRecipeState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 detect_configuration: Optional[pulumi.Input['RemediationRecipeDetectConfigurationArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_run_triggered_on_kb_change: Optional[pulumi.Input[_builtins.bool]] = None,
                 knowledge_base_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input['RemediationRecipeNetworkConfigurationArgs']] = None,
                 scm_configuration: Optional[pulumi.Input['RemediationRecipeScmConfigurationArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_configuration: Optional[pulumi.Input['RemediationRecipeVerifyConfigurationArgs']] = None):
        """
        Input properties used for looking up and filtering RemediationRecipe resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The compartment Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the remediation recipe.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input['RemediationRecipeDetectConfigurationArgs'] detect_configuration: (Updatable) A configuration to define the constraints when detecting vulnerable dependencies and recommending remediations.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the remediation recipe.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_run_triggered_on_kb_change: (Updatable) Boolean indicating if a run should be automatically triggered once the knowledge base is updated.
        :param pulumi.Input[_builtins.str] knowledge_base_id: (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        :param pulumi.Input['RemediationRecipeNetworkConfigurationArgs'] network_configuration: (Updatable) A network configuration defines the required network characteristics for the remediation run of the recipe to access the source repository and/or verify build services.
        :param pulumi.Input['RemediationRecipeScmConfigurationArgs'] scm_configuration: (Updatable) A configuration for the Source Code Management tool/platform used by a remediation recipe.
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Remediation Recipe. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The creation date and time of the Remediation Recipe (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[_builtins.str] time_updated: The date and time the Remediation Recipe was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input['RemediationRecipeVerifyConfigurationArgs'] verify_configuration: (Updatable) The Verify stage configuration specifies a build service to run a pipeline for the recommended code changes. The build pipeline will be initiated to ensure that there is no breaking change after the dependency versions have been updated in source to avoid vulnerabilities.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if detect_configuration is not None:
            pulumi.set(__self__, "detect_configuration", detect_configuration)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_run_triggered_on_kb_change is not None:
            pulumi.set(__self__, "is_run_triggered_on_kb_change", is_run_triggered_on_kb_change)
        if knowledge_base_id is not None:
            pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if scm_configuration is not None:
            pulumi.set(__self__, "scm_configuration", scm_configuration)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if verify_configuration is not None:
            pulumi.set(__self__, "verify_configuration", verify_configuration)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The compartment Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the remediation recipe.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="detectConfiguration")
    def detect_configuration(self) -> Optional[pulumi.Input['RemediationRecipeDetectConfigurationArgs']]:
        """
        (Updatable) A configuration to define the constraints when detecting vulnerable dependencies and recommending remediations.
        """
        return pulumi.get(self, "detect_configuration")

    @detect_configuration.setter
    def detect_configuration(self, value: Optional[pulumi.Input['RemediationRecipeDetectConfigurationArgs']]):
        pulumi.set(self, "detect_configuration", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the remediation recipe.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isRunTriggeredOnKbChange")
    def is_run_triggered_on_kb_change(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Boolean indicating if a run should be automatically triggered once the knowledge base is updated.
        """
        return pulumi.get(self, "is_run_triggered_on_kb_change")

    @is_run_triggered_on_kb_change.setter
    def is_run_triggered_on_kb_change(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_run_triggered_on_kb_change", value)

    @_builtins.property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        """
        return pulumi.get(self, "knowledge_base_id")

    @knowledge_base_id.setter
    def knowledge_base_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "knowledge_base_id", value)

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['RemediationRecipeNetworkConfigurationArgs']]:
        """
        (Updatable) A network configuration defines the required network characteristics for the remediation run of the recipe to access the source repository and/or verify build services.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['RemediationRecipeNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @_builtins.property
    @pulumi.getter(name="scmConfiguration")
    def scm_configuration(self) -> Optional[pulumi.Input['RemediationRecipeScmConfigurationArgs']]:
        """
        (Updatable) A configuration for the Source Code Management tool/platform used by a remediation recipe.
        """
        return pulumi.get(self, "scm_configuration")

    @scm_configuration.setter
    def scm_configuration(self, value: Optional[pulumi.Input['RemediationRecipeScmConfigurationArgs']]):
        pulumi.set(self, "scm_configuration", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The target state for the Remediation Recipe. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation date and time of the Remediation Recipe (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the Remediation Recipe was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="verifyConfiguration")
    def verify_configuration(self) -> Optional[pulumi.Input['RemediationRecipeVerifyConfigurationArgs']]:
        """
        (Updatable) The Verify stage configuration specifies a build service to run a pipeline for the recommended code changes. The build pipeline will be initiated to ensure that there is no breaking change after the dependency versions have been updated in source to avoid vulnerabilities.
        """
        return pulumi.get(self, "verify_configuration")

    @verify_configuration.setter
    def verify_configuration(self, value: Optional[pulumi.Input['RemediationRecipeVerifyConfigurationArgs']]):
        pulumi.set(self, "verify_configuration", value)


@pulumi.type_token("oci:Adm/remediationRecipe:RemediationRecipe")
class RemediationRecipe(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 detect_configuration: Optional[pulumi.Input[Union['RemediationRecipeDetectConfigurationArgs', 'RemediationRecipeDetectConfigurationArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_run_triggered_on_kb_change: Optional[pulumi.Input[_builtins.bool]] = None,
                 knowledge_base_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input[Union['RemediationRecipeNetworkConfigurationArgs', 'RemediationRecipeNetworkConfigurationArgsDict']]] = None,
                 scm_configuration: Optional[pulumi.Input[Union['RemediationRecipeScmConfigurationArgs', 'RemediationRecipeScmConfigurationArgsDict']]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_configuration: Optional[pulumi.Input[Union['RemediationRecipeVerifyConfigurationArgs', 'RemediationRecipeVerifyConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Remediation Recipe resource in Oracle Cloud Infrastructure Adm service.

        Creates a new Remediation Recipe.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_remediation_recipe = oci.adm.RemediationRecipe("test_remediation_recipe",
            compartment_id=compartment_id,
            detect_configuration={
                "exclusions": remediation_recipe_detect_configuration_exclusions,
                "max_permissible_cvss_v2score": remediation_recipe_detect_configuration_max_permissible_cvss_v2score,
                "max_permissible_cvss_v3score": remediation_recipe_detect_configuration_max_permissible_cvss_v3score,
                "max_permissible_severity": remediation_recipe_detect_configuration_max_permissible_severity,
                "upgrade_policy": remediation_recipe_detect_configuration_upgrade_policy,
            },
            is_run_triggered_on_kb_change=remediation_recipe_is_run_triggered_on_kb_change,
            knowledge_base_id=test_knowledge_base["id"],
            network_configuration={
                "subnet_id": test_subnet["id"],
                "nsg_ids": remediation_recipe_network_configuration_nsg_ids,
            },
            scm_configuration={
                "branch": remediation_recipe_scm_configuration_branch,
                "is_automerge_enabled": remediation_recipe_scm_configuration_is_automerge_enabled,
                "scm_type": remediation_recipe_scm_configuration_scm_type,
                "build_file_location": remediation_recipe_scm_configuration_build_file_location,
                "external_scm_type": remediation_recipe_scm_configuration_external_scm_type,
                "oci_code_repository_id": test_repository["id"],
                "pat_secret_id": test_secret["id"],
                "repository_url": remediation_recipe_scm_configuration_repository_url,
                "username": remediation_recipe_scm_configuration_username,
            },
            verify_configuration={
                "build_service_type": remediation_recipe_verify_configuration_build_service_type,
                "additional_parameters": remediation_recipe_verify_configuration_additional_parameters,
                "jenkins_url": remediation_recipe_verify_configuration_jenkins_url,
                "job_name": test_job["name"],
                "pat_secret_id": test_secret["id"],
                "pipeline_id": test_pipeline["id"],
                "repository_url": remediation_recipe_verify_configuration_repository_url,
                "trigger_secret_id": test_secret["id"],
                "username": remediation_recipe_verify_configuration_username,
                "workflow_name": remediation_recipe_verify_configuration_workflow_name,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=remediation_recipe_display_name,
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        RemediationRecipes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Adm/remediationRecipe:RemediationRecipe test_remediation_recipe "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The compartment Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the remediation recipe.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Union['RemediationRecipeDetectConfigurationArgs', 'RemediationRecipeDetectConfigurationArgsDict']] detect_configuration: (Updatable) A configuration to define the constraints when detecting vulnerable dependencies and recommending remediations.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the remediation recipe.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_run_triggered_on_kb_change: (Updatable) Boolean indicating if a run should be automatically triggered once the knowledge base is updated.
        :param pulumi.Input[_builtins.str] knowledge_base_id: (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        :param pulumi.Input[Union['RemediationRecipeNetworkConfigurationArgs', 'RemediationRecipeNetworkConfigurationArgsDict']] network_configuration: (Updatable) A network configuration defines the required network characteristics for the remediation run of the recipe to access the source repository and/or verify build services.
        :param pulumi.Input[Union['RemediationRecipeScmConfigurationArgs', 'RemediationRecipeScmConfigurationArgsDict']] scm_configuration: (Updatable) A configuration for the Source Code Management tool/platform used by a remediation recipe.
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Remediation Recipe. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Union['RemediationRecipeVerifyConfigurationArgs', 'RemediationRecipeVerifyConfigurationArgsDict']] verify_configuration: (Updatable) The Verify stage configuration specifies a build service to run a pipeline for the recommended code changes. The build pipeline will be initiated to ensure that there is no breaking change after the dependency versions have been updated in source to avoid vulnerabilities.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RemediationRecipeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Remediation Recipe resource in Oracle Cloud Infrastructure Adm service.

        Creates a new Remediation Recipe.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_remediation_recipe = oci.adm.RemediationRecipe("test_remediation_recipe",
            compartment_id=compartment_id,
            detect_configuration={
                "exclusions": remediation_recipe_detect_configuration_exclusions,
                "max_permissible_cvss_v2score": remediation_recipe_detect_configuration_max_permissible_cvss_v2score,
                "max_permissible_cvss_v3score": remediation_recipe_detect_configuration_max_permissible_cvss_v3score,
                "max_permissible_severity": remediation_recipe_detect_configuration_max_permissible_severity,
                "upgrade_policy": remediation_recipe_detect_configuration_upgrade_policy,
            },
            is_run_triggered_on_kb_change=remediation_recipe_is_run_triggered_on_kb_change,
            knowledge_base_id=test_knowledge_base["id"],
            network_configuration={
                "subnet_id": test_subnet["id"],
                "nsg_ids": remediation_recipe_network_configuration_nsg_ids,
            },
            scm_configuration={
                "branch": remediation_recipe_scm_configuration_branch,
                "is_automerge_enabled": remediation_recipe_scm_configuration_is_automerge_enabled,
                "scm_type": remediation_recipe_scm_configuration_scm_type,
                "build_file_location": remediation_recipe_scm_configuration_build_file_location,
                "external_scm_type": remediation_recipe_scm_configuration_external_scm_type,
                "oci_code_repository_id": test_repository["id"],
                "pat_secret_id": test_secret["id"],
                "repository_url": remediation_recipe_scm_configuration_repository_url,
                "username": remediation_recipe_scm_configuration_username,
            },
            verify_configuration={
                "build_service_type": remediation_recipe_verify_configuration_build_service_type,
                "additional_parameters": remediation_recipe_verify_configuration_additional_parameters,
                "jenkins_url": remediation_recipe_verify_configuration_jenkins_url,
                "job_name": test_job["name"],
                "pat_secret_id": test_secret["id"],
                "pipeline_id": test_pipeline["id"],
                "repository_url": remediation_recipe_verify_configuration_repository_url,
                "trigger_secret_id": test_secret["id"],
                "username": remediation_recipe_verify_configuration_username,
                "workflow_name": remediation_recipe_verify_configuration_workflow_name,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=remediation_recipe_display_name,
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        RemediationRecipes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Adm/remediationRecipe:RemediationRecipe test_remediation_recipe "id"
        ```

        :param str resource_name: The name of the resource.
        :param RemediationRecipeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RemediationRecipeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 detect_configuration: Optional[pulumi.Input[Union['RemediationRecipeDetectConfigurationArgs', 'RemediationRecipeDetectConfigurationArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_run_triggered_on_kb_change: Optional[pulumi.Input[_builtins.bool]] = None,
                 knowledge_base_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input[Union['RemediationRecipeNetworkConfigurationArgs', 'RemediationRecipeNetworkConfigurationArgsDict']]] = None,
                 scm_configuration: Optional[pulumi.Input[Union['RemediationRecipeScmConfigurationArgs', 'RemediationRecipeScmConfigurationArgsDict']]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 verify_configuration: Optional[pulumi.Input[Union['RemediationRecipeVerifyConfigurationArgs', 'RemediationRecipeVerifyConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RemediationRecipeArgs.__new__(RemediationRecipeArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if detect_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'detect_configuration'")
            __props__.__dict__["detect_configuration"] = detect_configuration
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if is_run_triggered_on_kb_change is None and not opts.urn:
                raise TypeError("Missing required property 'is_run_triggered_on_kb_change'")
            __props__.__dict__["is_run_triggered_on_kb_change"] = is_run_triggered_on_kb_change
            if knowledge_base_id is None and not opts.urn:
                raise TypeError("Missing required property 'knowledge_base_id'")
            __props__.__dict__["knowledge_base_id"] = knowledge_base_id
            if network_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'network_configuration'")
            __props__.__dict__["network_configuration"] = network_configuration
            if scm_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'scm_configuration'")
            __props__.__dict__["scm_configuration"] = scm_configuration
            __props__.__dict__["state"] = state
            if verify_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'verify_configuration'")
            __props__.__dict__["verify_configuration"] = verify_configuration
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(RemediationRecipe, __self__).__init__(
            'oci:Adm/remediationRecipe:RemediationRecipe',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            detect_configuration: Optional[pulumi.Input[Union['RemediationRecipeDetectConfigurationArgs', 'RemediationRecipeDetectConfigurationArgsDict']]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_run_triggered_on_kb_change: Optional[pulumi.Input[_builtins.bool]] = None,
            knowledge_base_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_configuration: Optional[pulumi.Input[Union['RemediationRecipeNetworkConfigurationArgs', 'RemediationRecipeNetworkConfigurationArgsDict']]] = None,
            scm_configuration: Optional[pulumi.Input[Union['RemediationRecipeScmConfigurationArgs', 'RemediationRecipeScmConfigurationArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            verify_configuration: Optional[pulumi.Input[Union['RemediationRecipeVerifyConfigurationArgs', 'RemediationRecipeVerifyConfigurationArgsDict']]] = None) -> 'RemediationRecipe':
        """
        Get an existing RemediationRecipe resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The compartment Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the remediation recipe.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Union['RemediationRecipeDetectConfigurationArgs', 'RemediationRecipeDetectConfigurationArgsDict']] detect_configuration: (Updatable) A configuration to define the constraints when detecting vulnerable dependencies and recommending remediations.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the remediation recipe.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.bool] is_run_triggered_on_kb_change: (Updatable) Boolean indicating if a run should be automatically triggered once the knowledge base is updated.
        :param pulumi.Input[_builtins.str] knowledge_base_id: (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        :param pulumi.Input[Union['RemediationRecipeNetworkConfigurationArgs', 'RemediationRecipeNetworkConfigurationArgsDict']] network_configuration: (Updatable) A network configuration defines the required network characteristics for the remediation run of the recipe to access the source repository and/or verify build services.
        :param pulumi.Input[Union['RemediationRecipeScmConfigurationArgs', 'RemediationRecipeScmConfigurationArgsDict']] scm_configuration: (Updatable) A configuration for the Source Code Management tool/platform used by a remediation recipe.
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Remediation Recipe. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The creation date and time of the Remediation Recipe (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[_builtins.str] time_updated: The date and time the Remediation Recipe was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[Union['RemediationRecipeVerifyConfigurationArgs', 'RemediationRecipeVerifyConfigurationArgsDict']] verify_configuration: (Updatable) The Verify stage configuration specifies a build service to run a pipeline for the recommended code changes. The build pipeline will be initiated to ensure that there is no breaking change after the dependency versions have been updated in source to avoid vulnerabilities.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RemediationRecipeState.__new__(_RemediationRecipeState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["detect_configuration"] = detect_configuration
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_run_triggered_on_kb_change"] = is_run_triggered_on_kb_change
        __props__.__dict__["knowledge_base_id"] = knowledge_base_id
        __props__.__dict__["network_configuration"] = network_configuration
        __props__.__dict__["scm_configuration"] = scm_configuration
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["verify_configuration"] = verify_configuration
        return RemediationRecipe(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The compartment Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the remediation recipe.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="detectConfiguration")
    def detect_configuration(self) -> pulumi.Output['outputs.RemediationRecipeDetectConfiguration']:
        """
        (Updatable) A configuration to define the constraints when detecting vulnerable dependencies and recommending remediations.
        """
        return pulumi.get(self, "detect_configuration")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The name of the remediation recipe.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isRunTriggeredOnKbChange")
    def is_run_triggered_on_kb_change(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Boolean indicating if a run should be automatically triggered once the knowledge base is updated.
        """
        return pulumi.get(self, "is_run_triggered_on_kb_change")

    @_builtins.property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        """
        return pulumi.get(self, "knowledge_base_id")

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output['outputs.RemediationRecipeNetworkConfiguration']:
        """
        (Updatable) A network configuration defines the required network characteristics for the remediation run of the recipe to access the source repository and/or verify build services.
        """
        return pulumi.get(self, "network_configuration")

    @_builtins.property
    @pulumi.getter(name="scmConfiguration")
    def scm_configuration(self) -> pulumi.Output['outputs.RemediationRecipeScmConfiguration']:
        """
        (Updatable) A configuration for the Source Code Management tool/platform used by a remediation recipe.
        """
        return pulumi.get(self, "scm_configuration")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The target state for the Remediation Recipe. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The creation date and time of the Remediation Recipe (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the Remediation Recipe was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="verifyConfiguration")
    def verify_configuration(self) -> pulumi.Output['outputs.RemediationRecipeVerifyConfiguration']:
        """
        (Updatable) The Verify stage configuration specifies a build service to run a pipeline for the recommended code changes. The build pipeline will be initiated to ensure that there is no breaking change after the dependency versions have been updated in source to avoid vulnerabilities.
        """
        return pulumi.get(self, "verify_configuration")

