# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AgentPluginList',
    'AssetCompute',
    'AssetComputeDisk',
    'AssetComputeGpuDevice',
    'AssetComputeNic',
    'AssetComputeNvdimm',
    'AssetComputeNvdimmController',
    'AssetComputeScsiController',
    'AssetSourceDiscoveryCredentials',
    'AssetSourceReplicationCredentials',
    'AssetVm',
    'AssetVmwareVcenter',
    'AssetVmwareVm',
    'AssetVmwareVmCustomerTag',
    'GetAgentDependenciesAgentDependencyCollectionResult',
    'GetAgentDependenciesAgentDependencyCollectionItemResult',
    'GetAgentDependenciesFilterResult',
    'GetAgentPluginListResult',
    'GetAgentsAgentCollectionResult',
    'GetAgentsAgentCollectionItemResult',
    'GetAgentsAgentCollectionItemPluginListResult',
    'GetAgentsFilterResult',
    'GetApplianceImageItemResult',
    'GetApplianceImagesApplianceImageCollectionResult',
    'GetApplianceImagesApplianceImageCollectionItemResult',
    'GetApplianceImagesFilterResult',
    'GetAssetComputeResult',
    'GetAssetComputeDiskResult',
    'GetAssetComputeGpuDeviceResult',
    'GetAssetComputeNicResult',
    'GetAssetComputeNvdimmResult',
    'GetAssetComputeNvdimmControllerResult',
    'GetAssetComputeScsiControllerResult',
    'GetAssetSourceDiscoveryCredentialResult',
    'GetAssetSourceReplicationCredentialResult',
    'GetAssetSourcesAssetSourceCollectionResult',
    'GetAssetSourcesAssetSourceCollectionItemResult',
    'GetAssetSourcesAssetSourceCollectionItemDiscoveryCredentialResult',
    'GetAssetSourcesAssetSourceCollectionItemReplicationCredentialResult',
    'GetAssetSourcesFilterResult',
    'GetAssetVmResult',
    'GetAssetVmwareVcenterResult',
    'GetAssetVmwareVmResult',
    'GetAssetVmwareVmCustomerTagResult',
    'GetAssetsAssetCollectionResult',
    'GetAssetsAssetCollectionItemResult',
    'GetAssetsAssetCollectionItemComputeResult',
    'GetAssetsAssetCollectionItemComputeDiskResult',
    'GetAssetsAssetCollectionItemComputeGpuDeviceResult',
    'GetAssetsAssetCollectionItemComputeNicResult',
    'GetAssetsAssetCollectionItemComputeNvdimmResult',
    'GetAssetsAssetCollectionItemComputeNvdimmControllerResult',
    'GetAssetsAssetCollectionItemComputeScsiControllerResult',
    'GetAssetsAssetCollectionItemVmResult',
    'GetAssetsAssetCollectionItemVmwareVcenterResult',
    'GetAssetsAssetCollectionItemVmwareVmResult',
    'GetAssetsAssetCollectionItemVmwareVmCustomerTagResult',
    'GetAssetsFilterResult',
    'GetDiscoverySchedulesDiscoveryScheduleCollectionResult',
    'GetDiscoverySchedulesDiscoveryScheduleCollectionItemResult',
    'GetDiscoverySchedulesFilterResult',
    'GetEnvironmentsEnvironmentCollectionResult',
    'GetEnvironmentsEnvironmentCollectionItemResult',
    'GetEnvironmentsFilterResult',
    'GetInventoriesFilterResult',
    'GetInventoriesInventoryCollectionResult',
    'GetInventoriesInventoryCollectionItemResult',
]

@pulumi.output_type
class AgentPluginList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentId":
            suggest = "agent_id"
        elif key == "definedTags":
            suggest = "defined_tags"
        elif key == "freeformTags":
            suggest = "freeform_tags"
        elif key == "lifecycleDetails":
            suggest = "lifecycle_details"
        elif key == "pluginVersion":
            suggest = "plugin_version"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeUpdated":
            suggest = "time_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentPluginList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentPluginList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentPluginList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_id: Optional[_builtins.str] = None,
                 defined_tags: Optional[Mapping[str, _builtins.str]] = None,
                 freeform_tags: Optional[Mapping[str, _builtins.str]] = None,
                 lifecycle_details: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 plugin_version: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None,
                 time_updated: Optional[_builtins.str] = None):
        """
        :param _builtins.str agent_id: Agent identifier.
        :param Mapping[str, _builtins.str] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, _builtins.str] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param _builtins.str name: Plugin identifier, which can be renamed.
        :param _builtins.str plugin_version: Plugin version.
        :param _builtins.str state: The current state of the Agent.
        :param _builtins.str time_created: The time when the Agent was created. An RFC3339 formatted datetime string.
        :param _builtins.str time_updated: The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plugin_version is not None:
            pulumi.set(__self__, "plugin_version", plugin_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[_builtins.str]:
        """
        Agent identifier.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[_builtins.str]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Plugin identifier, which can be renamed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> Optional[_builtins.str]:
        """
        Plugin version.
        """
        return pulumi.get(self, "plugin_version")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Agent.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        The time when the Agent was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[_builtins.str]:
        """
        The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class AssetCompute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectedNetworks":
            suggest = "connected_networks"
        elif key == "coresCount":
            suggest = "cores_count"
        elif key == "cpuModel":
            suggest = "cpu_model"
        elif key == "disksCount":
            suggest = "disks_count"
        elif key == "dnsName":
            suggest = "dns_name"
        elif key == "gpuDevices":
            suggest = "gpu_devices"
        elif key == "gpuDevicesCount":
            suggest = "gpu_devices_count"
        elif key == "guestState":
            suggest = "guest_state"
        elif key == "hardwareVersion":
            suggest = "hardware_version"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "isPmemEnabled":
            suggest = "is_pmem_enabled"
        elif key == "isTpmEnabled":
            suggest = "is_tpm_enabled"
        elif key == "latencySensitivity":
            suggest = "latency_sensitivity"
        elif key == "memoryInMbs":
            suggest = "memory_in_mbs"
        elif key == "nicsCount":
            suggest = "nics_count"
        elif key == "nvdimmController":
            suggest = "nvdimm_controller"
        elif key == "operatingSystem":
            suggest = "operating_system"
        elif key == "operatingSystemVersion":
            suggest = "operating_system_version"
        elif key == "pmemInMbs":
            suggest = "pmem_in_mbs"
        elif key == "powerState":
            suggest = "power_state"
        elif key == "primaryIp":
            suggest = "primary_ip"
        elif key == "scsiController":
            suggest = "scsi_controller"
        elif key == "storageProvisionedInMbs":
            suggest = "storage_provisioned_in_mbs"
        elif key == "threadsPerCoreCount":
            suggest = "threads_per_core_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetCompute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetCompute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetCompute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connected_networks: Optional[_builtins.int] = None,
                 cores_count: Optional[_builtins.int] = None,
                 cpu_model: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None,
                 disks: Optional[Sequence['outputs.AssetComputeDisk']] = None,
                 disks_count: Optional[_builtins.int] = None,
                 dns_name: Optional[_builtins.str] = None,
                 firmware: Optional[_builtins.str] = None,
                 gpu_devices: Optional[Sequence['outputs.AssetComputeGpuDevice']] = None,
                 gpu_devices_count: Optional[_builtins.int] = None,
                 guest_state: Optional[_builtins.str] = None,
                 hardware_version: Optional[_builtins.str] = None,
                 host_name: Optional[_builtins.str] = None,
                 is_pmem_enabled: Optional[_builtins.bool] = None,
                 is_tpm_enabled: Optional[_builtins.bool] = None,
                 latency_sensitivity: Optional[_builtins.str] = None,
                 memory_in_mbs: Optional[_builtins.str] = None,
                 nics: Optional[Sequence['outputs.AssetComputeNic']] = None,
                 nics_count: Optional[_builtins.int] = None,
                 nvdimm_controller: Optional['outputs.AssetComputeNvdimmController'] = None,
                 nvdimms: Optional[Sequence['outputs.AssetComputeNvdimm']] = None,
                 operating_system: Optional[_builtins.str] = None,
                 operating_system_version: Optional[_builtins.str] = None,
                 pmem_in_mbs: Optional[_builtins.str] = None,
                 power_state: Optional[_builtins.str] = None,
                 primary_ip: Optional[_builtins.str] = None,
                 scsi_controller: Optional['outputs.AssetComputeScsiController'] = None,
                 storage_provisioned_in_mbs: Optional[_builtins.str] = None,
                 threads_per_core_count: Optional[_builtins.int] = None):
        """
        :param _builtins.int connected_networks: (Updatable) Number of connected networks.
        :param _builtins.int cores_count: (Updatable) Number of CPUs.
        :param _builtins.str cpu_model: (Updatable) CPU model name.
        :param _builtins.str description: (Updatable) Information about the asset.
        :param Sequence['AssetComputeDiskArgs'] disks: (Updatable) Lists the set of disks belonging to the virtual machine. This list is unordered.
        :param _builtins.int disks_count: (Updatable) Number of disks.
        :param _builtins.str dns_name: (Updatable) Fully Qualified DNS Name.
        :param _builtins.str firmware: (Updatable) Information about firmware type for this virtual machine.
        :param Sequence['AssetComputeGpuDeviceArgs'] gpu_devices: (Updatable) List of GPU devices attached to a virtual machine.
        :param _builtins.int gpu_devices_count: (Updatable) Number of GPU devices.
        :param _builtins.str guest_state: (Updatable) Guest state.
        :param _builtins.str hardware_version: (Updatable) Hardware version.
        :param _builtins.str host_name: (Updatable) Host name of the VM.
        :param _builtins.bool is_pmem_enabled: (Updatable) Whether Pmem is enabled. Decides if NVDIMMs are used as a permanent memory.
        :param _builtins.bool is_tpm_enabled: (Updatable) Whether Trusted Platform Module (TPM) is enabled.
        :param _builtins.str latency_sensitivity: (Updatable) Latency sensitivity.
        :param _builtins.str memory_in_mbs: (Updatable) Memory size in MBs.
        :param Sequence['AssetComputeNicArgs'] nics: (Updatable) List of network ethernet cards attached to a virtual machine.
        :param _builtins.int nics_count: (Updatable) Number of network ethernet cards.
        :param 'AssetComputeNvdimmControllerArgs' nvdimm_controller: (Updatable) The asset's NVDIMM configuration.
        :param Sequence['AssetComputeNvdimmArgs'] nvdimms: (Updatable) The properties of the NVDIMMs attached to a virtual machine.
        :param _builtins.str operating_system: (Updatable) Operating system.
        :param _builtins.str operating_system_version: (Updatable) Operating system version.
        :param _builtins.str pmem_in_mbs: (Updatable) Pmem size in MBs.
        :param _builtins.str power_state: (Updatable) The current power state of the virtual machine.
        :param _builtins.str primary_ip: (Updatable) Primary IP address of the compute instance.
        :param 'AssetComputeScsiControllerArgs' scsi_controller: (Updatable) The assets SCSI controller.
        :param _builtins.str storage_provisioned_in_mbs: (Updatable) Provision storage size in MBs.
        :param _builtins.int threads_per_core_count: (Updatable) Number of threads per core.
        """
        if connected_networks is not None:
            pulumi.set(__self__, "connected_networks", connected_networks)
        if cores_count is not None:
            pulumi.set(__self__, "cores_count", cores_count)
        if cpu_model is not None:
            pulumi.set(__self__, "cpu_model", cpu_model)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if disks_count is not None:
            pulumi.set(__self__, "disks_count", disks_count)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if firmware is not None:
            pulumi.set(__self__, "firmware", firmware)
        if gpu_devices is not None:
            pulumi.set(__self__, "gpu_devices", gpu_devices)
        if gpu_devices_count is not None:
            pulumi.set(__self__, "gpu_devices_count", gpu_devices_count)
        if guest_state is not None:
            pulumi.set(__self__, "guest_state", guest_state)
        if hardware_version is not None:
            pulumi.set(__self__, "hardware_version", hardware_version)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if is_pmem_enabled is not None:
            pulumi.set(__self__, "is_pmem_enabled", is_pmem_enabled)
        if is_tpm_enabled is not None:
            pulumi.set(__self__, "is_tpm_enabled", is_tpm_enabled)
        if latency_sensitivity is not None:
            pulumi.set(__self__, "latency_sensitivity", latency_sensitivity)
        if memory_in_mbs is not None:
            pulumi.set(__self__, "memory_in_mbs", memory_in_mbs)
        if nics is not None:
            pulumi.set(__self__, "nics", nics)
        if nics_count is not None:
            pulumi.set(__self__, "nics_count", nics_count)
        if nvdimm_controller is not None:
            pulumi.set(__self__, "nvdimm_controller", nvdimm_controller)
        if nvdimms is not None:
            pulumi.set(__self__, "nvdimms", nvdimms)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if operating_system_version is not None:
            pulumi.set(__self__, "operating_system_version", operating_system_version)
        if pmem_in_mbs is not None:
            pulumi.set(__self__, "pmem_in_mbs", pmem_in_mbs)
        if power_state is not None:
            pulumi.set(__self__, "power_state", power_state)
        if primary_ip is not None:
            pulumi.set(__self__, "primary_ip", primary_ip)
        if scsi_controller is not None:
            pulumi.set(__self__, "scsi_controller", scsi_controller)
        if storage_provisioned_in_mbs is not None:
            pulumi.set(__self__, "storage_provisioned_in_mbs", storage_provisioned_in_mbs)
        if threads_per_core_count is not None:
            pulumi.set(__self__, "threads_per_core_count", threads_per_core_count)

    @_builtins.property
    @pulumi.getter(name="connectedNetworks")
    def connected_networks(self) -> Optional[_builtins.int]:
        """
        (Updatable) Number of connected networks.
        """
        return pulumi.get(self, "connected_networks")

    @_builtins.property
    @pulumi.getter(name="coresCount")
    def cores_count(self) -> Optional[_builtins.int]:
        """
        (Updatable) Number of CPUs.
        """
        return pulumi.get(self, "cores_count")

    @_builtins.property
    @pulumi.getter(name="cpuModel")
    def cpu_model(self) -> Optional[_builtins.str]:
        """
        (Updatable) CPU model name.
        """
        return pulumi.get(self, "cpu_model")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        (Updatable) Information about the asset.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[Sequence['outputs.AssetComputeDisk']]:
        """
        (Updatable) Lists the set of disks belonging to the virtual machine. This list is unordered.
        """
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter(name="disksCount")
    def disks_count(self) -> Optional[_builtins.int]:
        """
        (Updatable) Number of disks.
        """
        return pulumi.get(self, "disks_count")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) Fully Qualified DNS Name.
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter
    def firmware(self) -> Optional[_builtins.str]:
        """
        (Updatable) Information about firmware type for this virtual machine.
        """
        return pulumi.get(self, "firmware")

    @_builtins.property
    @pulumi.getter(name="gpuDevices")
    def gpu_devices(self) -> Optional[Sequence['outputs.AssetComputeGpuDevice']]:
        """
        (Updatable) List of GPU devices attached to a virtual machine.
        """
        return pulumi.get(self, "gpu_devices")

    @_builtins.property
    @pulumi.getter(name="gpuDevicesCount")
    def gpu_devices_count(self) -> Optional[_builtins.int]:
        """
        (Updatable) Number of GPU devices.
        """
        return pulumi.get(self, "gpu_devices_count")

    @_builtins.property
    @pulumi.getter(name="guestState")
    def guest_state(self) -> Optional[_builtins.str]:
        """
        (Updatable) Guest state.
        """
        return pulumi.get(self, "guest_state")

    @_builtins.property
    @pulumi.getter(name="hardwareVersion")
    def hardware_version(self) -> Optional[_builtins.str]:
        """
        (Updatable) Hardware version.
        """
        return pulumi.get(self, "hardware_version")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) Host name of the VM.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="isPmemEnabled")
    def is_pmem_enabled(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether Pmem is enabled. Decides if NVDIMMs are used as a permanent memory.
        """
        return pulumi.get(self, "is_pmem_enabled")

    @_builtins.property
    @pulumi.getter(name="isTpmEnabled")
    def is_tpm_enabled(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether Trusted Platform Module (TPM) is enabled.
        """
        return pulumi.get(self, "is_tpm_enabled")

    @_builtins.property
    @pulumi.getter(name="latencySensitivity")
    def latency_sensitivity(self) -> Optional[_builtins.str]:
        """
        (Updatable) Latency sensitivity.
        """
        return pulumi.get(self, "latency_sensitivity")

    @_builtins.property
    @pulumi.getter(name="memoryInMbs")
    def memory_in_mbs(self) -> Optional[_builtins.str]:
        """
        (Updatable) Memory size in MBs.
        """
        return pulumi.get(self, "memory_in_mbs")

    @_builtins.property
    @pulumi.getter
    def nics(self) -> Optional[Sequence['outputs.AssetComputeNic']]:
        """
        (Updatable) List of network ethernet cards attached to a virtual machine.
        """
        return pulumi.get(self, "nics")

    @_builtins.property
    @pulumi.getter(name="nicsCount")
    def nics_count(self) -> Optional[_builtins.int]:
        """
        (Updatable) Number of network ethernet cards.
        """
        return pulumi.get(self, "nics_count")

    @_builtins.property
    @pulumi.getter(name="nvdimmController")
    def nvdimm_controller(self) -> Optional['outputs.AssetComputeNvdimmController']:
        """
        (Updatable) The asset's NVDIMM configuration.
        """
        return pulumi.get(self, "nvdimm_controller")

    @_builtins.property
    @pulumi.getter
    def nvdimms(self) -> Optional[Sequence['outputs.AssetComputeNvdimm']]:
        """
        (Updatable) The properties of the NVDIMMs attached to a virtual machine.
        """
        return pulumi.get(self, "nvdimms")

    @_builtins.property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[_builtins.str]:
        """
        (Updatable) Operating system.
        """
        return pulumi.get(self, "operating_system")

    @_builtins.property
    @pulumi.getter(name="operatingSystemVersion")
    def operating_system_version(self) -> Optional[_builtins.str]:
        """
        (Updatable) Operating system version.
        """
        return pulumi.get(self, "operating_system_version")

    @_builtins.property
    @pulumi.getter(name="pmemInMbs")
    def pmem_in_mbs(self) -> Optional[_builtins.str]:
        """
        (Updatable) Pmem size in MBs.
        """
        return pulumi.get(self, "pmem_in_mbs")

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> Optional[_builtins.str]:
        """
        (Updatable) The current power state of the virtual machine.
        """
        return pulumi.get(self, "power_state")

    @_builtins.property
    @pulumi.getter(name="primaryIp")
    def primary_ip(self) -> Optional[_builtins.str]:
        """
        (Updatable) Primary IP address of the compute instance.
        """
        return pulumi.get(self, "primary_ip")

    @_builtins.property
    @pulumi.getter(name="scsiController")
    def scsi_controller(self) -> Optional['outputs.AssetComputeScsiController']:
        """
        (Updatable) The assets SCSI controller.
        """
        return pulumi.get(self, "scsi_controller")

    @_builtins.property
    @pulumi.getter(name="storageProvisionedInMbs")
    def storage_provisioned_in_mbs(self) -> Optional[_builtins.str]:
        """
        (Updatable) Provision storage size in MBs.
        """
        return pulumi.get(self, "storage_provisioned_in_mbs")

    @_builtins.property
    @pulumi.getter(name="threadsPerCoreCount")
    def threads_per_core_count(self) -> Optional[_builtins.int]:
        """
        (Updatable) Number of threads per core.
        """
        return pulumi.get(self, "threads_per_core_count")


@pulumi.output_type
class AssetComputeDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootOrder":
            suggest = "boot_order"
        elif key == "persistentMode":
            suggest = "persistent_mode"
        elif key == "sizeInMbs":
            suggest = "size_in_mbs"
        elif key == "uuidLun":
            suggest = "uuid_lun"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetComputeDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetComputeDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetComputeDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_order: Optional[_builtins.int] = None,
                 location: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 persistent_mode: Optional[_builtins.str] = None,
                 size_in_mbs: Optional[_builtins.str] = None,
                 uuid: Optional[_builtins.str] = None,
                 uuid_lun: Optional[_builtins.str] = None):
        """
        :param _builtins.int boot_order: (Updatable) Order of boot volumes.
        :param _builtins.str location: (Updatable) Location of the boot/data volume.
        :param _builtins.str name: (Updatable) Disk name.
        :param _builtins.str persistent_mode: (Updatable) The disk persistent mode.
        :param _builtins.str size_in_mbs: (Updatable) The size of the volume in MBs.
        :param _builtins.str uuid: (Updatable) Disk UUID for the virtual disk, if available.
        :param _builtins.str uuid_lun: (Updatable) Disk UUID LUN for the virtual disk, if available.
        """
        if boot_order is not None:
            pulumi.set(__self__, "boot_order", boot_order)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if persistent_mode is not None:
            pulumi.set(__self__, "persistent_mode", persistent_mode)
        if size_in_mbs is not None:
            pulumi.set(__self__, "size_in_mbs", size_in_mbs)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if uuid_lun is not None:
            pulumi.set(__self__, "uuid_lun", uuid_lun)

    @_builtins.property
    @pulumi.getter(name="bootOrder")
    def boot_order(self) -> Optional[_builtins.int]:
        """
        (Updatable) Order of boot volumes.
        """
        return pulumi.get(self, "boot_order")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        (Updatable) Location of the boot/data volume.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        (Updatable) Disk name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="persistentMode")
    def persistent_mode(self) -> Optional[_builtins.str]:
        """
        (Updatable) The disk persistent mode.
        """
        return pulumi.get(self, "persistent_mode")

    @_builtins.property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> Optional[_builtins.str]:
        """
        (Updatable) The size of the volume in MBs.
        """
        return pulumi.get(self, "size_in_mbs")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[_builtins.str]:
        """
        (Updatable) Disk UUID for the virtual disk, if available.
        """
        return pulumi.get(self, "uuid")

    @_builtins.property
    @pulumi.getter(name="uuidLun")
    def uuid_lun(self) -> Optional[_builtins.str]:
        """
        (Updatable) Disk UUID LUN for the virtual disk, if available.
        """
        return pulumi.get(self, "uuid_lun")


@pulumi.output_type
class AssetComputeGpuDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coresCount":
            suggest = "cores_count"
        elif key == "memoryInMbs":
            suggest = "memory_in_mbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetComputeGpuDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetComputeGpuDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetComputeGpuDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cores_count: Optional[_builtins.int] = None,
                 description: Optional[_builtins.str] = None,
                 manufacturer: Optional[_builtins.str] = None,
                 memory_in_mbs: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.int cores_count: (Updatable) Number of GPU cores.
        :param _builtins.str description: (Updatable) GPU device description.
        :param _builtins.str manufacturer: (Updatable) The manufacturer of GPU.
        :param _builtins.str memory_in_mbs: (Updatable) GPU memory size in MBs.
        :param _builtins.str name: (Updatable) GPU device name.
        """
        if cores_count is not None:
            pulumi.set(__self__, "cores_count", cores_count)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if manufacturer is not None:
            pulumi.set(__self__, "manufacturer", manufacturer)
        if memory_in_mbs is not None:
            pulumi.set(__self__, "memory_in_mbs", memory_in_mbs)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="coresCount")
    def cores_count(self) -> Optional[_builtins.int]:
        """
        (Updatable) Number of GPU cores.
        """
        return pulumi.get(self, "cores_count")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        (Updatable) GPU device description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def manufacturer(self) -> Optional[_builtins.str]:
        """
        (Updatable) The manufacturer of GPU.
        """
        return pulumi.get(self, "manufacturer")

    @_builtins.property
    @pulumi.getter(name="memoryInMbs")
    def memory_in_mbs(self) -> Optional[_builtins.str]:
        """
        (Updatable) GPU memory size in MBs.
        """
        return pulumi.get(self, "memory_in_mbs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        (Updatable) GPU device name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AssetComputeNic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddresses":
            suggest = "ip_addresses"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "macAddressType":
            suggest = "mac_address_type"
        elif key == "networkName":
            suggest = "network_name"
        elif key == "switchName":
            suggest = "switch_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetComputeNic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetComputeNic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetComputeNic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_addresses: Optional[Sequence[_builtins.str]] = None,
                 label: Optional[_builtins.str] = None,
                 mac_address: Optional[_builtins.str] = None,
                 mac_address_type: Optional[_builtins.str] = None,
                 network_name: Optional[_builtins.str] = None,
                 switch_name: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] ip_addresses: (Updatable) List of IP addresses.
        :param _builtins.str label: (Updatable) Provides a label and summary information for the device.
        :param _builtins.str mac_address: (Updatable) Mac address of the VM.
        :param _builtins.str mac_address_type: (Updatable) Mac address type.
        :param _builtins.str network_name: (Updatable) Network name.
        :param _builtins.str switch_name: (Updatable) Switch name.
        """
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if mac_address_type is not None:
            pulumi.set(__self__, "mac_address_type", mac_address_type)
        if network_name is not None:
            pulumi.set(__self__, "network_name", network_name)
        if switch_name is not None:
            pulumi.set(__self__, "switch_name", switch_name)

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) List of IP addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        (Updatable) Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[_builtins.str]:
        """
        (Updatable) Mac address of the VM.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="macAddressType")
    def mac_address_type(self) -> Optional[_builtins.str]:
        """
        (Updatable) Mac address type.
        """
        return pulumi.get(self, "mac_address_type")

    @_builtins.property
    @pulumi.getter(name="networkName")
    def network_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) Network name.
        """
        return pulumi.get(self, "network_name")

    @_builtins.property
    @pulumi.getter(name="switchName")
    def switch_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) Switch name.
        """
        return pulumi.get(self, "switch_name")


@pulumi.output_type
class AssetComputeNvdimm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "controllerKey":
            suggest = "controller_key"
        elif key == "unitNumber":
            suggest = "unit_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetComputeNvdimm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetComputeNvdimm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetComputeNvdimm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 controller_key: Optional[_builtins.int] = None,
                 label: Optional[_builtins.str] = None,
                 unit_number: Optional[_builtins.int] = None):
        """
        :param _builtins.int controller_key: (Updatable) Controller key.
        :param _builtins.str label: (Updatable) Provides a label and summary information for the device.
        :param _builtins.int unit_number: (Updatable) The unit number of NVDIMM.
        """
        if controller_key is not None:
            pulumi.set(__self__, "controller_key", controller_key)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if unit_number is not None:
            pulumi.set(__self__, "unit_number", unit_number)

    @_builtins.property
    @pulumi.getter(name="controllerKey")
    def controller_key(self) -> Optional[_builtins.int]:
        """
        (Updatable) Controller key.
        """
        return pulumi.get(self, "controller_key")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        (Updatable) Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="unitNumber")
    def unit_number(self) -> Optional[_builtins.int]:
        """
        (Updatable) The unit number of NVDIMM.
        """
        return pulumi.get(self, "unit_number")


@pulumi.output_type
class AssetComputeNvdimmController(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "busNumber":
            suggest = "bus_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetComputeNvdimmController. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetComputeNvdimmController.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetComputeNvdimmController.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bus_number: Optional[_builtins.int] = None,
                 label: Optional[_builtins.str] = None):
        """
        :param _builtins.int bus_number: (Updatable) Bus number.
        :param _builtins.str label: (Updatable) Provides a label and summary information for the device.
        """
        if bus_number is not None:
            pulumi.set(__self__, "bus_number", bus_number)
        if label is not None:
            pulumi.set(__self__, "label", label)

    @_builtins.property
    @pulumi.getter(name="busNumber")
    def bus_number(self) -> Optional[_builtins.int]:
        """
        (Updatable) Bus number.
        """
        return pulumi.get(self, "bus_number")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        (Updatable) Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class AssetComputeScsiController(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sharedBus":
            suggest = "shared_bus"
        elif key == "unitNumber":
            suggest = "unit_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetComputeScsiController. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetComputeScsiController.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetComputeScsiController.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: Optional[_builtins.str] = None,
                 shared_bus: Optional[_builtins.str] = None,
                 unit_number: Optional[_builtins.int] = None):
        """
        :param _builtins.str label: (Updatable) Provides a label and summary information for the device.
        :param _builtins.str shared_bus: (Updatable) Shared bus.
        :param _builtins.int unit_number: (Updatable) The unit number of the SCSI controller.
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if shared_bus is not None:
            pulumi.set(__self__, "shared_bus", shared_bus)
        if unit_number is not None:
            pulumi.set(__self__, "unit_number", unit_number)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        (Updatable) Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="sharedBus")
    def shared_bus(self) -> Optional[_builtins.str]:
        """
        (Updatable) Shared bus.
        """
        return pulumi.get(self, "shared_bus")

    @_builtins.property
    @pulumi.getter(name="unitNumber")
    def unit_number(self) -> Optional[_builtins.int]:
        """
        (Updatable) The unit number of the SCSI controller.
        """
        return pulumi.get(self, "unit_number")


@pulumi.output_type
class AssetSourceDiscoveryCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretId":
            suggest = "secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetSourceDiscoveryCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetSourceDiscoveryCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetSourceDiscoveryCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        :param _builtins.str type: (Updatable) Authentication type
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        (Updatable) Authentication type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AssetSourceReplicationCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretId":
            suggest = "secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetSourceReplicationCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetSourceReplicationCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetSourceReplicationCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        :param _builtins.str type: (Updatable) Authentication type
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        (Updatable) Authentication type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AssetVm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hypervisorHost":
            suggest = "hypervisor_host"
        elif key == "hypervisorVendor":
            suggest = "hypervisor_vendor"
        elif key == "hypervisorVersion":
            suggest = "hypervisor_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetVm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetVm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetVm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hypervisor_host: Optional[_builtins.str] = None,
                 hypervisor_vendor: Optional[_builtins.str] = None,
                 hypervisor_version: Optional[_builtins.str] = None):
        """
        :param _builtins.str hypervisor_host: (Updatable) Host name/IP address of VM on which the host is running.
        :param _builtins.str hypervisor_vendor: (Updatable) Hypervisor vendor.
        :param _builtins.str hypervisor_version: (Updatable) Hypervisor version.
        """
        if hypervisor_host is not None:
            pulumi.set(__self__, "hypervisor_host", hypervisor_host)
        if hypervisor_vendor is not None:
            pulumi.set(__self__, "hypervisor_vendor", hypervisor_vendor)
        if hypervisor_version is not None:
            pulumi.set(__self__, "hypervisor_version", hypervisor_version)

    @_builtins.property
    @pulumi.getter(name="hypervisorHost")
    def hypervisor_host(self) -> Optional[_builtins.str]:
        """
        (Updatable) Host name/IP address of VM on which the host is running.
        """
        return pulumi.get(self, "hypervisor_host")

    @_builtins.property
    @pulumi.getter(name="hypervisorVendor")
    def hypervisor_vendor(self) -> Optional[_builtins.str]:
        """
        (Updatable) Hypervisor vendor.
        """
        return pulumi.get(self, "hypervisor_vendor")

    @_builtins.property
    @pulumi.getter(name="hypervisorVersion")
    def hypervisor_version(self) -> Optional[_builtins.str]:
        """
        (Updatable) Hypervisor version.
        """
        return pulumi.get(self, "hypervisor_version")


@pulumi.output_type
class AssetVmwareVcenter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataCenter":
            suggest = "data_center"
        elif key == "vcenterKey":
            suggest = "vcenter_key"
        elif key == "vcenterVersion":
            suggest = "vcenter_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetVmwareVcenter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetVmwareVcenter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetVmwareVcenter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_center: Optional[_builtins.str] = None,
                 vcenter_key: Optional[_builtins.str] = None,
                 vcenter_version: Optional[_builtins.str] = None):
        """
        :param _builtins.str data_center: (Updatable) Data center name.
        :param _builtins.str vcenter_key: (Updatable) vCenter unique key.
        :param _builtins.str vcenter_version: (Updatable) Dot-separated version string.
        """
        if data_center is not None:
            pulumi.set(__self__, "data_center", data_center)
        if vcenter_key is not None:
            pulumi.set(__self__, "vcenter_key", vcenter_key)
        if vcenter_version is not None:
            pulumi.set(__self__, "vcenter_version", vcenter_version)

    @_builtins.property
    @pulumi.getter(name="dataCenter")
    def data_center(self) -> Optional[_builtins.str]:
        """
        (Updatable) Data center name.
        """
        return pulumi.get(self, "data_center")

    @_builtins.property
    @pulumi.getter(name="vcenterKey")
    def vcenter_key(self) -> Optional[_builtins.str]:
        """
        (Updatable) vCenter unique key.
        """
        return pulumi.get(self, "vcenter_key")

    @_builtins.property
    @pulumi.getter(name="vcenterVersion")
    def vcenter_version(self) -> Optional[_builtins.str]:
        """
        (Updatable) Dot-separated version string.
        """
        return pulumi.get(self, "vcenter_version")


@pulumi.output_type
class AssetVmwareVm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerFields":
            suggest = "customer_fields"
        elif key == "customerTags":
            suggest = "customer_tags"
        elif key == "faultToleranceBandwidth":
            suggest = "fault_tolerance_bandwidth"
        elif key == "faultToleranceSecondaryLatency":
            suggest = "fault_tolerance_secondary_latency"
        elif key == "faultToleranceState":
            suggest = "fault_tolerance_state"
        elif key == "instanceUuid":
            suggest = "instance_uuid"
        elif key == "isDisksCbtEnabled":
            suggest = "is_disks_cbt_enabled"
        elif key == "isDisksUuidEnabled":
            suggest = "is_disks_uuid_enabled"
        elif key == "vmwareToolsStatus":
            suggest = "vmware_tools_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetVmwareVm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetVmwareVm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetVmwareVm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster: Optional[_builtins.str] = None,
                 customer_fields: Optional[Sequence[_builtins.str]] = None,
                 customer_tags: Optional[Sequence['outputs.AssetVmwareVmCustomerTag']] = None,
                 fault_tolerance_bandwidth: Optional[_builtins.int] = None,
                 fault_tolerance_secondary_latency: Optional[_builtins.int] = None,
                 fault_tolerance_state: Optional[_builtins.str] = None,
                 instance_uuid: Optional[_builtins.str] = None,
                 is_disks_cbt_enabled: Optional[_builtins.bool] = None,
                 is_disks_uuid_enabled: Optional[_builtins.bool] = None,
                 path: Optional[_builtins.str] = None,
                 vmware_tools_status: Optional[_builtins.str] = None):
        """
        :param _builtins.str cluster: (Updatable) Cluster name.
        :param Sequence[_builtins.str] customer_fields: (Updatable) Customer fields.
        :param Sequence['AssetVmwareVmCustomerTagArgs'] customer_tags: (Updatable) Customer defined tags.
        :param _builtins.int fault_tolerance_bandwidth: (Updatable) Fault tolerance bandwidth.
        :param _builtins.int fault_tolerance_secondary_latency: (Updatable) Fault tolerance to secondary latency.
        :param _builtins.str fault_tolerance_state: (Updatable) Fault tolerance state.
        :param _builtins.str instance_uuid: (Updatable) vCenter-specific identifier of the virtual machine.
        :param _builtins.bool is_disks_cbt_enabled: (Updatable) Indicates that change tracking is supported for virtual disks of this virtual machine. However, even if change tracking is supported, it might not be available for all disks of the virtual machine.
        :param _builtins.bool is_disks_uuid_enabled: (Updatable) Whether changed block tracking for this VM's disk is active.
        :param _builtins.str path: (Updatable) Path directory of the asset.
        :param _builtins.str vmware_tools_status: (Updatable) VMware tools status.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if customer_fields is not None:
            pulumi.set(__self__, "customer_fields", customer_fields)
        if customer_tags is not None:
            pulumi.set(__self__, "customer_tags", customer_tags)
        if fault_tolerance_bandwidth is not None:
            pulumi.set(__self__, "fault_tolerance_bandwidth", fault_tolerance_bandwidth)
        if fault_tolerance_secondary_latency is not None:
            pulumi.set(__self__, "fault_tolerance_secondary_latency", fault_tolerance_secondary_latency)
        if fault_tolerance_state is not None:
            pulumi.set(__self__, "fault_tolerance_state", fault_tolerance_state)
        if instance_uuid is not None:
            pulumi.set(__self__, "instance_uuid", instance_uuid)
        if is_disks_cbt_enabled is not None:
            pulumi.set(__self__, "is_disks_cbt_enabled", is_disks_cbt_enabled)
        if is_disks_uuid_enabled is not None:
            pulumi.set(__self__, "is_disks_uuid_enabled", is_disks_uuid_enabled)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if vmware_tools_status is not None:
            pulumi.set(__self__, "vmware_tools_status", vmware_tools_status)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> Optional[_builtins.str]:
        """
        (Updatable) Cluster name.
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter(name="customerFields")
    def customer_fields(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) Customer fields.
        """
        return pulumi.get(self, "customer_fields")

    @_builtins.property
    @pulumi.getter(name="customerTags")
    def customer_tags(self) -> Optional[Sequence['outputs.AssetVmwareVmCustomerTag']]:
        """
        (Updatable) Customer defined tags.
        """
        return pulumi.get(self, "customer_tags")

    @_builtins.property
    @pulumi.getter(name="faultToleranceBandwidth")
    def fault_tolerance_bandwidth(self) -> Optional[_builtins.int]:
        """
        (Updatable) Fault tolerance bandwidth.
        """
        return pulumi.get(self, "fault_tolerance_bandwidth")

    @_builtins.property
    @pulumi.getter(name="faultToleranceSecondaryLatency")
    def fault_tolerance_secondary_latency(self) -> Optional[_builtins.int]:
        """
        (Updatable) Fault tolerance to secondary latency.
        """
        return pulumi.get(self, "fault_tolerance_secondary_latency")

    @_builtins.property
    @pulumi.getter(name="faultToleranceState")
    def fault_tolerance_state(self) -> Optional[_builtins.str]:
        """
        (Updatable) Fault tolerance state.
        """
        return pulumi.get(self, "fault_tolerance_state")

    @_builtins.property
    @pulumi.getter(name="instanceUuid")
    def instance_uuid(self) -> Optional[_builtins.str]:
        """
        (Updatable) vCenter-specific identifier of the virtual machine.
        """
        return pulumi.get(self, "instance_uuid")

    @_builtins.property
    @pulumi.getter(name="isDisksCbtEnabled")
    def is_disks_cbt_enabled(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Indicates that change tracking is supported for virtual disks of this virtual machine. However, even if change tracking is supported, it might not be available for all disks of the virtual machine.
        """
        return pulumi.get(self, "is_disks_cbt_enabled")

    @_builtins.property
    @pulumi.getter(name="isDisksUuidEnabled")
    def is_disks_uuid_enabled(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Whether changed block tracking for this VM's disk is active.
        """
        return pulumi.get(self, "is_disks_uuid_enabled")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        (Updatable) Path directory of the asset.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="vmwareToolsStatus")
    def vmware_tools_status(self) -> Optional[_builtins.str]:
        """
        (Updatable) VMware tools status.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vmware_tools_status")


@pulumi.output_type
class AssetVmwareVmCustomerTag(dict):
    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: (Updatable) The tag description.
        :param _builtins.str name: (Updatable) The tag name.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        (Updatable) The tag description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        (Updatable) The tag name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAgentDependenciesAgentDependencyCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetAgentDependenciesAgentDependencyCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAgentDependenciesAgentDependencyCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetAgentDependenciesAgentDependencyCollectionItemResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 checksum: _builtins.str,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 dependency_name: _builtins.str,
                 dependency_version: _builtins.str,
                 description: _builtins.str,
                 display_name: _builtins.str,
                 e_tag: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str):
        """
        :param _builtins.str bucket: Object storage bucket where the Agent dependency is uploaded.
        :param _builtins.str checksum: The checksum associated with the dependency object returned by Object Storage.
        :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, _builtins.str] defined_tags: The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str dependency_name: Name of the dependency type. This should match the whitelisted enum of dependency names.
        :param _builtins.str dependency_version: Version of the Agent dependency.
        :param _builtins.str description: Description about the Agent dependency.
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param _builtins.str e_tag: The eTag associated with the dependency object returned by Object Storage.
        :param Mapping[str, _builtins.str] freeform_tags: The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: Unique identifier that is immutable on creation.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param _builtins.str namespace: Object storage namespace associated with the customer's tenancy.
        :param _builtins.str object: Name of the dependency object uploaded by the customer.
        :param _builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, _builtins.str] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param _builtins.str time_created: The time when the AgentDependency was created. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "dependency_name", dependency_name)
        pulumi.set(__self__, "dependency_version", dependency_version)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "e_tag", e_tag)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Object storage bucket where the Agent dependency is uploaded.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> _builtins.str:
        """
        The checksum associated with the dependency object returned by Object Storage.
        """
        return pulumi.get(self, "checksum")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="dependencyName")
    def dependency_name(self) -> _builtins.str:
        """
        Name of the dependency type. This should match the whitelisted enum of dependency names.
        """
        return pulumi.get(self, "dependency_name")

    @_builtins.property
    @pulumi.getter(name="dependencyVersion")
    def dependency_version(self) -> _builtins.str:
        """
        Version of the Agent dependency.
        """
        return pulumi.get(self, "dependency_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description about the Agent dependency.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> _builtins.str:
        """
        The eTag associated with the dependency object returned by Object Storage.
        """
        return pulumi.get(self, "e_tag")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        Object storage namespace associated with the customer's tenancy.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        Name of the dependency object uploaded by the customer.
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the AgentDependency was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetAgentDependenciesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetAgentPluginListResult(dict):
    def __init__(__self__, *,
                 agent_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 freeform_tags: Mapping[str, _builtins.str],
                 lifecycle_details: _builtins.str,
                 name: _builtins.str,
                 plugin_version: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str agent_id: Unique Agent identifier path parameter.
        :param Mapping[str, _builtins.str] defined_tags: The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, _builtins.str] freeform_tags: The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param _builtins.str name: Plugin identifier, which can be renamed.
        :param _builtins.str plugin_version: Plugin version.
        :param _builtins.str state: The current state of the Agent.
        :param _builtins.str time_created: The time when the Agent was created. An RFC3339 formatted datetime string.
        :param _builtins.str time_updated: The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "plugin_version", plugin_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> _builtins.str:
        """
        Unique Agent identifier path parameter.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Plugin identifier, which can be renamed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> _builtins.str:
        """
        Plugin version.
        """
        return pulumi.get(self, "plugin_version")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Agent.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the Agent was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetAgentsAgentCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetAgentsAgentCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAgentsAgentCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetAgentsAgentCollectionItemResult(dict):
    def __init__(__self__, *,
                 agent_pub_key: _builtins.str,
                 agent_type: _builtins.str,
                 agent_version: _builtins.str,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 environment_id: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 heart_beat_status: _builtins.str,
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 os_version: _builtins.str,
                 plugin_lists: Sequence['outputs.GetAgentsAgentCollectionItemPluginListResult'],
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_expire_agent_key_in_ms: _builtins.str,
                 time_last_sync_received: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str agent_pub_key: Resource principal public key.
        :param _builtins.str agent_type: Type of the Agent.
        :param _builtins.str agent_version: Agent identifier.
        :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, _builtins.str] defined_tags: The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param _builtins.str environment_id: A filter to return only resources that match the given environment ID.
        :param Mapping[str, _builtins.str] freeform_tags: The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str heart_beat_status: The current heartbeat status of the Agent based on its timeLastSyncReceived value.
        :param _builtins.str id: Unique identifier that is immutable on creation.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param _builtins.str os_version: OS version.
        :param Sequence['GetAgentsAgentCollectionItemPluginListArgs'] plugin_lists: List of plugins associated with the agent.
        :param _builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, _builtins.str] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param _builtins.str time_created: The time when the Agent was created. An RFC3339 formatted datetime string.
        :param _builtins.str time_expire_agent_key_in_ms: The time since epoch for when the public key will expire. An RFC3339 formatted datetime string.
        :param _builtins.str time_last_sync_received: The time when the last heartbeat of the Agent was noted. An RFC3339 formatted datetime string.
        :param _builtins.str time_updated: The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "agent_pub_key", agent_pub_key)
        pulumi.set(__self__, "agent_type", agent_type)
        pulumi.set(__self__, "agent_version", agent_version)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "heart_beat_status", heart_beat_status)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "os_version", os_version)
        pulumi.set(__self__, "plugin_lists", plugin_lists)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_expire_agent_key_in_ms", time_expire_agent_key_in_ms)
        pulumi.set(__self__, "time_last_sync_received", time_last_sync_received)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="agentPubKey")
    def agent_pub_key(self) -> _builtins.str:
        """
        Resource principal public key.
        """
        return pulumi.get(self, "agent_pub_key")

    @_builtins.property
    @pulumi.getter(name="agentType")
    def agent_type(self) -> _builtins.str:
        """
        Type of the Agent.
        """
        return pulumi.get(self, "agent_type")

    @_builtins.property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> _builtins.str:
        """
        Agent identifier.
        """
        return pulumi.get(self, "agent_version")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> _builtins.str:
        """
        A filter to return only resources that match the given environment ID.
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="heartBeatStatus")
    def heart_beat_status(self) -> _builtins.str:
        """
        The current heartbeat status of the Agent based on its timeLastSyncReceived value.
        """
        return pulumi.get(self, "heart_beat_status")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> _builtins.str:
        """
        OS version.
        """
        return pulumi.get(self, "os_version")

    @_builtins.property
    @pulumi.getter(name="pluginLists")
    def plugin_lists(self) -> Sequence['outputs.GetAgentsAgentCollectionItemPluginListResult']:
        """
        List of plugins associated with the agent.
        """
        return pulumi.get(self, "plugin_lists")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the Agent was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeExpireAgentKeyInMs")
    def time_expire_agent_key_in_ms(self) -> _builtins.str:
        """
        The time since epoch for when the public key will expire. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_expire_agent_key_in_ms")

    @_builtins.property
    @pulumi.getter(name="timeLastSyncReceived")
    def time_last_sync_received(self) -> _builtins.str:
        """
        The time when the last heartbeat of the Agent was noted. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_last_sync_received")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetAgentsAgentCollectionItemPluginListResult(dict):
    def __init__(__self__, *,
                 agent_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 freeform_tags: Mapping[str, _builtins.str],
                 lifecycle_details: _builtins.str,
                 name: _builtins.str,
                 plugin_version: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str agent_id: A filter to return only resources that match the given Agent ID.
        :param Mapping[str, _builtins.str] defined_tags: The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, _builtins.str] freeform_tags: The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param _builtins.str name: Plugin identifier, which can be renamed.
        :param _builtins.str plugin_version: Plugin version.
        :param _builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param _builtins.str time_created: The time when the Agent was created. An RFC3339 formatted datetime string.
        :param _builtins.str time_updated: The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "plugin_version", plugin_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> _builtins.str:
        """
        A filter to return only resources that match the given Agent ID.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Plugin identifier, which can be renamed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> _builtins.str:
        """
        Plugin version.
        """
        return pulumi.get(self, "plugin_version")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the Agent was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetAgentsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Plugin identifier, which can be renamed.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Plugin identifier, which can be renamed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetApplianceImageItemResult(dict):
    def __init__(__self__, *,
                 checksum: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 download_url: _builtins.str,
                 file_name: _builtins.str,
                 format: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 platform: _builtins.str,
                 size_in_mbs: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str checksum: The checksum of the image file.
        :param Mapping[str, _builtins.str] defined_tags: The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param _builtins.str download_url: The URL from which the appliance image can be downloaded.
        :param _builtins.str file_name: The name of the appliance Image file.
        :param _builtins.str format: The file format of the image file.
        :param Mapping[str, _builtins.str] freeform_tags: The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: Unique identifier that is immutable on creation.
        :param _builtins.str platform: The virtualization platform that the image file supports.
        :param _builtins.str size_in_mbs: The size of the image file in megabytes.
        :param _builtins.str state: The current state of the appliance image.
        :param _builtins.str time_created: The time when the appliance image was created.An RFC3339 formatted datetime string.
        :param _builtins.str time_updated: The time when the appliance image was last updated. An RFC3339 formatted datetime string.
        :param _builtins.str version: The version of the image file.
        """
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "download_url", download_url)
        pulumi.set(__self__, "file_name", file_name)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "size_in_mbs", size_in_mbs)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> _builtins.str:
        """
        The checksum of the image file.
        """
        return pulumi.get(self, "checksum")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="downloadUrl")
    def download_url(self) -> _builtins.str:
        """
        The URL from which the appliance image can be downloaded.
        """
        return pulumi.get(self, "download_url")

    @_builtins.property
    @pulumi.getter(name="fileName")
    def file_name(self) -> _builtins.str:
        """
        The name of the appliance Image file.
        """
        return pulumi.get(self, "file_name")

    @_builtins.property
    @pulumi.getter
    def format(self) -> _builtins.str:
        """
        The file format of the image file.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> _builtins.str:
        """
        The virtualization platform that the image file supports.
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> _builtins.str:
        """
        The size of the image file in megabytes.
        """
        return pulumi.get(self, "size_in_mbs")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the appliance image.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the appliance image was created.An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when the appliance image was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the image file.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetApplianceImagesApplianceImageCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetApplianceImagesApplianceImageCollectionItemResult']):
        """
        :param Sequence['GetApplianceImagesApplianceImageCollectionItemArgs'] items: List of appliance images.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetApplianceImagesApplianceImageCollectionItemResult']:
        """
        List of appliance images.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetApplianceImagesApplianceImageCollectionItemResult(dict):
    def __init__(__self__, *,
                 checksum: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 download_url: _builtins.str,
                 file_name: _builtins.str,
                 format: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 platform: _builtins.str,
                 size_in_mbs: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str checksum: The checksum of the image file.
        :param Mapping[str, _builtins.str] defined_tags: The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param _builtins.str download_url: The URL from which the appliance image can be downloaded.
        :param _builtins.str file_name: The name of the appliance Image file.
        :param _builtins.str format: The file format of the image file.
        :param Mapping[str, _builtins.str] freeform_tags: The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: Unique identifier that is immutable on creation.
        :param _builtins.str platform: The virtualization platform that the image file supports.
        :param _builtins.str size_in_mbs: The size of the image file in megabytes.
        :param _builtins.str state: The current state of the appliance image.
        :param _builtins.str time_created: The time when the appliance image was created.An RFC3339 formatted datetime string.
        :param _builtins.str time_updated: The time when the appliance image was last updated. An RFC3339 formatted datetime string.
        :param _builtins.str version: The version of the image file.
        """
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "download_url", download_url)
        pulumi.set(__self__, "file_name", file_name)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "size_in_mbs", size_in_mbs)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> _builtins.str:
        """
        The checksum of the image file.
        """
        return pulumi.get(self, "checksum")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="downloadUrl")
    def download_url(self) -> _builtins.str:
        """
        The URL from which the appliance image can be downloaded.
        """
        return pulumi.get(self, "download_url")

    @_builtins.property
    @pulumi.getter(name="fileName")
    def file_name(self) -> _builtins.str:
        """
        The name of the appliance Image file.
        """
        return pulumi.get(self, "file_name")

    @_builtins.property
    @pulumi.getter
    def format(self) -> _builtins.str:
        """
        The file format of the image file.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> _builtins.str:
        """
        The virtualization platform that the image file supports.
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> _builtins.str:
        """
        The size of the image file in megabytes.
        """
        return pulumi.get(self, "size_in_mbs")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the appliance image.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the appliance image was created.An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when the appliance image was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the image file.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetApplianceImagesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetAssetComputeResult(dict):
    def __init__(__self__, *,
                 connected_networks: _builtins.int,
                 cores_count: _builtins.int,
                 cpu_model: _builtins.str,
                 description: _builtins.str,
                 disks: Sequence['outputs.GetAssetComputeDiskResult'],
                 disks_count: _builtins.int,
                 dns_name: _builtins.str,
                 firmware: _builtins.str,
                 gpu_devices: Sequence['outputs.GetAssetComputeGpuDeviceResult'],
                 gpu_devices_count: _builtins.int,
                 guest_state: _builtins.str,
                 hardware_version: _builtins.str,
                 host_name: _builtins.str,
                 is_pmem_enabled: _builtins.bool,
                 is_tpm_enabled: _builtins.bool,
                 latency_sensitivity: _builtins.str,
                 memory_in_mbs: _builtins.str,
                 nics: Sequence['outputs.GetAssetComputeNicResult'],
                 nics_count: _builtins.int,
                 nvdimm_controllers: Sequence['outputs.GetAssetComputeNvdimmControllerResult'],
                 nvdimms: Sequence['outputs.GetAssetComputeNvdimmResult'],
                 operating_system: _builtins.str,
                 operating_system_version: _builtins.str,
                 pmem_in_mbs: _builtins.str,
                 power_state: _builtins.str,
                 primary_ip: _builtins.str,
                 scsi_controllers: Sequence['outputs.GetAssetComputeScsiControllerResult'],
                 storage_provisioned_in_mbs: _builtins.str,
                 threads_per_core_count: _builtins.int):
        """
        :param _builtins.int connected_networks: Number of connected networks.
        :param _builtins.int cores_count: Number of GPU cores.
        :param _builtins.str cpu_model: CPU model name.
        :param _builtins.str description: The tag description.
        :param Sequence['GetAssetComputeDiskArgs'] disks: Lists the set of disks belonging to the virtual machine. This list is unordered.
        :param _builtins.int disks_count: Number of disks.
        :param _builtins.str dns_name: Fully Qualified DNS Name.
        :param _builtins.str firmware: Information about firmware type for this virtual machine.
        :param Sequence['GetAssetComputeGpuDeviceArgs'] gpu_devices: List of GPU devices attached to a virtual machine.
        :param _builtins.int gpu_devices_count: Number of GPU devices.
        :param _builtins.str guest_state: Guest state.
        :param _builtins.str hardware_version: Hardware version.
        :param _builtins.str host_name: Host name of the VM.
        :param _builtins.bool is_pmem_enabled: Whether Pmem is enabled. Decides if NVDIMMs are used as a permanent memory.
        :param _builtins.bool is_tpm_enabled: Whether Trusted Platform Module (TPM) is enabled.
        :param _builtins.str latency_sensitivity: Latency sensitivity.
        :param _builtins.str memory_in_mbs: Memory size in MBs.
        :param Sequence['GetAssetComputeNicArgs'] nics: List of network ethernet cards attached to a virtual machine.
        :param _builtins.int nics_count: Number of network ethernet cards.
        :param Sequence['GetAssetComputeNvdimmControllerArgs'] nvdimm_controllers: The asset's NVDIMM configuration.
        :param Sequence['GetAssetComputeNvdimmArgs'] nvdimms: The properties of the NVDIMMs attached to a virtual machine.
        :param _builtins.str operating_system: Operating system.
        :param _builtins.str operating_system_version: Operating system version.
        :param _builtins.str pmem_in_mbs: Pmem size in MBs.
        :param _builtins.str power_state: The current power state of the virtual machine.
        :param _builtins.str primary_ip: Primary IP address of the compute instance.
        :param Sequence['GetAssetComputeScsiControllerArgs'] scsi_controllers: The assets SCSI controller.
        :param _builtins.str storage_provisioned_in_mbs: Provision storage size in MBs.
        :param _builtins.int threads_per_core_count: Number of threads per core.
        """
        pulumi.set(__self__, "connected_networks", connected_networks)
        pulumi.set(__self__, "cores_count", cores_count)
        pulumi.set(__self__, "cpu_model", cpu_model)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disks", disks)
        pulumi.set(__self__, "disks_count", disks_count)
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "firmware", firmware)
        pulumi.set(__self__, "gpu_devices", gpu_devices)
        pulumi.set(__self__, "gpu_devices_count", gpu_devices_count)
        pulumi.set(__self__, "guest_state", guest_state)
        pulumi.set(__self__, "hardware_version", hardware_version)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "is_pmem_enabled", is_pmem_enabled)
        pulumi.set(__self__, "is_tpm_enabled", is_tpm_enabled)
        pulumi.set(__self__, "latency_sensitivity", latency_sensitivity)
        pulumi.set(__self__, "memory_in_mbs", memory_in_mbs)
        pulumi.set(__self__, "nics", nics)
        pulumi.set(__self__, "nics_count", nics_count)
        pulumi.set(__self__, "nvdimm_controllers", nvdimm_controllers)
        pulumi.set(__self__, "nvdimms", nvdimms)
        pulumi.set(__self__, "operating_system", operating_system)
        pulumi.set(__self__, "operating_system_version", operating_system_version)
        pulumi.set(__self__, "pmem_in_mbs", pmem_in_mbs)
        pulumi.set(__self__, "power_state", power_state)
        pulumi.set(__self__, "primary_ip", primary_ip)
        pulumi.set(__self__, "scsi_controllers", scsi_controllers)
        pulumi.set(__self__, "storage_provisioned_in_mbs", storage_provisioned_in_mbs)
        pulumi.set(__self__, "threads_per_core_count", threads_per_core_count)

    @_builtins.property
    @pulumi.getter(name="connectedNetworks")
    def connected_networks(self) -> _builtins.int:
        """
        Number of connected networks.
        """
        return pulumi.get(self, "connected_networks")

    @_builtins.property
    @pulumi.getter(name="coresCount")
    def cores_count(self) -> _builtins.int:
        """
        Number of GPU cores.
        """
        return pulumi.get(self, "cores_count")

    @_builtins.property
    @pulumi.getter(name="cpuModel")
    def cpu_model(self) -> _builtins.str:
        """
        CPU model name.
        """
        return pulumi.get(self, "cpu_model")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The tag description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.GetAssetComputeDiskResult']:
        """
        Lists the set of disks belonging to the virtual machine. This list is unordered.
        """
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter(name="disksCount")
    def disks_count(self) -> _builtins.int:
        """
        Number of disks.
        """
        return pulumi.get(self, "disks_count")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> _builtins.str:
        """
        Fully Qualified DNS Name.
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter
    def firmware(self) -> _builtins.str:
        """
        Information about firmware type for this virtual machine.
        """
        return pulumi.get(self, "firmware")

    @_builtins.property
    @pulumi.getter(name="gpuDevices")
    def gpu_devices(self) -> Sequence['outputs.GetAssetComputeGpuDeviceResult']:
        """
        List of GPU devices attached to a virtual machine.
        """
        return pulumi.get(self, "gpu_devices")

    @_builtins.property
    @pulumi.getter(name="gpuDevicesCount")
    def gpu_devices_count(self) -> _builtins.int:
        """
        Number of GPU devices.
        """
        return pulumi.get(self, "gpu_devices_count")

    @_builtins.property
    @pulumi.getter(name="guestState")
    def guest_state(self) -> _builtins.str:
        """
        Guest state.
        """
        return pulumi.get(self, "guest_state")

    @_builtins.property
    @pulumi.getter(name="hardwareVersion")
    def hardware_version(self) -> _builtins.str:
        """
        Hardware version.
        """
        return pulumi.get(self, "hardware_version")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> _builtins.str:
        """
        Host name of the VM.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="isPmemEnabled")
    def is_pmem_enabled(self) -> _builtins.bool:
        """
        Whether Pmem is enabled. Decides if NVDIMMs are used as a permanent memory.
        """
        return pulumi.get(self, "is_pmem_enabled")

    @_builtins.property
    @pulumi.getter(name="isTpmEnabled")
    def is_tpm_enabled(self) -> _builtins.bool:
        """
        Whether Trusted Platform Module (TPM) is enabled.
        """
        return pulumi.get(self, "is_tpm_enabled")

    @_builtins.property
    @pulumi.getter(name="latencySensitivity")
    def latency_sensitivity(self) -> _builtins.str:
        """
        Latency sensitivity.
        """
        return pulumi.get(self, "latency_sensitivity")

    @_builtins.property
    @pulumi.getter(name="memoryInMbs")
    def memory_in_mbs(self) -> _builtins.str:
        """
        Memory size in MBs.
        """
        return pulumi.get(self, "memory_in_mbs")

    @_builtins.property
    @pulumi.getter
    def nics(self) -> Sequence['outputs.GetAssetComputeNicResult']:
        """
        List of network ethernet cards attached to a virtual machine.
        """
        return pulumi.get(self, "nics")

    @_builtins.property
    @pulumi.getter(name="nicsCount")
    def nics_count(self) -> _builtins.int:
        """
        Number of network ethernet cards.
        """
        return pulumi.get(self, "nics_count")

    @_builtins.property
    @pulumi.getter(name="nvdimmControllers")
    def nvdimm_controllers(self) -> Sequence['outputs.GetAssetComputeNvdimmControllerResult']:
        """
        The asset's NVDIMM configuration.
        """
        return pulumi.get(self, "nvdimm_controllers")

    @_builtins.property
    @pulumi.getter
    def nvdimms(self) -> Sequence['outputs.GetAssetComputeNvdimmResult']:
        """
        The properties of the NVDIMMs attached to a virtual machine.
        """
        return pulumi.get(self, "nvdimms")

    @_builtins.property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> _builtins.str:
        """
        Operating system.
        """
        return pulumi.get(self, "operating_system")

    @_builtins.property
    @pulumi.getter(name="operatingSystemVersion")
    def operating_system_version(self) -> _builtins.str:
        """
        Operating system version.
        """
        return pulumi.get(self, "operating_system_version")

    @_builtins.property
    @pulumi.getter(name="pmemInMbs")
    def pmem_in_mbs(self) -> _builtins.str:
        """
        Pmem size in MBs.
        """
        return pulumi.get(self, "pmem_in_mbs")

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> _builtins.str:
        """
        The current power state of the virtual machine.
        """
        return pulumi.get(self, "power_state")

    @_builtins.property
    @pulumi.getter(name="primaryIp")
    def primary_ip(self) -> _builtins.str:
        """
        Primary IP address of the compute instance.
        """
        return pulumi.get(self, "primary_ip")

    @_builtins.property
    @pulumi.getter(name="scsiControllers")
    def scsi_controllers(self) -> Sequence['outputs.GetAssetComputeScsiControllerResult']:
        """
        The assets SCSI controller.
        """
        return pulumi.get(self, "scsi_controllers")

    @_builtins.property
    @pulumi.getter(name="storageProvisionedInMbs")
    def storage_provisioned_in_mbs(self) -> _builtins.str:
        """
        Provision storage size in MBs.
        """
        return pulumi.get(self, "storage_provisioned_in_mbs")

    @_builtins.property
    @pulumi.getter(name="threadsPerCoreCount")
    def threads_per_core_count(self) -> _builtins.int:
        """
        Number of threads per core.
        """
        return pulumi.get(self, "threads_per_core_count")


@pulumi.output_type
class GetAssetComputeDiskResult(dict):
    def __init__(__self__, *,
                 boot_order: _builtins.int,
                 location: _builtins.str,
                 name: _builtins.str,
                 persistent_mode: _builtins.str,
                 size_in_mbs: _builtins.str,
                 uuid: _builtins.str,
                 uuid_lun: _builtins.str):
        """
        :param _builtins.int boot_order: Order of boot volumes.
        :param _builtins.str location: Location of the boot/data volume.
        :param _builtins.str name: The tag name.
        :param _builtins.str persistent_mode: The disk persistent mode.
        :param _builtins.str size_in_mbs: The size of the volume in MBs.
        :param _builtins.str uuid: Disk UUID for the virtual disk, if available.
        :param _builtins.str uuid_lun: Disk UUID LUN for the virtual disk, if available.
        """
        pulumi.set(__self__, "boot_order", boot_order)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "persistent_mode", persistent_mode)
        pulumi.set(__self__, "size_in_mbs", size_in_mbs)
        pulumi.set(__self__, "uuid", uuid)
        pulumi.set(__self__, "uuid_lun", uuid_lun)

    @_builtins.property
    @pulumi.getter(name="bootOrder")
    def boot_order(self) -> _builtins.int:
        """
        Order of boot volumes.
        """
        return pulumi.get(self, "boot_order")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Location of the boot/data volume.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The tag name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="persistentMode")
    def persistent_mode(self) -> _builtins.str:
        """
        The disk persistent mode.
        """
        return pulumi.get(self, "persistent_mode")

    @_builtins.property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> _builtins.str:
        """
        The size of the volume in MBs.
        """
        return pulumi.get(self, "size_in_mbs")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        Disk UUID for the virtual disk, if available.
        """
        return pulumi.get(self, "uuid")

    @_builtins.property
    @pulumi.getter(name="uuidLun")
    def uuid_lun(self) -> _builtins.str:
        """
        Disk UUID LUN for the virtual disk, if available.
        """
        return pulumi.get(self, "uuid_lun")


@pulumi.output_type
class GetAssetComputeGpuDeviceResult(dict):
    def __init__(__self__, *,
                 cores_count: _builtins.int,
                 description: _builtins.str,
                 manufacturer: _builtins.str,
                 memory_in_mbs: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.int cores_count: Number of GPU cores.
        :param _builtins.str description: The tag description.
        :param _builtins.str manufacturer: The manufacturer of GPU.
        :param _builtins.str memory_in_mbs: Memory size in MBs.
        :param _builtins.str name: The tag name.
        """
        pulumi.set(__self__, "cores_count", cores_count)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "manufacturer", manufacturer)
        pulumi.set(__self__, "memory_in_mbs", memory_in_mbs)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="coresCount")
    def cores_count(self) -> _builtins.int:
        """
        Number of GPU cores.
        """
        return pulumi.get(self, "cores_count")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The tag description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def manufacturer(self) -> _builtins.str:
        """
        The manufacturer of GPU.
        """
        return pulumi.get(self, "manufacturer")

    @_builtins.property
    @pulumi.getter(name="memoryInMbs")
    def memory_in_mbs(self) -> _builtins.str:
        """
        Memory size in MBs.
        """
        return pulumi.get(self, "memory_in_mbs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The tag name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAssetComputeNicResult(dict):
    def __init__(__self__, *,
                 ip_addresses: Sequence[_builtins.str],
                 label: _builtins.str,
                 mac_address: _builtins.str,
                 mac_address_type: _builtins.str,
                 network_name: _builtins.str,
                 switch_name: _builtins.str):
        """
        :param Sequence[_builtins.str] ip_addresses: List of IP addresses.
        :param _builtins.str label: Provides a label and summary information for the device.
        :param _builtins.str mac_address: Mac address of the VM.
        :param _builtins.str mac_address_type: Mac address type.
        :param _builtins.str network_name: Network name.
        :param _builtins.str switch_name: Switch name.
        """
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "mac_address_type", mac_address_type)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "switch_name", switch_name)

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[_builtins.str]:
        """
        List of IP addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> _builtins.str:
        """
        Mac address of the VM.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="macAddressType")
    def mac_address_type(self) -> _builtins.str:
        """
        Mac address type.
        """
        return pulumi.get(self, "mac_address_type")

    @_builtins.property
    @pulumi.getter(name="networkName")
    def network_name(self) -> _builtins.str:
        """
        Network name.
        """
        return pulumi.get(self, "network_name")

    @_builtins.property
    @pulumi.getter(name="switchName")
    def switch_name(self) -> _builtins.str:
        """
        Switch name.
        """
        return pulumi.get(self, "switch_name")


@pulumi.output_type
class GetAssetComputeNvdimmResult(dict):
    def __init__(__self__, *,
                 controller_key: _builtins.int,
                 label: _builtins.str,
                 unit_number: _builtins.int):
        """
        :param _builtins.int controller_key: Controller key.
        :param _builtins.str label: Provides a label and summary information for the device.
        :param _builtins.int unit_number: The unit number of the SCSI controller.
        """
        pulumi.set(__self__, "controller_key", controller_key)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "unit_number", unit_number)

    @_builtins.property
    @pulumi.getter(name="controllerKey")
    def controller_key(self) -> _builtins.int:
        """
        Controller key.
        """
        return pulumi.get(self, "controller_key")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="unitNumber")
    def unit_number(self) -> _builtins.int:
        """
        The unit number of the SCSI controller.
        """
        return pulumi.get(self, "unit_number")


@pulumi.output_type
class GetAssetComputeNvdimmControllerResult(dict):
    def __init__(__self__, *,
                 bus_number: _builtins.int,
                 label: _builtins.str):
        """
        :param _builtins.int bus_number: Bus number.
        :param _builtins.str label: Provides a label and summary information for the device.
        """
        pulumi.set(__self__, "bus_number", bus_number)
        pulumi.set(__self__, "label", label)

    @_builtins.property
    @pulumi.getter(name="busNumber")
    def bus_number(self) -> _builtins.int:
        """
        Bus number.
        """
        return pulumi.get(self, "bus_number")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class GetAssetComputeScsiControllerResult(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 shared_bus: _builtins.str,
                 unit_number: _builtins.int):
        """
        :param _builtins.str label: Provides a label and summary information for the device.
        :param _builtins.str shared_bus: Shared bus.
        :param _builtins.int unit_number: The unit number of the SCSI controller.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "shared_bus", shared_bus)
        pulumi.set(__self__, "unit_number", unit_number)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="sharedBus")
    def shared_bus(self) -> _builtins.str:
        """
        Shared bus.
        """
        return pulumi.get(self, "shared_bus")

    @_builtins.property
    @pulumi.getter(name="unitNumber")
    def unit_number(self) -> _builtins.int:
        """
        The unit number of the SCSI controller.
        """
        return pulumi.get(self, "unit_number")


@pulumi.output_type
class GetAssetSourceDiscoveryCredentialResult(dict):
    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        :param _builtins.str type: The type of asset source. Indicates external origin of the assets that are read by assigning this asset source.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of asset source. Indicates external origin of the assets that are read by assigning this asset source.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAssetSourceReplicationCredentialResult(dict):
    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        :param _builtins.str type: The type of asset source. Indicates external origin of the assets that are read by assigning this asset source.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of asset source. Indicates external origin of the assets that are read by assigning this asset source.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAssetSourcesAssetSourceCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetAssetSourcesAssetSourceCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAssetSourcesAssetSourceCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetAssetSourcesAssetSourceCollectionItemResult(dict):
    def __init__(__self__, *,
                 are_historical_metrics_collected: _builtins.bool,
                 are_realtime_metrics_collected: _builtins.bool,
                 assets_compartment_id: _builtins.str,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 discovery_credentials: Sequence['outputs.GetAssetSourcesAssetSourceCollectionItemDiscoveryCredentialResult'],
                 discovery_schedule_id: _builtins.str,
                 display_name: _builtins.str,
                 environment_id: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 inventory_id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 replication_credentials: Sequence['outputs.GetAssetSourcesAssetSourceCollectionItemReplicationCredentialResult'],
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 type: _builtins.str,
                 vcenter_endpoint: _builtins.str):
        """
        :param _builtins.bool are_historical_metrics_collected: Flag indicating whether historical metrics are collected for assets, originating from this asset source.
        :param _builtins.bool are_realtime_metrics_collected: Flag indicating whether real-time metrics are collected for assets, originating from this asset source.
        :param _builtins.str assets_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that is going to be used to create assets.
        :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, _builtins.str] defined_tags: The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Sequence['GetAssetSourcesAssetSourceCollectionItemDiscoveryCredentialArgs'] discovery_credentials: Credentials for an asset source.
        :param _builtins.str discovery_schedule_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of an attached discovery schedule.
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param _builtins.str environment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the environment.
        :param Mapping[str, _builtins.str] freeform_tags: The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        :param _builtins.str inventory_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the inventory that will contain created assets.
        :param _builtins.str lifecycle_details: The detailed state of the asset source.
        :param Sequence['GetAssetSourcesAssetSourceCollectionItemReplicationCredentialArgs'] replication_credentials: Credentials for an asset source.
        :param _builtins.str state: The current state of the asset source.
        :param Mapping[str, _builtins.str] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param _builtins.str time_created: The time when the asset source was created in the RFC3339 format.
        :param _builtins.str time_updated: The point in time that the asset source was last updated in the RFC3339 format.
        :param _builtins.str type: The type of asset source. Indicates external origin of the assets that are read by assigning this asset source.
        :param _builtins.str vcenter_endpoint: Endpoint for VMware asset discovery and replication in the form of ```https://<host>:<port>/sdk```
        """
        pulumi.set(__self__, "are_historical_metrics_collected", are_historical_metrics_collected)
        pulumi.set(__self__, "are_realtime_metrics_collected", are_realtime_metrics_collected)
        pulumi.set(__self__, "assets_compartment_id", assets_compartment_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "discovery_credentials", discovery_credentials)
        pulumi.set(__self__, "discovery_schedule_id", discovery_schedule_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inventory_id", inventory_id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "replication_credentials", replication_credentials)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vcenter_endpoint", vcenter_endpoint)

    @_builtins.property
    @pulumi.getter(name="areHistoricalMetricsCollected")
    def are_historical_metrics_collected(self) -> _builtins.bool:
        """
        Flag indicating whether historical metrics are collected for assets, originating from this asset source.
        """
        return pulumi.get(self, "are_historical_metrics_collected")

    @_builtins.property
    @pulumi.getter(name="areRealtimeMetricsCollected")
    def are_realtime_metrics_collected(self) -> _builtins.bool:
        """
        Flag indicating whether real-time metrics are collected for assets, originating from this asset source.
        """
        return pulumi.get(self, "are_realtime_metrics_collected")

    @_builtins.property
    @pulumi.getter(name="assetsCompartmentId")
    def assets_compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that is going to be used to create assets.
        """
        return pulumi.get(self, "assets_compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="discoveryCredentials")
    def discovery_credentials(self) -> Sequence['outputs.GetAssetSourcesAssetSourceCollectionItemDiscoveryCredentialResult']:
        """
        Credentials for an asset source.
        """
        return pulumi.get(self, "discovery_credentials")

    @_builtins.property
    @pulumi.getter(name="discoveryScheduleId")
    def discovery_schedule_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of an attached discovery schedule.
        """
        return pulumi.get(self, "discovery_schedule_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the environment.
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inventoryId")
    def inventory_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the inventory that will contain created assets.
        """
        return pulumi.get(self, "inventory_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        The detailed state of the asset source.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="replicationCredentials")
    def replication_credentials(self) -> Sequence['outputs.GetAssetSourcesAssetSourceCollectionItemReplicationCredentialResult']:
        """
        Credentials for an asset source.
        """
        return pulumi.get(self, "replication_credentials")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the asset source.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the asset source was created in the RFC3339 format.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The point in time that the asset source was last updated in the RFC3339 format.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of asset source. Indicates external origin of the assets that are read by assigning this asset source.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vcenterEndpoint")
    def vcenter_endpoint(self) -> _builtins.str:
        """
        Endpoint for VMware asset discovery and replication in the form of ```https://<host>:<port>/sdk```
        """
        return pulumi.get(self, "vcenter_endpoint")


@pulumi.output_type
class GetAssetSourcesAssetSourceCollectionItemDiscoveryCredentialResult(dict):
    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        :param _builtins.str type: The type of asset source. Indicates external origin of the assets that are read by assigning this asset source.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of asset source. Indicates external origin of the assets that are read by assigning this asset source.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAssetSourcesAssetSourceCollectionItemReplicationCredentialResult(dict):
    def __init__(__self__, *,
                 secret_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        :param _builtins.str type: The type of asset source. Indicates external origin of the assets that are read by assigning this asset source.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of asset source. Indicates external origin of the assets that are read by assigning this asset source.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAssetSourcesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetAssetVmResult(dict):
    def __init__(__self__, *,
                 hypervisor_host: _builtins.str,
                 hypervisor_vendor: _builtins.str,
                 hypervisor_version: _builtins.str):
        """
        :param _builtins.str hypervisor_host: Host name/IP address of VM on which the host is running.
        :param _builtins.str hypervisor_vendor: Hypervisor vendor.
        :param _builtins.str hypervisor_version: Hypervisor version.
        """
        pulumi.set(__self__, "hypervisor_host", hypervisor_host)
        pulumi.set(__self__, "hypervisor_vendor", hypervisor_vendor)
        pulumi.set(__self__, "hypervisor_version", hypervisor_version)

    @_builtins.property
    @pulumi.getter(name="hypervisorHost")
    def hypervisor_host(self) -> _builtins.str:
        """
        Host name/IP address of VM on which the host is running.
        """
        return pulumi.get(self, "hypervisor_host")

    @_builtins.property
    @pulumi.getter(name="hypervisorVendor")
    def hypervisor_vendor(self) -> _builtins.str:
        """
        Hypervisor vendor.
        """
        return pulumi.get(self, "hypervisor_vendor")

    @_builtins.property
    @pulumi.getter(name="hypervisorVersion")
    def hypervisor_version(self) -> _builtins.str:
        """
        Hypervisor version.
        """
        return pulumi.get(self, "hypervisor_version")


@pulumi.output_type
class GetAssetVmwareVcenterResult(dict):
    def __init__(__self__, *,
                 data_center: _builtins.str,
                 vcenter_key: _builtins.str,
                 vcenter_version: _builtins.str):
        """
        :param _builtins.str data_center: Data center name.
        :param _builtins.str vcenter_key: vCenter unique key.
        :param _builtins.str vcenter_version: Dot-separated version string.
        """
        pulumi.set(__self__, "data_center", data_center)
        pulumi.set(__self__, "vcenter_key", vcenter_key)
        pulumi.set(__self__, "vcenter_version", vcenter_version)

    @_builtins.property
    @pulumi.getter(name="dataCenter")
    def data_center(self) -> _builtins.str:
        """
        Data center name.
        """
        return pulumi.get(self, "data_center")

    @_builtins.property
    @pulumi.getter(name="vcenterKey")
    def vcenter_key(self) -> _builtins.str:
        """
        vCenter unique key.
        """
        return pulumi.get(self, "vcenter_key")

    @_builtins.property
    @pulumi.getter(name="vcenterVersion")
    def vcenter_version(self) -> _builtins.str:
        """
        Dot-separated version string.
        """
        return pulumi.get(self, "vcenter_version")


@pulumi.output_type
class GetAssetVmwareVmResult(dict):
    def __init__(__self__, *,
                 cluster: _builtins.str,
                 customer_fields: Sequence[_builtins.str],
                 customer_tags: Sequence['outputs.GetAssetVmwareVmCustomerTagResult'],
                 fault_tolerance_bandwidth: _builtins.int,
                 fault_tolerance_secondary_latency: _builtins.int,
                 fault_tolerance_state: _builtins.str,
                 instance_uuid: _builtins.str,
                 is_disks_cbt_enabled: _builtins.bool,
                 is_disks_uuid_enabled: _builtins.bool,
                 path: _builtins.str,
                 vmware_tools_status: _builtins.str):
        """
        :param _builtins.str cluster: Cluster name.
        :param Sequence[_builtins.str] customer_fields: Customer fields.
        :param Sequence['GetAssetVmwareVmCustomerTagArgs'] customer_tags: Customer defined tags.
        :param _builtins.int fault_tolerance_bandwidth: Fault tolerance bandwidth.
        :param _builtins.int fault_tolerance_secondary_latency: Fault tolerance to secondary latency.
        :param _builtins.str fault_tolerance_state: Fault tolerance state.
        :param _builtins.str instance_uuid: vCenter-specific identifier of the virtual machine.
        :param _builtins.bool is_disks_cbt_enabled: Indicates that change tracking is supported for virtual disks of this virtual machine. However, even if change tracking is supported, it might not be available for all disks of the virtual machine.
        :param _builtins.bool is_disks_uuid_enabled: Whether changed block tracking for this VM's disk is active.
        :param _builtins.str path: Path directory of the asset.
        :param _builtins.str vmware_tools_status: VMware tools status.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "customer_fields", customer_fields)
        pulumi.set(__self__, "customer_tags", customer_tags)
        pulumi.set(__self__, "fault_tolerance_bandwidth", fault_tolerance_bandwidth)
        pulumi.set(__self__, "fault_tolerance_secondary_latency", fault_tolerance_secondary_latency)
        pulumi.set(__self__, "fault_tolerance_state", fault_tolerance_state)
        pulumi.set(__self__, "instance_uuid", instance_uuid)
        pulumi.set(__self__, "is_disks_cbt_enabled", is_disks_cbt_enabled)
        pulumi.set(__self__, "is_disks_uuid_enabled", is_disks_uuid_enabled)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "vmware_tools_status", vmware_tools_status)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> _builtins.str:
        """
        Cluster name.
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter(name="customerFields")
    def customer_fields(self) -> Sequence[_builtins.str]:
        """
        Customer fields.
        """
        return pulumi.get(self, "customer_fields")

    @_builtins.property
    @pulumi.getter(name="customerTags")
    def customer_tags(self) -> Sequence['outputs.GetAssetVmwareVmCustomerTagResult']:
        """
        Customer defined tags.
        """
        return pulumi.get(self, "customer_tags")

    @_builtins.property
    @pulumi.getter(name="faultToleranceBandwidth")
    def fault_tolerance_bandwidth(self) -> _builtins.int:
        """
        Fault tolerance bandwidth.
        """
        return pulumi.get(self, "fault_tolerance_bandwidth")

    @_builtins.property
    @pulumi.getter(name="faultToleranceSecondaryLatency")
    def fault_tolerance_secondary_latency(self) -> _builtins.int:
        """
        Fault tolerance to secondary latency.
        """
        return pulumi.get(self, "fault_tolerance_secondary_latency")

    @_builtins.property
    @pulumi.getter(name="faultToleranceState")
    def fault_tolerance_state(self) -> _builtins.str:
        """
        Fault tolerance state.
        """
        return pulumi.get(self, "fault_tolerance_state")

    @_builtins.property
    @pulumi.getter(name="instanceUuid")
    def instance_uuid(self) -> _builtins.str:
        """
        vCenter-specific identifier of the virtual machine.
        """
        return pulumi.get(self, "instance_uuid")

    @_builtins.property
    @pulumi.getter(name="isDisksCbtEnabled")
    def is_disks_cbt_enabled(self) -> _builtins.bool:
        """
        Indicates that change tracking is supported for virtual disks of this virtual machine. However, even if change tracking is supported, it might not be available for all disks of the virtual machine.
        """
        return pulumi.get(self, "is_disks_cbt_enabled")

    @_builtins.property
    @pulumi.getter(name="isDisksUuidEnabled")
    def is_disks_uuid_enabled(self) -> _builtins.bool:
        """
        Whether changed block tracking for this VM's disk is active.
        """
        return pulumi.get(self, "is_disks_uuid_enabled")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path directory of the asset.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="vmwareToolsStatus")
    def vmware_tools_status(self) -> _builtins.str:
        """
        VMware tools status.
        """
        return pulumi.get(self, "vmware_tools_status")


@pulumi.output_type
class GetAssetVmwareVmCustomerTagResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str description: The tag description.
        :param _builtins.str name: The tag name.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The tag description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The tag name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAssetsAssetCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetAssetsAssetCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAssetsAssetCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetAssetsAssetCollectionItemResult(dict):
    def __init__(__self__, *,
                 asset_source_ids: Sequence[_builtins.str],
                 asset_type: _builtins.str,
                 compartment_id: _builtins.str,
                 computes: Sequence['outputs.GetAssetsAssetCollectionItemComputeResult'],
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 external_asset_key: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 inventory_id: _builtins.str,
                 source_key: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 vms: Sequence['outputs.GetAssetsAssetCollectionItemVmResult'],
                 vmware_vcenters: Sequence['outputs.GetAssetsAssetCollectionItemVmwareVcenterResult'],
                 vmware_vms: Sequence['outputs.GetAssetsAssetCollectionItemVmwareVmResult']):
        """
        :param Sequence[_builtins.str] asset_source_ids: List of asset source OCID.
        :param _builtins.str asset_type: The type of asset.
        :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence['GetAssetsAssetCollectionItemComputeArgs'] computes: Compute related properties.
        :param Mapping[str, _builtins.str] defined_tags: The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param _builtins.str external_asset_key: External asset key.
        :param Mapping[str, _builtins.str] freeform_tags: The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: Asset OCID that is immutable on creation.
        :param _builtins.str inventory_id: Unique Inventory identifier.
        :param _builtins.str source_key: Source key from where the assets originate.
        :param _builtins.str state: A filter to return only assets whose lifecycleState matches the given lifecycleState.
        :param Mapping[str, _builtins.str] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param _builtins.str time_created: The time when the asset was created. An RFC3339 formatted datetime string.
        :param _builtins.str time_updated: The time when the asset was updated. An RFC3339 formatted datetime string.
        :param Sequence['GetAssetsAssetCollectionItemVmArgs'] vms: Virtual machine related properties.
        :param Sequence['GetAssetsAssetCollectionItemVmwareVcenterArgs'] vmware_vcenters: VMware vCenter related properties.
        :param Sequence['GetAssetsAssetCollectionItemVmwareVmArgs'] vmware_vms: VMware virtual machine related properties.
        """
        pulumi.set(__self__, "asset_source_ids", asset_source_ids)
        pulumi.set(__self__, "asset_type", asset_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "computes", computes)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "external_asset_key", external_asset_key)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inventory_id", inventory_id)
        pulumi.set(__self__, "source_key", source_key)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "vms", vms)
        pulumi.set(__self__, "vmware_vcenters", vmware_vcenters)
        pulumi.set(__self__, "vmware_vms", vmware_vms)

    @_builtins.property
    @pulumi.getter(name="assetSourceIds")
    def asset_source_ids(self) -> Sequence[_builtins.str]:
        """
        List of asset source OCID.
        """
        return pulumi.get(self, "asset_source_ids")

    @_builtins.property
    @pulumi.getter(name="assetType")
    def asset_type(self) -> _builtins.str:
        """
        The type of asset.
        """
        return pulumi.get(self, "asset_type")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def computes(self) -> Sequence['outputs.GetAssetsAssetCollectionItemComputeResult']:
        """
        Compute related properties.
        """
        return pulumi.get(self, "computes")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalAssetKey")
    def external_asset_key(self) -> _builtins.str:
        """
        External asset key.
        """
        return pulumi.get(self, "external_asset_key")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Asset OCID that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inventoryId")
    def inventory_id(self) -> _builtins.str:
        """
        Unique Inventory identifier.
        """
        return pulumi.get(self, "inventory_id")

    @_builtins.property
    @pulumi.getter(name="sourceKey")
    def source_key(self) -> _builtins.str:
        """
        Source key from where the assets originate.
        """
        return pulumi.get(self, "source_key")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only assets whose lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the asset was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when the asset was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def vms(self) -> Sequence['outputs.GetAssetsAssetCollectionItemVmResult']:
        """
        Virtual machine related properties.
        """
        return pulumi.get(self, "vms")

    @_builtins.property
    @pulumi.getter(name="vmwareVcenters")
    def vmware_vcenters(self) -> Sequence['outputs.GetAssetsAssetCollectionItemVmwareVcenterResult']:
        """
        VMware vCenter related properties.
        """
        return pulumi.get(self, "vmware_vcenters")

    @_builtins.property
    @pulumi.getter(name="vmwareVms")
    def vmware_vms(self) -> Sequence['outputs.GetAssetsAssetCollectionItemVmwareVmResult']:
        """
        VMware virtual machine related properties.
        """
        return pulumi.get(self, "vmware_vms")


@pulumi.output_type
class GetAssetsAssetCollectionItemComputeResult(dict):
    def __init__(__self__, *,
                 connected_networks: _builtins.int,
                 cores_count: _builtins.int,
                 cpu_model: _builtins.str,
                 description: _builtins.str,
                 disks: Sequence['outputs.GetAssetsAssetCollectionItemComputeDiskResult'],
                 disks_count: _builtins.int,
                 dns_name: _builtins.str,
                 firmware: _builtins.str,
                 gpu_devices: Sequence['outputs.GetAssetsAssetCollectionItemComputeGpuDeviceResult'],
                 gpu_devices_count: _builtins.int,
                 guest_state: _builtins.str,
                 hardware_version: _builtins.str,
                 host_name: _builtins.str,
                 is_pmem_enabled: _builtins.bool,
                 is_tpm_enabled: _builtins.bool,
                 latency_sensitivity: _builtins.str,
                 memory_in_mbs: _builtins.str,
                 nics: Sequence['outputs.GetAssetsAssetCollectionItemComputeNicResult'],
                 nics_count: _builtins.int,
                 nvdimm_controllers: Sequence['outputs.GetAssetsAssetCollectionItemComputeNvdimmControllerResult'],
                 nvdimms: Sequence['outputs.GetAssetsAssetCollectionItemComputeNvdimmResult'],
                 operating_system: _builtins.str,
                 operating_system_version: _builtins.str,
                 pmem_in_mbs: _builtins.str,
                 power_state: _builtins.str,
                 primary_ip: _builtins.str,
                 scsi_controllers: Sequence['outputs.GetAssetsAssetCollectionItemComputeScsiControllerResult'],
                 storage_provisioned_in_mbs: _builtins.str,
                 threads_per_core_count: _builtins.int):
        """
        :param _builtins.int connected_networks: Number of connected networks.
        :param _builtins.int cores_count: Number of GPU cores.
        :param _builtins.str cpu_model: CPU model name.
        :param _builtins.str description: The tag description.
        :param Sequence['GetAssetsAssetCollectionItemComputeDiskArgs'] disks: Lists the set of disks belonging to the virtual machine. This list is unordered.
        :param _builtins.int disks_count: Number of disks.
        :param _builtins.str dns_name: Fully Qualified DNS Name.
        :param _builtins.str firmware: Information about firmware type for this virtual machine.
        :param Sequence['GetAssetsAssetCollectionItemComputeGpuDeviceArgs'] gpu_devices: List of GPU devices attached to a virtual machine.
        :param _builtins.int gpu_devices_count: Number of GPU devices.
        :param _builtins.str guest_state: Guest state.
        :param _builtins.str hardware_version: Hardware version.
        :param _builtins.str host_name: Host name of the VM.
        :param _builtins.bool is_pmem_enabled: Whether Pmem is enabled. Decides if NVDIMMs are used as a permanent memory.
        :param _builtins.bool is_tpm_enabled: Whether Trusted Platform Module (TPM) is enabled.
        :param _builtins.str latency_sensitivity: Latency sensitivity.
        :param _builtins.str memory_in_mbs: Memory size in MBs.
        :param Sequence['GetAssetsAssetCollectionItemComputeNicArgs'] nics: List of network ethernet cards attached to a virtual machine.
        :param _builtins.int nics_count: Number of network ethernet cards.
        :param Sequence['GetAssetsAssetCollectionItemComputeNvdimmControllerArgs'] nvdimm_controllers: The asset's NVDIMM configuration.
        :param Sequence['GetAssetsAssetCollectionItemComputeNvdimmArgs'] nvdimms: The properties of the NVDIMMs attached to a virtual machine.
        :param _builtins.str operating_system: Operating system.
        :param _builtins.str operating_system_version: Operating system version.
        :param _builtins.str pmem_in_mbs: Pmem size in MBs.
        :param _builtins.str power_state: The current power state of the virtual machine.
        :param _builtins.str primary_ip: Primary IP address of the compute instance.
        :param Sequence['GetAssetsAssetCollectionItemComputeScsiControllerArgs'] scsi_controllers: The assets SCSI controller.
        :param _builtins.str storage_provisioned_in_mbs: Provision storage size in MBs.
        :param _builtins.int threads_per_core_count: Number of threads per core.
        """
        pulumi.set(__self__, "connected_networks", connected_networks)
        pulumi.set(__self__, "cores_count", cores_count)
        pulumi.set(__self__, "cpu_model", cpu_model)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disks", disks)
        pulumi.set(__self__, "disks_count", disks_count)
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "firmware", firmware)
        pulumi.set(__self__, "gpu_devices", gpu_devices)
        pulumi.set(__self__, "gpu_devices_count", gpu_devices_count)
        pulumi.set(__self__, "guest_state", guest_state)
        pulumi.set(__self__, "hardware_version", hardware_version)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "is_pmem_enabled", is_pmem_enabled)
        pulumi.set(__self__, "is_tpm_enabled", is_tpm_enabled)
        pulumi.set(__self__, "latency_sensitivity", latency_sensitivity)
        pulumi.set(__self__, "memory_in_mbs", memory_in_mbs)
        pulumi.set(__self__, "nics", nics)
        pulumi.set(__self__, "nics_count", nics_count)
        pulumi.set(__self__, "nvdimm_controllers", nvdimm_controllers)
        pulumi.set(__self__, "nvdimms", nvdimms)
        pulumi.set(__self__, "operating_system", operating_system)
        pulumi.set(__self__, "operating_system_version", operating_system_version)
        pulumi.set(__self__, "pmem_in_mbs", pmem_in_mbs)
        pulumi.set(__self__, "power_state", power_state)
        pulumi.set(__self__, "primary_ip", primary_ip)
        pulumi.set(__self__, "scsi_controllers", scsi_controllers)
        pulumi.set(__self__, "storage_provisioned_in_mbs", storage_provisioned_in_mbs)
        pulumi.set(__self__, "threads_per_core_count", threads_per_core_count)

    @_builtins.property
    @pulumi.getter(name="connectedNetworks")
    def connected_networks(self) -> _builtins.int:
        """
        Number of connected networks.
        """
        return pulumi.get(self, "connected_networks")

    @_builtins.property
    @pulumi.getter(name="coresCount")
    def cores_count(self) -> _builtins.int:
        """
        Number of GPU cores.
        """
        return pulumi.get(self, "cores_count")

    @_builtins.property
    @pulumi.getter(name="cpuModel")
    def cpu_model(self) -> _builtins.str:
        """
        CPU model name.
        """
        return pulumi.get(self, "cpu_model")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The tag description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.GetAssetsAssetCollectionItemComputeDiskResult']:
        """
        Lists the set of disks belonging to the virtual machine. This list is unordered.
        """
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter(name="disksCount")
    def disks_count(self) -> _builtins.int:
        """
        Number of disks.
        """
        return pulumi.get(self, "disks_count")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> _builtins.str:
        """
        Fully Qualified DNS Name.
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter
    def firmware(self) -> _builtins.str:
        """
        Information about firmware type for this virtual machine.
        """
        return pulumi.get(self, "firmware")

    @_builtins.property
    @pulumi.getter(name="gpuDevices")
    def gpu_devices(self) -> Sequence['outputs.GetAssetsAssetCollectionItemComputeGpuDeviceResult']:
        """
        List of GPU devices attached to a virtual machine.
        """
        return pulumi.get(self, "gpu_devices")

    @_builtins.property
    @pulumi.getter(name="gpuDevicesCount")
    def gpu_devices_count(self) -> _builtins.int:
        """
        Number of GPU devices.
        """
        return pulumi.get(self, "gpu_devices_count")

    @_builtins.property
    @pulumi.getter(name="guestState")
    def guest_state(self) -> _builtins.str:
        """
        Guest state.
        """
        return pulumi.get(self, "guest_state")

    @_builtins.property
    @pulumi.getter(name="hardwareVersion")
    def hardware_version(self) -> _builtins.str:
        """
        Hardware version.
        """
        return pulumi.get(self, "hardware_version")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> _builtins.str:
        """
        Host name of the VM.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="isPmemEnabled")
    def is_pmem_enabled(self) -> _builtins.bool:
        """
        Whether Pmem is enabled. Decides if NVDIMMs are used as a permanent memory.
        """
        return pulumi.get(self, "is_pmem_enabled")

    @_builtins.property
    @pulumi.getter(name="isTpmEnabled")
    def is_tpm_enabled(self) -> _builtins.bool:
        """
        Whether Trusted Platform Module (TPM) is enabled.
        """
        return pulumi.get(self, "is_tpm_enabled")

    @_builtins.property
    @pulumi.getter(name="latencySensitivity")
    def latency_sensitivity(self) -> _builtins.str:
        """
        Latency sensitivity.
        """
        return pulumi.get(self, "latency_sensitivity")

    @_builtins.property
    @pulumi.getter(name="memoryInMbs")
    def memory_in_mbs(self) -> _builtins.str:
        """
        Memory size in MBs.
        """
        return pulumi.get(self, "memory_in_mbs")

    @_builtins.property
    @pulumi.getter
    def nics(self) -> Sequence['outputs.GetAssetsAssetCollectionItemComputeNicResult']:
        """
        List of network ethernet cards attached to a virtual machine.
        """
        return pulumi.get(self, "nics")

    @_builtins.property
    @pulumi.getter(name="nicsCount")
    def nics_count(self) -> _builtins.int:
        """
        Number of network ethernet cards.
        """
        return pulumi.get(self, "nics_count")

    @_builtins.property
    @pulumi.getter(name="nvdimmControllers")
    def nvdimm_controllers(self) -> Sequence['outputs.GetAssetsAssetCollectionItemComputeNvdimmControllerResult']:
        """
        The asset's NVDIMM configuration.
        """
        return pulumi.get(self, "nvdimm_controllers")

    @_builtins.property
    @pulumi.getter
    def nvdimms(self) -> Sequence['outputs.GetAssetsAssetCollectionItemComputeNvdimmResult']:
        """
        The properties of the NVDIMMs attached to a virtual machine.
        """
        return pulumi.get(self, "nvdimms")

    @_builtins.property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> _builtins.str:
        """
        Operating system.
        """
        return pulumi.get(self, "operating_system")

    @_builtins.property
    @pulumi.getter(name="operatingSystemVersion")
    def operating_system_version(self) -> _builtins.str:
        """
        Operating system version.
        """
        return pulumi.get(self, "operating_system_version")

    @_builtins.property
    @pulumi.getter(name="pmemInMbs")
    def pmem_in_mbs(self) -> _builtins.str:
        """
        Pmem size in MBs.
        """
        return pulumi.get(self, "pmem_in_mbs")

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> _builtins.str:
        """
        The current power state of the virtual machine.
        """
        return pulumi.get(self, "power_state")

    @_builtins.property
    @pulumi.getter(name="primaryIp")
    def primary_ip(self) -> _builtins.str:
        """
        Primary IP address of the compute instance.
        """
        return pulumi.get(self, "primary_ip")

    @_builtins.property
    @pulumi.getter(name="scsiControllers")
    def scsi_controllers(self) -> Sequence['outputs.GetAssetsAssetCollectionItemComputeScsiControllerResult']:
        """
        The assets SCSI controller.
        """
        return pulumi.get(self, "scsi_controllers")

    @_builtins.property
    @pulumi.getter(name="storageProvisionedInMbs")
    def storage_provisioned_in_mbs(self) -> _builtins.str:
        """
        Provision storage size in MBs.
        """
        return pulumi.get(self, "storage_provisioned_in_mbs")

    @_builtins.property
    @pulumi.getter(name="threadsPerCoreCount")
    def threads_per_core_count(self) -> _builtins.int:
        """
        Number of threads per core.
        """
        return pulumi.get(self, "threads_per_core_count")


@pulumi.output_type
class GetAssetsAssetCollectionItemComputeDiskResult(dict):
    def __init__(__self__, *,
                 boot_order: _builtins.int,
                 location: _builtins.str,
                 name: _builtins.str,
                 persistent_mode: _builtins.str,
                 size_in_mbs: _builtins.str,
                 uuid: _builtins.str,
                 uuid_lun: _builtins.str):
        """
        :param _builtins.int boot_order: Order of boot volumes.
        :param _builtins.str location: Location of the boot/data volume.
        :param _builtins.str name: The tag name.
        :param _builtins.str persistent_mode: The disk persistent mode.
        :param _builtins.str size_in_mbs: The size of the volume in MBs.
        :param _builtins.str uuid: Disk UUID for the virtual disk, if available.
        :param _builtins.str uuid_lun: Disk UUID LUN for the virtual disk, if available.
        """
        pulumi.set(__self__, "boot_order", boot_order)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "persistent_mode", persistent_mode)
        pulumi.set(__self__, "size_in_mbs", size_in_mbs)
        pulumi.set(__self__, "uuid", uuid)
        pulumi.set(__self__, "uuid_lun", uuid_lun)

    @_builtins.property
    @pulumi.getter(name="bootOrder")
    def boot_order(self) -> _builtins.int:
        """
        Order of boot volumes.
        """
        return pulumi.get(self, "boot_order")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Location of the boot/data volume.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The tag name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="persistentMode")
    def persistent_mode(self) -> _builtins.str:
        """
        The disk persistent mode.
        """
        return pulumi.get(self, "persistent_mode")

    @_builtins.property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> _builtins.str:
        """
        The size of the volume in MBs.
        """
        return pulumi.get(self, "size_in_mbs")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        Disk UUID for the virtual disk, if available.
        """
        return pulumi.get(self, "uuid")

    @_builtins.property
    @pulumi.getter(name="uuidLun")
    def uuid_lun(self) -> _builtins.str:
        """
        Disk UUID LUN for the virtual disk, if available.
        """
        return pulumi.get(self, "uuid_lun")


@pulumi.output_type
class GetAssetsAssetCollectionItemComputeGpuDeviceResult(dict):
    def __init__(__self__, *,
                 cores_count: _builtins.int,
                 description: _builtins.str,
                 manufacturer: _builtins.str,
                 memory_in_mbs: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.int cores_count: Number of GPU cores.
        :param _builtins.str description: The tag description.
        :param _builtins.str manufacturer: The manufacturer of GPU.
        :param _builtins.str memory_in_mbs: Memory size in MBs.
        :param _builtins.str name: The tag name.
        """
        pulumi.set(__self__, "cores_count", cores_count)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "manufacturer", manufacturer)
        pulumi.set(__self__, "memory_in_mbs", memory_in_mbs)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="coresCount")
    def cores_count(self) -> _builtins.int:
        """
        Number of GPU cores.
        """
        return pulumi.get(self, "cores_count")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The tag description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def manufacturer(self) -> _builtins.str:
        """
        The manufacturer of GPU.
        """
        return pulumi.get(self, "manufacturer")

    @_builtins.property
    @pulumi.getter(name="memoryInMbs")
    def memory_in_mbs(self) -> _builtins.str:
        """
        Memory size in MBs.
        """
        return pulumi.get(self, "memory_in_mbs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The tag name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAssetsAssetCollectionItemComputeNicResult(dict):
    def __init__(__self__, *,
                 ip_addresses: Sequence[_builtins.str],
                 label: _builtins.str,
                 mac_address: _builtins.str,
                 mac_address_type: _builtins.str,
                 network_name: _builtins.str,
                 switch_name: _builtins.str):
        """
        :param Sequence[_builtins.str] ip_addresses: List of IP addresses.
        :param _builtins.str label: Provides a label and summary information for the device.
        :param _builtins.str mac_address: Mac address of the VM.
        :param _builtins.str mac_address_type: Mac address type.
        :param _builtins.str network_name: Network name.
        :param _builtins.str switch_name: Switch name.
        """
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "mac_address_type", mac_address_type)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "switch_name", switch_name)

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[_builtins.str]:
        """
        List of IP addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> _builtins.str:
        """
        Mac address of the VM.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="macAddressType")
    def mac_address_type(self) -> _builtins.str:
        """
        Mac address type.
        """
        return pulumi.get(self, "mac_address_type")

    @_builtins.property
    @pulumi.getter(name="networkName")
    def network_name(self) -> _builtins.str:
        """
        Network name.
        """
        return pulumi.get(self, "network_name")

    @_builtins.property
    @pulumi.getter(name="switchName")
    def switch_name(self) -> _builtins.str:
        """
        Switch name.
        """
        return pulumi.get(self, "switch_name")


@pulumi.output_type
class GetAssetsAssetCollectionItemComputeNvdimmResult(dict):
    def __init__(__self__, *,
                 controller_key: _builtins.int,
                 label: _builtins.str,
                 unit_number: _builtins.int):
        """
        :param _builtins.int controller_key: Controller key.
        :param _builtins.str label: Provides a label and summary information for the device.
        :param _builtins.int unit_number: The unit number of the SCSI controller.
        """
        pulumi.set(__self__, "controller_key", controller_key)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "unit_number", unit_number)

    @_builtins.property
    @pulumi.getter(name="controllerKey")
    def controller_key(self) -> _builtins.int:
        """
        Controller key.
        """
        return pulumi.get(self, "controller_key")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="unitNumber")
    def unit_number(self) -> _builtins.int:
        """
        The unit number of the SCSI controller.
        """
        return pulumi.get(self, "unit_number")


@pulumi.output_type
class GetAssetsAssetCollectionItemComputeNvdimmControllerResult(dict):
    def __init__(__self__, *,
                 bus_number: _builtins.int,
                 label: _builtins.str):
        """
        :param _builtins.int bus_number: Bus number.
        :param _builtins.str label: Provides a label and summary information for the device.
        """
        pulumi.set(__self__, "bus_number", bus_number)
        pulumi.set(__self__, "label", label)

    @_builtins.property
    @pulumi.getter(name="busNumber")
    def bus_number(self) -> _builtins.int:
        """
        Bus number.
        """
        return pulumi.get(self, "bus_number")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class GetAssetsAssetCollectionItemComputeScsiControllerResult(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 shared_bus: _builtins.str,
                 unit_number: _builtins.int):
        """
        :param _builtins.str label: Provides a label and summary information for the device.
        :param _builtins.str shared_bus: Shared bus.
        :param _builtins.int unit_number: The unit number of the SCSI controller.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "shared_bus", shared_bus)
        pulumi.set(__self__, "unit_number", unit_number)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="sharedBus")
    def shared_bus(self) -> _builtins.str:
        """
        Shared bus.
        """
        return pulumi.get(self, "shared_bus")

    @_builtins.property
    @pulumi.getter(name="unitNumber")
    def unit_number(self) -> _builtins.int:
        """
        The unit number of the SCSI controller.
        """
        return pulumi.get(self, "unit_number")


@pulumi.output_type
class GetAssetsAssetCollectionItemVmResult(dict):
    def __init__(__self__, *,
                 hypervisor_host: _builtins.str,
                 hypervisor_vendor: _builtins.str,
                 hypervisor_version: _builtins.str):
        """
        :param _builtins.str hypervisor_host: Host name/IP address of VM on which the host is running.
        :param _builtins.str hypervisor_vendor: Hypervisor vendor.
        :param _builtins.str hypervisor_version: Hypervisor version.
        """
        pulumi.set(__self__, "hypervisor_host", hypervisor_host)
        pulumi.set(__self__, "hypervisor_vendor", hypervisor_vendor)
        pulumi.set(__self__, "hypervisor_version", hypervisor_version)

    @_builtins.property
    @pulumi.getter(name="hypervisorHost")
    def hypervisor_host(self) -> _builtins.str:
        """
        Host name/IP address of VM on which the host is running.
        """
        return pulumi.get(self, "hypervisor_host")

    @_builtins.property
    @pulumi.getter(name="hypervisorVendor")
    def hypervisor_vendor(self) -> _builtins.str:
        """
        Hypervisor vendor.
        """
        return pulumi.get(self, "hypervisor_vendor")

    @_builtins.property
    @pulumi.getter(name="hypervisorVersion")
    def hypervisor_version(self) -> _builtins.str:
        """
        Hypervisor version.
        """
        return pulumi.get(self, "hypervisor_version")


@pulumi.output_type
class GetAssetsAssetCollectionItemVmwareVcenterResult(dict):
    def __init__(__self__, *,
                 data_center: _builtins.str,
                 vcenter_key: _builtins.str,
                 vcenter_version: _builtins.str):
        """
        :param _builtins.str data_center: Data center name.
        :param _builtins.str vcenter_key: vCenter unique key.
        :param _builtins.str vcenter_version: Dot-separated version string.
        """
        pulumi.set(__self__, "data_center", data_center)
        pulumi.set(__self__, "vcenter_key", vcenter_key)
        pulumi.set(__self__, "vcenter_version", vcenter_version)

    @_builtins.property
    @pulumi.getter(name="dataCenter")
    def data_center(self) -> _builtins.str:
        """
        Data center name.
        """
        return pulumi.get(self, "data_center")

    @_builtins.property
    @pulumi.getter(name="vcenterKey")
    def vcenter_key(self) -> _builtins.str:
        """
        vCenter unique key.
        """
        return pulumi.get(self, "vcenter_key")

    @_builtins.property
    @pulumi.getter(name="vcenterVersion")
    def vcenter_version(self) -> _builtins.str:
        """
        Dot-separated version string.
        """
        return pulumi.get(self, "vcenter_version")


@pulumi.output_type
class GetAssetsAssetCollectionItemVmwareVmResult(dict):
    def __init__(__self__, *,
                 cluster: _builtins.str,
                 customer_fields: Sequence[_builtins.str],
                 customer_tags: Sequence['outputs.GetAssetsAssetCollectionItemVmwareVmCustomerTagResult'],
                 fault_tolerance_bandwidth: _builtins.int,
                 fault_tolerance_secondary_latency: _builtins.int,
                 fault_tolerance_state: _builtins.str,
                 instance_uuid: _builtins.str,
                 is_disks_cbt_enabled: _builtins.bool,
                 is_disks_uuid_enabled: _builtins.bool,
                 path: _builtins.str,
                 vmware_tools_status: _builtins.str):
        """
        :param _builtins.str cluster: Cluster name.
        :param Sequence[_builtins.str] customer_fields: Customer fields.
        :param Sequence['GetAssetsAssetCollectionItemVmwareVmCustomerTagArgs'] customer_tags: Customer defined tags.
        :param _builtins.int fault_tolerance_bandwidth: Fault tolerance bandwidth.
        :param _builtins.int fault_tolerance_secondary_latency: Fault tolerance to secondary latency.
        :param _builtins.str fault_tolerance_state: Fault tolerance state.
        :param _builtins.str instance_uuid: vCenter-specific identifier of the virtual machine.
        :param _builtins.bool is_disks_cbt_enabled: Indicates that change tracking is supported for virtual disks of this virtual machine. However, even if change tracking is supported, it might not be available for all disks of the virtual machine.
        :param _builtins.bool is_disks_uuid_enabled: Whether changed block tracking for this VM's disk is active.
        :param _builtins.str path: Path directory of the asset.
        :param _builtins.str vmware_tools_status: VMware tools status.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "customer_fields", customer_fields)
        pulumi.set(__self__, "customer_tags", customer_tags)
        pulumi.set(__self__, "fault_tolerance_bandwidth", fault_tolerance_bandwidth)
        pulumi.set(__self__, "fault_tolerance_secondary_latency", fault_tolerance_secondary_latency)
        pulumi.set(__self__, "fault_tolerance_state", fault_tolerance_state)
        pulumi.set(__self__, "instance_uuid", instance_uuid)
        pulumi.set(__self__, "is_disks_cbt_enabled", is_disks_cbt_enabled)
        pulumi.set(__self__, "is_disks_uuid_enabled", is_disks_uuid_enabled)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "vmware_tools_status", vmware_tools_status)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> _builtins.str:
        """
        Cluster name.
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter(name="customerFields")
    def customer_fields(self) -> Sequence[_builtins.str]:
        """
        Customer fields.
        """
        return pulumi.get(self, "customer_fields")

    @_builtins.property
    @pulumi.getter(name="customerTags")
    def customer_tags(self) -> Sequence['outputs.GetAssetsAssetCollectionItemVmwareVmCustomerTagResult']:
        """
        Customer defined tags.
        """
        return pulumi.get(self, "customer_tags")

    @_builtins.property
    @pulumi.getter(name="faultToleranceBandwidth")
    def fault_tolerance_bandwidth(self) -> _builtins.int:
        """
        Fault tolerance bandwidth.
        """
        return pulumi.get(self, "fault_tolerance_bandwidth")

    @_builtins.property
    @pulumi.getter(name="faultToleranceSecondaryLatency")
    def fault_tolerance_secondary_latency(self) -> _builtins.int:
        """
        Fault tolerance to secondary latency.
        """
        return pulumi.get(self, "fault_tolerance_secondary_latency")

    @_builtins.property
    @pulumi.getter(name="faultToleranceState")
    def fault_tolerance_state(self) -> _builtins.str:
        """
        Fault tolerance state.
        """
        return pulumi.get(self, "fault_tolerance_state")

    @_builtins.property
    @pulumi.getter(name="instanceUuid")
    def instance_uuid(self) -> _builtins.str:
        """
        vCenter-specific identifier of the virtual machine.
        """
        return pulumi.get(self, "instance_uuid")

    @_builtins.property
    @pulumi.getter(name="isDisksCbtEnabled")
    def is_disks_cbt_enabled(self) -> _builtins.bool:
        """
        Indicates that change tracking is supported for virtual disks of this virtual machine. However, even if change tracking is supported, it might not be available for all disks of the virtual machine.
        """
        return pulumi.get(self, "is_disks_cbt_enabled")

    @_builtins.property
    @pulumi.getter(name="isDisksUuidEnabled")
    def is_disks_uuid_enabled(self) -> _builtins.bool:
        """
        Whether changed block tracking for this VM's disk is active.
        """
        return pulumi.get(self, "is_disks_uuid_enabled")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path directory of the asset.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="vmwareToolsStatus")
    def vmware_tools_status(self) -> _builtins.str:
        """
        VMware tools status.
        """
        return pulumi.get(self, "vmware_tools_status")


@pulumi.output_type
class GetAssetsAssetCollectionItemVmwareVmCustomerTagResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str description: The tag description.
        :param _builtins.str name: The tag name.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The tag description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The tag name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAssetsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The tag name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The tag name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDiscoverySchedulesDiscoveryScheduleCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDiscoverySchedulesDiscoveryScheduleCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDiscoverySchedulesDiscoveryScheduleCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDiscoverySchedulesDiscoveryScheduleCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 execution_recurrences: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, _builtins.str] defined_tags: The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param _builtins.str execution_recurrences: Recurrence specification for the discovery schedule execution.
        :param Mapping[str, _builtins.str] freeform_tags: The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the discovery schedule.
        :param _builtins.str lifecycle_details: The detailed state of the discovery schedule.
        :param _builtins.str state: The current state of the discovery schedule.
        :param Mapping[str, _builtins.str] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param _builtins.str time_created: The time when the discovery schedule was created in RFC3339 format.
        :param _builtins.str time_updated: The time when the discovery schedule was last updated in RFC3339 format.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "execution_recurrences", execution_recurrences)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="executionRecurrences")
    def execution_recurrences(self) -> _builtins.str:
        """
        Recurrence specification for the discovery schedule execution.
        """
        return pulumi.get(self, "execution_recurrences")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the discovery schedule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        The detailed state of the discovery schedule.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the discovery schedule.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the discovery schedule was created in RFC3339 format.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when the discovery schedule was last updated in RFC3339 format.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDiscoverySchedulesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetEnvironmentsEnvironmentCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetEnvironmentsEnvironmentCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetEnvironmentsEnvironmentCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetEnvironmentsEnvironmentCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, _builtins.str] defined_tags: The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, _builtins.str] freeform_tags: The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: Unique identifier that is immutable on creation.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param _builtins.str state: A filter to return only resources where their lifecycleState matches the given lifecycleState.
        :param Mapping[str, _builtins.str] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param _builtins.str time_created: The time when the source environment was created. An RFC3339 formatted datetime string.
        :param _builtins.str time_updated: The time when the source environment was updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources where their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the source environment was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when the source environment was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetEnvironmentsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetInventoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetInventoriesInventoryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetInventoriesInventoryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetInventoriesInventoryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetInventoriesInventoryCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, _builtins.str] defined_tags: The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: Inventory display name.
        :param Mapping[str, _builtins.str] freeform_tags: The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: Inventory OCID.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param _builtins.str state: A filter to return inventory if the lifecycleState matches the given lifecycleState.
        :param Mapping[str, _builtins.str] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param _builtins.str time_created: The time when the inventory was created. An RFC3339 formatted datetime string.
        :param _builtins.str time_updated: The time when the inventory was updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Inventory display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Inventory OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return inventory if the lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the inventory was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when the inventory was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


