# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetComputeHostGroupsResult',
    'AwaitableGetComputeHostGroupsResult',
    'get_compute_host_groups',
    'get_compute_host_groups_output',
]

@pulumi.output_type
class GetComputeHostGroupsResult:
    """
    A collection of values returned by getComputeHostGroups.
    """
    def __init__(__self__, compartment_id=None, compute_host_group_collections=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_host_group_collections and not isinstance(compute_host_group_collections, list):
            raise TypeError("Expected argument 'compute_host_group_collections' to be a list")
        pulumi.set(__self__, "compute_host_group_collections", compute_host_group_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment that contains host group.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="computeHostGroupCollections")
    def compute_host_group_collections(self) -> Sequence['outputs.GetComputeHostGroupsComputeHostGroupCollectionResult']:
        """
        The list of compute_host_group_collection.
        """
        return pulumi.get(self, "compute_host_group_collections")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetComputeHostGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetComputeHostGroupsResult(GetComputeHostGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeHostGroupsResult(
            compartment_id=self.compartment_id,
            compute_host_group_collections=self.compute_host_group_collections,
            filters=self.filters,
            id=self.id)


def get_compute_host_groups(compartment_id: Optional[_builtins.str] = None,
                            filters: Optional[Sequence[Union['GetComputeHostGroupsFilterArgs', 'GetComputeHostGroupsFilterArgsDict']]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeHostGroupsResult:
    """
    This data source provides the list of Compute Host Groups in Oracle Cloud Infrastructure Core service.

    Lists the compute host groups that match the specified criteria and compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_host_groups = oci.Core.get_compute_host_groups(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getComputeHostGroups:getComputeHostGroups', __args__, opts=opts, typ=GetComputeHostGroupsResult).value

    return AwaitableGetComputeHostGroupsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_host_group_collections=pulumi.get(__ret__, 'compute_host_group_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_compute_host_groups_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetComputeHostGroupsFilterArgs', 'GetComputeHostGroupsFilterArgsDict']]]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputeHostGroupsResult]:
    """
    This data source provides the list of Compute Host Groups in Oracle Cloud Infrastructure Core service.

    Lists the compute host groups that match the specified criteria and compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_host_groups = oci.Core.get_compute_host_groups(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getComputeHostGroups:getComputeHostGroups', __args__, opts=opts, typ=GetComputeHostGroupsResult)
    return __ret__.apply(lambda __response__: GetComputeHostGroupsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compute_host_group_collections=pulumi.get(__response__, 'compute_host_group_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
