# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSensitiveColumnAnalyticsResult',
    'AwaitableGetSensitiveColumnAnalyticsResult',
    'get_sensitive_column_analytics',
    'get_sensitive_column_analytics_output',
]

@pulumi.output_type
class GetSensitiveColumnAnalyticsResult:
    """
    A collection of values returned by getSensitiveColumnAnalytics.
    """
    def __init__(__self__, access_level=None, column_names=None, compartment_id=None, compartment_id_in_subtree=None, filters=None, group_bies=None, id=None, objects=None, schema_names=None, sensitive_column_analytics_collections=None, sensitive_data_model_id=None, sensitive_type_group_id=None, sensitive_type_ids=None, target_id=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if column_names and not isinstance(column_names, list):
            raise TypeError("Expected argument 'column_names' to be a list")
        pulumi.set(__self__, "column_names", column_names)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if group_bies and not isinstance(group_bies, list):
            raise TypeError("Expected argument 'group_bies' to be a list")
        pulumi.set(__self__, "group_bies", group_bies)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if objects and not isinstance(objects, list):
            raise TypeError("Expected argument 'objects' to be a list")
        pulumi.set(__self__, "objects", objects)
        if schema_names and not isinstance(schema_names, list):
            raise TypeError("Expected argument 'schema_names' to be a list")
        pulumi.set(__self__, "schema_names", schema_names)
        if sensitive_column_analytics_collections and not isinstance(sensitive_column_analytics_collections, list):
            raise TypeError("Expected argument 'sensitive_column_analytics_collections' to be a list")
        pulumi.set(__self__, "sensitive_column_analytics_collections", sensitive_column_analytics_collections)
        if sensitive_data_model_id and not isinstance(sensitive_data_model_id, str):
            raise TypeError("Expected argument 'sensitive_data_model_id' to be a str")
        pulumi.set(__self__, "sensitive_data_model_id", sensitive_data_model_id)
        if sensitive_type_group_id and not isinstance(sensitive_type_group_id, str):
            raise TypeError("Expected argument 'sensitive_type_group_id' to be a str")
        pulumi.set(__self__, "sensitive_type_group_id", sensitive_type_group_id)
        if sensitive_type_ids and not isinstance(sensitive_type_ids, list):
            raise TypeError("Expected argument 'sensitive_type_ids' to be a list")
        pulumi.set(__self__, "sensitive_type_ids", sensitive_type_ids)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        The name of the sensitive column.
        """
        return pulumi.get(self, "column_names")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSensitiveColumnAnalyticsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "group_bies")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def objects(self) -> Optional[Sequence[_builtins.str]]:
        """
        The database object that contains the sensitive column.
        """
        return pulumi.get(self, "objects")

    @_builtins.property
    @pulumi.getter(name="schemaNames")
    def schema_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        The database schema that contains the sensitive column.
        """
        return pulumi.get(self, "schema_names")

    @_builtins.property
    @pulumi.getter(name="sensitiveColumnAnalyticsCollections")
    def sensitive_column_analytics_collections(self) -> Sequence['outputs.GetSensitiveColumnAnalyticsSensitiveColumnAnalyticsCollectionResult']:
        """
        The list of sensitive_column_analytics_collection.
        """
        return pulumi.get(self, "sensitive_column_analytics_collections")

    @_builtins.property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the sensitive data model which contains the sensitive column.
        """
        return pulumi.get(self, "sensitive_data_model_id")

    @_builtins.property
    @pulumi.getter(name="sensitiveTypeGroupId")
    def sensitive_type_group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sensitive_type_group_id")

    @_builtins.property
    @pulumi.getter(name="sensitiveTypeIds")
    def sensitive_type_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        The OCID of the sensitive type associated with the sensitive column.
        """
        return pulumi.get(self, "sensitive_type_ids")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the target database associated with the sensitive column.
        """
        return pulumi.get(self, "target_id")


class AwaitableGetSensitiveColumnAnalyticsResult(GetSensitiveColumnAnalyticsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSensitiveColumnAnalyticsResult(
            access_level=self.access_level,
            column_names=self.column_names,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            group_bies=self.group_bies,
            id=self.id,
            objects=self.objects,
            schema_names=self.schema_names,
            sensitive_column_analytics_collections=self.sensitive_column_analytics_collections,
            sensitive_data_model_id=self.sensitive_data_model_id,
            sensitive_type_group_id=self.sensitive_type_group_id,
            sensitive_type_ids=self.sensitive_type_ids,
            target_id=self.target_id)


def get_sensitive_column_analytics(access_level: Optional[_builtins.str] = None,
                                   column_names: Optional[Sequence[_builtins.str]] = None,
                                   compartment_id: Optional[_builtins.str] = None,
                                   compartment_id_in_subtree: Optional[_builtins.bool] = None,
                                   filters: Optional[Sequence[Union['GetSensitiveColumnAnalyticsFilterArgs', 'GetSensitiveColumnAnalyticsFilterArgsDict']]] = None,
                                   group_bies: Optional[Sequence[_builtins.str]] = None,
                                   objects: Optional[Sequence[_builtins.str]] = None,
                                   schema_names: Optional[Sequence[_builtins.str]] = None,
                                   sensitive_data_model_id: Optional[_builtins.str] = None,
                                   sensitive_type_group_id: Optional[_builtins.str] = None,
                                   sensitive_type_ids: Optional[Sequence[_builtins.str]] = None,
                                   target_id: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSensitiveColumnAnalyticsResult:
    """
    This data source provides the list of Sensitive Column Analytics in Oracle Cloud Infrastructure Data Safe service.

    Gets consolidated sensitive columns analytics data based on the specified query parameters.

    When you perform the ListSensitiveColumnAnalytics operation, if the parameter compartmentIdInSubtree is set to "true," and if the
    parameter accessLevel is set to ACCESSIBLE, then the operation returns compartments in which the requestor has INSPECT
    permissions on at least one resource, directly or indirectly (in subcompartments). If the operation is performed at the
    root compartment and the requestor does not have access to at least one subcompartment of the compartment specified by
    compartmentId, then "Not Authorized" is returned.

    To use ListSensitiveColumnAnalytics to get a full list of all compartments and subcompartments in the tenancy from the root compartment,
    set the parameter compartmentIdInSubtree to true and accessLevel to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_column_analytics = oci.DataSafe.get_sensitive_column_analytics(compartment_id=compartment_id,
        access_level=sensitive_column_analytic_access_level,
        column_names=sensitive_column_analytic_column_name,
        compartment_id_in_subtree=sensitive_column_analytic_compartment_id_in_subtree,
        group_bies=sensitive_column_analytic_group_by,
        objects=sensitive_column_analytic_object,
        schema_names=sensitive_column_analytic_schema_name,
        sensitive_data_model_id=test_sensitive_data_model["id"],
        sensitive_type_group_id=test_sensitive_type_group["id"],
        sensitive_type_ids=test_sensitive_type["id"],
        target_id=test_target["id"])
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param Sequence[_builtins.str] column_names: A filter to return only a specific column based on column name.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param Sequence[_builtins.str] group_bies: The group by parameter to summarize the sensitive columns.
    :param Sequence[_builtins.str] objects: A filter to return only items related to a specific object name.
    :param Sequence[_builtins.str] schema_names: A filter to return only items related to specific schema name.
    :param _builtins.str sensitive_data_model_id: A filter to return only the resources that match the specified sensitive data model OCID.
    :param _builtins.str sensitive_type_group_id: An optional filter to return only resources that match the specified OCID of the sensitive type group resource.
    :param Sequence[_builtins.str] sensitive_type_ids: A filter to return only the sensitive columns that are associated with one of the sensitive types identified by the specified OCIDs.
    :param _builtins.str target_id: A filter to return only items related to a specific target OCID.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['columnNames'] = column_names
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['groupBies'] = group_bies
    __args__['objects'] = objects
    __args__['schemaNames'] = schema_names
    __args__['sensitiveDataModelId'] = sensitive_data_model_id
    __args__['sensitiveTypeGroupId'] = sensitive_type_group_id
    __args__['sensitiveTypeIds'] = sensitive_type_ids
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSensitiveColumnAnalytics:getSensitiveColumnAnalytics', __args__, opts=opts, typ=GetSensitiveColumnAnalyticsResult).value

    return AwaitableGetSensitiveColumnAnalyticsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        column_names=pulumi.get(__ret__, 'column_names'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        group_bies=pulumi.get(__ret__, 'group_bies'),
        id=pulumi.get(__ret__, 'id'),
        objects=pulumi.get(__ret__, 'objects'),
        schema_names=pulumi.get(__ret__, 'schema_names'),
        sensitive_column_analytics_collections=pulumi.get(__ret__, 'sensitive_column_analytics_collections'),
        sensitive_data_model_id=pulumi.get(__ret__, 'sensitive_data_model_id'),
        sensitive_type_group_id=pulumi.get(__ret__, 'sensitive_type_group_id'),
        sensitive_type_ids=pulumi.get(__ret__, 'sensitive_type_ids'),
        target_id=pulumi.get(__ret__, 'target_id'))
def get_sensitive_column_analytics_output(access_level: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          column_names: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                          compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSensitiveColumnAnalyticsFilterArgs', 'GetSensitiveColumnAnalyticsFilterArgsDict']]]]] = None,
                                          group_bies: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                          objects: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                          schema_names: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                          sensitive_data_model_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          sensitive_type_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          sensitive_type_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                          target_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSensitiveColumnAnalyticsResult]:
    """
    This data source provides the list of Sensitive Column Analytics in Oracle Cloud Infrastructure Data Safe service.

    Gets consolidated sensitive columns analytics data based on the specified query parameters.

    When you perform the ListSensitiveColumnAnalytics operation, if the parameter compartmentIdInSubtree is set to "true," and if the
    parameter accessLevel is set to ACCESSIBLE, then the operation returns compartments in which the requestor has INSPECT
    permissions on at least one resource, directly or indirectly (in subcompartments). If the operation is performed at the
    root compartment and the requestor does not have access to at least one subcompartment of the compartment specified by
    compartmentId, then "Not Authorized" is returned.

    To use ListSensitiveColumnAnalytics to get a full list of all compartments and subcompartments in the tenancy from the root compartment,
    set the parameter compartmentIdInSubtree to true and accessLevel to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_column_analytics = oci.DataSafe.get_sensitive_column_analytics(compartment_id=compartment_id,
        access_level=sensitive_column_analytic_access_level,
        column_names=sensitive_column_analytic_column_name,
        compartment_id_in_subtree=sensitive_column_analytic_compartment_id_in_subtree,
        group_bies=sensitive_column_analytic_group_by,
        objects=sensitive_column_analytic_object,
        schema_names=sensitive_column_analytic_schema_name,
        sensitive_data_model_id=test_sensitive_data_model["id"],
        sensitive_type_group_id=test_sensitive_type_group["id"],
        sensitive_type_ids=test_sensitive_type["id"],
        target_id=test_target["id"])
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param Sequence[_builtins.str] column_names: A filter to return only a specific column based on column name.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param Sequence[_builtins.str] group_bies: The group by parameter to summarize the sensitive columns.
    :param Sequence[_builtins.str] objects: A filter to return only items related to a specific object name.
    :param Sequence[_builtins.str] schema_names: A filter to return only items related to specific schema name.
    :param _builtins.str sensitive_data_model_id: A filter to return only the resources that match the specified sensitive data model OCID.
    :param _builtins.str sensitive_type_group_id: An optional filter to return only resources that match the specified OCID of the sensitive type group resource.
    :param Sequence[_builtins.str] sensitive_type_ids: A filter to return only the sensitive columns that are associated with one of the sensitive types identified by the specified OCIDs.
    :param _builtins.str target_id: A filter to return only items related to a specific target OCID.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['columnNames'] = column_names
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['groupBies'] = group_bies
    __args__['objects'] = objects
    __args__['schemaNames'] = schema_names
    __args__['sensitiveDataModelId'] = sensitive_data_model_id
    __args__['sensitiveTypeGroupId'] = sensitive_type_group_id
    __args__['sensitiveTypeIds'] = sensitive_type_ids
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSensitiveColumnAnalytics:getSensitiveColumnAnalytics', __args__, opts=opts, typ=GetSensitiveColumnAnalyticsResult)
    return __ret__.apply(lambda __response__: GetSensitiveColumnAnalyticsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        column_names=pulumi.get(__response__, 'column_names'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        group_bies=pulumi.get(__response__, 'group_bies'),
        id=pulumi.get(__response__, 'id'),
        objects=pulumi.get(__response__, 'objects'),
        schema_names=pulumi.get(__response__, 'schema_names'),
        sensitive_column_analytics_collections=pulumi.get(__response__, 'sensitive_column_analytics_collections'),
        sensitive_data_model_id=pulumi.get(__response__, 'sensitive_data_model_id'),
        sensitive_type_group_id=pulumi.get(__response__, 'sensitive_type_group_id'),
        sensitive_type_ids=pulumi.get(__response__, 'sensitive_type_ids'),
        target_id=pulumi.get(__response__, 'target_id')))
