# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFleetExportSettingResult',
    'AwaitableGetFleetExportSettingResult',
    'get_fleet_export_setting',
    'get_fleet_export_setting_output',
]

@pulumi.output_type
class GetFleetExportSettingResult:
    """
    A collection of values returned by getFleetExportSetting.
    """
    def __init__(__self__, export_duration=None, export_frequency=None, export_resources=None, export_setting_key=None, fleet_id=None, id=None, is_cross_region_acknowledged=None, is_enabled=None, target_bucket_name=None, target_bucket_namespace=None, target_bucket_region=None, time_created=None, time_last_modified=None):
        if export_duration and not isinstance(export_duration, str):
            raise TypeError("Expected argument 'export_duration' to be a str")
        pulumi.set(__self__, "export_duration", export_duration)
        if export_frequency and not isinstance(export_frequency, str):
            raise TypeError("Expected argument 'export_frequency' to be a str")
        pulumi.set(__self__, "export_frequency", export_frequency)
        if export_resources and not isinstance(export_resources, str):
            raise TypeError("Expected argument 'export_resources' to be a str")
        pulumi.set(__self__, "export_resources", export_resources)
        if export_setting_key and not isinstance(export_setting_key, str):
            raise TypeError("Expected argument 'export_setting_key' to be a str")
        pulumi.set(__self__, "export_setting_key", export_setting_key)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_cross_region_acknowledged and not isinstance(is_cross_region_acknowledged, bool):
            raise TypeError("Expected argument 'is_cross_region_acknowledged' to be a bool")
        pulumi.set(__self__, "is_cross_region_acknowledged", is_cross_region_acknowledged)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if target_bucket_name and not isinstance(target_bucket_name, str):
            raise TypeError("Expected argument 'target_bucket_name' to be a str")
        pulumi.set(__self__, "target_bucket_name", target_bucket_name)
        if target_bucket_namespace and not isinstance(target_bucket_namespace, str):
            raise TypeError("Expected argument 'target_bucket_namespace' to be a str")
        pulumi.set(__self__, "target_bucket_namespace", target_bucket_namespace)
        if target_bucket_region and not isinstance(target_bucket_region, str):
            raise TypeError("Expected argument 'target_bucket_region' to be a str")
        pulumi.set(__self__, "target_bucket_region", target_bucket_region)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_modified and not isinstance(time_last_modified, str):
            raise TypeError("Expected argument 'time_last_modified' to be a str")
        pulumi.set(__self__, "time_last_modified", time_last_modified)

    @_builtins.property
    @pulumi.getter(name="exportDuration")
    def export_duration(self) -> _builtins.str:
        """
        The duration of data to be exported for fleets.
        """
        return pulumi.get(self, "export_duration")

    @_builtins.property
    @pulumi.getter(name="exportFrequency")
    def export_frequency(self) -> _builtins.str:
        """
        Schedule at which data will be exported.
        """
        return pulumi.get(self, "export_frequency")

    @_builtins.property
    @pulumi.getter(name="exportResources")
    def export_resources(self) -> _builtins.str:
        """
        Resource to export data associated from the fleets.
        """
        return pulumi.get(self, "export_resources")

    @_builtins.property
    @pulumi.getter(name="exportSettingKey")
    def export_setting_key(self) -> _builtins.str:
        """
        The internal identifier of the export setting.
        """
        return pulumi.get(self, "export_setting_key")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the fleet.
        """
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isCrossRegionAcknowledged")
    def is_cross_region_acknowledged(self) -> _builtins.bool:
        """
        Acknowledgement for cross region target bucket configuration.
        """
        return pulumi.get(self, "is_cross_region_acknowledged")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        ExportSetting flag to store enabled or disabled status.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="targetBucketName")
    def target_bucket_name(self) -> _builtins.str:
        """
        The name of the bucket where data will be exported.
        """
        return pulumi.get(self, "target_bucket_name")

    @_builtins.property
    @pulumi.getter(name="targetBucketNamespace")
    def target_bucket_namespace(self) -> _builtins.str:
        """
        The namespace of the bucket where data will be exported.
        """
        return pulumi.get(self, "target_bucket_namespace")

    @_builtins.property
    @pulumi.getter(name="targetBucketRegion")
    def target_bucket_region(self) -> _builtins.str:
        """
        The id of the region of the target bucket.
        """
        return pulumi.get(self, "target_bucket_region")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The creation date and time of the export setting (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> _builtins.str:
        """
        The update date and time of the export setting (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_last_modified")


class AwaitableGetFleetExportSettingResult(GetFleetExportSettingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetExportSettingResult(
            export_duration=self.export_duration,
            export_frequency=self.export_frequency,
            export_resources=self.export_resources,
            export_setting_key=self.export_setting_key,
            fleet_id=self.fleet_id,
            id=self.id,
            is_cross_region_acknowledged=self.is_cross_region_acknowledged,
            is_enabled=self.is_enabled,
            target_bucket_name=self.target_bucket_name,
            target_bucket_namespace=self.target_bucket_namespace,
            target_bucket_region=self.target_bucket_region,
            time_created=self.time_created,
            time_last_modified=self.time_last_modified)


def get_fleet_export_setting(fleet_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetExportSettingResult:
    """
    This data source provides details about a specific Fleet Export Setting resource in Oracle Cloud Infrastructure Jms service.

    Returns export setting for the specified fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_export_setting = oci.Jms.get_fleet_export_setting(fleet_id=test_fleet["id"])
    ```


    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetExportSetting:getFleetExportSetting', __args__, opts=opts, typ=GetFleetExportSettingResult).value

    return AwaitableGetFleetExportSettingResult(
        export_duration=pulumi.get(__ret__, 'export_duration'),
        export_frequency=pulumi.get(__ret__, 'export_frequency'),
        export_resources=pulumi.get(__ret__, 'export_resources'),
        export_setting_key=pulumi.get(__ret__, 'export_setting_key'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        is_cross_region_acknowledged=pulumi.get(__ret__, 'is_cross_region_acknowledged'),
        is_enabled=pulumi.get(__ret__, 'is_enabled'),
        target_bucket_name=pulumi.get(__ret__, 'target_bucket_name'),
        target_bucket_namespace=pulumi.get(__ret__, 'target_bucket_namespace'),
        target_bucket_region=pulumi.get(__ret__, 'target_bucket_region'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_modified=pulumi.get(__ret__, 'time_last_modified'))
def get_fleet_export_setting_output(fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetExportSettingResult]:
    """
    This data source provides details about a specific Fleet Export Setting resource in Oracle Cloud Infrastructure Jms service.

    Returns export setting for the specified fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_export_setting = oci.Jms.get_fleet_export_setting(fleet_id=test_fleet["id"])
    ```


    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getFleetExportSetting:getFleetExportSetting', __args__, opts=opts, typ=GetFleetExportSettingResult)
    return __ret__.apply(lambda __response__: GetFleetExportSettingResult(
        export_duration=pulumi.get(__response__, 'export_duration'),
        export_frequency=pulumi.get(__response__, 'export_frequency'),
        export_resources=pulumi.get(__response__, 'export_resources'),
        export_setting_key=pulumi.get(__response__, 'export_setting_key'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        is_cross_region_acknowledged=pulumi.get(__response__, 'is_cross_region_acknowledged'),
        is_enabled=pulumi.get(__response__, 'is_enabled'),
        target_bucket_name=pulumi.get(__response__, 'target_bucket_name'),
        target_bucket_namespace=pulumi.get(__response__, 'target_bucket_namespace'),
        target_bucket_region=pulumi.get(__response__, 'target_bucket_region'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_last_modified=pulumi.get(__response__, 'time_last_modified')))
