# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetApiaccesscontrolApiMetadataResult',
    'AwaitableGetApiaccesscontrolApiMetadataResult',
    'get_apiaccesscontrol_api_metadata',
    'get_apiaccesscontrol_api_metadata_output',
]

@pulumi.output_type
class GetApiaccesscontrolApiMetadataResult:
    """
    A collection of values returned by getApiaccesscontrolApiMetadata.
    """
    def __init__(__self__, api_metadata_id=None, api_name=None, defined_tags=None, display_name=None, entity_type=None, fields=None, freeform_tags=None, id=None, lifecycle_details=None, path=None, service_name=None, state=None, system_tags=None, time_created=None, time_deleted=None, time_updated=None):
        if api_metadata_id and not isinstance(api_metadata_id, str):
            raise TypeError("Expected argument 'api_metadata_id' to be a str")
        pulumi.set(__self__, "api_metadata_id", api_metadata_id)
        if api_name and not isinstance(api_name, str):
            raise TypeError("Expected argument 'api_name' to be a str")
        pulumi.set(__self__, "api_name", api_name)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if entity_type and not isinstance(entity_type, str):
            raise TypeError("Expected argument 'entity_type' to be a str")
        pulumi.set(__self__, "entity_type", entity_type)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_deleted and not isinstance(time_deleted, str):
            raise TypeError("Expected argument 'time_deleted' to be a str")
        pulumi.set(__self__, "time_deleted", time_deleted)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="apiMetadataId")
    def api_metadata_id(self) -> _builtins.str:
        return pulumi.get(self, "api_metadata_id")

    @_builtins.property
    @pulumi.getter(name="apiName")
    def api_name(self) -> _builtins.str:
        """
        The name of the api to execute the api request.
        """
        return pulumi.get(self, "api_name")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The operation Name of the api. The name must be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> _builtins.str:
        """
        ResourceType to which the apiMetadata belongs to.
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter
    def fields(self) -> Sequence[_builtins.str]:
        """
        List of the fields that is use while calling post or put for the data.
        """
        return pulumi.get(self, "fields")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message that describes the current state of the ApiMetadata in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        rest path of the api.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The service Name to which the api belongs to.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the ApiMetadata.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the PrivilegedApiControl was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> _builtins.str:
        """
        The date and time the PrivilegedApiControl was marked for delete, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_deleted")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the PrivilegedApiControl was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetApiaccesscontrolApiMetadataResult(GetApiaccesscontrolApiMetadataResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiaccesscontrolApiMetadataResult(
            api_metadata_id=self.api_metadata_id,
            api_name=self.api_name,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            entity_type=self.entity_type,
            fields=self.fields,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            path=self.path,
            service_name=self.service_name,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_deleted=self.time_deleted,
            time_updated=self.time_updated)


def get_apiaccesscontrol_api_metadata(api_metadata_id: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiaccesscontrolApiMetadataResult:
    """
    This data source provides details about a specific Api Metadata resource in Oracle Cloud Infrastructure Apiaccesscontrol service.

    Gets information about a ApiMetadata.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_api_metadata = oci.oci.get_apiaccesscontrol_api_metadata(api_metadata_id=test_api_metadata_oci_apiaccesscontrol_api_metadata["id"])
    ```


    :param _builtins.str api_metadata_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the PrivilegedApiControl.
    """
    __args__ = dict()
    __args__['apiMetadataId'] = api_metadata_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getApiaccesscontrolApiMetadata:getApiaccesscontrolApiMetadata', __args__, opts=opts, typ=GetApiaccesscontrolApiMetadataResult).value

    return AwaitableGetApiaccesscontrolApiMetadataResult(
        api_metadata_id=pulumi.get(__ret__, 'api_metadata_id'),
        api_name=pulumi.get(__ret__, 'api_name'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        entity_type=pulumi.get(__ret__, 'entity_type'),
        fields=pulumi.get(__ret__, 'fields'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        path=pulumi.get(__ret__, 'path'),
        service_name=pulumi.get(__ret__, 'service_name'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_deleted=pulumi.get(__ret__, 'time_deleted'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_apiaccesscontrol_api_metadata_output(api_metadata_id: Optional[pulumi.Input[_builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiaccesscontrolApiMetadataResult]:
    """
    This data source provides details about a specific Api Metadata resource in Oracle Cloud Infrastructure Apiaccesscontrol service.

    Gets information about a ApiMetadata.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_api_metadata = oci.oci.get_apiaccesscontrol_api_metadata(api_metadata_id=test_api_metadata_oci_apiaccesscontrol_api_metadata["id"])
    ```


    :param _builtins.str api_metadata_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the PrivilegedApiControl.
    """
    __args__ = dict()
    __args__['apiMetadataId'] = api_metadata_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getApiaccesscontrolApiMetadata:getApiaccesscontrolApiMetadata', __args__, opts=opts, typ=GetApiaccesscontrolApiMetadataResult)
    return __ret__.apply(lambda __response__: GetApiaccesscontrolApiMetadataResult(
        api_metadata_id=pulumi.get(__response__, 'api_metadata_id'),
        api_name=pulumi.get(__response__, 'api_name'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        entity_type=pulumi.get(__response__, 'entity_type'),
        fields=pulumi.get(__response__, 'fields'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        path=pulumi.get(__response__, 'path'),
        service_name=pulumi.get(__response__, 'service_name'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_deleted=pulumi.get(__response__, 'time_deleted'),
        time_updated=pulumi.get(__response__, 'time_updated')))
