# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DbSystemArgs', 'DbSystem']

@pulumi.input_type
class DbSystemArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 db_version: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 network_details: pulumi.Input['DbSystemNetworkDetailsArgs'],
                 shape: pulumi.Input[_builtins.str],
                 storage_details: pulumi.Input['DbSystemStorageDetailsArgs'],
                 apply_config: Optional[pulumi.Input[_builtins.str]] = None,
                 config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input['DbSystemCredentialsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 instances_details: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]]] = None,
                 management_policy: Optional[pulumi.Input['DbSystemManagementPolicyArgs']] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemPatchOperationArgs']]]] = None,
                 source: Optional[pulumi.Input['DbSystemSourceArgs']] = None,
                 system_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DbSystem resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the database system.
        :param pulumi.Input[_builtins.str] db_version: Version of database system software.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the database system. Avoid entering confidential information.
        :param pulumi.Input['DbSystemNetworkDetailsArgs'] network_details: (Updatable) Network details for the database system.
        :param pulumi.Input[_builtins.str] shape: (Updatable) The name of the shape for the database instance node. Use the /shapes API for accepted shapes. Example: `VM.Standard.E4.Flex`
        :param pulumi.Input['DbSystemStorageDetailsArgs'] storage_details: (Updatable) Storage details of the database system.
        :param pulumi.Input[_builtins.str] apply_config: Whether a configuration update requires a restart of the database instance or a reload of the configuration. Some configuration changes require a restart of database instances to be applied. Apply config can be passed as `RESTART` or `RELOAD`
        :param pulumi.Input[_builtins.str] config_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration associated with the database system.
        :param pulumi.Input['DbSystemCredentialsArgs'] credentials: Initial database system credentials that the database system will be provisioned with. The password details are not visible on any subsequent operation, such as GET /dbSystems/{dbSystemId}.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-provided description of a database system.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] instance_count: Count of database instances nodes to be created in the database system.
        :param pulumi.Input[_builtins.int] instance_memory_size_in_gbs: (Updatable) The total amount of memory available to each database instance node, in gigabytes.
        :param pulumi.Input[_builtins.int] instance_ocpu_count: (Updatable) The total number of OCPUs available to each database instance node.
        :param pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]] instances_details: Details of database instances nodes to be created. This parameter is optional. If specified, its size must match `instanceCount`.
        :param pulumi.Input['DbSystemManagementPolicyArgs'] management_policy: (Updatable) PostgreSQL database system management policy update details.
        :param pulumi.Input[Sequence[pulumi.Input['DbSystemPatchOperationArgs']]] patch_operations: (Updatable) For adding and removing from read replica database instances. Please remove the patch_operations after it is applied. Update the instance_count arrodrandly. Cannot be specified when creating the resource.
        :param pulumi.Input['DbSystemSourceArgs'] source: The source used to restore the database system.
        :param pulumi.Input[_builtins.str] system_type: Type of the database system.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "network_details", network_details)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "storage_details", storage_details)
        if apply_config is not None:
            pulumi.set(__self__, "apply_config", apply_config)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_memory_size_in_gbs is not None:
            pulumi.set(__self__, "instance_memory_size_in_gbs", instance_memory_size_in_gbs)
        if instance_ocpu_count is not None:
            pulumi.set(__self__, "instance_ocpu_count", instance_ocpu_count)
        if instances_details is not None:
            pulumi.set(__self__, "instances_details", instances_details)
        if management_policy is not None:
            pulumi.set(__self__, "management_policy", management_policy)
        if patch_operations is not None:
            pulumi.set(__self__, "patch_operations", patch_operations)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if system_type is not None:
            pulumi.set(__self__, "system_type", system_type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the database system.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Input[_builtins.str]:
        """
        Version of database system software.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_version", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) A user-friendly display name for the database system. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="networkDetails")
    def network_details(self) -> pulumi.Input['DbSystemNetworkDetailsArgs']:
        """
        (Updatable) Network details for the database system.
        """
        return pulumi.get(self, "network_details")

    @network_details.setter
    def network_details(self, value: pulumi.Input['DbSystemNetworkDetailsArgs']):
        pulumi.set(self, "network_details", value)

    @_builtins.property
    @pulumi.getter
    def shape(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The name of the shape for the database instance node. Use the /shapes API for accepted shapes. Example: `VM.Standard.E4.Flex`
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "shape", value)

    @_builtins.property
    @pulumi.getter(name="storageDetails")
    def storage_details(self) -> pulumi.Input['DbSystemStorageDetailsArgs']:
        """
        (Updatable) Storage details of the database system.
        """
        return pulumi.get(self, "storage_details")

    @storage_details.setter
    def storage_details(self, value: pulumi.Input['DbSystemStorageDetailsArgs']):
        pulumi.set(self, "storage_details", value)

    @_builtins.property
    @pulumi.getter(name="applyConfig")
    def apply_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether a configuration update requires a restart of the database instance or a reload of the configuration. Some configuration changes require a restart of database instances to be applied. Apply config can be passed as `RESTART` or `RELOAD`
        """
        return pulumi.get(self, "apply_config")

    @apply_config.setter
    def apply_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "apply_config", value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration associated with the database system.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['DbSystemCredentialsArgs']]:
        """
        Initial database system credentials that the database system will be provisioned with. The password details are not visible on any subsequent operation, such as GET /dbSystems/{dbSystemId}.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['DbSystemCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-provided description of a database system.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Count of database instances nodes to be created in the database system.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_count", value)

    @_builtins.property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The total amount of memory available to each database instance node, in gigabytes.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @instance_memory_size_in_gbs.setter
    def instance_memory_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_memory_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The total number of OCPUs available to each database instance node.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @instance_ocpu_count.setter
    def instance_ocpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_ocpu_count", value)

    @_builtins.property
    @pulumi.getter(name="instancesDetails")
    def instances_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]]]:
        """
        Details of database instances nodes to be created. This parameter is optional. If specified, its size must match `instanceCount`.
        """
        return pulumi.get(self, "instances_details")

    @instances_details.setter
    def instances_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]]]):
        pulumi.set(self, "instances_details", value)

    @_builtins.property
    @pulumi.getter(name="managementPolicy")
    def management_policy(self) -> Optional[pulumi.Input['DbSystemManagementPolicyArgs']]:
        """
        (Updatable) PostgreSQL database system management policy update details.
        """
        return pulumi.get(self, "management_policy")

    @management_policy.setter
    def management_policy(self, value: Optional[pulumi.Input['DbSystemManagementPolicyArgs']]):
        pulumi.set(self, "management_policy", value)

    @_builtins.property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemPatchOperationArgs']]]]:
        """
        (Updatable) For adding and removing from read replica database instances. Please remove the patch_operations after it is applied. Update the instance_count arrodrandly. Cannot be specified when creating the resource.
        """
        return pulumi.get(self, "patch_operations")

    @patch_operations.setter
    def patch_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemPatchOperationArgs']]]]):
        pulumi.set(self, "patch_operations", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['DbSystemSourceArgs']]:
        """
        The source used to restore the database system.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['DbSystemSourceArgs']]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="systemType")
    def system_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the database system.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_type")

    @system_type.setter
    def system_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_type", value)


@pulumi.input_type
class _DbSystemState:
    def __init__(__self__, *,
                 admin_username: Optional[pulumi.Input[_builtins.str]] = None,
                 apply_config: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input['DbSystemCredentialsArgs']] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstanceArgs']]]] = None,
                 instances_details: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 management_policy: Optional[pulumi.Input['DbSystemManagementPolicyArgs']] = None,
                 network_details: Optional[pulumi.Input['DbSystemNetworkDetailsArgs']] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemPatchOperationArgs']]]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input['DbSystemSourceArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_details: Optional[pulumi.Input['DbSystemStorageDetailsArgs']] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DbSystem resources.
        :param pulumi.Input[_builtins.str] admin_username: The database system administrator username.
        :param pulumi.Input[_builtins.str] apply_config: Whether a configuration update requires a restart of the database instance or a reload of the configuration. Some configuration changes require a restart of database instances to be applied. Apply config can be passed as `RESTART` or `RELOAD`
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the database system.
        :param pulumi.Input[_builtins.str] config_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration associated with the database system.
        :param pulumi.Input['DbSystemCredentialsArgs'] credentials: Initial database system credentials that the database system will be provisioned with. The password details are not visible on any subsequent operation, such as GET /dbSystems/{dbSystemId}.
        :param pulumi.Input[_builtins.str] db_version: Version of database system software.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-provided description of a database system.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the database system. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] instance_count: Count of database instances nodes to be created in the database system.
        :param pulumi.Input[_builtins.int] instance_memory_size_in_gbs: (Updatable) The total amount of memory available to each database instance node, in gigabytes.
        :param pulumi.Input[_builtins.int] instance_ocpu_count: (Updatable) The total number of OCPUs available to each database instance node.
        :param pulumi.Input[Sequence[pulumi.Input['DbSystemInstanceArgs']]] instances: The list of instances, or nodes, in the database system.
        :param pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]] instances_details: Details of database instances nodes to be created. This parameter is optional. If specified, its size must match `instanceCount`.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input['DbSystemManagementPolicyArgs'] management_policy: (Updatable) PostgreSQL database system management policy update details.
        :param pulumi.Input['DbSystemNetworkDetailsArgs'] network_details: (Updatable) Network details for the database system.
        :param pulumi.Input[Sequence[pulumi.Input['DbSystemPatchOperationArgs']]] patch_operations: (Updatable) For adding and removing from read replica database instances. Please remove the patch_operations after it is applied. Update the instance_count arrodrandly. Cannot be specified when creating the resource.
        :param pulumi.Input[_builtins.str] shape: (Updatable) The name of the shape for the database instance node. Use the /shapes API for accepted shapes. Example: `VM.Standard.E4.Flex`
        :param pulumi.Input['DbSystemSourceArgs'] source: The source used to restore the database system.
        :param pulumi.Input[_builtins.str] state: The current state of the database system.
        :param pulumi.Input['DbSystemStorageDetailsArgs'] storage_details: (Updatable) Storage details of the database system.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] system_type: Type of the database system.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The date and time that the database system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time that the database system was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if apply_config is not None:
            pulumi.set(__self__, "apply_config", apply_config)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_memory_size_in_gbs is not None:
            pulumi.set(__self__, "instance_memory_size_in_gbs", instance_memory_size_in_gbs)
        if instance_ocpu_count is not None:
            pulumi.set(__self__, "instance_ocpu_count", instance_ocpu_count)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if instances_details is not None:
            pulumi.set(__self__, "instances_details", instances_details)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if management_policy is not None:
            pulumi.set(__self__, "management_policy", management_policy)
        if network_details is not None:
            pulumi.set(__self__, "network_details", network_details)
        if patch_operations is not None:
            pulumi.set(__self__, "patch_operations", patch_operations)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_details is not None:
            pulumi.set(__self__, "storage_details", storage_details)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if system_type is not None:
            pulumi.set(__self__, "system_type", system_type)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database system administrator username.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_username", value)

    @_builtins.property
    @pulumi.getter(name="applyConfig")
    def apply_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether a configuration update requires a restart of the database instance or a reload of the configuration. Some configuration changes require a restart of database instances to be applied. Apply config can be passed as `RESTART` or `RELOAD`
        """
        return pulumi.get(self, "apply_config")

    @apply_config.setter
    def apply_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "apply_config", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the database system.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration associated with the database system.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['DbSystemCredentialsArgs']]:
        """
        Initial database system credentials that the database system will be provisioned with. The password details are not visible on any subsequent operation, such as GET /dbSystems/{dbSystemId}.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['DbSystemCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of database system software.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_version", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-provided description of a database system.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly display name for the database system. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Count of database instances nodes to be created in the database system.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_count", value)

    @_builtins.property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The total amount of memory available to each database instance node, in gigabytes.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @instance_memory_size_in_gbs.setter
    def instance_memory_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_memory_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The total number of OCPUs available to each database instance node.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @instance_ocpu_count.setter
    def instance_ocpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_ocpu_count", value)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstanceArgs']]]]:
        """
        The list of instances, or nodes, in the database system.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstanceArgs']]]]):
        pulumi.set(self, "instances", value)

    @_builtins.property
    @pulumi.getter(name="instancesDetails")
    def instances_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]]]:
        """
        Details of database instances nodes to be created. This parameter is optional. If specified, its size must match `instanceCount`.
        """
        return pulumi.get(self, "instances_details")

    @instances_details.setter
    def instances_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]]]):
        pulumi.set(self, "instances_details", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="managementPolicy")
    def management_policy(self) -> Optional[pulumi.Input['DbSystemManagementPolicyArgs']]:
        """
        (Updatable) PostgreSQL database system management policy update details.
        """
        return pulumi.get(self, "management_policy")

    @management_policy.setter
    def management_policy(self, value: Optional[pulumi.Input['DbSystemManagementPolicyArgs']]):
        pulumi.set(self, "management_policy", value)

    @_builtins.property
    @pulumi.getter(name="networkDetails")
    def network_details(self) -> Optional[pulumi.Input['DbSystemNetworkDetailsArgs']]:
        """
        (Updatable) Network details for the database system.
        """
        return pulumi.get(self, "network_details")

    @network_details.setter
    def network_details(self, value: Optional[pulumi.Input['DbSystemNetworkDetailsArgs']]):
        pulumi.set(self, "network_details", value)

    @_builtins.property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemPatchOperationArgs']]]]:
        """
        (Updatable) For adding and removing from read replica database instances. Please remove the patch_operations after it is applied. Update the instance_count arrodrandly. Cannot be specified when creating the resource.
        """
        return pulumi.get(self, "patch_operations")

    @patch_operations.setter
    def patch_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemPatchOperationArgs']]]]):
        pulumi.set(self, "patch_operations", value)

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the shape for the database instance node. Use the /shapes API for accepted shapes. Example: `VM.Standard.E4.Flex`
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shape", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['DbSystemSourceArgs']]:
        """
        The source used to restore the database system.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['DbSystemSourceArgs']]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the database system.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="storageDetails")
    def storage_details(self) -> Optional[pulumi.Input['DbSystemStorageDetailsArgs']]:
        """
        (Updatable) Storage details of the database system.
        """
        return pulumi.get(self, "storage_details")

    @storage_details.setter
    def storage_details(self, value: Optional[pulumi.Input['DbSystemStorageDetailsArgs']]):
        pulumi.set(self, "storage_details", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="systemType")
    def system_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the database system.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_type")

    @system_type.setter
    def system_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_type", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the database system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the database system was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:Psql/dbSystem:DbSystem")
class DbSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_config: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Union['DbSystemCredentialsArgs', 'DbSystemCredentialsArgsDict']]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 instances_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbSystemInstancesDetailArgs', 'DbSystemInstancesDetailArgsDict']]]]] = None,
                 management_policy: Optional[pulumi.Input[Union['DbSystemManagementPolicyArgs', 'DbSystemManagementPolicyArgsDict']]] = None,
                 network_details: Optional[pulumi.Input[Union['DbSystemNetworkDetailsArgs', 'DbSystemNetworkDetailsArgsDict']]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbSystemPatchOperationArgs', 'DbSystemPatchOperationArgsDict']]]]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['DbSystemSourceArgs', 'DbSystemSourceArgsDict']]] = None,
                 storage_details: Optional[pulumi.Input[Union['DbSystemStorageDetailsArgs', 'DbSystemStorageDetailsArgsDict']]] = None,
                 system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Db System resource in Oracle Cloud Infrastructure Psql service.

        Creates a new database system.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_system = oci.psql.DbSystem("test_db_system",
            compartment_id=compartment_id,
            credentials={
                "password_details": {
                    "password_type": db_system_credentials_password_details_password_type,
                    "password": db_system_credentials_password_details_password,
                    "secret_id": test_secret["id"],
                    "secret_version": db_system_credentials_password_details_secret_version,
                },
                "username": db_system_credentials_username,
            },
            db_version=db_system_db_version,
            display_name=db_system_display_name,
            network_details={
                "subnet_id": test_subnet["id"],
                "is_reader_endpoint_enabled": db_system_network_details_is_reader_endpoint_enabled,
                "nsg_ids": db_system_network_details_nsg_ids,
                "primary_db_endpoint_private_ip": db_system_network_details_primary_db_endpoint_private_ip,
            },
            shape=db_system_shape,
            storage_details={
                "is_regionally_durable": db_system_storage_details_is_regionally_durable,
                "system_type": db_system_storage_details_system_type,
                "availability_domain": db_system_storage_details_availability_domain,
                "iops": db_system_storage_details_iops,
            },
            config_id=test_config["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=db_system_description,
            freeform_tags={
                "bar-key": "value",
            },
            instance_count=db_system_instance_count,
            instance_memory_size_in_gbs=db_system_instance_memory_size_in_gbs,
            instance_ocpu_count=db_system_instance_ocpu_count,
            instances_details=[{
                "description": db_system_instances_details_description,
                "display_name": db_system_instances_details_display_name,
                "private_ip": db_system_instances_details_private_ip,
            }],
            management_policy={
                "backup_policy": {
                    "backup_start": db_system_management_policy_backup_policy_backup_start,
                    "copy_policy": {
                        "compartment_id": compartment_id,
                        "regions": db_system_management_policy_backup_policy_copy_policy_regions,
                        "retention_period": db_system_management_policy_backup_policy_copy_policy_retention_period,
                    },
                    "days_of_the_months": db_system_management_policy_backup_policy_days_of_the_month,
                    "days_of_the_weeks": db_system_management_policy_backup_policy_days_of_the_week,
                    "kind": db_system_management_policy_backup_policy_kind,
                    "retention_days": db_system_management_policy_backup_policy_retention_days,
                },
                "maintenance_window_start": db_system_management_policy_maintenance_window_start,
            },
            source={
                "source_type": db_system_source_source_type,
                "backup_id": test_backup["id"],
                "is_having_restore_config_overrides": db_system_source_is_having_restore_config_overrides,
            },
            system_type=db_system_system_type,
            patch_operations=[{
                "operation": db_system_patch_operations_operation,
                "selection": db_system_patch_operations_selection,
                "value": db_system_patch_operations_value,
            }])
        ```

        ## Import

        DbSystems can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Psql/dbSystem:DbSystem test_db_system "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] apply_config: Whether a configuration update requires a restart of the database instance or a reload of the configuration. Some configuration changes require a restart of database instances to be applied. Apply config can be passed as `RESTART` or `RELOAD`
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the database system.
        :param pulumi.Input[_builtins.str] config_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration associated with the database system.
        :param pulumi.Input[Union['DbSystemCredentialsArgs', 'DbSystemCredentialsArgsDict']] credentials: Initial database system credentials that the database system will be provisioned with. The password details are not visible on any subsequent operation, such as GET /dbSystems/{dbSystemId}.
        :param pulumi.Input[_builtins.str] db_version: Version of database system software.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-provided description of a database system.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the database system. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] instance_count: Count of database instances nodes to be created in the database system.
        :param pulumi.Input[_builtins.int] instance_memory_size_in_gbs: (Updatable) The total amount of memory available to each database instance node, in gigabytes.
        :param pulumi.Input[_builtins.int] instance_ocpu_count: (Updatable) The total number of OCPUs available to each database instance node.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbSystemInstancesDetailArgs', 'DbSystemInstancesDetailArgsDict']]]] instances_details: Details of database instances nodes to be created. This parameter is optional. If specified, its size must match `instanceCount`.
        :param pulumi.Input[Union['DbSystemManagementPolicyArgs', 'DbSystemManagementPolicyArgsDict']] management_policy: (Updatable) PostgreSQL database system management policy update details.
        :param pulumi.Input[Union['DbSystemNetworkDetailsArgs', 'DbSystemNetworkDetailsArgsDict']] network_details: (Updatable) Network details for the database system.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbSystemPatchOperationArgs', 'DbSystemPatchOperationArgsDict']]]] patch_operations: (Updatable) For adding and removing from read replica database instances. Please remove the patch_operations after it is applied. Update the instance_count arrodrandly. Cannot be specified when creating the resource.
        :param pulumi.Input[_builtins.str] shape: (Updatable) The name of the shape for the database instance node. Use the /shapes API for accepted shapes. Example: `VM.Standard.E4.Flex`
        :param pulumi.Input[Union['DbSystemSourceArgs', 'DbSystemSourceArgsDict']] source: The source used to restore the database system.
        :param pulumi.Input[Union['DbSystemStorageDetailsArgs', 'DbSystemStorageDetailsArgsDict']] storage_details: (Updatable) Storage details of the database system.
        :param pulumi.Input[_builtins.str] system_type: Type of the database system.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Db System resource in Oracle Cloud Infrastructure Psql service.

        Creates a new database system.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_system = oci.psql.DbSystem("test_db_system",
            compartment_id=compartment_id,
            credentials={
                "password_details": {
                    "password_type": db_system_credentials_password_details_password_type,
                    "password": db_system_credentials_password_details_password,
                    "secret_id": test_secret["id"],
                    "secret_version": db_system_credentials_password_details_secret_version,
                },
                "username": db_system_credentials_username,
            },
            db_version=db_system_db_version,
            display_name=db_system_display_name,
            network_details={
                "subnet_id": test_subnet["id"],
                "is_reader_endpoint_enabled": db_system_network_details_is_reader_endpoint_enabled,
                "nsg_ids": db_system_network_details_nsg_ids,
                "primary_db_endpoint_private_ip": db_system_network_details_primary_db_endpoint_private_ip,
            },
            shape=db_system_shape,
            storage_details={
                "is_regionally_durable": db_system_storage_details_is_regionally_durable,
                "system_type": db_system_storage_details_system_type,
                "availability_domain": db_system_storage_details_availability_domain,
                "iops": db_system_storage_details_iops,
            },
            config_id=test_config["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=db_system_description,
            freeform_tags={
                "bar-key": "value",
            },
            instance_count=db_system_instance_count,
            instance_memory_size_in_gbs=db_system_instance_memory_size_in_gbs,
            instance_ocpu_count=db_system_instance_ocpu_count,
            instances_details=[{
                "description": db_system_instances_details_description,
                "display_name": db_system_instances_details_display_name,
                "private_ip": db_system_instances_details_private_ip,
            }],
            management_policy={
                "backup_policy": {
                    "backup_start": db_system_management_policy_backup_policy_backup_start,
                    "copy_policy": {
                        "compartment_id": compartment_id,
                        "regions": db_system_management_policy_backup_policy_copy_policy_regions,
                        "retention_period": db_system_management_policy_backup_policy_copy_policy_retention_period,
                    },
                    "days_of_the_months": db_system_management_policy_backup_policy_days_of_the_month,
                    "days_of_the_weeks": db_system_management_policy_backup_policy_days_of_the_week,
                    "kind": db_system_management_policy_backup_policy_kind,
                    "retention_days": db_system_management_policy_backup_policy_retention_days,
                },
                "maintenance_window_start": db_system_management_policy_maintenance_window_start,
            },
            source={
                "source_type": db_system_source_source_type,
                "backup_id": test_backup["id"],
                "is_having_restore_config_overrides": db_system_source_is_having_restore_config_overrides,
            },
            system_type=db_system_system_type,
            patch_operations=[{
                "operation": db_system_patch_operations_operation,
                "selection": db_system_patch_operations_selection,
                "value": db_system_patch_operations_value,
            }])
        ```

        ## Import

        DbSystems can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Psql/dbSystem:DbSystem test_db_system "id"
        ```

        :param str resource_name: The name of the resource.
        :param DbSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_config: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Union['DbSystemCredentialsArgs', 'DbSystemCredentialsArgsDict']]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 instances_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbSystemInstancesDetailArgs', 'DbSystemInstancesDetailArgsDict']]]]] = None,
                 management_policy: Optional[pulumi.Input[Union['DbSystemManagementPolicyArgs', 'DbSystemManagementPolicyArgsDict']]] = None,
                 network_details: Optional[pulumi.Input[Union['DbSystemNetworkDetailsArgs', 'DbSystemNetworkDetailsArgsDict']]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbSystemPatchOperationArgs', 'DbSystemPatchOperationArgsDict']]]]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['DbSystemSourceArgs', 'DbSystemSourceArgsDict']]] = None,
                 storage_details: Optional[pulumi.Input[Union['DbSystemStorageDetailsArgs', 'DbSystemStorageDetailsArgsDict']]] = None,
                 system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbSystemArgs.__new__(DbSystemArgs)

            __props__.__dict__["apply_config"] = apply_config
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["config_id"] = config_id
            __props__.__dict__["credentials"] = credentials
            if db_version is None and not opts.urn:
                raise TypeError("Missing required property 'db_version'")
            __props__.__dict__["db_version"] = db_version
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["instance_count"] = instance_count
            __props__.__dict__["instance_memory_size_in_gbs"] = instance_memory_size_in_gbs
            __props__.__dict__["instance_ocpu_count"] = instance_ocpu_count
            __props__.__dict__["instances_details"] = instances_details
            __props__.__dict__["management_policy"] = management_policy
            if network_details is None and not opts.urn:
                raise TypeError("Missing required property 'network_details'")
            __props__.__dict__["network_details"] = network_details
            __props__.__dict__["patch_operations"] = patch_operations
            if shape is None and not opts.urn:
                raise TypeError("Missing required property 'shape'")
            __props__.__dict__["shape"] = shape
            __props__.__dict__["source"] = source
            if storage_details is None and not opts.urn:
                raise TypeError("Missing required property 'storage_details'")
            __props__.__dict__["storage_details"] = storage_details
            __props__.__dict__["system_type"] = system_type
            __props__.__dict__["admin_username"] = None
            __props__.__dict__["instances"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DbSystem, __self__).__init__(
            'oci:Psql/dbSystem:DbSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_username: Optional[pulumi.Input[_builtins.str]] = None,
            apply_config: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            config_id: Optional[pulumi.Input[_builtins.str]] = None,
            credentials: Optional[pulumi.Input[Union['DbSystemCredentialsArgs', 'DbSystemCredentialsArgsDict']]] = None,
            db_version: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            instance_count: Optional[pulumi.Input[_builtins.int]] = None,
            instance_memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            instance_ocpu_count: Optional[pulumi.Input[_builtins.int]] = None,
            instances: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbSystemInstanceArgs', 'DbSystemInstanceArgsDict']]]]] = None,
            instances_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbSystemInstancesDetailArgs', 'DbSystemInstancesDetailArgsDict']]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            management_policy: Optional[pulumi.Input[Union['DbSystemManagementPolicyArgs', 'DbSystemManagementPolicyArgsDict']]] = None,
            network_details: Optional[pulumi.Input[Union['DbSystemNetworkDetailsArgs', 'DbSystemNetworkDetailsArgsDict']]] = None,
            patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbSystemPatchOperationArgs', 'DbSystemPatchOperationArgsDict']]]]] = None,
            shape: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[Union['DbSystemSourceArgs', 'DbSystemSourceArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            storage_details: Optional[pulumi.Input[Union['DbSystemStorageDetailsArgs', 'DbSystemStorageDetailsArgsDict']]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            system_type: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'DbSystem':
        """
        Get an existing DbSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] admin_username: The database system administrator username.
        :param pulumi.Input[_builtins.str] apply_config: Whether a configuration update requires a restart of the database instance or a reload of the configuration. Some configuration changes require a restart of database instances to be applied. Apply config can be passed as `RESTART` or `RELOAD`
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the database system.
        :param pulumi.Input[_builtins.str] config_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration associated with the database system.
        :param pulumi.Input[Union['DbSystemCredentialsArgs', 'DbSystemCredentialsArgsDict']] credentials: Initial database system credentials that the database system will be provisioned with. The password details are not visible on any subsequent operation, such as GET /dbSystems/{dbSystemId}.
        :param pulumi.Input[_builtins.str] db_version: Version of database system software.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) A user-provided description of a database system.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name for the database system. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] instance_count: Count of database instances nodes to be created in the database system.
        :param pulumi.Input[_builtins.int] instance_memory_size_in_gbs: (Updatable) The total amount of memory available to each database instance node, in gigabytes.
        :param pulumi.Input[_builtins.int] instance_ocpu_count: (Updatable) The total number of OCPUs available to each database instance node.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbSystemInstanceArgs', 'DbSystemInstanceArgsDict']]]] instances: The list of instances, or nodes, in the database system.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbSystemInstancesDetailArgs', 'DbSystemInstancesDetailArgsDict']]]] instances_details: Details of database instances nodes to be created. This parameter is optional. If specified, its size must match `instanceCount`.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Union['DbSystemManagementPolicyArgs', 'DbSystemManagementPolicyArgsDict']] management_policy: (Updatable) PostgreSQL database system management policy update details.
        :param pulumi.Input[Union['DbSystemNetworkDetailsArgs', 'DbSystemNetworkDetailsArgsDict']] network_details: (Updatable) Network details for the database system.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbSystemPatchOperationArgs', 'DbSystemPatchOperationArgsDict']]]] patch_operations: (Updatable) For adding and removing from read replica database instances. Please remove the patch_operations after it is applied. Update the instance_count arrodrandly. Cannot be specified when creating the resource.
        :param pulumi.Input[_builtins.str] shape: (Updatable) The name of the shape for the database instance node. Use the /shapes API for accepted shapes. Example: `VM.Standard.E4.Flex`
        :param pulumi.Input[Union['DbSystemSourceArgs', 'DbSystemSourceArgsDict']] source: The source used to restore the database system.
        :param pulumi.Input[_builtins.str] state: The current state of the database system.
        :param pulumi.Input[Union['DbSystemStorageDetailsArgs', 'DbSystemStorageDetailsArgsDict']] storage_details: (Updatable) Storage details of the database system.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] system_type: Type of the database system.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The date and time that the database system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time that the database system was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbSystemState.__new__(_DbSystemState)

        __props__.__dict__["admin_username"] = admin_username
        __props__.__dict__["apply_config"] = apply_config
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["db_version"] = db_version
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["instance_count"] = instance_count
        __props__.__dict__["instance_memory_size_in_gbs"] = instance_memory_size_in_gbs
        __props__.__dict__["instance_ocpu_count"] = instance_ocpu_count
        __props__.__dict__["instances"] = instances
        __props__.__dict__["instances_details"] = instances_details
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["management_policy"] = management_policy
        __props__.__dict__["network_details"] = network_details
        __props__.__dict__["patch_operations"] = patch_operations
        __props__.__dict__["shape"] = shape
        __props__.__dict__["source"] = source
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_details"] = storage_details
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["system_type"] = system_type
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return DbSystem(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Output[_builtins.str]:
        """
        The database system administrator username.
        """
        return pulumi.get(self, "admin_username")

    @_builtins.property
    @pulumi.getter(name="applyConfig")
    def apply_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether a configuration update requires a restart of the database instance or a reload of the configuration. Some configuration changes require a restart of database instances to be applied. Apply config can be passed as `RESTART` or `RELOAD`
        """
        return pulumi.get(self, "apply_config")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the database system.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration associated with the database system.
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional['outputs.DbSystemCredentials']]:
        """
        Initial database system credentials that the database system will be provisioned with. The password details are not visible on any subsequent operation, such as GET /dbSystems/{dbSystemId}.
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of database system software.
        """
        return pulumi.get(self, "db_version")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-provided description of a database system.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly display name for the database system. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Output[_builtins.int]:
        """
        Count of database instances nodes to be created in the database system.
        """
        return pulumi.get(self, "instance_count")

    @_builtins.property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The total amount of memory available to each database instance node, in gigabytes.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The total number of OCPUs available to each database instance node.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> pulumi.Output[Sequence['outputs.DbSystemInstance']]:
        """
        The list of instances, or nodes, in the database system.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="instancesDetails")
    def instances_details(self) -> pulumi.Output[Sequence['outputs.DbSystemInstancesDetail']]:
        """
        Details of database instances nodes to be created. This parameter is optional. If specified, its size must match `instanceCount`.
        """
        return pulumi.get(self, "instances_details")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="managementPolicy")
    def management_policy(self) -> pulumi.Output['outputs.DbSystemManagementPolicy']:
        """
        (Updatable) PostgreSQL database system management policy update details.
        """
        return pulumi.get(self, "management_policy")

    @_builtins.property
    @pulumi.getter(name="networkDetails")
    def network_details(self) -> pulumi.Output['outputs.DbSystemNetworkDetails']:
        """
        (Updatable) Network details for the database system.
        """
        return pulumi.get(self, "network_details")

    @_builtins.property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> pulumi.Output[Optional[Sequence['outputs.DbSystemPatchOperation']]]:
        """
        (Updatable) For adding and removing from read replica database instances. Please remove the patch_operations after it is applied. Update the instance_count arrodrandly. Cannot be specified when creating the resource.
        """
        return pulumi.get(self, "patch_operations")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The name of the shape for the database instance node. Use the /shapes API for accepted shapes. Example: `VM.Standard.E4.Flex`
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.DbSystemSource']:
        """
        The source used to restore the database system.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the database system.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="storageDetails")
    def storage_details(self) -> pulumi.Output['outputs.DbSystemStorageDetails']:
        """
        (Updatable) Storage details of the database system.
        """
        return pulumi.get(self, "storage_details")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="systemType")
    def system_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the database system.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_type")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the database system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the database system was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

