# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['QueueArgs', 'Queue']

@pulumi.input_type
class QueueArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 channel_consumption_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_queue_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 purge_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 purge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 visibility_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Queue resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the queue.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name of the queue.
        :param pulumi.Input[_builtins.int] channel_consumption_limit: (Updatable) The percentage of allocated queue resources that can be consumed by a single channel. For example, if a queue has a storage limit of 2Gb, and a single channel consumption limit is 0.1 (10%), that means data size of a single channel  can't exceed 200Mb. Consumption limit of 100% (default) means that a single channel can consume up-to all allocated queue's resources.
        :param pulumi.Input[_builtins.str] custom_encryption_key_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the custom encryption key to be used to encrypt messages content.
        :param pulumi.Input[_builtins.int] dead_letter_queue_delivery_count: (Updatable) The number of times a message can be delivered to a consumer before being moved to the dead letter queue. A value of 0 indicates that the DLQ is not used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] purge_trigger: (Updatable) An optional property when incremented triggers Purge. Could be set to any integer value.
        :param pulumi.Input[_builtins.str] purge_type: (Updatable) An optional value that specifies the purge behavior for the Queue. Could be set to NORMAL, DLQ or BOTH. If unset, the default value is NORMAL
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.int] retention_in_seconds: The retention period of messages in the queue, in seconds.
        :param pulumi.Input[_builtins.int] timeout_in_seconds: (Updatable) The default polling timeout of the messages in the queue, in seconds.
        :param pulumi.Input[_builtins.int] visibility_in_seconds: (Updatable) The default visibility timeout of the messages consumed from the queue, in seconds.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        if channel_consumption_limit is not None:
            pulumi.set(__self__, "channel_consumption_limit", channel_consumption_limit)
        if custom_encryption_key_id is not None:
            pulumi.set(__self__, "custom_encryption_key_id", custom_encryption_key_id)
        if dead_letter_queue_delivery_count is not None:
            pulumi.set(__self__, "dead_letter_queue_delivery_count", dead_letter_queue_delivery_count)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if purge_trigger is not None:
            pulumi.set(__self__, "purge_trigger", purge_trigger)
        if purge_type is not None:
            pulumi.set(__self__, "purge_type", purge_type)
        if retention_in_seconds is not None:
            pulumi.set(__self__, "retention_in_seconds", retention_in_seconds)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if visibility_in_seconds is not None:
            pulumi.set(__self__, "visibility_in_seconds", visibility_in_seconds)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the queue.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The user-friendly name of the queue.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="channelConsumptionLimit")
    def channel_consumption_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The percentage of allocated queue resources that can be consumed by a single channel. For example, if a queue has a storage limit of 2Gb, and a single channel consumption limit is 0.1 (10%), that means data size of a single channel  can't exceed 200Mb. Consumption limit of 100% (default) means that a single channel can consume up-to all allocated queue's resources.
        """
        return pulumi.get(self, "channel_consumption_limit")

    @channel_consumption_limit.setter
    def channel_consumption_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "channel_consumption_limit", value)

    @_builtins.property
    @pulumi.getter(name="customEncryptionKeyId")
    def custom_encryption_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the custom encryption key to be used to encrypt messages content.
        """
        return pulumi.get(self, "custom_encryption_key_id")

    @custom_encryption_key_id.setter
    def custom_encryption_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_encryption_key_id", value)

    @_builtins.property
    @pulumi.getter(name="deadLetterQueueDeliveryCount")
    def dead_letter_queue_delivery_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The number of times a message can be delivered to a consumer before being moved to the dead letter queue. A value of 0 indicates that the DLQ is not used.
        """
        return pulumi.get(self, "dead_letter_queue_delivery_count")

    @dead_letter_queue_delivery_count.setter
    def dead_letter_queue_delivery_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dead_letter_queue_delivery_count", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="purgeTrigger")
    def purge_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Purge. Could be set to any integer value.
        """
        return pulumi.get(self, "purge_trigger")

    @purge_trigger.setter
    def purge_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "purge_trigger", value)

    @_builtins.property
    @pulumi.getter(name="purgeType")
    def purge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An optional value that specifies the purge behavior for the Queue. Could be set to NORMAL, DLQ or BOTH. If unset, the default value is NORMAL

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "purge_type")

    @purge_type.setter
    def purge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "purge_type", value)

    @_builtins.property
    @pulumi.getter(name="retentionInSeconds")
    def retention_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of messages in the queue, in seconds.
        """
        return pulumi.get(self, "retention_in_seconds")

    @retention_in_seconds.setter
    def retention_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The default polling timeout of the messages in the queue, in seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="visibilityInSeconds")
    def visibility_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The default visibility timeout of the messages consumed from the queue, in seconds.
        """
        return pulumi.get(self, "visibility_in_seconds")

    @visibility_in_seconds.setter
    def visibility_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "visibility_in_seconds", value)


@pulumi.input_type
class _QueueState:
    def __init__(__self__, *,
                 channel_consumption_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_queue_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 messages_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 purge_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 purge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 visibility_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Queue resources.
        :param pulumi.Input[_builtins.int] channel_consumption_limit: (Updatable) The percentage of allocated queue resources that can be consumed by a single channel. For example, if a queue has a storage limit of 2Gb, and a single channel consumption limit is 0.1 (10%), that means data size of a single channel  can't exceed 200Mb. Consumption limit of 100% (default) means that a single channel can consume up-to all allocated queue's resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the queue.
        :param pulumi.Input[_builtins.str] custom_encryption_key_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the custom encryption key to be used to encrypt messages content.
        :param pulumi.Input[_builtins.int] dead_letter_queue_delivery_count: (Updatable) The number of times a message can be delivered to a consumer before being moved to the dead letter queue. A value of 0 indicates that the DLQ is not used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name of the queue.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Any additional details about the current state of the queue.
        :param pulumi.Input[_builtins.str] messages_endpoint: The endpoint to use to consume or publish messages in the queue.
        :param pulumi.Input[_builtins.int] purge_trigger: (Updatable) An optional property when incremented triggers Purge. Could be set to any integer value.
        :param pulumi.Input[_builtins.str] purge_type: (Updatable) An optional value that specifies the purge behavior for the Queue. Could be set to NORMAL, DLQ or BOTH. If unset, the default value is NORMAL
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.int] retention_in_seconds: The retention period of messages in the queue, in seconds.
        :param pulumi.Input[_builtins.str] state: The current state of the queue.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time that the queue was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        :param pulumi.Input[_builtins.str] time_updated: The time that the queue was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        :param pulumi.Input[_builtins.int] timeout_in_seconds: (Updatable) The default polling timeout of the messages in the queue, in seconds.
        :param pulumi.Input[_builtins.int] visibility_in_seconds: (Updatable) The default visibility timeout of the messages consumed from the queue, in seconds.
        """
        if channel_consumption_limit is not None:
            pulumi.set(__self__, "channel_consumption_limit", channel_consumption_limit)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if custom_encryption_key_id is not None:
            pulumi.set(__self__, "custom_encryption_key_id", custom_encryption_key_id)
        if dead_letter_queue_delivery_count is not None:
            pulumi.set(__self__, "dead_letter_queue_delivery_count", dead_letter_queue_delivery_count)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if messages_endpoint is not None:
            pulumi.set(__self__, "messages_endpoint", messages_endpoint)
        if purge_trigger is not None:
            pulumi.set(__self__, "purge_trigger", purge_trigger)
        if purge_type is not None:
            pulumi.set(__self__, "purge_type", purge_type)
        if retention_in_seconds is not None:
            pulumi.set(__self__, "retention_in_seconds", retention_in_seconds)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if visibility_in_seconds is not None:
            pulumi.set(__self__, "visibility_in_seconds", visibility_in_seconds)

    @_builtins.property
    @pulumi.getter(name="channelConsumptionLimit")
    def channel_consumption_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The percentage of allocated queue resources that can be consumed by a single channel. For example, if a queue has a storage limit of 2Gb, and a single channel consumption limit is 0.1 (10%), that means data size of a single channel  can't exceed 200Mb. Consumption limit of 100% (default) means that a single channel can consume up-to all allocated queue's resources.
        """
        return pulumi.get(self, "channel_consumption_limit")

    @channel_consumption_limit.setter
    def channel_consumption_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "channel_consumption_limit", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the queue.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="customEncryptionKeyId")
    def custom_encryption_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the custom encryption key to be used to encrypt messages content.
        """
        return pulumi.get(self, "custom_encryption_key_id")

    @custom_encryption_key_id.setter
    def custom_encryption_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_encryption_key_id", value)

    @_builtins.property
    @pulumi.getter(name="deadLetterQueueDeliveryCount")
    def dead_letter_queue_delivery_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The number of times a message can be delivered to a consumer before being moved to the dead letter queue. A value of 0 indicates that the DLQ is not used.
        """
        return pulumi.get(self, "dead_letter_queue_delivery_count")

    @dead_letter_queue_delivery_count.setter
    def dead_letter_queue_delivery_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dead_letter_queue_delivery_count", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The user-friendly name of the queue.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Any additional details about the current state of the queue.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="messagesEndpoint")
    def messages_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint to use to consume or publish messages in the queue.
        """
        return pulumi.get(self, "messages_endpoint")

    @messages_endpoint.setter
    def messages_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "messages_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="purgeTrigger")
    def purge_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Purge. Could be set to any integer value.
        """
        return pulumi.get(self, "purge_trigger")

    @purge_trigger.setter
    def purge_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "purge_trigger", value)

    @_builtins.property
    @pulumi.getter(name="purgeType")
    def purge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An optional value that specifies the purge behavior for the Queue. Could be set to NORMAL, DLQ or BOTH. If unset, the default value is NORMAL

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "purge_type")

    @purge_type.setter
    def purge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "purge_type", value)

    @_builtins.property
    @pulumi.getter(name="retentionInSeconds")
    def retention_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention period of messages in the queue, in seconds.
        """
        return pulumi.get(self, "retention_in_seconds")

    @retention_in_seconds.setter
    def retention_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the queue.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time that the queue was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time that the queue was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The default polling timeout of the messages in the queue, in seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="visibilityInSeconds")
    def visibility_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The default visibility timeout of the messages consumed from the queue, in seconds.
        """
        return pulumi.get(self, "visibility_in_seconds")

    @visibility_in_seconds.setter
    def visibility_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "visibility_in_seconds", value)


@pulumi.type_token("oci:Queue/queue:Queue")
class Queue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_consumption_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_queue_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 purge_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 purge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 visibility_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        This resource provides the Queue resource in Oracle Cloud Infrastructure Queue service.

        Creates a new queue.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_queue = oci.queue.Queue("test_queue",
            compartment_id=compartment_id,
            display_name=queue_display_name,
            channel_consumption_limit=queue_channel_consumption_limit,
            custom_encryption_key_id=test_key["id"],
            dead_letter_queue_delivery_count=queue_dead_letter_queue_delivery_count,
            purge_trigger=purge_trigger,
            purge_type=purge_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            retention_in_seconds=queue_retention_in_seconds,
            timeout_in_seconds=queue_timeout_in_seconds,
            visibility_in_seconds=queue_visibility_in_seconds)
        ```

        ## Import

        Queues can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Queue/queue:Queue test_queue "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] channel_consumption_limit: (Updatable) The percentage of allocated queue resources that can be consumed by a single channel. For example, if a queue has a storage limit of 2Gb, and a single channel consumption limit is 0.1 (10%), that means data size of a single channel  can't exceed 200Mb. Consumption limit of 100% (default) means that a single channel can consume up-to all allocated queue's resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the queue.
        :param pulumi.Input[_builtins.str] custom_encryption_key_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the custom encryption key to be used to encrypt messages content.
        :param pulumi.Input[_builtins.int] dead_letter_queue_delivery_count: (Updatable) The number of times a message can be delivered to a consumer before being moved to the dead letter queue. A value of 0 indicates that the DLQ is not used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name of the queue.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] purge_trigger: (Updatable) An optional property when incremented triggers Purge. Could be set to any integer value.
        :param pulumi.Input[_builtins.str] purge_type: (Updatable) An optional value that specifies the purge behavior for the Queue. Could be set to NORMAL, DLQ or BOTH. If unset, the default value is NORMAL
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.int] retention_in_seconds: The retention period of messages in the queue, in seconds.
        :param pulumi.Input[_builtins.int] timeout_in_seconds: (Updatable) The default polling timeout of the messages in the queue, in seconds.
        :param pulumi.Input[_builtins.int] visibility_in_seconds: (Updatable) The default visibility timeout of the messages consumed from the queue, in seconds.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QueueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Queue resource in Oracle Cloud Infrastructure Queue service.

        Creates a new queue.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_queue = oci.queue.Queue("test_queue",
            compartment_id=compartment_id,
            display_name=queue_display_name,
            channel_consumption_limit=queue_channel_consumption_limit,
            custom_encryption_key_id=test_key["id"],
            dead_letter_queue_delivery_count=queue_dead_letter_queue_delivery_count,
            purge_trigger=purge_trigger,
            purge_type=purge_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            retention_in_seconds=queue_retention_in_seconds,
            timeout_in_seconds=queue_timeout_in_seconds,
            visibility_in_seconds=queue_visibility_in_seconds)
        ```

        ## Import

        Queues can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Queue/queue:Queue test_queue "id"
        ```

        :param str resource_name: The name of the resource.
        :param QueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_consumption_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dead_letter_queue_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 purge_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 purge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 visibility_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueueArgs.__new__(QueueArgs)

            __props__.__dict__["channel_consumption_limit"] = channel_consumption_limit
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["custom_encryption_key_id"] = custom_encryption_key_id
            __props__.__dict__["dead_letter_queue_delivery_count"] = dead_letter_queue_delivery_count
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["purge_trigger"] = purge_trigger
            __props__.__dict__["purge_type"] = purge_type
            __props__.__dict__["retention_in_seconds"] = retention_in_seconds
            __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
            __props__.__dict__["visibility_in_seconds"] = visibility_in_seconds
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["messages_endpoint"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Queue, __self__).__init__(
            'oci:Queue/queue:Queue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            channel_consumption_limit: Optional[pulumi.Input[_builtins.int]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            custom_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            dead_letter_queue_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            messages_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            purge_trigger: Optional[pulumi.Input[_builtins.int]] = None,
            purge_type: Optional[pulumi.Input[_builtins.str]] = None,
            retention_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            visibility_in_seconds: Optional[pulumi.Input[_builtins.int]] = None) -> 'Queue':
        """
        Get an existing Queue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] channel_consumption_limit: (Updatable) The percentage of allocated queue resources that can be consumed by a single channel. For example, if a queue has a storage limit of 2Gb, and a single channel consumption limit is 0.1 (10%), that means data size of a single channel  can't exceed 200Mb. Consumption limit of 100% (default) means that a single channel can consume up-to all allocated queue's resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the queue.
        :param pulumi.Input[_builtins.str] custom_encryption_key_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the custom encryption key to be used to encrypt messages content.
        :param pulumi.Input[_builtins.int] dead_letter_queue_delivery_count: (Updatable) The number of times a message can be delivered to a consumer before being moved to the dead letter queue. A value of 0 indicates that the DLQ is not used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The user-friendly name of the queue.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Any additional details about the current state of the queue.
        :param pulumi.Input[_builtins.str] messages_endpoint: The endpoint to use to consume or publish messages in the queue.
        :param pulumi.Input[_builtins.int] purge_trigger: (Updatable) An optional property when incremented triggers Purge. Could be set to any integer value.
        :param pulumi.Input[_builtins.str] purge_type: (Updatable) An optional value that specifies the purge behavior for the Queue. Could be set to NORMAL, DLQ or BOTH. If unset, the default value is NORMAL
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.int] retention_in_seconds: The retention period of messages in the queue, in seconds.
        :param pulumi.Input[_builtins.str] state: The current state of the queue.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time that the queue was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        :param pulumi.Input[_builtins.str] time_updated: The time that the queue was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        :param pulumi.Input[_builtins.int] timeout_in_seconds: (Updatable) The default polling timeout of the messages in the queue, in seconds.
        :param pulumi.Input[_builtins.int] visibility_in_seconds: (Updatable) The default visibility timeout of the messages consumed from the queue, in seconds.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QueueState.__new__(_QueueState)

        __props__.__dict__["channel_consumption_limit"] = channel_consumption_limit
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["custom_encryption_key_id"] = custom_encryption_key_id
        __props__.__dict__["dead_letter_queue_delivery_count"] = dead_letter_queue_delivery_count
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["messages_endpoint"] = messages_endpoint
        __props__.__dict__["purge_trigger"] = purge_trigger
        __props__.__dict__["purge_type"] = purge_type
        __props__.__dict__["retention_in_seconds"] = retention_in_seconds
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
        __props__.__dict__["visibility_in_seconds"] = visibility_in_seconds
        return Queue(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="channelConsumptionLimit")
    def channel_consumption_limit(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The percentage of allocated queue resources that can be consumed by a single channel. For example, if a queue has a storage limit of 2Gb, and a single channel consumption limit is 0.1 (10%), that means data size of a single channel  can't exceed 200Mb. Consumption limit of 100% (default) means that a single channel can consume up-to all allocated queue's resources.
        """
        return pulumi.get(self, "channel_consumption_limit")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the queue.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="customEncryptionKeyId")
    def custom_encryption_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the custom encryption key to be used to encrypt messages content.
        """
        return pulumi.get(self, "custom_encryption_key_id")

    @_builtins.property
    @pulumi.getter(name="deadLetterQueueDeliveryCount")
    def dead_letter_queue_delivery_count(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The number of times a message can be delivered to a consumer before being moved to the dead letter queue. A value of 0 indicates that the DLQ is not used.
        """
        return pulumi.get(self, "dead_letter_queue_delivery_count")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The user-friendly name of the queue.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Any additional details about the current state of the queue.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="messagesEndpoint")
    def messages_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint to use to consume or publish messages in the queue.
        """
        return pulumi.get(self, "messages_endpoint")

    @_builtins.property
    @pulumi.getter(name="purgeTrigger")
    def purge_trigger(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Purge. Could be set to any integer value.
        """
        return pulumi.get(self, "purge_trigger")

    @_builtins.property
    @pulumi.getter(name="purgeType")
    def purge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Updatable) An optional value that specifies the purge behavior for the Queue. Could be set to NORMAL, DLQ or BOTH. If unset, the default value is NORMAL

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "purge_type")

    @_builtins.property
    @pulumi.getter(name="retentionInSeconds")
    def retention_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        The retention period of messages in the queue, in seconds.
        """
        return pulumi.get(self, "retention_in_seconds")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the queue.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time that the queue was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time that the queue was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The default polling timeout of the messages in the queue, in seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="visibilityInSeconds")
    def visibility_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The default visibility timeout of the messages consumed from the queue, in seconds.
        """
        return pulumi.get(self, "visibility_in_seconds")

