# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'SubscriptionRedeemableUserItem',
    'GetResourceQuotasFilterResult',
    'GetResourceQuotasResourceQuotumCollectionResult',
    'GetResourceQuotasResourceQuotumCollectionItemResult',
    'GetResourcesFilterResult',
    'GetResourcesResourcesCollectionResult',
    'GetResourcesResourcesCollectionItemResult',
    'GetResourcesResourcesCollectionItemSkusResult',
    'GetSubscriptionProductItemResult',
    'GetSubscriptionProductsFilterResult',
    'GetSubscriptionProductsProductCollectionResult',
    'GetSubscriptionProductsProductCollectionItemResult',
    'GetSubscriptionProductsProductCollectionItemItemResult',
    'GetSubscriptionRedeemableUserItemResult',
    'GetSubscriptionRedeemableUsersFilterResult',
    'GetSubscriptionRedeemableUsersRedeemableUserCollectionResult',
    'GetSubscriptionRedeemableUsersRedeemableUserCollectionItemResult',
    'GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemResult',
    'GetSubscriptionRedemptionItemResult',
    'GetSubscriptionRedemptionsFilterResult',
    'GetSubscriptionRedemptionsRedemptionCollectionResult',
    'GetSubscriptionRedemptionsRedemptionCollectionItemResult',
    'GetSubscriptionRedemptionsRedemptionCollectionItemItemResult',
    'GetSubscriptionRewardItemResult',
    'GetSubscriptionRewardSummaryResult',
    'GetSubscriptionRewardsFilterResult',
    'GetSubscriptionRewardsRewardCollectionResult',
    'GetSubscriptionRewardsRewardCollectionItemResult',
    'GetSubscriptionRewardsRewardCollectionItemItemResult',
    'GetSubscriptionRewardsRewardCollectionItemSummaryResult',
    'GetUsagelimitsFilterResult',
    'GetUsagelimitsUsageLimitCollectionResult',
    'GetUsagelimitsUsageLimitCollectionItemResult',
]

@pulumi.output_type
class SubscriptionRedeemableUserItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailId":
            suggest = "email_id"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionRedeemableUserItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionRedeemableUserItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionRedeemableUserItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_id: _builtins.str,
                 first_name: Optional[_builtins.str] = None,
                 last_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str email_id: The email ID for a user that can redeem rewards.
        :param _builtins.str first_name: The first name of the user that can redeem rewards.
        :param _builtins.str last_name: The last name of the user that can redeem rewards.
        """
        pulumi.set(__self__, "email_id", email_id)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)

    @_builtins.property
    @pulumi.getter(name="emailId")
    def email_id(self) -> _builtins.str:
        """
        The email ID for a user that can redeem rewards.
        """
        return pulumi.get(self, "email_id")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[_builtins.str]:
        """
        The first name of the user that can redeem rewards.
        """
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[_builtins.str]:
        """
        The last name of the user that can redeem rewards.
        """
        return pulumi.get(self, "last_name")


@pulumi.output_type
class GetResourceQuotasFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The resource name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetResourceQuotasResourceQuotumCollectionResult(dict):
    def __init__(__self__, *,
                 is_allowed: _builtins.bool,
                 items: Sequence['outputs.GetResourceQuotasResourceQuotumCollectionItemResult']):
        """
        :param _builtins.bool is_allowed: Used to indicate if further quota consumption isAllowed.
        :param Sequence['GetResourceQuotasResourceQuotumCollectionItemArgs'] items: The list of resource quota details.
        """
        pulumi.set(__self__, "is_allowed", is_allowed)
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter(name="isAllowed")
    def is_allowed(self) -> _builtins.bool:
        """
        Used to indicate if further quota consumption isAllowed.
        """
        return pulumi.get(self, "is_allowed")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetResourceQuotasResourceQuotumCollectionItemResult']:
        """
        The list of resource quota details.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetResourceQuotasResourceQuotumCollectionItemResult(dict):
    def __init__(__self__, *,
                 affected_resource: _builtins.str,
                 balance: _builtins.float,
                 is_allowed: _builtins.bool,
                 is_dependency: _builtins.bool,
                 is_overage: _builtins.bool,
                 name: _builtins.str,
                 purchased_limit: _builtins.float,
                 service: _builtins.str):
        """
        :param _builtins.str affected_resource: The affected resource name.
        :param _builtins.float balance: The quota balance.
        :param _builtins.bool is_allowed: Used to indicate if further quota consumption isAllowed.
        :param _builtins.bool is_dependency: Used to indicate any resource dependencies.
        :param _builtins.bool is_overage: Used to indicate if overages are incurred.
        :param _builtins.str name: The resource name.
        :param _builtins.float purchased_limit: The purchased quota limit.
        :param _builtins.str service: The service name.
        """
        pulumi.set(__self__, "affected_resource", affected_resource)
        pulumi.set(__self__, "balance", balance)
        pulumi.set(__self__, "is_allowed", is_allowed)
        pulumi.set(__self__, "is_dependency", is_dependency)
        pulumi.set(__self__, "is_overage", is_overage)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "purchased_limit", purchased_limit)
        pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter(name="affectedResource")
    def affected_resource(self) -> _builtins.str:
        """
        The affected resource name.
        """
        return pulumi.get(self, "affected_resource")

    @_builtins.property
    @pulumi.getter
    def balance(self) -> _builtins.float:
        """
        The quota balance.
        """
        return pulumi.get(self, "balance")

    @_builtins.property
    @pulumi.getter(name="isAllowed")
    def is_allowed(self) -> _builtins.bool:
        """
        Used to indicate if further quota consumption isAllowed.
        """
        return pulumi.get(self, "is_allowed")

    @_builtins.property
    @pulumi.getter(name="isDependency")
    def is_dependency(self) -> _builtins.bool:
        """
        Used to indicate any resource dependencies.
        """
        return pulumi.get(self, "is_dependency")

    @_builtins.property
    @pulumi.getter(name="isOverage")
    def is_overage(self) -> _builtins.bool:
        """
        Used to indicate if overages are incurred.
        """
        return pulumi.get(self, "is_overage")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="purchasedLimit")
    def purchased_limit(self) -> _builtins.float:
        """
        The purchased quota limit.
        """
        return pulumi.get(self, "purchased_limit")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        The service name.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GetResourcesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Name of the resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetResourcesResourcesCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetResourcesResourcesCollectionItemResult']):
        """
        :param Sequence['GetResourcesResourcesCollectionItemArgs'] items: The list of resource details for a service.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetResourcesResourcesCollectionItemResult']:
        """
        The list of resource details for a service.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetResourcesResourcesCollectionItemResult(dict):
    def __init__(__self__, *,
                 child_resources: Sequence[_builtins.str],
                 daily_unit_display_name: _builtins.str,
                 description: _builtins.str,
                 hourly_unit_display_name: _builtins.str,
                 instance_type: _builtins.str,
                 is_purchased: _builtins.bool,
                 name: _builtins.str,
                 raw_unit_display_name: _builtins.str,
                 servicename: _builtins.str,
                 skuses: Sequence['outputs.GetResourcesResourcesCollectionItemSkusResult'],
                 usage_data_type: _builtins.str):
        """
        :param Sequence[_builtins.str] child_resources: The details of any child resources.
        :param _builtins.str daily_unit_display_name: Units to be used for daily aggregated data.
        :param _builtins.str description: Description of the resource.
        :param _builtins.str hourly_unit_display_name: Units to be used for hourly aggregated data.
        :param _builtins.str instance_type: Instance type for the resource.
        :param _builtins.bool is_purchased: Indicates if the SKU was purchased
        :param _builtins.str name: Name of the resource.
        :param _builtins.str raw_unit_display_name: Default units to use when unspecified.
        :param _builtins.str servicename: Name of the service.
        :param Sequence['GetResourcesResourcesCollectionItemSkusArgs'] skuses: The details of resource Skus.
        :param _builtins.str usage_data_type: Usage data type of the resource.
        """
        pulumi.set(__self__, "child_resources", child_resources)
        pulumi.set(__self__, "daily_unit_display_name", daily_unit_display_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "hourly_unit_display_name", hourly_unit_display_name)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "is_purchased", is_purchased)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "raw_unit_display_name", raw_unit_display_name)
        pulumi.set(__self__, "servicename", servicename)
        pulumi.set(__self__, "skuses", skuses)
        pulumi.set(__self__, "usage_data_type", usage_data_type)

    @_builtins.property
    @pulumi.getter(name="childResources")
    def child_resources(self) -> Sequence[_builtins.str]:
        """
        The details of any child resources.
        """
        return pulumi.get(self, "child_resources")

    @_builtins.property
    @pulumi.getter(name="dailyUnitDisplayName")
    def daily_unit_display_name(self) -> _builtins.str:
        """
        Units to be used for daily aggregated data.
        """
        return pulumi.get(self, "daily_unit_display_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="hourlyUnitDisplayName")
    def hourly_unit_display_name(self) -> _builtins.str:
        """
        Units to be used for hourly aggregated data.
        """
        return pulumi.get(self, "hourly_unit_display_name")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        Instance type for the resource.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="isPurchased")
    def is_purchased(self) -> _builtins.bool:
        """
        Indicates if the SKU was purchased
        """
        return pulumi.get(self, "is_purchased")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="rawUnitDisplayName")
    def raw_unit_display_name(self) -> _builtins.str:
        """
        Default units to use when unspecified.
        """
        return pulumi.get(self, "raw_unit_display_name")

    @_builtins.property
    @pulumi.getter
    def servicename(self) -> _builtins.str:
        """
        Name of the service.
        """
        return pulumi.get(self, "servicename")

    @_builtins.property
    @pulumi.getter
    def skuses(self) -> Sequence['outputs.GetResourcesResourcesCollectionItemSkusResult']:
        """
        The details of resource Skus.
        """
        return pulumi.get(self, "skuses")

    @_builtins.property
    @pulumi.getter(name="usageDataType")
    def usage_data_type(self) -> _builtins.str:
        """
        Usage data type of the resource.
        """
        return pulumi.get(self, "usage_data_type")


@pulumi.output_type
class GetResourcesResourcesCollectionItemSkusResult(dict):
    def __init__(__self__, *,
                 cloud_credit_type: _builtins.str,
                 sku_id: _builtins.str,
                 sku_type: _builtins.str):
        """
        :param _builtins.str cloud_credit_type: The cloud credit type for the resource.
        :param _builtins.str sku_id: The Sku Id for the resource.
        :param _builtins.str sku_type: The Sku type for the resource.
        """
        pulumi.set(__self__, "cloud_credit_type", cloud_credit_type)
        pulumi.set(__self__, "sku_id", sku_id)
        pulumi.set(__self__, "sku_type", sku_type)

    @_builtins.property
    @pulumi.getter(name="cloudCreditType")
    def cloud_credit_type(self) -> _builtins.str:
        """
        The cloud credit type for the resource.
        """
        return pulumi.get(self, "cloud_credit_type")

    @_builtins.property
    @pulumi.getter(name="skuId")
    def sku_id(self) -> _builtins.str:
        """
        The Sku Id for the resource.
        """
        return pulumi.get(self, "sku_id")

    @_builtins.property
    @pulumi.getter(name="skuType")
    def sku_type(self) -> _builtins.str:
        """
        The Sku type for the resource.
        """
        return pulumi.get(self, "sku_type")


@pulumi.output_type
class GetSubscriptionProductItemResult(dict):
    def __init__(__self__, *,
                 earned_rewards: _builtins.float,
                 is_eligible_to_earn_rewards: _builtins.bool,
                 product_name: _builtins.str,
                 product_number: _builtins.str,
                 usage_amount: _builtins.float):
        """
        :param _builtins.float earned_rewards: The earned rewards for the product.
        :param _builtins.bool is_eligible_to_earn_rewards: The boolean parameter to indicate if the product is eligible to earn rewards.
        :param _builtins.str product_name: The rate card product name.
        :param _builtins.str product_number: The rate card product number.
        :param _builtins.float usage_amount: The rate card product usage amount.
        """
        pulumi.set(__self__, "earned_rewards", earned_rewards)
        pulumi.set(__self__, "is_eligible_to_earn_rewards", is_eligible_to_earn_rewards)
        pulumi.set(__self__, "product_name", product_name)
        pulumi.set(__self__, "product_number", product_number)
        pulumi.set(__self__, "usage_amount", usage_amount)

    @_builtins.property
    @pulumi.getter(name="earnedRewards")
    def earned_rewards(self) -> _builtins.float:
        """
        The earned rewards for the product.
        """
        return pulumi.get(self, "earned_rewards")

    @_builtins.property
    @pulumi.getter(name="isEligibleToEarnRewards")
    def is_eligible_to_earn_rewards(self) -> _builtins.bool:
        """
        The boolean parameter to indicate if the product is eligible to earn rewards.
        """
        return pulumi.get(self, "is_eligible_to_earn_rewards")

    @_builtins.property
    @pulumi.getter(name="productName")
    def product_name(self) -> _builtins.str:
        """
        The rate card product name.
        """
        return pulumi.get(self, "product_name")

    @_builtins.property
    @pulumi.getter(name="productNumber")
    def product_number(self) -> _builtins.str:
        """
        The rate card product number.
        """
        return pulumi.get(self, "product_number")

    @_builtins.property
    @pulumi.getter(name="usageAmount")
    def usage_amount(self) -> _builtins.float:
        """
        The rate card product usage amount.
        """
        return pulumi.get(self, "usage_amount")


@pulumi.output_type
class GetSubscriptionProductsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionProductsProductCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionProductsProductCollectionItemResult']):
        """
        :param Sequence['GetSubscriptionProductsProductCollectionItemArgs'] items: The list of product rewards summaries.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionProductsProductCollectionItemResult']:
        """
        The list of product rewards summaries.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionProductsProductCollectionItemResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionProductsProductCollectionItemItemResult']):
        """
        :param Sequence['GetSubscriptionProductsProductCollectionItemItemArgs'] items: The list of product rewards summaries.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionProductsProductCollectionItemItemResult']:
        """
        The list of product rewards summaries.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionProductsProductCollectionItemItemResult(dict):
    def __init__(__self__, *,
                 earned_rewards: _builtins.float,
                 is_eligible_to_earn_rewards: _builtins.bool,
                 product_name: _builtins.str,
                 product_number: _builtins.str,
                 usage_amount: _builtins.float):
        """
        :param _builtins.float earned_rewards: The earned rewards for the product.
        :param _builtins.bool is_eligible_to_earn_rewards: The boolean parameter to indicate if the product is eligible to earn rewards.
        :param _builtins.str product_name: The rate card product name.
        :param _builtins.str product_number: The rate card product number.
        :param _builtins.float usage_amount: The rate card product usage amount.
        """
        pulumi.set(__self__, "earned_rewards", earned_rewards)
        pulumi.set(__self__, "is_eligible_to_earn_rewards", is_eligible_to_earn_rewards)
        pulumi.set(__self__, "product_name", product_name)
        pulumi.set(__self__, "product_number", product_number)
        pulumi.set(__self__, "usage_amount", usage_amount)

    @_builtins.property
    @pulumi.getter(name="earnedRewards")
    def earned_rewards(self) -> _builtins.float:
        """
        The earned rewards for the product.
        """
        return pulumi.get(self, "earned_rewards")

    @_builtins.property
    @pulumi.getter(name="isEligibleToEarnRewards")
    def is_eligible_to_earn_rewards(self) -> _builtins.bool:
        """
        The boolean parameter to indicate if the product is eligible to earn rewards.
        """
        return pulumi.get(self, "is_eligible_to_earn_rewards")

    @_builtins.property
    @pulumi.getter(name="productName")
    def product_name(self) -> _builtins.str:
        """
        The rate card product name.
        """
        return pulumi.get(self, "product_name")

    @_builtins.property
    @pulumi.getter(name="productNumber")
    def product_number(self) -> _builtins.str:
        """
        The rate card product number.
        """
        return pulumi.get(self, "product_number")

    @_builtins.property
    @pulumi.getter(name="usageAmount")
    def usage_amount(self) -> _builtins.float:
        """
        The rate card product usage amount.
        """
        return pulumi.get(self, "usage_amount")


@pulumi.output_type
class GetSubscriptionRedeemableUserItemResult(dict):
    def __init__(__self__, *,
                 email_id: _builtins.str,
                 first_name: _builtins.str,
                 last_name: _builtins.str):
        """
        :param _builtins.str email_id: The email ID of the user that can redeem rewards.
        :param _builtins.str first_name: The first name of the user that can redeem rewards.
        :param _builtins.str last_name: The last name of the user that can redeem rewards.
        """
        pulumi.set(__self__, "email_id", email_id)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_name", last_name)

    @_builtins.property
    @pulumi.getter(name="emailId")
    def email_id(self) -> _builtins.str:
        """
        The email ID of the user that can redeem rewards.
        """
        return pulumi.get(self, "email_id")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> _builtins.str:
        """
        The first name of the user that can redeem rewards.
        """
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> _builtins.str:
        """
        The last name of the user that can redeem rewards.
        """
        return pulumi.get(self, "last_name")


@pulumi.output_type
class GetSubscriptionRedeemableUsersFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionRedeemableUsersRedeemableUserCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRedeemableUsersRedeemableUserCollectionItemResult']):
        """
        :param Sequence['GetSubscriptionRedeemableUsersRedeemableUserCollectionItemArgs'] items: The list of user summary that can redeem rewards.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRedeemableUsersRedeemableUserCollectionItemResult']:
        """
        The list of user summary that can redeem rewards.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionRedeemableUsersRedeemableUserCollectionItemResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemResult'],
                 subscription_id: _builtins.str,
                 tenancy_id: _builtins.str,
                 user_id: _builtins.str):
        """
        :param Sequence['GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemArgs'] items: The list of user summary that can redeem rewards.
        :param _builtins.str subscription_id: The subscription ID for which rewards information is requested for.
        :param _builtins.str tenancy_id: The OCID of the tenancy.
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemResult']:
        """
        The list of user summary that can redeem rewards.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        """
        The subscription ID for which rewards information is requested for.
        """
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> _builtins.str:
        """
        The OCID of the tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemResult(dict):
    def __init__(__self__, *,
                 email_id: _builtins.str,
                 first_name: _builtins.str,
                 last_name: _builtins.str):
        """
        :param _builtins.str email_id: The email ID of the user that can redeem rewards.
        :param _builtins.str first_name: The first name of the user that can redeem rewards.
        :param _builtins.str last_name: The last name of the user that can redeem rewards.
        """
        pulumi.set(__self__, "email_id", email_id)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_name", last_name)

    @_builtins.property
    @pulumi.getter(name="emailId")
    def email_id(self) -> _builtins.str:
        """
        The email ID of the user that can redeem rewards.
        """
        return pulumi.get(self, "email_id")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> _builtins.str:
        """
        The first name of the user that can redeem rewards.
        """
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> _builtins.str:
        """
        The last name of the user that can redeem rewards.
        """
        return pulumi.get(self, "last_name")


@pulumi.output_type
class GetSubscriptionRedemptionItemResult(dict):
    def __init__(__self__, *,
                 base_rewards: _builtins.float,
                 fx_rate: _builtins.float,
                 invoice_currency: _builtins.str,
                 invoice_number: _builtins.str,
                 invoice_total_amount: _builtins.float,
                 redeemed_rewards: _builtins.float,
                 redemption_code: _builtins.str,
                 redemption_email: _builtins.str,
                 time_invoiced: _builtins.str,
                 time_redeemed: _builtins.str):
        """
        :param _builtins.float base_rewards: It provides the redeemed rewards in base/subscription currency.
        :param _builtins.float fx_rate: It provides the fxRate between invoice currency and subscription currency.
        :param _builtins.str invoice_currency: The currency associated with invoice.
        :param _builtins.str invoice_number: It provides the invoice number against the redemption.
        :param _builtins.float invoice_total_amount: It provides the invoice total amount of given redemption.
        :param _builtins.float redeemed_rewards: It provides the redeemed rewards in invoice currency.
        :param _builtins.str redemption_code: The redemption code used in the Billing Center during the reward redemption process.
        :param _builtins.str redemption_email: It provides the redemption email id.
        :param _builtins.str time_invoiced: It provides the invoice date.
        :param _builtins.str time_redeemed: It provides redeem date.
        """
        pulumi.set(__self__, "base_rewards", base_rewards)
        pulumi.set(__self__, "fx_rate", fx_rate)
        pulumi.set(__self__, "invoice_currency", invoice_currency)
        pulumi.set(__self__, "invoice_number", invoice_number)
        pulumi.set(__self__, "invoice_total_amount", invoice_total_amount)
        pulumi.set(__self__, "redeemed_rewards", redeemed_rewards)
        pulumi.set(__self__, "redemption_code", redemption_code)
        pulumi.set(__self__, "redemption_email", redemption_email)
        pulumi.set(__self__, "time_invoiced", time_invoiced)
        pulumi.set(__self__, "time_redeemed", time_redeemed)

    @_builtins.property
    @pulumi.getter(name="baseRewards")
    def base_rewards(self) -> _builtins.float:
        """
        It provides the redeemed rewards in base/subscription currency.
        """
        return pulumi.get(self, "base_rewards")

    @_builtins.property
    @pulumi.getter(name="fxRate")
    def fx_rate(self) -> _builtins.float:
        """
        It provides the fxRate between invoice currency and subscription currency.
        """
        return pulumi.get(self, "fx_rate")

    @_builtins.property
    @pulumi.getter(name="invoiceCurrency")
    def invoice_currency(self) -> _builtins.str:
        """
        The currency associated with invoice.
        """
        return pulumi.get(self, "invoice_currency")

    @_builtins.property
    @pulumi.getter(name="invoiceNumber")
    def invoice_number(self) -> _builtins.str:
        """
        It provides the invoice number against the redemption.
        """
        return pulumi.get(self, "invoice_number")

    @_builtins.property
    @pulumi.getter(name="invoiceTotalAmount")
    def invoice_total_amount(self) -> _builtins.float:
        """
        It provides the invoice total amount of given redemption.
        """
        return pulumi.get(self, "invoice_total_amount")

    @_builtins.property
    @pulumi.getter(name="redeemedRewards")
    def redeemed_rewards(self) -> _builtins.float:
        """
        It provides the redeemed rewards in invoice currency.
        """
        return pulumi.get(self, "redeemed_rewards")

    @_builtins.property
    @pulumi.getter(name="redemptionCode")
    def redemption_code(self) -> _builtins.str:
        """
        The redemption code used in the Billing Center during the reward redemption process.
        """
        return pulumi.get(self, "redemption_code")

    @_builtins.property
    @pulumi.getter(name="redemptionEmail")
    def redemption_email(self) -> _builtins.str:
        """
        It provides the redemption email id.
        """
        return pulumi.get(self, "redemption_email")

    @_builtins.property
    @pulumi.getter(name="timeInvoiced")
    def time_invoiced(self) -> _builtins.str:
        """
        It provides the invoice date.
        """
        return pulumi.get(self, "time_invoiced")

    @_builtins.property
    @pulumi.getter(name="timeRedeemed")
    def time_redeemed(self) -> _builtins.str:
        """
        It provides redeem date.
        """
        return pulumi.get(self, "time_redeemed")


@pulumi.output_type
class GetSubscriptionRedemptionsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionRedemptionsRedemptionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRedemptionsRedemptionCollectionItemResult']):
        """
        :param Sequence['GetSubscriptionRedemptionsRedemptionCollectionItemArgs'] items: The list of redemption summary.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRedemptionsRedemptionCollectionItemResult']:
        """
        The list of redemption summary.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionRedemptionsRedemptionCollectionItemResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRedemptionsRedemptionCollectionItemItemResult']):
        """
        :param Sequence['GetSubscriptionRedemptionsRedemptionCollectionItemItemArgs'] items: The list of redemption summary.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRedemptionsRedemptionCollectionItemItemResult']:
        """
        The list of redemption summary.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionRedemptionsRedemptionCollectionItemItemResult(dict):
    def __init__(__self__, *,
                 base_rewards: _builtins.float,
                 fx_rate: _builtins.float,
                 invoice_currency: _builtins.str,
                 invoice_number: _builtins.str,
                 invoice_total_amount: _builtins.float,
                 redeemed_rewards: _builtins.float,
                 redemption_code: _builtins.str,
                 redemption_email: _builtins.str,
                 time_invoiced: _builtins.str,
                 time_redeemed: _builtins.str):
        """
        :param _builtins.float base_rewards: It provides the redeemed rewards in base/subscription currency.
        :param _builtins.float fx_rate: It provides the fxRate between invoice currency and subscription currency.
        :param _builtins.str invoice_currency: The currency associated with invoice.
        :param _builtins.str invoice_number: It provides the invoice number against the redemption.
        :param _builtins.float invoice_total_amount: It provides the invoice total amount of given redemption.
        :param _builtins.float redeemed_rewards: It provides the redeemed rewards in invoice currency.
        :param _builtins.str redemption_code: The redemption code used in the Billing Center during the reward redemption process.
        :param _builtins.str redemption_email: It provides the redemption email id.
        :param _builtins.str time_invoiced: It provides the invoice date.
        :param _builtins.str time_redeemed: It provides redeem date.
        """
        pulumi.set(__self__, "base_rewards", base_rewards)
        pulumi.set(__self__, "fx_rate", fx_rate)
        pulumi.set(__self__, "invoice_currency", invoice_currency)
        pulumi.set(__self__, "invoice_number", invoice_number)
        pulumi.set(__self__, "invoice_total_amount", invoice_total_amount)
        pulumi.set(__self__, "redeemed_rewards", redeemed_rewards)
        pulumi.set(__self__, "redemption_code", redemption_code)
        pulumi.set(__self__, "redemption_email", redemption_email)
        pulumi.set(__self__, "time_invoiced", time_invoiced)
        pulumi.set(__self__, "time_redeemed", time_redeemed)

    @_builtins.property
    @pulumi.getter(name="baseRewards")
    def base_rewards(self) -> _builtins.float:
        """
        It provides the redeemed rewards in base/subscription currency.
        """
        return pulumi.get(self, "base_rewards")

    @_builtins.property
    @pulumi.getter(name="fxRate")
    def fx_rate(self) -> _builtins.float:
        """
        It provides the fxRate between invoice currency and subscription currency.
        """
        return pulumi.get(self, "fx_rate")

    @_builtins.property
    @pulumi.getter(name="invoiceCurrency")
    def invoice_currency(self) -> _builtins.str:
        """
        The currency associated with invoice.
        """
        return pulumi.get(self, "invoice_currency")

    @_builtins.property
    @pulumi.getter(name="invoiceNumber")
    def invoice_number(self) -> _builtins.str:
        """
        It provides the invoice number against the redemption.
        """
        return pulumi.get(self, "invoice_number")

    @_builtins.property
    @pulumi.getter(name="invoiceTotalAmount")
    def invoice_total_amount(self) -> _builtins.float:
        """
        It provides the invoice total amount of given redemption.
        """
        return pulumi.get(self, "invoice_total_amount")

    @_builtins.property
    @pulumi.getter(name="redeemedRewards")
    def redeemed_rewards(self) -> _builtins.float:
        """
        It provides the redeemed rewards in invoice currency.
        """
        return pulumi.get(self, "redeemed_rewards")

    @_builtins.property
    @pulumi.getter(name="redemptionCode")
    def redemption_code(self) -> _builtins.str:
        """
        The redemption code used in the Billing Center during the reward redemption process.
        """
        return pulumi.get(self, "redemption_code")

    @_builtins.property
    @pulumi.getter(name="redemptionEmail")
    def redemption_email(self) -> _builtins.str:
        """
        It provides the redemption email id.
        """
        return pulumi.get(self, "redemption_email")

    @_builtins.property
    @pulumi.getter(name="timeInvoiced")
    def time_invoiced(self) -> _builtins.str:
        """
        It provides the invoice date.
        """
        return pulumi.get(self, "time_invoiced")

    @_builtins.property
    @pulumi.getter(name="timeRedeemed")
    def time_redeemed(self) -> _builtins.str:
        """
        It provides redeem date.
        """
        return pulumi.get(self, "time_redeemed")


@pulumi.output_type
class GetSubscriptionRewardItemResult(dict):
    def __init__(__self__, *,
                 available_rewards: _builtins.float,
                 earned_rewards: _builtins.float,
                 eligible_usage_amount: _builtins.float,
                 ineligible_usage_amount: _builtins.float,
                 is_manual: _builtins.bool,
                 redeemed_rewards: _builtins.float,
                 time_rewards_earned: _builtins.str,
                 time_rewards_expired: _builtins.str,
                 time_usage_ended: _builtins.str,
                 time_usage_started: _builtins.str,
                 usage_amount: _builtins.float,
                 usage_period_key: _builtins.str):
        """
        :param _builtins.float available_rewards: The number of rewards available for a specific usage period.
        :param _builtins.float earned_rewards: The number of rewards earned for the specific usage period.
        :param _builtins.float eligible_usage_amount: The eligible usage amount for the usage period.
        :param _builtins.float ineligible_usage_amount: The ineligible usage amount for the usage period.
        :param _builtins.bool is_manual: The boolean parameter to indicate whether or not the available rewards are manually posted.
        :param _builtins.float redeemed_rewards: The number of rewards redeemed for a specific month.
        :param _builtins.str time_rewards_earned: The date and time when rewards accrue.
        :param _builtins.str time_rewards_expired: The date and time when rewards expire.
        :param _builtins.str time_usage_ended: The end date and time for the usage period.
        :param _builtins.str time_usage_started: The start date and time for the usage period.
        :param _builtins.float usage_amount: The usage amount for the usage period.
        :param _builtins.str usage_period_key: The usage period ID.
        """
        pulumi.set(__self__, "available_rewards", available_rewards)
        pulumi.set(__self__, "earned_rewards", earned_rewards)
        pulumi.set(__self__, "eligible_usage_amount", eligible_usage_amount)
        pulumi.set(__self__, "ineligible_usage_amount", ineligible_usage_amount)
        pulumi.set(__self__, "is_manual", is_manual)
        pulumi.set(__self__, "redeemed_rewards", redeemed_rewards)
        pulumi.set(__self__, "time_rewards_earned", time_rewards_earned)
        pulumi.set(__self__, "time_rewards_expired", time_rewards_expired)
        pulumi.set(__self__, "time_usage_ended", time_usage_ended)
        pulumi.set(__self__, "time_usage_started", time_usage_started)
        pulumi.set(__self__, "usage_amount", usage_amount)
        pulumi.set(__self__, "usage_period_key", usage_period_key)

    @_builtins.property
    @pulumi.getter(name="availableRewards")
    def available_rewards(self) -> _builtins.float:
        """
        The number of rewards available for a specific usage period.
        """
        return pulumi.get(self, "available_rewards")

    @_builtins.property
    @pulumi.getter(name="earnedRewards")
    def earned_rewards(self) -> _builtins.float:
        """
        The number of rewards earned for the specific usage period.
        """
        return pulumi.get(self, "earned_rewards")

    @_builtins.property
    @pulumi.getter(name="eligibleUsageAmount")
    def eligible_usage_amount(self) -> _builtins.float:
        """
        The eligible usage amount for the usage period.
        """
        return pulumi.get(self, "eligible_usage_amount")

    @_builtins.property
    @pulumi.getter(name="ineligibleUsageAmount")
    def ineligible_usage_amount(self) -> _builtins.float:
        """
        The ineligible usage amount for the usage period.
        """
        return pulumi.get(self, "ineligible_usage_amount")

    @_builtins.property
    @pulumi.getter(name="isManual")
    def is_manual(self) -> _builtins.bool:
        """
        The boolean parameter to indicate whether or not the available rewards are manually posted.
        """
        return pulumi.get(self, "is_manual")

    @_builtins.property
    @pulumi.getter(name="redeemedRewards")
    def redeemed_rewards(self) -> _builtins.float:
        """
        The number of rewards redeemed for a specific month.
        """
        return pulumi.get(self, "redeemed_rewards")

    @_builtins.property
    @pulumi.getter(name="timeRewardsEarned")
    def time_rewards_earned(self) -> _builtins.str:
        """
        The date and time when rewards accrue.
        """
        return pulumi.get(self, "time_rewards_earned")

    @_builtins.property
    @pulumi.getter(name="timeRewardsExpired")
    def time_rewards_expired(self) -> _builtins.str:
        """
        The date and time when rewards expire.
        """
        return pulumi.get(self, "time_rewards_expired")

    @_builtins.property
    @pulumi.getter(name="timeUsageEnded")
    def time_usage_ended(self) -> _builtins.str:
        """
        The end date and time for the usage period.
        """
        return pulumi.get(self, "time_usage_ended")

    @_builtins.property
    @pulumi.getter(name="timeUsageStarted")
    def time_usage_started(self) -> _builtins.str:
        """
        The start date and time for the usage period.
        """
        return pulumi.get(self, "time_usage_started")

    @_builtins.property
    @pulumi.getter(name="usageAmount")
    def usage_amount(self) -> _builtins.float:
        """
        The usage amount for the usage period.
        """
        return pulumi.get(self, "usage_amount")

    @_builtins.property
    @pulumi.getter(name="usagePeriodKey")
    def usage_period_key(self) -> _builtins.str:
        """
        The usage period ID.
        """
        return pulumi.get(self, "usage_period_key")


@pulumi.output_type
class GetSubscriptionRewardSummaryResult(dict):
    def __init__(__self__, *,
                 currency: _builtins.str,
                 redemption_code: _builtins.str,
                 rewards_rate: _builtins.float,
                 subscription_id: _builtins.str,
                 tenancy_id: _builtins.str,
                 total_rewards_available: _builtins.float):
        """
        :param _builtins.str currency: The currency unit for the reward amount.
        :param _builtins.str redemption_code: The redemption code used in the Billing Center during the reward redemption process.
        :param _builtins.float rewards_rate: The current Rewards percentage in decimal format.
        :param _builtins.str subscription_id: The subscription ID for which rewards information is requested for.
        :param _builtins.str tenancy_id: The OCID of the tenancy.
        :param _builtins.float total_rewards_available: The total number of available rewards for a given subscription ID.
        """
        pulumi.set(__self__, "currency", currency)
        pulumi.set(__self__, "redemption_code", redemption_code)
        pulumi.set(__self__, "rewards_rate", rewards_rate)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        pulumi.set(__self__, "total_rewards_available", total_rewards_available)

    @_builtins.property
    @pulumi.getter
    def currency(self) -> _builtins.str:
        """
        The currency unit for the reward amount.
        """
        return pulumi.get(self, "currency")

    @_builtins.property
    @pulumi.getter(name="redemptionCode")
    def redemption_code(self) -> _builtins.str:
        """
        The redemption code used in the Billing Center during the reward redemption process.
        """
        return pulumi.get(self, "redemption_code")

    @_builtins.property
    @pulumi.getter(name="rewardsRate")
    def rewards_rate(self) -> _builtins.float:
        """
        The current Rewards percentage in decimal format.
        """
        return pulumi.get(self, "rewards_rate")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        """
        The subscription ID for which rewards information is requested for.
        """
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> _builtins.str:
        """
        The OCID of the tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @_builtins.property
    @pulumi.getter(name="totalRewardsAvailable")
    def total_rewards_available(self) -> _builtins.float:
        """
        The total number of available rewards for a given subscription ID.
        """
        return pulumi.get(self, "total_rewards_available")


@pulumi.output_type
class GetSubscriptionRewardsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionRewardsRewardCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemResult']):
        """
        :param Sequence['GetSubscriptionRewardsRewardCollectionItemArgs'] items: The monthly summary of rewards.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemResult']:
        """
        The monthly summary of rewards.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionRewardsRewardCollectionItemResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemItemResult'],
                 summaries: Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemSummaryResult']):
        """
        :param Sequence['GetSubscriptionRewardsRewardCollectionItemItemArgs'] items: The monthly summary of rewards.
        :param Sequence['GetSubscriptionRewardsRewardCollectionItemSummaryArgs'] summaries: The overall monthly reward summary.
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "summaries", summaries)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemItemResult']:
        """
        The monthly summary of rewards.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def summaries(self) -> Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemSummaryResult']:
        """
        The overall monthly reward summary.
        """
        return pulumi.get(self, "summaries")


@pulumi.output_type
class GetSubscriptionRewardsRewardCollectionItemItemResult(dict):
    def __init__(__self__, *,
                 available_rewards: _builtins.float,
                 earned_rewards: _builtins.float,
                 eligible_usage_amount: _builtins.float,
                 ineligible_usage_amount: _builtins.float,
                 is_manual: _builtins.bool,
                 redeemed_rewards: _builtins.float,
                 time_rewards_earned: _builtins.str,
                 time_rewards_expired: _builtins.str,
                 time_usage_ended: _builtins.str,
                 time_usage_started: _builtins.str,
                 usage_amount: _builtins.float,
                 usage_period_key: _builtins.str):
        """
        :param _builtins.float available_rewards: The number of rewards available for a specific usage period.
        :param _builtins.float earned_rewards: The number of rewards earned for the specific usage period.
        :param _builtins.float eligible_usage_amount: The eligible usage amount for the usage period.
        :param _builtins.float ineligible_usage_amount: The ineligible usage amount for the usage period.
        :param _builtins.bool is_manual: The boolean parameter to indicate whether or not the available rewards are manually posted.
        :param _builtins.float redeemed_rewards: The number of rewards redeemed for a specific month.
        :param _builtins.str time_rewards_earned: The date and time when rewards accrue.
        :param _builtins.str time_rewards_expired: The date and time when rewards expire.
        :param _builtins.str time_usage_ended: The end date and time for the usage period.
        :param _builtins.str time_usage_started: The start date and time for the usage period.
        :param _builtins.float usage_amount: The usage amount for the usage period.
        :param _builtins.str usage_period_key: The usage period ID.
        """
        pulumi.set(__self__, "available_rewards", available_rewards)
        pulumi.set(__self__, "earned_rewards", earned_rewards)
        pulumi.set(__self__, "eligible_usage_amount", eligible_usage_amount)
        pulumi.set(__self__, "ineligible_usage_amount", ineligible_usage_amount)
        pulumi.set(__self__, "is_manual", is_manual)
        pulumi.set(__self__, "redeemed_rewards", redeemed_rewards)
        pulumi.set(__self__, "time_rewards_earned", time_rewards_earned)
        pulumi.set(__self__, "time_rewards_expired", time_rewards_expired)
        pulumi.set(__self__, "time_usage_ended", time_usage_ended)
        pulumi.set(__self__, "time_usage_started", time_usage_started)
        pulumi.set(__self__, "usage_amount", usage_amount)
        pulumi.set(__self__, "usage_period_key", usage_period_key)

    @_builtins.property
    @pulumi.getter(name="availableRewards")
    def available_rewards(self) -> _builtins.float:
        """
        The number of rewards available for a specific usage period.
        """
        return pulumi.get(self, "available_rewards")

    @_builtins.property
    @pulumi.getter(name="earnedRewards")
    def earned_rewards(self) -> _builtins.float:
        """
        The number of rewards earned for the specific usage period.
        """
        return pulumi.get(self, "earned_rewards")

    @_builtins.property
    @pulumi.getter(name="eligibleUsageAmount")
    def eligible_usage_amount(self) -> _builtins.float:
        """
        The eligible usage amount for the usage period.
        """
        return pulumi.get(self, "eligible_usage_amount")

    @_builtins.property
    @pulumi.getter(name="ineligibleUsageAmount")
    def ineligible_usage_amount(self) -> _builtins.float:
        """
        The ineligible usage amount for the usage period.
        """
        return pulumi.get(self, "ineligible_usage_amount")

    @_builtins.property
    @pulumi.getter(name="isManual")
    def is_manual(self) -> _builtins.bool:
        """
        The boolean parameter to indicate whether or not the available rewards are manually posted.
        """
        return pulumi.get(self, "is_manual")

    @_builtins.property
    @pulumi.getter(name="redeemedRewards")
    def redeemed_rewards(self) -> _builtins.float:
        """
        The number of rewards redeemed for a specific month.
        """
        return pulumi.get(self, "redeemed_rewards")

    @_builtins.property
    @pulumi.getter(name="timeRewardsEarned")
    def time_rewards_earned(self) -> _builtins.str:
        """
        The date and time when rewards accrue.
        """
        return pulumi.get(self, "time_rewards_earned")

    @_builtins.property
    @pulumi.getter(name="timeRewardsExpired")
    def time_rewards_expired(self) -> _builtins.str:
        """
        The date and time when rewards expire.
        """
        return pulumi.get(self, "time_rewards_expired")

    @_builtins.property
    @pulumi.getter(name="timeUsageEnded")
    def time_usage_ended(self) -> _builtins.str:
        """
        The end date and time for the usage period.
        """
        return pulumi.get(self, "time_usage_ended")

    @_builtins.property
    @pulumi.getter(name="timeUsageStarted")
    def time_usage_started(self) -> _builtins.str:
        """
        The start date and time for the usage period.
        """
        return pulumi.get(self, "time_usage_started")

    @_builtins.property
    @pulumi.getter(name="usageAmount")
    def usage_amount(self) -> _builtins.float:
        """
        The usage amount for the usage period.
        """
        return pulumi.get(self, "usage_amount")

    @_builtins.property
    @pulumi.getter(name="usagePeriodKey")
    def usage_period_key(self) -> _builtins.str:
        """
        The usage period ID.
        """
        return pulumi.get(self, "usage_period_key")


@pulumi.output_type
class GetSubscriptionRewardsRewardCollectionItemSummaryResult(dict):
    def __init__(__self__, *,
                 currency: _builtins.str,
                 redemption_code: _builtins.str,
                 rewards_rate: _builtins.float,
                 subscription_id: _builtins.str,
                 tenancy_id: _builtins.str,
                 total_rewards_available: _builtins.float):
        """
        :param _builtins.str currency: The currency unit for the reward amount.
        :param _builtins.str redemption_code: The redemption code used in the Billing Center during the reward redemption process.
        :param _builtins.float rewards_rate: The current Rewards percentage in decimal format.
        :param _builtins.str subscription_id: The subscription ID for which rewards information is requested for.
        :param _builtins.str tenancy_id: The OCID of the tenancy.
        :param _builtins.float total_rewards_available: The total number of available rewards for a given subscription ID.
        """
        pulumi.set(__self__, "currency", currency)
        pulumi.set(__self__, "redemption_code", redemption_code)
        pulumi.set(__self__, "rewards_rate", rewards_rate)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        pulumi.set(__self__, "total_rewards_available", total_rewards_available)

    @_builtins.property
    @pulumi.getter
    def currency(self) -> _builtins.str:
        """
        The currency unit for the reward amount.
        """
        return pulumi.get(self, "currency")

    @_builtins.property
    @pulumi.getter(name="redemptionCode")
    def redemption_code(self) -> _builtins.str:
        """
        The redemption code used in the Billing Center during the reward redemption process.
        """
        return pulumi.get(self, "redemption_code")

    @_builtins.property
    @pulumi.getter(name="rewardsRate")
    def rewards_rate(self) -> _builtins.float:
        """
        The current Rewards percentage in decimal format.
        """
        return pulumi.get(self, "rewards_rate")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        """
        The subscription ID for which rewards information is requested for.
        """
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> _builtins.str:
        """
        The OCID of the tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @_builtins.property
    @pulumi.getter(name="totalRewardsAvailable")
    def total_rewards_available(self) -> _builtins.float:
        """
        The total number of available rewards for a given subscription ID.
        """
        return pulumi.get(self, "total_rewards_available")


@pulumi.output_type
class GetUsagelimitsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetUsagelimitsUsageLimitCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetUsagelimitsUsageLimitCollectionItemResult']):
        """
        :param Sequence['GetUsagelimitsUsageLimitCollectionItemArgs'] items: The list of usage limits.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetUsagelimitsUsageLimitCollectionItemResult']:
        """
        The list of usage limits.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetUsagelimitsUsageLimitCollectionItemResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 alert_level: _builtins.float,
                 created_by: _builtins.str,
                 entitlement_id: _builtins.str,
                 id: _builtins.str,
                 limit: _builtins.str,
                 limit_type: _builtins.str,
                 max_hard_limit: _builtins.str,
                 modified_by: _builtins.str,
                 resource_name: _builtins.str,
                 service_name: _builtins.str,
                 sku_part_id: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_modified: _builtins.str,
                 value_type: _builtins.str):
        """
        :param _builtins.str action: The action when usage limit is hit
        :param _builtins.float alert_level: The alert level of the usage limit
        :param _builtins.str created_by: The user who created the limit
        :param _builtins.str entitlement_id: Entitlement ID of the usage limit
        :param _builtins.str id: The usage limit ID
        :param _builtins.str limit_type: Hard or soft limit. Hard limits lead to breaches, soft to alerts.
        :param _builtins.str max_hard_limit: The maximum hard limit set for the usage limit
        :param _builtins.str modified_by: The user who modified the limit
        :param _builtins.str resource_name: The resource for which the limit is defined
        :param _builtins.str service_name: The service for which the limit is defined
        :param _builtins.str sku_part_id: The SKU for which the usage limit is set
        :param _builtins.str state: The usage limit lifecycle state.
        :param _builtins.str time_created: Time when the usage limit was created
        :param _builtins.str time_modified: Time when the usage limit was modified
        :param _builtins.str value_type: The value type of the usage limit
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "alert_level", alert_level)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "entitlement_id", entitlement_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "limit", limit)
        pulumi.set(__self__, "limit_type", limit_type)
        pulumi.set(__self__, "max_hard_limit", max_hard_limit)
        pulumi.set(__self__, "modified_by", modified_by)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "sku_part_id", sku_part_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_modified", time_modified)
        pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action when usage limit is hit
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="alertLevel")
    def alert_level(self) -> _builtins.float:
        """
        The alert level of the usage limit
        """
        return pulumi.get(self, "alert_level")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The user who created the limit
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="entitlementId")
    def entitlement_id(self) -> _builtins.str:
        """
        Entitlement ID of the usage limit
        """
        return pulumi.get(self, "entitlement_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The usage limit ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> _builtins.str:
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="limitType")
    def limit_type(self) -> _builtins.str:
        """
        Hard or soft limit. Hard limits lead to breaches, soft to alerts.
        """
        return pulumi.get(self, "limit_type")

    @_builtins.property
    @pulumi.getter(name="maxHardLimit")
    def max_hard_limit(self) -> _builtins.str:
        """
        The maximum hard limit set for the usage limit
        """
        return pulumi.get(self, "max_hard_limit")

    @_builtins.property
    @pulumi.getter(name="modifiedBy")
    def modified_by(self) -> _builtins.str:
        """
        The user who modified the limit
        """
        return pulumi.get(self, "modified_by")

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> _builtins.str:
        """
        The resource for which the limit is defined
        """
        return pulumi.get(self, "resource_name")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The service for which the limit is defined
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="skuPartId")
    def sku_part_id(self) -> _builtins.str:
        """
        The SKU for which the usage limit is set
        """
        return pulumi.get(self, "sku_part_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The usage limit lifecycle state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time when the usage limit was created
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> _builtins.str:
        """
        Time when the usage limit was modified
        """
        return pulumi.get(self, "time_modified")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        The value type of the usage limit
        """
        return pulumi.get(self, "value_type")


