from ._core import _PRIMAPHIST_2_Release

paper_2016 = """Gütschow, J.; Jeffery, L.; Gieseke, R.; Gebel, R.; Stevens, D.; Krapp, M.; Rocha, M. (2016): The PRIMAP-hist national historical emissions time series, Earth Syst. Sci. Data, 8, 571-603, doi:10.5194/essd-8-571-2016"""
doi_article = "10.5194/essd-8-571-2016"


citation_2_5_1 = """Gütschow, J., Pflüger, M., & Busch, D. (2024). The PRIMAP-hist national historical emissions time series (1750-2022) v2.5.1 (2.5.1) [Data set]. Zenodo. https://doi.org/10.5281/zenodo.10705513"""

_PRIMAPHIST_2_5_1 = _PRIMAPHIST_2_Release(
    name="PRIMAP-hist 2.5.1",
    version="2.5.1",
    published="2024-02-27",
    doi="10.5281/zenodo.10705513",
    citation=citation_2_5_1,
    doi_article=doi_article,
    citation_article=paper_2016,
    files={
        "main": {
            "filename": "Guetschow_et_al_2024-PRIMAP-hist_v2.5.1_final_27-Feb-2024.csv",
            "known_hash": "md5:7de949e90dfc924c3829aa25d32afe1b",
            "note": "The main dataset with numerical extrapolation of all time series to 2022 and three significant digits.",
        }
    },
)

citation_2_5 = """Gütschow, J., & Pflüger, M. (2023). The PRIMAP-hist national historical emissions time series (1750-2022) v2.5 (2.5) [Data set]. Zenodo. https://doi.org/10.5281/zenodo.10006301"""

_PRIMAPHIST_2_5 = _PRIMAPHIST_2_Release(
    name="PRIMAP-hist 2.5",
    version="2.5",
    published="2023-10-15",
    doi="10.5281/zenodo.10006301",
    citation=citation_2_5,
    doi_article=doi_article,
    citation_article=paper_2016,
    files={
        "main": {
            "filename": "Guetschow_et_al_2023b-PRIMAP-hist_v2.5_final_15-Oct-2023.csv",
            "known_hash": "md5:77405ac4eb5e915a7a9bfc25ff84d7c8",
            "note": "The main dataset with numerical extrapolation of all time series to 2022 and three significant digits.",
        }
    },
)

citation_2_4_2 = """Gütschow, J.; Pflüger, M. (2023): The PRIMAP-hist national historical emissions time series v2.4.2 (1750-2021). zenodo. doi:10.5281/zenodo.7727475."""

_PRIMAPHIST_2_4_2 = _PRIMAPHIST_2_Release(
    name="PRIMAP-hist 2.4.2",
    version="2.4.2",
    doi="10.5281/zenodo.7727475",
    published="2023-03-15",
    citation=citation_2_4_2,
    doi_article=doi_article,
    citation_article=paper_2016,
    files={
        "main": {
            "filename": "Guetschow-et-al-2023a-PRIMAP-hist_v2.4.2_final_09-Mar-2023.csv",
            "known_hash": "md5:4cd6ac6cf2cc53c211f7bbf6e951e3f1",
            "note": "The main dataset with numerical extrapolation of all time series to 2021 and three significant digits.",
        }
    },
)

citation_2_4_1 = """Gütschow, J.; Pflüger, M. (2023): The PRIMAP-hist national historical emissions time series v2.4.1 (1750-2021). zenodo. doi:10.5281/zenodo.7585420."""

_PRIMAPHIST_2_4_1 = _PRIMAPHIST_2_Release(
    name="PRIMAP-hist 2.4.1",
    version="2.4.1",
    doi="10.5281/zenodo.7585420",
    published="2023-02-20",
    citation=citation_2_4_1,
    doi_article=doi_article,
    citation_article=paper_2016,
    files={
        "main": {
            "filename": "Guetschow-et-al-2023-PRIMAP-hist_v2.4.1_final_16-Feb-2023.csv",
            "known_hash": "md5:220b45725161685f00ba48032f911b28",
            "note": "The main dataset with numerical extrapolation of all time series to 2021 and three significant digits.",
        }
    },
)


citation_2_4 = """Gütschow, J.; Pflüger, M. (2022): The PRIMAP-hist national historical emissions time series v2.4 (1750-2021). zenodo. doi:10.5281/zenodo.7179775."""

_PRIMAPHIST_2_4 = _PRIMAPHIST_2_Release(
    name="PRIMAP-hist 2.4",
    version="2.4",
    doi="10.5281/zenodo.7179775",
    published="2022-10-17",
    citation=citation_2_4,
    doi_article=doi_article,
    citation_article=paper_2016,
    files={
        "main": {
            "filename": "Guetschow-et-al-2022-PRIMAP-hist_v2.4_11-Oct-2022.csv",
            "known_hash": "md5:502b68fb811fac25af8680e91898c324",
            "note": "The main dataset with numerical extrapolation of all time series to 2021 and three significant digits.",
        }
    },
)

citation_2_3_1 = """Gütschow, J.; Günther, A.; Pflüger, M. (2021): The PRIMAP-hist national historical emissions time series v2.3.1 (1850-2019). zenodo. doi:10.5281/zenodo.5494497."""

_PRIMAPHIST_2_3_1 = _PRIMAPHIST_2_Release(
    name="PRIMAP-hist 2.3.1",
    version="2.3.1",
    doi="10.5281/zenodo.5494497",
    published="2021-09-22",
    citation=citation_2_3_1,
    doi_article=doi_article,
    citation_article=paper_2016,
    files={
        "main": {
            "filename": "Guetschow-et-al-2021-PRIMAP-hist_v2.3.1_20-Sep_2021.csv",
            "known_hash": "md5:f4cb55a55e4d5e5dcfb1513b677ae318",
            "note": "The main dataset with numerical extrapolation of all time series to 2019 and three significant digits.",
        },
        "no_extrap": {
            "filename": "Guetschow-et-al-2021-PRIMAP-hist_v2.3.1_no_extrap_20-Sep_2021.csv",
            "known_hash": "md5:870bf6d47e74f9245d9f9803d7be80ea",
            "note": "Variant without numerical extrapolation of missing values and not including country groups (three significant digits).",
        },
        "no_extrap_no_rounding": {
            "filename": "Guetschow-et-al-2021-PRIMAP-hist_v2.3.1_no_extrap_no_rounding_20-Sep_2021.csv",
            "known_hash": "md5:f0b9afb73aefbf40693d475ea3dcc6ad",
            "note": "Variant without numerical extrapolation of missing values and not including country groups (eleven significant digits).",
        },
    },
)

citation_2_3 = "Gütschow, J.; Günther, A.; Pflüger, M. (2021): The PRIMAP-hist national historical emissions time series v2.3 (1850-2019). zenodo. doi:10.5281/zenodo.5175154."

_PRIMAPHIST_2_3 = _PRIMAPHIST_2_Release(
    name="PRIMAP-hist 2.3",
    version="2.3",
    doi="10.5281/zenodo.5175154",
    published="2021-08-30",
    citation=citation_2_3,
    doi_article=doi_article,
    citation_article=paper_2016,
    files={
        "main": {
            "filename": "Guetschow-et-al-2021-PRIMAP-hist_v2.3_28_Jul_2021.csv",
            "known_hash": "md5:7b29dfb49ca97dcf594bc639767f1e2a",
            "note": "The main dataset with numerical extrapolation of all time series to 2019 and three significant digits.",
        }
    },
)

citation_2_2 = "Gütschow, J.; Günther, A.; Jeffery, L.; Gieseke, R. (2021): The PRIMAP-hist national historical emissions time series v2.2 (1850-2018). zenodo. doi:10.5281/zenodo.4479172."

_PRIMAPHIST_2_2 = _PRIMAPHIST_2_Release(
    name="PRIMAP-hist 2.2",
    version="2.2",
    doi="10.5281/zenodo.4479172",
    published="2021-02-09",
    citation=citation_2_2,
    doi_article=doi_article,
    citation_article=paper_2016,
    files={
        "main": {
            "filename": "PRIMAP-hist_v2.2_19-Jan-2021.csv",
            "known_hash": "md5:a3a8c25f7b784fdb85c89fbff29f5fd3",
            "note": "With numerical extrapolation of all time series to 2018.",
        }
    },
)


PRIMAPHIST = {
    "2.5.1": _PRIMAPHIST_2_5_1,
    "2.5": _PRIMAPHIST_2_5,
    "2.4.2": _PRIMAPHIST_2_4_2,
    "2.4.1": _PRIMAPHIST_2_4_1,
    "2.4": _PRIMAPHIST_2_4,
    "2.3.1": _PRIMAPHIST_2_3_1,
    "2.3": _PRIMAPHIST_2_3,
    "2.2": _PRIMAPHIST_2_2,
}
