"use strict";
// --------------------------------------------------------------------------------
// This file defines context keys that enable certain features that are
// implemented behind a flag in order to preserve backwards compatibility for
// existing apps. When a new app is initialized through `cdk init`, the CLI will
// automatically add enable these features by adding them to the generated
// `cdk.json` file. In the next major release of the CDK, these feature flags
// will be removed and will become the default behavior.
// See https://github.com/aws/aws-cdk-rfcs/blob/master/text/0055-feature-flags.md
// --------------------------------------------------------------------------------
Object.defineProperty(exports, "__esModule", { value: true });
exports.futureFlagDefault = exports.FUTURE_FLAGS = exports.KMS_DEFAULT_KEY_POLICIES = exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = exports.DOCKER_IGNORE_SUPPORT = exports.STACK_RELATIVE_EXPORTS_CONTEXT = exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT = exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = void 0;
/**
 * If this is set, multiple stacks can use the same stack name (e.g. deployed to
 * different environments). This means that the name of the synthesized template
 * file will be based on the construct path and not on the defined `stackName`
 * of the stack.
 *
 * This is a "future flag": the feature is disabled by default for backwards
 * compatibility, but new projects created using `cdk init` will have this
 * enabled through the generated `cdk.json`.
 */
exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = '@aws-cdk/core:enableStackNameDuplicates';
/**
 * IF this is set, `cdk diff` will always exit with 0.
 *
 * Use `cdk diff --fail` to exit with 1 if there's a diff.
 */
exports.ENABLE_DIFF_NO_FAIL_CONTEXT = 'aws-cdk:enableDiffNoFail';
/** @deprecated use `ENABLE_DIFF_NO_FAIL_CONTEXT` */
exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT;
/**
 * Switch to new stack synthesis method which enable CI/CD
 */
exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = '@aws-cdk/core:newStyleStackSynthesis';
/**
 * Name exports based on the construct paths relative to the stack, rather than the global construct path
 *
 * Combined with the stack name this relative construct path is good enough to
 * ensure uniqueness, and makes the export names robust against refactoring
 * the location of the stack in the construct tree (specifically, moving the Stack
 * into a Stage).
 */
exports.STACK_RELATIVE_EXPORTS_CONTEXT = '@aws-cdk/core:stackRelativeExports';
/**
 * DockerImageAsset properly supports `.dockerignore` files by default
 *
 * If this flag is not set, the default behavior for `DockerImageAsset` is to use
 * glob semantics for `.dockerignore` files. If this flag is set, the default behavior
 * is standard Docker ignore semantics.
 *
 * This is a feature flag as the old behavior was technically incorrect but
 * users may have come to depend on it.
 */
exports.DOCKER_IGNORE_SUPPORT = '@aws-cdk/aws-ecr-assets:dockerIgnoreSupport';
/**
 * Secret.secretName for an "owned" secret will attempt to parse the secretName from the ARN,
 * rather than the default full resource name, which includes the SecretsManager suffix.
 *
 * If this flag is not set, Secret.secretName will include the SecretsManager suffix, which cannot be directly
 * used by SecretsManager.DescribeSecret, and must be parsed by the user first (e.g., Fn:Join, Fn:Select, Fn:Split).
 */
exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = '@aws-cdk/aws-secretsmanager:parseOwnedSecretName';
/**
 * KMS Keys start with a default key policy that grants the account access to administer the key,
 * mirroring the behavior of the KMS SDK/CLI/Console experience. Users may override the default key
 * policy by specifying their own.
 *
 * If this flag is not set, the default key policy depends on the setting of the `trustAccountIdentities`
 * flag. If false (the default, for backwards-compatibility reasons), the default key policy somewhat
 * resemebles the default admin key policy, but with the addition of 'GenerateDataKey' permissions. If
 * true, the policy matches what happens when this feature flag is set.
 *
 * Additionally, if this flag is not set and the user supplies a custom key policy, this will be appended
 * to the key's default policy (rather than replacing it).
 */
exports.KMS_DEFAULT_KEY_POLICIES = '@aws-cdk/aws-kms:defaultKeyPolicies';
/**
 * This map includes context keys and values for feature flags that enable
 * capabilities "from the future", which we could not introduce as the default
 * behavior due to backwards compatibility for existing projects.
 *
 * New projects generated through `cdk init` will include these flags in their
 * generated `cdk.json` file.
 *
 * When we release the next major version of the CDK, we will flip the logic of
 * these features and clean up the `cdk.json` generated by `cdk init`.
 *
 * Tests must cover the default (disabled) case and the future (enabled) case.
 */
exports.FUTURE_FLAGS = {
    [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: 'true',
    [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: 'true',
    [exports.STACK_RELATIVE_EXPORTS_CONTEXT]: 'true',
    [exports.DOCKER_IGNORE_SUPPORT]: true,
    [exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME]: true,
    [exports.KMS_DEFAULT_KEY_POLICIES]: true,
};
/**
 * The set of defaults that should be applied if the feature flag is not
 * explicitly configured.
 */
const FUTURE_FLAGS_DEFAULTS = {
    [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: false,
    [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: false,
    [exports.STACK_RELATIVE_EXPORTS_CONTEXT]: false,
    [exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT]: false,
    [exports.DOCKER_IGNORE_SUPPORT]: false,
    [exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME]: false,
    [exports.KMS_DEFAULT_KEY_POLICIES]: false,
};
function futureFlagDefault(flag) {
    return FUTURE_FLAGS_DEFAULTS[flag];
}
exports.futureFlagDefault = futureFlagDefault;
//# sourceMappingURL=data:application/json;base64,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