import * as cxschema from '@aws-cdk/cloud-assembly-schema';
/**
 * The key used when CDK path is embedded in **CloudFormation template** metadata (not cdk metadata).
 */
export declare const PATH_METADATA_KEY = "aws:cdk:path";
/**
 * @experimental
 */
export declare enum SynthesisMessageLevel {
    /**
     * @experimental
     */
    INFO = "info",
    /**
     * @experimental
     */
    WARNING = "warning",
    /**
     * @experimental
     */
    ERROR = "error"
}
/**
 * @experimental
 */
export interface MetadataEntryResult extends cxschema.MetadataEntry {
    /**
     * (experimental) The path in which this entry was defined.
     *
     * @experimental
     */
    readonly path: string;
}
/**
 * Metadata associated with the objects in the stack's Construct tree
 */
export declare type StackMetadata = {
    [path: string]: cxschema.MetadataEntry[];
};
/**
 * @experimental
 */
export interface SynthesisMessage {
    /**
     * @experimental
     */
    readonly level: SynthesisMessageLevel;
    /**
     * @experimental
     */
    readonly id: string;
    /**
     * @experimental
     */
    readonly entry: cxschema.MetadataEntry;
}
