/**
 * (experimental) Placeholders which can be used manifests.
 *
 * These can occur both in the Asset Manifest as well as the general
 * Cloud Assembly manifest.
 *
 * @experimental
 */
export declare class EnvironmentPlaceholders {
    /**
     * (experimental) Insert this into the destination fields to be replaced with the current region.
     *
     * @experimental
     */
    static readonly CURRENT_REGION = "${AWS::Region}";
    /**
     * (experimental) Insert this into the destination fields to be replaced with the current account.
     *
     * @experimental
     */
    static readonly CURRENT_ACCOUNT = "${AWS::AccountId}";
    /**
     * (experimental) Insert this into the destination fields to be replaced with the current partition.
     *
     * @experimental
     */
    static readonly CURRENT_PARTITION = "${AWS::Partition}";
    /**
     * (experimental) Replace the environment placeholders in all strings found in a complex object.
     *
     * Duplicated between cdk-assets and aws-cdk CLI because we don't have a good single place to put it
     * (they're nominally independent tools).
     *
     * @experimental
     */
    static replace(object: any, values: EnvironmentPlaceholderValues): any;
    /**
     * (experimental) Like 'replace', but asynchronous.
     *
     * @experimental
     */
    static replaceAsync(object: any, provider: IEnvironmentPlaceholderProvider): Promise<any>;
    private static recurse;
}
/**
 * (experimental) Return the appropriate values for the environment placeholders.
 *
 * @experimental
 */
export interface EnvironmentPlaceholderValues {
    /**
     * (experimental) Return the region.
     *
     * @experimental
     */
    readonly region: string;
    /**
     * (experimental) Return the account.
     *
     * @experimental
     */
    readonly accountId: string;
    /**
     * (experimental) Return the partition.
     *
     * @experimental
     */
    readonly partition: string;
}
/**
 * (experimental) Return the appropriate values for the environment placeholders.
 *
 * @experimental
 */
export interface IEnvironmentPlaceholderProvider {
    /**
     * (experimental) Return the region.
     *
     * @experimental
     */
    region(): Promise<string>;
    /**
     * (experimental) Return the account.
     *
     * @experimental
     */
    accountId(): Promise<string>;
    /**
     * (experimental) Return the partition.
     *
     * @experimental
     */
    partition(): Promise<string>;
}
