"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AWS_SERVICES = exports.AWS_REGIONS = void 0;
/**
 * The names of all (known) AWS regions
 *
 * Not in the list ==> no built-in data for that region.
 */
exports.AWS_REGIONS = [
    'us-east-2',
    'us-east-1',
    'us-west-1',
    'us-west-2',
    'us-gov-east-1',
    'us-gov-west-1',
    'us-iso-east-1',
    'us-isob-east-1',
    'af-south-1',
    'ap-east-1',
    'ap-south-1',
    'ap-northeast-2',
    'ap-southeast-1',
    'ap-southeast-2',
    'ap-northeast-1',
    'ca-central-1',
    'cn-north-1',
    'cn-northwest-1',
    'eu-central-1',
    'eu-west-1',
    'eu-west-2',
    'eu-west-3',
    'eu-north-1',
    'eu-south-1',
    'me-south-1',
    'sa-east-1',
].sort();
/**
 * Possibly non-exaustive list of all service names, used to locate service principals.
 *
 * Not in the list ==> default service principal mappings.
 */
exports.AWS_SERVICES = [
    'application-autoscaling',
    'autoscaling',
    'codedeploy',
    'ec2',
    'events',
    'lambda',
    'logs',
    's3',
    'sns',
    'sqs',
    'states',
].sort();
//# sourceMappingURL=data:application/json;base64,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