"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnUtilsProvider = void 0;
const construct_compat_1 = require("../construct-compat");
const custom_resource_provider_1 = require("../custom-resource-provider");
/**
 * A custom resource provider for CFN utilities such as `CfnJson`.
 */
class CfnUtilsProvider extends construct_compat_1.Construct {
    static getOrCreate(scope) {
        return custom_resource_provider_1.CustomResourceProvider.getOrCreate(scope, 'AWSCDKCfnUtilsProvider', {
            runtime: custom_resource_provider_1.CustomResourceProviderRuntime.NODEJS_12,
            codeDirectory: `${__dirname}/cfn-utils-provider`,
        });
    }
}
exports.CfnUtilsProvider = CfnUtilsProvider;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2ZuLXV0aWxzLXByb3ZpZGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY2ZuLXV0aWxzLXByb3ZpZGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDBEQUFnRDtBQUNoRCwwRUFBb0c7QUFFcEc7O0dBRUc7QUFDSCxNQUFhLGdCQUFpQixTQUFRLDRCQUFTO0lBQ3RDLE1BQU0sQ0FBQyxXQUFXLENBQUMsS0FBZ0I7UUFDeEMsT0FBTyxpREFBc0IsQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLHdCQUF3QixFQUFFO1lBQ3pFLE9BQU8sRUFBRSx3REFBNkIsQ0FBQyxTQUFTO1lBQ2hELGFBQWEsRUFBRSxHQUFHLFNBQVMscUJBQXFCO1NBQ2pELENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjtBQVBELDRDQU9DIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnLi4vY29uc3RydWN0LWNvbXBhdCc7XG5pbXBvcnQgeyBDdXN0b21SZXNvdXJjZVByb3ZpZGVyLCBDdXN0b21SZXNvdXJjZVByb3ZpZGVyUnVudGltZSB9IGZyb20gJy4uL2N1c3RvbS1yZXNvdXJjZS1wcm92aWRlcic7XG5cbi8qKlxuICogQSBjdXN0b20gcmVzb3VyY2UgcHJvdmlkZXIgZm9yIENGTiB1dGlsaXRpZXMgc3VjaCBhcyBgQ2ZuSnNvbmAuXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5VdGlsc1Byb3ZpZGVyIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHN0YXRpYyBnZXRPckNyZWF0ZShzY29wZTogQ29uc3RydWN0KSB7XG4gICAgcmV0dXJuIEN1c3RvbVJlc291cmNlUHJvdmlkZXIuZ2V0T3JDcmVhdGUoc2NvcGUsICdBV1NDREtDZm5VdGlsc1Byb3ZpZGVyJywge1xuICAgICAgcnVudGltZTogQ3VzdG9tUmVzb3VyY2VQcm92aWRlclJ1bnRpbWUuTk9ERUpTXzEyLFxuICAgICAgY29kZURpcmVjdG9yeTogYCR7X19kaXJuYW1lfS9jZm4tdXRpbHMtcHJvdmlkZXJgLFxuICAgIH0pO1xuICB9XG59Il19