"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetManifestArtifact = void 0;
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
/**
 * (experimental) Asset manifest is a description of a set of assets which need to be built and published.
 *
 * @experimental
 */
class AssetManifestArtifact extends cloud_artifact_1.CloudArtifact {
    /**
     * @experimental
     */
    constructor(assembly, name, artifact) {
        var _a;
        super(assembly, name, artifact);
        const properties = (this.manifest.properties || {});
        if (!properties.file) {
            throw new Error('Invalid AssetManifestArtifact. Missing "file" property');
        }
        this.file = path.resolve(this.assembly.directory, properties.file);
        this.requiresBootstrapStackVersion = (_a = properties.requiresBootstrapStackVersion) !== null && _a !== void 0 ? _a : 1;
    }
}
exports.AssetManifestArtifact = AssetManifestArtifact;
//# sourceMappingURL=data:application/json;base64,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